# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .target_details import TargetDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VmClusterTargetSummary(TargetDetails):
    """
    Details of a VmCluster target member of a Exadata Fleet Update Collection.
    Stored references of the resource documented in
    https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/VmCluster/
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VmClusterTargetSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.VmClusterTargetSummary.entity_type` attribute
        of this class is ``VMCLUSTER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param entity_type:
            The value to assign to the entity_type property of this VmClusterTargetSummary.
            Allowed values for this property are: "DATABASE", "VMCLUSTER", "CLOUDVMCLUSTER"
        :type entity_type: str

        :param id:
            The value to assign to the id property of this VmClusterTargetSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this VmClusterTargetSummary.
        :type compartment_id: str

        :param infrastructure_id:
            The value to assign to the infrastructure_id property of this VmClusterTargetSummary.
        :type infrastructure_id: str

        """
        self.swagger_types = {
            'entity_type': 'str',
            'id': 'str',
            'compartment_id': 'str',
            'infrastructure_id': 'str'
        }

        self.attribute_map = {
            'entity_type': 'entityType',
            'id': 'id',
            'compartment_id': 'compartmentId',
            'infrastructure_id': 'infrastructureId'
        }

        self._entity_type = None
        self._id = None
        self._compartment_id = None
        self._infrastructure_id = None
        self._entity_type = 'VMCLUSTER'

    @property
    def infrastructure_id(self):
        """
        Gets the infrastructure_id of this VmClusterTargetSummary.
        OCID of the related Exadata Infrastructure or Cloud Exadata Infrastructure resource.


        :return: The infrastructure_id of this VmClusterTargetSummary.
        :rtype: str
        """
        return self._infrastructure_id

    @infrastructure_id.setter
    def infrastructure_id(self, infrastructure_id):
        """
        Sets the infrastructure_id of this VmClusterTargetSummary.
        OCID of the related Exadata Infrastructure or Cloud Exadata Infrastructure resource.


        :param infrastructure_id: The infrastructure_id of this VmClusterTargetSummary.
        :type: str
        """
        self._infrastructure_id = infrastructure_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
