# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ServingMode(object):
    """
    The model's serving mode, which is either on-demand serving or dedicated serving.
    """

    #: A constant which can be used with the serving_type property of a ServingMode.
    #: This constant has a value of "ON_DEMAND"
    SERVING_TYPE_ON_DEMAND = "ON_DEMAND"

    #: A constant which can be used with the serving_type property of a ServingMode.
    #: This constant has a value of "DEDICATED"
    SERVING_TYPE_DEDICATED = "DEDICATED"

    def __init__(self, **kwargs):
        """
        Initializes a new ServingMode object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.generative_ai_inference.models.DedicatedServingMode`
        * :class:`~oci.generative_ai_inference.models.OnDemandServingMode`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param serving_type:
            The value to assign to the serving_type property of this ServingMode.
            Allowed values for this property are: "ON_DEMAND", "DEDICATED"
        :type serving_type: str

        """
        self.swagger_types = {
            'serving_type': 'str'
        }

        self.attribute_map = {
            'serving_type': 'servingType'
        }

        self._serving_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['servingType']

        if type == 'DEDICATED':
            return 'DedicatedServingMode'

        if type == 'ON_DEMAND':
            return 'OnDemandServingMode'
        else:
            return 'ServingMode'

    @property
    def serving_type(self):
        """
        **[Required]** Gets the serving_type of this ServingMode.
        The serving mode type, which is either on-demand serving or dedicated serving.

        Allowed values for this property are: "ON_DEMAND", "DEDICATED"


        :return: The serving_type of this ServingMode.
        :rtype: str
        """
        return self._serving_type

    @serving_type.setter
    def serving_type(self, serving_type):
        """
        Sets the serving_type of this ServingMode.
        The serving mode type, which is either on-demand serving or dedicated serving.


        :param serving_type: The serving_type of this ServingMode.
        :type: str
        """
        allowed_values = ["ON_DEMAND", "DEDICATED"]
        if not value_allowed_none_or_none_sentinel(serving_type, allowed_values):
            raise ValueError(
                f"Invalid value for `serving_type`, must be None or one of {allowed_values}"
            )
        self._serving_type = serving_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
