# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppExtensionOpcServiceApp(object):
    """
    This extension defines attributes specific to Apps that represent instances of an Oracle Public Cloud (OPC) service.
    """

    #: A constant which can be used with the current_federation_mode property of a AppExtensionOpcServiceApp.
    #: This constant has a value of "None"
    CURRENT_FEDERATION_MODE_NONE = "None"

    #: A constant which can be used with the current_federation_mode property of a AppExtensionOpcServiceApp.
    #: This constant has a value of "AppAsServiceProvider"
    CURRENT_FEDERATION_MODE_APP_AS_SERVICE_PROVIDER = "AppAsServiceProvider"

    #: A constant which can be used with the current_federation_mode property of a AppExtensionOpcServiceApp.
    #: This constant has a value of "AppAsIdentityProvider"
    CURRENT_FEDERATION_MODE_APP_AS_IDENTITY_PROVIDER = "AppAsIdentityProvider"

    #: A constant which can be used with the current_synchronization_mode property of a AppExtensionOpcServiceApp.
    #: This constant has a value of "None"
    CURRENT_SYNCHRONIZATION_MODE_NONE = "None"

    #: A constant which can be used with the current_synchronization_mode property of a AppExtensionOpcServiceApp.
    #: This constant has a value of "AppAsTarget"
    CURRENT_SYNCHRONIZATION_MODE_APP_AS_TARGET = "AppAsTarget"

    #: A constant which can be used with the current_synchronization_mode property of a AppExtensionOpcServiceApp.
    #: This constant has a value of "AppAsSource"
    CURRENT_SYNCHRONIZATION_MODE_APP_AS_SOURCE = "AppAsSource"

    #: A constant which can be used with the next_federation_mode property of a AppExtensionOpcServiceApp.
    #: This constant has a value of "None"
    NEXT_FEDERATION_MODE_NONE = "None"

    #: A constant which can be used with the next_federation_mode property of a AppExtensionOpcServiceApp.
    #: This constant has a value of "AppAsServiceProvider"
    NEXT_FEDERATION_MODE_APP_AS_SERVICE_PROVIDER = "AppAsServiceProvider"

    #: A constant which can be used with the next_federation_mode property of a AppExtensionOpcServiceApp.
    #: This constant has a value of "AppAsIdentityProvider"
    NEXT_FEDERATION_MODE_APP_AS_IDENTITY_PROVIDER = "AppAsIdentityProvider"

    #: A constant which can be used with the next_synchronization_mode property of a AppExtensionOpcServiceApp.
    #: This constant has a value of "None"
    NEXT_SYNCHRONIZATION_MODE_NONE = "None"

    #: A constant which can be used with the next_synchronization_mode property of a AppExtensionOpcServiceApp.
    #: This constant has a value of "AppAsTarget"
    NEXT_SYNCHRONIZATION_MODE_APP_AS_TARGET = "AppAsTarget"

    #: A constant which can be used with the next_synchronization_mode property of a AppExtensionOpcServiceApp.
    #: This constant has a value of "AppAsSource"
    NEXT_SYNCHRONIZATION_MODE_APP_AS_SOURCE = "AppAsSource"

    def __init__(self, **kwargs):
        """
        Initializes a new AppExtensionOpcServiceApp object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param service_instance_identifier:
            The value to assign to the service_instance_identifier property of this AppExtensionOpcServiceApp.
        :type service_instance_identifier: str

        :param region:
            The value to assign to the region property of this AppExtensionOpcServiceApp.
        :type region: str

        :param current_federation_mode:
            The value to assign to the current_federation_mode property of this AppExtensionOpcServiceApp.
            Allowed values for this property are: "None", "AppAsServiceProvider", "AppAsIdentityProvider", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type current_federation_mode: str

        :param current_synchronization_mode:
            The value to assign to the current_synchronization_mode property of this AppExtensionOpcServiceApp.
            Allowed values for this property are: "None", "AppAsTarget", "AppAsSource", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type current_synchronization_mode: str

        :param next_federation_mode:
            The value to assign to the next_federation_mode property of this AppExtensionOpcServiceApp.
            Allowed values for this property are: "None", "AppAsServiceProvider", "AppAsIdentityProvider", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type next_federation_mode: str

        :param next_synchronization_mode:
            The value to assign to the next_synchronization_mode property of this AppExtensionOpcServiceApp.
            Allowed values for this property are: "None", "AppAsTarget", "AppAsSource", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type next_synchronization_mode: str

        :param enabling_next_fed_sync_modes:
            The value to assign to the enabling_next_fed_sync_modes property of this AppExtensionOpcServiceApp.
        :type enabling_next_fed_sync_modes: bool

        """
        self.swagger_types = {
            'service_instance_identifier': 'str',
            'region': 'str',
            'current_federation_mode': 'str',
            'current_synchronization_mode': 'str',
            'next_federation_mode': 'str',
            'next_synchronization_mode': 'str',
            'enabling_next_fed_sync_modes': 'bool'
        }

        self.attribute_map = {
            'service_instance_identifier': 'serviceInstanceIdentifier',
            'region': 'region',
            'current_federation_mode': 'currentFederationMode',
            'current_synchronization_mode': 'currentSynchronizationMode',
            'next_federation_mode': 'nextFederationMode',
            'next_synchronization_mode': 'nextSynchronizationMode',
            'enabling_next_fed_sync_modes': 'enablingNextFedSyncModes'
        }

        self._service_instance_identifier = None
        self._region = None
        self._current_federation_mode = None
        self._current_synchronization_mode = None
        self._next_federation_mode = None
        self._next_synchronization_mode = None
        self._enabling_next_fed_sync_modes = None

    @property
    def service_instance_identifier(self):
        """
        Gets the service_instance_identifier of this AppExtensionOpcServiceApp.
        This value specifies the unique identifier assigned to an instance of an Oracle Public Cloud service app.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: server


        :return: The service_instance_identifier of this AppExtensionOpcServiceApp.
        :rtype: str
        """
        return self._service_instance_identifier

    @service_instance_identifier.setter
    def service_instance_identifier(self, service_instance_identifier):
        """
        Sets the service_instance_identifier of this AppExtensionOpcServiceApp.
        This value specifies the unique identifier assigned to an instance of an Oracle Public Cloud service app.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: server


        :param service_instance_identifier: The service_instance_identifier of this AppExtensionOpcServiceApp.
        :type: str
        """
        self._service_instance_identifier = service_instance_identifier

    @property
    def region(self):
        """
        Gets the region of this AppExtensionOpcServiceApp.
        This value identifies the OPC region in which the service is running.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The region of this AppExtensionOpcServiceApp.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this AppExtensionOpcServiceApp.
        This value identifies the OPC region in which the service is running.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param region: The region of this AppExtensionOpcServiceApp.
        :type: str
        """
        self._region = region

    @property
    def current_federation_mode(self):
        """
        Gets the current_federation_mode of this AppExtensionOpcServiceApp.
        Current Federation Mode

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string

        Allowed values for this property are: "None", "AppAsServiceProvider", "AppAsIdentityProvider", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The current_federation_mode of this AppExtensionOpcServiceApp.
        :rtype: str
        """
        return self._current_federation_mode

    @current_federation_mode.setter
    def current_federation_mode(self, current_federation_mode):
        """
        Sets the current_federation_mode of this AppExtensionOpcServiceApp.
        Current Federation Mode

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string


        :param current_federation_mode: The current_federation_mode of this AppExtensionOpcServiceApp.
        :type: str
        """
        allowed_values = ["None", "AppAsServiceProvider", "AppAsIdentityProvider"]
        if not value_allowed_none_or_none_sentinel(current_federation_mode, allowed_values):
            current_federation_mode = 'UNKNOWN_ENUM_VALUE'
        self._current_federation_mode = current_federation_mode

    @property
    def current_synchronization_mode(self):
        """
        Gets the current_synchronization_mode of this AppExtensionOpcServiceApp.
        Current Synchronization Mode

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string

        Allowed values for this property are: "None", "AppAsTarget", "AppAsSource", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The current_synchronization_mode of this AppExtensionOpcServiceApp.
        :rtype: str
        """
        return self._current_synchronization_mode

    @current_synchronization_mode.setter
    def current_synchronization_mode(self, current_synchronization_mode):
        """
        Sets the current_synchronization_mode of this AppExtensionOpcServiceApp.
        Current Synchronization Mode

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string


        :param current_synchronization_mode: The current_synchronization_mode of this AppExtensionOpcServiceApp.
        :type: str
        """
        allowed_values = ["None", "AppAsTarget", "AppAsSource"]
        if not value_allowed_none_or_none_sentinel(current_synchronization_mode, allowed_values):
            current_synchronization_mode = 'UNKNOWN_ENUM_VALUE'
        self._current_synchronization_mode = current_synchronization_mode

    @property
    def next_federation_mode(self):
        """
        Gets the next_federation_mode of this AppExtensionOpcServiceApp.
        Next Federation Mode

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string

        Allowed values for this property are: "None", "AppAsServiceProvider", "AppAsIdentityProvider", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The next_federation_mode of this AppExtensionOpcServiceApp.
        :rtype: str
        """
        return self._next_federation_mode

    @next_federation_mode.setter
    def next_federation_mode(self, next_federation_mode):
        """
        Sets the next_federation_mode of this AppExtensionOpcServiceApp.
        Next Federation Mode

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string


        :param next_federation_mode: The next_federation_mode of this AppExtensionOpcServiceApp.
        :type: str
        """
        allowed_values = ["None", "AppAsServiceProvider", "AppAsIdentityProvider"]
        if not value_allowed_none_or_none_sentinel(next_federation_mode, allowed_values):
            next_federation_mode = 'UNKNOWN_ENUM_VALUE'
        self._next_federation_mode = next_federation_mode

    @property
    def next_synchronization_mode(self):
        """
        Gets the next_synchronization_mode of this AppExtensionOpcServiceApp.
        Next Synchronization Mode

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string

        Allowed values for this property are: "None", "AppAsTarget", "AppAsSource", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The next_synchronization_mode of this AppExtensionOpcServiceApp.
        :rtype: str
        """
        return self._next_synchronization_mode

    @next_synchronization_mode.setter
    def next_synchronization_mode(self, next_synchronization_mode):
        """
        Sets the next_synchronization_mode of this AppExtensionOpcServiceApp.
        Next Synchronization Mode

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string


        :param next_synchronization_mode: The next_synchronization_mode of this AppExtensionOpcServiceApp.
        :type: str
        """
        allowed_values = ["None", "AppAsTarget", "AppAsSource"]
        if not value_allowed_none_or_none_sentinel(next_synchronization_mode, allowed_values):
            next_synchronization_mode = 'UNKNOWN_ENUM_VALUE'
        self._next_synchronization_mode = next_synchronization_mode

    @property
    def enabling_next_fed_sync_modes(self):
        """
        Gets the enabling_next_fed_sync_modes of this AppExtensionOpcServiceApp.
        If true, indicates that enablement is in progress started but not completed

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: boolean


        :return: The enabling_next_fed_sync_modes of this AppExtensionOpcServiceApp.
        :rtype: bool
        """
        return self._enabling_next_fed_sync_modes

    @enabling_next_fed_sync_modes.setter
    def enabling_next_fed_sync_modes(self, enabling_next_fed_sync_modes):
        """
        Sets the enabling_next_fed_sync_modes of this AppExtensionOpcServiceApp.
        If true, indicates that enablement is in progress started but not completed

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: boolean


        :param enabling_next_fed_sync_modes: The enabling_next_fed_sync_modes of this AppExtensionOpcServiceApp.
        :type: bool
        """
        self._enabling_next_fed_sync_modes = enabling_next_fed_sync_modes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
