# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApprovalWorkflowMaxDuration(object):
    """
    Max duration of the ApprovalWorkflow must be acted at all levels.

    **SCIM++ Properties:**
    - caseExact: true
    - idcsSearchable: false
    - multiValued: false
    - mutability: readWrite
    - required: true
    - returned: default
    - type: complex
    - uniqueness: none
    """

    #: A constant which can be used with the unit property of a ApprovalWorkflowMaxDuration.
    #: This constant has a value of "MONTH"
    UNIT_MONTH = "MONTH"

    #: A constant which can be used with the unit property of a ApprovalWorkflowMaxDuration.
    #: This constant has a value of "WEEK"
    UNIT_WEEK = "WEEK"

    #: A constant which can be used with the unit property of a ApprovalWorkflowMaxDuration.
    #: This constant has a value of "DAY"
    UNIT_DAY = "DAY"

    #: A constant which can be used with the unit property of a ApprovalWorkflowMaxDuration.
    #: This constant has a value of "HOUR"
    UNIT_HOUR = "HOUR"

    def __init__(self, **kwargs):
        """
        Initializes a new ApprovalWorkflowMaxDuration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this ApprovalWorkflowMaxDuration.
        :type value: int

        :param unit:
            The value to assign to the unit property of this ApprovalWorkflowMaxDuration.
            Allowed values for this property are: "MONTH", "WEEK", "DAY", "HOUR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type unit: str

        """
        self.swagger_types = {
            'value': 'int',
            'unit': 'str'
        }

        self.attribute_map = {
            'value': 'value',
            'unit': 'unit'
        }

        self._value = None
        self._unit = None

    @property
    def value(self):
        """
        **[Required]** Gets the value of this ApprovalWorkflowMaxDuration.
        The value of the max duration.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - idcsMaxValue: 1488
         - idcsMinValue: 1
         - idcsDefaultValue: 14
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The value of this ApprovalWorkflowMaxDuration.
        :rtype: int
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this ApprovalWorkflowMaxDuration.
        The value of the max duration.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - idcsMaxValue: 1488
         - idcsMinValue: 1
         - idcsDefaultValue: 14
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: integer
         - uniqueness: none


        :param value: The value of this ApprovalWorkflowMaxDuration.
        :type: int
        """
        self._value = value

    @property
    def unit(self):
        """
        **[Required]** Gets the unit of this ApprovalWorkflowMaxDuration.
        The unit of the max duration.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - idcsDefaultValue: DAY
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "MONTH", "WEEK", "DAY", "HOUR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The unit of this ApprovalWorkflowMaxDuration.
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """
        Sets the unit of this ApprovalWorkflowMaxDuration.
        The unit of the max duration.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - idcsDefaultValue: DAY
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param unit: The unit of this ApprovalWorkflowMaxDuration.
        :type: str
        """
        allowed_values = ["MONTH", "WEEK", "DAY", "HOUR"]
        if not value_allowed_none_or_none_sentinel(unit, allowed_values):
            unit = 'UNKNOWN_ENUM_VALUE'
        self._unit = unit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
