# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: release


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PortInformation(object):
    """
    The details of the port.
    """

    #: A constant which can be used with the port_type property of a PortInformation.
    #: This constant has a value of "CLIENTUTILITY"
    PORT_TYPE_CLIENTUTILITY = "CLIENTUTILITY"

    #: A constant which can be used with the port_type property of a PortInformation.
    #: This constant has a value of "MANAGEMENTUTILITY"
    PORT_TYPE_MANAGEMENTUTILITY = "MANAGEMENTUTILITY"

    def __init__(self, **kwargs):
        """
        Initializes a new PortInformation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param port_number:
            The value to assign to the port_number property of this PortInformation.
        :type port_number: int

        :param port_type:
            The value to assign to the port_type property of this PortInformation.
            Allowed values for this property are: "CLIENTUTILITY", "MANAGEMENTUTILITY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type port_type: str

        """
        self.swagger_types = {
            'port_number': 'int',
            'port_type': 'str'
        }

        self.attribute_map = {
            'port_number': 'portNumber',
            'port_type': 'portType'
        }

        self._port_number = None
        self._port_type = None

    @property
    def port_number(self):
        """
        **[Required]** Gets the port_number of this PortInformation.
        The port number of the cavium server.


        :return: The port_number of this PortInformation.
        :rtype: int
        """
        return self._port_number

    @port_number.setter
    def port_number(self, port_number):
        """
        Sets the port_number of this PortInformation.
        The port number of the cavium server.


        :param port_number: The port_number of this PortInformation.
        :type: int
        """
        self._port_number = port_number

    @property
    def port_type(self):
        """
        **[Required]** Gets the port_type of this PortInformation.
        Port type associated for the port number.

        Allowed values for this property are: "CLIENTUTILITY", "MANAGEMENTUTILITY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The port_type of this PortInformation.
        :rtype: str
        """
        return self._port_type

    @port_type.setter
    def port_type(self, port_type):
        """
        Sets the port_type of this PortInformation.
        Port type associated for the port number.


        :param port_type: The port_type of this PortInformation.
        :type: str
        """
        allowed_values = ["CLIENTUTILITY", "MANAGEMENTUTILITY"]
        if not value_allowed_none_or_none_sentinel(port_type, allowed_values):
            port_type = 'UNKNOWN_ENUM_VALUE'
        self._port_type = port_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
