# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200531

from .unified_agent_logging_source import UnifiedAgentLoggingSource
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UnifiedAgentCustomPluginLogSource(UnifiedAgentLoggingSource):
    """
    User-customized-source-plugin log source object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UnifiedAgentCustomPluginLogSource object with values from keyword arguments. The default value of the :py:attr:`~oci.logging.models.UnifiedAgentCustomPluginLogSource.source_type` attribute
        of this class is ``CUSTOM_PLUGIN`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this UnifiedAgentCustomPluginLogSource.
        :type name: str

        :param source_type:
            The value to assign to the source_type property of this UnifiedAgentCustomPluginLogSource.
            Allowed values for this property are: "LOG_TAIL", "WINDOWS_EVENT_LOG", "CUSTOM_PLUGIN"
        :type source_type: str

        :param custom_plugin:
            The value to assign to the custom_plugin property of this UnifiedAgentCustomPluginLogSource.
        :type custom_plugin: str

        """
        self.swagger_types = {
            'name': 'str',
            'source_type': 'str',
            'custom_plugin': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'source_type': 'sourceType',
            'custom_plugin': 'customPlugin'
        }

        self._name = None
        self._source_type = None
        self._custom_plugin = None
        self._source_type = 'CUSTOM_PLUGIN'

    @property
    def custom_plugin(self):
        """
        **[Required]** Gets the custom_plugin of this UnifiedAgentCustomPluginLogSource.
        User customized source plugin.


        :return: The custom_plugin of this UnifiedAgentCustomPluginLogSource.
        :rtype: str
        """
        return self._custom_plugin

    @custom_plugin.setter
    def custom_plugin(self, custom_plugin):
        """
        Sets the custom_plugin of this UnifiedAgentCustomPluginLogSource.
        User customized source plugin.


        :param custom_plugin: The custom_plugin of this UnifiedAgentCustomPluginLogSource.
        :type: str
        """
        self._custom_plugin = custom_plugin

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
