# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OfferInternalDetail(object):
    """
    the internal details of an offer that are only visible to the seller
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OfferInternalDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param custom_fields:
            The value to assign to the custom_fields property of this OfferInternalDetail.
        :type custom_fields: list[oci.marketplace_publisher.models.CustomField]

        :param internal_notes:
            The value to assign to the internal_notes property of this OfferInternalDetail.
        :type internal_notes: str

        """
        self.swagger_types = {
            'custom_fields': 'list[CustomField]',
            'internal_notes': 'str'
        }

        self.attribute_map = {
            'custom_fields': 'customFields',
            'internal_notes': 'internalNotes'
        }

        self._custom_fields = None
        self._internal_notes = None

    @property
    def custom_fields(self):
        """
        **[Required]** Gets the custom_fields of this OfferInternalDetail.
        A list of key value pairs specified by the seller


        :return: The custom_fields of this OfferInternalDetail.
        :rtype: list[oci.marketplace_publisher.models.CustomField]
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """
        Sets the custom_fields of this OfferInternalDetail.
        A list of key value pairs specified by the seller


        :param custom_fields: The custom_fields of this OfferInternalDetail.
        :type: list[oci.marketplace_publisher.models.CustomField]
        """
        self._custom_fields = custom_fields

    @property
    def internal_notes(self):
        """
        **[Required]** Gets the internal_notes of this OfferInternalDetail.
        Internal notes only intended for the Publisher of the Offer


        :return: The internal_notes of this OfferInternalDetail.
        :rtype: str
        """
        return self._internal_notes

    @internal_notes.setter
    def internal_notes(self, internal_notes):
        """
        Sets the internal_notes of this OfferInternalDetail.
        Internal notes only intended for the Publisher of the Offer


        :param internal_notes: The internal_notes of this OfferInternalDetail.
        :type: str
        """
        self._internal_notes = internal_notes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
