# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UrlList(object):
    """
    URL pattern lists of the policy.
    The value of an entry is a list of URL patterns.
    The associated key/name is the identifier by which the URL pattern list is referenced.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UrlList object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this UrlList.
        :type name: str

        :param urls:
            The value to assign to the urls property of this UrlList.
        :type urls: list[oci.network_firewall.models.UrlPattern]

        :param total_urls:
            The value to assign to the total_urls property of this UrlList.
        :type total_urls: int

        :param parent_resource_id:
            The value to assign to the parent_resource_id property of this UrlList.
        :type parent_resource_id: str

        """
        self.swagger_types = {
            'name': 'str',
            'urls': 'list[UrlPattern]',
            'total_urls': 'int',
            'parent_resource_id': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'urls': 'urls',
            'total_urls': 'totalUrls',
            'parent_resource_id': 'parentResourceId'
        }

        self._name = None
        self._urls = None
        self._total_urls = None
        self._parent_resource_id = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this UrlList.
        Unique name identifier for the URL list.


        :return: The name of this UrlList.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UrlList.
        Unique name identifier for the URL list.


        :param name: The name of this UrlList.
        :type: str
        """
        self._name = name

    @property
    def urls(self):
        """
        **[Required]** Gets the urls of this UrlList.
        List of urls.


        :return: The urls of this UrlList.
        :rtype: list[oci.network_firewall.models.UrlPattern]
        """
        return self._urls

    @urls.setter
    def urls(self, urls):
        """
        Sets the urls of this UrlList.
        List of urls.


        :param urls: The urls of this UrlList.
        :type: list[oci.network_firewall.models.UrlPattern]
        """
        self._urls = urls

    @property
    def total_urls(self):
        """
        **[Required]** Gets the total_urls of this UrlList.
        Total count of URLs in the URL List


        :return: The total_urls of this UrlList.
        :rtype: int
        """
        return self._total_urls

    @total_urls.setter
    def total_urls(self, total_urls):
        """
        Sets the total_urls of this UrlList.
        Total count of URLs in the URL List


        :param total_urls: The total_urls of this UrlList.
        :type: int
        """
        self._total_urls = total_urls

    @property
    def parent_resource_id(self):
        """
        **[Required]** Gets the parent_resource_id of this UrlList.
        OCID of the Network Firewall Policy this URL List belongs to.


        :return: The parent_resource_id of this UrlList.
        :rtype: str
        """
        return self._parent_resource_id

    @parent_resource_id.setter
    def parent_resource_id(self, parent_resource_id):
        """
        Sets the parent_resource_id of this UrlList.
        OCID of the Network Firewall Policy this URL List belongs to.


        :param parent_resource_id: The parent_resource_id of this UrlList.
        :type: str
        """
        self._parent_resource_id = parent_resource_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
