# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ListObjects(object):
    """
    List of the objects.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ListObjects object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param prefixes:
            The value to assign to the prefixes property of this ListObjects.
        :type prefixes: list[str]

        :param next_start_with:
            The value to assign to the next_start_with property of this ListObjects.
        :type next_start_with: str

        :param objects:
            The value to assign to the objects property of this ListObjects.
        :type objects: list[oci.opsi.models.ObjectSummary]

        """
        self.swagger_types = {
            'prefixes': 'list[str]',
            'next_start_with': 'str',
            'objects': 'list[ObjectSummary]'
        }

        self.attribute_map = {
            'prefixes': 'prefixes',
            'next_start_with': 'nextStartWith',
            'objects': 'objects'
        }

        self._prefixes = None
        self._next_start_with = None
        self._objects = None

    @property
    def prefixes(self):
        """
        Gets the prefixes of this ListObjects.
        Array comprising of all the prefixes.


        :return: The prefixes of this ListObjects.
        :rtype: list[str]
        """
        return self._prefixes

    @prefixes.setter
    def prefixes(self, prefixes):
        """
        Sets the prefixes of this ListObjects.
        Array comprising of all the prefixes.


        :param prefixes: The prefixes of this ListObjects.
        :type: list[str]
        """
        self._prefixes = prefixes

    @property
    def next_start_with(self):
        """
        Gets the next_start_with of this ListObjects.
        Object names returned by a list query must be greater or equal to this parameter.


        :return: The next_start_with of this ListObjects.
        :rtype: str
        """
        return self._next_start_with

    @next_start_with.setter
    def next_start_with(self, next_start_with):
        """
        Sets the next_start_with of this ListObjects.
        Object names returned by a list query must be greater or equal to this parameter.


        :param next_start_with: The next_start_with of this ListObjects.
        :type: str
        """
        self._next_start_with = next_start_with

    @property
    def objects(self):
        """
        **[Required]** Gets the objects of this ListObjects.
        List of the object summary data.


        :return: The objects of this ListObjects.
        :rtype: list[oci.opsi.models.ObjectSummary]
        """
        return self._objects

    @objects.setter
    def objects(self, objects):
        """
        Sets the objects of this ListObjects.
        List of the object summary data.


        :param objects: The objects of this ListObjects.
        :type: list[oci.opsi.models.ObjectSummary]
        """
        self._objects = objects

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
