# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WorkRequestEventDataAdditionalDetails(object):
    """
    Provides additional information for the work request associated with an event.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new WorkRequestEventDataAdditionalDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param initiator_id:
            The value to assign to the initiator_id property of this WorkRequestEventDataAdditionalDetails.
        :type initiator_id: str

        :param work_request_ids:
            The value to assign to the work_request_ids property of this WorkRequestEventDataAdditionalDetails.
        :type work_request_ids: list[str]

        """
        self.swagger_types = {
            'initiator_id': 'str',
            'work_request_ids': 'list[str]'
        }

        self.attribute_map = {
            'initiator_id': 'initiatorId',
            'work_request_ids': 'workRequestIds'
        }

        self._initiator_id = None
        self._work_request_ids = None

    @property
    def initiator_id(self):
        """
        **[Required]** Gets the initiator_id of this WorkRequestEventDataAdditionalDetails.
        The `OCID`__ of the resource that triggered the event, such as scheduled job id.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The initiator_id of this WorkRequestEventDataAdditionalDetails.
        :rtype: str
        """
        return self._initiator_id

    @initiator_id.setter
    def initiator_id(self, initiator_id):
        """
        Sets the initiator_id of this WorkRequestEventDataAdditionalDetails.
        The `OCID`__ of the resource that triggered the event, such as scheduled job id.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param initiator_id: The initiator_id of this WorkRequestEventDataAdditionalDetails.
        :type: str
        """
        self._initiator_id = initiator_id

    @property
    def work_request_ids(self):
        """
        Gets the work_request_ids of this WorkRequestEventDataAdditionalDetails.
        List of all work request `OCIDs`__ associated with the event.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The work_request_ids of this WorkRequestEventDataAdditionalDetails.
        :rtype: list[str]
        """
        return self._work_request_ids

    @work_request_ids.setter
    def work_request_ids(self, work_request_ids):
        """
        Sets the work_request_ids of this WorkRequestEventDataAdditionalDetails.
        List of all work request `OCIDs`__ associated with the event.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param work_request_ids: The work_request_ids of this WorkRequestEventDataAdditionalDetails.
        :type: list[str]
        """
        self._work_request_ids = work_request_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
