# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TunnelStatus(object):
    """
    Deprecated. For tunnel information, instead see :class:`IPSecConnectionTunnel`.
    """

    #: A constant which can be used with the lifecycle_state property of a TunnelStatus.
    #: This constant has a value of "UP"
    LIFECYCLE_STATE_UP = "UP"

    #: A constant which can be used with the lifecycle_state property of a TunnelStatus.
    #: This constant has a value of "DOWN"
    LIFECYCLE_STATE_DOWN = "DOWN"

    #: A constant which can be used with the lifecycle_state property of a TunnelStatus.
    #: This constant has a value of "DOWN_FOR_MAINTENANCE"
    LIFECYCLE_STATE_DOWN_FOR_MAINTENANCE = "DOWN_FOR_MAINTENANCE"

    #: A constant which can be used with the lifecycle_state property of a TunnelStatus.
    #: This constant has a value of "PARTIAL_UP"
    LIFECYCLE_STATE_PARTIAL_UP = "PARTIAL_UP"

    def __init__(self, **kwargs):
        """
        Initializes a new TunnelStatus object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ip_address:
            The value to assign to the ip_address property of this TunnelStatus.
        :type ip_address: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this TunnelStatus.
            Allowed values for this property are: "UP", "DOWN", "DOWN_FOR_MAINTENANCE", "PARTIAL_UP"
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this TunnelStatus.
        :type time_created: datetime

        :param time_state_modified:
            The value to assign to the time_state_modified property of this TunnelStatus.
        :type time_state_modified: datetime

        """
        self.swagger_types = {
            'ip_address': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_state_modified': 'datetime'
        }

        self.attribute_map = {
            'ip_address': 'ipAddress',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_state_modified': 'timeStateModified'
        }

        self._ip_address = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_state_modified = None

    @property
    def ip_address(self):
        """
        **[Required]** Gets the ip_address of this TunnelStatus.
        The IP address of Oracle's VPN headend.

        Example: `203.0.113.50`


        :return: The ip_address of this TunnelStatus.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this TunnelStatus.
        The IP address of Oracle's VPN headend.

        Example: `203.0.113.50`


        :param ip_address: The ip_address of this TunnelStatus.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this TunnelStatus.
        The tunnel's current state.

        Allowed values for this property are: "UP", "DOWN", "DOWN_FOR_MAINTENANCE", "PARTIAL_UP"


        :return: The lifecycle_state of this TunnelStatus.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this TunnelStatus.
        The tunnel's current state.


        :param lifecycle_state: The lifecycle_state of this TunnelStatus.
        :type: str
        """
        allowed_values = ["UP", "DOWN", "DOWN_FOR_MAINTENANCE", "PARTIAL_UP"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            raise ValueError(
                f"Invalid value for `lifecycle_state`, must be None or one of {allowed_values}"
            )
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        Gets the time_created of this TunnelStatus.
        The date and time the IPSec connection was created, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this TunnelStatus.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this TunnelStatus.
        The date and time the IPSec connection was created, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this TunnelStatus.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_state_modified(self):
        """
        Gets the time_state_modified of this TunnelStatus.
        When the state of the tunnel last changed, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_state_modified of this TunnelStatus.
        :rtype: datetime
        """
        return self._time_state_modified

    @time_state_modified.setter
    def time_state_modified(self, time_state_modified):
        """
        Sets the time_state_modified of this TunnelStatus.
        When the state of the tunnel last changed, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_state_modified: The time_state_modified of this TunnelStatus.
        :type: datetime
        """
        self._time_state_modified = time_state_modified

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
