# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Package(object):
    """
    Details of the vulnerable package found
    """

    #: A constant which can be used with the type property of a Package.
    #: This constant has a value of "JAVA"
    TYPE_JAVA = "JAVA"

    #: A constant which can be used with the type property of a Package.
    #: This constant has a value of "APK"
    TYPE_APK = "APK"

    #: A constant which can be used with the type property of a Package.
    #: This constant has a value of "RPM"
    TYPE_RPM = "RPM"

    #: A constant which can be used with the type property of a Package.
    #: This constant has a value of "DEB"
    TYPE_DEB = "DEB"

    #: A constant which can be used with the type property of a Package.
    #: This constant has a value of "GO"
    TYPE_GO = "GO"

    #: A constant which can be used with the type property of a Package.
    #: This constant has a value of "NPM"
    TYPE_NPM = "NPM"

    #: A constant which can be used with the type property of a Package.
    #: This constant has a value of "PYTHON"
    TYPE_PYTHON = "PYTHON"

    #: A constant which can be used with the type property of a Package.
    #: This constant has a value of "RUST"
    TYPE_RUST = "RUST"

    #: A constant which can be used with the type property of a Package.
    #: This constant has a value of "PHP_COMPOSER"
    TYPE_PHP_COMPOSER = "PHP_COMPOSER"

    #: A constant which can be used with the type property of a Package.
    #: This constant has a value of "GEM"
    TYPE_GEM = "GEM"

    #: A constant which can be used with the type property of a Package.
    #: This constant has a value of "MSRC_KB"
    TYPE_MSRC_KB = "MSRC_KB"

    def __init__(self, **kwargs):
        """
        Initializes a new Package object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this Package.
        :type name: str

        :param version:
            The value to assign to the version property of this Package.
        :type version: str

        :param cve_fix_version:
            The value to assign to the cve_fix_version property of this Package.
        :type cve_fix_version: str

        :param type:
            The value to assign to the type property of this Package.
            Allowed values for this property are: "JAVA", "APK", "RPM", "DEB", "GO", "NPM", "PYTHON", "RUST", "PHP_COMPOSER", "GEM", "MSRC_KB", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param locations:
            The value to assign to the locations property of this Package.
        :type locations: list[str]

        """
        self.swagger_types = {
            'name': 'str',
            'version': 'str',
            'cve_fix_version': 'str',
            'type': 'str',
            'locations': 'list[str]'
        }

        self.attribute_map = {
            'name': 'name',
            'version': 'version',
            'cve_fix_version': 'cveFixVersion',
            'type': 'type',
            'locations': 'locations'
        }

        self._name = None
        self._version = None
        self._cve_fix_version = None
        self._type = None
        self._locations = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this Package.
        Name of the package


        :return: The name of this Package.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Package.
        Name of the package


        :param name: The name of this Package.
        :type: str
        """
        self._name = name

    @property
    def version(self):
        """
        **[Required]** Gets the version of this Package.
        Package version


        :return: The version of this Package.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this Package.
        Package version


        :param version: The version of this Package.
        :type: str
        """
        self._version = version

    @property
    def cve_fix_version(self):
        """
        Gets the cve_fix_version of this Package.
        Package version in which the CVE was fixed


        :return: The cve_fix_version of this Package.
        :rtype: str
        """
        return self._cve_fix_version

    @cve_fix_version.setter
    def cve_fix_version(self, cve_fix_version):
        """
        Sets the cve_fix_version of this Package.
        Package version in which the CVE was fixed


        :param cve_fix_version: The cve_fix_version of this Package.
        :type: str
        """
        self._cve_fix_version = cve_fix_version

    @property
    def type(self):
        """
        **[Required]** Gets the type of this Package.
        Package type

        Allowed values for this property are: "JAVA", "APK", "RPM", "DEB", "GO", "NPM", "PYTHON", "RUST", "PHP_COMPOSER", "GEM", "MSRC_KB", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this Package.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Package.
        Package type


        :param type: The type of this Package.
        :type: str
        """
        allowed_values = ["JAVA", "APK", "RPM", "DEB", "GO", "NPM", "PYTHON", "RUST", "PHP_COMPOSER", "GEM", "MSRC_KB"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def locations(self):
        """
        Gets the locations of this Package.
        Disk locations where package was found


        :return: The locations of this Package.
        :rtype: list[str]
        """
        return self._locations

    @locations.setter
    def locations(self, locations):
        """
        Sets the locations of this Package.
        Disk locations where package was found


        :param locations: The locations of this Package.
        :type: list[str]
        """
        self._locations = locations

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
