#  SHIBOKEN_INCLUDE_DIR        - Directories to include to use SHIBOKEN
#  SHIBOKEN_LIBRARY            - Files to link against to use SHIBOKEN
#  SHIBOKEN_BINARY             - Executable name
#  SHIBOKEN_BUILD_TYPE         - Tells if Shiboken was compiled in Release or Debug mode.
#  SHIBOKEN_PYTHON_INTERPRETER - Python interpreter (regular or debug) to be used with the bindings.
#  SHIBOKEN_PYTHON_LIBRARIES   - Python libraries (regular or debug) Shiboken is linked against.

SET(SHIBOKEN_INCLUDE_DIR "/opt/local/include/shiboken-3.11")
if(MSVC)
    SET(SHIBOKEN_LIBRARY "/opt/local/lib/libshiboken.cpython-311-darwin.lib")
elseif(CYGWIN)
    SET(SHIBOKEN_LIBRARY "/opt/local/lib/shiboken.cpython-311-darwin")
elseif(WIN32)
    SET(SHIBOKEN_LIBRARY "/opt/local/bin/libshiboken.cpython-311-darwin.dylib")
else()
    SET(SHIBOKEN_LIBRARY "/opt/local/lib/libshiboken.cpython-311-darwin.dylib")
endif()
SET(SHIBOKEN_PYTHON_INCLUDE_DIR "/opt/local/Library/Frameworks/Python.framework/Versions/3.11/include/python3.11")
SET(SHIBOKEN_PYTHON_INCLUDE_DIR "/opt/local/Library/Frameworks/Python.framework/Versions/3.11/include/python3.11")
SET(SHIBOKEN_PYTHON_INTERPRETER "/opt/local/bin/python3.11")
SET(SHIBOKEN_PYTHON_LIBRARIES "-undefined dynamic_lookup")
SET(SHIBOKEN_PYTHON_SUFFIX ".cpython-311-darwin")
message(STATUS "libshiboken built for Release")


set(SHIBOKEN_BINARY "/opt/local/bin/shiboken-3.11")
