'use strict';
/*!
 * Copyright (c) Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  let define;
  const parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  const cache = {};

  const normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      const prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    const alias = aliases[name]
    if (alias != null)
      return alias;

    const trailing = name.length > 0 && name[name.length-1] === "/";
    const index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  const require = function(name) {
    let mod = cache[name];
    if (!mod) {
      const id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          const err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  const main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (let name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (let name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (let name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    const plugin = require(plugin_entry);

    for (let name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
function _(t,_,n,o,r){o();t(1).__exportStar(t(2),n),t(76)},
function _(e,t,r,n,o){n();var a=function(e,t){return a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r])},a(e,t)};function i(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function r(){this.constructor=e}a(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}r.__extends=i;function c(e,t){var r={};for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.indexOf(n)<0&&(r[n]=e[n]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(n=Object.getOwnPropertySymbols(e);o<n.length;o++)t.indexOf(n[o])<0&&Object.prototype.propertyIsEnumerable.call(e,n[o])&&(r[n[o]]=e[n[o]])}return r}function s(e,t,r,n){var o,a=arguments.length,i=a<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(e,t,r,n);else for(var c=e.length-1;c>=0;c--)(o=e[c])&&(i=(a<3?o(i):a>3?o(t,r,i):o(t,r))||i);return a>3&&i&&Object.defineProperty(t,r,i),i}function u(e,t){return function(r,n){t(r,n,e)}}function f(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)}function l(e,t,r,n){return new(r||(r=Promise))((function(o,a){function i(e){try{s(n.next(e))}catch(e){a(e)}}function c(e){try{s(n.throw(e))}catch(e){a(e)}}function s(e){var t;e.done?o(e.value):(t=e.value,t instanceof r?t:new r((function(e){e(t)}))).then(i,c)}s((n=n.apply(e,t||[])).next())}))}function p(e,t){var r,n,o,a,i={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:c(0),throw:c(1),return:c(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function c(c){return function(s){return function(c){if(r)throw new TypeError("Generator is already executing.");for(;a&&(a=0,c[0]&&(i=0)),i;)try{if(r=1,n&&(o=2&c[0]?n.return:c[0]?n.throw||((o=n.return)&&o.call(n),0):n.next)&&!(o=o.call(n,c[1])).done)return o;switch(n=0,o&&(c=[2&c[0],o.value]),c[0]){case 0:case 1:o=c;break;case 4:return i.label++,{value:c[1],done:!1};case 5:i.label++,n=c[1],c=[0];continue;case 7:c=i.ops.pop(),i.trys.pop();continue;default:if(!(o=i.trys,(o=o.length>0&&o[o.length-1])||6!==c[0]&&2!==c[0])){i=0;continue}if(3===c[0]&&(!o||c[1]>o[0]&&c[1]<o[3])){i.label=c[1];break}if(6===c[0]&&i.label<o[1]){i.label=o[1],o=c;break}if(o&&i.label<o[2]){i.label=o[2],i.ops.push(c);break}o[2]&&i.ops.pop(),i.trys.pop();continue}c=t.call(e,i)}catch(e){c=[6,e],n=0}finally{r=o=0}if(5&c[0])throw c[1];return{value:c[0]?c[1]:void 0,done:!0}}([c,s])}}}function y(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||(0,r.__createBinding)(t,e,n)}function _(e){var t="function"==typeof Symbol&&Symbol.iterator,r=t&&e[t],n=0;if(r)return r.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&n>=e.length&&(e=void 0),{value:e&&e[n++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")}function d(e,t){var r="function"==typeof Symbol&&e[Symbol.iterator];if(!r)return e;var n,o,a=r.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(n=a.next()).done;)i.push(n.value)}catch(e){o={error:e}}finally{try{n&&!n.done&&(r=a.return)&&r.call(a)}finally{if(o)throw o.error}}return i}function h(){for(var e=[],t=0;t<arguments.length;t++)e=e.concat(d(arguments[t]));return e}function b(){for(var e=0,t=0,r=arguments.length;t<r;t++)e+=arguments[t].length;var n=Array(e),o=0;for(t=0;t<r;t++)for(var a=arguments[t],i=0,c=a.length;i<c;i++,o++)n[o]=a[i];return n}function v(e,t,r){if(r||2===arguments.length)for(var n,o=0,a=t.length;o<a;o++)!n&&o in t||(n||(n=Array.prototype.slice.call(t,0,o)),n[o]=t[o]);return e.concat(n||Array.prototype.slice.call(t))}function w(e){return this instanceof w?(this.v=e,this):new w(e)}function m(e,t,r){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var n,o=r.apply(e,t||[]),a=[];return n={},i("next"),i("throw"),i("return"),n[Symbol.asyncIterator]=function(){return this},n;function i(e){o[e]&&(n[e]=function(t){return new Promise((function(r,n){a.push([e,t,r,n])>1||c(e,t)}))})}function c(e,t){try{(r=o[e](t)).value instanceof w?Promise.resolve(r.value.v).then(s,u):f(a[0][2],r)}catch(e){f(a[0][3],e)}var r}function s(e){c("next",e)}function u(e){c("throw",e)}function f(e,t){e(t),a.shift(),a.length&&c(a[0][0],a[0][1])}}function g(e){var t,r;return t={},n("next"),n("throw",(function(e){throw e})),n("return"),t[Symbol.iterator]=function(){return this},t;function n(n,o){t[n]=e[n]?function(t){return(r=!r)?{value:w(e[n](t)),done:!1}:o?o(t):t}:o}}function O(e){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var t,r=e[Symbol.asyncIterator];return r?r.call(e):(e=_(e),t={},n("next"),n("throw"),n("return"),t[Symbol.asyncIterator]=function(){return this},t);function n(r){t[r]=e[r]&&function(t){return new Promise((function(n,o){(function(e,t,r,n){Promise.resolve(n).then((function(t){e({value:t,done:r})}),t)})(n,o,(t=e[r](t)).done,t.value)}))}}}function j(e,t){return Object.defineProperty?Object.defineProperty(e,"raw",{value:t}):e.raw=t,e}r.__assign=function(){return r.__assign=Object.assign||function(e){for(var t,r=1,n=arguments.length;r<n;r++)for(var o in t=arguments[r])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e},r.__assign.apply(this,arguments)},r.__rest=c,r.__decorate=s,r.__param=u,r.__esDecorate=function(e,t,r,n,o,a){function i(e){if(void 0!==e&&"function"!=typeof e)throw new TypeError("Function expected");return e}for(var c,s=n.kind,u="getter"===s?"get":"setter"===s?"set":"value",f=!t&&e?n.static?e:e.prototype:null,l=t||(f?Object.getOwnPropertyDescriptor(f,n.name):{}),p=!1,y=r.length-1;y>=0;y--){var _={};for(var d in n)_[d]="access"===d?{}:n[d];for(var d in n.access)_.access[d]=n.access[d];_.addInitializer=function(e){if(p)throw new TypeError("Cannot add initializers after decoration has completed");a.push(i(e||null))};var h=(0,r[y])("accessor"===s?{get:l.get,set:l.set}:l[u],_);if("accessor"===s){if(void 0===h)continue;if(null===h||"object"!=typeof h)throw new TypeError("Object expected");(c=i(h.get))&&(l.get=c),(c=i(h.set))&&(l.set=c),(c=i(h.init))&&o.unshift(c)}else(c=i(h))&&("field"===s?o.unshift(c):l[u]=c)}f&&Object.defineProperty(f,n.name,l),p=!0},r.__runInitializers=function(e,t,r){for(var n=arguments.length>2,o=0;o<t.length;o++)r=n?t[o].call(e,r):t[o].call(e);return n?r:void 0},r.__propKey=function(e){return"symbol"==typeof e?e:"".concat(e)},r.__setFunctionName=function(e,t,r){return"symbol"==typeof t&&(t=t.description?"[".concat(t.description,"]"):""),Object.defineProperty(e,"name",{configurable:!0,value:r?"".concat(r," ",t):t})},r.__metadata=f,r.__awaiter=l,r.__generator=p,r.__createBinding=Object.create?function(e,t,r,n){void 0===n&&(n=r);var o=Object.getOwnPropertyDescriptor(t,r);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,o)}:function(e,t,r,n){void 0===n&&(n=r),e[n]=t[r]},r.__exportStar=y,r.__values=_,r.__read=d,r.__spread=h,r.__spreadArrays=b,r.__spreadArray=v,r.__await=w,r.__asyncGenerator=m,r.__asyncDelegator=g,r.__asyncValues=O,r.__makeTemplateObject=j;var P=Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t};function S(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)"default"!==n&&Object.prototype.hasOwnProperty.call(e,n)&&(0,r.__createBinding)(t,e,n);return P(t,e),t}function E(e){return e&&e.__esModule?e:{default:e}}function x(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)}function T(e,t,r,n,o){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!o)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!o:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?o.call(e,r):o?o.value=r:t.set(e,r),r}function D(e,t){if(null===t||"object"!=typeof t&&"function"!=typeof t)throw new TypeError("Cannot use 'in' operator on non-object");return"function"==typeof e?t===e:e.has(t)}function I(e,t,r){if(null!=t){if("object"!=typeof t&&"function"!=typeof t)throw new TypeError("Object expected.");var n;if(r){if(!Symbol.asyncDispose)throw new TypeError("Symbol.asyncDispose is not defined.");n=t[Symbol.asyncDispose]}if(void 0===n){if(!Symbol.dispose)throw new TypeError("Symbol.dispose is not defined.");n=t[Symbol.dispose]}if("function"!=typeof n)throw new TypeError("Object not disposable.");e.stack.push({value:t,dispose:n,async:r})}else r&&e.stack.push({async:!0});return t}r.__importStar=S,r.__importDefault=E,r.__classPrivateFieldGet=x,r.__classPrivateFieldSet=T,r.__classPrivateFieldIn=D,r.__addDisposableResource=I;var k="function"==typeof SuppressedError?SuppressedError:function(e,t,r){var n=new Error(r);return n.name="SuppressedError",n.error=e,n.suppressed=t,n};function R(e){function t(t){e.error=e.hasError?new k(t,e.error,"An error was suppressed during disposal."):t,e.hasError=!0}return function r(){for(;e.stack.length;){var n=e.stack.pop();try{var o=n.dispose&&n.dispose.call(n.value);if(n.async)return Promise.resolve(o).then(r,(function(e){return t(e),r()}))}catch(e){t(e)}}if(e.hasError)throw e.error}()}r.__disposeResources=R,r.default={__extends:i,__assign:r.__assign,__rest:c,__decorate:s,__param:u,__metadata:f,__awaiter:l,__generator:p,__createBinding:r.__createBinding,__exportStar:y,__values:_,__read:d,__spread:h,__spreadArrays:b,__spreadArray:v,__await:w,__asyncGenerator:m,__asyncDelegator:g,__asyncValues:O,__makeTemplateObject:j,__importStar:S,__importDefault:E,__classPrivateFieldGet:x,__classPrivateFieldSet:T,__classPrivateFieldIn:D,__addDisposableResource:I,__disposeResources:R}},
function _(e,o,t,s,l){s();const r=e(1);l("version",e(3).version),l("index",e(4).index),t.embed=r.__importStar(e(4)),t.protocol=r.__importStar(e(74));var n=e(19);l("logger",n.logger),l("set_log_level",n.set_log_level),l("settings",e(29).settings),l("Models",e(7).default_resolver),l("documents",e(5).documents),l("safely",e(75).safely)},
function _(n,i,o,c,e){c(),o.version="3.4.0"},
function _(e,o,t,n,r){n();const s=e(5),d=e(29),i=e(19),_=e(40),c=e(9),a=e(8),u=e(16),l=e(54),m=e(67),f=e(72);var w=e(54);r("add_document_standalone",w.add_document_standalone),r("index",w.index),r("add_document_from_session",e(67).add_document_from_session);var g=e(73);async function k(e,o,t,n){(0,a.isString)(e)&&(e=JSON.parse((0,_.unescape)(e)));const r={};for(const[o,t]of(0,c.entries)(e))r[o]=s.Document.from_json(t);const u=[];for(const e of o){const o=(0,f._resolve_element)(e),s=(0,f._resolve_root_elements)(e);if(null!=e.docid)u.push(await(0,l.add_document_standalone)(r[e.docid],o,s,e.use_for_title));else{if(null==e.token)throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");{const r=(0,m._get_ws_url)(t,n);i.logger.debug(`embed: computed ws url: ${r}`);try{u.push(await(0,m.add_document_from_session)(r,e.token,o,s,e.use_for_title)),console.log("Bokeh items were rendered successfully")}catch(e){if(d.settings.dev)throw e;console.error("Error rendering Bokeh items:",e)}}}}return u}r("embed_items_notebook",g.embed_items_notebook),r("kernels",g.kernels),t.embed_item=async function(e,o){const t={},n=(0,_.uuid4)();t[n]=e.doc,null==o&&(o=e.target_id);const r={roots:{[e.root_id]:o},root_ids:[e.root_id],docid:n};await(0,u.defer)();const[s]=await k(t,[r]);return s},t.embed_items=async function(e,o,t,n){return await(0,u.defer)(),k(e,o,t,n)}},
function _(t,_,o,r,n){r();const a=t(1);a.__exportStar(t(6),o),a.__exportStar(t(41),o)},
function _(e,t,s,o,n){o();const i=e(1),_=e(7),l=e(3),r=e(19),a=e(46),c=e(32),h=e(47),d=e(49),m=e(15),u=e(8),f=e(26),g=e(10),v=e(9),p=i.__importStar(e(44)),w=e(50),b=e(51),k=e(52),y=e(53),z=e(41);h.Deserializer.register("model",k.decode_def);class S{constructor(e){this.subscribed_models=new Set,this.document=e}send_event(e){if(e.publish){const t=new z.MessageSentEvent(this.document,"bokeh_event",e);this.document._trigger_on_change(t)}this.document._trigger_on_event(e)}trigger(e){for(const t of this.subscribed_models)null!=e.origin&&e.origin!=t||t._process_event(e)}}s.EventManager=S,S.__name__="EventManager",s.documents=[],s.DEFAULT_TITLE="Bokeh Application";class D{constructor(e={}){s.documents.push(this),this._init_timestamp=Date.now(),this._resolver=e.resolver??new a.ModelResolver(_.default_resolver),this._title=s.DEFAULT_TITLE,this._roots=[],this._all_models=new Map,this._new_models=new Set,this._all_models_freeze_count=0,this._callbacks=new Map,this._document_callbacks=new Map,this._message_callbacks=new Map,this.event_manager=new S(this),this.idle=new m.Signal0(this,"idle"),this._idle_roots=new WeakSet,this._interactive_timestamp=null,this._interactive_plot=null,null!=e.roots&&this._add_roots(...e.roots)}[f.equals](e,t){return this==e}get all_models(){return new Set(this._all_models.values())}get is_idle(){for(const e of this._roots)if(!this._idle_roots.has(e))return!1;return!0}notify_idle(e){this._idle_roots.add(e),this.is_idle&&(r.logger.info(`document idle at ${Date.now()-this._init_timestamp} ms`),this.event_manager.send_event(new y.DocumentReady),this.idle.emit())}clear(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}}interactive_start(e,t=null){null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new y.LODStart)),this._interactive_finalize=t,this._interactive_timestamp=Date.now()}interactive_stop(){null!=this._interactive_plot&&(this._interactive_plot.trigger_event(new y.LODEnd),null!=this._interactive_finalize&&this._interactive_finalize()),this._interactive_plot=null,this._interactive_timestamp=null,this._interactive_finalize=null}interactive_duration(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp}destructively_move(e){if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();const t=(0,g.copy)(this._roots);this.clear();for(const e of t)if(null!=e.document)throw new Error(`Somehow we didn't detach ${e}`);if(0!=this._all_models.size)throw new Error(`this._all_models still had stuff in it: ${this._all_models}`);for(const s of t)e.add_root(s);e.set_title(this._title)}_push_all_models_freeze(){this._all_models_freeze_count+=1}_pop_all_models_freeze(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()}_invalidate_all_models(){r.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()}_recompute_all_models(){let e=new Set;for(const t of this._roots)e=p.union(e,t.references());const t=new Set(this._all_models.values()),s=p.difference(t,e),o=p.difference(e,t),n=new Map;for(const t of e)n.set(t.id,t);for(const e of s)e.detach_document();for(const e of o)e.attach_document(this),this._new_models.add(e);this._all_models=n}roots(){return this._roots}_add_roots(...e){if(0==(e=e.filter((e=>!this._roots.includes(e)))).length)return!1;this._push_all_models_freeze();try{this._roots.push(...e)}finally{this._pop_all_models_freeze()}return!0}_remove_root(e){const t=this._roots.indexOf(e);if(t<0)return!1;this._push_all_models_freeze();try{this._roots.splice(t,1)}finally{this._pop_all_models_freeze()}return!0}_set_title(e){const t=e!=this._title;return t&&(this._title=e),t}add_root(e,{sync:t}={}){if(this._add_roots(e)){const s=new z.RootAddedEvent(this,e);s.sync=t??!0,this._trigger_on_change(s)}}remove_root(e,{sync:t}={}){if(this._remove_root(e)){const s=new z.RootRemovedEvent(this,e);s.sync=t??!0,this._trigger_on_change(s)}}set_title(e,{sync:t}={}){if(this._set_title(e)){const s=new z.TitleChangedEvent(this,e);s.sync=t??!0,this._trigger_on_change(s)}}title(){return this._title}get_model_by_id(e){return this._all_models.get(e)??null}get_model_by_name(e){const t=[];for(const s of this._all_models.values())s instanceof b.Model&&s.name==e&&t.push(s);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error(`Multiple models are named '${e}'`)}}on_message(e,t){const s=this._message_callbacks.get(e);null==s?this._message_callbacks.set(e,new Set([t])):s.add(t)}remove_on_message(e,t){this._message_callbacks.get(e)?.delete(t)}_trigger_on_message(e,t){const s=this._message_callbacks.get(e);if(null!=s)for(const e of s)e(t)}on_change(e,t=!1){this._callbacks.has(e)||this._callbacks.set(e,t)}remove_on_change(e){this._callbacks.delete(e)}_trigger_on_change(e){for(const[t,s]of this._callbacks)if(!s&&e instanceof z.DocumentEventBatch)for(const s of e.events)t(s);else t(e)}_trigger_on_event(e){const t=this._document_callbacks.get(e.event_name);if(null!=t)for(const s of t)(0,w.execute)(s,this,e)}on_event(e,...t){const s=(0,u.isString)(e)?e:e.prototype.event_name,o=this._document_callbacks.get(s)??[],n=t;this._document_callbacks.set(s,[...o,...n])}to_json_string(e=!0){return JSON.stringify(this.to_json(e))}to_json(e=!0){const t=new c.Serializer({include_defaults:e}).encode(this._roots);return{version:l.version,title:this._title,roots:t}}static from_json_string(e,t){const s=JSON.parse(e);return D.from_json(s,t)}static _handle_version(e){null==e.version&&r.logger.warn("'version' field is missing");const t=e.version??"0.0.0",s=d.Version.from(t),o=d.Version.from(l.version),n=`new document using Bokeh ${t} and BokehJS ${l.version}`;(0,f.is_equal)(s,o)?r.logger.debug(n):r.logger.warn(`Bokeh/BokehJS version mismatch: ${n}`)}static from_json(e,t){r.logger.debug("Creating Document from JSON"),D._handle_version(e);const s=new a.ModelResolver(_.default_resolver);if(null!=e.defs){new h.Deserializer(s).decode(e.defs)}const o=new D({resolver:s});o._push_all_models_freeze();const n=e=>t?.push(e);o.on_change(n,!0);const i=new h.Deserializer(s,o._all_models,(e=>e.attach_document(o))),l=i.decode(e.roots),c=null!=e.callbacks?i.decode(e.callbacks):{};o.remove_on_change(n);for(const[e,t]of(0,v.entries)(c))o.on_event(e,...t);for(const e of l)o.add_root(e);return null!=e.title&&o.set_title(e.title),o._pop_all_models_freeze(),o}replace_with_json(e){D.from_json(e).destructively_move(this)}create_json_patch(e){for(const t of e)if(t.document!=this)throw new Error("Cannot create a patch using events from a different document");const t=new Map;for(const e of this._all_models.values())this._new_models.has(e)||t.set(e,e.ref());const s={events:new c.Serializer({references:t,binary:!0}).encode(e)};return this._new_models.clear(),s}apply_json_patch(e,t=new Map){this._push_all_models_freeze();const s=new h.Deserializer(this._resolver,this._all_models,(e=>e.attach_document(this))).decode(e.events,t);for(const e of s)switch(e.kind){case"MessageSent":{const{msg_type:t,msg_data:s}=e;this._trigger_on_message(t,s);break}case"ModelChanged":{const{model:t,attr:s,new:o}=e;t.setv({[s]:o},{sync:!1});break}case"ColumnDataChanged":{const{model:t,attr:s,data:o,cols:n}=e;if(null!=n){const e=(0,v.dict)(o),n=(0,v.dict)(t.property(s).get_value());for(const[t,s]of n)e.has(t)||e.set(t,s)}t.setv({data:o},{sync:!1,check_eq:!1});break}case"ColumnsStreamed":{const{model:t,attr:s,data:o,rollover:n}=e,i=t.property(s);t.stream_to(i,o,n,{sync:!1});break}case"ColumnsPatched":{const{model:t,attr:s,patches:o}=e,n=t.property(s);t.patch_to(n,o,{sync:!1});break}case"RootAdded":this.add_root(e.model,{sync:!1});break;case"RootRemoved":this.remove_root(e.model,{sync:!1});break;case"TitleChanged":this.set_title(e.title,{sync:!1});break;default:throw new Error(`unknown patch event type '${e.kind}'`)}this._pop_all_models_freeze()}}s.Document=D,D.__name__="Document"},
function _(e,o,r,s,t){s();const l=e(8),n=e(9),a=e(14),f=e(46);r.default_resolver=new f.ModelResolver(null),r.register_models=function(e,o=!1){for(const t of(0,l.isArray)(e)?e:(0,n.values)(e))s=t,(0,l.isObject)(s)&&s.prototype instanceof a.HasProps&&r.default_resolver.register(t,o);var s}},
function _(n,t,r,i,e){i();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const{toString:o}=Object.prototype;function u(n){return null==n}function c(n){return null!=n}function s(n){return!0===n||!1===n||"[object Boolean]"===o.call(n)}function f(n){return"[object Number]"===o.call(n)}function l(n){return"[object String]"===o.call(n)}function a(n){return"symbol"==typeof n}function b(n){const t=typeof n;return"function"===t||"object"===t&&!!n}function y(n){return b(n)&&(u(n.constructor)||n.constructor===Object)}function j(n){return b(n)&&Symbol.iterator in n}r.is_undefined=function(n){return void 0===n},r.is_defined=function(n){return void 0!==n},r.is_nullish=u,r.isNull=function(n){return null==n},r.isNotNull=c,r.non_null=c,r.isBoolean=s,r.isNumber=f,r.isInteger=function(n){return f(n)&&Number.isInteger(n)},r.isString=l,r.isSymbol=a,r.isPrimitive=function(n){return null===n||s(n)||f(n)||l(n)||a(n)},r.isFunction=function(n){switch(o.call(n)){case"[object Function]":case"[object AsyncFunction]":case"[object GeneratorFunction]":case"[object AsyncGeneratorFunction]":return!0;default:return!1}},r.isArray=function(n){return Array.isArray(n)},r.isArrayOf=function(n,t){for(const r of n)if(!t(r))return!1;return!0},r.isArrayableOf=function(n,t){for(const r of n)if(!t(r))return!1;return!0},r.isTypedArray=function(n){return ArrayBuffer.isView(n)&&!(n instanceof DataView)},r.isObject=b,r.isBasicObject=function(n){return b(n)&&u(n.constructor)},r.isPlainObject=y,r.isDict=function(n){return n instanceof Map||y(n)},r.isIterable=j,r.isArrayable=function(n){return j(n)&&"length"in n}},
function _(e,t,n,s,i){var o;s();const r=e(8),c=e(10);function a(e){return e instanceof Map?[...e.keys()]:Object.keys(e)}function u(e){return e instanceof Map?[...e.values()]:Object.values(e)}function b(e){return e instanceof Map?[...e.entries()]:Object.entries(e)}function l(e){return e instanceof Map?e.size:Object.keys(e).length}n.assign=Object.assign,n.extend=n.assign,n.to_object=function(e){return(0,r.isPlainObject)(e)?e:Object.fromEntries(e)},n.keys=a,n.values=u,n.entries=b,n.typed_keys=Object.keys,n.typed_values=Object.values,n.typed_entries=Object.entries,n.clone=function(e){return e instanceof Map?new Map(e):{...e}},n.merge=function(e,t){const n=new Map,s=[...e.keys(),...t.keys()];for(const i of s){const s=e.get(i),o=t.get(i),r=void 0===s?[]:s,a=void 0===o?[]:o;n.set(i,(0,c.union)(r,a))}return n},n.size=l,n.is_empty=function(e){return 0==l(e)};const{hasOwnProperty:j}=Object.prototype;class h{constructor(e){this[o]="PlainObjectProxy",this.obj=e}clear(){for(const e of this.keys())delete this.obj[e]}delete(e){const t=this.has(e);return t&&delete this.obj[e],t}has(e){return j.call(this.obj,e)}get(e){return this.has(e)?this.obj[e]:void 0}set(e,t){return this.obj[e]=t,this}get size(){return l(this.obj)}[(o=Symbol.toStringTag,Symbol.iterator)](){return this.entries()}*keys(){yield*a(this.obj)}*values(){yield*u(this.obj)}*entries(){yield*b(this.obj)}forEach(e,t){for(const[n,s]of this.entries())e.call(t,s,n,this)}}n.PlainObjectProxy=h,h.__name__="PlainObjectProxy",n.dict=function(e){return(0,r.isPlainObject)(e)?new h(e):e}},
function _(n,t,e,r,o){r();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const i=n(11),c=n(12),s=n(8),u=n(13);var f=n(13);o("map",f.map),o("reduce",f.reduce),o("min",f.min),o("min_by",f.min_by),o("max",f.max),o("max_by",f.max_by),o("sum",f.sum),o("cumsum",f.cumsum),o("every",f.every),o("some",f.some),o("find",f.find),o("find_last",f.find_last),o("find_index",f.find_index),o("find_last_index",f.find_last_index),o("sorted_index",f.sorted_index),o("is_empty",f.is_empty),o("includes",f.includes),o("contains",f.contains),o("sort_by",f.sort_by);const l=Array.prototype.slice;function a(n){return l.call(n)}function h(n,t,e=1){(0,c.assert)(e>0,"'step' must be a positive number"),null==t&&(t=n,n=0);const{max:r,ceil:o,abs:i}=Math,s=n<=t?e:-e,u=r(o(i(t-n)/e),0),f=new Array(u);for(let t=0;t<u;t++,n+=s)f[t]=n;return f}function m(n){const t=new Set;for(const e of n)for(const n of e)t.add(n);return t}function d(n,t){for(let e=0;e<n.length;)t(n[e])?n.splice(e,1):e++}e.head=function(n){if(0!=n.length)return n[0];throw new Error("out of bounds access")},e.last=function(n){if(0!=n.length)return n[n.length-1];throw new Error("out of bounds access")},e.copy=a,e.concat=function(n){return[].concat(...n)},e.nth=function(n,t){return n[t>=0?t:n.length+t]},e.zip=function(...n){if(0==n.length)return[];const t=(0,u.min)(n.map((n=>n.length))),e=n.length,r=new Array(t);for(let o=0;o<t;o++){r[o]=new Array(e);for(let t=0;t<e;t++)r[o][t]=n[t][o]}return r},e.unzip=function(n){const t=n.length;if(0==t)return[];const e=(0,u.min)(n.map((n=>n.length))),r=Array(e);for(let n=0;n<e;n++)r[n]=new Array(t);for(let o=0;o<t;o++)for(let t=0;t<e;t++)r[t][o]=n[o][t];return r},e.range=h,e.linspace=function(n,t,e=100){const r=1==e?0:(t-n)/(e-1),o=new Array(e);for(let t=0;t<e;t++)o[t]=n+r*t;return o},e.transpose=function(n){const t=n.length,e=n[0].length,r=[];for(let o=0;o<e;o++){r[o]=[];for(let e=0;e<t;e++)r[o][e]=n[e][o]}return r},e.argmin=function(n){return(0,u.min_by)(h(n.length),(t=>n[t]))},e.argmax=function(n){return(0,u.max_by)(h(n.length),(t=>n[t]))},e.uniq=function(n){const t=new Set;for(const e of n)t.add(e);return[...t]},e.uniq_by=function(n,t){const e=[],r=[];for(const o of n){const n=t(o);(0,u.includes)(r,n)||(r.push(n),e.push(o))}return e},e._union=m,e.union=function(...n){return[...m(n)]},e.intersection=function(n,...t){const e=[];n:for(const r of n)if(!(0,u.includes)(e,r)){for(const n of t)if(!(0,u.includes)(n,r))continue n;e.push(r)}return e},e.difference=function(n,...t){const e=m(t);return(0,u.filter)(n,(n=>!e.has(n)))},e.symmetric_difference=function(n,t){const e=new Set(n),r=new Set(t),o=[];for(const n of e)r.has(n)||o.push(n);for(const n of r)e.has(n)||o.push(n);return o},e.remove_at=function(n,t){(0,c.assert)((0,s.isInteger)(t)&&t>=0);const e=a(n);return e.splice(t,1),e},e.remove=function(n,t){d(n,(n=>n==t))},e.remove_by=d,e.clear=function(n){n.splice(0,n.length)},e.split=function(n,t){const e=[],r=n.length;let o=0,i=0;for(;i<r;)n[i]===t?(e.push(n.slice(o,i)),o=++i):++i;return e.push(n.slice(o)),e},e.shuffle=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++){const t=(0,i.randomIn)(0,r);t!==r&&(e[r]=e[t]),e[t]=n[r]}return e},e.pairwise=function(n,t){const e=n.length,r=new Array(e-1);for(let o=0;o<e-1;o++)r[o]=t(n[o],n[o+1]);return r},e.elementwise=function(n,t,e){const r=Math.min(n.length,t.length),o=Array(r);for(let i=0;i<r;i++)o[i]=e(n[i],t[i]);return o},e.reversed=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++)e[t-r-1]=n[r];return e},e.repeat=function(n,t){return new Array(t).fill(n)},e.resize=function(n,t,e){if(n.length>=t)return n.slice(0,t);{const r=new Array(t-n.length);return void 0!==e&&r.fill(e),n.concat(r)}}},
function _(n,t,r,o,e){o();const a=n(8),c=n(12),{PI:u,abs:i,sign:f}=Math;function l(n){if(0==n)return 0;for(;n<=0;)n+=2*u;for(;n>2*u;)n-=2*u;return n}function s(n,t){return l(n-t)}function h(n,t,r="anticlock"){return-("anticlock"==r?1:-1)*n*g(t)}function g(n){switch(n){case"deg":return u/180;case"rad":return 1;case"grad":return u/200;case"turn":return 2*u}}function m(n,t){for(n=Math.abs(n),t=Math.abs(t);0!=t;)[n,t]=[t,n%t];return n}r.angle_norm=l,r.angle_dist=s,r.angle_between=function(n,t,r,o=!1){const e=s(t,r);if(0==e)return!1;if(e==2*u)return!0;const a=l(n),c=s(t,a)<=e&&s(a,r)<=e;return o?!c:c},r.randomIn=function(n,t){return null==t&&(t=n,n=0),n+Math.floor(Math.random()*(t-n+1))},r.atan2=function(n,t){return Math.atan2(t[1]-n[1],t[0]-n[0])},r.radians=function(n){return n*(u/180)},r.degrees=function(n){return n/(u/180)},r.compute_angle=h,r.resolve_angle=h,r.invert_angle=function(n,t,r="anticlock"){return-("anticlock"==r?1:-1)*n/g(t)},r.to_radians_coeff=g,r.minmax=function(n,t){return n<=t?[n,t]:[t,n]},r.clamp=function(n,t,r){return n<t?t:n>r?r:n},r.cycle=function(n,t,r){return n>r?t:n<t?r:n},r.log=function(n,t=Math.E){return Math.log(n)/Math.log(t)},r.gcd=m,r.lcm=function(n,...t){for(const r of t)n=Math.floor(n*r/m(n,r));return n},r.float=Symbol("float"),r.is_Floating=function(n){return(0,a.isObject)(n)&&r.float in n};class _{constructor(n,t){(0,c.assert)(0!=t,"Zero divisor");const r=m(n,t),o=f(n)*f(t);this.numer=o*i(n)/r,this.denom=i(t)/r}[r.float](){return this.numer/this.denom}toString(){return`${this.numer}/${this.denom}`}}function d(n){let t=1;for(let r=2;r<=n;r++)t*=r;return t}r.Fraction=_,_.__name__="Fraction",r.float32_epsilon=1.1920928955078125e-7,r.factorial=d,r.hermite=function(n){const t=new Array(n+1);t.fill(0);const r=d(n);for(let o=0;o<=Math.floor(n/2);o++){const e=(-1)**o*r/(d(o)*d(n-2*o))*2**(n-2*o);t[2*o]=e}return t},r.eval_poly=function(n,t){let r=0,o=1;for(let e=n.length-1;e>=0;e--)r+=o*n[e],o*=t;return r}},
function _(r,e,n,o,s){o();class a extends Error{}n.AssertionError=a,a.__name__="AssertionError";class t extends Error{}function c(r,e){if(!(!0===r||!1!==r&&r()))throw new a(e??"Assertion failed")}n.UnreachableError=t,t.__name__="UnreachableError",n.assert=c,n.assert_debug=function(r,e){"undefined"!=typeof DEBUG&&DEBUG&&c(r,e)},n.unreachable=function(r){throw new t(`unreachable code${null!=r?`: ${r}`:""}`)}},
function _(n,t,e,r,o){r();const i=n(11),c=n(12),{floor:u}=Math;function f(n){const t=n.length;if(0==t)return!0;let e=n[0];for(let r=1;r<t;r++){const t=n[r];if(!(e<=t))return!1;e=t}return!0}function l(n,t,e,...r){const o=n.length;t<0&&(t+=o),t<0?t=0:t>o&&(t=o),null==e||e>o-t?e=o-t:e<0&&(e=0);const i=o-e+r.length,c=new n.constructor(i);let u=0;for(;u<t;u++)c[u]=n[u];for(const n of r)c[u++]=n;for(let r=t+e;r<o;r++)c[u++]=n[r];return c}function s(n,t){return l(n,t,n.length-t)}function a(n,t){return-1!==n.indexOf(t)}function h(n,t){const e=n.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=t(n[o],o,n);return r}function g(n,t,e){const r=n.length;if(void 0===e&&0==r)throw new Error("can't reduce an empty array without an initial value");let o,i;for(void 0===e?(o=n[0],i=1):(o=e,i=0);i<r;i++)o=t(o,n[i],i,n);return o}function d(n){return function(t,e){const r=t.length;let o=n>0?0:r-1;for(;o>=0&&o<r;o+=n)if(e(t[o]))return o;return-1}}function _(n,t,e,r=0,o=n.length){for((0,c.assert_debug)((()=>f(n))),(0,c.assert)(0<=r&&o<=n.length);r<o;){const i=u((r+o)/2);e(n[i])<t?r=i+1:o=i}return r}function m(n,t,e,r=0,o=n.length){for((0,c.assert_debug)((()=>f(n))),(0,c.assert)(0<=r&&o<=n.length);r<o;){const i=u((r+o)/2);e(n[i])<=t?r=i+1:o=i}return r}function y(n,t,e=0,r){return _(n,t,(n=>n),e,r)}function x(n,t,e,r,o){const i=(o-e)/(r-t);let c=i*(n-t)+e;return isFinite(c)||(c=i*(n-r)+o,isFinite(c)||e!=o||(c=e)),c}function w(n,t){if(n<t[0])return-1;if(n>t[t.length-1])return t.length;if(1==t.length)return 0;let e=0,r=t.length-1;for(;r-e!=1;){const o=e+Math.floor((r-e)/2);n>=t[o]?e=o:r=o}return e}e.is_empty=function(n){return 0==n.length},e.is_sorted=f,e.copy=function(n){return Array.isArray(n)?n.slice():new n.constructor(n)},e.splice=l,e.head=s,e.insert=function(n,t,e){return l(n,e,0,t)},e.append=function(n,t){return l(n,n.length,0,t)},e.prepend=function(n,t){return l(n,0,0,t)},e.index_of=function(n,t){return n.indexOf(t)},e.includes=a,e.contains=a,e.subselect=function(n,t){const e=t.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=n[t[o]];return r},e.mul=function(n,t,e){const r=n.length,o=e??new n.constructor(r);for(let e=0;e<r;e++)o[e]=n[e]*t;return o},e.map=h,e.inplace_map=function(n,t,e){const r=n.length,o=e??n;for(let e=0;e<r;e++)o[e]=t(n[e],e)},e.filter=function(n,t){const e=n.length,r=new n.constructor(e);let o=0;for(let i=0;i<e;i++){const e=n[i];t(e,i,n)&&(r[o++]=e)}return s(r,o)},e.reduce=g,e.sort_by=function(n,t){const e=Array.from(n,((n,e)=>({index:e,key:t(n)})));return e.sort(((n,t)=>{const e=n.key,r=t.key;if(e!==r){if(e>r)return 1;if(e<r)return-1}return n.index-t.index})),h(n,((t,r)=>n[e[r].index]))},e.min=function(n){let t=1/0;for(const e of n)!isNaN(e)&&e<t&&(t=e);return t},e.max=function(n){let t=-1/0;for(const e of n)!isNaN(e)&&e>t&&(t=e);return t},e.minmax=function(n){let t=1/0,e=-1/0;for(const r of n)isNaN(r)||(r<t&&(t=r),r>e&&(e=r));return[t,e]},e.minmax2=function(n,t){let e,r,o=1/0,i=-1/0,c=1/0,u=-1/0;const f=Math.min(n.length,t.length);for(let l=0;l<f;l++)e=n[l],r=t[l],isNaN(e)||isNaN(r)||(e<o&&(o=e),e>i&&(i=e),r<c&&(c=r),r>u&&(u=r));return[o,i,c,u]},e.min_by=function(n,t){if(0==n.length)throw new Error("min_by() called with an empty array");let e=n[0],r=t(e,0);for(let o=1,i=n.length;o<i;o++){const i=n[o],c=t(i,o);c<r&&(e=i,r=c)}return e},e.max_by=function(n,t){if(0==n.length)throw new Error("max_by() called with an empty array");let e=n[0],r=t(e,0);for(let o=1,i=n.length;o<i;o++){const i=n[o],c=t(i,o);c>r&&(e=i,r=c)}return e},e.sum=function(n){let t=0;for(let e=0,r=n.length;e<r;e++)t+=n[e];return t},e.cumsum=function(n){const t=new n.constructor(n.length);return g(n,((n,e,r)=>t[r]=n+e),0),t},e.every=function(n,t){for(const e of n)if(!t(e))return!1;return!0},e.some=function(n,t){for(const e of n)if(t(e))return!0;return!1},e.find_index=d(1),e.find_last_index=d(-1),e.find=function(n,t){const r=(0,e.find_index)(n,t);return-1==r?void 0:n[r]},e.find_last=function(n,t){const r=(0,e.find_last_index)(n,t);return-1==r?void 0:n[r]},e.bisect_left_by=_,e.bisect_right_by=m,e.bisect_left=y,e.bisect_right=function(n,t,e=0,r){return m(n,t,(n=>n),e,r)},e.binary_search=function(n,t){const e=y(n,t);return e!=n.length&&n[e]==t?e:null},e.sorted_index=y,e.bin_counts=function(n,t){const r=t.length-1,o=Array(r).fill(0);for(let c=0;c<n.length;c++){const u=n[c],f=(0,e.sorted_index)(t,u);o[(0,i.clamp)(f-1,0,r-1)]+=1}return o},e.interpolate=function(n,t,e){const r=n.length,o=new Array(r);for(let i=0;i<r;i++){const r=n[i];if(isNaN(r)||0==t.length){o[i]=NaN;continue}const c=w(r,t);if(-1==c)o[i]=e[0];else if(c==t.length)o[i]=e[e.length-1];else if(c==t.length-1||t[c]==r)o[i]=e[c];else{const n=t[c],u=e[c],f=t[c+1],l=e[c+1];o[i]=x(r,n,u,f,l)}}return o},e.left_edge_index=w,e.norm=function(n,t,e){const r=e-t;return h(n,(n=>(n-t)/r))}},
function _(t,e,s,n,i){var r;n();const o=t(1),c=t(15),a=t(17),h=o.__importStar(t(18)),_=o.__importStar(t(21)),u=t(12),l=t(40),f=t(9),p=t(8),d=t(26),g=t(32),y=t(41),m=t(26),v=t(42),w=t(31),b=o.__importStar(t(21)),S=t(28),$=t(43),x=new WeakMap;class P extends((0,c.Signalable)()){get is_syncable(){return!0}get type(){return this.constructor.__qualified__}static get __qualified__(){let t=x.get(this);if(null==t){const{__module__:e,__name__:s}=this;t=null!=e?`${e}.${s}`:s,x.set(this,t)}return t}static set __qualified__(t){x.set(this,t)}get[Symbol.toStringTag](){return this.constructor.__qualified__}static _fix_default(t,e){if(void 0===t||t===h.unset)return()=>h.unset;if((0,p.isFunction)(t))return t;if((0,p.isPrimitive)(t))return()=>t;{const e=new w.Cloner;return()=>e.clone(t)}}static define(t){for(const[e,s]of(0,f.entries)((0,p.isFunction)(t)?t(b):t)){if(e in this.prototype._props)throw new Error(`attempted to redefine property '${this.prototype.type}.${e}'`);if(e in this.prototype)throw new Error(`attempted to redefine attribute '${this.prototype.type}.${e}'`);Object.defineProperty(this.prototype,e,{get(){return this.properties[e].get_value()},set(t){return this.setv({[e]:t}),this},configurable:!1,enumerable:!0});const[t,n,i={}]=s,r={type:t,default_value:this._fix_default(n,e),options:i};this.prototype._props={...this.prototype._props,[e]:r}}}static internal(t){const e={};for(const[s,n]of(0,f.entries)((0,p.isFunction)(t)?t(b):t)){const[t,i,r={}]=n;e[s]=[t,i,{...r,internal:!0}]}this.define(e)}static mixins(t){function e(t,e){const s={};for(const[n,i]of(0,f.entries)(e))s[t+n]=i;return s}const s={},n=[];for(const i of(0,p.isArray)(t)?t:[t])if((0,p.isArray)(i)){const[t,r]=i;(0,f.extend)(s,e(t,r)),n.push([t,r])}else{const t=i;(0,f.extend)(s,t),n.push(["",t])}this.define(s),this.prototype._mixins=[...this.prototype._mixins,...n]}static override(t){for(const[e,s]of(0,f.entries)(t)){const t=this._fix_default(s,e);if(!(e in this.prototype._props))throw new Error(`attempted to override nonexistent '${this.prototype.type}.${e}'`);const n=this.prototype._props[e],i={...this.prototype._props};i[e]={...n,default_value:t},this.prototype._props=i}}static toString(){return this.__qualified__}toString(){return`${this.type}(${this.id})`}property(t){if(t in this.properties)return this.properties[t];throw new Error(`unknown property ${this.type}.${t}`)}get attributes(){const t={};for(const e of this)e.is_unset||(t[e.attr]=e.get_value());return t}[w.clone](t){const e=new Map;for(const s of this)s.dirty&&e.set(s.attr,t.clone(s.get_value()));return new this.constructor(e)}[m.equals](t,e){for(const s of this){const n=t.property(s.attr);if(!e.eq(s.get_value(),n.get_value()))return!1}return!0}[v.pretty](t){const e=t.token,s=[];for(const n of this)if(n.dirty){const i=n.get_value();s.push(`${n.attr}${e(":")} ${t.to_string(i)}`)}return`${this.constructor.__qualified__}${e("(")}${e("{")}${s.join(`${e(",")} `)}${e("}")}${e(")")}`}[g.serialize](t){const e=this.ref();t.add_ref(this,e);const s={};for(const e of this)if(e.syncable&&(t.include_defaults||e.dirty)&&(!e.readonly||!e.is_unset)){const n=e.get_value();s[e.attr]=t.encode(n)}const{type:n,id:i}=this,r={type:"object",name:n,id:i};return(0,f.is_empty)(s)?r:{...r,attributes:s}}constructor(t={}){super(),this.document=null,this.destroyed=new c.Signal0(this,"destroyed"),this.change=new c.Signal0(this,"change"),this.transformchange=new c.Signal0(this,"transformchange"),this.exprchange=new c.Signal0(this,"exprchange"),this.streaming=new c.Signal0(this,"streaming"),this.patching=new c.Signal(this,"patching"),this.properties={},this._watchers=new WeakMap,this._pending=!1,this._changing=!1;const e=(0,p.isPlainObject)(t)&&"id"in t;this.id=e?t.id:(0,l.unique_id)();for(const[t,{type:e,default_value:s,options:n}]of(0,f.entries)(this._props)){let i;if(e instanceof h.PropertyAlias){const s=this.properties[e.attr];if(void 0===s)throw new Error(`can't resolve ${e.attr} before ${t} to create an alias`);Object.defineProperty(this.properties,t,{get:()=>s,configurable:!1,enumerable:!1})}else i=e instanceof _.Kind?new h.PrimitiveProperty(this,t,e,s,n):new e(this,t,_.Any,s,n),this.properties[t]=i}e?(0,u.assert)(1==(0,f.keys)(t).length,"'id' cannot be used together with property initializers"):(this.initialize_props(t),this.finalize(),this.connect_signals())}initialize_props(t){const e=(0,f.dict)(t),s=new Set;for(const t of this){const n=e.get(t.attr);t.initialize(n),s.add(t.attr)}for(const[t,n]of e)s.has(t)||this.property(t).set_value(n)}finalize(){this.initialize()}initialize(){}assert_initialized(){for(const t of this)t.syncable&&!t.readonly&&t.get_value()}connect_signals(){for(const t of this){if(!(t instanceof h.VectorSpec||t instanceof h.ScalarSpec))continue;if(t.is_unset)continue;const e=t.get_value();null!=e.transform&&this.connect(e.transform.change,(()=>this.transformchange.emit())),(0,S.isExpr)(e)&&this.connect(e.expr.change,(()=>this.exprchange.emit()))}}disconnect_signals(){c.Signal.disconnect_receiver(this)}destroy(){this.disconnect_signals(),this.destroyed.emit()}clone(){return(new w.Cloner).clone(this)}_clear_watchers(){this._watchers=new WeakMap}changed_for(t){const e=this._watchers.get(t);return this._watchers.set(t,!1),e??!0}_setv(t,e){const s=e.check_eq,n=new Set,i=this._changing;this._changing=!0;for(const[e,i]of t)!1!==s&&!e.is_unset&&(0,d.is_equal)(e.get_value(),i)||(e.set_value(i),n.add(e));n.size>0&&(this._clear_watchers(),this._pending=!0);for(const t of n)t.change.emit();if(!i){if(!e.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}return n}setv(t,e={}){const s=(0,f.entries)(t);if(0==s.length)return;if(e.silent){this._clear_watchers();for(const[t,e]of s)this.properties[t].set_value(e);return}const n=new Map,i=new Map;for(const[t,e]of s){const s=this.properties[t];n.set(s,e),i.set(s,s.is_unset?void 0:s.get_value())}const r=this._setv(n,e),{document:o}=this;if(null!=o){const t=[];for(const[e,s]of i)r.has(e)&&t.push([e,s,e.get_value()]);for(const[e,s,n]of t)if(e.may_have_refs&&this._needs_invalidate(s,n)){o._invalidate_all_models();break}const s=e.sync??!0;this._push_changes(t,s)}}ref(){return{id:this.id}}*[Symbol.iterator](){yield*(0,f.values)(this.properties)}*syncable_properties(){for(const t of this)t.syncable&&(yield t)}*own_properties(){const t=Object.getPrototypeOf(this),e=Object.getPrototypeOf(t),s=new Set((0,f.keys)(e._props));for(const t of this)s.has(t.attr)||(yield t)}static _value_record_references(t,e,s){if(!(0,p.isObject)(t)||!(0,a.may_have_refs)(t))return;const{recursive:n}=s;if(t instanceof r){if(!e.has(t)&&(e.add(t),n))for(const s of t.syncable_properties())if(!s.is_unset&&s.may_have_refs){const t=s.get_value();r._value_record_references(t,e,{recursive:n})}}else if((0,p.isIterable)(t))for(const s of t)r._value_record_references(s,e,{recursive:n});else if((0,p.isPlainObject)(t))for(const s of(0,f.values)(t))r._value_record_references(s,e,{recursive:n})}static references(t,e){const s=new Set;return r._value_record_references(t,s,e),s}references(){return r.references(this,{recursive:!0})}_doc_attached(){}_doc_detached(){}attach_document(t){if(null!=this.document){if(this.document==t)return;throw new Error("models must be owned by only a single document")}this.document=t,this._doc_attached()}detach_document(){this._doc_detached(),this.document=null}_needs_invalidate(t,e){const s=new Set;r._value_record_references(e,s,{recursive:!1});const n=new Set;r._value_record_references(t,n,{recursive:!1});for(const t of s)if(!n.has(t))return!0;for(const t of n)if(!s.has(t))return!0;return!1}_push_changes(t,e){if(!this.is_syncable)return;const{document:s}=this;if(null==s)return;const n=[];for(const[i,,r]of t)if(i.syncable){const t=new y.ModelChangedEvent(s,this,i.attr,r);t.sync=e,n.push(t)}if(0!=n.length){let t;1==n.length?[t]=n:t=new y.DocumentEventBatch(s,n),s._trigger_on_change(t)}}on_change(t,e){for(const s of(0,p.isArray)(t)?t:[t])this.connect(s.change,e)}stream_to(t,e,s,{sync:n}={}){const i=t.get_value();if((0,$.stream_to_columns)(i,e,s),this._clear_watchers(),t.set_value(i),this.streaming.emit(),null!=this.document){const i=new y.ColumnsStreamedEvent(this.document,this,t.attr,e,s);i.sync=n??!0,this.document._trigger_on_change(i)}}patch_to(t,e,{sync:s}={}){const n=t.get_value(),i=(0,$.patch_to_columns)(n,e);if(this._clear_watchers(),t.set_value(n),this.patching.emit([...i]),null!=this.document){const n=new y.ColumnsPatchedEvent(this.document,this,t.attr,e);n.sync=s??!0,this.document._trigger_on_change(n)}}}s.HasProps=P,(r=P).prototype._props={},r.prototype._mixins=[]},
function _(n,e,t,s,r){s();const l=n(16),i=n(10);class o{constructor(n,e){this.sender=n,this.name=e}connect(n,e=null){t.receivers_for_sender.has(this.sender)||t.receivers_for_sender.set(this.sender,[]);const s=t.receivers_for_sender.get(this.sender);if(null!=f(s,this,n,e))return!1;const r=e??n;u.has(r)||u.set(r,[]);const l=u.get(r),i={signal:this,slot:n,context:e};return s.push(i),l.push(i),!0}disconnect(n,e=null){const s=t.receivers_for_sender.get(this.sender);if(null==s||0===s.length)return!1;const r=f(s,this,n,e);if(null==r)return!1;const l=e??n,i=u.get(l);return r.signal=null,g(s),g(i),!0}emit(n){const e=t.receivers_for_sender.get(this.sender)??[];for(const{signal:t,slot:s,context:r}of e)t===this&&s.call(r,n,this.sender)}}t.Signal=o,o.__name__="Signal";class c extends o{emit(){super.emit(void 0)}}t.Signal0=c,c.__name__="Signal0",function(n){n.disconnect_between=function(n,e){const s=t.receivers_for_sender.get(n);if(null==s||0===s.length)return;const r=u.get(e);if(null!=r&&0!==r.length){for(const e of r){if(null==e.signal)return;e.signal.sender===n&&(e.signal=null)}g(s),g(r)}},n.disconnect_sender=function(n){const e=t.receivers_for_sender.get(n);if(null!=e&&0!==e.length){for(const n of e){if(null==n.signal)return;const e=n.context??n.slot;n.signal=null,g(u.get(e))}g(e)}},n.disconnect_receiver=function(n,e,s){const r=u.get(n);if(null!=r&&0!==r.length){for(const n of r){if(null==n.signal)return;if(null!=e&&n.slot!=e)continue;const r=n.signal.sender;null!=s&&s.has(r)||(n.signal=null,g(t.receivers_for_sender.get(r)))}g(r)}},n.disconnect_all=function(n){const e=t.receivers_for_sender.get(n);if(null!=e&&0!==e.length){for(const n of e)n.signal=null;g(e)}const s=u.get(n);if(null!=s&&0!==s.length){for(const n of s)n.signal=null;g(s)}}}(o||(t.Signal=o={})),t.Signalable=function(){return class{connect(n,e){return n.connect(e,this)}disconnect(n,e){return n.disconnect(e,this)}}},t.receivers_for_sender=new WeakMap;const u=new WeakMap;function f(n,e,t,s){return(0,i.find)(n,(n=>n.signal===e&&n.slot===t&&n.context===s))}const a=new Set;function g(n){0==a.size&&(async()=>{await(0,l.defer)(),function(){for(const n of a)(0,i.remove_by)(n,(n=>null==n.signal));a.clear()}()})(),a.add(n)}},
function _(e,n,t,o,r){o();const s=new MessageChannel,i=new Map;s.port1.onmessage=e=>{const n=e.data,t=i.get(n);if(null!=t)try{t()}finally{i.delete(n)}};let a=1;function l(e){return new Promise((n=>setTimeout(n,e)))}t.defer=function(){return new Promise((e=>{const n=a++;i.set(n,e),s.port2.postMessage(n)}))},t.delay=l,t.poll=async function(e,n=50,t=500){for(;!e()&&t>=0;)await l(n),t-=n},t.paint=function(){return new Promise((e=>{requestAnimationFrame((()=>e()))}))},t.idle=function(){return new Promise((e=>{requestIdleCallback((()=>e()))}))}},
function _(s,n,r,e,t){e();const i=s(8);function f(s){return r.has_refs in s}r.is_ref=function(s){return(0,i.isPlainObject)(s)&&"id"in s&&!("type"in s)},r.has_refs=Symbol("has_refs"),r._is_HasRefs=f,r.is_HasRefs=function(s){return(0,i.isObject)(s)&&f(s)},r.may_have_refs=function(s){if(f(s))return s[r.has_refs];const n=s.constructor;return!f(n)||n[r.has_refs]}},
function _(e,t,r,n,a){n(),r.TextBaselineSpec=r.TextAlignSpec=r.FontStyleSpec=r.FontSizeSpec=r.FontSpec=r.LineDashSpec=r.LineCapSpec=r.LineJoinSpec=r.MarkerSpec=r.ArraySpec=r.NullStringSpec=r.StringSpec=r.AnySpec=r.NDArraySpec=void 0;const s=e(1),i=e(15),l=e(19),_=s.__importStar(e(20)),o=e(24),c=e(10),u=e(13),d=e(11),S=e(22),p=e(27),h=e(8),m=e(28),f=e(29),v=e(30),y=e(38),x=e(12),g=e(32),A=e(39);function w(e){try{return JSON.stringify(e)}catch{return e.toString()}}function z(e){return(0,h.isPlainObject)(e)&&(void 0===e.value?0:1)+(void 0===e.field?0:1)+(void 0===e.expr?0:1)==1}a("Uniform",A.Uniform),a("UniformScalar",A.UniformScalar),a("UniformVector",A.UniformVector),r.isSpec=z;let b=null;r.use_theme=function(e=null){b=e},r.unset=Symbol("unset");class C extends Error{}r.UnsetValueError=C,C.__name__="UnsetValueError";class F{get syncable(){return!this.internal}get is_unset(){return this._value===r.unset}get initialized(){return this._initialized}initialize(e=r.unset){if(this._initialized)throw new Error("already initialized");let t=r.unset;if(e!==r.unset)t=e,this._dirty=!0;else{const e=this._default_override();if(e!==r.unset)t=e;else{let e=!1;if(null!=b){const r=b.get(this.obj,this.attr);void 0!==r&&(t=r,e=!0)}e||(t=this.default_value(this.obj))}}t!==r.unset?(null!=this.kind.coerce&&(t=this.kind.coerce(t)),this._update(t)):this._value=r.unset,this._initialized=!0}get_value(){if(this._value!==r.unset)return this._value;throw new C(`${this.obj}.${this.attr} is unset`)}set_value(e){this._initialized?(this._update(e),this._dirty=!0):this.initialize(e),y.diagnostics.report(this)}_default_override(){return r.unset}get dirty(){return this._dirty}constructor(e,t,n,a,s={}){this._value=r.unset,this._initialized=!1,this._dirty=!1,this.obj=e,this.attr=t,this.kind=n,this.default_value=a,this.change=new i.Signal0(this.obj,"change"),this.internal=s.internal??!1,this.readonly=s.readonly??!1,this.convert=s.convert,this.on_update=s.on_update,this.may_have_refs=n.may_have_refs()}_update(e){if(this.validate(e),null!=this.convert){const t=this.convert(e,this.obj);void 0!==t&&(e=t)}this._value=e,this.on_update?.(e,this.obj)}toString(){return`Prop(${this.obj}.${this.attr}, value: ${w(this._value)})`}normalize(e){return e}validate(e){if(!this.valid(e))throw new Error(`${this.obj}.${this.attr} given invalid value: ${w(e)}`)}valid(e){return this.kind.valid(e)}}r.Property=F,F.__name__="Property";class q{constructor(e){this.attr=e}}r.PropertyAlias=q,q.__name__="PropertyAlias",r.Alias=function(e){return new q(e)};class N extends F{}r.PrimitiveProperty=N,N.__name__="PrimitiveProperty";class U extends N{_default_override(){return f.settings.dev?"Bokeh":r.unset}}r.Font=U,U.__name__="Font";class $ extends F{constructor(){super(...arguments),this._value=r.unset}get_value(){if(this._value!==r.unset)return this._value;throw new Error(`${this.obj}.${this.attr} is unset`)}_update(e){if(z(e)?this._value=e:this._value={value:e},(0,h.isPlainObject)(this._value)){const{_value:e}=this;this._value[g.serialize]=t=>{const{value:r,field:n,expr:a,transform:s,units:i}=e;return t.encode_struct(void 0!==r?{type:"value",value:r,transform:s,units:i}:void 0!==n?{type:"field",field:n,transform:s,units:i}:{type:"expr",expr:a,transform:s,units:i})}}(0,m.isValue)(this._value)&&this.validate(this._value.value)}materialize(e){return e}scalar(e,t){return new A.UniformScalar(e,t)}uniform(e){const t=this.get_value(),r=e.get_length()??1;if((0,m.isExpr)(t)){const{expr:n,transform:a}=t;let s=n.compute(e);return null!=a&&(s=a.compute(s)),s=this.materialize(s),this.scalar(s,r)}{const{value:e,transform:n}=t;let a=e;return null!=n&&(a=n.compute(a)),a=this.materialize(a),this.scalar(a,r)}}}r.ScalarSpec=$,$.__name__="ScalarSpec";class j extends ${}r.AnyScalar=j,j.__name__="AnyScalar";class D extends ${}r.DictScalar=D,D.__name__="DictScalar";class B extends ${}r.ColorScalar=B,B.__name__="ColorScalar";class E extends ${}r.NumberScalar=E,E.__name__="NumberScalar";class L extends ${}r.StringScalar=L,L.__name__="StringScalar";class P extends ${}r.NullStringScalar=P,P.__name__="NullStringScalar";class T extends ${}r.ArrayScalar=T,T.__name__="ArrayScalar";class V extends ${}r.LineJoinScalar=V,V.__name__="LineJoinScalar";class k extends ${}r.LineCapScalar=k,k.__name__="LineCapScalar";class J extends ${}r.LineDashScalar=J,J.__name__="LineDashScalar";class X extends ${_default_override(){return f.settings.dev?"Bokeh":r.unset}}r.FontScalar=X,X.__name__="FontScalar";class Y extends ${}r.FontSizeScalar=Y,Y.__name__="FontSizeScalar";class G extends ${}r.FontStyleScalar=G,G.__name__="FontStyleScalar";class I extends ${}r.TextAlignScalar=I,I.__name__="TextAlignScalar";class O extends ${}r.TextBaselineScalar=O,O.__name__="TextBaselineScalar";class R extends F{constructor(){super(...arguments),this._value=r.unset}get_value(){if(this._value!==r.unset)return this._value;throw new Error(`${this.obj}.${this.attr} is unset`)}_update(e){if(z(e)?this._value=e:this._value={value:e},(0,h.isPlainObject)(this._value)){const{_value:e}=this;this._value[g.serialize]=t=>{const{value:r,field:n,expr:a,transform:s,units:i}=e;return t.encode_struct(void 0!==r?{type:"value",value:r,transform:s,units:i}:void 0!==n?{type:"field",field:n,transform:s,units:i}:{type:"expr",expr:a,transform:s,units:i})}}(0,m.isValue)(this._value)&&this.validate(this._value.value)}materialize(e){return e}v_materialize(e){return e}scalar(e,t){return new A.UniformScalar(e,t)}vector(e){return new A.UniformVector(e)}uniform(e){const t=this.get_value(),r=e.get_length()??1;if((0,m.isField)(t)){const{field:n,transform:a}=t;let s=e.get_column(n);if(null!=s)return null!=a&&(s=a.v_compute(s)),s=this.v_materialize(s),this.vector(s);{const e=`attempted to retrieve property array for nonexistent field '${n}'`;if(f.settings.force_fields)throw new Error(e);return l.logger.warn(e),this.scalar(null,r)}}if((0,m.isExpr)(t)){const{expr:r,transform:n}=t;let a=r.v_compute(e);return null!=n&&(a=n.v_compute(a)),a=this.v_materialize(a),this.vector(a)}if((0,m.isValue)(t)){const{value:e,transform:n}=t;let a=e;return null!=n&&(a=n.compute(a)),a=this.materialize(a),this.scalar(a,r)}(0,x.unreachable)()}array(e){let t;const r=e.get_length()??1,n=this.get_value();if((0,m.isField)(n)){const{field:a}=n,s=e.get_column(a);if(null!=s)t=this.normalize(s);else{const e=`attempted to retrieve property array for nonexistent field '${a}'`;if(f.settings.force_fields)throw new Error(e);l.logger.warn(e);const n=new Float64Array(r);n.fill(NaN),t=n}}else if((0,m.isExpr)(n)){const{expr:r}=n;t=this.normalize(r.v_compute(e))}else{const e=this.normalize([n.value])[0];if((0,h.isNumber)(e)){const n=new Float64Array(r);n.fill(e),t=n}else t=(0,c.repeat)(e,r)}const{transform:a}=n;return null!=a&&(t=a.v_compute(t)),t}}r.VectorSpec=R,R.__name__="VectorSpec";class M extends R{}r.DataSpec=M,M.__name__="DataSpec";class H extends R{constructor(){super(...arguments),this._value=r.unset}_update(e){if(super._update(e),this._value!==r.unset){const{units:e}=this._value;if(null!=e&&!(0,c.includes)(this.valid_units,e))throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${e}`)}}get units(){return this._value!==r.unset?this._value.units??this.default_units:this.default_units}set units(e){if(this._value===r.unset)throw new Error(`${this.obj}.${this.attr} is unset`);e!=this.default_units?this._value.units=e:delete this._value.units}}r.UnitsSpec=H,H.__name__="UnitsSpec";class K extends H{array(e){return new Float64Array(super.array(e))}}r.NumberUnitsSpec=K,K.__name__="NumberUnitsSpec";class Q extends M{}r.BaseCoordinateSpec=Q,Q.__name__="BaseCoordinateSpec";class W extends Q{}r.CoordinateSpec=W,W.__name__="CoordinateSpec";class Z extends Q{}r.CoordinateSeqSpec=Z,Z.__name__="CoordinateSeqSpec";class ee extends Q{}r.CoordinateSeqSeqSeqSpec=ee,ee.__name__="CoordinateSeqSeqSeqSpec";class te extends W{constructor(){super(...arguments),this.dimension="x"}}r.XCoordinateSpec=te,te.__name__="XCoordinateSpec";class re extends W{constructor(){super(...arguments),this.dimension="y"}}r.YCoordinateSpec=re,re.__name__="YCoordinateSpec";class ne extends Z{constructor(){super(...arguments),this.dimension="x"}}r.XCoordinateSeqSpec=ne,ne.__name__="XCoordinateSeqSpec";class ae extends Z{constructor(){super(...arguments),this.dimension="y"}}r.YCoordinateSeqSpec=ae,ae.__name__="YCoordinateSeqSpec";class se extends ee{constructor(){super(...arguments),this.dimension="x"}}r.XCoordinateSeqSeqSeqSpec=se,se.__name__="XCoordinateSeqSeqSeqSpec";class ie extends ee{constructor(){super(...arguments),this.dimension="y"}}r.YCoordinateSeqSeqSeqSpec=ie,ie.__name__="YCoordinateSeqSeqSeqSpec";class le extends K{get default_units(){return"rad"}get valid_units(){return[..._.AngleUnits]}materialize(e){return e*-(0,d.to_radians_coeff)(this.units)}v_materialize(e){const t=-(0,d.to_radians_coeff)(this.units),r=new Float32Array(e.length);return(0,u.mul)(e,t,r),r}array(e){throw new Error("not supported")}}r.AngleSpec=le,le.__name__="AngleSpec";class _e extends K{get default_units(){return"data"}get valid_units(){return[..._.SpatialUnits]}}r.DistanceSpec=_e,_e.__name__="DistanceSpec";class oe extends _e{materialize(e){return e??NaN}}r.NullDistanceSpec=oe,oe.__name__="NullDistanceSpec";class ce extends M{v_materialize(e){return new Uint8Array(e)}array(e){return new Uint8Array(super.array(e))}}r.BooleanSpec=ce,ce.__name__="BooleanSpec";class ue extends M{v_materialize(e){return(0,h.isTypedArray)(e)?e:new Int32Array(e)}array(e){return new Int32Array(super.array(e))}}r.IntSpec=ue,ue.__name__="IntSpec";class de extends M{v_materialize(e){return(0,h.isTypedArray)(e)?e:new Float64Array(e)}array(e){return new Float64Array(super.array(e))}}r.NumberSpec=de,de.__name__="NumberSpec";class Se extends de{valid(e){return(0,h.isNumber)(e)&&e>=0}}r.ScreenSizeSpec=Se,Se.__name__="ScreenSizeSpec";class pe extends M{materialize(e){return(0,S.encode_rgba)((0,S.color2rgba)(e))}v_materialize(e){if(!(0,v.is_NDArray)(e))return this._from_css_array(e);if("uint32"==e.dtype&&1==e.dimension)return(0,p.to_big_endian)(e);if("uint8"==e.dtype&&1==e.dimension){const[t]=e.shape,r=new o.RGBAArray(4*t);let n=0;for(const t of e)r[n++]=t,r[n++]=t,r[n++]=t,r[n++]=255;return new o.ColorArray(r.buffer)}if("uint8"==e.dtype&&2==e.dimension){const[t,r]=e.shape;if(4==r)return new o.ColorArray(e.buffer);if(3==r){const n=new o.RGBAArray(4*t);for(let a=0,s=0;a<r*t;)n[s++]=e[a++],n[s++]=e[a++],n[s++]=e[a++],n[s++]=255;return new o.ColorArray(n.buffer)}}else if("float32"!=e.dtype&&"float64"!=e.dtype||2!=e.dimension){if("object"==e.dtype&&1==e.dimension)return this._from_css_array(e)}else{const[t,r]=e.shape;if(3==r||4==r){const n=new o.RGBAArray(4*t);for(let a=0,s=0;a<r*t;)n[s++]=255*e[a++],n[s++]=255*e[a++],n[s++]=255*e[a++],n[s++]=255*(3==r?1:e[a++]);return new o.ColorArray(n.buffer)}}throw new Error("invalid color array")}_from_css_array(e){const t=e.length,r=new o.RGBAArray(4*t);let n=0;for(const t of e){const[e,a,s,i]=(0,S.color2rgba)(t);r[n++]=e,r[n++]=a,r[n++]=s,r[n++]=i}return new o.ColorArray(r.buffer)}vector(e){return new A.ColorUniformVector(e)}}r.ColorSpec=pe,pe.__name__="ColorSpec";class he extends M{}r.NDArraySpec=he,he.__name__="NDArraySpec";class me extends M{}r.AnySpec=me,me.__name__="AnySpec";class fe extends M{}r.StringSpec=fe,fe.__name__="StringSpec";class ve extends M{}r.NullStringSpec=ve,ve.__name__="NullStringSpec";class ye extends M{}r.ArraySpec=ye,ye.__name__="ArraySpec";class xe extends M{}r.MarkerSpec=xe,xe.__name__="MarkerSpec";class ge extends M{}r.LineJoinSpec=ge,ge.__name__="LineJoinSpec";class Ae extends M{}r.LineCapSpec=Ae,Ae.__name__="LineCapSpec";class we extends M{}r.LineDashSpec=we,we.__name__="LineDashSpec";class ze extends M{_default_override(){return f.settings.dev?"Bokeh":r.unset}}r.FontSpec=ze,ze.__name__="FontSpec";class be extends M{}r.FontSizeSpec=be,be.__name__="FontSizeSpec";class Ce extends M{}r.FontStyleSpec=Ce,Ce.__name__="FontStyleSpec";class Fe extends M{}r.TextAlignSpec=Fe,Fe.__name__="TextAlignSpec";class qe extends M{}r.TextBaselineSpec=qe,qe.__name__="TextBaselineSpec"},
function _(e,l,o,t,n){t();const g=e(8),r=e(9),s=e(3),i={};class v{constructor(e,l,o){this.name=e,this.level=l,this.method=o}}o.LogLevel=v,v.__name__="LogLevel";class _{static get levels(){return Object.keys(_.log_levels)}static get(e,l=_.INFO){if(e.length>0)return e in i?i[e]:i[e]=new _(e,l);throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")}constructor(e,l=_.INFO){this._name=e,this.set_level(l)}get level(){return this.get_level()}get_level(){return this._log_level}set_level(e){if(e instanceof v)this._log_level=e;else{if(!_.log_levels.hasOwnProperty(e))throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=_.log_levels[e]}const l=`[${this._name}]`;for(const{level:e,method:o}of(0,r.values)(_.log_levels))e<this._log_level.level||this._log_level.level===_.OFF.level?this[o]=function(){}:this[o]=a(o,l);this.log=a("log",l)}log(...e){}trace(...e){}debug(...e){}info(...e){}warn(...e){}error(...e){}}function a(e,l){const o=console[e];return(void 0!==o?o:console.log).bind(console,l)}function c(e){const l=o.logger.level;return(0,g.isString)(e)&&!(e in _.log_levels)?(o.logger.log(`unrecognized logging level '${e}' passed to Bokeh.set_log_level(), ignoring`),o.logger.log(`valid log levels are: ${_.levels.join(", ")}`)):(o.logger.log(`setting log level to: '${(0,g.isString)(e)?e:e.level}'`),o.logger.set_level(e)),l}o.Logger=_,_.__name__="Logger",_.TRACE=new v("trace",0,"trace"),_.DEBUG=new v("debug",1,"debug"),_.INFO=new v("info",2,"info"),_.WARN=new v("warn",6,"warn"),_.ERROR=new v("error",7,"error"),_.FATAL=new v("fatal",8,"error"),_.OFF=new v("off",9,"log"),_.log_levels={trace:_.TRACE,debug:_.DEBUG,info:_.INFO,warn:_.WARN,error:_.ERROR,fatal:_.FATAL,off:_.OFF},o.logger=_.get(`bokeh ${s.version}`),o.set_log_level=c,o.with_log_level=function(e,l){const o=c(e);try{l()}finally{c(o)}}},
function _(e,t,n,o,i){o(),n.ToolIcon=n.VerticalAlign=n.UpdateMode=n.TooltipAttachment=n.LabelOrientation=n.TextureRepetition=n.TextBaseline=n.TextAlign=n.TapGesture=n.TapBehavior=n.StepMode=n.StartEnd=n.SpatialUnits=n.Sort=void 0;const a=e(21);n.Align=(0,a.Enum)("start","center","end"),n.HAlign=(0,a.Enum)("left","center","right"),n.VAlign=(0,a.Enum)("top","center","bottom"),n.Anchor=(0,a.Enum)("top_left","top_center","top_right","center_left","center_center","center_right","bottom_left","bottom_center","bottom_right","top","left","center","right","bottom"),n.AngleUnits=(0,a.Enum)("deg","rad","grad","turn"),n.AlternationPolicy=(0,a.Enum)("none","even","odd","every"),n.BoxOrigin=(0,a.Enum)("corner","center"),n.ButtonType=(0,a.Enum)("default","primary","success","warning","danger","light"),n.CalendarPosition=(0,a.Enum)("auto","above","below"),n.Clock=(0,a.Enum)("12h","24h"),n.CoordinateUnits=(0,a.Enum)("canvas","screen","data"),n.ContextWhich=(0,a.Enum)("start","center","end","all"),n.Dimension=(0,a.Enum)("width","height"),n.Dimensions=(0,a.Enum)("width","height","both"),n.Direction=(0,a.Enum)("clock","anticlock"),n.Distribution=(0,a.Enum)("uniform","normal"),n.Face=(0,a.Enum)("front","back"),n.FlowMode=(0,a.Enum)("block","inline"),n.FontStyle=(0,a.Enum)("normal","italic","bold","bold italic"),n.HatchPatternType=(0,a.Enum)("blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"),n.HTTPMethod=(0,a.Enum)("POST","GET"),n.HexTileOrientation=(0,a.Enum)("pointytop","flattop"),n.HoverMode=(0,a.Enum)("mouse","hline","vline"),n.ImageOrigin=(0,a.Enum)("bottom_left","top_left","bottom_right","top_right"),n.LatLon=(0,a.Enum)("lat","lon"),n.LegendClickPolicy=(0,a.Enum)("none","hide","mute"),n.LegendLocation=n.Anchor,n.LineCap=(0,a.Enum)("butt","round","square"),n.LineDash=(0,a.Enum)("solid","dashed","dotted","dotdash","dashdot"),n.LineJoin=(0,a.Enum)("miter","round","bevel"),n.LinePolicy=(0,a.Enum)("prev","next","nearest","interp","none"),n.Location=(0,a.Enum)("above","below","left","right"),n.Logo=(0,a.Enum)("normal","grey"),n.MapType=(0,a.Enum)("satellite","roadmap","terrain","hybrid"),n.MarkerType=(0,a.Enum)("asterisk","circle","circle_cross","circle_dot","circle_x","circle_y","cross","dash","diamond","diamond_cross","diamond_dot","dot","hex","hex_dot","inverted_triangle","plus","square","square_cross","square_dot","square_pin","square_x","star","star_dot","triangle","triangle_dot","triangle_pin","x","y"),n.MutedPolicy=(0,a.Enum)("show","ignore"),n.Orientation=(0,a.Enum)("vertical","horizontal"),n.OutputBackend=(0,a.Enum)("canvas","svg","webgl"),n.PaddingUnits=(0,a.Enum)("percent","absolute"),n.Place=(0,a.Enum)("above","below","left","right","center"),n.PointPolicy=(0,a.Enum)("snap_to_data","follow_mouse","none"),n.RadiusDimension=(0,a.Enum)("x","y","max","min"),n.RenderLevel=(0,a.Enum)("image","underlay","glyph","guide","annotation","overlay"),n.ResetPolicy=(0,a.Enum)("standard","event_only"),n.ResolutionType=(0,a.Enum)("microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"),n.RoundingFunction=(0,a.Enum)("round","nearest","floor","rounddown","ceil","roundup"),n.ScrollbarPolicy=(0,a.Enum)("auto","visible","hidden"),n.SelectionMode=(0,a.Enum)("replace","append","intersect","subtract","xor"),n.Side=(0,a.Enum)("above","below","left","right"),n.SizingMode=(0,a.Enum)("stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed","inherit"),n.Sort=(0,a.Enum)("ascending","descending"),n.SpatialUnits=(0,a.Enum)("screen","data"),n.StartEnd=(0,a.Enum)("start","end"),n.StepMode=(0,a.Enum)("after","before","center"),n.TapBehavior=(0,a.Enum)("select","inspect"),n.TapGesture=(0,a.Enum)("tap","doubletap"),n.TextAlign=(0,a.Enum)("left","right","center"),n.TextBaseline=(0,a.Enum)("top","middle","bottom","alphabetic","hanging","ideographic"),n.TextureRepetition=(0,a.Enum)("repeat","repeat_x","repeat_y","no_repeat"),n.LabelOrientation=(0,a.Enum)("vertical","horizontal","parallel","normal"),n.TooltipAttachment=(0,a.Enum)("horizontal","vertical","left","right","above","below"),n.UpdateMode=(0,a.Enum)("replace","append"),n.VerticalAlign=(0,a.Enum)("top","middle","bottom"),n.ToolIcon=(0,a.Enum)("append_mode","arrow_down_to_bar","arrow_up_from_bar","auto_box_zoom","bold","box_edit","box_select","box_zoom","caret_down","caret_left","caret_right","caret_up","check","chevron_down","chevron_left","chevron_right","chevron_up","clear_selection","copy","crosshair","delete","freehand_draw","fullscreen","help","hover","intersect_mode","invert_selection","italic","lasso_select","line_edit","maximize","minimize","pan","pin","point_draw","pointer","poly_draw","poly_edit","polygon_select","range","redo","replace_mode","reset","save","see_off","see_on","settings","square","square_check","subtract_mode","tap_select","text_align_center","text_align_left","text_align_right","undo","unknown","unpin","wheel_pan","wheel_zoom","x_box_select","x_box_zoom","x_grip","x_pan","xor_mode","y_box_select","y_box_zoom","y_grip","y_pan","zoom_in","zoom_out")},
function _(e,t,r,n,s){n();const i=e(1).__importStar(e(8)),a=e(22),_=e(9),o=e(17),u=globalThis.Map,l=globalThis.Set,y=globalThis.Node;class c{}r.Kind=c,c.__name__="Kind",function(e){class t extends c{may_have_refs(){return!1}}t.__name__="Primitive",e.Primitive=t;class r extends t{valid(e){return void 0!==e}toString(){return"Any"}may_have_refs(){return!0}}r.__name__="Any",e.Any=r;class n extends t{valid(e){return void 0!==e}toString(){return"Unknown"}may_have_refs(){return!0}}n.__name__="Unknown",e.Unknown=n;class s extends t{valid(e){return i.isBoolean(e)}toString(){return"Bool"}}s.__name__="Bool",e.Bool=s;class d extends c{constructor(e){super(),this.obj_type=e}valid(e){return e instanceof this.obj_type}toString(){const e=this.obj_type;return`Ref(${e.__name__??e.toString()})`}may_have_refs(){const{obj_type:e}=this;return!(o.has_refs in e)||e[o.has_refs]}}d.__name__="Ref",e.Ref=d;class h extends c{valid(e){return i.isObject(e)}toString(){return"AnyRef"}may_have_refs(){return!0}}h.__name__="AnyRef",e.AnyRef=h;class p extends t{valid(e){return i.isNumber(e)}toString(){return"Float"}}p.__name__="Float",e.Float=p;class m extends p{valid(e){return super.valid(e)&&i.isInteger(e)}toString(){return"Int"}}m.__name__="Int",e.Int=m;class v extends p{valid(e){return super.valid(e)&&0<=e&&e<=1}toString(){return"Percent"}}v.__name__="Percent",e.Percent=v;class f extends c{constructor(e){super(),this.types=e,this.types=e}valid(e){return this.types.some((t=>t.valid(e)))}toString(){return`Or(${this.types.map((e=>e.toString())).join(", ")})`}may_have_refs(){return this.types.some((e=>e.may_have_refs()))}}f.__name__="Or",e.Or=f;class S extends c{constructor(e){super(),this.types=e,this.types=e}valid(e){if(!i.isArray(e))return!1;for(let t=0;t<this.types.length;t++){const r=this.types[t],n=e[t];if(!r.valid(n))return!1}return!0}toString(){return`Tuple(${this.types.map((e=>e.toString())).join(", ")})`}may_have_refs(){return this.types.some((e=>e.may_have_refs()))}}S.__name__="Tuple",e.Tuple=S;class g extends c{constructor(e){super(),this.struct_type=e}valid(e){if(!i.isPlainObject(e))return!1;const t=new _.PlainObjectProxy(this.struct_type);for(const r of(0,_.keys)(e))if(!t.has(r))return!1;for(const[r,n]of t){const t=e[r];if(!n.valid(t))return!1}return!0}toString(){return`Struct({${(0,_.typed_entries)(this.struct_type).map((([e,t])=>`${e.toString()}: ${t}`)).join(", ")}})`}may_have_refs(){return(0,_.typed_values)(this.struct_type).some((e=>e.may_have_refs()))}}g.__name__="Struct",e.Struct=g;class b extends c{constructor(e){super(),this.struct_type=e}valid(e){if(!i.isPlainObject(e))return!1;const t=new _.PlainObjectProxy(e),r=new _.PlainObjectProxy(this.struct_type);for(const e of t.keys())if(!r.has(e))return!1;for(const[e,n]of r){const r=t.get(e);if(void 0!==r&&!n.valid(r))return!1}return!0}toString(){return`Struct({${(0,_.typed_entries)(this.struct_type).map((([e,t])=>`${e.toString()}?: ${t}`)).join(", ")}})`}may_have_refs(){return(0,_.typed_values)(this.struct_type).some((e=>e.may_have_refs()))}}b.__name__="PartialStruct",e.PartialStruct=b;class x extends c{constructor(e){super(),this.item_type=e}valid(e){return i.isIterable(e)}toString(){return`Iterable(${this.item_type.toString()})`}may_have_refs(){return this.item_type.may_have_refs()}}x.__name__="Iterable",e.Iterable=x;class w extends c{constructor(e){super(),this.item_type=e}valid(e){return i.isArray(e)||i.isTypedArray(e)}toString(){return`Arrayable(${this.item_type.toString()})`}may_have_refs(){return this.item_type.may_have_refs()}}w.__name__="Arrayable",e.Arrayable=w;class K extends c{constructor(e){super(),this.item_type=e}valid(e){return i.isArray(e)&&e.every((e=>this.item_type.valid(e)))}toString(){return`List(${this.item_type.toString()})`}may_have_refs(){return this.item_type.may_have_refs()}}K.__name__="List",e.List=K;class N extends t{valid(e){return null===e}toString(){return"Null"}}N.__name__="Null",e.Null=N;class P extends c{constructor(e){super(),this.base_type=e}valid(e){return null===e||this.base_type.valid(e)}toString(){return`Nullable(${this.base_type.toString()})`}may_have_refs(){return this.base_type.may_have_refs()}}P.__name__="Nullable",e.Nullable=P;class A extends c{constructor(e){super(),this.base_type=e}valid(e){return void 0===e||this.base_type.valid(e)}toString(){return`Opt(${this.base_type.toString()})`}may_have_refs(){return this.base_type.may_have_refs()}}A.__name__="Opt",e.Opt=A;class $ extends c{valid(e){return e instanceof ArrayBuffer}toString(){return"Bytes"}may_have_refs(){return!1}}$.__name__="Bytes",e.Bytes=$;class O extends t{valid(e){return i.isString(e)}toString(){return"Str"}}O.__name__="Str",e.Str=O;class j extends O{constructor(e){super(),this.regex=e}valid(e){return super.valid(e)&&this.regex.test(e)}toString(){return`Regex(${this.regex.toString()})`}}j.__name__="Regex",e.Regex=j;class F extends t{constructor(e){super(),this.values=new l(e)}valid(e){return this.values.has(e)}*[Symbol.iterator](){yield*this.values}toString(){return`Enum(${[...this.values].map((e=>e.toString())).join(", ")})`}}F.__name__="Enum",e.Enum=F;class R extends c{constructor(e){super(),this.item_type=e}valid(e){if(!(e instanceof u||i.isPlainObject(e)))return!1;for(const t of(0,_.values)(e))if(!this.item_type.valid(t))return!1;return!0}toString(){return`Dict(${this.item_type.toString()})`}may_have_refs(){return this.item_type.may_have_refs()}}R.__name__="Dict",e.Dict=R;class B extends c{constructor(e,t){super(),this.key_type=e,this.item_type=t}coerce(e){return i.isPlainObject(e)&&(0,_.is_empty)(e)?new u:e}valid(e){if(!(e instanceof u))return!1;for(const[t,r]of e.entries())if(!this.key_type.valid(t)||!this.item_type.valid(r))return!1;return!0}toString(){return`Mapping(${this.key_type.toString()}, ${this.item_type.toString()})`}may_have_refs(){return this.key_type.may_have_refs()||this.item_type.may_have_refs()}}B.__name__="Mapping",e.Mapping=B;class I extends c{constructor(e){super(),this.item_type=e}valid(e){if(!(e instanceof l))return!1;for(const t of e)if(!this.item_type.valid(t))return!1;return!0}toString(){return`Set(${this.item_type.toString()})`}may_have_refs(){return this.item_type.may_have_refs()}}I.__name__="Set",e.Set=I;class k extends c{valid(e){return(0,a.is_Color)(e)}toString(){return"Color"}may_have_refs(){return!1}}k.__name__="Color",e.Color=k;class C extends O{toString(){return"CSSLength"}}C.__name__="CSSLength",e.CSSLength=C;class L extends c{valid(e){return i.isFunction(e)}toString(){return"Func(...)"}may_have_refs(){return!1}}L.__name__="Func",e.Func=L;class T extends c{constructor(e){super(),this.base_type=e}valid(e){return this.base_type.valid(e)&&e>=0}toString(){return`NonNegative(${this.base_type.toString()})`}may_have_refs(){return this.base_type.may_have_refs()}}T.__name__="NonNegative",e.NonNegative=T;class M extends c{constructor(e){super(),this.base_type=e}valid(e){return this.base_type.valid(e)&&e>0}toString(){return`Positive(${this.base_type.toString()})`}may_have_refs(){return this.base_type.may_have_refs()}}M.__name__="Positive",e.Positive=M;class E extends c{valid(e){return e instanceof y}toString(){return"Node"}may_have_refs(){return!1}}E.__name__="Node",e.Node=E}(r.Kinds||(r.Kinds={})),r.Any=new r.Kinds.Any,r.Unknown=new r.Kinds.Unknown,r.Bool=new r.Kinds.Bool,r.Float=new r.Kinds.Float,r.Int=new r.Kinds.Int,r.Bytes=new r.Kinds.Bytes,r.Str=new r.Kinds.Str;r.Regex=e=>new r.Kinds.Regex(e),r.Null=new r.Kinds.Null;r.Nullable=e=>new r.Kinds.Nullable(e);r.Opt=e=>new r.Kinds.Opt(e);r.Or=(...e)=>new r.Kinds.Or(e);r.Tuple=(...e)=>new r.Kinds.Tuple(e);r.Struct=e=>new r.Kinds.Struct(e);r.PartialStruct=e=>new r.Kinds.PartialStruct(e);r.Iterable=e=>new r.Kinds.Iterable(e);r.Arrayable=e=>new r.Kinds.Arrayable(e);r.List=e=>new r.Kinds.List(e);r.Dict=e=>new r.Kinds.Dict(e);r.Mapping=(e,t)=>new r.Kinds.Mapping(e,t);r.Set=e=>new r.Kinds.Set(e);r.Enum=(...e)=>new r.Kinds.Enum(e);r.Ref=e=>new r.Kinds.Ref(e);r.AnyRef=()=>new r.Kinds.AnyRef;r.Func=()=>new r.Kinds.Func,r.Node=new r.Kinds.Node;r.NonNegative=e=>new r.Kinds.NonNegative(e);r.Positive=e=>new r.Kinds.Positive(e),r.Percent=new r.Kinds.Percent,r.Alpha=r.Percent,r.Color=new r.Kinds.Color,r.Auto=(0,r.Enum)("auto"),r.CSSLength=new r.Kinds.CSSLength,r.FontSize=r.Str,r.Font=r.Str,r.Angle=r.Float,r.Boolean=r.Bool,r.String=r.Str,r.Number=r.Float,r.Array=r.List,r.Map=r.Mapping,r.Function=r.Func},
function _(n,r,t,e,s){e();const u=n(23),c=n(11),i=n(8),{round:o,sqrt:l}=Math;function a(n){return(0,c.clamp)(o(n),0,255)}function f(){return[0,0,0,0]}function g(n){return[n>>24&255,n>>16&255,n>>8&255,255&n]}function b(n,r=1){const[t,e,s,u]=(()=>{if(null==n)return[0,0,0,0];if((0,i.isInteger)(n))return g(n);if((0,i.isString)(n))return p(n)??[0,0,0,0];if(2==n.length){const[r,t]=n;return b(r,t)}{const[r,t,e,s=1]=n;return[r,t,e,a(255*s)]}})();return[t,e,s,a(r*u)]}t.byte=a,t.transparent=f,t.encode_rgba=function([n,r,t,e]){return n<<24|r<<16|t<<8|e},t.decode_rgba=g,t.color2rgba=b;const h={0:"0",1:"1",2:"2",3:"3",4:"4",5:"5",6:"6",7:"7",8:"8",9:"9",10:"a",11:"b",12:"c",13:"d",14:"e",15:"f"};function d(n){return h[n>>4]+h[15&n]}function $([n,r,t,e]){return`rgba(${n}, ${r}, ${t}, ${e/255})`}t.rgba2css=$,t.color2css=function(n,r){const[t,e,s,u]=b(n,r);return $([t,e,s,u])},t.color2hex=function(n,r){const[t,e,s,u]=b(n,r),c=`#${d(t)}${d(e)}${d(s)}`;return 255==u?c:`${c}${d(u)}`},t.color2hexrgb=function(n){const[r,t,e]=b(n);return`#${d(r)}${d(t)}${d(e)}`};const m=/^rgba?\(\s*(?<r>[^\s,]+?)\s+(?<g>[^\s,]+?)\s+(?<b>[^\s,]+?)(?:\s*\/\s*(?<a>[^\s,]+?))?\s*\)$/,N=/^rgba?\(\s*(?<r>[^\s,]+?)\s*,\s*(?<g>[^\s,]+?)\s*,\s*(?<b>[^\s,]+?)(?:\s*,\s*(?<a>[^\s,]+?))?\s*\)$/,_=(()=>{const n=document.createElement("canvas");n.width=1,n.height=1;const r=n.getContext("2d"),t=r.createLinearGradient(0,0,1,1);return n=>{r.fillStyle=t,r.fillStyle=n;const e=r.fillStyle;return e!=t?e:null}})();function p(n){if(""==(n=n.trim().toLowerCase()))return null;if("transparent"==n)return[0,0,0,0];if((0,u.is_named_color)(n))return g(u.named_colors[n]);if("#"==n[0]){const r=Number(`0x${n.substring(1)}`);if(isNaN(r))return null;switch(n.length-1){case 3:{const n=r>>8&15,t=r>>4&15,e=r>>0&15;return[n<<4|n,t<<4|t,e<<4|e,255]}case 4:{const n=r>>12&15,t=r>>8&15,e=r>>4&15,s=r>>0&15;return[n<<4|n,t<<4|t,e<<4|e,s<<4|s]}case 6:return[r>>16&255,r>>8&255,r>>0&255,255];case 8:return[r>>24&255,r>>16&255,r>>8&255,r>>0&255]}}else if(n.startsWith("rgb")){const r=n.match(m)??n.match(N);if(null!=r?.groups){let{r:n,g:t,b:e,a:s="1"}=r.groups;const u=n.endsWith("%"),c=t.endsWith("%"),i=e.endsWith("%"),o=s.endsWith("%");if(!(u&&c&&i)&&(u||c||i))return null;u&&(n=n.slice(0,-1)),c&&(t=t.slice(0,-1)),i&&(e=e.slice(0,-1)),o&&(s=s.slice(0,-1));let l=Number(n),f=Number(t),g=Number(e),b=Number(s);return isNaN(l+f+g+b)?null:(u&&(l=l/100*255),c&&(f=f/100*255),i&&(g=g/100*255),b=255*(o?b/100:b),l=a(l),f=a(f),g=a(g),b=a(b),[l,f,g,b])}}else{const r=_(n);if(null!=r)return p(r)}return null}t.css4_parse=p,t.is_Color=function(n){return!!(0,i.isInteger)(n)||(!(!(0,i.isString)(n)||null==p(n))||!(!(0,i.isArray)(n)||3!=n.length&&4!=n.length))},t.is_dark=function([n,r,t]){return 1-(.299*n+.587*r+.114*t)/255>=.6},t.brightness=function(n){const[r,t,e]=b(n);return l(.299*r**2+.587*t**2+.114*e**2)/255},t.luminance=function(n){const[r,t,e]=b(n);return(.2126*r**2.2+.7152*t**2.2+.0722*e**2.2)/255**2.2}},
function _(e,r,l,a,i){a();l.named_colors={aliceblue:4042850303,antiquewhite:4209760255,aqua:16777215,aquamarine:2147472639,azure:4043309055,beige:4126530815,bisque:4293182719,black:255,blanchedalmond:4293643775,blue:65535,blueviolet:2318131967,brown:2771004159,burlywood:3736635391,cadetblue:1604231423,chartreuse:2147418367,chocolate:3530104575,coral:4286533887,cornflowerblue:1687547391,cornsilk:4294499583,crimson:3692313855,cyan:16777215,darkblue:35839,darkcyan:9145343,darkgoldenrod:3095792639,darkgray:2846468607,darkgreen:6553855,darkgrey:2846468607,darkkhaki:3182914559,darkmagenta:2332068863,darkolivegreen:1433087999,darkorange:4287365375,darkorchid:2570243327,darkred:2332033279,darksalmon:3918953215,darkseagreen:2411499519,darkslateblue:1211993087,darkslategray:793726975,darkslategrey:793726975,darkturquoise:13554175,darkviolet:2483082239,deeppink:4279538687,deepskyblue:12582911,dimgray:1768516095,dimgrey:1768516095,dodgerblue:512819199,firebrick:2988581631,floralwhite:4294635775,forestgreen:579543807,fuchsia:4278255615,gainsboro:3705462015,ghostwhite:4177068031,gold:4292280575,goldenrod:3668254975,gray:2155905279,green:8388863,greenyellow:2919182335,grey:2155905279,honeydew:4043305215,hotpink:4285117695,indianred:3445382399,indigo:1258324735,ivory:4294963455,khaki:4041641215,lavender:3873897215,lavenderblush:4293981695,lawngreen:2096890111,lemonchiffon:4294626815,lightblue:2916673279,lightcoral:4034953471,lightcyan:3774873599,lightgoldenrodyellow:4210742015,lightgray:3553874943,lightgreen:2431553791,lightgrey:3553874943,lightpink:4290167295,lightsalmon:4288707327,lightseagreen:548580095,lightskyblue:2278488831,lightslategray:2005441023,lightslategrey:2005441023,lightsteelblue:2965692159,lightyellow:4294959359,lime:16711935,limegreen:852308735,linen:4210091775,magenta:4278255615,maroon:2147483903,mediumaquamarine:1724754687,mediumblue:52735,mediumorchid:3126187007,mediumpurple:2473647103,mediumseagreen:1018393087,mediumslateblue:2070474495,mediumspringgreen:16423679,mediumturquoise:1221709055,mediumvioletred:3340076543,midnightblue:421097727,mintcream:4127193855,mistyrose:4293190143,moccasin:4293178879,navajowhite:4292783615,navy:33023,oldlace:4260751103,olive:2155872511,olivedrab:1804477439,orange:4289003775,orangered:4282712319,orchid:3664828159,palegoldenrod:4008225535,palegreen:2566625535,paleturquoise:2951671551,palevioletred:3681588223,papayawhip:4293907967,peachpuff:4292524543,peru:3448061951,pink:4290825215,plum:3718307327,powderblue:2967529215,purple:2147516671,rebeccapurple:1714657791,red:4278190335,rosybrown:3163525119,royalblue:1097458175,saddlebrown:2336560127,salmon:4202722047,sandybrown:4104413439,seagreen:780883967,seashell:4294307583,sienna:2689740287,silver:3233857791,skyblue:2278484991,slateblue:1784335871,slategray:1887473919,slategrey:1887473919,snow:4294638335,springgreen:16744447,steelblue:1182971135,tan:3535047935,teal:8421631,thistle:3636451583,tomato:4284696575,turquoise:1088475391,violet:4001558271,wheat:4125012991,white:4294967295,whitesmoke:4126537215,yellow:4294902015,yellowgreen:2597139199},l.is_named_color=function(e){return e in l.named_colors}},
function _(r,t,n,o,a){o(),n.GeneratorFunction=Object.getPrototypeOf((function*(){})).constructor,n.AsyncGeneratorFunction=Object.getPrototypeOf((async function*(){})).constructor,n.ColorArray=Uint32Array,n.RGBAArray=Uint8ClampedArray,n.infer_type=function(r,t){return r instanceof Float64Array||r instanceof Array||t instanceof Float64Array||t instanceof Array?Float64Array:Float32Array},n.ScreenArray=Float32Array,n.to_screen=function(r){return r instanceof Float32Array?r:Float32Array.from(r)},a("Indices",r(25).BitSet)},
function _(t,s,r,e,i){var n,o;e();const _=t(26),a=t(12),h=t(17);class c{constructor(t,s=0){this[n]="BitSet",this._count=null,this.size=t,this._nwords=Math.ceil(t/c._word_length),0==s||1==s?(this._array=new Uint32Array(this._nwords),1==s&&this._array.fill(4294967295)):((0,a.assert)(s.length==this._nwords,"Initializer size mismatch"),this._array=s)}clone(){return new c(this.size,new Uint32Array(this._array))}[(n=Symbol.toStringTag,o=h.has_refs,_.equals)](t,s){if(!s.eq(this.size,t.size))return!1;const{_nwords:r}=this,e=this.size%c._word_length,i=0==e?r:r-1;for(let s=0;s<i;s++)if(this._array[s]!=t._array[s])return!1;if(0==e)return!0;{const s=1<<e-1,r=s-1^s;return(this._array[i]&r)==(t._array[i]&r)}}static all_set(t){return new c(t,1)}static all_unset(t){return new c(t,0)}static from_indices(t,s){const r=new c(t);for(const t of s)r.set(t);return r}static from_booleans(t,s){const r=new c(t);let e=0;for(const i of s){if(e==t)break;i&&r.set(e),e+=1}return r}_check_bounds(t){(0,a.assert)(0<=t&&t<this.size,`Out of bounds: 0 <= ${t} < ${this.size}`)}get(t){this._check_bounds(t);const s=t>>>5,r=31&t;return 1==(this._array[s]>>r&1)}set(t,s=!0){this._check_bounds(t),this._count=null;const r=t>>>5,e=31&t;s?this._array[r]|=1<<e:this._array[r]&=~(1<<e)}unset(t){this.set(t,!1)}*[Symbol.iterator](){yield*this.ones()}get count(){let t=this._count;return null==t&&(this._count=t=this._get_count()),t}_get_count(){const{_array:t,_nwords:s,size:r}=this;let e=0;for(let i=0,n=0;n<s;n++){const s=t[n];if(0==s)i+=c._word_length;else for(let t=0;t<c._word_length&&i<r;t++,i++)1==(s>>>t&1)&&(e+=1)}return e}*ones(){const{_array:t,_nwords:s,size:r}=this;for(let e=0,i=0;i<s;i++){const s=t[i];if(0!=s)for(let t=0;t<c._word_length&&e<r;t++,e++)1==(s>>>t&1)&&(yield e);else e+=c._word_length}}*zeros(){const{_array:t,_nwords:s,size:r}=this;for(let e=0,i=0;i<s;i++){const s=t[i];if(4294967295!=s)for(let t=0;t<c._word_length&&e<r;t++,e++)0==(s>>>t&1)&&(yield e);else e+=c._word_length}}_check_size(t){(0,a.assert)(this.size==t.size,`Size mismatch (${this.size} != ${t.size})`)}invert(){for(let t=0;t<this._nwords;t++)this._array[t]=~this._array[t]>>>0}add(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]|=t._array[s]}intersect(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]&=t._array[s]}subtract(t){this._check_size(t);for(let s=0;s<this._nwords;s++){const r=this._array[s],e=t._array[s];this._array[s]=(r^e)&r}}symmetric_subtract(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]^=t._array[s]}inversion(){const t=this.clone();return t.invert(),t}union(t){const s=this.clone();return s.add(t),s}intersection(t){const s=this.clone();return s.intersect(t),s}difference(t){const s=this.clone();return s.subtract(t),s}symmetric_difference(t){const s=this.clone();return s.symmetric_subtract(t),s}select(t){(0,a.assert)(this.size<=t.length,"Size mismatch");const s=this.count,r=new t.constructor(s);let e=0;for(const s of this)r[e++]=t[s];return r}}r.BitSet=c,c.__name__="BitSet",c[o]=!1,c._word_length=32},
function _(t,e,r,s,n){s();const o=t(8),{hasOwnProperty:c}=Object.prototype;function a(t){return(0,o.isObject)(t)&&r.equals in t}r.equals=Symbol("equals"),r.wildcard=Symbol("wildcard");const i=Object.prototype.toString;class u extends Error{}r.EqNotImplemented=u,u.__name__="EqNotImplemented";class l{constructor(t){this.a_stack=[],this.b_stack=[],this.structural=t?.structural??!1}eq(t,e){if(Object.is(t,e))return!0;if(t===r.wildcard||e===r.wildcard)return!0;if(null==t||null==e)return t===e;const s=i.call(t);if(s!=i.call(e))return!1;switch(s){case"[object Number]":return this.numbers(t,e);case"[object Symbol]":return t===e;case"[object RegExp]":case"[object String]":return`${t}`==`${e}`;case"[object Date]":case"[object Boolean]":return+t==+e}const{a_stack:n,b_stack:o}=this;let c=n.length;for(;c-- >0;)if(n[c]===t)return o[c]===e;n.push(t),o.push(e);const l=(()=>{if(a(t)&&a(e))return t[r.equals](e,this);switch(s){case"[object Array]":case"[object Uint8Array]":case"[object Int8Array]":case"[object Uint16Array]":case"[object Int16Array]":case"[object Uint32Array]":case"[object Int32Array]":case"[object Float32Array]":case"[object Float64Array]":return this.arrays(t,e);case"[object Map]":return this.maps(t,e);case"[object Set]":return this.sets(t,e);case"[object Object]":if(t.constructor==e.constructor&&(null==t.constructor||t.constructor===Object))return this.objects(t,e);case"[object Function]":if(t.constructor==e.constructor&&t.constructor===Function)return this.eq(`${t}`,`${e}`)}if("undefined"!=typeof Node&&t instanceof Node)return this.nodes(t,e);throw new u(`can't compare objects of type ${s}`)})();return n.pop(),o.pop(),l}numbers(t,e){return Object.is(t,e)}arrays(t,e){const{length:r}=t;if(r!=e.length)return!1;for(let s=0;s<r;s++)if(!this.eq(t[s],e[s]))return!1;return!0}iterables(t,e){const r=t[Symbol.iterator](),s=e[Symbol.iterator]();for(;;){const t=r.next(),e=s.next(),n=t.done??!1,o=e.done??!1;if(n&&o)return!0;if(n||o)return!1;if(!this.eq(t.value,e.value))return!1}}maps(t,e){if(t.size!=e.size)return!1;if(this.structural)return this.iterables(t.entries(),e.entries());for(const[r,s]of t)if(!e.has(r)||!this.eq(s,e.get(r)))return!1;return!0}sets(t,e){if(t.size!=e.size)return!1;if(this.structural)return this.iterables(t.entries(),e.entries());for(const r of t)if(!e.has(r))return!1;return!0}objects(t,e){const r=Object.keys(t);if(r.length!=Object.keys(e).length)return!1;for(const s of r)if(!c.call(e,s)||!this.eq(t[s],e[s]))return!1;return!0}nodes(t,e){return t.nodeType==e.nodeType&&(t.textContent==e.textContent&&!!this.iterables(t.childNodes,e.childNodes))}}r.Comparator=l,l.__name__="Comparator";const{abs:b}=Math;class f extends l{constructor(t=1e-4){super(),this.tolerance=t}numbers(t,e){return super.numbers(t,e)||b(t-e)<this.tolerance}}r.SimilarComparator=f,f.__name__="SimilarComparator",r.is_equal=function(t,e){return(new l).eq(t,e)},r.is_structurally_equal=function(t,e){return new l({structural:!0}).eq(t,e)},r.is_similar=function(t,e,r){return new f(r).eq(t,e)}},
function _(n,t,i,e,r){e(),i.is_mobile="ontouchstart"in globalThis||"undefined"!=typeof navigator&&navigator.maxTouchPoints>0,i.is_little_endian=(()=>{const n=new ArrayBuffer(4),t=new Uint8Array(n);new Uint32Array(n)[1]=168496141;let i=!0;return 10==t[4]&&11==t[5]&&12==t[6]&&13==t[7]&&(i=!1),i})(),i.BYTE_ORDER=i.is_little_endian?"little":"big",i.to_big_endian=function(n){if(i.is_little_endian){const t=new Uint32Array(n.length),i=new DataView(t.buffer);let e=0;for(const t of n)i.setUint32(e,t),e+=4;return t}return n}},
function _(i,n,e,t,u){t();const c=i(8);e.isValue=function(i){return(0,c.isPlainObject)(i)&&"value"in i},e.isField=function(i){return(0,c.isPlainObject)(i)&&"field"in i},e.isExpr=function(i){return(0,c.isPlainObject)(i)&&"expr"in i}},
function _(e,t,r,s,_){s();class i{constructor(){this._dev=!1,this._wireframe=!1,this._force_webgl=!1,this._force_fields=!1}set dev(e){this._dev=e}get dev(){return this._dev}set wireframe(e){this._wireframe=e}get wireframe(){return this._wireframe}set force_webgl(e){this._force_webgl=e}get force_webgl(){return this._force_webgl}set force_fields(e){this._force_fields=e}get force_fields(){return this._force_fields}}r.Settings=i,i.__name__="Settings",r.settings=new i},
function _(e,t,s,r,n){var a,i,h,u,o,l,c,p,y,_;r();const A=e(8),d=e(27),g=e(26),f=e(31),m=e(32),w=Symbol("__ndarray__");function N(e,t){return{type:"ndarray",array:t.encode("object"==e.dtype?Array.from(e):e.buffer),order:d.BYTE_ORDER,dtype:e.dtype,shape:e.shape}}class D extends Uint8Array{constructor(e,t){super(e),this[a]=!0,this.dtype="bool",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(a=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new D(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return 1==this[e]}}s.BoolNDArray=D,D.__name__="BoolNDArray";class q extends Uint8Array{constructor(e,t){super(e),this[i]=!0,this.dtype="uint8",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(i=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new q(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Uint8NDArray=q,q.__name__="Uint8NDArray";class b extends Int8Array{constructor(e,t){super(e),this[h]=!0,this.dtype="int8",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(h=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new b(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Int8NDArray=b,b.__name__="Int8NDArray";class U extends Uint16Array{constructor(e,t){super(e),this[u]=!0,this.dtype="uint16",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(u=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new U(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Uint16NDArray=U,U.__name__="Uint16NDArray";class I extends Int16Array{constructor(e,t){super(e),this[o]=!0,this.dtype="int16",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(o=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new I(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Int16NDArray=I,I.__name__="Int16NDArray";class x extends Uint32Array{constructor(e,t){super(e),this[l]=!0,this.dtype="uint32",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(l=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new x(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Uint32NDArray=x,x.__name__="Uint32NDArray";class z extends Int32Array{constructor(e,t){super(e),this[c]=!0,this.dtype="int32",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(c=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new z(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Int32NDArray=z,z.__name__="Int32NDArray";class F extends Float32Array{constructor(e,t){super(e),this[p]=!0,this.dtype="float32",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(p=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new F(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Float32NDArray=F,F.__name__="Float32NDArray";class j extends Float64Array{constructor(e,t){super(e),this[y]=!0,this.dtype="float64",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(y=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new j(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Float64NDArray=j,j.__name__="Float64NDArray";class B extends Array{get shape(){return this._shape??[this.length]}get dimension(){return this.shape.length}constructor(e,t){const s=e instanceof ArrayBuffer?new Float64Array(e):e;if(super((0,A.isNumber)(s)?s:s.length),this[_]=!0,this.dtype="object",!(0,A.isNumber)(s))for(let e=0;e<s.length;e++)this[e]=s[e];this._shape=t??(O(s)?s.shape:void 0)}[(_=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new B(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}function O(e){return(0,A.isObject)(e)&&w in e}s.ObjectNDArray=B,B.__name__="ObjectNDArray",s.is_NDArray=O,s.ndarray=function(e,{dtype:t,shape:s}={}){switch(null==t&&(t=(()=>{switch(!0){case e instanceof Uint8Array:return"uint8";case e instanceof Int8Array:return"int8";case e instanceof Uint16Array:return"uint16";case e instanceof Int16Array:return"int16";case e instanceof Uint32Array:return"uint32";case e instanceof Int32Array:return"int32";case e instanceof Float32Array:return"float32";case e instanceof ArrayBuffer:case e instanceof Float64Array:return"float64";default:return"object"}})()),t){case"bool":return new D(e,s);case"uint8":return new q(e,s);case"int8":return new b(e,s);case"uint16":return new U(e,s);case"int16":return new I(e,s);case"uint32":return new x(e,s);case"int32":return new z(e,s);case"float32":return new F(e,s);case"float64":return new j(e,s);case"object":return new B(e,s)}}},
function _(n,e,t,o,r){o();const i=n(9),c=n(8);function l(n){return(0,c.isObject)(n)&&t.clone in n}t.clone=Symbol("clone"),t.is_Cloneable=l;class s extends Error{}t.CloningError=s,s.__name__="CloningError";class a{constructor(){}clone(n){if(l(n))return n[t.clone](this);if((0,c.isPrimitive)(n))return n;if((0,c.isArray)(n)){const e=n.length,t=new Array(e);for(let o=0;o<e;o++){const e=n[o];t[o]=this.clone(e)}return t}if((0,c.isPlainObject)(n)){const e={};for(const[t,o]of(0,i.entries)(n))e[t]=this.clone(o);return e}if(n instanceof Map)return new Map([...n].map((([n,e])=>[this.clone(n),this.clone(e)])));if(n instanceof Set)return new Set([...n].map((n=>this.clone(n))));throw new s(`${Object.prototype.toString.call(n)} is not cloneable`)}}t.Cloner=a,a.__name__="Cloner"},
function _(r,e,i,a,f){a();const o=r(1);var l=r(33);f("Serializer",l.Serializer),f("SerializationError",l.SerializationError),f("serialize",l.serialize);var t=r(35);f("Buffer",t.Buffer),f("Base64Buffer",t.Base64Buffer),o.__exportStar(r(37),i)},
function _(e,r,t,n,i){n();const s=e(12),a=e(9),c=e(8),o=e(34),u=e(27),l=e(35);t.serialize=Symbol("serialize");class f extends Error{}t.SerializationError=f,f.__name__="SerializationError";class y{constructor(e){this.value=e}to_json(){return JSON.stringify(this.value)}}y.__name__="Serialized";class d{constructor(e){this._circular=new WeakSet,this.binary=e?.binary??!1,this.include_defaults=e?.include_defaults??!1;const r=e?.references;this._references=null!=r?new Map(r):new Map}get_ref(e){return this._references.get(e)}add_ref(e,r){(0,s.assert)(!this._references.has(e)),this._references.set(e,r)}to_serializable(e){return new y(this.encode(e))}encode(e){const r=this.get_ref(e);if(null!=r)return r;if(!(0,c.isObject)(e))return this._encode(e);this._circular.has(e)&&this.error("circular reference"),this._circular.add(e);try{return this._encode(e)}finally{this._circular.delete(e)}}_encode(e){if(function(e){return(0,c.isObject)(e)&&t.serialize in e}(e))return e[t.serialize](this);if((0,c.isArray)(e)){const r=e.length,t=new Array(r);for(let n=0;n<r;n++){const r=e[n];t[n]=this.encode(r)}return t}if((0,c.isTypedArray)(e))return this._encode_typed_array(e);if(e instanceof ArrayBuffer){return{type:"bytes",data:this.binary?new l.Buffer(e):new l.Base64Buffer(e)}}if((0,c.isPlainObject)(e)){const r=(0,a.entries)(e);return 0==r.length?{type:"map"}:{type:"map",entries:[...(0,o.map)(r,(([e,r])=>[this.encode(e),this.encode(r)]))]}}if(null===e||(0,c.isBoolean)(e)||(0,c.isString)(e))return e;if((0,c.isNumber)(e))return isNaN(e)?{type:"number",value:"nan"}:isFinite(e)?e:{type:"number",value:(e<0?"-":"+")+"inf"};if(e instanceof Date){return{type:"date",iso:e.toISOString()}}if(e instanceof Set)return 0==e.size?{type:"set"}:{type:"set",entries:[...(0,o.map)(e.values(),(e=>this.encode(e)))]};if(e instanceof Map)return 0==e.size?{type:"map"}:{type:"map",entries:[...(0,o.map)(e.entries(),(([e,r])=>[this.encode(e),this.encode(r)]))]};if((0,c.isSymbol)(e)&&null!=e.description)return{type:"symbol",name:e.description};throw new f(`${Object.prototype.toString.call(e)} is not serializable`)}encode_struct(e){const r={};for(const[t,n]of(0,a.entries)(e))void 0!==n&&(r[t]=this.encode(n));return r}error(e){throw new f(e)}_encode_typed_array(e){const r=this.encode(e.buffer),t=(()=>{switch(e.constructor){case Uint8Array:return"uint8";case Int8Array:return"int8";case Uint16Array:return"uint16";case Int16Array:return"int16";case Uint32Array:return"uint32";case Int32Array:return"int32";case Float32Array:return"float32";case Float64Array:return"float64";default:this.error(`can't serialize typed array of type '${e[Symbol.toStringTag]}'`)}})();return{type:"typed_array",array:r,order:u.BYTE_ORDER,dtype:t}}}t.Serializer=d,d.__name__="Serializer"},
function _(n,o,t,e,f){e();const i=n(10),r=n(12);var l=n(13);function*c(n){const o=n.length;for(let t=0;t<o;t++)yield n[o-t-1]}function*s(n,o){(0,r.assert)(o>=0);for(const t of n)0==o?yield t:o-=1}function*a(n,o){const t=n.length;if(o>t)return;const e=(0,i.range)(o);for(yield e.map((o=>n[o]));;){let f;for(const n of c((0,i.range)(o)))if(e[n]!=n+t-o){f=n;break}if(null==f)return;e[f]+=1;for(const n of(0,i.range)(f+1,o))e[n]=e[n-1]+1;yield e.map((o=>n[o]))}}f("min",l.min),f("max",l.max),t.range=function*(n,o,t=1){(0,r.assert)(t>0);const{abs:e,ceil:f,max:i}=Math;null==o&&(o=n,n=0);const l=n<=o?t:-t,c=i(f(e(o-n)/t),0);for(let o=0;o<c;o++,n+=l)yield n},t.reverse=c,t.enumerate=function*(n){let o=0;for(const t of n)yield[t,o++]},t.take=function*(n,o){(0,r.assert)(o>=0);let t=0;for(const e of n){if(!(t++<o))break;yield e}},t.skip=s,t.tail=function*(n){yield*s(n,1)},t.join=function*(n,o){let t=!0;for(const e of n)t?t=!1:null!=o&&(yield o()),yield*e},t.zip=function*(n,o){const t=n[Symbol.iterator](),e=o[Symbol.iterator]();for(;;){const n=t.next(),o=e.next();if(!0===n.done||!0===o.done)break;yield[n.value,o.value]}},t.interleave=function*(n,o){let t=!0;for(const e of n)t?t=!1:yield o(),yield e},t.map=function*(n,o){let t=0;for(const e of n)yield o(e,t++)},t.flat_map=function*(n,o){let t=0;for(const e of n)yield*o(e,t++)},t.every=function(n,o){for(const t of n)if(!o(t))return!1;return!0},t.some=function(n,o){for(const t of n)if(o(t))return!0;return!1},t.combinations=a,t.subsets=function*(n){for(const o of(0,i.range)(n.length+1))yield*a(n,o)}},
function _(e,f,r,s,t){s();const u=e(36),_=e(26);class a{constructor(e){this.buffer=e}to_base64(){return(0,u.buffer_to_base64)(this.buffer)}[_.equals](e,f){return f.eq(this.buffer,e.buffer)}}r.Buffer=a,a.__name__="Buffer";class n extends a{toJSON(){return this.to_base64()}}r.Base64Buffer=n,n.__name__="Base64Buffer"},
function _(t,n,e,r,o){r(),e.buffer_to_base64=function(t){const n=new Uint8Array(t),e=Array.from(n).map((t=>String.fromCharCode(t)));return btoa(e.join(""))},e.base64_to_buffer=function(t){const n=atob(t),e=n.length,r=new Uint8Array(e);for(let t=0,o=e;t<o;t++)r[t]=n.charCodeAt(t);return r.buffer},e.swap=function(t,n){switch(n){case"uint16":case"int16":!function(t){const n=new Uint8Array(t);for(let t=0,e=n.length;t<e;t+=2){const e=n[t];n[t]=n[t+1],n[t+1]=e}}(t);break;case"uint32":case"int32":case"float32":!function(t){const n=new Uint8Array(t);for(let t=0,e=n.length;t<e;t+=4){let e=n[t];n[t]=n[t+3],n[t+3]=e,e=n[t+1],n[t+1]=n[t+2],n[t+2]=e}}(t);break;case"float64":!function(t){const n=new Uint8Array(t);for(let t=0,e=n.length;t<e;t+=8){let e=n[t];n[t]=n[t+7],n[t+7]=e,e=n[t+1],n[t+1]=n[t+6],n[t+6]=e,e=n[t+2],n[t+2]=n[t+5],n[t+5]=e,e=n[t+3],n[t+3]=n[t+4],n[t+4]=e}}(t)}}},
function _(n,c,f,i,o){i()},
function _(s,t,e,n,i){n();class c{constructor(){this.listeners=new Set}connect(s){this.listeners.add(s)}disconnect(s){this.listeners.delete(s)}report(s){for(const t of this.listeners)t(s)}}e.Diagnostics=c,c.__name__="Diagnostics",e.diagnostics=new c},
function _(t,r,e,a,s){a();const n=t(1),i=t(26),l=n.__importStar(t(13));class o{is_Scalar(){return this.is_scalar}is_Vector(){return!this.is_scalar}}e.Uniform=o,o.__name__="Uniform";class h extends o{constructor(t,r){super(),this.is_scalar=!0,this.value=t,this.length=r}get(t){return this.value}*[Symbol.iterator](){const{length:t,value:r}=this;for(let e=0;e<t;e++)yield r}select(t){return new h(this.value,t.count)}[i.equals](t,r){return r.eq(this.length,t.length)&&r.eq(this.value,t.value)}map(t){return new h(t(this.value),this.length)}}e.UniformScalar=h,h.__name__="UniformScalar";class c extends o{constructor(t){super(),this.is_scalar=!1,this.array=t,this.length=this.array.length}get(t){return this.array[t]}*[Symbol.iterator](){yield*this.array}select(t){const r=t.select(this.array);return new this.constructor(r)}[i.equals](t,r){return r.eq(this.length,t.length)&&r.eq(this.array,t.array)}map(t){return new c(l.map(this.array,t))}}e.UniformVector=c,c.__name__="UniformVector";class u extends c{constructor(t){super(t),this.array=t,this._view=new DataView(t.buffer)}get(t){return this._view.getUint32(4*t)}*[Symbol.iterator](){const t=this.length;for(let r=0;r<t;r++)yield this.get(r)}}e.ColorUniformVector=u,u.__name__="ColorUniformVector",e.min=function(t){return t.is_Scalar()?t.value:l.min(t.array)},e.max=function(t){return t.is_Scalar()?t.value:l.max(t.array)}},
function _(e,t,r,n,u){n();const c=e(29);function s(){const e=new Array(32),t="0123456789ABCDEF";for(let r=0;r<32;r++)e[r]=t[Math.floor(16*Math.random())];return e[12]="4",e[16]=t[3&e[16].charCodeAt(0)|8],e.join("")}r.uuid4=s;let a=1e3;r.unique_id=function(e){const t=c.settings.dev?"j"+a++:s();return null!=e?`${e}-${t}`:t},r.escape=function(e){return e.replace(/(?:[&<>"'`])/g,(e=>{switch(e){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return e}}))},r.unescape=function(e){return e.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,((e,t)=>{switch(t){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return t}}))},r.use_strict=function(e){return`'use strict';\n${e}`},r.to_fixed=function(e,t){return e.toFixed(t).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"")},r.insert_text_on_position=function(e,t,r){const n=[];return n.push(e.slice(0,t)),n.push(r),n.push(e.slice(t)),n.join("")}},
function _(e,t,s,n,a){n();const i=e(26),r=e(32);class d{constructor(e){this.sync=!0,this.document=e}get[Symbol.toStringTag](){return this.constructor.__name__}[i.equals](e,t){return t.eq(this.document,e.document)}}s.DocumentEvent=d,d.__name__="DocumentEvent";class o extends d{constructor(e,t){super(e),this.events=t}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.events,e.events)}}s.DocumentEventBatch=o,o.__name__="DocumentEventBatch";class l extends d{}s.DocumentChangedEvent=l,l.__name__="DocumentChangedEvent";class h extends l{constructor(e,t,s){super(e),this.kind="MessageSent",this.msg_type=t,this.msg_data=s}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.msg_type,e.msg_type)&&t.eq(this.msg_data,e.msg_data)}[r.serialize](e){return{kind:this.kind,msg_type:this.msg_type,msg_data:e.encode(this.msg_data)}}}s.MessageSentEvent=h,h.__name__="MessageSentEvent";class u extends l{constructor(e,t,s,n){super(e),this.kind="ModelChanged",this.model=t,this.attr=s,this.value=n}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)&&t.eq(this.attr,e.attr)&&t.eq(this.value,e.value)}[r.serialize](e){return{kind:this.kind,model:this.model.ref(),attr:this.attr,new:e.encode(this.value)}}}s.ModelChangedEvent=u,u.__name__="ModelChangedEvent";class m extends l{constructor(e,t,s,n,a){super(e),this.kind="ColumnDataChanged",this.model=t,this.attr=s,this.data=n,this.cols=a}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)&&t.eq(this.attr,e.attr)&&t.eq(this.data,e.data)&&t.eq(this.cols,e.cols)}[r.serialize](e){return{kind:this.kind,model:this.model.ref(),attr:this.attr,data:e.encode(this.data),cols:this.cols}}}s.ColumnDataChangedEvent=m,m.__name__="ColumnDataChangedEvent";class c extends l{constructor(e,t,s,n,a){super(e),this.kind="ColumnsStreamed",this.model=t,this.attr=s,this.data=n,this.rollover=a}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)&&t.eq(this.attr,e.attr)&&t.eq(this.data,e.data)&&t.eq(this.rollover,e.rollover)}[r.serialize](e){return{kind:this.kind,model:this.model.ref(),attr:this.attr,data:e.encode(this.data),rollover:this.rollover}}}s.ColumnsStreamedEvent=c,c.__name__="ColumnsStreamedEvent";class _ extends l{constructor(e,t,s,n){super(e),this.kind="ColumnsPatched",this.model=t,this.attr=s,this.patches=n}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)&&t.eq(this.attr,e.attr)&&t.eq(this.patches,e.patches)}[r.serialize](e){return{kind:this.kind,attr:this.attr,model:this.model.ref(),patches:e.encode(this.patches)}}}s.ColumnsPatchedEvent=_,_.__name__="ColumnsPatchedEvent";class q extends l{constructor(e,t){super(e),this.kind="TitleChanged",this.title=t}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.title,e.title)}[r.serialize](e){return{kind:this.kind,title:this.title}}}s.TitleChangedEvent=q,q.__name__="TitleChangedEvent";class v extends l{constructor(e,t){super(e),this.kind="RootAdded",this.model=t}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)}[r.serialize](e){return{kind:this.kind,model:e.encode(this.model)}}}s.RootAddedEvent=v,v.__name__="RootAddedEvent";class p extends l{constructor(e,t){super(e),this.kind="RootRemoved",this.model=t}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)}[r.serialize](e){return{kind:this.kind,model:this.model.ref()}}}s.RootRemovedEvent=p,p.__name__="RootRemovedEvent"},
function _(t,r,i,e,n){e();const s=t(8),o=t(9);i.pretty=Symbol("pretty");class c{constructor(t){this.visited=new Set,this.precision=t?.precision}to_string(t){if((0,s.isObject)(t)){if(this.visited.has(t))return"<circular>";this.visited.add(t)}return function(t){return(0,s.isObject)(t)&&i.pretty in t}(t)?t[i.pretty](this):(0,s.isBoolean)(t)?this.boolean(t):(0,s.isNumber)(t)?this.number(t):(0,s.isString)(t)?this.string(t):(0,s.isArray)(t)?this.array(t):(0,s.isIterable)(t)?this.iterable(t):(0,s.isPlainObject)(t)?this.object(t):(0,s.isSymbol)(t)?this.symbol(t):t instanceof ArrayBuffer?this.array_buffer(t):`${t}`}token(t){return t}boolean(t){return`${t}`}number(t){return null!=this.precision?t.toFixed(this.precision):`${t}`}string(t){const r=t.includes("'"),i=t.includes('"');return r&&i?`\`${t.replace(/`/g,"\\`")}\``:i?`'${t}'`:`"${t}"`}symbol(t){return t.toString()}array(t){const r=this.token,i=[];for(const r of t)i.push(this.to_string(r));return`${r("[")}${i.join(`${r(",")} `)}${r("]")}`}iterable(t){const r=this.token,i=Object(t)[Symbol.toStringTag]??"Object",e=this.array(t);return`${i}${r("(")}${e}${r(")")}`}object(t){const r=this.token,i=[];for(const[e,n]of(0,o.entries)(t))i.push(`${e}${r(":")} ${this.to_string(n)}`);return`${r("{")}${i.join(`${r(",")} `)}${r("}")}`}array_buffer(t){return`ArrayBuffer(#${t.byteLength})`}}i.Printer=c,c.__name__="Printer",i.to_string=function(t,r){return new c(r).to_string(t)}},
function _(t,r,n,e,o){e();const s=t(1),c=t(8),u=t(9),l=t(44),i=s.__importStar(t(45));function a(t,r,n){if((0,c.isArray)(t)&&(0,c.isArray)(r)){const e=t.concat(r);return null!=n&&e.length>n?e.slice(-n):e}const e=t.length+r.length;if(null!=n&&e>n){const o=e-n,s=t.length,u=(()=>{if(t.length<n){const e=new((()=>{if((0,c.isTypedArray)(t))return t.constructor;if((0,c.isTypedArray)(r))return r.constructor;throw new Error("unsupported array types")})())(n);return e.set(t,0),e}return t})();for(let t=o,r=s;t<r;t++)u[t-o]=u[t];for(let t=0,n=r.length;t<n;t++)u[t+(s-o)]=r[t];return u}{const n=(()=>{if((0,c.isTypedArray)(t))return t;if((0,c.isTypedArray)(r))return new r.constructor(t);throw new Error("unsupported array types")})();return i.concat(n,r)}}function f(t,r){let n,e,o;return(0,c.isNumber)(t)?(n=t,o=t+1,e=1):(n=null!=t.start?t.start:0,o=null!=t.stop?t.stop:r,e=null!=t.step?t.step:1),[n,o,e]}function p(t,r){const n=new Set;let e=!1;for(const[o,s]of r){let r,u,l,i;if((0,c.isArray)(o)){const[e]=o;n.add(e),r=t[e].shape,u=t[e],i=s,2===o.length?(r=[1,r[0]],l=[o[0],0,o[1]]):l=o}else(0,c.isNumber)(o)?(i=[s],n.add(o)):(i=s,e=!0),l=[0,0,o],r=[1,t.length],u=t;let a=0;const[p,d,y]=f(l[1],r[0]),[h,_,g]=f(l[2],r[1]);for(let t=p;t<d;t+=y)for(let o=h;o<_;o+=g)e&&n.add(o),u[t*r[1]+o]=i[a],a++}return n}n.stream_to_column=a,n.slice=f,n.patch_to_column=p,n.stream_to_columns=function(t,r,n){const e=(0,u.dict)(t);for(const[t,o]of(0,u.dict)(r)){const r=e.get(t)??[];e.set(t,a(r,o,n))}},n.patch_to_columns=function(t,r){const n=(0,u.dict)(t);let e=new Set;for(const[t,o]of(0,u.dict)(r)){const r=n.get(t)??[];e=(0,l.union)(e,p(r,o))}return e}},
function _(n,o,t,e,f){function c(...n){const o=new Set;for(const t of n)for(const n of t)o.add(n);return o}e(),t.union=c,t.intersection=function(n,...o){const t=new Set;n:for(const e of n){for(const n of o)if(!n.has(e))continue n;t.add(e)}return t},t.difference=function(n,...o){const t=new Set(n);for(const n of c(...o))t.delete(n);return t}},
function _(t,n,o,e,c){e(),o.concat=function(t,...n){let o=t.length;for(const t of n)o+=t.length;const e=new t.constructor(o);e.set(t,0);let c=t.length;for(const t of n)e.set(t,c),c+=t.length;return e}},
function _(e,s,t,n,o){n();class r{constructor(e,s=[]){this._known_models=new Map,this.parent=e;for(const e of s)this.register(e)}get(e){return this._known_models.get(e)??this.parent?.get(e)??null}register(e,s=!1){const t=e.__qualified__;s||null==this.get(t)?this._known_models.set(t,e):console.warn(`Model '${t}' was already registered with this resolver`)}get names(){return[...this._known_models.keys()]}}t.ModelResolver=r,r.__name__="ModelResolver"},
function _(e,r,t,s,n){s();const i=e(19),d=e(17),o=e(30),a=e(9),c=e(10),_=e(27),u=e(36),l=e(8),f=e(48),h=new Map;class y extends Error{}t.DeserializationError=y,y.__name__="DeserializationError";class p{static register(e,r){if(h.has(e))throw new Error(`'${e}' already registered for decoding`);h.set(e,r)}constructor(e,r=new Map,t){this._decoding=!1,this._buffers=new Map,this._finalizable=new Set,this.resolver=e,this.references=r,this.finalize=t}decode(e,r){if(null!=r)for(const[e,t]of r)this._buffers.set(e,t);if(this._decoding)return this._decode(e);let t;this._decoding=!0;const s=(()=>{try{return this._decode(e)}finally{t=new Set(this._finalizable),this._decoding=!1,this._buffers.clear(),this._finalizable.clear()}})();for(const e of t)this.finalize?.(e),e.finalize(),e.assert_initialized();for(const e of t)e.connect_signals();return s}_decode(e){if((0,l.isArray)(e))return this._decode_plain_array(e);if(!(0,l.isPlainObject)(e))return e;if(!(0,l.isString)(e.type))return(0,l.isString)(e.id)?this._decode_ref(e):this._decode_plain_object(e);{const r=h.get(e.type);if(null!=r)return r(e,this);switch(e.type){case"ref":return this._decode_ref(e);case"symbol":return this._decode_symbol(e);case"number":return this._decode_number(e);case"array":return this._decode_array(e);case"set":return this._decode_set(e);case"map":return this._decode_map(e);case"bytes":return this._decode_bytes(e);case"slice":return this._decode_slice(e);case"date":return this._decode_date(e);case"value":return this._decode_value(e);case"field":return this._decode_field(e);case"expr":return this._decode_expr(e);case"typed_array":return this._decode_typed_array(e);case"ndarray":return this._decode_ndarray(e);case"object":return(0,l.isString)(e.id)?this._decode_object_ref(e):this._decode_object(e);default:this.error(`unable to decode an object of type '${e.type}'`)}}}_decode_symbol(e){this.error(`can't resolve named symbol '${e.name}'`)}_decode_number(e){if("value"in e){const{value:r}=e;if((0,l.isString)(r))switch(r){case"nan":return NaN;case"+inf":return 1/0;case"-inf":return-1/0}else if((0,l.isNumber)(r))return r}this.error(`invalid number representation '${e}'`)}_decode_plain_array(e){return(0,c.map)(e,(e=>this._decode(e)))}_decode_plain_object(e){const r={};for(const[t,s]of(0,a.entries)(e))r[t]=this._decode(s);return r}_decode_array(e){const r=[];for(const t of e.entries??[])r.push(this._decode(t));return r}_decode_set(e){const r=new Set;for(const t of e.entries??[])r.add(this._decode(t));return r}_decode_map(e){const r=(0,c.map)(e.entries??[],(([e,r])=>[this._decode(e),this._decode(r)]));return r.every((([e,r])=>(0,l.isString)(e)))?Object.fromEntries(r):new Map(r)}_decode_bytes(e){const{data:r}=e;if(!(0,d.is_ref)(r))return(0,l.isString)(r)?(0,u.base64_to_buffer)(r):r.buffer;{const e=this._buffers.get(r.id);if(null!=e)return e;this.error(`buffer for id=${r.id} not found`)}}_decode_slice(e){const r=this._decode(e.start),t=this._decode(e.stop),s=this._decode(e.step);return new f.Slice({start:r,stop:t,step:s})}_decode_date(e){const r=this._decode(e.iso);return new Date(r)}_decode_value(e){return{value:this._decode(e.value),transform:null!=e.transform?this._decode(e.transform):void 0,units:null!=e.units?this._decode(e.units):void 0}}_decode_field(e){return{field:this._decode(e.field),transform:null!=e.transform?this._decode(e.transform):void 0,units:null!=e.units?this._decode(e.units):void 0}}_decode_expr(e){return{expr:this._decode(e.expr),transform:null!=e.transform?this._decode(e.transform):void 0,units:null!=e.units?this._decode(e.units):void 0}}_decode_typed_array(e){const{array:r,order:t,dtype:s}=e,n=this._decode(r);switch(t!=_.BYTE_ORDER&&(0,u.swap)(n,s),s){case"uint8":return new Uint8Array(n);case"int8":return new Int8Array(n);case"uint16":return new Uint16Array(n);case"int16":return new Int16Array(n);case"uint32":return new Uint32Array(n);case"int32":return new Int32Array(n);case"float32":return new Float32Array(n);case"float64":return new Float64Array(n);default:this.error(`unsupported dtype '${s}'`)}}_decode_ndarray(e){const{array:r,order:t,dtype:s,shape:n}=e,i=this._decode(r);return i instanceof ArrayBuffer&&t!=_.BYTE_ORDER&&(0,u.swap)(i,s),(0,o.ndarray)(i,{dtype:s,shape:n})}_decode_object(e){const{type:r,attributes:t}=e,s=this._resolve_type(r);return null!=t?new s(this._decode(t)):new s}_decode_ref(e){const r=this.references.get(e.id);if(null!=r)return r;this.error(`reference ${e.id} isn't known`)}_decode_object_ref(e){const{id:r,name:t,attributes:s}=e,n=this.references.get(r);if(null==n){const e=new(this._resolve_type(t))({id:r});this.references.set(r,e);const n=this._decode(s??{});return e.initialize_props(n),this._finalizable.add(e),e}if(n.type==t){const e=this._decode(s??{});return n.setv(e,{sync:!1}),n}this.error(`type mismatch for an existing reference '${n}', expected '${t}'`)}error(e){throw new y(e)}warning(e){i.logger.warn(e)}_resolve_type(e){const r=this.resolver.get(e);if(null!=r)return r;this.error(`could not resolve type '${e}', which could be due to a widget or a custom model not being registered before first usage`)}}t.Deserializer=p,p.__name__="Deserializer"},
function _(t,s,e,i,n){i();const c=t(32);class l{constructor({start:t,stop:s,step:e}={}){this.start=t??null,this.stop=s??null,this.step=e??null}[c.serialize](t){return{type:"slice",start:t.encode(this.start),stop:t.encode(this.stop),step:t.encode(this.step)}}}e.Slice=l,l.__name__="Slice"},
function _(e,r,s,t,i){t();const a=e(26),n=/^(?<major>\d+)\.(?<minor>\d+)\.(?<patch>\d+)(?:(?<type>-dev\.|-rc\.|.dev|rc)(?<revision>\d+))?(?:\+(?<build>\d+)\..+)?$/;var o;(o=s.ReleaseType||(s.ReleaseType={}))[o.Dev=0]="Dev",o[o.Candidate=1]="Candidate",o[o.Release=2]="Release";class c{constructor(e,r,t,i=s.ReleaseType.Release,a=0,n=0){this.major=e,this.minor=r,this.patch=t,this.type=i,this.revision=a,this.build=n}static from(e){return function(e){const r=n.exec(e);if(null==r||null==r.groups)return null;const{groups:t}=r,i=Number(t.major),a=Number(t.minor),o=Number(t.patch),l=(()=>{switch(t.type){case"-dev.":case".dev":return s.ReleaseType.Dev;case"-rc.":case"rc":return s.ReleaseType.Candidate;default:return s.ReleaseType.Release}})(),u=void 0===t.revision?0:Number(t.revision),d=void 0===t.build?0:Number(t.build);return new c(i,a,o,l,u,d)}(e)}toString(){const{major:e,minor:r,patch:t,type:i,revision:a,build:n}=this;let o=`${e}.${r}.${t}`;switch(i){case s.ReleaseType.Dev:o+=`-dev.${a}`;case s.ReleaseType.Candidate:o+=`-rc.${a}`;case s.ReleaseType.Release:}return 0!=n&&(o+=`+${n}`),o}[a.equals](e){const{major:r,minor:s,patch:t,type:i,revision:a}=this;return r==e.major&&s==e.minor&&t==e.patch&&i==e.type&&a==e.revision}}s.Version=c,c.__name__="Version"},
function _(n,e,t,c,u){c();const i=n(8);t.execute=function(n,e,...t){return(0,i.isFunction)(n)?n(e,...t):n.execute(e,...t)}},
function _(e,t,s,n,c){var i;n();const r=e(14),a=e(8),l=e(9),o=e(26),_=e(19),h=e(50);class u extends r.HasProps{get is_syncable(){return this.syncable}[o.equals](e,t){return(!!t.structural||t.eq(this.id,e.id))&&super[o.equals](e,t)}constructor(e){super(e)}initialize(){super.initialize(),this._js_callbacks=new Map}connect_signals(){super.connect_signals(),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,(()=>this._update_property_callbacks())),this.connect(this.properties.js_event_callbacks.change,(()=>this._update_event_callbacks())),this.connect(this.properties.subscribed_events.change,(()=>this._update_event_callbacks()))}_process_event(e){for(const t of(0,l.dict)(this.js_event_callbacks).get(e.event_name)??[])(0,h.execute)(t,e);null!=this.document&&this.subscribed_events.has(e.event_name)&&this.document.event_manager.send_event(e)}trigger_event(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))}_update_event_callbacks(){null!=this.document?this.document.event_manager.subscribed_models.add(this):_.logger.warn("WARNING: Document not defined for updating event callbacks")}_update_property_callbacks(){const e=e=>{const[t,s=null]=e.split(":");return null!=s?this.properties[s][t]:this[t]};for(const[t,s]of this._js_callbacks){const n=e(t);for(const e of s)this.disconnect(n,e)}this._js_callbacks.clear();for(const[t,s]of(0,l.dict)(this.js_property_callbacks)){const n=s.map((e=>()=>(0,h.execute)(e,this)));this._js_callbacks.set(t,n);const c=e(t);for(const e of n)this.connect(c,e)}}_doc_attached(){0==this.js_event_callbacks.size&&0==this.subscribed_events.size||this._update_event_callbacks()}_doc_detached(){this.document.event_manager.subscribed_models.delete(this)}select(e){if((0,a.isString)(e))return[...this.references()].filter((t=>t instanceof i&&t.name===e));if((0,a.isPlainObject)(e)&&"type"in e)return[...this.references()].filter((t=>t.type==e.type));if(e.prototype instanceof r.HasProps)return[...this.references()].filter((t=>t instanceof e));throw new Error(`invalid selector ${e}`)}select_one(e){const t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error(`found multiple objects matching the given selector ${e}`)}}get_one(e){const t=this.select_one(e);if(null!=t)return t;throw new Error(`could not find any objects matching the given selector ${e}`)}on_event(e,t){const s=(0,a.isString)(e)?e:e.prototype.event_name,n=(0,l.dict)(this.js_event_callbacks),c=n.get(s)??[];n.set(s,[...c,t])}}s.Model=u,i=u,u.__name__="Model",i.define((({Any:e,Unknown:t,Bool:s,Str:n,List:c,Set:i,Dict:r,Nullable:a})=>({tags:[c(t),[]],name:[a(n),null],js_property_callbacks:[r(c(e)),{}],js_event_callbacks:[r(c(e)),{}],subscribed_events:[i(n),new globalThis.Set],syncable:[s,!0]})))},
function _(e,n,r,t,o){t();const s=e(1),c=e(51),u=s.__importStar(e(21)),a=e(8),i=e(9);r.decode_def=function(e,n){var r;function t(e){if((0,a.isString)(e))switch(e){case"Any":return u.Any;case"Unknown":return u.Unknown;case"Bool":return u.Bool;case"Float":return u.Float;case"Int":return u.Int;case"Bytes":return u.Bytes;case"Str":return u.Str;case"Null":return u.Null}else switch(e[0]){case"Regex":{const[,n,r]=e;return u.Regex(new RegExp(n,r))}case"Nullable":{const[,n]=e;return u.Nullable(t(n))}case"Or":{const[,n,...r]=e;return u.Or(t(n),...r.map(t))}case"Tuple":{const[,n,...r]=e;return u.Tuple(t(n),...r.map(t))}case"List":{const[,n]=e;return u.List(t(n))}case"Struct":{const[,...n]=e,r=n.map((([e,n])=>[e,t(n)]));return u.Struct((0,i.to_object)(r))}case"Dict":{const[,n]=e;return u.Dict(t(n))}case"Mapping":{const[,n,r]=e;return u.Mapping(t(n),t(r))}case"Enum":{const[,...n]=e;return u.Enum(...n)}case"Ref":{const[,r]=e,t=n.resolver.get(r.id);if(null!=t)return u.Ref(t);throw new Error(`${r.id} wasn't defined before referencing it`)}case"AnyRef":return u.AnyRef()}}const o=(()=>{const r=e.extends?.id??"Model";if("Model"==r)return c.Model;const t=n.resolver.get(r);if(null!=t)return t;throw new Error(`base model ${r} of ${e.name} is not defined`)})(),l=(r=class extends o{},s.__setFunctionName(r,"model"),r.__qualified__=e.name,r);function d(e){return void 0===e?e:n.decode(e)}for(const n of e.properties??[]){const e=t(n.kind);l.define({[n.name]:[e,d(n.default)]})}for(const n of e.overrides??[])l.override({[n.name]:d(n.default)});return n.resolver.register(l),l}},
function _(e,t,s,n,a){var _,l,o,r,u,c,i,v,d,m,p,h,x,y,P,E,g,R,M,f,S,D,b,L,k,C,O,U;n();var T=this&&this.__decorate||function(e,t,s,n){var a,_=arguments.length,l=_<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,s):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)l=Reflect.decorate(e,t,s,n);else for(var o=e.length-1;o>=0;o--)(a=e[o])&&(l=(_<3?a(l):_>3?a(t,s,l):a(t,s))||l);return _>3&&l&&Object.defineProperty(t,s,l),l};const B=e(32),I=e(26);function j(e){return t=>{t.prototype.event_name=e}}class w{[B.serialize](e){const{event_name:t,event_values:s}=this;return{type:"event",name:t,values:e.encode(s)}}[I.equals](e,t){return this.event_name==e.event_name&&t.eq(this.event_values,e.event_values)}}s.BokehEvent=w,_=w,w.__name__="BokehEvent",_.prototype.publish=!0;class G extends w{constructor(){super(...arguments),this.origin=null}get event_values(){return{model:this.origin}}}s.ModelEvent=G,G.__name__="ModelEvent";class V extends w{}s.DocumentEvent=V,V.__name__="DocumentEvent";let W=((l=class extends V{get event_values(){return{}}}).__name__="DocumentReady",l);s.DocumentReady=W,s.DocumentReady=W=T([j("document_ready")],W);class q extends V{}s.ConnectionEvent=q,q.__name__="ConnectionEvent";class z extends q{constructor(){super(...arguments),this.timestamp=new Date}get event_values(){const{timestamp:e}=this;return{timestamp:e}}}s.ConnectionLost=z,o=z,z.__name__="ConnectionLost",o.prototype.event_name="connection_lost",o.prototype.publish=!1;let A=((r=class extends G{}).__name__="ButtonClick",r);s.ButtonClick=A,s.ButtonClick=A=T([j("button_click")],A);let F=((u=class extends G{constructor(e){super(),this.item=e}get event_values(){const{item:e}=this;return{...super.event_values,item:e}}}).__name__="MenuItemClick",u);s.MenuItemClick=F,s.MenuItemClick=F=T([j("menu_item_click")],F);let H=((c=class extends G{constructor(e){super(),this.value=e}get event_values(){const{value:e}=this;return{...super.event_values,value:e}}}).__name__="ValueSubmit",c);s.ValueSubmit=H,s.ValueSubmit=H=T([j("value_submit")],H);class J extends G{}s.UIEvent=J,J.__name__="UIEvent";let K=((i=class extends J{}).__name__="LODStart",i);s.LODStart=K,s.LODStart=K=T([j("lodstart")],K);let N=((v=class extends J{}).__name__="LODEnd",v);s.LODEnd=N,s.LODEnd=N=T([j("lodend")],N);let Q=((d=class extends J{constructor(e,t,s,n){super(),this.x0=e,this.x1=t,this.y0=s,this.y1=n}get event_values(){const{x0:e,x1:t,y0:s,y1:n}=this;return{...super.event_values,x0:e,x1:t,y0:s,y1:n}}}).__name__="RangesUpdate",d);s.RangesUpdate=Q,s.RangesUpdate=Q=T([j("rangesupdate")],Q);let X=((m=class extends J{constructor(e,t){super(),this.geometry=e,this.final=t}get event_values(){const{geometry:e,final:t}=this;return{...super.event_values,geometry:e,final:t}}}).__name__="SelectionGeometry",m);s.SelectionGeometry=X,s.SelectionGeometry=X=T([j("selectiongeometry")],X);let Y=((p=class extends J{}).__name__="Reset",p);s.Reset=Y,s.Reset=Y=T([j("reset")],Y);class Z extends J{constructor(e,t,s,n,a){super(),this.sx=e,this.sy=t,this.x=s,this.y=n,this.modifiers=a}get event_values(){const{sx:e,sy:t,x:s,y:n,modifiers:a}=this;return{...super.event_values,sx:e,sy:t,x:s,y:n,modifiers:a}}}s.PointEvent=Z,Z.__name__="PointEvent";let $=((h=class extends Z{constructor(e,t,s,n,a,_,l){super(e,t,s,n,l),this.delta_x=a,this.delta_y=_}get event_values(){const{delta_x:e,delta_y:t}=this;return{...super.event_values,delta_x:e,delta_y:t}}}).__name__="Pan",h);s.Pan=$,s.Pan=$=T([j("pan")],$);let ee=((x=class extends Z{constructor(e,t,s,n,a,_){super(e,t,s,n,_),this.scale=a}get event_values(){const{scale:e}=this;return{...super.event_values,scale:e}}}).__name__="Pinch",x);s.Pinch=ee,s.Pinch=ee=T([j("pinch")],ee);let te=((y=class extends Z{constructor(e,t,s,n,a,_){super(e,t,s,n,_),this.rotation=a}get event_values(){const{rotation:e}=this;return{...super.event_values,rotation:e}}}).__name__="Rotate",y);s.Rotate=te,s.Rotate=te=T([j("rotate")],te);let se=((P=class extends Z{constructor(e,t,s,n,a,_){super(e,t,s,n,_),this.delta=a}get event_values(){const{delta:e}=this;return{...super.event_values,delta:e}}}).__name__="MouseWheel",P);s.MouseWheel=se,s.MouseWheel=se=T([j("wheel")],se);let ne=((E=class extends Z{}).__name__="MouseMove",E);s.MouseMove=ne,s.MouseMove=ne=T([j("mousemove")],ne);let ae=((g=class extends Z{}).__name__="MouseEnter",g);s.MouseEnter=ae,s.MouseEnter=ae=T([j("mouseenter")],ae);let _e=((R=class extends Z{}).__name__="MouseLeave",R);s.MouseLeave=_e,s.MouseLeave=_e=T([j("mouseleave")],_e);let le=((M=class extends Z{}).__name__="Tap",M);s.Tap=le,s.Tap=le=T([j("tap")],le);let oe=((f=class extends Z{}).__name__="DoubleTap",f);s.DoubleTap=oe,s.DoubleTap=oe=T([j("doubletap")],oe);let re=((S=class extends Z{}).__name__="Press",S);s.Press=re,s.Press=re=T([j("press")],re);let ue=((D=class extends Z{}).__name__="PressUp",D);s.PressUp=ue,s.PressUp=ue=T([j("pressup")],ue);let ce=((b=class extends Z{}).__name__="PanStart",b);s.PanStart=ce,s.PanStart=ce=T([j("panstart")],ce);let ie=((L=class extends Z{}).__name__="PanEnd",L);s.PanEnd=ie,s.PanEnd=ie=T([j("panend")],ie);let ve=((k=class extends Z{}).__name__="PinchStart",k);s.PinchStart=ve,s.PinchStart=ve=T([j("pinchstart")],ve);let de=((C=class extends Z{}).__name__="PinchEnd",C);s.PinchEnd=de,s.PinchEnd=de=T([j("pinchend")],de);let me=((O=class extends Z{}).__name__="RotateStart",O);s.RotateStart=me,s.RotateStart=me=T([j("rotatestart")],me);let pe=((U=class extends Z{}).__name__="RotateEnd",U);s.RotateEnd=pe,s.RotateEnd=pe=T([j("rotateend")],pe)},
function _(e,n,t,i,o){i();const r=e(5),a=e(55),s=e(57),c=e(8),d=e(12);t.index=new Proxy(new a.ViewManager,{get(e,n){if((0,c.isString)(n)){const t=e.get_by_id(n);if(null!=t)return t}return Reflect.get(e,n)},has(e,n){if((0,c.isString)(n)){if(null!=e.get_by_id(n))return!0}return Reflect.has(e,n)},ownKeys:e=>e.roots.map((e=>e.model.id)),getOwnPropertyDescriptor(e,n){if((0,c.isString)(n)){const t=e.get_by_id(n);if(null!=t)return{configurable:!0,enumerable:!0,writable:!1,value:t}}return Reflect.getOwnPropertyDescriptor(e,n)}}),t.add_document_standalone=async function(e,n,i=[],o=!1){(0,d.assert)(null==e.views_manager);const c=new a.ViewManager([],t.index);async function l(o){null!=o.default_view?await async function(o){const r=await c.build_view(o);if(r instanceof s.DOMView){const t=e.roots().indexOf(o),a=i[t]??n;r.render_to(a)}t.index.add(r)}(o):e.notify_idle(o)}e.views_manager=c;for(const n of e.roots())await l(n);return o&&(window.document.title=e.title()),e.on_change((e=>{e instanceof r.RootAddedEvent?l(e.model):e instanceof r.RootRemovedEvent?function(e){const n=c.get(e);n?.remove()}(e.model):o&&e instanceof r.TitleChangedEvent&&(window.document.title=e.title)})),c}},
function _(t,e,n,o,i){o();const r=t(56);class s{constructor(t=[],e){this.global=e,this._roots=new Set(t)}toString(){return`ViewManager(${[...this._roots].map((t=>`${t}`)).join(", ")})`}async build_view(t,e=null){const n=await(0,r.build_view)(t,{owner:this,parent:e});return null==e&&this.add(n),n}get(t){for(const e of this._roots)if(e.model==t)return e;return null}get_by_id(t){for(const e of this._roots)if(e.model.id==t)return e;return null}add(t){this._roots.add(t),this.global?.add(t)}delete(t){this._roots.delete(t),this.global?.delete(t)}remove(t){this.delete(t)}clear(){for(const t of this)t.remove()}get roots(){return[...this._roots]}*[Symbol.iterator](){yield*this._roots}*views(){yield*this.query((()=>!0))}*query(t){const e=new Set;function*n(o){if(!e.has(o)){e.add(o),t(o)&&(yield o);for(const t of o.children())yield*n(t)}}for(const t of this._roots)yield*n(t)}query_one(t){for(const e of this.query(t))return e;return null}*find(t){yield*this.query((e=>e.model==t))}*find_by_id(t){yield*this.query((e=>e.model.id==t))}find_one(t){for(const e of this.find(t))return e;return null}find_one_by_id(t){for(const e of this.find_by_id(t))return e;return null}get_one(t){const e=this.find_one(t);if(null!=e)return e;throw new Error(`cannot find a view for ${t}`)}get_one_by_id(t){const e=this.find_one_by_id(t);if(null!=e)return e;throw new Error(`cannot find a view for a model with '${t}' identity`)}find_all(t){return[...this.find(t)]}find_all_by_id(t){return[...this.find_by_id(t)]}}n.ViewManager=s,s.__name__="ViewManager"},
function _(e,n,t,o,i){o();const s=e(10),c=e(12);async function l(e,n,t){(0,c.assert)(null!=e,"model doesn't implement a view");const o=new e({...t,model:n});return o.initialize(),await o.lazy_initialize(),o}t.build_view=async function(e,n={parent:null},t=(e=>e.default_view)){const o=await l(t(e),e,n);return o.connect_signals(),o},t.build_views=async function(e,n,t={parent:null},o=(e=>e.default_view)){const i=(0,s.difference)([...e.keys()],n),c=[];for(const n of i){const t=e.get(n);null!=t&&(e.delete(n),c.push(t),t.remove())}const a=[],r=n.filter((n=>!e.has(n)));for(const n of r){const i=await l(o(n),n,t);e.set(n,i),a.push(i)}for(const e of a)e.connect_signals();return{created:a,removed:c}},t.remove_views=function(e){for(const[n,t]of e)t.remove(),e.delete(n)}},
function _(s,e,t,i,l){i();const _=s(1),a=s(58),h=s(63),c=s(8),n=_.__importDefault(s(66));class r extends a.View{get children_el(){return this.shadow_el??this.el}initialize(){super.initialize(),this.el=this._createElement()}remove(){(0,h.remove)(this.el),super.remove()}stylesheets(){return[]}css_classes(){return[]}render_to(s){this.render(),s?.appendChild(this.el),this.after_render()}after_render(){this.reposition()}finish(){this._has_finished=!0,this.notify_finished()}_createElement(){return(0,h.createElement)(this.constructor.tag_name,{class:this.css_classes()})}reposition(s){}}t.DOMView=r,r.__name__="DOMView",r.tag_name="div";class p extends r{initialize(){super.initialize(),this.class_list=new h.ClassList(this.el.classList)}}t.DOMElementView=p,p.__name__="DOMElementView";class d extends p{constructor(){super(...arguments),this._applied_stylesheets=[],this._applied_css_classes=[]}initialize(){super.initialize(),this.shadow_el=this.el.attachShadow({mode:"open"})}stylesheets(){return[...super.stylesheets(),n.default]}empty(){(0,h.empty)(this.shadow_el),this.class_list.clear(),this._applied_css_classes=[],this._applied_stylesheets=[]}render(){this.empty(),this._update_stylesheets(),this._update_css_classes(),this._update_css_variables()}reposition(s){this._update_css_variables()}*_stylesheets(){for(const s of this.stylesheets())yield(0,c.isString)(s)?new h.InlineStyleSheet(s):s}*_css_classes(){yield`bk-${this.model.type.replace(/\./g,"-")}`,yield*this.css_classes()}*_css_variables(){}_apply_stylesheets(s){this._applied_stylesheets.push(...s),s.forEach((s=>s.install(this.shadow_el)))}_apply_css_classes(s){this._applied_css_classes.push(...s),this.class_list.add(...s)}_update_stylesheets(){this._applied_stylesheets.forEach((s=>s.uninstall())),this._applied_stylesheets=[],this._apply_stylesheets([...this._stylesheets()])}_update_css_classes(){this.class_list.remove(this._applied_css_classes),this._applied_css_classes=[],this._apply_css_classes([...this._css_classes()])}_update_css_variables(){for(const[s,e]of this._css_variables()){const t=s.startsWith("--")?s:`--${s}`;this.el.style.setProperty(t,e)}}}t.DOMComponentView=d,d.__name__="DOMComponentView"},
function _(e,t,s,n,r){n();const i=e(14),o=e(15),l=e(8),h=e(59),a=e(61),_=e(62),c=e(55);class d{get ready(){return this._ready}*children(){}mark_finished(){this._has_finished=!0}connect(e,t){let s=this._slots.get(t);return null==s&&(s=(e,s)=>{const n=Promise.resolve(t.call(this,e,s));this._ready=this._ready.then((()=>n)),this.root!=this&&(this.root._ready=this.root._ready.then((()=>this._ready)))},this._slots.set(t,s)),e.connect(s,this)}disconnect(e,t){return e.disconnect(t,this)}constructor(e){this.removed=new o.Signal0(this,"removed"),this._ready=Promise.resolve(void 0),this._slots=new WeakMap,this._destroyed=!1,this._idle_notified=!1;const{model:t,parent:s,owner:n}=e;this.model=t,this.parent=s,null==s?(this.root=this,this.owner=n??new c.ViewManager([this])):(this.root=s.root,this.owner=this.root.owner)}initialize(){this._has_finished=!1}async lazy_initialize(){}remove(){this.disconnect_signals(),this.owner.remove(this),this.removed.emit(),this._destroyed=!0}get is_destroyed(){return this._destroyed}toString(){return`${this.model.type}View(${this.model.id})`}serializable_state(){return{type:this.model.type}}get is_root(){return null==this.parent}has_finished(){return this._has_finished}get is_idle(){return this.has_finished()}connect_signals(){}disconnect_signals(){o.Signal.disconnect_receiver(this)}on_change(e,t){for(const s of(0,l.isArray)(e)?e:[e])this.connect(s.change,t)}on_transitive_change(e,t){const s=()=>{const t=e.is_unset?[]:e.get_value();return i.HasProps.references(t,{recursive:!1})},n=e=>{for(const s of e)this.connect(s.change,t)},r=e=>{for(const s of e)this.disconnect(s.change,t)};let o=s();n(o),this.on_change(e,(()=>{r(o),o=s(),n(o),t()}))}cursor(e,t){return null}notify_finished(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()}resolve_frame(){return null}resolve_canvas(){return null}resolve_plot(){return null}resolve_target(e){if(!(0,l.isString)(e)){const t=[this.root];for(;;){const s=t.shift();if(null==s)break;if(s.model==e)return s;t.push(...s.children())}return null}{const t=e=>{let t=this;for(;null!=t;){const s=e(t);if(null!=s)return s;t=t.parent}return null};switch(e){case"parent":return this.parent;case"frame":return t((e=>e.resolve_frame()));case"canvas":return t((e=>e.resolve_canvas()));case"plot":return t((e=>e.resolve_plot()))}}}resolve_symbol(e){return{x:NaN,y:NaN}}resolve_node(e){const t=this.resolve_target(e.target);return null!=t?t.resolve_symbol(e):{x:NaN,y:NaN}}resolve_coordinate(e){if(e instanceof a.XY){let t=this;for(;null!=t&&null==t.resolve_xy;)t=t.parent;return t?.resolve_xy?.(e)??{x:NaN,y:NaN}}if(e instanceof _.Indexed){let t=this;for(;null!=t&&null==t.resolve_indexed;)t=t.parent;return t?.resolve_indexed?.(e)??{x:NaN,y:NaN}}return e instanceof h.Node?this.resolve_node(e):{x:NaN,y:NaN}}resolve_as_xy(e){const t=this.resolve_coordinate(e);return(0,l.isNumber)(t)?{x:NaN,y:NaN}:t}resolve_as_scalar(e,t){const s=this.resolve_coordinate(e);return(0,l.isNumber)(s)?s:s[t]}}s.View=d,d.__name__="View"},
function _(t,e,r,n,o){var s;n();const a=t(60),i=t(51),_=t(21);r.ImplicitTarget=(0,_.Enum)("canvas","plot","frame","parent"),r.NodeTarget=(0,_.Or)((0,_.Ref)(i.Model),r.ImplicitTarget);class h{constructor(t,e=!1){this._left=null,this._right=null,this._top=null,this._bottom=null,this.target=t,this.frozen=e}_node(t){const{target:e,frozen:r}=this,n=new l({target:e,symbol:t});return r&&(this[`_${t}`]=n),n}get left(){return this._left??this._node("left")}get right(){return this._right??this._node("right")}get top(){return this._top??this._node("top")}get bottom(){return this._bottom??this._node("bottom")}freeze(){return new h(this.target,!0)}}r.BoxNodes=h,h.__name__="BoxNodes";class l extends a.Coordinate{constructor(t){super(t)}static get frame(){return this._frame_nodes}static get canvas(){return this._canvas_nodes}}r.Node=l,s=l,l.__name__="Node",s.define((({Str:t,Int:e})=>({target:[r.NodeTarget],symbol:[t],offset:[e,0]}))),l._frame_nodes=new h("frame"),l._canvas_nodes=new h("canvas")},
function _(o,n,e,t,s){t();const c=o(51);class r extends c.Model{constructor(o){super(o)}}e.Coordinate=r,r.__name__="Coordinate"},
function _(n,e,o,t,s){var a;t();const c=n(60);class r extends c.Coordinate{constructor(n){super(n)}}o.XY=r,a=r,r.__name__="XY",a.define((({Float:n})=>({x:[n],y:[n]})))},
function _(e,n,d,r,t){var o;r();const s=e(60);class c extends s.Coordinate{constructor(e){super(e)}}d.Indexed=c,o=c,c.__name__="Indexed",o.define((({Int:e,AnyRef:n})=>({index:[e],renderer:[n()]})))},
function _(t,e,n,i,o){i(),n.supports_adopted_stylesheets=n.px=n.dom_ready=n.GlobalImportedStyleSheet=void 0;const s=t(8),l=t(9),r=t(64),c=t(65),a=t=>(e={},...n)=>{const i=document.createElement(t);(0,s.isPlainObject)(e)||(n=[e,...n],e={});for(let[t,n]of(0,l.entries)(e))if(null!=n&&(!(0,s.isBoolean)(n)||n))if("class"===t&&((0,s.isString)(n)&&(n=n.split(/\s+/)),(0,s.isArray)(n)))for(const t of n)null!=t&&i.classList.add(t);else if("style"===t&&(0,s.isPlainObject)(n))for(const[t,e]of(0,l.entries)(n))i.style[t]=e;else if("data"===t&&(0,s.isPlainObject)(n))for(const[t,e]of(0,l.entries)(n))i.dataset[t]=e;else i.setAttribute(t,n);function o(t){if((0,s.isString)(t))i.appendChild(document.createTextNode(t));else if(t instanceof Node)i.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)for(const e of t)i.appendChild(e);else if(null!=t&&!1!==t)throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(t)}`)}for(const t of n)if((0,s.isArray)(t))for(const e of t)o(e);else o(t);return i};function d(t){return document.createTextNode(t)}function h(t){const e=t.parentNode;null!=e&&e.removeChild(t)}function u(t){const e=parseFloat(t);return isFinite(e)?e:0}function f(t){const e=getComputedStyle(t);return{border:{top:u(e.borderTopWidth),bottom:u(e.borderBottomWidth),left:u(e.borderLeftWidth),right:u(e.borderRightWidth)},margin:{top:u(e.marginTop),bottom:u(e.marginBottom),left:u(e.marginLeft),right:u(e.marginRight)},padding:{top:u(e.paddingTop),bottom:u(e.paddingBottom),left:u(e.paddingLeft),right:u(e.paddingRight)}}}function p(t){const e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}n.createElement=function(t,e,...n){return a(t)(e,...n)},n.div=a("div"),n.span=a("span"),n.canvas=a("canvas"),n.link=a("link"),n.style=a("style"),n.a=a("a"),n.p=a("p"),n.i=a("i"),n.pre=a("pre"),n.button=a("button"),n.label=a("label"),n.legend=a("legend"),n.fieldset=a("fieldset"),n.input=a("input"),n.select=a("select"),n.option=a("option"),n.optgroup=a("optgroup"),n.textarea=a("textarea"),n.createSVGElement=function(t,e=null,...n){const i=document.createElementNS("http://www.w3.org/2000/svg",t);for(const[t,n]of(0,l.entries)(e??{}))null!=n&&!1!==n&&i.setAttribute(t,n);function o(t){if((0,s.isString)(t))i.appendChild(document.createTextNode(t));else if(t instanceof Node)i.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)for(const e of t)i.appendChild(e);else if(null!=t&&!1!==t)throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(t)}`)}for(const t of n)if((0,s.isArray)(t))for(const e of t)o(e);else o(t);return i},n.text=d,n.nbsp=function(){return d("\xa0")},n.append=function(t,...e){for(const n of e)t.appendChild(n)},n.remove=h,n.replaceWith=function(t,e){const n=t.parentNode;null!=n&&n.replaceChild(e,t)},n.prepend=function(t,...e){const n=t.firstChild;for(const i of e)t.insertBefore(i,n)},n.empty=function(t,e=!1){let n;for(;null!=(n=t.firstChild);)t.removeChild(n);if(e&&t instanceof Element)for(const e of t.attributes)t.removeAttributeNode(e)},n.contains=function(t,e){let n=e;for(;null!=n.parentNode;){const e=n.parentNode;if(e==t)return!0;n=e instanceof ShadowRoot?e.host:e}return!1},n.display=function(t,e=!0){t.style.display=e?"":"none"},n.undisplay=function(t){t.style.display="none"},n.show=function(t){t.style.visibility=""},n.hide=function(t){t.style.visibility="hidden"},n.offset_bbox=function(t){const{top:e,left:n,width:i,height:o}=t.getBoundingClientRect();return new r.BBox({left:n+scrollX-document.documentElement.clientLeft,top:e+scrollY-document.documentElement.clientTop,width:i,height:o})},n.parent=function(t,e){let n=t;for(;null!=(n=n.parentElement);)if(n.matches(e))return n;return null},n.extents=f,n.size=p,n.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},n.outer_size=function(t){const{margin:{left:e,right:n,top:i,bottom:o}}=f(t),{width:s,height:l}=p(t);return{width:Math.ceil(s+e+n),height:Math.ceil(l+i+o)}},n.content_size=function(t){const{left:e,top:n}=t.getBoundingClientRect(),{padding:i}=f(t);let o=0,s=0;for(const l of(t.shadowRoot??t).children){const t=l.getBoundingClientRect();o=Math.max(o,Math.ceil(t.left-e-i.left+t.width)),s=Math.max(s,Math.ceil(t.top-n-i.top+t.height))}return{width:o,height:s}},n.bounding_box=function(t){const{x:e,y:n,width:i,height:o}=t.getBoundingClientRect();return new r.BBox({x:e,y:n,width:i,height:o})},n.box_size=function(t){const{width:e,height:n}=t.getBoundingClientRect();return{width:e,height:n}},n.position=function(t,e,n){const{style:i}=t;if(i.left=`${e.x}px`,i.top=`${e.y}px`,i.width=`${e.width}px`,i.height=`${e.height}px`,null==n)i.margin="";else{const{top:t,right:e,bottom:o,left:s}=n;i.margin=`${t}px ${e}px ${o}px ${s}px`}};class g{constructor(t){this.class_list=t}get values(){const t=[];for(let e=0;e<this.class_list.length;e++){const n=this.class_list.item(e);null!=n&&t.push(n)}return t}has(t){return this.class_list.contains(t)}add(...t){for(const e of t)this.class_list.add(e);return this}remove(...t){for(const e of t)(0,s.isArray)(e)?e.forEach((t=>this.class_list.remove(t))):this.class_list.remove(e);return this}clear(){for(const t of this.values)this.class_list.remove(t);return this}toggle(t,e){return(null!=e?e:!this.has(t))?this.add(t):this.remove(t),this}}var m;n.ClassList=g,g.__name__="ClassList",n.classes=function(t){return new g(t.classList)},n.toggle_attribute=function(t,e,n){null==n&&(n=!t.hasAttribute(e)),n?t.setAttribute(e,"true"):t.removeAttribute(e)},(m=n.MouseButton||(n.MouseButton={}))[m.None=0]="None",m[m.Primary=1]="Primary",m[m.Secondary=2]="Secondary",m[m.Auxiliary=4]="Auxiliary",m[m.Left=1]="Left",m[m.Right=2]="Right",m[m.Middle=4]="Middle";class _{install(t){t.append(this.el)}uninstall(){this.el.remove()}}n.StyleSheet=_,_.__name__="StyleSheet";class y extends _{constructor(t){super(),this.el=(0,n.style)({type:"text/css"}),(0,s.isString)(t)?this._update(t):null!=t&&this._update((0,c.compose_stylesheet)(t))}get css(){return this.el.textContent??""}_update(t){this.el.textContent=t}clear(){this.replace("")}_to_css(t,e){return null==e?t:(0,c.compose_stylesheet)({[t]:e})}replace(t,e){this._update(this._to_css(t,e))}prepend(t,e){this._update(`${this._to_css(t,e)}\n${this.css}`)}append(t,e){this._update(`${this.css}\n${this._to_css(t,e)}`)}remove(){h(this.el)}}n.InlineStyleSheet=y,y.__name__="InlineStyleSheet";class b extends y{install(){this.el.isConnected||document.head.appendChild(this.el)}}n.GlobalInlineStyleSheet=b,b.__name__="GlobalInlineStyleSheet";class x extends _{constructor(t){super(),this.el=(0,n.link)({rel:"stylesheet",href:t})}replace(t){this.el.href=t}remove(){h(this.el)}}n.ImportedStyleSheet=x,x.__name__="ImportedStyleSheet";class S extends x{install(){this.el.isConnected||document.head.appendChild(this.el)}}n.GlobalImportedStyleSheet=S,S.__name__="GlobalImportedStyleSheet",n.dom_ready=async function(){if("loading"==document.readyState)return new Promise(((t,e)=>{document.addEventListener("DOMContentLoaded",(()=>t()),{once:!0})}))},n.px=function(t){return(0,s.isNumber)(t)?`${t}px`:t},n.supports_adopted_stylesheets="adoptedStyleSheets"in ShadowRoot.prototype},
function _(t,e,i,r,h){r();const s=t(24),n=t(26),o=t(13),x=t(8),{min:y,max:u,round:g}=Math;function c(t,e){return isNaN(t)?e:isNaN(e)?t:y(t,e)}function a(t,e){return isNaN(t)?e:isNaN(e)?t:u(t,e)}i.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},i.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},i.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},i.union=function(t,e){return{x0:c(t.x0,e.x0),x1:a(t.x1,e.x1),y0:c(t.y0,e.y0),y1:a(t.y1,e.y1)}},i.isXY=function(t){return(0,x.isPlainObject)(t)&&"x"in t&&"y"in t};class _{constructor(t,e=!1){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){const{x0:e,y0:i,x1:r,y1:h}=t;if(isFinite(e+i+r+h)){if(!(e<=r&&i<=h))throw new Error(`invalid bbox {x0: ${e}, y0: ${i}, x1: ${r}, y1: ${h}}`);this.x0=e,this.y0=i,this.x1=r,this.y1=h}else this.x0=NaN,this.y0=NaN,this.x1=NaN,this.y1=NaN}else if("x"in t){const{x:e,y:i,width:r,height:h}=t;if(!(r>=0&&h>=0))throw new Error(`invalid bbox {x: ${e}, y: ${i}, width: ${r}, height: ${h}}`);this.x0=e,this.y0=i,this.x1=e+r,this.y1=i+h}else{let i,r,h,s;if("width"in t)if("left"in t)i=t.left,r=i+t.width;else if("right"in t)r=t.right,i=r-t.width;else{const e=t.width/2;i=t.hcenter-e,r=t.hcenter+e}else i=t.left,r=t.right;if("height"in t)if("top"in t)h=t.top,s=h+t.height;else if("bottom"in t)s=t.bottom,h=s-t.height;else{const e=t.height/2;h=t.vcenter-e,s=t.vcenter+e}else h=t.top,s=t.bottom;if(i>r||h>s){if(!e)throw new Error(`invalid bbox {left: ${i}, top: ${h}, right: ${r}, bottom: ${s}}`);i>r&&(i=r),h>s&&(h=s)}this.x0=i,this.y0=h,this.x1=r,this.y1=s}}static from_lrtb({left:t,right:e,top:i,bottom:r}){return new _({x0:Math.min(t,e),y0:Math.min(i,r),x1:Math.max(t,e),y1:Math.max(i,r)})}clone(){return new _(this)}equals(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1}[n.equals](t,e){return e.eq(this.x0,t.x0)&&e.eq(this.y0,t.y0)&&e.eq(this.x1,t.x1)&&e.eq(this.y1,t.y1)}toString(){return`BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`}get is_valid(){const{x0:t,x1:e,y0:i,y1:r}=this;return isFinite(t+e+i+r)}get is_empty(){const{x0:t,x1:e,y0:i,y1:r}=this;return 0==t&&0==e&&0==i&&0==r}get left(){return this.x0}get top(){return this.y0}get right(){return this.x1}get bottom(){return this.y1}get p0(){return{x:this.x0,y:this.y0}}get p1(){return{x:this.x1,y:this.y1}}get x(){return this.x0}get y(){return this.y0}get width(){return this.x1-this.x0}get height(){return this.y1-this.y0}get size(){return{width:this.width,height:this.height}}get rect(){const{x0:t,y0:e,x1:i,y1:r}=this;return{p0:{x:t,y:e},p1:{x:i,y:e},p2:{x:i,y:r},p3:{x:t,y:r}}}get box(){const{x:t,y:e,width:i,height:r}=this;return{x:t,y:e,width:i,height:r}}get lrtb(){const{left:t,right:e,top:i,bottom:r}=this;return{left:t,right:e,top:i,bottom:r}}get x_range(){return{start:this.x0,end:this.x1}}get y_range(){return{start:this.y0,end:this.y1}}get h_range(){return this.x_range}get v_range(){return this.y_range}get ranges(){return[this.x_range,this.y_range]}get aspect(){return this.width/this.height}get hcenter(){return(this.left+this.right)/2}get vcenter(){return(this.top+this.bottom)/2}get area(){return this.width*this.height}resolve(t){switch(t){case"top_left":return{x:this.left,y:this.top};case"top_center":return{x:this.hcenter,y:this.top};case"top_right":return{x:this.right,y:this.top};case"center_left":return{x:this.left,y:this.vcenter};case"center_center":case"center":return{x:this.hcenter,y:this.vcenter};case"center_right":return{x:this.right,y:this.vcenter};case"bottom_left":return{x:this.left,y:this.bottom};case"bottom_center":return{x:this.hcenter,y:this.bottom};case"bottom_right":return{x:this.right,y:this.bottom};case"top":return this.top;case"left":return this.left;case"right":return this.right;case"bottom":return this.bottom;case"width":return this.width;case"height":return this.height;default:return{x:NaN,y:NaN}}}round(){return new _({x0:g(this.x0),x1:g(this.x1),y0:g(this.y0),y1:g(this.y1)})}relative(){const{width:t,height:e}=this;return new _({x:0,y:0,width:t,height:e})}translate(t,e){const{x:i,y:r,width:h,height:s}=this;return new _({x:t+i,y:e+r,width:h,height:s})}scale(t){return new _({x0:this.x0*t,x1:this.x1*t,y0:this.y0*t,y1:this.y1*t})}relativize(t,e){return[t-this.x,e-this.y]}contains(t,e){return this.x0<=t&&t<=this.x1&&this.y0<=e&&e<=this.y1}clip(t,e){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),e<this.y0?e=this.y0:e>this.y1&&(e=this.y1),[t,e]}grow_by(t){return new _({left:this.left-t,right:this.right+t,top:this.top-t,bottom:this.bottom+t})}shrink_by(t){return new _({left:this.left+t,right:this.right-t,top:this.top+t,bottom:this.bottom-t},!0)}union(t){return new _({x0:y(this.x0,t.x0),y0:y(this.y0,t.y0),x1:u(this.x1,t.x1),y1:u(this.y1,t.y1)})}intersection(t){return this.intersects(t)?new _({x0:u(this.x0,t.x0),y0:u(this.y0,t.y0),x1:y(this.x1,t.x1),y1:y(this.y1,t.y1)}):null}intersects(t){return!(t.x1<this.x0||t.x0>this.x1||t.y1<this.y0||t.y0>this.y1)}get x_screen(){const t=this;return this._x_screen??(this._x_screen={compute:e=>t.left+e,invert:e=>e-t.left,v_compute(e){const{left:i}=t;return new s.ScreenArray((0,o.map)(e,(t=>i+t)))},v_invert(e){const{left:i}=t;return(0,o.map)(e,(t=>t-i))},get source_range(){return t.x_range},get target_range(){return t.x_range}})}get y_screen(){const t=this;return this._y_screen??(this._y_screen={compute:e=>t.top+e,invert:e=>e-t.top,v_compute(e){const{top:i}=t;return new s.ScreenArray((0,o.map)(e,(t=>i+t)))},v_invert(e){const{top:i}=t;return(0,o.map)(e,(t=>t-i))},get source_range(){return t.y_range},get target_range(){return t.y_range}})}get x_view(){const t=this;return this._x_view??(this._x_view={compute:e=>t.left+e,invert:e=>e-t.left,v_compute(e){const{left:i}=t;return new s.ScreenArray((0,o.map)(e,(t=>i+t)))},v_invert(e){const{left:i}=t;return(0,o.map)(e,(t=>t-i))},get source_range(){return t.x_range},get target_range(){return t.x_range}})}get y_view(){const t=this;return this._y_view??(this._y_view={compute:e=>t.bottom-e,invert:e=>t.bottom-e,v_compute(e){const{bottom:i}=t;return new s.ScreenArray((0,o.map)(e,(t=>i-t)))},v_invert(e){const{bottom:i}=t;return(0,o.map)(e,(t=>i-t))},get source_range(){return t.y_range},get target_range(){return{start:t.bottom,end:t.top}}})}get xview(){return this.x_view}get yview(){return this.y_view}}i.BBox=_,_.__name__="BBox"},
function _(n,t,e,o,r){o();const s=n(19),i=n(9),c=n(8),l=document.createElement("div").style;function f(n){if(n.startsWith("--"))return n;const t=n.replaceAll(/_/g,"-").replaceAll(/[A-Z]/g,(n=>`-${n.toLowerCase()}`));if(t in l)return t;const e=`-webkit-${t}`;if(e in l)return e;const o=`-moz-${t}`;return o in l?o:(s.logger.warn(`unknown CSS property '${n}'`),null)}function*u(n){if((0,c.isPlainObject)(n)||n instanceof Map)for(const[t,e]of(0,i.entries)(n)){const n=f(t);null!=n&&(yield[n,e])}else for(const t of n.own_properties())if(t.dirty){const n=f(t.attr);null!=n&&(yield[n,t.get_value()])}}e.apply_styles=function(n,t){for(const[e,o]of u(t))(0,c.isString)(o)?n.setProperty(e,o):n.removeProperty(e)},e.compose_stylesheet=function(n){const t=[];for(const[e,o]of(0,i.entries)(n)){t.push(`${e} {`);for(const[n,e]of u(o))(0,c.isString)(e)&&0!=e.length&&t.push(`  ${n}: ${e};`);t.push("}")}return t.join("\n")}},
function _(e,o,i,n,t){n(),i.default=":host{--base-font:var(--bokeh-base-font, Helvetica, Arial, sans-serif);--mono-font:var(--bokeh-mono-font, monospace);--font-size:var(--bokeh-font-size, 12px);--line-height:calc(20 / 14);--line-height-computed:calc(var(--font-size) * var(--line-height));--border-radius:4px;--padding-vertical:6px;--padding-horizontal:12px;--bokeh-top-level:1000;}:host{box-sizing:border-box;font-family:var(--base-font);font-size:var(--font-size);line-height:var(--line-height);}*,*:before,*:after{box-sizing:inherit;font-family:inherit;}pre,code{font-family:var(--mono-font);margin:0;}"},
function _(n,t,o,e,s){e();const a=n(68),c=n(19),r=n(54);o._get_ws_url=function(n,t){let o,e="ws:";return"https:"==window.location.protocol&&(e="wss:"),null!=t?(o=document.createElement("a"),o.href=t):o=window.location,null!=n?"/"==n&&(n=""):n=o.pathname.replace(/\/+$/,""),`${e}//${o.host}${n}/ws`};const i=new Map;o.add_document_from_session=async function(n,t,o,e=[],s=!1){const l=window.location.search.substring(1);let d;try{d=await function(n,t,o){const e=(0,a.parse_token)(t).session_id;i.has(n)||i.set(n,new Map);const s=i.get(n);return s.has(e)||s.set(e,(0,a.pull_session)(n,t,o)),s.get(e)}(n,t,l)}catch(n){const o=(0,a.parse_token)(t).session_id;throw c.logger.error(`Failed to load Bokeh session ${o}: ${n}`),n}return(0,r.add_document_standalone)(d.document,o,e,s)}},
function _(e,s,n,t,o){t();const r=e(19),i=e(5),l=e(69),c=e(70),_=e(71);n.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",n.DEFAULT_TOKEN="eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";let h=0;function a(e){let s=e.split(".")[0];const n=s.length%4;return 0!=n&&(s+="=".repeat(4-n)),JSON.parse(atob(s.replace(/_/g,"/").replace(/-/g,"+")))}n.parse_token=a;class d{constructor(e=n.DEFAULT_SERVER_WEBSOCKET_URL,s=n.DEFAULT_TOKEN,t=null){this._number=h++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_replies=new Map,this._pending_messages=[],this._receiver=new c.Receiver,this.url=e,this.token=s,this.args_string=t,this.id=a(s).session_id.split(".")[0],r.logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`)}async connect(){if(this.closed_permanently)throw new Error("Cannot connect() a closed ClientConnection");if(null!=this.socket)throw new Error("Already connected");this._current_handler=null,this._pending_replies.clear(),this._pending_messages=[];try{let e=`${this.url}`;return null!=this.args_string&&this.args_string.length>0&&(e+=`?${this.args_string}`),this.socket=new WebSocket(e,["bokeh",this.token]),new Promise(((e,s)=>{this.socket.binaryType="arraybuffer",this.socket.onopen=()=>this._on_open(e,s),this.socket.onmessage=e=>this._on_message(e),this.socket.onclose=e=>this._on_close(e,s),this.socket.onerror=()=>this._on_error(s)}))}catch(e){throw r.logger.error(`websocket creation failed to url: ${this.url}`),r.logger.error(` - ${e}`),e}}close(){this.closed_permanently||(r.logger.debug(`Permanently closing websocket connection ${this._number}`),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,`close method called on ClientConnection ${this._number}`),this.session._connection_closed())}_schedule_reconnect(e){setTimeout((()=>{this.closed_permanently||(r.logger.info(`Websocket connection ${this._number} disconnected, will not attempt to reconnect`),this.session?.notify_connection_lost())}),e)}send(e){null!=this.socket?e.send(this.socket):r.logger.error("not connected so cannot send",e)}async send_with_reply(e){const s=await new Promise(((s,n)=>{this._pending_replies.set(e.msgid(),{resolve:s,reject:n}),this.send(e)}));if("ERROR"==s.msgtype())throw new Error(`Error reply ${s.content.text}`);return s}async _pull_doc_json(){const e=l.Message.create("PULL-DOC-REQ",{},{}),s=await this.send_with_reply(e);if(!("doc"in s.content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return s.content.doc}async _repull_session_doc(e,s){r.logger.debug(null!=this.session?"Repulling session":"Pulling session for first time");try{const n=await this._pull_doc_json();if(null==this.session)if(this.closed_permanently)r.logger.debug("Got new document after connection was already closed"),s(new Error("The connection has been closed"));else{const s=[],t=i.Document.from_json(n,s);this.session=new _.ClientSession(this,t);for(const e of s)t._trigger_on_change(e);for(const e of this._pending_messages)this.session.handle(e);this._pending_messages=[],r.logger.debug("Created a new session from new pulled doc"),e(this.session)}else this.session.document.replace_with_json(n),r.logger.debug("Updated existing session with new pulled doc")}catch(e){console.trace(e),r.logger.error(`Failed to repull session ${e}`),s(e instanceof Error?e:`${e}`)}}_on_open(e,s){r.logger.info(`Websocket connection ${this._number} is now open`),this._current_handler=n=>{this._awaiting_ack_handler(n,e,s)}}_on_message(e){null==this._current_handler&&r.logger.error("Got a message with no current handler set");try{this._receiver.consume(e.data)}catch(e){this._close_bad_protocol(`${e}`)}const s=this._receiver.message;if(null!=s){const e=s.problem();null!=e&&this._close_bad_protocol(e),this._current_handler(s)}}_on_close(e,s){r.logger.info(`Lost websocket ${this._number} connection, ${e.code} (${e.reason})`),this.socket=null,this._pending_replies.forEach((e=>e.reject("Disconnected"))),this._pending_replies.clear(),this.closed_permanently||this._schedule_reconnect(2e3),s(new Error(`Lost websocket connection, ${e.code} (${e.reason})`))}_on_error(e){r.logger.debug(`Websocket error on socket ${this._number}`);const s="Could not open websocket";r.logger.error(`Failed to connect to Bokeh server: ${s}`),e(new Error(s))}_close_bad_protocol(e){r.logger.error(`Closing connection: ${e}`),null!=this.socket&&this.socket.close(1002,e)}_awaiting_ack_handler(e,s,n){"ACK"===e.msgtype()?(this._current_handler=e=>this._steady_state_handler(e),this._repull_session_doc(s,n)):this._close_bad_protocol("First message was not an ACK")}_steady_state_handler(e){const s=e.reqid(),n=this._pending_replies.get(s);null!=n?(this._pending_replies.delete(s),n.resolve(e)):null!=this.session?this.session.handle(e):"PATCH-DOC"!=e.msgtype()&&this._pending_messages.push(e)}}n.ClientConnection=d,d.__name__="ClientConnection",n.pull_session=function(e,s,n){return new d(e,s,n).connect()}},
function _(e,s,t,r,n){r();const i=e(32),a=e(40),h=e(12);class f{get buffers(){return this._buffers}constructor(e,s,t){this._buffers=new Map,this.header=e,this.metadata=s,this.content=t}static assemble(e,s,t){const r=JSON.parse(e),n=JSON.parse(s),i=JSON.parse(t);return new f(r,n,i)}assemble_buffer(e,s){const t=this.header.num_buffers??0;if(t<=this._buffers.size)throw new Error(`too many buffers received, expecting ${t}`);const{id:r}=JSON.parse(e);this._buffers.set(r,s)}static create(e,s,t){const r=f.create_header(e);return new f(r,s,t)}static create_header(e){return{msgid:(0,a.unique_id)(),msgtype:e}}complete(){const{num_buffers:e}=this.header;return null==e||this._buffers.size==e}send(e){(0,h.assert)(null==this.header.num_buffers);const s=[],t=JSON.stringify(this.content,((e,t)=>{if(t instanceof i.Buffer){const e={id:`${s.length}`};return s.push([e,t.buffer]),e}return t})),r=s.length;r>0&&(this.header.num_buffers=r);const n=JSON.stringify(this.header),a=JSON.stringify(this.metadata);e.send(n),e.send(a),e.send(t);for(const[t,r]of s)e.send(JSON.stringify(t)),e.send(r)}msgid(){return this.header.msgid}msgtype(){return this.header.msgtype}reqid(){return this.header.reqid}problem(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"}}t.Message=f,f.__name__="Message"},
function _(t,e,s,_,r){_();const i=t(69),h=t(8),a=t(12);class n{constructor(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}consume(t){this._current_consumer(t)}_HEADER(t){this._assume_text(t),this.message=null,this._partial=null,this._fragments=[t],this._buf_header=null,this._current_consumer=this._METADATA}_METADATA(t){this._assume_text(t),this._fragments.push(t),this._current_consumer=this._CONTENT}_CONTENT(t){this._assume_text(t),this._fragments.push(t);const[e,s,_]=this._fragments;(0,a.assert)(null!=e&&null!=s&&null!=_),this._partial=i.Message.assemble(e,s,_),this._check_complete()}_BUFFER_HEADER(t){this._assume_text(t),this._buf_header=t,this._current_consumer=this._BUFFER_PAYLOAD}_BUFFER_PAYLOAD(t){this._assume_binary(t),(0,a.assert)(null!=this._partial&&null!=this._buf_header),this._partial.assemble_buffer(this._buf_header,t),this._check_complete()}_assume_text(t){if(!(0,h.isString)(t))throw new Error("Expected text fragment but received binary fragment")}_assume_binary(t){if(!(t instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")}_check_complete(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER}}s.Receiver=n,n.__name__="Receiver"},
function _(e,n,t,o,s){o();const c=e(5),i=e(53),_=e(69),r=e(19);class a{constructor(e,n){this._document_listener=e=>{this._document_changed(e)},this._connection=e,this.document=n,this.document.on_change(this._document_listener,!0)}get id(){return this._connection.id}handle(e){const n=e.msgtype();switch(n){case"PATCH-DOC":this._handle_patch(e);break;case"OK":this._handle_ok(e);break;case"ERROR":this._handle_error(e);break;default:r.logger.debug(`Doing nothing with message '${n}'`)}}notify_connection_lost(){this.document.event_manager.send_event(new i.ConnectionLost)}close(){this._connection.close()}_connection_closed(){this.document.remove_on_change(this._document_listener)}async request_server_info(){const e=_.Message.create("SERVER-INFO-REQ",{},{});return(await this._connection.send_with_reply(e)).content}async force_roundtrip(){await this.request_server_info()}_document_changed(e){const n=(e instanceof c.DocumentEventBatch?e.sync?e.events:[]:[e]).filter((e=>e.sync));if(0==n.length)return;const t=this.document.create_json_patch(n),o=_.Message.create("PATCH-DOC",{},t);this._connection.send(o)}_handle_patch(e){this.document.apply_json_patch(e.content,e.buffers)}_handle_ok(e){r.logger.trace(`Unhandled OK reply to ${e.reqid()}`)}_handle_error(e){r.logger.error(`Unhandled ERROR reply to ${e.reqid()}: ${e.content.text}`)}}t.ClientSession=a,a.__name__="ClientSession"},
function _(n,e,o,t,r){t();const i=n(63),l=n(8);function s(n){let e=(0,l.isString)(n)?document.getElementById(n):n;if(null==e)throw new Error(`Error rendering Bokeh model: could not find ${(0,l.isString)(n)?`#${n}`:n} HTML tag`);if(!(0,i.contains)(document.body,e))throw new Error(`Error rendering Bokeh model: element ${(0,l.isString)(n)?`#${n}`:n} must be under <body>`);if(e instanceof HTMLElement&&"SCRIPT"==e.tagName){const n=(0,i.div)();(0,i.replaceWith)(e,n),e=n}return e}o._resolve_element=function(n){const{elementid:e}=n;return null!=e?s(e):document.body},o._resolve_root_elements=function(n){const e=[];if(null!=n.root_ids&&null!=n.roots)for(const o of n.root_ids)e.push(s(n.roots[o]));return e}},
function _(e,o,t,n,r){n();const s=e(5),i=e(70),c=e(19),l=e(9),g=e(54),a=e(72);function f(e,o){o.buffers.length>0?e.consume(o.buffers[0].buffer):e.consume(o.content.data);const t=e.message;null!=t&&this.apply_json_patch(t.content,t.buffers)}function m(e,o){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){c.logger.info(`Registering Jupyter comms for target ${e}`);const t=Jupyter.notebook.kernel.comm_manager;try{t.register_target(e,(t=>{c.logger.info(`Registering Jupyter comms for target ${e}`);const n=new i.Receiver;t.on_msg(f.bind(o,n))}))}catch(e){c.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if(o.roots()[0].id in t.kernels){c.logger.info(`Registering JupyterLab comms for target ${e}`);const n=t.kernels[o.roots()[0].id];try{n.registerCommTarget(e,(t=>{c.logger.info(`Registering JupyterLab comms for target ${e}`);const n=new i.Receiver;t.onMsg=f.bind(o,n)}))}catch(e){c.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if("undefined"!=typeof google&&null!=google.colab.kernel){c.logger.info(`Registering Google Colab comms for target ${e}`);const t=google.colab.kernel.comms;try{t.registerTarget(e,(async t=>{c.logger.info(`Registering Google Colab comms for target ${e}`);const n=new i.Receiver;for await(const e of t.messages){const t={data:e.data},r=[];for(const o of e.buffers??[])r.push(new DataView(o));const s={content:t,buffers:r};f.bind(o)(n,s)}}))}catch(e){c.logger.warn(`Google Colab comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.")}t.kernels={},t.embed_items_notebook=async function(e,o){if(1!=(0,l.size)(e))throw new Error("embed_items_notebook expects exactly one document in docs_json");const t=s.Document.from_json((0,l.values)(e)[0]);for(const e of o){null!=e.notebook_comms_target&&m(e.notebook_comms_target,t);const o=(0,a._resolve_element)(e),n=(0,a._resolve_root_elements)(e);await(0,g.add_document_standalone)(t,o,n);for(const e of n)e instanceof HTMLElement&&e.removeAttribute("id")}}},
function _(t,_,o,r,n){r();const a=t(1);a.__exportStar(t(69),o),a.__exportStar(t(70),o)},
function _(e,t,o,l,n){l(),o.safely=function(e,t=!1){try{return e()}catch(e){if(function(e){const t=document.createElement("div");t.style.backgroundColor="#f2dede",t.style.border="1px solid #a94442",t.style.borderRadius="4px",t.style.display="inline-block",t.style.fontFamily="sans-serif",t.style.marginTop="5px",t.style.minWidth="200px",t.style.padding="5px 5px 5px 10px",t.classList.add("bokeh-error-box-into-flames");const o=document.createElement("span");o.style.backgroundColor="#a94442",o.style.borderRadius="0px 4px 0px 0px",o.style.color="white",o.style.cursor="pointer",o.style.cssFloat="right",o.style.fontSize="0.8em",o.style.margin="-6px -6px 0px 0px",o.style.padding="2px 5px 4px 5px",o.title="close",o.setAttribute("aria-label","close"),o.appendChild(document.createTextNode("x")),o.addEventListener("click",(()=>s.removeChild(t)));const l=document.createElement("h3");l.style.color="#a94442",l.style.margin="8px 0px 0px 0px",l.style.padding="0px",l.appendChild(document.createTextNode("Bokeh Error"));const n=document.createElement("pre");n.style.whiteSpace="unset",n.style.overflowX="auto",n.appendChild(document.createTextNode(e)),t.appendChild(o),t.appendChild(l),t.appendChild(n);const s=document.getElementsByTagName("body")[0];s.insertBefore(t,s.firstChild)}(e instanceof Error&&null!=e.stack?e.stack:`${e}`),t)return;throw e}}},
function _(t,r,o,_,e){_();const s=t(1),i=t(7),m=s.__importStar(t(77));(0,i.register_models)(m);const n=s.__importStar(t(526));(0,i.register_models)(n)},
function _(t,_,r,o,a){o();const e=t(1);e.__exportStar(t(78),r),e.__exportStar(t(262),r),e.__exportStar(t(310),r),e.__exportStar(t(320),r),e.__exportStar(t(325),r),e.__exportStar(t(326),r),e.__exportStar(t(335),r),e.__exportStar(t(238),r),e.__exportStar(t(344),r),e.__exportStar(t(386),r),e.__exportStar(t(387),r),e.__exportStar(t(391),r),e.__exportStar(t(393),r),e.__exportStar(t(267),r),e.__exportStar(t(415),r),e.__exportStar(t(416),r),e.__exportStar(t(425),r),e.__exportStar(t(442),r),e.__exportStar(t(443),r),e.__exportStar(t(252),r),e.__exportStar(t(445),r),e.__exportStar(t(250),r),e.__exportStar(t(448),r),e.__exportStar(t(449),r),e.__exportStar(t(454),r),e.__exportStar(t(197),r),e.__exportStar(t(459),r),e.__exportStar(t(468),r),e.__exportStar(t(472),r),e.__exportStar(t(482),r)},
function _(e,o,a,n,r){n();const t=e(1);r("Annotation",e(79).Annotation),r("Arrow",e(123).Arrow),r("ArrowHead",e(165).ArrowHead),r("OpenHead",e(165).OpenHead),r("NormalHead",e(165).NormalHead),r("TeeHead",e(165).TeeHead),r("VeeHead",e(165).VeeHead),r("BaseColorBar",e(167).BaseColorBar),r("Band",e(257).Band),r("BoxAnnotation",e(259).BoxAnnotation),r("ColorBar",e(261).ColorBar),r("ContourColorBar",e(277).ContourColorBar),r("Label",e(278).Label),r("LabelSet",e(279).LabelSet),r("Legend",e(280).Legend),r("LegendItem",e(281).LegendItem),r("PolyAnnotation",e(282).PolyAnnotation),r("ScaleBar",e(283).ScaleBar);var l=e(284);r("Metric",l.Metric),r("ReciprocalMetric",l.ReciprocalMetric),r("MetricLength",l.MetricLength),r("ReciprocalMetricLength",l.ReciprocalMetricLength),r("ImperialLength",l.ImperialLength),r("Angular",l.Angular),r("Slope",e(285).Slope),r("Span",e(286).Span),r("TextAnnotation",e(169).TextAnnotation),r("Title",e(168).Title),r("ToolbarPanel",e(287).ToolbarPanel),r("Whisker",e(304).Whisker),t.__exportStar(e(305),a)},
function _(t,e,i,n,s){var o;n();const r=t(80);class l extends r.CompositeRendererView{get_size(){if(this.displayed){const{width:t,height:e}=this._get_size();return{width:Math.round(t),height:Math.round(e)}}return{width:0,height:0}}_get_size(){throw new Error("not implemented")}connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.visible,(()=>{null!=this.layout&&(this.layout.visible=this.model.visible,this.plot_view.request_layout())}))}get needs_clip(){return null==this.layout}serializable_state(){const t=super.serializable_state(),e=this.bbox?.round()??this.layout?.bbox;return null==e?t:{...t,bbox:e}}}i.AnnotationView=l,l.__name__="AnnotationView";class a extends r.CompositeRenderer{constructor(t){super(t)}}i.Annotation=a,o=a,a.__name__="Annotation",o.override({level:"annotation"})},
function _(e,s,i,t,r){var n;t();const _=e(81),a=e(107),d=e(122),l=e(56),o=e(21),h=(0,o.Or)((0,o.Ref)(a.UIElement),(0,o.Ref)(d.DOMNode));class w extends _.RendererView{constructor(){super(...arguments),this._renderer_views=new Map,this._element_views=new Map,this._has_rendered_elements=!1}get renderer_views(){return this.model.renderers.map((e=>this._renderer_views.get(e)))}get element_views(){return this.model.elements.map((e=>this._element_views.get(e)))}*children(){yield*super.children(),yield*this.renderer_views,yield*this.element_views}async lazy_initialize(){await super.lazy_initialize(),await this._build_renderers(),await this._build_elements()}async _build_renderers(){return await(0,l.build_views)(this._renderer_views,this.model.renderers,{parent:this.plot_view})}async _build_elements(){return await(0,l.build_views)(this._element_views,this.model.elements,{parent:this.plot_view})}async _update_renderers(){await this._build_renderers()}async _update_elements(){const{created:e}=await this._build_elements(),s=new Set(e);if(0!=s.size){for(const e of this.element_views)e.el.remove();for(const e of this.element_views){s.has(e)?e.render_to(this.plot_view.shadow_el):this.plot_view.shadow_el.append(e.el)}}}remove(){(0,l.remove_views)(this._renderer_views),(0,l.remove_views)(this._element_views),super.remove()}connect_signals(){super.connect_signals();const{renderers:e,elements:s}=this.model.properties;this.on_change(e,(async()=>{await this._update_renderers()})),this.on_change(s,(async()=>{await this._update_elements()}))}render(){if(!this._has_rendered_elements){for(const e of this.element_views)e.render_to(this.plot_view.shadow_el);this._has_rendered_elements=!0}super.render();const{displayed:e}=this;for(const s of this.element_views)s.reposition(e)}has_finished(){if(!super.has_finished())return!1;for(const e of this.renderer_views)if(!e.has_finished())return!1;for(const e of this.element_views)if(!e.has_finished())return!1;return!0}serializable_state(){const{children:e,...s}=super.serializable_state();return{...s,children:[...e??[],...this.renderer_views.map((e=>e.serializable_state())),...this.element_views.map((e=>e.serializable_state()))]}}}i.CompositeRendererView=w,w.__name__="CompositeRendererView";class m extends _.Renderer{constructor(e){super(e)}}i.CompositeRenderer=m,n=m,m.__name__="CompositeRenderer",n.define((({List:e,Ref:s})=>({renderers:[e(s(_.Renderer)),[]],elements:[e(h),[]]})))},
function _(e,t,i,n,s){var r,o;n();const a=e(1),_=e(58),l=e(56),u=a.__importStar(e(82)),c=e(20),d=e(8),h=e(51),m=e(12),p=e(91),v=e(64),g=e(106);class f extends h.Model{constructor(e){super(e)}}i.RendererGroup=f,r=f,f.__name__="RendererGroup",r.define((({Bool:e})=>({visible:[e,!0]})));class y extends _.View{constructor(){super(...arguments),this._context_menu=null,this._custom_coordinates=null}get context_menu(){return this._context_menu}get coordinates(){const{_coordinates:e}=this;return null!=e?e:this._coordinates=this._initialize_coordinates()}set coordinates(e){this._custom_coordinates=e}initialize(){super.initialize(),this.visuals=new u.Visuals(this)}async lazy_initialize(){await super.lazy_initialize();const{context_menu:e}=this.model;null!=e&&(this._context_menu=await(0,l.build_view)(e,{parent:this.plot_view}))}remove(){this._context_menu?.remove(),super.remove()}connect_signals(){super.connect_signals();const{group:e}=this.model;null!=e&&this.on_change(e.properties.visible,(()=>{this.model.visible=e.visible}));const{x_range_name:t,y_range_name:i}=this.model.properties;this.on_change([t,i],(()=>delete this._coordinates)),this.connect(this.plot_view.frame.change,(()=>delete this._coordinates))}_initialize_coordinates(){if(null!=this._custom_coordinates)return this._custom_coordinates;const{coordinates:e}=this.model,{frame:t}=this.plot_view;if(null!=e)return e.get_transform(t);{const{x_range_name:e,y_range_name:i}=this.model,n=t.x_scales.get(e),s=t.y_scales.get(i);return(0,m.assert)(null!=n,`missing '${e}' range`),(0,m.assert)(null!=s,`missing '${i}' range`),new p.CoordinateTransform(n,s)}}get plot_view(){return this.parent}get plot_model(){return this.parent.model}get layer(){const{overlays:e,primary:t}=this.canvas;return"overlay"==this.model.level?e:t}get canvas(){return this.plot_view.canvas_view}request_render(){this.request_paint()}request_paint(){this.plot_view.request_paint(this)}request_layout(){this.plot_view.request_layout()}notify_finished(){this.plot_view.notify_finished()}notify_finished_after_paint(){this.plot_view.notify_finished_after_paint()}get needs_clip(){return!1}get has_webgl(){return!1}get displayed(){return this.model.visible}render(){this.update_geometry(),this.compute_geometry(),this.displayed&&this._render(),this._has_finished=!0}renderer_view(e){}update_geometry(){}compute_geometry(){}resolve_frame(){return this.plot_view.frame}resolve_canvas(){return this.plot_view.canvas}resolve_plot(){return this.plot_view}resolve_symbol(e){const t=this;if("bbox"in t&&t.bbox instanceof v.BBox){const i=t.bbox.resolve(e.symbol),{offset:n}=e;if((0,d.isNumber)(i))return i+n;{const{x:e,y:t}=i;return{x:e+n,y:t+n}}}return{x:NaN,y:NaN}}get attribution(){return null}}i.RendererView=y,y.__name__="RendererView";class w extends h.Model{constructor(e){super(e)}}i.Renderer=w,o=w,w.__name__="Renderer",o.define((({Bool:e,Str:t,Ref:i,Nullable:n})=>({group:[n(i(f)),null],level:[c.RenderLevel,"image"],visible:[e,!0],x_range_name:[t,"default"],y_range_name:[t,"default"],coordinates:[n(i(p.CoordinateMapping)),null],propagate_hover:[e,!1],context_menu:[n(i(g.Menu)),null]})))},
function _(e,a,r,t,c){t();const n=e(1),l=e(83);c("Line",l.Line),c("LineScalar",l.LineScalar),c("LineVector",l.LineVector);const s=e(86);c("Fill",s.Fill),c("FillScalar",s.FillScalar),c("FillVector",s.FillVector);const i=e(87);c("Text",i.Text),c("TextScalar",i.TextScalar),c("TextVector",i.TextVector);const o=e(88);c("Hatch",o.Hatch),c("HatchScalar",o.HatchScalar),c("HatchVector",o.HatchVector);const u=e(90);c("Image",u.Image),c("ImageScalar",u.ImageScalar),c("ImageVector",u.ImageVector);const V=n.__importStar(e(85)),S=e(84);c("VisualProperties",S.VisualProperties),c("VisualUniforms",S.VisualUniforms);class m{*[Symbol.iterator](){yield*this._visuals}constructor(e){this._visuals=[];for(const[a,r]of e.model._mixins){const t=(()=>{switch(r){case V.Line:return new l.Line(e,a);case V.LineScalar:return new l.LineScalar(e,a);case V.LineVector:return new l.LineVector(e,a);case V.Fill:return new s.Fill(e,a);case V.FillScalar:return new s.FillScalar(e,a);case V.FillVector:return new s.FillVector(e,a);case V.Text:return new i.Text(e,a);case V.TextScalar:return new i.TextScalar(e,a);case V.TextVector:return new i.TextVector(e,a);case V.Hatch:return new o.Hatch(e,a);case V.HatchScalar:return new o.HatchScalar(e,a);case V.HatchVector:return new o.HatchVector(e,a);case V.Image:return new u.Image(e,a);case V.ImageScalar:return new u.ImageScalar(e,a);case V.ImageVector:return new u.ImageVector(e,a);default:throw new Error("unknown visual")}})();t instanceof S.VisualProperties&&t.update(),this._visuals.push(t),Object.defineProperty(this,a+t.type,{get:()=>t,configurable:!1,enumerable:!0})}}}r.Visuals=m,m.__name__="Visuals"},
function _(e,t,i,l,s){l();const a=e(1),n=e(84),h=a.__importStar(e(85)),o=e(22),_=e(8);function r(e){if((0,_.isArray)(e))return e;switch(e){case"solid":return[];case"dashed":return[6];case"dotted":return[2,4];case"dotdash":return[2,4,6,4];case"dashdot":return[6,4,2,4];default:return e.split(" ").map(Number).filter(_.isInteger)}}i.resolve_line_dash=r;class u extends n.VisualProperties{get doit(){const e=this.line_color.get_value(),t=this.line_alpha.get_value(),i=this.line_width.get_value();return!(null==e||0==t||0==i)}apply(e){const{doit:t}=this;return t&&(this.set_value(e),e.stroke()),t}values(){return{color:this.line_color.get_value(),alpha:this.line_alpha.get_value(),width:this.line_width.get_value(),join:this.line_join.get_value(),cap:this.line_cap.get_value(),dash:this.line_dash.get_value(),offset:this.line_dash_offset.get_value()}}set_value(e){const t=this.line_color.get_value(),i=this.line_alpha.get_value();e.strokeStyle=(0,o.color2css)(t,i),e.lineWidth=this.line_width.get_value(),e.lineJoin=this.line_join.get_value(),e.lineCap=this.line_cap.get_value(),e.setLineDash(r(this.line_dash.get_value())),e.lineDashOffset=this.line_dash_offset.get_value()}}i.Line=u,u.__name__="Line";class c extends n.VisualUniforms{get doit(){const e=this.line_color.value,t=this.line_alpha.value,i=this.line_width.value;return!(0==e||0==t||0==i)}apply(e){const{doit:t}=this;return t&&(this.set_value(e),e.stroke()),t}values(){return{color:this.line_color.value,alpha:this.line_alpha.value,width:this.line_width.value,join:this.line_join.value,cap:this.line_cap.value,dash:this.line_dash.value,offset:this.line_dash_offset.value}}set_value(e){const t=this.line_color.value,i=this.line_alpha.value;e.strokeStyle=(0,o.color2css)(t,i),e.lineWidth=this.line_width.value,e.lineJoin=this.line_join.value,e.lineCap=this.line_cap.value,e.setLineDash(r(this.line_dash.value)),e.lineDashOffset=this.line_dash_offset.value}}i.LineScalar=c,c.__name__="LineScalar";class d extends n.VisualUniforms{get doit(){const{line_color:e}=this;if(e.is_Scalar()&&0==e.value)return!1;const{line_alpha:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{line_width:i}=this;return!i.is_Scalar()||0!=i.value}v_doit(e){return 0!=this.line_color.get(e)&&(0!=this.line_alpha.get(e)&&0!=this.line_width.get(e))}apply(e,t){const i=this.v_doit(t);return i&&(this.set_vectorize(e,t),e.stroke()),i}values(e){return{color:this.line_color.get(e),alpha:this.line_alpha.get(e),width:this.line_width.get(e),join:this.line_join.get(e),cap:this.line_cap.get(e),dash:this.line_dash.get(e),offset:this.line_dash_offset.get(e)}}set_vectorize(e,t){const i=this.line_color.get(t),l=this.line_alpha.get(t),s=this.line_width.get(t),a=this.line_join.get(t),n=this.line_cap.get(t),h=this.line_dash.get(t),_=this.line_dash_offset.get(t);e.strokeStyle=(0,o.color2css)(i,l),e.lineWidth=s,e.lineJoin=a,e.lineCap=n,e.setLineDash(r(h)),e.lineDashOffset=_}}i.LineVector=d,d.__name__="LineVector",u.prototype.type="line",u.prototype.attrs=Object.keys(h.Line),c.prototype.type="line",c.prototype.attrs=Object.keys(h.LineScalar),d.prototype.type="line",d.prototype.attrs=Object.keys(h.LineVector)},
function _(t,s,o,i,r){i();class e{*[Symbol.iterator](){yield*this._props}constructor(t,s=""){this.obj=t,this.prefix=s;const o=this;this._props=[];for(const i of this.attrs){const r=t.model.properties[s+i];r.change.connect((()=>this.update())),o[i]=r,this._props.push(r)}}update(){}}o.VisualProperties=e,e.__name__="VisualProperties";class p{*[Symbol.iterator](){for(const t of this.attrs)yield this.obj.model.properties[this.prefix+t]}constructor(t,s=""){this.obj=t,this.prefix=s;for(const o of this.attrs)Object.defineProperty(this,o,{get:()=>t[s+o]})}update(){}}o.VisualUniforms=p,p.__name__="VisualUniforms"},
function _(l,e,a,t,o){t();const c=l(1),r=c.__importStar(l(18)),n=l(20),_=c.__importStar(l(21)),i=l(9),h=l(8);a.Line={line_color:[_.Nullable(_.Color),"black"],line_alpha:[_.Alpha,1],line_width:[_.Float,1],line_join:[n.LineJoin,"bevel"],line_cap:[n.LineCap,"butt"],line_dash:[_.Or(n.LineDash,_.Array(_.Float)),[]],line_dash_offset:[_.Float,0]},a.Fill={fill_color:[_.Nullable(_.Color),"gray"],fill_alpha:[_.Alpha,1]},a.Image={global_alpha:[_.Alpha,1]},a.Hatch={hatch_color:[_.Nullable(_.Color),"black"],hatch_alpha:[_.Alpha,1],hatch_scale:[_.Float,12],hatch_pattern:[_.Nullable(_.Or(n.HatchPatternType,_.Str)),null],hatch_weight:[_.Float,1],hatch_extra:[_.Dict(_.AnyRef()),{}]},a.Text={text_color:[_.Nullable(_.Color),"#444444"],text_outline_color:[_.Nullable(_.Color),null],text_alpha:[_.Alpha,1],text_font:[r.Font,"helvetica"],text_font_size:[_.FontSize,"16px"],text_font_style:[n.FontStyle,"normal"],text_align:[n.TextAlign,"left"],text_baseline:[n.TextBaseline,"bottom"],text_line_height:[_.Float,1.2]},a.LineScalar={line_color:[r.ColorScalar,"black"],line_alpha:[r.NumberScalar,1],line_width:[r.NumberScalar,1],line_join:[r.LineJoinScalar,"bevel"],line_cap:[r.LineCapScalar,"butt"],line_dash:[r.LineDashScalar,[]],line_dash_offset:[r.NumberScalar,0]},a.FillScalar={fill_color:[r.ColorScalar,"gray"],fill_alpha:[r.NumberScalar,1]},a.ImageScalar={global_alpha:[r.NumberScalar,1]},a.HatchScalar={hatch_color:[r.ColorScalar,"black"],hatch_alpha:[r.NumberScalar,1],hatch_scale:[r.NumberScalar,12],hatch_pattern:[r.NullStringScalar,null],hatch_weight:[r.NumberScalar,1],hatch_extra:[r.DictScalar,{}]},a.TextScalar={text_color:[r.ColorScalar,"#444444"],text_outline_color:[r.ColorScalar,null],text_alpha:[r.NumberScalar,1],text_font:[r.FontScalar,"helvetica"],text_font_size:[r.FontSizeScalar,"16px"],text_font_style:[r.FontStyleScalar,"normal"],text_align:[r.TextAlignScalar,"left"],text_baseline:[r.TextBaselineScalar,"bottom"],text_line_height:[r.NumberScalar,1.2]},a.LineVector={line_color:[r.ColorSpec,"black"],line_alpha:[r.NumberSpec,1],line_width:[r.NumberSpec,1],line_join:[r.LineJoinSpec,"bevel"],line_cap:[r.LineCapSpec,"butt"],line_dash:[r.LineDashSpec,[]],line_dash_offset:[r.NumberSpec,0]},a.FillVector={fill_color:[r.ColorSpec,"gray"],fill_alpha:[r.NumberSpec,1]},a.ImageVector={global_alpha:[r.NumberSpec,1]},a.HatchVector={hatch_color:[r.ColorSpec,"black"],hatch_alpha:[r.NumberSpec,1],hatch_scale:[r.NumberSpec,12],hatch_pattern:[r.NullStringSpec,null],hatch_weight:[r.NumberSpec,1],hatch_extra:[r.DictScalar,{}]},a.TextVector={text_color:[r.ColorSpec,"#444444"],text_outline_color:[r.ColorSpec,null],text_alpha:[r.NumberSpec,1],text_font:[r.FontSpec,"helvetica"],text_font_size:[r.FontSizeSpec,"16px"],text_font_style:[r.FontStyleSpec,"normal"],text_align:[r.TextAlignSpec,"left"],text_baseline:[r.TextBaselineSpec,"bottom"],text_line_height:[r.NumberSpec,1.2]},a.attrs_of=function(l,e,a,t=!1){const o={};for(const c of(0,i.keys)(a)){const a=`${e}${c}`,r=l[a];o[(0,h.isString)(t)?`${t}${c}`:t?a:c]=r}return o}},
function _(l,t,e,i,s){i();const a=l(1),o=l(84),r=a.__importStar(l(85)),_=l(22);class c extends o.VisualProperties{get doit(){const l=this.fill_color.get_value(),t=this.fill_alpha.get_value();return!(null==l||0==t)}apply(l,t){const{doit:e}=this;return e&&(this.set_value(l),l.fill(t)),e}values(){return{color:this.fill_color.get_value(),alpha:this.fill_alpha.get_value()}}set_value(l){const t=this.fill_color.get_value(),e=this.fill_alpha.get_value();l.fillStyle=(0,_.color2css)(t,e)}}e.Fill=c,c.__name__="Fill";class h extends o.VisualUniforms{get doit(){const l=this.fill_color.value,t=this.fill_alpha.value;return!(0==l||0==t)}apply(l,t){const{doit:e}=this;return e&&(this.set_value(l),l.fill(t)),e}values(){return{color:this.fill_color.value,alpha:this.fill_alpha.value}}set_value(l){const t=this.fill_color.value,e=this.fill_alpha.value;l.fillStyle=(0,_.color2css)(t,e)}}e.FillScalar=h,h.__name__="FillScalar";class u extends o.VisualUniforms{get doit(){const{fill_color:l}=this;if(l.is_Scalar()&&0==l.value)return!1;const{fill_alpha:t}=this;return!t.is_Scalar()||0!=t.value}v_doit(l){return 0!=this.fill_color.get(l)&&0!=this.fill_alpha.get(l)}apply(l,t,e){const i=this.v_doit(t);return i&&(this.set_vectorize(l,t),l.fill(e)),i}values(l){return{color:this.fill_color.get(l),alpha:this.fill_alpha.get(l)}}set_vectorize(l,t){const e=this.fill_color.get(t),i=this.fill_alpha.get(t);l.fillStyle=(0,_.color2css)(e,i)}}e.FillVector=u,u.__name__="FillVector",c.prototype.type="fill",c.prototype.attrs=Object.keys(r.Fill),h.prototype.type="fill",h.prototype.attrs=Object.keys(r.FillScalar),u.prototype.type="fill",u.prototype.attrs=Object.keys(r.FillVector)},
function _(t,e,l,s,o){s();const i=t(1),_=t(84),a=i.__importStar(t(85)),n=t(22),h=new Map;function r(t,e){const l=h.get(t);if(null==l){const l=new WeakSet([e]);h.set(t,l)}else{if(l.has(e))return;l.add(e)}const{fonts:s}=document;s.check(t)||s.load(t).then((()=>e.request_render()))}class u extends _.VisualProperties{get doit(){const t=this.text_color.get_value(),e=this.text_alpha.get_value();return!(null==t||0==e)}update(){if(!this.doit)return;r(this.font_value(),this.obj)}values(){return{color:this.text_color.get_value(),outline_color:this.text_outline_color.get_value(),alpha:this.text_alpha.get_value(),font:this.text_font.get_value(),font_size:this.text_font_size.get_value(),font_style:this.text_font_style.get_value(),align:this.text_align.get_value(),baseline:this.text_baseline.get_value(),line_height:this.text_line_height.get_value()}}set_value(t){const e=this.text_color.get_value(),l=this.text_outline_color.get_value(),s=this.text_alpha.get_value();t.fillStyle=(0,n.color2css)(e,s),t.strokeStyle=(0,n.color2css)(l,s),t.font=this.font_value(),t.textAlign=this.text_align.get_value(),t.textBaseline=this.text_baseline.get_value()}font_value(){return`${this.text_font_style.get_value()} ${this.text_font_size.get_value()} ${this.text_font.get_value()}`}}l.Text=u,u.__name__="Text";class x extends _.VisualUniforms{get doit(){const t=this.text_color.value,e=this.text_alpha.value;return!(0==t||0==e)}update(){if(!this.doit)return;r(this.font_value(),this.obj)}values(){return{color:this.text_color.value,outline_color:this.text_outline_color.value,alpha:this.text_alpha.value,font:this.text_font.value,font_size:this.text_font_size.value,font_style:this.text_font_style.value,align:this.text_align.value,baseline:this.text_baseline.value,line_height:this.text_line_height.value}}set_value(t){const e=this.text_color.value,l=this.text_alpha.value,s=this.text_outline_color.value,o=this.font_value(),i=this.text_align.value,_=this.text_baseline.value;t.fillStyle=(0,n.color2css)(e,l),t.strokeStyle=(0,n.color2css)(s,l),t.font=o,t.textAlign=i,t.textBaseline=_}font_value(){return`${this.text_font_style.value} ${this.text_font_size.value} ${this.text_font.value}`}}l.TextScalar=x,x.__name__="TextScalar";class c extends _.VisualUniforms{_assert_font(t){r(this.font_value(t),this.obj)}values(t){return this._assert_font(t),{color:this.text_color.get(t),outline_color:this.text_outline_color.get(t),alpha:this.text_alpha.get(t),font:this.text_font.get(t),font_size:this.text_font_size.get(t),font_style:this.text_font_style.get(t),align:this.text_align.get(t),baseline:this.text_baseline.get(t),line_height:this.text_line_height.get(t)}}get doit(){const{text_color:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{text_alpha:e}=this;return!e.is_Scalar()||0!=e.value}v_doit(t){return 0!=this.text_color.get(t)&&0!=this.text_alpha.get(t)}apply(t,e){const l=this.v_doit(e);return l&&this.set_vectorize(t,e),l}set_vectorize(t,e){this._assert_font(e);const l=this.text_color.get(e),s=this.text_outline_color.get(e),o=this.text_alpha.get(e),i=this.font_value(e),_=this.text_align.get(e),a=this.text_baseline.get(e);t.fillStyle=(0,n.color2css)(l,o),t.strokeStyle=(0,n.color2css)(s,o),t.font=i,t.textAlign=_,t.textBaseline=a}font_value(t){return`${this.text_font_style.get(t)} ${this.text_font_size.get(t)} ${this.text_font.get(t)}`}}l.TextVector=c,c.__name__="TextVector",u.prototype.type="text",u.prototype.attrs=Object.keys(a.Text),x.prototype.type="text",x.prototype.attrs=Object.keys(a.TextScalar),c.prototype.type="text",c.prototype.attrs=Object.keys(a.TextVector)},
function _(t,e,a,i,r){i();const h=t(1),s=t(84),n=t(89),c=h.__importStar(t(18)),_=h.__importStar(t(85)),l=t(9);class o extends s.VisualProperties{constructor(){super(...arguments),this._update_iteration=0}update(){if(this._update_iteration++,this._hatch_image=null,!this.doit)return;const t=this.hatch_color.get_value(),e=this.hatch_alpha.get_value(),a=this.hatch_scale.get_value(),i=this.hatch_pattern.get_value(),r=this.hatch_weight.get_value(),h=t=>{this._hatch_image=t},s=(0,l.dict)(this.hatch_extra.get_value()).get(i);if(null!=s){const i=s.get_pattern(t,e,a,r);if(i instanceof Promise){const{_update_iteration:t}=this;i.then((e=>{this._update_iteration==t&&(h(e),this.obj.request_render())}))}else h(i)}else{const s=this.obj.canvas.create_layer(),c=(0,n.get_pattern)(s,i,t,e,a,r);h(c)}}get doit(){const t=this.hatch_color.get_value(),e=this.hatch_alpha.get_value(),a=this.hatch_pattern.get_value();return!(null==t||0==e||" "==a||"blank"==a||null==a)}apply(t,e){const{doit:a}=this;return a&&(this.set_value(t),t.layer.undo_transform((()=>t.fill(e)))),a}set_value(t){const e=this.pattern(t);t.fillStyle=e??"transparent"}pattern(t){const e=this._hatch_image;return null==e?null:t.createPattern(e,this.repetition())}repetition(){const t=this.hatch_pattern.get_value(),e=(0,l.dict)(this.hatch_extra.get_value()).get(t);if(null==e)return"repeat";switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}}a.Hatch=o,o.__name__="Hatch";class u extends s.VisualUniforms{constructor(){super(...arguments),this._static_doit=!1,this._update_iteration=0}_compute_static_doit(){const t=this.hatch_color.value,e=this.hatch_alpha.value,a=this.hatch_pattern.value;return!(0==t||0==e||" "==a||"blank"==a||null==a)}update(){this._update_iteration++;const t=this.hatch_color.length;if(this._hatch_image=new c.UniformScalar(null,t),this._static_doit=this._compute_static_doit(),!this._static_doit)return;const e=this.hatch_color.value,a=this.hatch_alpha.value,i=this.hatch_scale.value,r=this.hatch_pattern.value,h=this.hatch_weight.value,s=e=>{this._hatch_image=new c.UniformScalar(e,t)},_=(0,l.dict)(this.hatch_extra.value).get(r);if(null!=_){const t=_.get_pattern(e,a,i,h);if(t instanceof Promise){const{_update_iteration:e}=this;t.then((t=>{this._update_iteration==e&&(s(t),this.obj.request_render())}))}else s(t)}else{const t=this.obj.canvas.create_layer(),c=(0,n.get_pattern)(t,r,e,a,i,h);s(c)}}get doit(){return this._static_doit}apply(t,e){const{doit:a}=this;return a&&(this.set_value(t),t.layer.undo_transform((()=>t.fill(e)))),a}set_value(t){t.fillStyle=this.pattern(t)??"transparent"}pattern(t){const e=this._hatch_image.value;return null==e?null:t.createPattern(e,this.repetition())}repetition(){const t=this.hatch_pattern.value;if(null!=t){const e=(0,l.dict)(this.hatch_extra.value).get(t);if(null!=e)switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}return"repeat"}}a.HatchScalar=u,u.__name__="HatchScalar";class p extends s.VisualUniforms{constructor(){super(...arguments),this._static_doit=!1,this._update_iteration=0}_compute_static_doit(){const{hatch_color:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{hatch_alpha:e}=this;if(e.is_Scalar()&&0==e.value)return!1;const{hatch_pattern:a}=this;if(a.is_Scalar()){const t=a.value;if(" "==t||"blank"==t||null==t)return!1}return!0}update(){this._update_iteration++;const t=this.hatch_color.length;if(this._hatch_image=new c.UniformScalar(null,t),this._static_doit=this._compute_static_doit(),!this._static_doit)return;const e=(t,e,a,i,r,h)=>{const s=(0,l.dict)(this.hatch_extra.value).get(t);if(null!=s){const t=s.get_pattern(e,a,i,r);if(t instanceof Promise){const{_update_iteration:e}=this;t.then((t=>{this._update_iteration==e&&(h(t),this.obj.request_render())}))}else h(t)}else{const s=this.obj.canvas.create_layer(),c=(0,n.get_pattern)(s,t,e,a,i,r);h(c)}};if(this.hatch_color.is_Scalar()&&this.hatch_alpha.is_Scalar()&&this.hatch_scale.is_Scalar()&&this.hatch_pattern.is_Scalar()&&this.hatch_weight.is_Scalar()){const a=this.hatch_color.value,i=this.hatch_alpha.value,r=this.hatch_scale.value;e(this.hatch_pattern.value,a,i,r,this.hatch_weight.value,(e=>{this._hatch_image=new c.UniformScalar(e,t)}))}else{const a=new Array(t);a.fill(null),this._hatch_image=new c.UniformVector(a);for(let i=0;i<t;i++){const t=this.hatch_color.get(i),r=this.hatch_alpha.get(i),h=this.hatch_scale.get(i);e(this.hatch_pattern.get(i),t,r,h,this.hatch_weight.get(i),(t=>{a[i]=t}))}}}get doit(){return this._static_doit}v_doit(t){if(!this.doit)return!1;if(0==this.hatch_color.get(t))return!1;if(0==this.hatch_alpha.get(t))return!1;const e=this.hatch_pattern.get(t);return" "!=e&&"blank"!=e&&null!=e}apply(t,e,a){const i=this.v_doit(e);return i&&(this.set_vectorize(t,e),t.layer.undo_transform((()=>t.fill(a)))),i}set_vectorize(t,e){t.fillStyle=this.pattern(t,e)??"transparent"}pattern(t,e){const a=this._hatch_image.get(e);return null==a?null:t.createPattern(a,this.repetition(e))}repetition(t){const e=this.hatch_pattern.get(t);if(null!=e){const t=(0,l.dict)(this.hatch_extra.value).get(e);if(null!=t)switch(t.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}return"repeat"}}a.HatchVector=p,p.__name__="HatchVector",o.prototype.type="hatch",o.prototype.attrs=Object.keys(_.Hatch),u.prototype.type="hatch",u.prototype.attrs=Object.keys(_.HatchScalar),p.prototype.type="hatch",p.prototype.attrs=Object.keys(_.HatchVector)},
function _(e,o,a,r,s){r();const i=e(19),n=e(22);function l(e,o,a){e.moveTo(0,a+.5),e.lineTo(o,a+.5),e.stroke()}function t(e,o,a){e.moveTo(a+.5,0),e.lineTo(a+.5,o),e.stroke()}function c(e,o){e.moveTo(0,o),e.lineTo(o,0),e.stroke(),e.moveTo(0,0),e.lineTo(o,o),e.stroke()}a.hatch_aliases={" ":"blank",".":"dot",o:"ring","-":"horizontal_line","|":"vertical_line","+":"cross",'"':"horizontal_dash",":":"vertical_dash","@":"spiral","/":"right_diagonal_line","\\":"left_diagonal_line",x:"diagonal_cross",",":"right_diagonal_dash","`":"left_diagonal_dash",v:"horizontal_wave",">":"vertical_wave","*":"criss_cross"},a.get_pattern=function(e,o,r,s,k,_){return e.resize(k,k),e.prepare(),function(e,o,r,s,k,_){const T=k,h=T/2,v=h/2,d=(0,n.color2css)(r,s);switch(e.strokeStyle=d,e.fillStyle=d,e.lineCap="square",e.lineWidth=_,a.hatch_aliases[o]??o){case"blank":break;case"dot":e.arc(h,h,h/2,0,2*Math.PI,!0),e.fill();break;case"ring":e.arc(h,h,h/2,0,2*Math.PI,!0),e.stroke();break;case"horizontal_line":l(e,T,h);break;case"vertical_line":t(e,T,h);break;case"cross":l(e,T,h),t(e,T,h);break;case"horizontal_dash":l(e,h,h);break;case"vertical_dash":t(e,h,h);break;case"spiral":{const o=T/30;e.moveTo(h,h);for(let a=0;a<360;a++){const r=.1*a,s=h+o*r*Math.cos(r),i=h+o*r*Math.sin(r);e.lineTo(s,i)}e.stroke();break}case"right_diagonal_line":e.moveTo(.5-v,T),e.lineTo(v+.5,0),e.stroke(),e.moveTo(v+.5,T),e.lineTo(3*v+.5,0),e.stroke(),e.moveTo(3*v+.5,T),e.lineTo(5*v+.5,0),e.stroke();break;case"left_diagonal_line":e.moveTo(v+.5,T),e.lineTo(.5-v,0),e.stroke(),e.moveTo(3*v+.5,T),e.lineTo(v+.5,0),e.stroke(),e.moveTo(5*v+.5,T),e.lineTo(3*v+.5,0),e.stroke();break;case"diagonal_cross":c(e,T);break;case"right_diagonal_dash":e.moveTo(v+.5,3*v+.5),e.lineTo(3*v+.5,v+.5),e.stroke();break;case"left_diagonal_dash":e.moveTo(v+.5,v+.5),e.lineTo(3*v+.5,3*v+.5),e.stroke();break;case"horizontal_wave":e.moveTo(0,v),e.lineTo(h,3*v),e.lineTo(T,v),e.stroke();break;case"vertical_wave":e.moveTo(v,0),e.lineTo(3*v,h),e.lineTo(v,T),e.stroke();break;case"criss_cross":c(e,T),l(e,T,h),t(e,T,h);break;default:i.logger.warn(`unknown hatch pattern: ${o}`)}}(e.ctx,o,r,s,k,_),e.canvas}},
function _(a,t,e,l,s){l();const o=a(1),r=a(84),p=o.__importStar(a(85));class _ extends r.VisualProperties{get doit(){return!(0==this.global_alpha.get_value())}apply(a){const{doit:t}=this;return t&&this.set_value(a),t}values(){return{global_alpha:this.global_alpha.get_value()}}set_value(a){const t=this.global_alpha.get_value();a.globalAlpha=t}}e.Image=_,_.__name__="Image";class i extends r.VisualUniforms{get doit(){return!(0==this.global_alpha.value)}apply(a){const{doit:t}=this;return t&&this.set_value(a),t}values(){return{global_alpha:this.global_alpha.value}}set_value(a){const t=this.global_alpha.value;a.globalAlpha=t}}e.ImageScalar=i,i.__name__="ImageScalar";class g extends r.VisualUniforms{get doit(){const{global_alpha:a}=this;return!a.is_Scalar()||0!=a.value}v_doit(a){return 0!=this.global_alpha.get(a)}apply(a,t){const e=this.v_doit(t);return e&&this.set_vectorize(a,t),e}values(a){return{alpha:this.global_alpha.get(a)}}set_vectorize(a,t){const e=this.global_alpha.get(t);a.globalAlpha=e}}e.ImageVector=g,g.__name__="ImageVector",_.prototype.type="image",_.prototype.attrs=Object.keys(p.Image),i.prototype.type="image",i.prototype.attrs=Object.keys(p.ImageScalar),g.prototype.type="image",g.prototype.attrs=Object.keys(p.ImageVector)},
function _(e,a,s,t,r){var c;t();const n=e(51),_=e(92),o=e(97),i=e(99),g=e(100),l=e(101),u=e(94),h=e(102),y=e(105);class x{constructor(e,a){this.x_scale=e,this.y_scale=a,this.x_source=this.x_scale.source_range,this.y_source=this.y_scale.source_range,this.ranges=[this.x_source,this.y_source],this.scales=[this.x_scale,this.y_scale]}map_to_screen(e,a){return[this.x_scale.v_compute(e),this.y_scale.v_compute(a)]}map_from_screen(e,a){return[this.x_scale.v_invert(e),this.y_scale.v_invert(a)]}}s.CoordinateTransform=x,x.__name__="CoordinateTransform";class p extends n.Model{constructor(e){super(e)}get x_ranges(){return new Map([["default",this.x_source]])}get y_ranges(){return new Map([["default",this.y_source]])}_get_scale(e,a,s){if(e instanceof y.FactorRange!=a instanceof g.CategoricalScale)throw new Error(`Range ${e.type} is incompatible is Scale ${a.type}`);a instanceof i.LogScale&&e instanceof h.DataRange1d&&(e.scale_hint="log");const t=a.clone();return t.setv({source_range:e,target_range:s}),t}get_transform(e){const{x_source:a,x_scale:s,x_target:t}=this,r=this._get_scale(a,s,t),{y_source:c,y_scale:n,y_target:_}=this,o=this._get_scale(c,n,_),i=new l.CompositeScale({source_scale:r,source_range:r.source_range,target_scale:e.x_scale,target_range:e.x_target}),g=new l.CompositeScale({source_scale:o,source_range:o.source_range,target_scale:e.y_scale,target_range:e.y_target});return new x(i,g)}}s.CoordinateMapping=p,c=p,p.__name__="CoordinateMapping",c.define((({Ref:e})=>({x_source:[e(u.Range),()=>new h.DataRange1d],y_source:[e(u.Range),()=>new h.DataRange1d],x_scale:[e(_.Scale),()=>new o.LinearScale],y_scale:[e(_.Scale),()=>new o.LinearScale],x_target:[e(u.Range)],y_target:[e(u.Range)]})))},
function _(e,t,r,n,s){var _;n();const a=e(93),c=e(94),o=e(95),i=e(24);class u extends a.Transform{constructor(e){super(e)}compute(e){return this.s_compute(e)}v_compute(e){const t=new i.ScreenArray(e.length),{s_compute:r}=this;for(let n=0;n<e.length;n++)t[n]=r(e[n]);return t}invert(e){return this.s_invert(e)}v_invert(e){const t=new Float64Array(e.length),{s_invert:r}=this;for(let n=0;n<e.length;n++)t[n]=r(e[n]);return t}r_compute(e,t){const{s_compute:r}=this;return this.target_range.is_reversed?[r(t),r(e)]:[r(e),r(t)]}r_invert(e,t){const{s_invert:r}=this;return this.target_range.is_reversed?[r(t),r(e)]:[r(e),r(t)]}}r.Scale=u,_=u,u.__name__="Scale",_.internal((({Ref:e})=>({source_range:[e(c.Range)],target_range:[e(o.Range1d)]})))},
function _(n,s,o,r,c){r();const e=n(51);class t extends e.Model{constructor(n){super(n)}}o.Transform=t,t.__name__="Transform"},
function _(t,e,n,l,s){var u;l();const a=t(51),i=t(21),o=(0,i.Nullable)((0,i.Or)((0,i.Tuple)((0,i.Nullable)(i.Float),(0,i.Nullable)(i.Float)),i.Auto));class r extends a.Model{constructor(t){super(t),this.have_updated_interactively=!1,this.plots=new Set}get computed_bounds(){return this._computed_bounds}get is_reversed(){return this.start>this.end}get is_valid(){return isFinite(this.min)&&isFinite(this.max)}get span(){return Math.abs(this.end-this.start)}}n.Range=r,u=r,r.__name__="Range",u.define((({Float:t,Nullable:e})=>({bounds:[o,null,{on_update(t,e){const[n,l]="auto"==t||null==t?[null,null]:t;e._computed_bounds=[n??-1/0,l??1/0]}}],min_interval:[e(t),null],max_interval:[e(t),null]})))},
function _(t,e,s,n,r){var a;n();const i=t(96);class _ extends i.NumericalRange{constructor(t){super(t)}_set_auto_bounds(){if("auto"==this.bounds){const t=Math.min(this._reset_start,this._reset_end),e=Math.max(this._reset_start,this._reset_end);this._computed_bounds=[t,e]}}initialize(){super.initialize(),this._set_auto_bounds()}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}reset(){this._set_auto_bounds();const{_reset_start:t,_reset_end:e}=this;this.start!=t||this.end!=e?this.setv({start:t,end:e}):this.change.emit()}map(t){return new a({start:t(this.start),end:t(this.end)})}widen(t){let{start:e,end:s}=this;return this.is_reversed?(e+=t,s-=t):(e-=t,s+=t),new a({start:e,end:s})}}s.Range1d=_,a=_,_.__name__="Range1d",a.define((({Float:t,Nullable:e})=>({reset_start:[e(t),null,{on_update(t,e){e._reset_start=t??e.start}}],reset_end:[e(t),null,{on_update(t,e){e._reset_end=t??e.end}}]}))),a.override({start:0,end:1})},
function _(n,e,t,c,r){var o;c();const a=n(1),s=n(94),u=a.__importStar(n(18)),_=n(11);class m extends s.Range{constructor(n){super(n)}}t.NumericalRange=m,o=m,m.__name__="NumericalRange",o.define((({Float:n})=>({start:[n,u.unset,{convert(n,e){const[t,c]=e.computed_bounds;return(0,_.clamp)(n,t,c)}}],end:[n,u.unset,{convert(n,e){const[t,c]=e.computed_bounds;return(0,_.clamp)(n,t,c)}}]})))},
function _(t,e,n,r,s){r();const a=t(98);class _ extends a.ContinuousScale{constructor(t){super(t)}get s_compute(){const[t,e]=this._linear_compute_state();return n=>t*n+e}get s_invert(){const[t,e]=this._linear_compute_state();return n=>(n-e)/t}_linear_compute_state(){const t=this.source_range.start,e=this.source_range.end,n=this.target_range.start,r=(this.target_range.end-n)/(e-t);return[r,-r*t+n]}}n.LinearScale=_,_.__name__="LinearScale"},
function _(n,c,o,s,e){s();const t=n(92);class u extends t.Scale{constructor(n){super(n)}}o.ContinuousScale=u,u.__name__="ContinuousScale"},
function _(t,e,s,a,r){a();const o=t(98);class n extends o.ContinuousScale{constructor(t){super(t)}get s_compute(){const[t,e,s,a]=this._compute_state();return r=>{if(0==s)return 0;{const o=(Math.log(r)-a)/s;return isFinite(o)?o*t+e:NaN}}}get s_invert(){const[t,e,s,a]=this._compute_state();return r=>{const o=(r-e)/t;return Math.exp(s*o+a)}}_get_safe_factor(t,e){let s=t<0?0:t,a=e<0?0:e;if(s==a)if(0==s)[s,a]=[1,10];else{const t=Math.log10(s);s=10**Math.floor(t),a=Math.ceil(t)!=Math.floor(t)?10**Math.ceil(t):10**(Math.ceil(t)+1)}return[s,a]}_compute_state(){const t=this.source_range.start,e=this.source_range.end,s=this.target_range.start,a=this.target_range.end-s,[r,o]=this._get_safe_factor(t,e);let n,c;0==r?(n=Math.log(o),c=0):(n=Math.log(o/r),c=Math.log(r));return[a,s,n,c]}}s.LogScale=n,n.__name__="LogScale"},
function _(t,e,c,a,s){a();const n=t(92),r=t(97),{_linear_compute_state:o}=r.LinearScale.prototype;class l extends n.Scale{constructor(t){super(t)}get s_compute(){const[t,e]=o.call(this),c=this.source_range;return a=>t*c.synthetic(a)+e}get s_invert(){const[t,e]=o.call(this);return c=>(c-e)/t}}c.CategoricalScale=l,l.__name__="CategoricalScale"},
function _(e,t,s,c,r){var n;c();const _=e(92),o=e(13);class a extends _.Scale{constructor(e){super(e)}get s_compute(){const e=this.source_scale.s_compute,t=this.target_scale.s_compute;return s=>t(e(s))}get s_invert(){const e=this.source_scale.s_invert,t=this.target_scale.s_invert;return s=>e(t(s))}compute(e){return this.s_compute(e)}v_compute(e){const{s_compute:t}=this;return(0,o.map)(e,t)}invert(e){return this.s_invert(e)}v_invert(e){const{s_invert:t}=this;return(0,o.map)(e,t)}}s.CompositeScale=a,n=a,a.__name__="CompositeScale",n.define((({Ref:e})=>({source_scale:[e(_.Scale)],target_scale:[e(_.Scale)]})))},
function _(t,i,n,a,e){var s;a();const l=t(1),_=t(103),o=t(20),r=t(34),d=t(19),h=l.__importStar(t(64)),u=t(104);n.auto_ranged=Symbol("auto_ranged"),n.is_auto_ranged=function(t){return n.auto_ranged in t};class g extends _.DataRange{constructor(t){super(t),this.have_updated_interactively=!1}initialize(){super.initialize(),this._initial_start=isNaN(this.start)?null:this.start,this._initial_end=isNaN(this.end)?null:this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span,this._plot_bounds=new Map}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}computed_renderers(){const{renderers:t}=this,i=(0,r.flat_map)(this.plots,(t=>t.auto_ranged_renderers.map((t=>t.model))));return(0,u.compute_renderers)(0==t.length?"auto":t,[...i])}_compute_plot_bounds(t,i){let n=h.empty();for(const a of t){const t=i.get(a);null==t||!a.visible&&this.only_visible||(n=h.union(n,t))}return n}adjust_bounds_for_aspect(t,i){const n=h.empty();let a=t.x1-t.x0;a<=0&&(a=1);let e=t.y1-t.y0;e<=0&&(e=1);const s=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return a<i*e?a=i*e:e=a/i,n.x1=s+.5*a,n.x0=s-.5*a,n.y1=l+.5*e,n.y0=l-.5*e,n}_compute_min_max(t,i){let n,a,e=h.empty();for(const[i,n]of t)i.model.visible&&(e=h.union(e,n));return[n,a]=0==i?[e.x0,e.x1]:[e.y0,e.y1],[n,a]}_compute_range(t,i){const n=this.range_padding;let a,e;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){let s,l;if((isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,d.logger.warn(`could not determine minimum data value for log axis, DataRange1d using value ${t}`)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,d.logger.warn(`could not determine maximum data value for log axis, DataRange1d using value ${i}`)),i==t)l=this.default_span+.001,s=Math.log10(t);else{let a,e;"percent"==this.range_padding_units?(a=Math.log10(t),e=Math.log10(i),l=(e-a)*(1+n)):(a=Math.log10(t-n),e=Math.log10(i+n),l=e-a),s=(a+e)/2}a=10**(s-l/2),e=10**(s+l/2)}else{let s;s=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+n):i-t+2*n;const l=(i+t)/2;a=l-s/2,e=l+s/2}let s=1;this.flipped&&([a,e]=[e,a],s=-1);const l=this.follow_interval;return null!=l&&Math.abs(a-e)>l&&("start"==this.follow?e=a+s*l:"end"==this.follow&&(a=e-s*l)),[a,e]}update(t,i,n,a){if(this.have_updated_interactively)return;const e=this.computed_renderers();let s=this._compute_plot_bounds(e,t);null!=a&&(s=this.adjust_bounds_for_aspect(s,a)),this._plot_bounds.set(n,s);const[l,_]=this._compute_min_max(this._plot_bounds.entries(),i);let[o,r]=this._compute_range(l,_);null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(o=this._initial_start):o=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(r=this._initial_end):r=this._initial_end);let d=!1;"auto"==this.bounds&&(this._computed_bounds=[o,r],d=!0);const[h,u]=[this.start,this.end];if(o!=h||r!=u){const t={};o!=h&&(t.start=o),r!=u&&(t.end=r),this.setv(t),d=!1}d&&this.change.emit()}reset(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()}}n.DataRange1d=g,s=g,g.__name__="DataRange1d",s.define((({Bool:t,Float:i,Nullable:n})=>({range_padding:[i,.1],range_padding_units:[o.PaddingUnits,"percent"],flipped:[t,!1],follow:[n(o.StartEnd),null],follow_interval:[n(i),null],default_span:[i,2],only_visible:[t,!1]}))),s.internal((({Enum:t})=>({scale_hint:[t("log","auto"),"auto"]})))},
function _(e,a,n,r,t){var s;r();const c=e(96);class o extends c.NumericalRange{constructor(e){super(e)}}n.DataRange=o,s=o,o.__name__="DataRange",s.define((({List:e,AnyRef:a,Or:n,Auto:r})=>({renderers:[n(e(a()),r),[]]}))),s.override({start:NaN,end:NaN})},
function _(n,e,r,t,u){t(),r.compute_renderers=function(n,e){return"auto"==n?e:n??[]}},
function _(t,n,e,s,i){var r;s();const a=t(1),o=t(94),p=t(20),c=a.__importStar(t(18)),g=t(21),l=t(24),h=t(15),u=t(10),d=t(8),_=t(12);function f(t,n,e=0){const s=new Map;for(let i=0;i<t.length;i++){const r=t[i];if(s.has(r))throw new Error(`duplicate factor or subfactor: ${r}`);s.set(r,{value:.5+i*(1+n)+e})}return[s,(t.length-1)*n]}function m(t,n,e,s=0){const i=new Map,r=new Map;for(const[n,e]of t){const t=r.get(n)??[];r.set(n,[...t,e])}let a=s,o=0;for(const[t,s]of r){const r=s.length,[p,c]=f(s,e,a);o+=c;const g=(0,u.sum)(s.map((t=>p.get(t).value)));i.set(t,{value:g/r,mapping:p}),a+=r+n+c}return[i,(r.size-1)*n+o]}function v(t,n,e,s,i=0){const r=new Map,a=new Map;for(const[n,e,s]of t){const t=a.get(n)??[];a.set(n,[...t,[e,s]])}let o=i,p=0;for(const[t,i]of a){const a=i.length,[c,g]=m(i,e,s,o);p+=g;const l=(0,u.sum)(i.map((([t])=>c.get(t).value)));r.set(t,{value:l/a,mapping:c}),o+=a+n+g}return[r,(a.size-1)*n+p]}e.Factor=(0,g.Or)(g.Str,(0,g.Tuple)(g.Str,g.Str),(0,g.Tuple)(g.Str,g.Str,g.Str)),e.FactorSeq=(0,g.Or)((0,g.List)(g.Str),(0,g.List)((0,g.Tuple)(g.Str,g.Str)),(0,g.List)((0,g.Tuple)(g.Str,g.Str,g.Str))),e.map_one_level=f,e.map_two_levels=m,e.map_three_levels=v;class S extends o.Range{constructor(t){super(t),this.invalidate_synthetic=new h.Signal0(this,"invalidate_synthetic")}get min(){return this.start}get max(){return this.end}initialize(){super.initialize(),this._init()}connect_signals(){super.connect_signals(),this.connect(this.properties.factors.change,(()=>this.reset())),this.connect(this.properties.factor_padding.change,(()=>this.reset())),this.connect(this.properties.group_padding.change,(()=>this.reset())),this.connect(this.properties.subgroup_padding.change,(()=>this.reset())),this.connect(this.properties.range_padding.change,(()=>this.reset())),this.connect(this.properties.range_padding_units.change,(()=>this.reset()))}reset(){this._init(),this.invalidate_synthetic.emit()}_lookup(t){switch(t.length){case 1:{const[n]=t,e=this._mapping.get(n);return null!=e?e.value:NaN}case 2:{const[n,e]=t,s=this._mapping.get(n);if(null!=s){const t=s.mapping.get(e);if(null!=t)return t.value}return NaN}case 3:{const[n,e,s]=t,i=this._mapping.get(n);if(null!=i){const t=i.mapping.get(e);if(null!=t){const n=t.mapping.get(s);if(null!=n)return n.value}}return NaN}}}synthetic(t){if((0,d.isNumber)(t))return t;if((0,d.isString)(t))return this._lookup([t]);let n=0;const e=t[t.length-1];return(0,d.isNumber)(e)&&(n=e,t=t.slice(0,-1)),this._lookup(t)+n}v_synthetic(t){const n=t.length,e=new l.ScreenArray(n);for(let s=0;s<n;s++)e[s]=this.synthetic(t[s]);return e}_init(){const{levels:t,mapping:n,tops:e,mids:s,inside_padding:i}=(()=>{if((0,u.every)(this.factors,d.isString)){const t=this.factors,[n,e]=f(t,this.factor_padding);return{levels:1,mapping:n,tops:null,mids:null,inside_padding:e}}if((0,u.every)(this.factors,(t=>(0,d.isArray)(t)&&2==t.length&&(0,d.isString)(t[0])&&(0,d.isString)(t[1])))){const t=this.factors,[n,e]=m(t,this.group_padding,this.factor_padding),s=[...n.keys()];return{levels:2,mapping:n,tops:s,mids:null,inside_padding:e}}if((0,u.every)(this.factors,(t=>(0,d.isArray)(t)&&3==t.length&&(0,d.isString)(t[0])&&(0,d.isString)(t[1])&&(0,d.isString)(t[2])))){const t=this.factors,[n,e]=v(t,this.group_padding,this.subgroup_padding,this.factor_padding),s=[...n.keys()],i=[];for(const[t,e]of n)for(const n of e.mapping.keys())i.push([t,n]);return{levels:3,mapping:n,tops:s,mids:i,inside_padding:e}}(0,_.unreachable)()})();this._mapping=n,this.tops=e,this.mids=s;let r=0,a=this.factors.length+i;if("percent"==this.range_padding_units){const t=(a-r)*this.range_padding/2;r-=t,a+=t}else r-=this.range_padding,a+=this.range_padding;this.setv({start:r,end:a,levels:t},{silent:!0}),"auto"==this.bounds&&(this._computed_bounds=[r,a])}}e.FactorRange=S,r=S,S.__name__="FactorRange",r.define((({Float:t})=>({factors:[e.FactorSeq,[]],factor_padding:[t,0],subgroup_padding:[t,.8],group_padding:[t,1.4],range_padding:[t,0],range_padding_units:[p.PaddingUnits,"percent"],start:[t,c.unset,{readonly:!0}],end:[t,c.unset,{readonly:!0}]}))),r.internal((({Float:t,Str:n,List:e,Tuple:s,Nullable:i})=>({levels:[t],mids:[i(e(s(n,n))),null],tops:[i(e(n)),null]})))},
function _(e,t,s,i,n){var o;i();const l=e(1),d=e(107),r=e(115),h=e(116),a=e(118),c=e(119),_=e(63),u=e(20),m=e(56),v=e(10),p=e(8),w=l.__importStar(e(120)),f=w,y=l.__importDefault(e(121));class b extends d.UIElementView{constructor(){super(...arguments),this._menu_views=new Map,this._open=!1,this._item_click=e=>{e.disabled||(e.action?.execute(this.model,{item:e}),this.hide())},this._on_mousedown=e=>{e.composedPath().includes(this.el)||this.prevent_hide?.(e)||this.hide()},this._on_keydown=e=>{"Escape"==e.key&&this.hide()},this._on_blur=()=>{this.hide()}}*children(){yield*super.children(),yield*this._menu_views.values()}async lazy_initialize(){await super.lazy_initialize();const e=this.model.items.map((e=>e instanceof h.ActionItem?e.menu:null)).filter(p.isNotNull);await(0,m.build_views)(this._menu_views,e,{parent:this})}get is_open(){return this._open}remove(){this._unlisten(),(0,m.remove_views)(this._menu_views),super.remove()}_listen(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)}_unlisten(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)}stylesheets(){return[...super.stylesheets(),w.default,y.default]}render(){super.render();const e=(()=>{const{reversed:e,items:t}=this.model;return e?(0,v.reversed)(t):t})();for(const t of e)if(t instanceof c.DividerItem){const e=(0,_.div)({class:f.divider});this.shadow_el.append(e)}else if(t instanceof h.ActionItem){const e=(0,_.div)({class:f.check}),s=(0,_.div)({class:f.icon}),i=(0,_.div)({class:f.label},t.label),n=(0,_.div)({class:f.shortcut},t.shortcut),o=(0,_.div)({class:f.chevron}),{icon:l}=t;if(null!=l)if(l.startsWith("data:image")){const e=`url("${encodeURI(l)}")`;s.style.backgroundImage=e}else if(l.startsWith("--"))s.style.backgroundImage=`var(${l})`;else if(l.startsWith(".")){const e=l.substring(1);s.classList.add(e)}else if(u.ToolIcon.valid(l)){const e=`bk-tool-icon-${l.replace(/_/g,"-")}`;s.classList.add(e)}const d=(0,_.div)({class:f.item,title:t.tooltip,tabIndex:0},e,s,i,n,o);d.classList.toggle(f.menu,null!=t.menu),d.classList.toggle(f.disabled,t.disabled),t instanceof a.CheckableItem&&(d.classList.add(f.checkable),d.classList.toggle(f.checked,t.checked)),d.addEventListener("click",(()=>{this._item_click(t)})),d.addEventListener("keydown",(e=>{"Enter"==e.key&&this._item_click(t)}));const{menu:r}=t;null!=r&&(d.addEventListener("pointerenter",(()=>{this._menu_views.get(r)._show_submenu(d)})),d.addEventListener("pointerleave",(()=>{this._menu_views.get(r).hide()}))),this.shadow_el.append(d)}}_show_submenu(e){if(0==this.model.items.length)return void this.hide();this.render(),e.append(this.el);const{style:t}=this.el;t.left="100%",t.top="0",this._listen(),this._open=!0}show(e){if(0==this.model.items.length)return void this.hide();const{parent:t}=this;if(null==t)return void this.hide();this.render();(t.el.shadowRoot??t.el).append(this.el);const{style:s}=this.el;s.left=(0,_.px)(e.x),s.top=(0,_.px)(e.y),this._listen(),this._open=!0}hide(){this._open&&(this._open=!1,this._unlisten(),this.el.remove())}}s.MenuView=b,b.__name__="MenuView";class k extends d.UIElement{constructor(e){super(e)}}s.Menu=k,o=k,k.__name__="Menu",o.prototype.default_view=b,o.define((({Bool:e,List:t,Ref:s})=>({items:[t(s(r.MenuItem)),[]],reversed:[e,!1]})))},
function _(e,t,s,i,l){var n;i();const r=e(1),_=e(51),o=e(59),a=e(108),h=e(109),u=e(57),y=e(56),c=e(65),d=e(63),p=e(110),b=e(64),f=e(9),x=e(8),m=r.__importDefault(e(114)),v=e(21);s.StylesLike=(0,v.Or)((0,v.Dict)((0,v.Nullable)(v.Str)),(0,v.Ref)(a.Styles)),s.StyleSheets=(0,v.List)((0,v.Or)((0,v.Ref)(h.StyleSheet),v.Str,(0,v.Dict)(s.StylesLike))),s.CSSVariables=(0,v.Dict)((0,v.Ref)(o.Node));const{round:g,floor:S}=Math;class w extends u.DOMComponentView{constructor(){super(...arguments),this._display=new d.InlineStyleSheet,this.style=new d.InlineStyleSheet,this._bbox=new b.BBox,this._context_menu=null,this._is_displayed=!1}*_css_classes(){yield*super._css_classes(),yield*this.model.css_classes}*_css_variables(){yield*super._css_variables();for(const[e,t]of(0,f.entries)(this.model.css_variables)){const s=this.resolve_coordinate(t);(0,x.isNumber)(s)&&(yield[e,`${s}px`])}}*_stylesheets(){yield*super._stylesheets(),yield this.style,yield this._display,yield*this._computed_stylesheets()}*_computed_stylesheets(){for(const e of this.model.stylesheets)e instanceof h.StyleSheet?yield e.underlying():yield new d.InlineStyleSheet(e)}stylesheets(){return[...super.stylesheets(),m.default]}update_style(){this.style.clear()}box_sizing(){return{width_policy:"auto",height_policy:"auto",width:null,height:null,aspect_ratio:null}}get bbox(){return this._bbox}update_bbox(){return this._update_bbox()}_update_bbox(){const e=(()=>{if(this.el.isConnected){if(null!=this.el.offsetParent)return!0;{const{position:e,display:t}=getComputedStyle(this.el);return"fixed"==e&&"none"!=t}}return!1})(),t=e?(()=>{const e=this.el.getBoundingClientRect(),{left:t,top:s}=(()=>{if(null!=this.parent){const t=this.parent.el.getBoundingClientRect();return{left:e.left-t.left,top:e.top-t.top}}return{left:0,top:0}})();return new b.BBox({left:g(t),top:g(s),width:S(e.width),height:S(e.height)})})():new b.BBox,s=!this._bbox.equals(t);return this._bbox=t,this._is_displayed=e,s}initialize(){super.initialize(),this._resize_observer=new ResizeObserver((e=>this.after_resize())),this._resize_observer.observe(this.el,{box:"border-box"})}async lazy_initialize(){await super.lazy_initialize();const{context_menu:e}=this.model;null!=e&&(this._context_menu=await(0,y.build_view)(e,{parent:this}))}connect_signals(){super.connect_signals();const{visible:e,styles:t,css_classes:s,css_variables:i,stylesheets:l}=this.model.properties;this.on_change(e,(()=>this._update_visible())),this.on_change(t,(()=>this._update_styles())),this.on_change(s,(()=>this._update_css_classes())),this.on_transitive_change(i,(()=>this._update_css_variables())),this.on_change(l,(()=>this._update_stylesheets())),this.el.addEventListener("contextmenu",(e=>this.show_context_menu(e)))}get_context_menu(e){return this._context_menu}show_context_menu(e){if(!e.shiftKey){const t=this.el.getBoundingClientRect(),s=e.x-t.x,i=e.y-t.y,l=this.get_context_menu({x:s,y:i});null!=l&&(e.stopPropagation(),e.preventDefault(),l.show({x:s,y:i}))}}remove(){this._resize_observer.disconnect(),this._context_menu?.remove(),super.remove()}_after_resize(){}after_resize(){this.update_bbox()&&this._after_resize(),this.finish()}render(){super.render(),this._apply_styles(),this._apply_visible()}_after_render(){}after_render(){super.after_render(),this.update_style(),this.update_bbox(),this._after_render(),this.is_displayed||this.finish()}get is_displayed(){return this._is_displayed}_apply_visible(){this.model.visible?this._display.clear():this._display.replace(":host { display: none !important; }")}_apply_styles(){(0,c.apply_styles)(this.el.style,this.model.styles)}_update_visible(){this._apply_visible()}_update_styles(){this.el.removeAttribute("style"),this._apply_styles()}export(e="auto",t=!0){const s="auto"==e||"png"==e?"canvas":"svg",i=new p.CanvasLayer(s,t),{width:l,height:n}=this.bbox;return i.resize(l,n),i}serializable_state(){return{...super.serializable_state(),bbox:this.bbox}}resolve_symbol(e){const t=this.bbox.resolve(e.symbol),{offset:s}=e;if((0,x.isNumber)(t))return t+s;{const{x:e,y:i}=t;return{x:e+s,y:i+s}}}}s.UIElementView=w,w.__name__="UIElementView";class z extends _.Model{constructor(e){super(e)}}s.UIElement=z,n=z,z.__name__="UIElement",n.define((({Bool:e,List:t,Str:i,AnyRef:l})=>({visible:[e,!0],css_classes:[t(i),[]],css_variables:[s.CSSVariables,{}],styles:[s.StylesLike,{}],stylesheets:[s.StyleSheets,[]],context_menu:[(0,v.Nullable)(l()),null]})))},
function _(l,n,u,_,e){var t;_();const o=l(51);class r extends o.Model{constructor(l){super(l)}}u.Styles=r,t=r,r.__name__="Styles",t.define((({Str:l,Nullable:n})=>({align_content:[n(l),null],align_items:[n(l),null],align_self:[n(l),null],alignment_baseline:[n(l),null],all:[n(l),null],animation:[n(l),null],animation_delay:[n(l),null],animation_direction:[n(l),null],animation_duration:[n(l),null],animation_fill_mode:[n(l),null],animation_iteration_count:[n(l),null],animation_name:[n(l),null],animation_play_state:[n(l),null],animation_timing_function:[n(l),null],aspect_ratio:[n(l),null],backface_visibility:[n(l),null],background:[n(l),null],background_attachment:[n(l),null],background_clip:[n(l),null],background_color:[n(l),null],background_image:[n(l),null],background_origin:[n(l),null],background_position:[n(l),null],background_position_x:[n(l),null],background_position_y:[n(l),null],background_repeat:[n(l),null],background_size:[n(l),null],baseline_shift:[n(l),null],block_size:[n(l),null],border:[n(l),null],border_block_end:[n(l),null],border_block_end_color:[n(l),null],border_block_end_style:[n(l),null],border_block_end_width:[n(l),null],border_block_start:[n(l),null],border_block_start_color:[n(l),null],border_block_start_style:[n(l),null],border_block_start_width:[n(l),null],border_bottom:[n(l),null],border_bottom_color:[n(l),null],border_bottom_left_radius:[n(l),null],border_bottom_right_radius:[n(l),null],border_bottom_style:[n(l),null],border_bottom_width:[n(l),null],border_collapse:[n(l),null],border_color:[n(l),null],border_image:[n(l),null],border_image_outset:[n(l),null],border_image_repeat:[n(l),null],border_image_slice:[n(l),null],border_image_source:[n(l),null],border_image_width:[n(l),null],border_inline_end:[n(l),null],border_inline_end_color:[n(l),null],border_inline_end_style:[n(l),null],border_inline_end_width:[n(l),null],border_inline_start:[n(l),null],border_inline_start_color:[n(l),null],border_inline_start_style:[n(l),null],border_inline_start_width:[n(l),null],border_left:[n(l),null],border_left_color:[n(l),null],border_left_style:[n(l),null],border_left_width:[n(l),null],border_radius:[n(l),null],border_right:[n(l),null],border_right_color:[n(l),null],border_right_style:[n(l),null],border_right_width:[n(l),null],border_spacing:[n(l),null],border_style:[n(l),null],border_top:[n(l),null],border_top_color:[n(l),null],border_top_left_radius:[n(l),null],border_top_right_radius:[n(l),null],border_top_style:[n(l),null],border_top_width:[n(l),null],border_width:[n(l),null],bottom:[n(l),null],box_shadow:[n(l),null],box_sizing:[n(l),null],break_after:[n(l),null],break_before:[n(l),null],break_inside:[n(l),null],caption_side:[n(l),null],caret_color:[n(l),null],clear:[n(l),null],clip:[n(l),null],clip_path:[n(l),null],clip_rule:[n(l),null],color:[n(l),null],color_interpolation:[n(l),null],color_interpolation_filters:[n(l),null],column_count:[n(l),null],column_fill:[n(l),null],column_gap:[n(l),null],column_rule:[n(l),null],column_rule_color:[n(l),null],column_rule_style:[n(l),null],column_rule_width:[n(l),null],column_span:[n(l),null],column_width:[n(l),null],columns:[n(l),null],content:[n(l),null],counter_increment:[n(l),null],counter_reset:[n(l),null],cursor:[n(l),null],direction:[n(l),null],display:[n(l),null],dominant_baseline:[n(l),null],empty_cells:[n(l),null],fill:[n(l),null],fill_opacity:[n(l),null],fill_rule:[n(l),null],filter:[n(l),null],flex:[n(l),null],flex_basis:[n(l),null],flex_direction:[n(l),null],flex_flow:[n(l),null],flex_grow:[n(l),null],flex_shrink:[n(l),null],flex_wrap:[n(l),null],float:[n(l),null],flood_color:[n(l),null],flood_opacity:[n(l),null],font:[n(l),null],font_family:[n(l),null],font_feature_settings:[n(l),null],font_kerning:[n(l),null],font_size:[n(l),null],font_size_adjust:[n(l),null],font_stretch:[n(l),null],font_style:[n(l),null],font_synthesis:[n(l),null],font_variant:[n(l),null],font_variant_caps:[n(l),null],font_variant_east_asian:[n(l),null],font_variant_ligatures:[n(l),null],font_variant_numeric:[n(l),null],font_variant_position:[n(l),null],font_weight:[n(l),null],gap:[n(l),null],glyph_orientation_vertical:[n(l),null],grid:[n(l),null],grid_area:[n(l),null],grid_auto_columns:[n(l),null],grid_auto_flow:[n(l),null],grid_auto_rows:[n(l),null],grid_column:[n(l),null],grid_column_end:[n(l),null],grid_column_gap:[n(l),null],grid_column_start:[n(l),null],grid_gap:[n(l),null],grid_row:[n(l),null],grid_row_end:[n(l),null],grid_row_gap:[n(l),null],grid_row_start:[n(l),null],grid_template:[n(l),null],grid_template_areas:[n(l),null],grid_template_columns:[n(l),null],grid_template_rows:[n(l),null],height:[n(l),null],hyphens:[n(l),null],image_orientation:[n(l),null],image_rendering:[n(l),null],inline_size:[n(l),null],justify_content:[n(l),null],justify_items:[n(l),null],justify_self:[n(l),null],left:[n(l),null],letter_spacing:[n(l),null],lighting_color:[n(l),null],line_break:[n(l),null],line_height:[n(l),null],list_style:[n(l),null],list_style_image:[n(l),null],list_style_position:[n(l),null],list_style_type:[n(l),null],margin:[n(l),null],margin_block_end:[n(l),null],margin_block_start:[n(l),null],margin_bottom:[n(l),null],margin_inline_end:[n(l),null],margin_inline_start:[n(l),null],margin_left:[n(l),null],margin_right:[n(l),null],margin_top:[n(l),null],marker:[n(l),null],marker_end:[n(l),null],marker_mid:[n(l),null],marker_start:[n(l),null],mask:[n(l),null],mask_composite:[n(l),null],mask_image:[n(l),null],mask_position:[n(l),null],mask_repeat:[n(l),null],mask_size:[n(l),null],mask_type:[n(l),null],max_block_size:[n(l),null],max_height:[n(l),null],max_inline_size:[n(l),null],max_width:[n(l),null],min_block_size:[n(l),null],min_height:[n(l),null],min_inline_size:[n(l),null],min_width:[n(l),null],object_fit:[n(l),null],object_position:[n(l),null],opacity:[n(l),null],order:[n(l),null],orphans:[n(l),null],outline:[n(l),null],outline_color:[n(l),null],outline_offset:[n(l),null],outline_style:[n(l),null],outline_width:[n(l),null],overflow:[n(l),null],overflow_anchor:[n(l),null],overflow_wrap:[n(l),null],overflow_x:[n(l),null],overflow_y:[n(l),null],overscroll_behavior:[n(l),null],overscroll_behavior_block:[n(l),null],overscroll_behavior_inline:[n(l),null],overscroll_behavior_x:[n(l),null],overscroll_behavior_y:[n(l),null],padding:[n(l),null],padding_block_end:[n(l),null],padding_block_start:[n(l),null],padding_bottom:[n(l),null],padding_inline_end:[n(l),null],padding_inline_start:[n(l),null],padding_left:[n(l),null],padding_right:[n(l),null],padding_top:[n(l),null],page_break_after:[n(l),null],page_break_before:[n(l),null],page_break_inside:[n(l),null],paint_order:[n(l),null],perspective:[n(l),null],perspective_origin:[n(l),null],place_content:[n(l),null],place_items:[n(l),null],place_self:[n(l),null],pointer_events:[n(l),null],position:[n(l),null],quotes:[n(l),null],resize:[n(l),null],right:[n(l),null],rotate:[n(l),null],row_gap:[n(l),null],ruby_align:[n(l),null],ruby_position:[n(l),null],scale:[n(l),null],scroll_behavior:[n(l),null],shape_rendering:[n(l),null],stop_color:[n(l),null],stop_opacity:[n(l),null],stroke:[n(l),null],stroke_dasharray:[n(l),null],stroke_dashoffset:[n(l),null],stroke_linecap:[n(l),null],stroke_linejoin:[n(l),null],stroke_miterlimit:[n(l),null],stroke_opacity:[n(l),null],stroke_width:[n(l),null],tab_size:[n(l),null],table_layout:[n(l),null],text_align:[n(l),null],text_align_last:[n(l),null],text_anchor:[n(l),null],text_combine_upright:[n(l),null],text_decoration:[n(l),null],text_decoration_color:[n(l),null],text_decoration_line:[n(l),null],text_decoration_style:[n(l),null],text_emphasis:[n(l),null],text_emphasis_color:[n(l),null],text_emphasis_position:[n(l),null],text_emphasis_style:[n(l),null],text_indent:[n(l),null],text_justify:[n(l),null],text_orientation:[n(l),null],text_overflow:[n(l),null],text_rendering:[n(l),null],text_shadow:[n(l),null],text_transform:[n(l),null],text_underline_position:[n(l),null],top:[n(l),null],touch_action:[n(l),null],transform:[n(l),null],transform_box:[n(l),null],transform_origin:[n(l),null],transform_style:[n(l),null],transition:[n(l),null],transition_delay:[n(l),null],transition_duration:[n(l),null],transition_property:[n(l),null],transition_timing_function:[n(l),null],translate:[n(l),null],unicode_bidi:[n(l),null],user_select:[n(l),null],vertical_align:[n(l),null],visibility:[n(l),null],white_space:[n(l),null],widows:[n(l),null],width:[n(l),null],will_change:[n(l),null],word_break:[n(l),null],word_spacing:[n(l),null],word_wrap:[n(l),null],writing_mode:[n(l),null],z_index:[n(l),null]})))},
function _(e,t,n,l,r){var s,i;l();const u=e(1),S=e(51),_=u.__importStar(e(63));class d extends S.Model{constructor(e){super(e)}}n.StyleSheet=d,d.__name__="StyleSheet";class h extends d{constructor(e){super(e)}underlying(){return new _.InlineStyleSheet(this.css)}}n.InlineStyleSheet=h,s=h,h.__name__="InlineStyleSheet",s.define((({Str:e})=>({css:[e]})));class o extends d{constructor(e){super(e)}underlying(){return new _.ImportedStyleSheet(this.url)}}n.ImportedStyleSheet=o,i=o,o.__name__="ImportedStyleSheet",i.define((({Str:e})=>({url:[e]})));class y extends h{constructor(e){super(e),this._underlying=null}underlying(){return null==this._underlying&&(this._underlying=new _.GlobalInlineStyleSheet(this.css)),this._underlying}}n.GlobalInlineStyleSheet=y,y.__name__="GlobalInlineStyleSheet";class c extends o{constructor(e){super(e),this._underlying=null}underlying(){return null==this._underlying&&(this._underlying=new _.GlobalImportedStyleSheet(this.url)),this._underlying}}n.GlobalImportedStyleSheet=c,c.__name__="GlobalImportedStyleSheet"},
function _(t,e,s,i,a){i();const n=t(111),r=t(64),h=t(63);class o{get canvas(){return this._canvas}get ctx(){return this._ctx}get el(){return this._el}constructor(t,e){switch(this.pixel_ratio=1,this.bbox=new r.BBox,this.backend=t,this.hidpi=e,t){case"webgl":case"canvas":{this._el=this._canvas=(0,h.canvas)({class:"bk-layer"});const t=this.canvas.getContext("2d");if(null==t)throw new Error("unable to obtain 2D rendering context");this._ctx=t,e&&(this.pixel_ratio=devicePixelRatio);break}case"svg":{const t=new n.SVGRenderingContext2D;this._ctx=t,this._canvas=t.get_svg(),this._el=(0,h.div)({class:"bk-layer"});this._el.attachShadow({mode:"open"}).appendChild(this._canvas);break}}this._ctx.layer=this}resize(t,e){if(this.bbox.width==t&&this.bbox.height==e)return;this.bbox=new r.BBox({left:0,top:0,width:t,height:e});const{target:s}=this;s.width=t*this.pixel_ratio,s.height=e*this.pixel_ratio}get target(){return this._ctx instanceof n.SVGRenderingContext2D?this._ctx:this.canvas}undo_transform(t){const{ctx:e}=this,s=e.getTransform();e.resetTransform();try{t(e)}finally{e.setTransform(s)}}prepare(){const{ctx:t,hidpi:e,pixel_ratio:s}=this;t.save(),e&&(t.scale(s,s),t.translate(.5,.5)),this.clear()}clear(){const{x:t,y:e,width:s,height:i}=this.bbox;this.ctx.clearRect(t,e,s,i)}finish(){this.ctx.restore()}to_blob(){const{_canvas:t}=this;if(t instanceof HTMLCanvasElement)return new Promise(((e,s)=>{t.toBlob((t=>null!=t?e(t):s()),"image/png")}));{const t=this._ctx.get_serialized_svg(!0),e=new Blob([t],{type:"image/svg+xml"});return Promise.resolve(e)}}}s.CanvasLayer=o,o.__name__="CanvasLayer"},
function _(t,e,i,s,r){s();const n=t(112),a=t(8),o=t(113),l=t(11),h=t(63);function _(t){const e={left:"start",right:"end",center:"middle",start:"start",end:"end"};return t in e?e[t]:e.start}function c(t){const e={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return t in e?e[t]:e.alphabetic}const p=function(t,e){const i=new Map,s=t.split(",");e=e??10;for(let t=0;t<s.length;t+=2){const r=`&${s[t+1]};`,n=parseInt(s[t],e);i.set(r,`&#${n};`)}return i.set("\\xa0","&#160;"),i}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),u={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},fontKerning:{canvas:"auto"},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"},lineDashOffset:{svgAttr:"stroke-dashoffset",canvas:0,svg:0,apply:"stroke"}};function d(t){if(function(t){return"undefined"!=typeof VideoFrame&&t instanceof VideoFrame}(t))return[t.codedWidth,t.codedHeight];{function e(t){return(0,a.isNumber)(t)?t:t.baseVal.value}const{width:i,height:s}=t;return[e(i),e(s)]}}class m{constructor(t,e){this.__root=t,this.__ctx=e}addColorStop(t,e){if("linearGradient"===this.__root.nodeName&&this.__root.getAttribute("x1")===this.__root.getAttribute("x2")&&this.__root.getAttribute("y1")===this.__root.getAttribute("y2"))return;if("radialGradient"===this.__root.nodeName&&this.__root.getAttribute("cx")===this.__root.getAttribute("fx")&&this.__root.getAttribute("cy")===this.__root.getAttribute("fy")&&this.__root.getAttribute("r")===this.__root.getAttribute("r0"))return;const i=this.__ctx.__createElement("stop");if(i.setAttribute("offset",`${t}`),-1!==e.indexOf("rgba")){const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),[,s,r,n,a]=t;i.setAttribute("stop-color",`rgb(${s},${r},${n})`),i.setAttribute("stop-opacity",a)}else i.setAttribute("stop-color",e);this.__root.appendChild(i)}}m.__name__="CanvasGradient";class f{constructor(t,e){this.__root=t,this.__ctx=e}setTransform(t){throw new Error("not implemented")}}f.__name__="CanvasPattern";class g{get canvas(){return this}get width(){return this._width}set width(t){this._width=t,this.__root.setAttribute("width",`${t}`)}get height(){return this._height}set height(t){this._height=t,this.__root.setAttribute("height",`${t}`)}constructor(t){this.__currentDefaultPath="",this.__currentPosition=null,this.globalAlpha=1,this._transform=new n.AffineTransform,this._clip_path=null,this.__document=t?.document??document,null!=t?.ctx?this.__ctx=t.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.reset(),this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version","1.1"),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__currentElement=this.__root,this.width=t?.width??500,this.height=t?.height??500,this.__ids=new Set,this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs)}_random_string(){let t;do{t=g.__random.choices(12,"ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz").join("")}while(this.__ids.has(t));return t}__createElement(t,e={},i=!1){const s=this.__document.createElementNS("http://www.w3.org/2000/svg",t);i&&(s.setAttribute("fill","none"),s.setAttribute("stroke","none"));const r=Object.keys(e);for(const t of r)s.setAttribute(t,`${e[t]}`);return s}__setDefaultStyles(){const t=Object.keys(u),e=this;for(let i=0;i<t.length;i++){const s=t[i];e[s]=u[s].canvas}}__applyStyleState(t){const e=Object.keys(t),i=this;for(let s=0;s<e.length;s++){const r=e[s];i[r]=t[r]}}__getStyleState(){const t=Object.keys(u),e={};for(let i=0;i<t.length;i++){const s=t[i];e[s]=this[s]}return e}__applyStyleToCurrentElement(t){const e=this.__currentElement,i=Object.keys(u);for(let s=0;s<i.length;s++){const r=u[i[s]],n=this[i[s]];if(null!=r.apply&&r.apply.includes(t))if(n instanceof f){for(const t of[...n.__ctx.__defs.childNodes])if(t instanceof Element){const e=t.getAttribute("id");this.__ids.add(e),this.__defs.appendChild(t)}const t=n.__root.getAttribute("id");e.setAttribute(r.apply,`url(#${t})`)}else if(n instanceof m){const t=n.__root.getAttribute("id");e.setAttribute(r.apply,`url(#${t})`)}else if(r.svg!==n)if("stroke"!==r.svgAttr&&"fill"!==r.svgAttr||!(0,a.isString)(n)||-1===n.indexOf("rgba")){let a=r.svgAttr;if("globalAlpha"===i[s]&&(a=`${t}-${r.svgAttr}`,null!=e.getAttribute(a)))continue;e.setAttribute(a,`${n}`)}else{const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(n),[,i,s,a,o]=t;e.setAttribute(r.svgAttr,`rgb(${i},${s},${a})`);const l=parseFloat(o)*this.globalAlpha;e.setAttribute(`${r.svgAttr}-opacity`,`${l}`)}}}get_serialized_svg(t=!1){let e=(new XMLSerializer).serializeToString(this.__root);if(t)for(const[t,i]of p){const s=new RegExp(t,"gi");s.test(e)&&(e=e.replace(s,i))}return e}get_svg(){return this.__root}save(){this.__stack.push({transform:this._transform,clip_path:this._clip_path,attributes:this.__getStyleState()}),this._transform=this._transform.clone()}restore(){if(0==this.__stack.length)return;const{transform:t,clip_path:e,attributes:i}=this.__stack.pop();this._transform=t,this._clip_path=e,this.__applyStyleState(i)}reset(){this.__setDefaultStyles(),this.__stack=[]}_apply_transform(t,e=this._transform){e.is_identity||t.setAttribute("transform",e.toString())}scale(t,e){isFinite(t)&&(null==e||isFinite(e))&&this._transform.scale(t,e??t)}rotate(t){isFinite(t)&&this._transform.rotate(t)}translate(t,e){isFinite(t+e)&&this._transform.translate(t,e)}transform(t,e,i,s,r,n){isFinite(t+e+i+s+r+n)&&this._transform.transform(t,e,i,s,r,n)}beginPath(){this.__currentDefaultPath="",this.__currentPosition=null,this.__init_element()}__init_element(){const t=this.__createElement("path",{},!0);this.__root.appendChild(t),this.__currentElement=t}__applyCurrentDefaultPath(){const t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)}__addPathCommand(t,e,i){const s=""==this.__currentDefaultPath?"":" ";this.__currentDefaultPath+=s+i,this.__currentPosition={x:t,y:e}}get _hasCurrentDefaultPath(){return""!=this.__currentDefaultPath}moveTo(t,e){if(!isFinite(t+e))return;"path"!==this.__currentElement.nodeName&&this.beginPath();const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`M ${i} ${s}`)}closePath(){this._hasCurrentDefaultPath&&this.__addPathCommand(NaN,NaN,"Z")}lineTo(t,e){if(isFinite(t+e))if(this._hasCurrentDefaultPath){const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`L ${i} ${s}`)}else this.moveTo(t,e)}bezierCurveTo(t,e,i,s,r,n){if(!isFinite(t+e+i+s+r+n))return;const[a,o]=this._transform.apply(r,n),[l,h]=this._transform.apply(t,e),[_,c]=this._transform.apply(i,s);this.__addPathCommand(a,o,`C ${l} ${h} ${_} ${c} ${a} ${o}`)}quadraticCurveTo(t,e,i,s){if(!isFinite(t+e+i+s))return;const[r,n]=this._transform.apply(i,s),[a,o]=this._transform.apply(t,e);this.__addPathCommand(r,n,`Q ${a} ${o} ${r} ${n}`)}arcTo(t,e,i,s,r){if(!isFinite(t+e+i+s+r))return;if(null==this.__currentPosition)return;const n=this._transform.inverse(),[a,o]=n.apply(this.__currentPosition.x,this.__currentPosition.y);if(r<0)throw new Error(`IndexSizeError: The radius provided (${r}) is negative.`);if(a===t&&o===e||t===i&&e===s||0===r)return void this.lineTo(t,e);function l([t,e]){const i=Math.sqrt(t**2+e**2);return[t/i,e/i]}const h=l([a-t,o-e]),_=l([i-t,s-e]);if(h[0]*_[1]==h[1]*_[0])return void this.lineTo(t,e);const c=h[0]*_[0]+h[1]*_[1],p=Math.acos(Math.abs(c)),u=l([h[0]+_[0],h[1]+_[1]]),d=r/Math.sin(p/2),m=t+d*u[0],f=e+d*u[1],g=[-h[1],h[0]],b=[_[1],-_[0]];function A(t){const e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)}const v=A(g),w=A(b);this.lineTo(m+g[0]*r,f+g[1]*r),this.arc(m,f,r,v,w)}stroke(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}fill(t,e){let i=null;if(t instanceof Path2D)i=t;else{if(null!=e)throw new Error("invalid arguments");e=t}if(null!=i)throw new Error("not implemented");"none"!=this.__currentElement.getAttribute("fill")&&this.__init_element(),"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill"),null!=e&&this.__currentElement.setAttribute("fill-rule",e),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}rect(t,e,i,s){isFinite(t+e+i+s)&&(this.moveTo(t,e),this.lineTo(t+i,e),this.lineTo(t+i,e+s),this.lineTo(t,e+s),this.lineTo(t,e),this.closePath())}fillRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.fill())}strokeRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.stroke())}__clearCanvas(){(0,h.empty)(this.__defs),(0,h.empty)(this.__root),this.__root.appendChild(this.__defs),this.__currentElement=this.__root}clearRect(t,e,i,s){if(!isFinite(t+e+i+s))return;if(0===t&&0===e&&i===this.width&&s===this.height)return void this.__clearCanvas();const r=this.__createElement("rect",{x:t,y:e,width:i,height:s,fill:"#FFFFFF"},!0);this._apply_transform(r),this.__root.appendChild(r)}roundRect(t,e,i,s,r){throw new Error("not implemented")}createLinearGradient(t,e,i,s){if(!isFinite(t+e+i+s))throw new Error("The provided double value is non-finite");const[r,n]=this._transform.apply(t,e),[a,o]=this._transform.apply(i,s),l=this.__createElement("linearGradient",{id:this._random_string(),x1:`${r}px`,x2:`${a}px`,y1:`${n}px`,y2:`${o}px`,gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(l),new m(l,this)}createRadialGradient(t,e,i,s,r,n){if(!isFinite(t+e+i+s+r+n))throw new Error("The provided double value is non-finite");const[a,o]=this._transform.apply(t,e),[l,h]=this._transform.apply(s,r),_=this.__createElement("radialGradient",{id:this._random_string(),cx:`${l}px`,cy:`${h}px`,r:`${n}px`,r0:`${i}px`,fx:`${a}px`,fy:`${o}px`,gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(_),new m(_,this)}createConicGradient(t,e,i){throw Error("not implemented")}__parseFont(){const[,t,e,i,s,,r]=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font);return{style:t??"normal",size:s??"10px",family:r??"sans-serif",weight:i??"normal",decoration:e??"normal"}}__applyText(t,e,i,s){const r=this.__parseFont(),n=this.__createElement("text",{"font-family":r.family,"font-size":r.size,"font-style":r.style,"font-weight":r.weight,"text-decoration":r.decoration,x:e,y:i,"text-anchor":_(this.textAlign),"dominant-baseline":c(this.textBaseline)},!0);n.appendChild(this.__document.createTextNode(t)),this._apply_transform(n),this.__currentElement=n,this.__applyStyleToCurrentElement(s);const a=(()=>{if(null!=this._clip_path){const t=this.__createElement("g");return t.setAttribute("clip-path",this._clip_path),t.appendChild(n),t}return n})();this.__root.appendChild(a)}fillText(t,e,i){isFinite(e+i)&&this.__applyText(t,e,i,"fill")}strokeText(t,e,i){isFinite(e+i)&&this.__applyText(t,e,i,"stroke")}measureText(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)}arc(t,e,i,s,r,n=!1){this.ellipse(t,e,i,i,0,s,r,n)}ellipse(t,e,i,s,r,a,o,h=!1){if(!isFinite(t+e+i+s+r+a+o))return;if(i<0||s<0)throw new DOMException("IndexSizeError, radius can't be negative");const _=h?o-a:a-o;a%=2*Math.PI,o%=2*Math.PI;const c=(new n.AffineTransform).translate(t,e).rotate(r),p=i*Math.cos(a),u=s*Math.sin(a),[d,m]=c.apply(p,u);this.lineTo(d,m);const f=180*r/Math.PI,g=h?0:1;if(Math.abs(a-o)<2*l.float32_epsilon&&!(Math.abs(_)<2*l.float32_epsilon&&_<0)){const[t,e]=this._transform.apply(d,m),r=i*Math.cos(a+Math.PI),n=s*Math.sin(a+Math.PI),[o,l]=c.apply(r,n),[h,_]=this._transform.apply(o,l);this.__addPathCommand(t,e,`A ${i} ${s} ${f} 0 ${g} ${h} ${_} A ${i} ${s} ${f} 0 ${g} ${t} ${e}`)}else{const t=i*Math.cos(o),e=s*Math.sin(o),[r,n]=c.apply(t,e);let l=o-a;l<0&&(l+=2*Math.PI);const _=h!==l>Math.PI?1:0,[p,u]=this._transform.apply(r,n);this.__addPathCommand(p,u,`A ${i} ${s} ${f} ${_} ${g} ${p} ${u}`)}}clip(t,e){let i=null;if(t instanceof Path2D)i=t;else{if(null!=e)throw new Error("invalid arguments");e=t}if(null!=i)throw new Error("not implemented");const s=this.__createElement("clipPath"),r=this._random_string();this.__applyCurrentDefaultPath(),null!=e&&this.__currentElement.setAttribute("clip-rule",e),s.setAttribute("id",r),s.appendChild(this.__currentElement),this.__defs.appendChild(s),this._clip_path=`url(#${r})`}drawImage(t,...e){let i,s,r,n,a,o,l,h;if(2==e.length){if([i,s]=e,!isFinite(i+s))return;a=0,o=0;const[_,c]=d(t);r=l=_,n=h=c}else if(4==e.length){if([i,s,r,n]=e,!isFinite(i+s+r+n))return;a=0,o=0;const[_,c]=d(t);l=_,h=c}else{if(8!==e.length)throw new Error(`Inavlid number of arguments passed to drawImage: ${arguments.length}`);if([a,o,l,h,i,s,r,n]=e,!isFinite(a+o+l+h+i+s+r+n))return}const _=this.__root,c=this._transform.clone().translate(i,s);if(t instanceof g||t instanceof SVGSVGElement){const e=(t instanceof SVGSVGElement?t:t.get_svg()).cloneNode(!0);let i;c.is_identity&&1==this.globalAlpha&&null==this._clip_path?i=_:(i=this.__createElement("g"),c.is_identity||this._apply_transform(i,c),1!=this.globalAlpha&&i.setAttribute("opacity",`${this.globalAlpha}`),null!=this._clip_path&&i.setAttribute("clip-path",this._clip_path),_.appendChild(i));for(const t of[...e.childNodes])if(t instanceof SVGDefsElement){for(const e of[...t.childNodes])if(e instanceof Element){const t=e.getAttribute("id");this.__ids.add(t),this.__defs.appendChild(e.cloneNode(!0))}}else i.appendChild(t.cloneNode(!0))}else if(t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__createElement("image");if(e.setAttribute("width",`${r}`),e.setAttribute("height",`${n}`),e.setAttribute("preserveAspectRatio","none"),1!=this.globalAlpha&&e.setAttribute("opacity",`${this.globalAlpha}`),0!=a||0!=o||l!==t.width||h!==t.height){const e=this.__document.createElement("canvas");e.width=r,e.height=n;e.getContext("2d").drawImage(t,a,o,l,h,0,0,r,n),t=e}this._apply_transform(e,c);const i=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");if(e.setAttribute("href",i),null!=this._clip_path){const t=this.__createElement("g");t.setAttribute("clip-path",this._clip_path),t.appendChild(e),_.appendChild(t)}else _.appendChild(e)}else if(t instanceof HTMLCanvasElement){const e=this.__createElement("image");e.setAttribute("width",`${r}`),e.setAttribute("height",`${n}`),e.setAttribute("preserveAspectRatio","none"),1!=this.globalAlpha&&e.setAttribute("opacity",`${this.globalAlpha}`);const i=this.__document.createElement("canvas");i.width=r,i.height=n;const s=i.getContext("2d");if(s.imageSmoothingEnabled=!1,s.drawImage(t,a,o,l,h,0,0,r,n),t=i,this._apply_transform(e,c),e.setAttribute("href",t.toDataURL()),null!=this._clip_path){const t=this.__createElement("g");t.setAttribute("clip-path",this._clip_path),t.appendChild(e),_.appendChild(t)}else _.appendChild(e)}}createPattern(t,e){const i=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),s=this._random_string(),[r,n]=d(t);if(i.setAttribute("id",s),i.setAttribute("width",`${r}`),i.setAttribute("height",`${n}`),i.setAttribute("patternUnits","userSpaceOnUse"),t instanceof HTMLCanvasElement||t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__document.createElementNS("http://www.w3.org/2000/svg","image"),s=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");e.setAttribute("href",s),i.appendChild(e),this.__defs.appendChild(i)}else if(t instanceof g){for(const e of[...t.__root.childNodes])e instanceof SVGDefsElement||i.appendChild(e.cloneNode(!0));this.__defs.appendChild(i)}else{if(!(t instanceof SVGSVGElement))throw new Error("unsupported");for(const e of[...t.childNodes])e instanceof SVGDefsElement||i.appendChild(e.cloneNode(!0));this.__defs.appendChild(i)}return new f(i,this)}getLineDash(){const{lineDash:t}=this;return(0,a.isString)(t)?t.split(",").map((t=>parseInt(t))):t??[]}setLineDash(t){t.length>0?this.lineDash=t.join(","):this.lineDash=null}getTransform(){return this._transform.to_DOMMatrix()}setTransform(...t){let e;e=(0,a.isNumber)(t[0])?new DOMMatrix(t):t[0]instanceof DOMMatrix?t[0]:new DOMMatrix(Object.values(null==t[0])),this._transform=n.AffineTransform.from_DOMMatrix(e)}resetTransform(){this._transform=new n.AffineTransform}isPointInPath(...t){throw new Error("not implemented")}isPointInStroke(...t){throw new Error("not implemented")}createImageData(...t){throw new Error("not implemented")}getImageData(t,e,i,s){throw new Error("not implemented")}putImageData(...t){throw new Error("not implemented")}drawFocusIfNeeded(...t){throw new Error("not implemented")}scrollPathIntoView(...t){throw new Error("not implemented")}}i.SVGRenderingContext2D=g,g.__name__="SVGRenderingContext2D",g.__random=o.random},
function _(t,r,s,e,i){e();const n=t(26),{sin:a,cos:h}=Math;class o{constructor(t=1,r=0,s=0,e=1,i=0,n=0){this.a=t,this.b=r,this.c=s,this.d=e,this.e=i,this.f=n}toString(){const{a:t,b:r,c:s,d:e,e:i,f:n}=this;return`matrix(${t}, ${r}, ${s}, ${e}, ${i}, ${n})`}static from_DOMMatrix(t){const{a:r,b:s,c:e,d:i,e:n,f:a}=t;return new o(r,s,e,i,n,a)}to_DOMMatrix(){const{a:t,b:r,c:s,d:e,e:i,f:n}=this;return new DOMMatrix([t,r,s,e,i,n])}clone(){const{a:t,b:r,c:s,d:e,e:i,f:n}=this;return new o(t,r,s,e,i,n)}[n.equals](t,r){return r.eq(this.a,t.a)&&r.eq(this.b,t.b)&&r.eq(this.c,t.c)&&r.eq(this.d,t.d)&&r.eq(this.e,t.e)&&r.eq(this.f,t.f)}reset(){this.a=1,this.b=0,this.c=0,this.d=1,this.e=0,this.f=0}get is_identity(){const{a:t,b:r,c:s,d:e,e:i,f:n}=this;return 1==t&&0==r&&0==s&&1==e&&0==i&&0==n}apply_point(t){const[r,s]=this.apply(t.x,t.y);return{x:r,y:s}}apply_rect(t){return{p0:this.apply_point(t.p0),p1:this.apply_point(t.p1),p2:this.apply_point(t.p2),p3:this.apply_point(t.p3)}}apply(t,r){const{a:s,b:e,c:i,d:n,e:a,f:h}=this;return[s*t+i*r+a,e*t+n*r+h]}iv_apply(t,r){const{a:s,b:e,c:i,d:n,e:a,f:h}=this,o=t.length;for(let c=0;c<o;c++){const o=t[c],p=r[c];t[c]=s*o+i*p+a,r[c]=e*o+n*p+h}}transform(t,r,s,e,i,n){const{a,b:h,c:o,d:c,e:p,f}=this;return this.a=a*t+o*r,this.c=a*s+o*e,this.e=a*i+o*n+p,this.b=h*t+c*r,this.d=h*s+c*e,this.f=h*i+c*n+f,this}translate(t,r){return this.transform(1,0,0,1,t,r)}scale(t,r){return this.transform(t,0,0,r,0,0)}skew(t,r){return this.transform(1,r,t,1,0,0)}rotate(t){if(0==t)return this;const r=a(t),s=h(t);return this.transform(s,r,-r,s,0,0)}rotate_ccw(t){return this.rotate(-t)}rotate_around(t,r,s){return this.translate(t,r),this.rotate(s),this.translate(-t,-r),this}translate_x(t){return this.translate(t,0)}translate_y(t){return this.translate(0,t)}flip(){return this.scale(-1,-1)}flip_x(){return this.scale(1,-1)}flip_y(){return this.scale(-1,1)}inverse(){return o.from_DOMMatrix(this.to_DOMMatrix().inverse())}}s.AffineTransform=o,o.__name__="AffineTransform",s.rotate_around=function(t,r,s){if(0==s)return t;{const e=new o;e.rotate_around(r.x,r.y,s);const[i,n]=e.apply(t.x,t.y);return{x:i,y:n}}}},
function _(t,e,n,s,r){s();const{PI:o,log:a,sin:_,cos:i,sqrt:m,floor:l}=Math;n.MAX_INT32=2147483647;class d{float(){return(this.integer()-1)/(n.MAX_INT32-1)}floats(t,e=0,n=1){const s=new Array(t);for(let r=0;r<t;r++)s[r]=e+this.float()*(n-e);return s}choices(t,e){const n=e.length,s=new Array(t);for(let r=0;r<t;r++)s[r]=e[this.integer()%n];return s}uniform(t,e){return t+(this.float()-.5)*e}uniforms(t,e,n){return Float64Array.from({length:n},(()=>this.uniform(t,e)))}normal(t,e){return this.normals(t,e,1)[0]}normals(t,e,n){const[s,r]=[t,e],l=new Float64Array(n);for(let t=0;t<n;t+=2){const e=this.float(),d=this.float(),h=m(-2*a(e));l[t]=s+r*(h*i(2*o*d)),t+1<n&&(l[t+1]=s+r*(h*_(2*o*d)))}return l}}n.AbstractRandom=d,d.__name__="AbstractRandom";class h extends d{integer(){return l(Math.random()*n.MAX_INT32)}}n.SystemRandom=h,h.__name__="SystemRandom";class c extends d{constructor(t){super(),this._seed=t%n.MAX_INT32,this._seed<=0&&(this._seed+=n.MAX_INT32-1)}integer(){return this._seed=48271*this._seed%n.MAX_INT32,this._seed}}n.LCGRandom=c,c.__name__="LCGRandom";class f extends c{}n.Random=f,f.__name__="Random",n.random=new f(Date.now())},
function _(t,i,o,e,n){e(),o.default=":host{position:relative;}"},
function _(e,n,t,s,c){s();const o=e(51);class u extends o.Model{constructor(e){super(e)}}t.MenuItem=u,u.__name__="MenuItem"},
function _(e,l,n,t,o){var a;t();const c=e(115),u=e(117),i=e(20),s=e(21),r=(0,s.Or)(i.ToolIcon,(0,s.Regex)(/^--/),(0,s.Regex)(/^\./),(0,s.Regex)(/^data:image/));class m extends c.MenuItem{constructor(e){super(e)}}n.ActionItem=m,a=m,m.__name__="ActionItem",a.define((({Bool:e,Str:l,Nullable:n,AnyRef:t,Ref:o})=>({icon:[n(r),null],label:[l],tooltip:[n(l),null],shortcut:[n(l),null],menu:[n(t()),null],disabled:[e,!1],action:[n(o(u.Callback)),null]})))},
function _(c,a,l,n,s){n();const e=c(51);class o extends e.Model{constructor(c){super(c)}}l.Callback=o,o.__name__="Callback"},
function _(e,c,t,n,o){var s;n();const a=e(116);class _ extends a.ActionItem{constructor(e){super(e)}}t.CheckableItem=_,s=_,_.__name__="CheckableItem",s.define((({Bool:e})=>({checked:[e,!1]})))},
function _(e,t,n,s,c){s();const i=e(115);class r extends i.MenuItem{constructor(e){super(e)}}n.DividerItem=r,r.__name__="DividerItem"},
function _(e,o,r,i,t){i(),r.item="bk-item",r.divider="bk-divider",r.check="bk-check",r.icon="bk-icon",r.label="bk-label",r.shortcut="bk-shortcut",r.chevron="bk-chevron",r.disabled="bk-disabled",r.menu="bk-menu",r.checkable="bk-checkable",r.checked="bk-checked",r.default=":host{position:absolute;display:inline-grid;grid-template-columns:repeat(5, max-content);grid-template-rows:auto;user-select:none;-webkit-user-select:none;cursor:pointer;width:auto;height:auto;z-index:var(--bokeh-top-level);font-size:var(--font-size);background-color:#fff;border:1px solid #ccc;border-radius:var(--border-radius);box-shadow:2px 4px 8px rgba(0, 0, 0, 0.175);}.bk-item,.bk-divider{position:relative;display:grid;grid-template-columns:subgrid;grid-column:span 5;align-items:center;}.bk-check{grid-column:1;}.bk-icon{grid-column:2;}.bk-label{grid-column:3;}.bk-shortcut{grid-column:4;}.bk-chevron{grid-column:5;}.bk-divider{cursor:default;overflow:hidden;background-color:#e5e5e5;height:1px;margin:1px 5px;}.bk-item{padding:0.5em;}.bk-item:hover{background-color:#f9f9f9;}.bk-item:focus,.bk-item:focus-visible{outline:1px dotted var(--active-tool-highlight);outline-offset:-1px;}.bk-item::-moz-focus-inner{border:0;}.bk-item.bk-disabled{color:gray;}.bk-item.bk-disabled .bk-icon{color:var(--bokeh-icon-color-disabled);}.bk-item:first-of-type{border-top-left-radius:var(--border-radius);border-top-right-radius:var(--border-radius);}.bk-item:last-of-type{border-bottom-left-radius:var(--border-radius);border-bottom-right-radius:var(--border-radius);}.bk-icon{position:relative;width:16px;height:16px;mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;background-size:100% 100%;background-origin:border-box;background-position:center center;background-repeat:no-repeat;}.bk-label{padding:0 0.5em;}.bk-shortcut{text-align:right;font-size:90%;color:gray;}.bk-chevron{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-caret-right);-webkit-mask-image:var(--bokeh-icon-caret-right);mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;width:12px;height:12px;}.bk-item:not(.bk-menu) .bk-chevron{display:none;}.bk-item.bk-checkable .bk-check{width:16px;height:16px;}.bk-item.bk-checkable.bk-checked .bk-check{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-check);-webkit-mask-image:var(--bokeh-icon-check);mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;}"},
function _(o,e,t,i,n){i(),t.tool_icon_square_check=t.tool_icon_square=t.tool_icon_check=t.tool_icon_text_align_right=t.tool_icon_text_align_center=t.tool_icon_text_align_left=t.tool_icon_italic=t.tool_icon_bold=t.tool_icon_delete=t.tool_icon_pointer=t.tool_icon_unpin=t.tool_icon_pin=t.tool_icon_maximize=t.tool_icon_minimize=t.tool_icon_arrow_up_from_bar=t.tool_icon_arrow_down_to_bar=t.tool_icon_y_grip=t.tool_icon_x_grip=t.tool_icon_see_off=t.tool_icon_see_on=void 0,t.tool_icon_copy="bk-tool-icon-copy",t.tool_icon_replace_mode="bk-tool-icon-replace-mode",t.tool_icon_append_mode="bk-tool-icon-append-mode",t.tool_icon_intersect_mode="bk-tool-icon-intersect-mode",t.tool_icon_subtract_mode="bk-tool-icon-subtract-mode",t.tool_icon_xor_mode="bk-tool-icon-xor-mode",t.tool_icon_invert_selection="bk-tool-icon-invert-selection",t.tool_icon_clear_selection="bk-tool-icon-clear-selection",t.tool_icon_box_select="bk-tool-icon-box-select",t.tool_icon_x_box_select="bk-tool-icon-x-box-select",t.tool_icon_y_box_select="bk-tool-icon-y-box-select",t.tool_icon_box_zoom="bk-tool-icon-box-zoom",t.tool_icon_x_box_zoom="bk-tool-icon-x-box-zoom",t.tool_icon_y_box_zoom="bk-tool-icon-y-box-zoom",t.tool_icon_auto_box_zoom="bk-tool-icon-auto-box-zoom",t.tool_icon_zoom_in="bk-tool-icon-zoom-in",t.tool_icon_zoom_out="bk-tool-icon-zoom-out",t.tool_icon_help="bk-tool-icon-help",t.tool_icon_hover="bk-tool-icon-hover",t.tool_icon_crosshair="bk-tool-icon-crosshair",t.tool_icon_lasso_select="bk-tool-icon-lasso-select",t.tool_icon_pan="bk-tool-icon-pan",t.tool_icon_x_pan="bk-tool-icon-x-pan",t.tool_icon_y_pan="bk-tool-icon-y-pan",t.tool_icon_range="bk-tool-icon-range",t.tool_icon_polygon_select="bk-tool-icon-polygon-select",t.tool_icon_redo="bk-tool-icon-redo",t.tool_icon_reset="bk-tool-icon-reset",t.tool_icon_save="bk-tool-icon-save",t.tool_icon_tap_select="bk-tool-icon-tap-select",t.tool_icon_undo="bk-tool-icon-undo",t.tool_icon_wheel_pan="bk-tool-icon-wheel-pan",t.tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",t.tool_icon_box_edit="bk-tool-icon-box-edit",t.tool_icon_freehand_draw="bk-tool-icon-freehand-draw",t.tool_icon_poly_draw="bk-tool-icon-poly-draw",t.tool_icon_point_draw="bk-tool-icon-point-draw",t.tool_icon_poly_edit="bk-tool-icon-poly-edit",t.tool_icon_line_edit="bk-tool-icon-line-edit",t.tool_icon_settings="bk-tool-icon-settings",t.tool_icon_unknown="bk-tool-icon-unknown",t.tool_icon_fullscreen="bk-tool-icon-fullscreen",t.tool_icon_chevron_up="bk-tool-icon-chevron-up",t.tool_icon_chevron_down="bk-tool-icon-chevron-down",t.tool_icon_chevron_left="bk-tool-icon-chevron-left",t.tool_icon_chevron_right="bk-tool-icon-chevron-right",t.tool_icon_caret_up="bk-tool-icon-caret-up",t.tool_icon_caret_down="bk-tool-icon-caret-down",t.tool_icon_caret_left="bk-tool-icon-caret-left",t.tool_icon_caret_right="bk-tool-icon-caret-right",t.tool_icon_see_on="bk-tool-icon-see-on",t.tool_icon_see_off="bk-tool-icon-see-off",t.tool_icon_x_grip="bk-tool-icon-x-grip",t.tool_icon_y_grip="bk-tool-icon-y-grip",t.tool_icon_arrow_down_to_bar="bk-tool-icon-arrow-down-to-bar",t.tool_icon_arrow_up_from_bar="bk-tool-icon-arrow-up-from-bar",t.tool_icon_minimize="bk-tool-icon-minimize",t.tool_icon_maximize="bk-tool-icon-maximize",t.tool_icon_pin="bk-tool-icon-pin",t.tool_icon_unpin="bk-tool-icon-unpin",t.tool_icon_pointer="bk-tool-icon-pointer",t.tool_icon_delete="bk-tool-icon-delete",t.tool_icon_bold="bk-tool-icon-bold",t.tool_icon_italic="bk-tool-icon-italic",t.tool_icon_text_align_left="bk-tool-icon-text-align-left",t.tool_icon_text_align_center="bk-tool-icon-text-align-center",t.tool_icon_text_align_right="bk-tool-icon-text-align-right",t.tool_icon_check="bk-tool-icon-check",t.tool_icon_square="bk-tool-icon-square",t.tool_icon_square_check="bk-tool-icon-square-check",t.default=':host{--bokeh-icon-color:#a1a6a9;--bokeh-icon-color-disabled:#d4d9db;}.bk-tool-icon-copy{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-copy);-webkit-mask-image:var(--bokeh-icon-copy);}.bk-tool-icon-replace-mode{background-image:var(--bokeh-icon-replace-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC"));}.bk-tool-icon-append-mode{background-image:var(--bokeh-icon-append-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII="));}.bk-tool-icon-intersect-mode{background-image:var(--bokeh-icon-intersect-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC"));}.bk-tool-icon-subtract-mode{background-image:var(--bokeh-icon-subtract-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg=="));}.bk-tool-icon-xor-mode{background-image:var(--bokeh-icon-xor-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAQAAADZc7J/AAAAAmJLR0QA/4ePzL8AAACXSURBVEjH3VXBCcAwCDxLxgl0oM7nQEL3sa9ASLQIqS3UT4SIOfXOECsAADsAwb1/ECbbsGilvdKfli9OgmUEdGo8uKb0QIZ6PUvrwfcJzCn0zGtM9fx1BKzzFMTgvRf3jBZGs1TnxeVNwUIxxsqrWmBNYmJptewBBuZMwas3uiP+sA+8i8i2rpSlRg7+FaxZCHpFpu/EC1y3NtihGuwKAAAAAElFTkSuQmCC"));}.bk-tool-icon-invert-selection{background-image:var(--bokeh-icon-invert-selection, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAQAAADZc7J/AAAAAmJLR0QA/4ePzL8AAAC2SURBVEjH7VVJEoQwCGysPMeqPCjv40FU+R/moCbMmEWNenFygUug6aYTmhRdZwBeX8ClVJboCRDN5SN4zc8gkBaCtaONKZ+vB0JEcT0HtmvtBALS+rnatAEAF/KcCroThXKZRAP0J3IUT25bpG33m1TwBCCqQOY9IKtCDsVkiOxQQdR6we2dlR+ws7FMYQObKsgJFUyB8Wtev2W+hYB1dtoxFa4mMaJQqb6PDRmPeIH+X1t/gQ8PhzjuVbw+wwAAAABJRU5ErkJggg=="));}.bk-tool-icon-clear-selection{background-image:var(--bokeh-icon-clear-selection, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC"));}.bk-tool-icon-box-select{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-box-select);-webkit-mask-image:var(--bokeh-icon-box-select);}.bk-tool-icon-x-box-select{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-x-box-select);-webkit-mask-image:var(--bokeh-icon-x-box-select);}.bk-tool-icon-y-box-select{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-y-box-select);-webkit-mask-image:var(--bokeh-icon-y-box-select);}.bk-tool-icon-box-zoom{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-box-zoom);-webkit-mask-image:var(--bokeh-icon-box-zoom);}.bk-tool-icon-x-box-zoom{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-x-box-zoom);-webkit-mask-image:var(--bokeh-icon-x-box-zoom);}.bk-tool-icon-y-box-zoom{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-y-box-zoom);-webkit-mask-image:var(--bokeh-icon-y-box-zoom);}.bk-tool-icon-auto-box-zoom{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-auto-box-zoom);-webkit-mask-image:var(--bokeh-icon-auto-box-zoom);}.bk-tool-icon-zoom-in{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-zoom-in);-webkit-mask-image:var(--bokeh-icon-zoom-in);}.bk-tool-icon-zoom-out{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-zoom-out);-webkit-mask-image:var(--bokeh-icon-zoom-out);}.bk-tool-icon-help{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-help);-webkit-mask-image:var(--bokeh-icon-help);}.bk-tool-icon-hover{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-hover);-webkit-mask-image:var(--bokeh-icon-hover);}.bk-tool-icon-crosshair{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-crosshair);-webkit-mask-image:var(--bokeh-icon-crosshair);}.bk-tool-icon-lasso-select{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-lasso-select);-webkit-mask-image:var(--bokeh-icon-lasso-select);}.bk-tool-icon-pan{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-pan);-webkit-mask-image:var(--bokeh-icon-pan);}.bk-tool-icon-x-pan{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-x-pan);-webkit-mask-image:var(--bokeh-icon-x-pan);}.bk-tool-icon-y-pan{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-y-pan);-webkit-mask-image:var(--bokeh-icon-y-pan);}.bk-tool-icon-range{background-image:var(--bokeh-icon-range, url("data:image/png;base64,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"));}.bk-tool-icon-polygon-select{background-image:var(--bokeh-icon-polygon-select, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII="));}.bk-tool-icon-redo{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-redo);-webkit-mask-image:var(--bokeh-icon-redo);}.bk-tool-icon-reset{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-reset);-webkit-mask-image:var(--bokeh-icon-reset);}.bk-tool-icon-save{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-save);-webkit-mask-image:var(--bokeh-icon-save);}.bk-tool-icon-tap-select{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-tap-select);-webkit-mask-image:var(--bokeh-icon-tap-select);}.bk-tool-icon-undo{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-undo);-webkit-mask-image:var(--bokeh-icon-undo);}.bk-tool-icon-wheel-pan{background-image:var(--bokeh-icon-wheel-pan, url("data:image/png;base64,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"));}.bk-tool-icon-wheel-zoom{background-image:var(--bokeh-icon-wheel-zoom, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII="));}.bk-tool-icon-box-edit{background-image:var(--bokeh-icon-box-edit, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII="));}.bk-tool-icon-freehand-draw{background-image:var(--bokeh-icon-freehand-draw, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg=="));}.bk-tool-icon-poly-draw{background-image:var(--bokeh-icon-poly-draw, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg=="));}.bk-tool-icon-point-draw{background-image:var(--bokeh-icon-point-draw, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg=="));}.bk-tool-icon-poly-edit{background-image:var(--bokeh-icon-poly-edit, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII="));}.bk-tool-icon-line-edit{background-image:var(--bokeh-icon-line-edit, url("data:image/png;base64,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"));}.bk-tool-icon-settings{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-settings);-webkit-mask-image:var(--bokeh-icon-settings);}.bk-tool-icon-unknown{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-unknown);-webkit-mask-image:var(--bokeh-icon-unknown);}.bk-tool-icon-fullscreen{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-fullscreen);-webkit-mask-image:var(--bokeh-icon-fullscreen);}.bk-tool-icon-chevron-up{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-chevron-up);-webkit-mask-image:var(--bokeh-icon-chevron-up);}.bk-tool-icon-chevron-down{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-chevron-down);-webkit-mask-image:var(--bokeh-icon-chevron-down);}.bk-tool-icon-chevron-left{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-chevron-left);-webkit-mask-image:var(--bokeh-icon-chevron-left);}.bk-tool-icon-chevron-right{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-chevron-right);-webkit-mask-image:var(--bokeh-icon-chevron-right);}.bk-tool-icon-caret-up{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-caret-up);-webkit-mask-image:var(--bokeh-icon-caret-up);}.bk-tool-icon-caret-down{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-caret-down);-webkit-mask-image:var(--bokeh-icon-caret-down);}.bk-tool-icon-caret-left{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-caret-left);-webkit-mask-image:var(--bokeh-icon-caret-left);}.bk-tool-icon-caret-right{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-caret-right);-webkit-mask-image:var(--bokeh-icon-caret-right);}.bk-tool-icon-see-on{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-see-on);-webkit-mask-image:var(--bokeh-icon-see-on);}.bk-tool-icon-see-off{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-see-off);-webkit-mask-image:var(--bokeh-icon-see-off);}.bk-tool-icon-x-grip{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-y-grip);-webkit-mask-image:var(--bokeh-icon-y-grip);}.bk-tool-icon-y-grip{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-y-grip);-webkit-mask-image:var(--bokeh-icon-y-grip);}.bk-tool-icon-arrow-down-to-bar{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-arrow-down-to-bar);-webkit-mask-image:var(--bokeh-icon-arrow-down-to-bar);}.bk-tool-icon-arrow-up-from-bar{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-arrow-up-from-bar);-webkit-mask-image:var(--bokeh-icon-arrow-up-from-bar);}.bk-tool-icon-minimize{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-minimize);-webkit-mask-image:var(--bokeh-icon-minimize);}.bk-tool-icon-maximize{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-maximize);-webkit-mask-image:var(--bokeh-icon-maximize);}.bk-tool-icon-pin{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-pin);-webkit-mask-image:var(--bokeh-icon-pin);}.bk-tool-icon-unpin{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-unpin);-webkit-mask-image:var(--bokeh-icon-unpin);}.bk-tool-icon-pointer{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-hand-pointing);-webkit-mask-image:var(--bokeh-icon-hand-pointing);}.bk-tool-icon-delete{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-trash);-webkit-mask-image:var(--bokeh-icon-trash);}.bk-tool-icon-bold{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-bold);-webkit-mask-image:var(--bokeh-icon-bold);}.bk-tool-icon-italic{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-italic);-webkit-mask-image:var(--bokeh-icon-italic);}.bk-tool-icon-text-align-left{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-text-align-left);-webkit-mask-image:var(--bokeh-icon-text-align-left);}.bk-tool-icon-text-align-center{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-text-align-center);-webkit-mask-image:var(--bokeh-icon-text-align-center);}.bk-tool-icon-text-align-right{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-text-align-right);-webkit-mask-image:var(--bokeh-icon-text-align-right);}.bk-tool-icon-check{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-check);-webkit-mask-image:var(--bokeh-icon-check);}.bk-tool-icon-square{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-square);-webkit-mask-image:var(--bokeh-icon-square);}.bk-tool-icon-square-check{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-square-check);-webkit-mask-image:var(--bokeh-icon-square-check);}:host{--bokeh-icon-question-mark:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8%208a3.5%203%200%200%201%203.5%20-3h1a3.5%203%200%200%201%203.5%203a3%203%200%200%201%20-2%203a3%204%200%200%200%20-2%204%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%2219%22%20x2%3D%2212%22%20y2%3D%2219.01%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-help:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%229%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%2217%22%20x2%3D%2212%22%20y2%3D%2217.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2013.5a1.5%201.5%200%200%201%201%20-1.5a2.6%202.6%200%201%200%20-3%20-4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%206l-12%2012%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%206l12%2012%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-settings:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M10.325%204.317c.426%20-1.756%202.924%20-1.756%203.35%200a1.724%201.724%200%200%200%202.573%201.066c1.543%20-.94%203.31%20.826%202.37%202.37a1.724%201.724%200%200%200%201.065%202.572c1.756%20.426%201.756%202.924%200%203.35a1.724%201.724%200%200%200%20-1.066%202.573c.94%201.543%20-.826%203.31%20-2.37%202.37a1.724%201.724%200%200%200%20-2.572%201.065c-.426%201.756%20-2.924%201.756%20-3.35%200a1.724%201.724%200%200%200%20-2.573%20-1.066c-1.543%20.94%20-3.31%20-.826%20-2.37%20-2.37a1.724%201.724%200%200%200%20-1.065%20-2.572c-1.756%20-.426%20-1.756%20-2.924%200%20-3.35a1.724%201.724%200%200%200%201.066%20-2.573c-.94%20-1.543%20.826%20-3.31%202.37%20-2.37c1%20.608%202.296%20.07%202.572%20-1.065z%22%3E%3C%2Fpath%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%223%22%3E%3C%2Fcircle%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-unknown:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M14%203v4a1%201%200%200%200%201%201h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M17%2021h-10a2%202%200%200%201%20-2%20-2v-14a2%202%200%200%201%202%20-2h7l5%205v11a2%202%200%200%201%20-2%202z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2017v.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2014a1.5%201.5%200%201%200%20-1.14%20-2.474%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-fullscreen:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Crect%20x%3D%223%22%20y%3D%2216%22%20width%3D%225%22%20height%3D%225%22%20rx%3D%221%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012v-6a2%202%200%200%201%202%20-2h12a2%202%200%200%201%202%202v12a2%202%200%200%201%20-2%202h-6%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%208h4v4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%208l-5%205%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-save:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%2017v2a2%202%200%200%200%202%202h12a2%202%200%200%200%202%20-2v-2%22%20%2F%3E%0A%20%20%3Cpolyline%20points%3D%227%2011%2012%2016%2017%2011%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%224%22%20x2%3D%2212%22%20y2%3D%2216%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-copy:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Crect%20x%3D%228%22%20y%3D%228%22%20width%3D%2212%22%20height%3D%2212%22%20rx%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%208v-2a2%202%200%200%200%20-2%20-2h-8a2%202%200%200%200%20-2%202v8a2%202%200%200%200%202%202h2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-tap-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cline%20x1%3D%223%22%20y1%3D%2212%22%20x2%3D%226%22%20y2%3D%2212%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%223%22%20x2%3D%2212%22%20y2%3D%226%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227.8%22%20y1%3D%227.8%22%20x2%3D%225.6%22%20y2%3D%225.6%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2216.2%22%20y1%3D%227.8%22%20x2%3D%2218.4%22%20y2%3D%225.6%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227.8%22%20y1%3D%2216.2%22%20x2%3D%225.6%22%20y2%3D%2218.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012l9%203l-4%202l-2%204l-3%20-9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-lasso-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4.028%2013.252c-.657%20-.972%20-1.028%20-2.078%20-1.028%20-3.252c0%20-3.866%204.03%20-7%209%20-7s9%203.134%209%207s-4.03%207%20-9%207c-1.913%200%20-3.686%20-.464%20-5.144%20-1.255%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%225%22%20cy%3D%2215%22%20r%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%2017c0%201.42%20.316%202.805%201%204%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%209l3%203l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%209l-3%203l3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l3%203l3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%206l-3%20-3l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012v9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%203v9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%209l3%203l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%209l-3%203l3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l3%203l3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%206l-3%20-3l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012v9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%203v9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M17%2013l-4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l2%202l2%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%2015v2.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M17%2013l-4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l4%204%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l2%202l2%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%2015v2.5%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-auto-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-zoom-in:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2210%22%20cy%3D%2210%22%20r%3D%227%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227%22%20y1%3D%2210%22%20x2%3D%2213%22%20y2%3D%2210%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2210%22%20y1%3D%227%22%20x2%3D%2210%22%20y2%3D%2213%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2221%22%20y1%3D%2221%22%20x2%3D%2215%22%20y2%3D%2215%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-zoom-out:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2210%22%20cy%3D%2210%22%20r%3D%227%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227%22%20y1%3D%2210%22%20x2%3D%2213%22%20y2%3D%2210%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2221%22%20y1%3D%2221%22%20x2%3D%2215%22%20y2%3D%2215%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-undo:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2013l-4%20-4l4%20-4m-4%204h11a4%204%200%200%201%200%208h-1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-redo:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%2013l4%20-4l-4%20-4m4%204h-11a4%204%200%200%200%200%208h1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-reset:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M20%2011a8.1%208.1%200%200%200%20-15.5%20-2m-.5%20-4v4h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2013a8.1%208.1%200%200%200%2015.5%202m.5%204v-4h-4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-hover:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%2020l-3%20-3h-2a3%203%200%200%201%20-3%20-3v-6a3%203%200%200%201%203%20-3h10a3%203%200%200%201%203%203v6a3%203%200%200%201%20-3%203h-2l-3%203%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%228%22%20y1%3D%229%22%20x2%3D%2216%22%20y2%3D%229%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%228%22%20y1%3D%2213%22%20x2%3D%2214%22%20y2%3D%2213%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-crosshair:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%229%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M20%2012h-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2020v-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%204v4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%226%2015%2012%209%2018%2015%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%226%209%2012%2015%2018%209%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%2215%206%209%2012%2015%2018%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%229%206%2015%2012%209%2018%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(180%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(270%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(90%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-see-on:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2012c-2.667%204.667%20-6%207%20-10%207s-7.333%20-2.333%20-10%20-7c2.667%20-4.667%206%20-7%2010%20-7s7.333%202.333%2010%207%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-see-off:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cline%20x1%3D%223%22%20y1%3D%223%22%20x2%3D%2221%22%20y2%3D%2221%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10.584%2010.587a2%202%200%200%200%202.828%202.83%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9.363%205.365a9.466%209.466%200%200%201%202.637%20-.365c4%200%207.333%202.333%2010%207c-.778%201.361%20-1.612%202.524%20-2.503%203.488m-2.14%201.861c-1.631%201.1%20-3.415%201.651%20-5.357%201.651c-4%200%20-7.333%20-2.333%20-10%20-7c1.369%20-2.395%202.913%20-4.175%204.632%20-5.341%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-cursor-rotate:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%3E%0A%20%20%3Cg%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%20%20%3Cg%20stroke-width%3D%224%22%20stroke%3D%22white%22%3E%0A%20%20%20%20%20%20%3Cpath%20d%3D%22M9%204.55a8%208%200%200%201%206%2014.9m0%20-4.45v5h5%22%20%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%20%20%20%20%3Cg%20stroke-width%3D%222%22%20stroke%3D%22black%22%3E%0A%20%20%20%20%20%20%3Cpath%20d%3D%22M9%204.55a8%208%200%200%201%206%2014.9m0%20-4.45v5h5%22%20%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A") 12 12, auto;--bokeh-icon-x-grip:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%209m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%2015m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%209m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2015m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M19%209m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M19%2015m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-grip:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%205m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M9%2012m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M9%2019m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%205m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%2012m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%2019m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-arrow-down-to-bar:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%2020l16%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2014l0%20-10%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2014l4%20-4%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2014l-4%20-4%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-arrow-up-from-bar:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%204l0%2010%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%204l4%204%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%204l-4%204%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M4%2020l16%200%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-minimize:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%2019v-2a2%202%200%200%201%202%20-2h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%205v2a2%202%200%200%200%202%202h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%2015h2a2%202%200%200%201%202%202v2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%209h2a2%202%200%200%200%202%20-2v-2%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-maximize:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%208v-2a2%202%200%200%201%202%20-2h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M4%2016v2a2%202%200%200%200%202%202h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M16%204h2a2%202%200%200%201%202%202v2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M16%2020h2a2%202%200%200%200%202%20-2v-2%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pin:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%204.5l-4%204l-4%201.5l-1.5%201.5l7%207l1.5%20-1.5l1.5%20-4l4%20-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2015l-4.5%204.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M14.5%204l5.5%205.5%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-unpin:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3%203l18%2018%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%204.5l-3.249%203.249m-2.57%201.433l-2.181%20.818l-1.5%201.5l7%207l1.5%20-1.5l.82%20-2.186m1.43%20-2.563l3.25%20-3.251%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2015l-4.5%204.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M14.5%204l5.5%205.5%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-hand-pointing:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8%2013v-8.5a1.5%201.5%200%200%201%203%200v7.5%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M11%2011.5v-2a1.5%201.5%200%201%201%203%200v2.5%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M14%2010.5a1.5%201.5%200%200%201%203%200v1.5%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M17%2011.5a1.5%201.5%200%200%201%203%200v4.5a6%206%200%200%201%20-6%206h-2h.208a6%206%200%200%201%20-5.012%20-2.7a69.74%2069.74%200%200%201%20-.196%20-.3c-.312%20-.479%20-1.407%20-2.388%20-3.286%20-5.728a1.5%201.5%200%200%201%20.536%20-2.022a1.867%201.867%200%200%201%202.28%20.28l1.47%201.47%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-trash:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%207l16%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M10%2011l0%206%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M14%2011l0%206%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%207l1%2012a2%202%200%200%200%202%202h8a2%202%200%200%200%202%20-2l1%20-12%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M9%207v-3a1%201%200%200%201%201%20-1h4a1%201%200%200%201%201%201v3%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-bold:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M7%205h6a3.5%203.5%200%200%201%200%207h-6z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2012h1a3.5%203.5%200%200%201%200%207h-7v-7%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-italic:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M11%205l6%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M7%2019l6%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M14%205l-4%2014%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-text-align-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206l16%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012l10%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2018l14%200%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-text-align-center:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206l16%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M8%2012l8%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018l12%200%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-text-align-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206l16%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%2012l10%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018l14%200%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-check:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%2012l5%205l10%20-10%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-square:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3%203m0%202a2%202%200%200%201%202%20-2h14a2%202%200%200%201%202%202v14a2%202%200%200%201%20-2%202h-14a2%202%200%200%201%20-2%20-2z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-square-check:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3%203m0%202a2%202%200%200%201%202%20-2h14a2%202%200%200%201%202%202v14a2%202%200%200%201%20-2%202h-14a2%202%200%200%201%20-2%20-2z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2012l2%202l4%20-4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");}'},
function _(e,o,_,d,s){d();const n=e(57),c=e(51);class t extends n.DOMView{}_.DOMNodeView=t,t.__name__="DOMNodeView";class M extends c.Model{constructor(e){super(e)}}_.DOMNode=M,M.__name__="DOMNode",M.__module__="bokeh.models.dom"},
function _(t,e,s,a,r){var n;a();const i=t(1),_=t(124),o=t(165),l=t(85),d=t(20),c=t(24),h=t(56),u=t(24),p=i.__importStar(t(18)),v=t(11);class y extends _.DataAnnotationView{*children(){yield*super.children();const{start:t,end:e}=this;null!=t&&(yield t),null!=e&&(yield e)}async lazy_initialize(){await super.lazy_initialize();const{start:t,end:e}=this.model;null!=t&&(this.start=await(0,h.build_view)(t,{parent:this})),null!=e&&(this.end=await(0,h.build_view)(e,{parent:this}))}set_data(t){super.set_data(t);const e=u.Indices.all_set(this._x_start.length);this.start?.set_data(t,e),this.end?.set_data(t,e)}remove(){this.start?.remove(),this.end?.remove(),super.remove()}map_data(){const{frame:t}=this.plot_view,[e,s]=(()=>{switch(this.model.start_units){case"canvas":return[new c.ScreenArray(this._x_start),new c.ScreenArray(this._y_start)];case"screen":return[t.bbox.xview.v_compute(this._x_start),t.bbox.yview.v_compute(this._y_start)];case"data":return[this.coordinates.x_scale.v_compute(this._x_start),this.coordinates.y_scale.v_compute(this._y_start)]}})(),[a,r]=(()=>{switch(this.model.end_units){case"canvas":return[new c.ScreenArray(this._x_end),new c.ScreenArray(this._y_end)];case"screen":return[t.bbox.xview.v_compute(this._x_end),t.bbox.yview.v_compute(this._y_end)];case"data":return[this.coordinates.x_scale.v_compute(this._x_end),this.coordinates.y_scale.v_compute(this._y_end)]}})();this._sx_start=e,this._sy_start=s,this._sx_end=a,this._sy_end=r;const n=e.length,i=this._angles=new c.ScreenArray(n);for(let t=0;t<n;t++)i[t]=Math.PI/2+(0,v.atan2)([e[t],s[t]],[a[t],r[t]])}paint(t){const{start:e,end:s}=this,{_sx_start:a,_sy_start:r,_sx_end:n,_sy_end:i,_angles:_}=this,{x:o,y:l,width:d,height:c}=this.plot_view.frame.bbox;for(let h=0,u=a.length;h<u;h++)null!=s&&(t.save(),t.translate(n[h],i[h]),t.rotate(_[h]),s.render(t,h),t.restore()),null!=e&&(t.save(),t.translate(a[h],r[h]),t.rotate(_[h]+Math.PI),e.render(t,h),t.restore()),this.visuals.line.doit&&(t.save(),null==e&&null==s||(t.beginPath(),t.rect(o,l,d,c),null!=s&&(t.save(),t.translate(n[h],i[h]),t.rotate(_[h]),s.clip(t,h),t.restore()),null!=e&&(t.save(),t.translate(a[h],r[h]),t.rotate(_[h]+Math.PI),e.clip(t,h),t.restore()),t.closePath(),t.clip()),t.beginPath(),t.moveTo(a[h],r[h]),t.lineTo(n[h],i[h]),this.visuals.line.apply(t,h),t.restore())}}s.ArrowView=y,y.__name__="ArrowView";class w extends _.DataAnnotation{constructor(t){super(t)}}s.Arrow=w,n=w,w.__name__="Arrow",n.prototype.default_view=y,n.mixins(l.LineVector),n.define((({Ref:t,Nullable:e})=>({x_start:[p.XCoordinateSpec,{field:"x_start"}],y_start:[p.YCoordinateSpec,{field:"y_start"}],start_units:[d.CoordinateUnits,"data"],start:[e(t(o.ArrowHead)),null],x_end:[p.XCoordinateSpec,{field:"x_end"}],y_end:[p.YCoordinateSpec,{field:"y_end"}],end_units:[d.CoordinateUnits,"data"],end:[e(t(o.ArrowHead)),()=>new o.OpenHead]})))},
function _(t,e,n,s,a){var o;s();const i=t(1),c=t(79),r=t(125),_=t(130),l=t(131),h=i.__importStar(t(18));class d extends c.AnnotationView{constructor(){super(...arguments),this._initial_set_data=!1}connect_signals(){super.connect_signals();const t=()=>{this.set_data(this.model.source),this._rerender()};this.connect(this.model.change,t),this.connect(this.model.source.streaming,t),this.connect(this.model.source.patching,t),this.connect(this.model.source.change,t)}_rerender(){this.request_render()}set_data(t){const e=this;for(const n of this.model)if(n instanceof h.VectorSpec||n instanceof h.ScalarSpec)if(n instanceof h.BaseCoordinateSpec){const s=n.array(t);e[`_${n.attr}`]=s}else{const s=n.uniform(t);e[`${n.attr}`]=s}this.plot_model.use_map&&(null!=e._x&&l.inplace.project_xy(e._x,e._y),null!=e._xs&&l.inplace.project_xsys(e._xs,e._ys));for(const t of this.visuals)t.update()}_render(){this._initial_set_data||(this.set_data(this.model.source),this._initial_set_data=!0),this.map_data(),this.paint(this.layer.ctx)}}n.DataAnnotationView=d,d.__name__="DataAnnotationView";class u extends c.Annotation{constructor(t){super(t)}}n.DataAnnotation=u,o=u,u.__name__="DataAnnotation",o.define((({Ref:t})=>({source:[t(r.ColumnarDataSource),()=>new _.ColumnDataSource]})))},
function _(t,e,n,s,r){var i;s();const a=t(19),c=t(126),o=t(15),l=t(12),u=t(10),h=t(30),d=t(9),f=t(8),g=t(128),_=t(127),p=t(129);class y extends p.DataSource{get_array(t){const e=(0,d.dict)(this.data);let n=e.get(t);return null==n?e.set(t,n=[]):(0,f.isArray)(n)||e.set(t,n=Array.from(n)),n}constructor(t){super(t),this.selection_manager=new c.SelectionManager(this)}initialize(){super.initialize(),this._select=new o.Signal0(this,"select"),this.inspect=new o.Signal(this,"inspect")}get inferred_defaults(){const t=new Map;for(const[e,n]of(0,d.entries)(this.data)){const s=(()=>{if((0,h.is_NDArray)(n))switch(n.dtype){case"bool":return!1;case"uint8":case"int8":case"uint16":case"int16":case"uint32":case"int32":case"float32":case"float64":return 0;case"object":return null}else if((0,f.isArray)(n)&&0!=n.length){const[t]=n;if(null===t)return null;if((0,f.isBoolean)(t))return!1;if((0,f.isNumber)(t))return 0;if((0,f.isString)(t))return"";if((0,f.isArray)(t))return[]}})();void 0!==s&&t.set(e,s)}return t}get(t){const e=this.get_column(t);return(0,l.assert)(null!=e,`unknown column '${t}' in ${this}`),e}set(t,e){(0,d.dict)(this.data).set(t,e)}get_column(t){return(0,d.dict)(this.data).get(t)??null}columns(){return(0,d.keys)(this.data)}get_length(t=!0){const e=(0,u.uniq)((0,d.values)(this.data).map((t=>(0,h.is_NDArray)(t)?t.shape[0]:t.length)));switch(e.length){case 0:return null;case 1:return e[0];default:{const n="data source has columns of inconsistent lengths";if(t)return a.logger.warn(n),e.sort()[0];throw new Error(n)}}}get length(){return this.get_length()??0}clear(){const t=(0,d.clone)(this.data),e=(0,d.dict)(t);for(const[t,n]of e){const s=new n.constructor(0);e.set(t,s)}this.data=t}stream(t,e,{sync:n}={}){this.stream_to(this.properties.data,t,e,{sync:n})}patch(t,{sync:e}={}){this.patch_to(this.properties.data,t,{sync:e})}}n.ColumnarDataSource=y,i=y,y.__name__="ColumnarDataSource",i.define((({Ref:t,Dict:e,Unknown:n})=>({default_values:[e(n),{}],selection_policy:[t(g.SelectionPolicy),()=>new g.UnionRenderers]}))),i.internal((({AnyRef:t})=>({inspected:[t(),()=>new _.Selection]})))},
function _(e,t,s,o,c){o();const n=e(127);function i(e){return"GlyphRenderer"==e.model.type}function r(e){return"GraphRenderer"==e.model.type}class l{constructor(e){this.inspectors=new Map,this.source=e}select(e,t,s,o="replace"){const c=[],n=[];for(const t of e)i(t)?c.push(t):r(t)&&n.push(t);let l=!1;for(const e of n){const c=e.model.selection_policy.hit_test(t,e);l=l||e.model.selection_policy.do_selection(c,e.model,s,o)}if(c.length>0){const e=this.source.selection_policy.hit_test(t,c);l=l||this.source.selection_policy.do_selection(e,this.source,s,o)}return l}inspect(e,t){let s=!1;if(i(e)){const o=e.hit_test(t);if(null!=o){s=!o.is_empty();const c=this.get_or_create_inspector(e.model);c.update(o,!0,"replace"),this.source.setv({inspected:c},{silent:!0}),this.source.inspect.emit([e.model,{geometry:t}])}}else if(r(e)){const o=e.model.inspection_policy.hit_test(t,e);s=e.model.inspection_policy.do_inspection(o,t,e,!1,"replace")}return s}invert(e){const t=this.source.get_length();null!=t&&(this.source.selected.invert(t),null!=e&&this.get_or_create_inspector(e.model).invert(t))}clear(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()}get_or_create_inspector(e){let t=this.inspectors.get(e);return null==t&&(t=new n.Selection,this.inspectors.set(e,t)),t}}s.SelectionManager=l,l.__name__="SelectionManager"},
function _(i,e,s,n,t){var c;n();const d=i(51),h=i(10),l=i(9),_=i(21),u=i(13);s.OpaqueIndices=(0,_.Arrayable)(_.Int),s.MultiIndices=(0,_.Mapping)(_.Int,s.OpaqueIndices);class a extends d.Model{constructor(i){super(i)}get_view(){return this.view}get selected_glyph(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null}add_to_selected_glyphs(i){this.selected_glyphs.push(i)}update(i,e=!0,s="replace"){switch(s){case"replace":this.update_through_replacement(i);break;case"append":this.update_through_union(i);break;case"intersect":this.update_through_intersection(i);break;case"subtract":this.update_through_subtraction(i);break;case"xor":this.update_through_symmetric_difference(i)}}invert(i){const e=new Set(this.indices),s=[];for(let n=0;n<i;n++)e.has(n)||s.push(n);this.indices=s}clear(){this.indices=[],this.line_indices=[],this.multiline_indices=new Map,this.image_indices=[],this.view=null,this.selected_glyphs=[]}map(i){return new c({...this.attributes,indices:(0,u.map)(this.indices,i),multiline_indices:new Map((0,u.map)([...this.multiline_indices.entries()],(([e,s])=>[i(e),s]))),image_indices:this.image_indices.map((e=>({...e,index:i(e.index)})))})}is_empty(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length}_union_image_indices(...i){const e=new Map,s=new Map,n=[];for(const t of i)for(const i of t){const{index:t,i:c,j:d}=i,h=e.get(t),l=s.get(t);null!=h&&null!=l?h.has(c)&&l.has(d)||(n.push(i),h.add(c),l.add(d)):(n.push(i),e.set(t,new Set([c])),s.set(t,new Set([d])))}return n}update_through_replacement(i){this.indices=i.indices,this.line_indices=i.line_indices,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices,this.view=i.view,this.selected_glyphs=i.selected_glyphs}update_through_union(i){this.indices=(0,h.union)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.image_indices=this._union_image_indices(this.image_indices,i.image_indices),this.view=i.view,this.multiline_indices=(0,l.merge)(i.multiline_indices,this.multiline_indices)}update_through_intersection(i){this.indices=(0,h.intersection)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.image_indices=this._union_image_indices(this.image_indices,i.image_indices),this.view=i.view,this.multiline_indices=(0,l.merge)(i.multiline_indices,this.multiline_indices)}update_through_subtraction(i){this.indices=(0,h.difference)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.image_indices=this._union_image_indices(this.image_indices,i.image_indices),this.view=i.view,this.multiline_indices=(0,l.merge)(i.multiline_indices,this.multiline_indices)}update_through_symmetric_difference(i){this.indices=(0,h.symmetric_difference)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.image_indices=this._union_image_indices(this.image_indices,i.image_indices),this.view=i.view,this.multiline_indices=(0,l.merge)(i.multiline_indices,this.multiline_indices)}}s.Selection=a,c=a,a.__name__="Selection",c.define((({Int:i,List:e,Struct:n})=>({indices:[s.OpaqueIndices,[]],line_indices:[s.OpaqueIndices,[]],multiline_indices:[s.MultiIndices,new Map],image_indices:[e(n({index:i,i,j:i,flat_index:i})),[]]}))),c.internal((({List:i,AnyRef:e,Nullable:s})=>({selected_glyphs:[i(e()),[]],view:[s(e()),null]})))},
function _(e,t,n,s,o){s();const r=e(51);class c extends r.Model{do_selection(e,t,n,s){return null!=e&&(t.selected.update(e,n,s),t._select.emit(),!t.selected.is_empty())}}n.SelectionPolicy=c,c.__name__="SelectionPolicy";class l extends c{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!=t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_intersection(t);return e}return null}}n.IntersectRenderers=l,l.__name__="IntersectRenderers";class _ extends c{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!=t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_union(t);return e}return null}}n.UnionRenderers=_,_.__name__="UnionRenderers"},
function _(e,n,c,o,t){var a;o();const r=e(51),s=e(127);class l extends r.Model{constructor(e){super(e)}}c.DataSource=l,a=l,l.__name__="DataSource",a.define((({Ref:e})=>({selected:[e(s.Selection),()=>new s.Selection,{readonly:!0}]})))},
function _(a,n,o,e,r){var t;e();const c=a(125);class u extends c.ColumnarDataSource{constructor(a){super(a)}}o.ColumnDataSource=u,t=u,u.__name__="ColumnDataSource",t.define((({Unknown:a,Dict:n,Arrayable:o})=>({data:[n(o(a)),{}]})))},
function _(n,t,e,o,r){o();const c=n(1),i=c.__importDefault(n(132)),l=c.__importDefault(n(133)),a=n(24),s=new l.default("GOOGLE"),u=new l.default("WGS84"),f=(0,i.default)(u,s);e.wgs84_mercator={compute:(n,t)=>isFinite(n)&&isFinite(t)?f.forward([n,t]):[NaN,NaN],invert:(n,t)=>isFinite(n)&&isFinite(t)?f.inverse([n,t]):[NaN,NaN]};const _={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},p={lon:[-180,180],lat:[-85.06,85.06]},{min:g,max:h}=Math;function m(n,t){const o=g(n.length,t.length),r=(0,a.infer_type)(n,t),c=new r(o),i=new r(o);return e.inplace.project_xy(n,t,c,i),[c,i]}e.clip_mercator=function(n,t,e){const[o,r]=_[e];return[h(n,o),g(t,r)]},e.in_bounds=function(n,t){const[e,o]=p[t];return e<n&&n<o},function(n){function t(n,t,o,r){const c=g(n.length,t.length);o=o??n,r=r??t;for(let i=0;i<c;i++){const c=n[i],l=t[i],[a,s]=e.wgs84_mercator.compute(c,l);o[i]=a,r[i]=s}}n.project_xy=t,n.project_xsys=function(n,e,o,r){const c=g(n.length,e.length);o=o??n,r=r??e;for(let i=0;i<c;i++)t(n[i],e[i],o[i],r[i])}}(e.inplace||(e.inplace={})),e.project_xy=m,e.project_xsys=function(n,t){const e=g(n.length,t.length),o=new Array(e),r=new Array(e);for(let c=0;c<e;c++){const[e,i]=m(n[c],t[c]);o[c]=e,r[c]=i}return[o,r]}},
function _(e,n,t,r,o){r();const a=e(1),i=a.__importDefault(e(133)),c=a.__importDefault(e(159));var u=(0,i.default)("WGS84");function f(e,n,t,r){var o,a,i;return Array.isArray(t)?(o=(0,c.default)(e,n,t,r)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof o.z?[o.x,o.y,o.z].concat(t.splice(3)):[o.x,o.y,t[2]].concat(t.splice(3)):[o.x,o.y].concat(t.splice(2)):[o.x,o.y]):(a=(0,c.default)(e,n,t,r),2===(i=Object.keys(t)).length||i.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;a[r]=t[r]})),a)}function l(e){return e instanceof i.default?e:e.oProj?e.oProj:(0,i.default)(e)}t.default=function(e,n,t){e=l(e);var r,o=!1;return void 0===n?(n=e,e=u,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=u,o=!0),n=l(n),t?f(e,n,t):(r={forward:function(t,r){return f(e,n,t,r)},inverse:function(t,r){return f(n,e,t,r)}},o&&(r.oProj=n),r)}},
function _(t,e,a,s,i){s();const l=t(1),u=l.__importDefault(t(134)),r=l.__importDefault(t(145)),d=l.__importDefault(t(146)),o=t(154),f=l.__importDefault(t(156)),p=l.__importDefault(t(157)),m=l.__importDefault(t(141)),n=t(158);function h(t,e){if(!(this instanceof h))return new h(t);e=e||function(t){if(t)throw t};var a=(0,u.default)(t);if("object"==typeof a){var s=h.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var i=(0,m.default)(f.default,a.datumCode);i&&(a.datum_params=a.datum_params||(i.towgs84?i.towgs84.split(","):null),a.ellps=i.ellipse,a.datumName=i.datumName?i.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84",a.lat1=a.lat1||a.lat0;var l=(0,o.sphere)(a.a,a.b,a.rf,a.ellps,a.sphere),d=(0,o.eccentricity)(l.a,l.b,l.rf,a.R_A),_=(0,n.getNadgrids)(a.nadgrids),c=a.datum||(0,p.default)(a.datumCode,a.datum_params,l.a,l.b,d.es,d.ep2,_);(0,r.default)(this,a),(0,r.default)(this,s),this.a=l.a,this.b=l.b,this.rf=l.rf,this.sphere=l.sphere,this.es=d.es,this.e=d.e,this.ep2=d.ep2,this.datum=c,this.init(),e(null,this)}else e(t)}else e(t)}h.projections=d.default,h.projections.start(),a.default=h},
function _(t,r,n,u,e){u();const f=t(1),i=f.__importDefault(t(135)),a=f.__importDefault(t(142)),o=f.__importDefault(t(137)),l=f.__importDefault(t(141));var C=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var d=["3857","900913","3785","102113"];n.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in i.default}(t))return i.default[t];if(function(t){return C.some((function(r){return t.indexOf(r)>-1}))}(t)){var r=(0,a.default)(t);if(function(t){var r=(0,l.default)(t,"authority");if(r){var n=(0,l.default)(r,"epsg");return n&&d.indexOf(n)>-1}}(r))return i.default["EPSG:3857"];var n=function(t){var r=(0,l.default)(t,"extension");if(r)return(0,l.default)(r,"proj4")}(r);return n?(0,o.default)(n):r}return function(t){return"+"===t[0]}(t)?(0,o.default)(t):void 0}},
function _(t,r,i,e,n){e();const f=t(1),a=f.__importDefault(t(136)),l=f.__importDefault(t(137)),u=f.__importDefault(t(142));function o(t){var r=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?o[t]=(0,l.default)(arguments[1]):o[t]=(0,u.default)(arguments[1]):o[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?o.apply(r,t):o(t)}));if("string"==typeof t){if(t in o)return o[t]}else"EPSG"in t?o["EPSG:"+t.EPSG]=t:"ESRI"in t?o["ESRI:"+t.ESRI]=t:"IAU2000"in t?o["IAU2000:"+t.IAU2000]=t:console.log(t);return}}(0,a.default)(o),i.default=o},
function _(t,l,G,S,e){S(),G.default=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},
function _(t,n,o,a,u){a();const e=t(1),r=t(138),i=e.__importDefault(t(139)),f=e.__importDefault(t(140)),l=e.__importDefault(t(141));o.default=function(t){var n,o,a,u={},e=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){u.rf=parseFloat(t)},lat_0:function(t){u.lat0=t*r.D2R},lat_1:function(t){u.lat1=t*r.D2R},lat_2:function(t){u.lat2=t*r.D2R},lat_ts:function(t){u.lat_ts=t*r.D2R},lon_0:function(t){u.long0=t*r.D2R},lon_1:function(t){u.long1=t*r.D2R},lon_2:function(t){u.long2=t*r.D2R},alpha:function(t){u.alpha=parseFloat(t)*r.D2R},gamma:function(t){u.rectified_grid_angle=parseFloat(t)},lonc:function(t){u.longc=t*r.D2R},x_0:function(t){u.x0=parseFloat(t)},y_0:function(t){u.y0=parseFloat(t)},k_0:function(t){u.k0=parseFloat(t)},k:function(t){u.k0=parseFloat(t)},a:function(t){u.a=parseFloat(t)},b:function(t){u.b=parseFloat(t)},r_a:function(){u.R_A=!0},zone:function(t){u.zone=parseInt(t,10)},south:function(){u.utmSouth=!0},towgs84:function(t){u.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){u.to_meter=parseFloat(t)},units:function(t){u.units=t;var n=(0,l.default)(f.default,t);n&&(u.to_meter=n.to_meter)},from_greenwich:function(t){u.from_greenwich=t*r.D2R},pm:function(t){var n=(0,l.default)(i.default,t);u.from_greenwich=(n||parseFloat(t))*r.D2R},nadgrids:function(t){"@null"===t?u.datumCode="none":u.nadgrids=t},axis:function(t){var n="ewnsud";3===t.length&&-1!==n.indexOf(t.substr(0,1))&&-1!==n.indexOf(t.substr(1,1))&&-1!==n.indexOf(t.substr(2,1))&&(u.axis=t)},approx:function(){u.approx=!0}};for(n in e)o=e[n],n in c?"function"==typeof(a=c[n])?a(o):u[a]=o:u[n]=o;return"string"==typeof u.datumCode&&"WGS84"!==u.datumCode&&(u.datumCode=u.datumCode.toLowerCase()),u}},
function _(S,_,P,R,I){R(),P.PJD_3PARAM=1,P.PJD_7PARAM=2,P.PJD_GRIDSHIFT=3,P.PJD_WGS84=4,P.PJD_NODATUM=5,P.SRS_WGS84_SEMIMAJOR=6378137,P.SRS_WGS84_SEMIMINOR=6356752.314,P.SRS_WGS84_ESQUARED=.0066943799901413165,P.SEC_TO_RAD=484813681109536e-20,P.HALF_PI=Math.PI/2,P.SIXTH=.16666666666666666,P.RA4=.04722222222222222,P.RA6=.022156084656084655,P.EPSLN=1e-10,P.D2R=.017453292519943295,P.R2D=57.29577951308232,P.FORTPI=Math.PI/4,P.TWO_PI=2*Math.PI,P.SPI=3.14159265359},
function _(o,r,a,e,s){e();var n={};a.default=n,n.greenwich=0,n.lisbon=-9.131906111111,n.paris=2.337229166667,n.bogota=-74.080916666667,n.madrid=-3.687938888889,n.rome=12.452333333333,n.bern=7.439583333333,n.jakarta=106.807719444444,n.ferro=-17.666666666667,n.brussels=4.367975,n.stockholm=18.058277777778,n.athens=23.7163375,n.oslo=10.722916666667},
function _(t,e,f,o,u){o(),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t,a,n){a();var o=/[\s_\-\/\(\)]/g;t.default=function(e,r){if(e[r])return e[r];for(var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]}},
function _(e,a,t,o,n){o();const r=e(1);var l=.017453292519943295;const d=r.__importDefault(e(143)),i=e(144);function _(e){return e*l}t.default=function(e){var a=(0,d.default)(e),t=a.shift(),o=a.shift();a.unshift(["name",o]),a.unshift(["type",t]);var n={};return(0,i.sExpr)(a,n),function(e){if("GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.AXIS){for(var a="",t=0,o=e.AXIS.length;t<o;++t){var n=[e.AXIS[t][0].toLowerCase(),e.AXIS[t][1].toLowerCase()];-1!==n[0].indexOf("north")||("y"===n[0]||"lat"===n[0])&&"north"===n[1]?a+="n":-1!==n[0].indexOf("south")||("y"===n[0]||"lat"===n[0])&&"south"===n[1]?a+="s":-1!==n[0].indexOf("east")||("x"===n[0]||"lon"===n[0])&&"east"===n[1]?a+="e":-1===n[0].indexOf("west")&&("x"!==n[0]&&"lon"!==n[0]||"west"!==n[1])||(a+="w")}2===a.length&&(a+="u"),3===a.length&&(e.axis=a)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;function l(a){return a*(e.to_meter||1)}"GEOGCS"===e.type&&(r=e),r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_1","Latitude of 1st standard parallel"],["standard_parallel_2","Standard_Parallel_2"],["standard_parallel_2","Latitude of 2nd standard parallel"],["false_easting","False_Easting"],["false_easting","False easting"],["false-easting","Easting at false origin"],["false_northing","False_Northing"],["false_northing","False northing"],["false_northing","Northing at false origin"],["central_meridian","Central_Meridian"],["central_meridian","Longitude of natural origin"],["central_meridian","Longitude of false origin"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["latitude_of_origin","Latitude of natural origin"],["latitude_of_origin","Latitude of false origin"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",_],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",_],["x0","false_easting",l],["y0","false_northing",l],["long0","central_meridian",_],["lat0","latitude_of_origin",_],["lat0","standard_parallel_1",_],["lat1","standard_parallel_1",_],["lat2","standard_parallel_2",_],["azimuth","Azimuth"],["alpha","azimuth",_],["srsCode","name"]].forEach((function(a){return t=e,n=(o=a)[0],r=o[1],void(!(n in t)&&r in t&&(t[n]=t[r],3===o.length&&(t[n]=o[2](t[n]))));var t,o,n,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName?!e.lat_ts&&e.lat0&&"Polar_Stereographic"===e.projName&&(e.lat_ts=e.lat0,e.lat0=_(e.lat0>0?90:-90)):(e.lat0=_(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(n),n}},
function _(t,e,r,i,s){i(),r.default=function(t){return new c(t).output()};var h=1,o=/\s/,n=/[A-Za-z]/,a=/[A-Za-z84_]/,u=/[,\]]/,d=/[\d\.E\-\+]/;function c(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=h}c.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;o.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case h:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},c.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(u.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},c.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=h)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=h,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},c.prototype.number=function(t){if(!d.test(t)){if(u.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},c.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},c.prototype.keyword=function(t){if(a.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=h)}if(!u.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},c.prototype.neutral=function(t){if(n.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(d.test(t))return this.word=t,void(this.state=3);if(!u.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},c.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,a,r,s,c){function n(e,a,r){Array.isArray(a)&&(r.unshift(a),a=null);var s=a?{}:e,c=r.reduce((function(e,a){return E(a,e),e}),s);a&&(e[a]=c)}function E(e,a){if(Array.isArray(e)){var r=e.shift();if("PARAMETER"===r&&(r=e.shift()),1===e.length)return Array.isArray(e[0])?(a[r]={},void E(e[0],a[r])):void(a[r]=e[0]);if(e.length)if("TOWGS84"!==r){if("AXIS"===r)return r in a||(a[r]=[]),void a[r].push(e);var s;switch(Array.isArray(r)||(a[r]={}),r){case"UNIT":case"PRIMEM":case"VERT_DATUM":return a[r]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&E(e[2],a[r]));case"SPHEROID":case"ELLIPSOID":return a[r]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&E(e[3],a[r]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void n(a,r,e);default:for(s=-1;++s<e.length;)if(!Array.isArray(e[s]))return E(e,a[r]);return n(a,r,e)}}else a[r]=e;else a[r]=!0}else a[e]=!0}s(),r.sExpr=E},
function _(n,r,f,i,t){i(),f.default=function(n,r){var f,i;if(n=n||{},!r)return n;for(i in r)void 0!==(f=r[i])&&(n[i]=f);return n}},
function _(t,o,a,e,n){e();const r=t(1),f=r.__importDefault(t(147)),u=r.__importDefault(t(153));var i=[f.default,u.default],c={},d=[];function s(t,o){var a=d.length;return t.names?(d[a]=t,t.names.forEach((function(t){c[t.toLowerCase()]=a})),this):(console.log(o),!0)}function l(t){if(!t)return!1;var o=t.toLowerCase();return void 0!==c[o]&&d[c[o]]?d[c[o]]:void 0}function v(){i.forEach(s)}a.add=s,a.get=l,a.start=v,a.default={start:v,add:s,get:l}},
function _(t,i,s,h,a){h();const e=t(1),r=e.__importDefault(t(148)),n=e.__importDefault(t(149)),l=e.__importDefault(t(151)),u=e.__importDefault(t(152)),o=t(138);function f(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=(0,r.default)(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function _(t){var i,s,h=t.x,a=t.y;if(a*o.R2D>90&&a*o.R2D<-90&&h*o.R2D>180&&h*o.R2D<-180)return null;if(Math.abs(Math.abs(a)-o.HALF_PI)<=o.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*(0,n.default)(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(o.FORTPI+.5*a));else{var e=Math.sin(a),r=(0,l.default)(this.e,a,e);i=this.x0+this.a*this.k0*(0,n.default)(h-this.long0),s=this.y0-this.a*this.k0*Math.log(r)}return t.x=i,t.y=s,t}function M(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=o.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var e=Math.exp(-a/(this.a*this.k0));if(-9999===(s=(0,u.default)(this.e,e)))return null}return i=(0,n.default)(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.init=f,s.forward=_,s.inverse=M,s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:f,forward:_,inverse:M,names:s.names}},
function _(t,n,r,u,a){u(),r.default=function(t,n,r){var u=t*n;return r/Math.sqrt(1-u*u)}},
function _(t,n,u,a,f){a();const e=t(1),o=t(138),_=e.__importDefault(t(150));u.default=function(t){return Math.abs(t)<=o.SPI?t:t-(0,_.default)(t)*o.TWO_PI}},
function _(n,t,u,f,c){f(),u.default=function(n){return n<0?-1:1}},
function _(t,n,a,o,u){o();const c=t(138);a.default=function(t,n,a){var o=t*a,u=.5*t;return o=Math.pow((1-o)/(1+o),u),Math.tan(.5*(c.HALF_PI-n))/o}},
function _(t,a,n,r,f){r();const h=t(138);n.default=function(t,a){for(var n,r,f=.5*t,o=h.HALF_PI-2*Math.atan(a),u=0;u<=15;u++)if(n=t*Math.sin(o),o+=r=h.HALF_PI-2*Math.atan(a*Math.pow((1-n)/(1+n),f))-o,Math.abs(r)<=1e-10)return o;return-9999}},
function _(n,i,e,t,r){function a(){}function f(n){return n}t(),e.init=a,e.forward=f,e.inverse=f,e.names=["longlat","identity"],e.default={init:a,forward:f,inverse:f,names:e.names}},
function _(t,r,e,a,n){a();const f=t(1),i=t(138),u=f.__importStar(t(155)),c=f.__importDefault(t(141));e.eccentricity=function(t,r,e,a){var n=t*t,f=r*r,u=(n-f)/n,c=0;return a?(n=(t*=1-u*(i.SIXTH+u*(i.RA4+u*i.RA6)))*t,u=0):c=Math.sqrt(u),{es:u,e:c,ep2:(n-f)/f}},e.sphere=function(t,r,e,a,n){if(!t){var f=(0,c.default)(u.default,a);f||(f=u.WGS84),t=f.a,r=f.b,e=f.rf}return e&&!r&&(r=(1-1/e)*t),(0===e||Math.abs(t-r)<i.EPSLN)&&(n=!0,r=t),{a:t,b:r,rf:e,sphere:n}}},
function _(e,a,l,s,r){s();var i={};l.default=i,i.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},i.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},i.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},i.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},i.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},i.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},i.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},i.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},i.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},i.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},i.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},i.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},i.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},i.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},i.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},i.clrk80ign={a:6378249.2,b:6356515,rf:293.4660213,ellipseName:"Clarke 1880 (IGN)"},i.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},i.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},i.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},i.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},i.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},i.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},i.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},i.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},i.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},i.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},i.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},i.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},i.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},i.hough={a:6378270,rf:297,ellipseName:"Hough"},i.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},i.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},i.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},i.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},i.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},i.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},i.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},i.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},i.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},i.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},i.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},i.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=i.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},i.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s,t,l){t();var i={};s.default=i,i.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},i.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},i.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},i.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},i.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},i.potsdam={towgs84:"598.1,73.7,418.2,0.202,0.045,-2.455,6.7",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},i.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},i.hermannskogel={towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Hermannskogel"},i.militargeographische_institut={towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Militar-Geographische Institut"},i.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},i.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},i.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},i.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},i.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},i.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},i.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},i.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},i.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_,t,u){t();const d=a(138);_.default=function(a,m,_,t,u,p,r){var s={};return s.datum_type=void 0===a||"none"===a?d.PJD_NODATUM:d.PJD_WGS84,m&&(s.datum_params=m.map(parseFloat),0===s.datum_params[0]&&0===s.datum_params[1]&&0===s.datum_params[2]||(s.datum_type=d.PJD_3PARAM),s.datum_params.length>3&&(0===s.datum_params[3]&&0===s.datum_params[4]&&0===s.datum_params[5]&&0===s.datum_params[6]||(s.datum_type=d.PJD_7PARAM,s.datum_params[3]*=d.SEC_TO_RAD,s.datum_params[4]*=d.SEC_TO_RAD,s.datum_params[5]*=d.SEC_TO_RAD,s.datum_params[6]=s.datum_params[6]/1e6+1))),r&&(s.datum_type=d.PJD_GRIDSHIFT,s.grids=r),s.a=_,s.b=t,s.es=u,s.ep2=p,s}},
function _(t,e,n,r,i){r();var u={};function o(t){if(0===t.length)return null;var e="@"===t[0];return e&&(t=t.slice(1)),"null"===t?{name:"null",mandatory:!e,grid:null,isNull:!0}:{name:t,mandatory:!e,grid:u[t]||null,isNull:!1}}function l(t){return t/3600*Math.PI/180}function a(t,e,n){return String.fromCharCode.apply(null,new Uint8Array(t.buffer.slice(e,n)))}function d(t){return t.map((function(t){return[l(t.longitudeShift),l(t.latitudeShift)]}))}function g(t,e,n){return{name:a(t,e+8,e+16).trim(),parent:a(t,e+24,e+24+8).trim(),lowerLatitude:t.getFloat64(e+72,n),upperLatitude:t.getFloat64(e+88,n),lowerLongitude:t.getFloat64(e+104,n),upperLongitude:t.getFloat64(e+120,n),latitudeInterval:t.getFloat64(e+136,n),longitudeInterval:t.getFloat64(e+152,n),gridNodeCount:t.getInt32(e+168,n)}}function f(t,e,n,r){for(var i=e+176,u=[],o=0;o<n.gridNodeCount;o++){var l={latitudeShift:t.getFloat32(i+16*o,r),longitudeShift:t.getFloat32(i+16*o+4,r),latitudeAccuracy:t.getFloat32(i+16*o+8,r),longitudeAccuracy:t.getFloat32(i+16*o+12,r)};u.push(l)}return u}n.default=function(t,e){var n=new DataView(e),r=function(t){var e=t.getInt32(8,!1);if(11===e)return!1;e=t.getInt32(8,!0),11!==e&&console.warn("Failed to detect nadgrid endian-ness, defaulting to little-endian");return!0}(n),i=function(t,e){return{nFields:t.getInt32(8,e),nSubgridFields:t.getInt32(24,e),nSubgrids:t.getInt32(40,e),shiftType:a(t,56,64).trim(),fromSemiMajorAxis:t.getFloat64(120,e),fromSemiMinorAxis:t.getFloat64(136,e),toSemiMajorAxis:t.getFloat64(152,e),toSemiMinorAxis:t.getFloat64(168,e)}}(n,r),o=function(t,e,n){for(var r=176,i=[],u=0;u<e.nSubgrids;u++){var o=g(t,r,n),a=f(t,r,o,n),c=Math.round(1+(o.upperLongitude-o.lowerLongitude)/o.longitudeInterval),s=Math.round(1+(o.upperLatitude-o.lowerLatitude)/o.latitudeInterval);i.push({ll:[l(o.lowerLongitude),l(o.lowerLatitude)],del:[l(o.longitudeInterval),l(o.latitudeInterval)],lim:[c,s],count:o.gridNodeCount,cvs:d(a)}),r+=176+16*o.gridNodeCount}return i}(n,i,r),c={header:i,subgrids:o};return u[t]=c,c},n.getNadgrids=function(t){return void 0===t?null:t.split(",").map(o)}},
function _(t,e,a,u,m){u();const r=t(1),_=t(138),d=r.__importDefault(t(160)),o=r.__importDefault(t(162)),f=r.__importDefault(t(133)),i=r.__importDefault(t(163)),n=r.__importDefault(t(164));a.default=function t(e,a,u,m){var r,y=void 0!==(u=Array.isArray(u)?(0,i.default)(u):{x:u.x,y:u.y,z:u.z,m:u.m}).z;if((0,n.default)(u),e.datum&&a.datum&&function(t,e){return(t.datum.datum_type===_.PJD_3PARAM||t.datum.datum_type===_.PJD_7PARAM||t.datum.datum_type===_.PJD_GRIDSHIFT)&&"WGS84"!==e.datumCode||(e.datum.datum_type===_.PJD_3PARAM||e.datum.datum_type===_.PJD_7PARAM||e.datum.datum_type===_.PJD_GRIDSHIFT)&&"WGS84"!==t.datumCode}(e,a)&&(u=t(e,r=new f.default("WGS84"),u,m),e=r),m&&"enu"!==e.axis&&(u=(0,o.default)(e,!1,u)),"longlat"===e.projName)u={x:u.x*_.D2R,y:u.y*_.D2R,z:u.z||0};else if(e.to_meter&&(u={x:u.x*e.to_meter,y:u.y*e.to_meter,z:u.z||0}),!(u=e.inverse(u)))return;if(e.from_greenwich&&(u.x+=e.from_greenwich),u=(0,d.default)(e.datum,a.datum,u))return a.from_greenwich&&(u={x:u.x-a.from_greenwich,y:u.y,z:u.z||0}),"longlat"===a.projName?u={x:u.x*_.R2D,y:u.y*_.R2D,z:u.z||0}:(u=a.forward(u),a.to_meter&&(u={x:u.x/a.to_meter,y:u.y/a.to_meter,z:u.z||0})),m&&"enu"!==a.axis?(0,o.default)(a,!0,u):(u&&!y&&delete u.z,u)}},
function _(r,e,t,a,i){a();const l=r(1),n=r(138),o=r(161),u=l.__importDefault(r(149));function d(r){return r===n.PJD_3PARAM||r===n.PJD_7PARAM}function s(r,e,t){if(null===r.grids||0===r.grids.length)return console.log("Grid shift grids not found"),-1;var a={x:-t.x,y:t.y},i={x:Number.NaN,y:Number.NaN},l=[];r:for(var o=0;o<r.grids.length;o++){var u=r.grids[o];if(l.push(u.name),u.isNull){i=a;break}if(u.mandatory,null!==u.grid)for(var d=u.grid.subgrids,s=0,f=d.length;s<f;s++){var x=d[s],m=(Math.abs(x.del[1])+Math.abs(x.del[0]))/1e4,N=x.ll[0]-m,c=x.ll[1]-m,_=x.ll[0]+(x.lim[0]-1)*x.del[0]+m,g=x.ll[1]+(x.lim[1]-1)*x.del[1]+m;if(!(c>a.y||N>a.x||g<a.y||_<a.x)&&(i=y(a,e,x),!isNaN(i.x)))break r}else if(u.mandatory)return console.log("Unable to find mandatory grid '"+u.name+"'"),-1}return isNaN(i.x)?(console.log("Failed to find a grid shift table for location '"+-a.x*n.R2D+" "+a.y*n.R2D+" tried: '"+l+"'"),-1):(t.x=-i.x,t.y=i.y,0)}function y(r,e,t){var a={x:Number.NaN,y:Number.NaN};if(isNaN(r.x))return a;var i={x:r.x,y:r.y};i.x-=t.ll[0],i.y-=t.ll[1],i.x=(0,u.default)(i.x-Math.PI)+Math.PI;var l=f(i,t);if(e){if(isNaN(l.x))return a;l.x=i.x-l.x,l.y=i.y-l.y;var n,o,d=9;do{if(o=f(l,t),isNaN(o.x)){console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");break}n={x:i.x-(o.x+l.x),y:i.y-(o.y+l.y)},l.x+=n.x,l.y+=n.y}while(d--&&Math.abs(n.x)>1e-12&&Math.abs(n.y)>1e-12);if(d<0)return console.log("Inverse grid shift iterator failed to converge."),a;a.x=(0,u.default)(l.x+t.ll[0]),a.y=l.y+t.ll[1]}else isNaN(l.x)||(a.x=r.x+l.x,a.y=r.y+l.y);return a}function f(r,e){var t,a={x:r.x/e.del[0],y:r.y/e.del[1]},i=Math.floor(a.x),l=Math.floor(a.y),n=a.x-1*i,o=a.y-1*l,u={x:Number.NaN,y:Number.NaN};if(i<0||i>=e.lim[0])return u;if(l<0||l>=e.lim[1])return u;t=l*e.lim[0]+i;var d=e.cvs[t][0],s=e.cvs[t][1];t++;var y=e.cvs[t][0],f=e.cvs[t][1];t+=e.lim[0];var x=e.cvs[t][0],m=e.cvs[t][1];t--;var N=e.cvs[t][0],c=e.cvs[t][1],_=n*o,g=n*(1-o),v=(1-n)*(1-o),S=(1-n)*o;return u.x=v*d+g*y+S*N+_*x,u.y=v*s+g*f+S*c+_*m,u}t.default=function(r,e,t){if((0,o.compareDatums)(r,e))return t;if(r.datum_type===n.PJD_NODATUM||e.datum_type===n.PJD_NODATUM)return t;var a=r.a,i=r.es;if(r.datum_type===n.PJD_GRIDSHIFT){if(0!==s(r,!1,t))return;a=n.SRS_WGS84_SEMIMAJOR,i=n.SRS_WGS84_ESQUARED}var l=e.a,u=e.b,y=e.es;if(e.datum_type===n.PJD_GRIDSHIFT&&(l=n.SRS_WGS84_SEMIMAJOR,u=n.SRS_WGS84_SEMIMINOR,y=n.SRS_WGS84_ESQUARED),i===y&&a===l&&!d(r.datum_type)&&!d(e.datum_type))return t;if(t=(0,o.geodeticToGeocentric)(t,i,a),d(r.datum_type)&&(t=(0,o.geocentricToWgs84)(t,r.datum_type,r.datum_params)),d(e.datum_type)&&(t=(0,o.geocentricFromWgs84)(t,e.datum_type,e.datum_params)),t=(0,o.geocentricToGeodetic)(t,y,l,u),e.datum_type===n.PJD_GRIDSHIFT&&0!==s(e,!0,t))return;return t},t.applyGridShift=s},
function _(a,t,r,m,s){m();const u=a(138);r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===u.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==u.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,s,_,e,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-u.HALF_PI&&d>-1.001*u.HALF_PI)d=-u.HALF_PI;else if(d>u.HALF_PI&&d<1.001*u.HALF_PI)d=u.HALF_PI;else{if(d<-u.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>u.HALF_PI)return{x:1/0,y:1/0,z:a.z}}return n>Math.PI&&(n-=2*Math.PI),s=Math.sin(d),e=Math.cos(d),_=s*s,{x:((m=r/Math.sqrt(1-t*_))+i)*e*Math.cos(n),y:(m+i)*e*Math.sin(n),z:(m*(1-t)+i)*s}},r.geocentricToGeodetic=function(a,t,r,m){var s,_,e,n,d,i,p,P,y,z,M,o,A,c,x,h=1e-12,f=a.x,I=a.y,F=a.z?a.z:0;if(s=Math.sqrt(f*f+I*I),_=Math.sqrt(f*f+I*I+F*F),s/r<h){if(c=0,_/r<h)return u.HALF_PI,x=-m,{x:a.x,y:a.y,z:a.z}}else c=Math.atan2(I,f);e=F/_,P=(n=s/_)*(1-t)*(d=1/Math.sqrt(1-t*(2-t)*n*n)),y=e*d,A=0;do{A++,i=t*(p=r/Math.sqrt(1-t*y*y))/(p+(x=s*P+F*y-p*(1-t*y*y))),o=(M=e*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(z=n*(1-i)*d)*y,P=z,y=M}while(o*o>1e-24&&A<30);return{x:c,y:Math.atan(M/Math.abs(z)),z:x}},r.geocentricToWgs84=function(a,t,r){if(t===u.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===u.PJD_7PARAM){var m=r[0],s=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-e*a.z)+s,z:i*(-n*a.x+e*a.y+a.z)+_}}},r.geocentricFromWgs84=function(a,t,r){if(t===u.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===u.PJD_7PARAM){var m=r[0],s=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-s)/i,y=(a.z-_)/i;return{x:p+d*P-n*y,y:-d*p+P+e*y,z:n*p-e*P+y}}}},
function _(e,a,i,s,n){s(),i.default=function(e,a,i){var s,n,r,c=i.x,d=i.y,f=i.z||0,u={};for(r=0;r<3;r++)if(!a||2!==r||void 0!==i.z)switch(0===r?(s=c,n=-1!=="ew".indexOf(e.axis[r])?"x":"y"):1===r?(s=d,n=-1!=="ns".indexOf(e.axis[r])?"y":"x"):(s=f,n="z"),e.axis[r]){case"e":case"n":u[n]=s;break;case"w":case"s":u[n]=-s;break;case"u":void 0!==i[n]&&(u.z=s);break;case"d":void 0!==i[n]&&(u.z=-s);break;default:return null}return u}},
function _(n,t,e,u,f){u(),e.default=function(n){var t={x:n[0],y:n[1]};return n.length>2&&(t.z=n[2]),n.length>3&&(t.m=n[3]),t}},
function _(e,i,n,t,r){function o(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}t(),n.default=function(e){o(e.x),o(e.y)}},
function _(e,i,s,o,n){var l,t,a,r,_;o();const c=e(1),d=e(166),p=e(85),T=c.__importStar(e(18));class m extends d.MarkingView{}s.ArrowHeadView=m,m.__name__="ArrowHeadView";class v extends d.Marking{constructor(e){super(e)}}s.ArrowHead=v,l=v,v.__name__="ArrowHead",l.define((()=>({size:[T.NumberSpec,25]})));class u extends m{clip(e,i){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(0,0),e.lineTo(.5*s,s)}render(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),this.visuals.line.apply(e,i)}}s.OpenHeadView=u,u.__name__="OpenHeadView";class h extends v{constructor(e){super(e)}}s.OpenHead=h,t=h,h.__name__="OpenHead",t.prototype.default_view=u,t.mixins(p.LineVector);class V extends m{clip(e,i){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(.5*s,s)}render(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),e.closePath(),this.visuals.fill.apply(e,i),this.visuals.line.apply(e,i)}}s.NormalHeadView=V,V.__name__="NormalHeadView";class H extends v{constructor(e){super(e)}}s.NormalHead=H,a=H,H.__name__="NormalHead",a.prototype.default_view=V,a.mixins([p.LineVector,p.FillVector]),a.override({fill_color:"black"});class w extends m{clip(e,i){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(0,.5*s),e.lineTo(.5*s,s)}render(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),e.lineTo(0,.5*s),e.closePath(),this.visuals.fill.apply(e,i),this.visuals.line.apply(e,i)}}s.VeeHeadView=w,w.__name__="VeeHeadView";class x extends v{constructor(e){super(e)}}s.VeeHead=x,r=x,x.__name__="VeeHead",r.prototype.default_view=w,r.mixins([p.LineVector,p.FillVector]),r.override({fill_color:"black"});class g extends m{render(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,0),e.lineTo(-.5*s,0),this.visuals.line.apply(e,i)}clip(e,i){}}s.TeeHeadView=g,g.__name__="TeeHeadView";class z extends v{constructor(e){super(e)}}s.TeeHead=z,_=z,z.__name__="TeeHead",_.prototype.default_view=g,_.mixins(p.LineVector)},
function _(e,t,n,i,s){var a;i();const r=e(1),c=e(51),o=e(58),_=r.__importStar(e(82)),u=r.__importStar(e(18));class l extends o.View{initialize(){super.initialize(),this.visuals=new _.Visuals(this)}request_render(){this.parent.request_render()}get canvas(){return this.parent.canvas}set_data(e,t){const n=this;for(const i of this.model){if(!(i instanceof u.VectorSpec||i instanceof u.ScalarSpec))continue;const s=i.uniform(e).select(t);n[`${i.attr}`]=s}}}n.MarkingView=l,l.__name__="MarkingView";class d extends c.Model{constructor(e){super(e)}}n.Marking=d,a=d,d.__name__="Marking",a.define((({})=>({})))},
function _(t,e,i,r,o){var a;r();const n=t(1),_=t(79),s=t(168),l=t(185),h=t(186),c=t(191),u=t(188),d=t(197),p=t(189),m=t(238),f=t(190),g=t(250),w=t(252),b=t(173),y=t(20),x=n.__importStar(t(85)),v=t(253),k=t(254),z=t(256),j=t(170),B=t(56),S=t(64),L=t(8);class T extends _.AnnotationView{get orientation(){return this._orientation}*children(){yield*super.children(),yield this._axis_view,yield this._title_view}initialize(){super.initialize();const{ticker:t,formatter:e}=this.model;this._ticker="auto"!=t?t:this._create_ticker(),this._formatter="auto"!=e?e:this._create_formatter(),this._major_range=this._create_major_range(),this._major_scale=this._create_major_scale(),this._minor_range=new w.Range1d({start:0,end:1}),this._minor_scale=new g.LinearScale,this._frame=new l.CartesianFrame(this._major_scale,this._minor_scale,this._major_range,this._minor_range),this._axis=this._create_axis(),this._apply_axis_properties(),this._title=new s.Title,this._apply_title_properties()}async lazy_initialize(){await super.lazy_initialize();const t=this,e={get parent(){return t.parent},get root(){return t.root},get frame(){return t._frame},get canvas_view(){return t.parent.canvas_view},request_layout(){t.layout.dirty=!0,t.parent.request_layout()},request_paint(){t.parent.request_paint(t)},request_render(){t.request_paint()},notify_finished_after_paint(){t.parent.notify_finished_after_paint()}};this._axis_view=await(0,B.build_view)(this._axis,{parent:e}),this._title_view=await(0,B.build_view)(this._title,{parent:e})}remove(){this._title_view.remove(),this._axis_view.remove(),super.remove()}_apply_axis_properties(){const t={ticker:this._ticker,formatter:this._formatter,major_label_standoff:this.model.label_standoff,axis_line_color:null,major_tick_in:this.model.major_tick_in,major_tick_out:this.model.major_tick_out,minor_tick_in:this.model.minor_tick_in,minor_tick_out:this.model.minor_tick_out,major_label_overrides:this.model.major_label_overrides,major_label_policy:this.model.major_label_policy,...x.attrs_of(this.model,"major_label_",x.Text,!0),...x.attrs_of(this.model,"major_tick_",x.Line,!0),...x.attrs_of(this.model,"minor_tick_",x.Line,!0)};this._axis.setv(t)}_apply_title_properties(){const t={text:this.model.title??"",standoff:this.model.title_standoff,...x.attrs_of(this.model,"title_",x.Text,!1)};this._title.setv(t)}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>{this._apply_title_properties(),this._apply_axis_properties()})),this.connect(this._ticker.change,(()=>this.request_render())),this.connect(this._formatter.change,(()=>this.request_render()))}_update_frame(){const[t,e,i,r]=(()=>"horizontal"==this.orientation?[this._major_scale,this._minor_scale,this._major_range,this._minor_range]:[this._minor_scale,this._major_scale,this._minor_range,this._major_range])();this._frame.in_x_scale=t,this._frame.in_y_scale=e,this._frame.x_range=i,this._frame.y_range=r,this._frame.configure_scales()}update_layout(){const{location:t,width:e,height:i,padding:r,margin:o}=this.model,[a,n]=(()=>{if(!(0,L.isString)(t))return["end","start"];switch(t){case"top_left":return["start","start"];case"top":case"top_center":return["start","center"];case"top_right":return["start","end"];case"bottom_left":return["end","start"];case"bottom":case"bottom_center":return["end","center"];case"bottom_right":return["end","end"];case"left":case"center_left":return["center","start"];case"center":case"center_center":return["center","center"];case"right":case"center_right":return["center","end"]}})(),_=this._orientation=(()=>{const{orientation:t}=this.model;return"auto"==t?null!=this.panel?this.panel.is_horizontal?"horizontal":"vertical":"start"==n||"end"==n||"center"==a?"vertical":"horizontal":t})();this._update_frame();const s=new k.NodeLayout,l=new k.VStack,h=new k.VStack,c=new k.HStack,u=new k.HStack;s.absolute=!0,l.absolute=!0,h.absolute=!0,c.absolute=!0,u.absolute=!0,s.on_resize((t=>this._frame.set_geometry(t)));const d=new z.BorderLayout;this._inner_layout=d,d.absolute=!0,d.center_panel=s,d.top_panel=l,d.bottom_panel=h,d.left_panel=c,d.right_panel=u;const p={left:r,right:r,top:r,bottom:r},m=(()=>{if(null==this.panel){if((0,L.isString)(t))return{left:o,right:o,top:o,bottom:o};{const[e,i]=t;return{left:e,right:o,top:o,bottom:i}}}if(!(0,L.isString)(t)){const[e,i]=t;return d.fixup_geometry=(t,r)=>{const o=t,a=this.layout.bbox,{width:n,height:_}=t;if(t=new S.BBox({left:a.left+e,bottom:a.bottom-i,width:n,height:_}),null!=r){const e=t.left-o.left,i=t.top-o.top,{left:a,top:n,width:_,height:s}=r;r=new S.BBox({left:a+e,top:n+i,width:_,height:s})}return[t,r]},{left:e,right:0,top:0,bottom:i}}d.fixup_geometry=(t,e)=>{const i=t;if("horizontal"==_){const{top:e,width:i,height:r}=t;if("end"==n){const{right:o}=this.layout.bbox;t=new S.BBox({right:o,top:e,width:i,height:r})}else if("center"==n){const{hcenter:o}=this.layout.bbox;t=new S.BBox({hcenter:Math.round(o),top:e,width:i,height:r})}}else{const{left:e,width:i,height:r}=t;if("end"==a){const{bottom:o}=this.layout.bbox;t=new S.BBox({left:e,bottom:o,width:i,height:r})}else if("center"==a){const{vcenter:o}=this.layout.bbox;t=new S.BBox({left:e,vcenter:Math.round(o),width:i,height:r})}}if(null!=e){const r=t.left-i.left,o=t.top-i.top,{left:a,top:n,width:_,height:s}=e;e=new S.BBox({left:a+r,top:n+o,width:_,height:s})}return[t,e]}})();let f,g,w,b;if(d.padding=p,null!=this.panel)f="max",g=void 0,w=void 0,b=void 0;else if("auto"==("horizontal"==_?e:i)){f="fixed";const t=this._get_major_size_factor();null!=t&&(g=25*t),w={percent:.3},b={percent:.8}}else f="fit",g=void 0;if("horizontal"==_){const t="auto"==e?void 0:e,r="auto"==i?25:i;d.set_sizing({width_policy:f,height_policy:"min",width:g,min_width:w,max_width:b,halign:n,valign:a,margin:m}),d.center_panel.set_sizing({width_policy:"auto"==e?"fit":"fixed",height_policy:"fixed",width:t,height:r})}else{const t="auto"==e?25:e,r="auto"==i?void 0:i;d.set_sizing({width_policy:"min",height_policy:f,height:g,min_height:w,max_height:b,halign:n,valign:a,margin:m}),d.center_panel.set_sizing({width_policy:"fixed",height_policy:"auto"==i?"fit":"fixed",width:t,height:r})}l.set_sizing({width_policy:"fit",height_policy:"min"}),h.set_sizing({width_policy:"fit",height_policy:"min"}),c.set_sizing({width_policy:"min",height_policy:"fit"}),u.set_sizing({width_policy:"min",height_policy:"fit"});const{_title_view:y}=this;"horizontal"==_?(y.panel=new j.SidePanel("above"),y.update_layout(),l.children.push(y.layout)):(y.panel=new j.SidePanel("left"),y.update_layout(),c.children.push(y.layout));const{panel:x}=this,B=null!=x&&_==x.orientation?x.side:"horizontal"==_?"below":"right",T=(()=>{switch(B){case"above":return l;case"below":return h;case"left":return c;case"right":return u}})(),{_axis_view:q}=this;if(q.panel=new j.SidePanel(B),q.update_layout(),null!=q.layout&&T.children.push(q.layout),null!=this.panel){const t=new v.Grid([{layout:d,row:0,col:0}]);t.absolute=!0,"horizontal"==_?t.set_sizing({width_policy:"max",height_policy:"min"}):t.set_sizing({width_policy:"min",height_policy:"max"}),this.layout=t}else this.layout=this._inner_layout;const{visible:A}=this.model;this.layout.sizing.visible=A}_create_axis(){return new c.LinearAxis}_create_formatter(){return new m.BasicTickFormatter}_create_major_range(){return new w.Range1d({start:0,end:1})}_create_major_scale(){return new g.LinearScale}_create_ticker(){return new d.BasicTicker}_get_major_size_factor(){return null}_render(){const{ctx:t}=this.layer;t.save(),this._paint_bbox(t,this._inner_layout.bbox),this._paint_colors(t,this._inner_layout.center_panel.bbox),this._title_view.render(),this._axis_view.render(),t.restore()}_paint_bbox(t,e){const{x:i,y:r}=e;let{width:o,height:a}=e;i+o>=this.parent.canvas_view.bbox.width&&(o-=1),r+a>=this.parent.canvas_view.bbox.height&&(a-=1),t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(i,r,o,a)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(i,r,o,a)),t.restore()}serializable_state(){const{children:t=[],...e}=super.serializable_state();return t.push(this._title_view.serializable_state()),t.push(this._axis_view.serializable_state()),{...e,children:t}}}i.BaseColorBarView=T,T.__name__="BaseColorBarView";class q extends _.Annotation{constructor(t){super(t)}}i.BaseColorBar=q,a=q,q.__name__="BaseColorBar",a.mixins([["major_label_",x.Text],["title_",x.Text],["major_tick_",x.Line],["minor_tick_",x.Line],["border_",x.Line],["bar_",x.Line],["background_",x.Fill]]),a.define((({Alpha:t,Float:e,Str:i,Tuple:r,Or:o,Ref:a,Auto:n,Nullable:_})=>({location:[o(y.Anchor,r(e,e)),"top_right"],orientation:[o(y.Orientation,n),"auto"],title:[_(o(i,a(b.BaseText))),null],title_standoff:[e,2],width:[o(e,n),"auto"],height:[o(e,n),"auto"],scale_alpha:[t,1],ticker:[o(a(u.Ticker),n),"auto"],formatter:[o(a(p.TickFormatter),n),"auto"],major_label_overrides:[h.LabelOverrides,new Map],major_label_policy:[a(f.LabelingPolicy),()=>new f.NoOverlap],label_standoff:[e,5],margin:[e,30],padding:[e,10],major_tick_in:[e,5],major_tick_out:[e,0],minor_tick_in:[e,0],minor_tick_out:[e,0]}))),a.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_font_size:"11px",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(e,t,i,a,s){var o;a();const r=e(1),n=e(169),c=e(20),l=r.__importStar(e(183));class h extends n.TextAnnotationView{_get_position(){const e=this.model.offset,t=this.model.standoff/2,{align:i,vertical_align:a}=this.model;let s,o;const{bbox:r}=this.layout;switch(this.panel.side){case"above":case"below":switch(a){case"top":o=r.top+t;break;case"middle":o=r.vcenter;break;case"bottom":o=r.bottom-t}switch(i){case"left":s=r.left+e;break;case"center":s=r.hcenter;break;case"right":s=r.right-e}break;case"left":switch(a){case"top":s=r.left+t;break;case"middle":s=r.hcenter;break;case"bottom":s=r.right-t}switch(i){case"left":o=r.bottom-e;break;case"center":o=r.vcenter;break;case"right":o=r.top+e}break;case"right":switch(a){case"top":s=r.right-t;break;case"middle":s=r.hcenter;break;case"bottom":s=r.left+t}switch(i){case"left":o=r.top+e;break;case"center":o=r.vcenter;break;case"right":o=r.bottom-e}}return{sx:s,sy:o}}get anchor(){const{align:e,vertical_align:t}=this.model;return l.text_anchor("auto",e,t)}get origin(){return this._get_position()}get angle(){return this.panel.get_label_angle_heuristic("parallel")}_get_size(){const e=e=>0==e?0:2+e+this.model.standoff,{width:t,height:i}=super._get_size();return this.panel.is_horizontal?{width:t,height:e(i)}:{width:e(t),height:i}}}i.TitleView=h,h.__name__="TitleView";class _ extends n.TextAnnotation{constructor(e){super(e)}}i.Title=_,o=_,_.__name__="Title",o.prototype.default_view=h,o.define((({Float:e})=>({vertical_align:[c.VerticalAlign,"bottom"],align:[c.TextAlign,"left"],offset:[e,0],standoff:[e,10]}))),o.override({text_font_size:"13px",text_font_style:"bold",text_line_height:1})},
function _(t,e,i,s,n){var a;s();const r=t(1),o=t(79),d=t(170),h=t(173),_=t(56),l=t(8),c=t(174),u=t(182),g=r.__importStar(t(183)),p=t(64),x=t(184),y=r.__importStar(t(85));class w extends o.AnnotationView{*children(){yield*super.children(),yield this._text_view}async lazy_initialize(){await super.lazy_initialize(),await this._init_text()}async _init_text(){const{text:t}=this.model,e=(0,l.isString)(t)?(0,c.parse_delimited_string)(t):t;this._text_view=await(0,_.build_view)(e,{parent:this})}update_layout(){const{panel:t}=this;this.layout=null!=t?new d.SideLayout(t,(()=>this.get_size()),!1):void 0}connect_signals(){super.connect_signals();const{text:t}=this.model.properties;this.on_change(t,(async()=>{this._text_view.remove(),await this._init_text()})),this.connect(this.model.change,(()=>this.request_render()))}remove(){this._text_view.remove(),super.remove()}has_finished(){return!!super.has_finished()&&!!this._text_view.has_finished()}get displayed(){return super.displayed&&""!=this._text_view.model.text&&this.visuals.text.doit}get padding(){return g.padding(this.model.padding)}get border_radius(){return g.border_radius(this.model.border_radius)}_get_size(){if(!this.displayed)return{width:0,height:0};const t=this._text_view.graphics();t.angle=this.angle,t.align="auto",t.visuals=this.visuals.text.values();const e=t.size(),{padding:i}=this;return{width:e.width+i.left+i.right,height:e.height+i.top+i.bottom}}compute_geometry(){super.compute_geometry();const t=this._text_view.graphics();t.position={sx:0,sy:0,x_anchor:"left",y_anchor:"top"},t.angle=0,t.align="auto",t.visuals=this.visuals.text.values();const e=t.size(),{sx:i,sy:s}=this.origin,{anchor:n,padding:a,border_radius:r,angle:o}=this,d=e.width+a.left+a.right,h=e.height+a.top+a.bottom;this._text_box=t,this._rect={sx:i,sy:s,width:d,height:h,angle:o,anchor:n,padding:a,border_radius:r}}_render(){this.compute_geometry();const{ctx:t}=this.layer,{sx:e,sy:i,width:s,height:n,angle:a,anchor:r,padding:o,border_radius:d}=this._rect,h=this._text_box,_=r.x*s,l=r.y*n;t.translate(e,i),t.rotate(a),t.translate(-_,-l);const{background_fill:c,background_hatch:u,border_line:g,text:y}=this.visuals;if(c.doit||u.doit||g.doit){t.beginPath();const e=new p.BBox({x:0,y:0,width:s,height:n});(0,x.round_rect)(t,e,d),c.apply(t),u.apply(t),g.apply(t)}if(y.doit){const{left:e,top:i}=o;t.translate(e,i),h.paint(t),t.translate(-e,-i)}t.translate(_,l),t.rotate(-a),t.translate(-e,-i)}}i.TextAnnotationView=w,w.__name__="TextAnnotationView";class m extends o.Annotation{constructor(t){super(t)}}i.TextAnnotation=m,a=m,m.__name__="TextAnnotation",a.mixins([y.Text,["border_",y.Line],["background_",y.Fill],["background_",y.Hatch]]),a.define((({Str:t,Or:e,Ref:i})=>({text:[e(t,i(h.BaseText)),""],padding:[u.Padding,0],border_radius:[u.BorderRadius,0]}))),a.override({border_line_color:null,background_fill_color:null,background_hatch_color:null})},
function _(t,e,i,l,a){l();const r=t(171),o=t(172),n=t(8),s=Math.PI/2,h={above:{parallel:0,normal:-s,horizontal:0,vertical:-s},below:{parallel:0,normal:s,horizontal:0,vertical:s},left:{parallel:-s,normal:0,horizontal:0,vertical:-s},right:{parallel:s,normal:0,horizontal:0,vertical:s}},c={above:{parallel:"bottom",normal:"center",horizontal:"bottom",vertical:"center"},below:{parallel:"top",normal:"center",horizontal:"top",vertical:"center"},left:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"},right:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"}},_={above:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},below:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},left:{parallel:"center",normal:"right",horizontal:"right",vertical:"center"},right:{parallel:"center",normal:"left",horizontal:"left",vertical:"center"}},g={above:"right",below:"left",left:"right",right:"left"},b={above:"left",below:"right",left:"right",right:"left"};class d{constructor(t,e){this.side=t,this.face=(()=>{if(null!=e&&"auto"!=e)return e;switch(this.side){case"left":case"above":return"front";case"right":case"below":return"back"}})(),this.dimension="above"==this.side||"below"==this.side?0:1,this.orientation=0==this.dimension?"horizontal":"vertical",this.is_horizontal=0==this.dimension,this.is_vertical=1==this.dimension,this.normals=(()=>{const t="front"==this.face?-1:1;switch(this.side){case"left":case"right":return[t,0];case"above":case"below":return[0,t]}})()}get face_adjusted_side(){const{side:t,face:e}=this;switch(t){case"left":case"right":return"front"==e?"left":"right";case"above":case"below":return"front"==e?"above":"below"}}get_label_text_heuristics(t){const e=this.face_adjusted_side;return(0,n.isString)(t)?{vertical_align:c[e][t],align:_[e][t]}:{vertical_align:"center",align:(t<0?g:b)[e]}}get_label_angle_heuristic(t){if((0,n.isString)(t)){const e=this.face_adjusted_side;return h[e][t]}return-t}}i.SidePanel=d,d.__name__="SidePanel";class f extends o.ContentLayoutable{constructor(t,e,i=!1){super(),this.panel=t,this.get_size=e,this.rotate=i,this.panel.is_horizontal?this.set_sizing({width_policy:"max",height_policy:"fixed"}):this.set_sizing({width_policy:"fixed",height_policy:"max"})}_content_size(){const{width:t,height:e}=this.get_size();return!this.rotate||this.panel.is_horizontal?new r.Sizeable({width:t,height:e}):new r.Sizeable({width:e,height:t})}has_size_changed(){const{width:t,height:e}=this._content_size();return this.panel.is_horizontal?this.bbox.height!=e:this.bbox.width!=t}}i.SideLayout=f,f.__name__="SideLayout"},
function _(h,t,i,e,w){e();const n=h(21),{min:d,max:s}=Math;class g{constructor(h={}){this.width=null!=h.width?h.width:0,this.height=null!=h.height?h.height:0}bounded_to({width:h,height:t}){return new g({width:this.width==1/0&&null!=h?h:this.width,height:this.height==1/0&&null!=t?t:this.height})}expanded_to({width:h,height:t}){return new g({width:h!=1/0?s(this.width,h):this.width,height:t!=1/0?s(this.height,t):this.height})}expand_to({width:h,height:t}){this.width=s(this.width,h),this.height=s(this.height,t)}narrowed_to({width:h,height:t}){return new g({width:d(this.width,h),height:d(this.height,t)})}narrow_to({width:h,height:t}){this.width=d(this.width,h),this.height=d(this.height,t)}grow_by({left:h,right:t,top:i,bottom:e}){const w=this.width+h+t,n=this.height+i+e;return new g({width:w,height:n})}shrink_by({left:h,right:t,top:i,bottom:e}){const w=s(this.width-h-t,0),n=s(this.height-i-e,0);return new g({width:w,height:n})}map(h,t){return new g({width:h(this.width),height:(null!=t?t:h)(this.height)})}}i.Sizeable=g,g.__name__="Sizeable",i.SizingPolicy=(0,n.Enum)("fixed","fit","min","max")},
function _(i,t,e,h,s){h();const n=i(171),r=i(64),_=i(8),g=i(12),{abs:o,min:l,max:a,round:d}=Math;class u{constructor(){this.absolute=!1,this.position={left:0,top:0},this._bbox=new r.BBox,this._inner_bbox=new r.BBox,this._sizing=null,this._dirty=!1,this._handlers=[]}*[Symbol.iterator](){}get bbox(){return this._bbox}get inner_bbox(){return this._inner_bbox}get sizing(){return(0,g.assert)(null!=this._sizing),this._sizing}set dirty(i){this._dirty=i}get dirty(){return this._dirty}get visible(){return this.sizing.visible}set visible(i){this.sizing.visible!=i&&(this.sizing.visible=i,this._dirty=!0)}set_sizing(i={}){const t=i.width_policy??"fit",e=i.width,h=i.min_width,s=i.max_width,n=i.height_policy??"fit",r=i.height,_=i.min_height,g=i.max_height,o=i.aspect,l=i.margin??{top:0,right:0,bottom:0,left:0},a=i.visible??!0,d=i.halign??"start",u=i.valign??"start";this._sizing={width_policy:t,min_width:h,width:e,max_width:s,height_policy:n,min_height:_,height:r,max_height:g,aspect:o,margin:l,visible:a,halign:d,valign:u,size:{width:e,height:r}},this._init()}_init(){}_set_geometry(i,t){this._bbox=i,this._inner_bbox=t}set_geometry(i,t){const{fixup_geometry:e}=this;null!=e&&([i,t]=e(i,t)),this._set_geometry(i,t??i);for(const i of this._handlers)i(this._bbox,this._inner_bbox)}on_resize(i){this._handlers.push(i)}is_width_expanding(){return"max"==this.sizing.width_policy}is_height_expanding(){return"max"==this.sizing.height_policy}apply_aspect(i,{width:t,height:e}){const{aspect:h}=this.sizing;if(null!=h){const{width_policy:s,height_policy:n}=this.sizing,r=(i,t)=>{const e={max:4,fit:3,min:2,fixed:1};return e[i]>e[t]};if("fixed"!=s&&"fixed"!=n)if(s==n){const s=t,n=d(t/h),r=d(e*h),_=e;o(i.width-s)+o(i.height-n)<=o(i.width-r)+o(i.height-_)?(t=s,e=n):(t=r,e=_)}else r(s,n)?e=d(t/h):t=d(e*h);else"fixed"==s?e=d(t/h):"fixed"==n&&(t=d(e*h))}return{width:t,height:e}}measure(i){if(null==this._sizing&&this.set_sizing(),!this.sizing.visible)return{width:0,height:0};const t=i=>"fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:i,e=i=>"fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:i,h=new n.Sizeable(i).shrink_by(this.sizing.margin).map(t,e),s=this._measure(h),r=this.clip_size(s,h),_=t(r.width),g=e(r.height),o=this.apply_aspect(h,{width:_,height:g});return{...s,...o}}compute(i={}){const t=this.measure({width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0}),{width:e,height:h}=t,{left:s,top:n}=this.position,_=new r.BBox({left:s,top:n,width:e,height:h});let g;if(null!=t.inner){const{left:i,top:s,right:n,bottom:_}=t.inner;g=new r.BBox({left:i,top:s,right:e-n,bottom:h-_})}this.set_geometry(_,g)}get xview(){return this.bbox.xview}get yview(){return this.bbox.yview}clip_size(i,t){function e(i,t,e,h){return null==e?e=0:(0,_.isNumber)(e)||(e=d(e.percent*t)),null==h?h=1/0:(0,_.isNumber)(h)||(h=d(h.percent*t)),a(e,l(i,h))}return{width:e(i.width,t.width,this.sizing.min_width,this.sizing.max_width),height:e(i.height,t.height,this.sizing.min_height,this.sizing.max_height)}}has_size_changed(){const{_dirty:i}=this;return this._dirty=!1,i}}e.Layoutable=u,u.__name__="Layoutable";class c extends u{_measure(i){const t=this._content_size(),e=i.bounded_to(this.sizing.size).bounded_to(t);return{width:(()=>{switch(this.sizing.width_policy){case"fixed":return null!=this.sizing.width?this.sizing.width:t.width;case"min":return t.width;case"fit":return e.width;case"max":return a(t.width,e.width)}})(),height:(()=>{switch(this.sizing.height_policy){case"fixed":return null!=this.sizing.height?this.sizing.height:t.height;case"min":return t.height;case"fit":return e.height;case"max":return a(t.height,e.height)}})()}}}e.ContentLayoutable=c,c.__name__="ContentLayoutable";class w extends c{constructor(i){super(),this.text=i}_content_size(){return new n.Sizeable(this.text.size())}}e.TextLayout=w,w.__name__="TextLayout";class x extends c{constructor(i={}){super(),this.size=i}_content_size(){return new n.Sizeable(this.size)}}e.FixedLayout=x,x.__name__="FixedLayout"},
function _(e,s,t,a,n){var _;a();const x=e(51),c=e(58);class i extends c.View{}t.BaseTextView=i,i.__name__="BaseTextView";class o extends x.Model{constructor(e){super(e)}}t.BaseText=o,_=o,o.__name__="BaseText",_.define((({Str:e})=>({text:[e]})))},
function _(n,e,t,i,o){i();const r=n(175),l=n(181),s=n(10),c=[{start:"$$",end:"$$",inline:!1},{start:"\\[",end:"\\]",inline:!1},{start:"\\(",end:"\\)",inline:!0}];function d(n){return n.split("").map((n=>`\\${n}`)).join("")}t.parse_delimited_string=function(n){const e=[];for(const t of c){const i=d(t.start),o=d(t.end),r=new RegExp(`${i}([^]*?)${o}`,"gm");for(const i of n.matchAll(r)){const{index:n}=i;if(null!=n){const[o,r]=i;e.push({index:n,outer:o,inner:r,delim:t})}}}if(e.length>0){if(1==e.length){const[t]=e,i=t.index,o=t.outer.length;if(0==i&&o==n.length){const n=t.inner;return new r.TeX({text:n,inline:t.delim.inline})}}let t="",i=0;for(const o of(0,s.sort_by)(e,(n=>n.index))){const e=o.index;i<=e&&(t+=0!=e?`\\text{${n.slice(i,e)}}${o.inner}`:`${o.inner}`,i=e+o.outer.length)}return t+=i<n.length?`\\text{${n.slice(i)}}`:"",new r.TeX({text:t,inline:!1})}return new l.PlainText({text:n})}},
function _(t,e,s,i,n){var h,o,r;i();const a=t(9),_=t(8),l=t(176),c=t(22),u=t(177),d=t(178),g=t(40),x=t(112),p=t(64),f=t(173),m=t(179);class y extends f.BaseTextView{constructor(){super(...arguments),this._position={sx:0,sy:0},this.align="left",this._x_anchor="left",this._y_anchor="center",this._base_font_size=13,this.font_size_scale=1,this.svg_image=null}graphics(){return this}infer_text_height(){return"ascent_descent"}set base_font_size(t){null!=t&&(this._base_font_size=t)}get base_font_size(){return this._base_font_size}_rect(){const{width:t,height:e}=this._size(),{x:s,y:i}=this._computed_position();return new p.BBox({x:s,y:i,width:t,height:e}).rect}set position(t){this._position=t}get position(){return this._position}get text(){return this.model.text}get provider(){return m.default_provider}async lazy_initialize(){await super.lazy_initialize(),"not_started"==this.provider.status&&await this.provider.fetch()}connect_signals(){super.connect_signals(),this.on_change(this.model.properties.text,(()=>this.load_image()))}set visuals(t){const e=t.color,s=t.alpha,i=t.font_style;let n=t.font_size;const h=t.font,{font_size_scale:o,_base_font_size:r}=this,a=(0,d.parse_css_font_size)(n);if(null!=a){let{value:t,unit:e}=a;t*=o,"em"==e&&0!=r&&(t*=r,e="px"),n=`${t}${e}`}const _=`${i} ${n} ${h}`;this.font=_,this.color=(0,c.color2css)(e,s);const l=t.align;this._x_anchor=l;const u=t.baseline;this._y_anchor=(()=>{switch(u){case"top":return"top";case"middle":return"center";case"bottom":return"bottom";default:return"baseline"}})()}_computed_position(){const{width:t,height:e}=this._size(),{sx:s,sy:i,x_anchor:n=this._x_anchor,y_anchor:h=this._y_anchor}=this.position,o=(0,d.font_metrics)(this.font);return{x:s-(()=>{if((0,_.isNumber)(n))return n*t;switch(n){case"left":return 0;case"center":return.5*t;case"right":return t}})(),y:i-(()=>{if((0,_.isNumber)(h))return h*e;switch(h){case"top":return o.height>e?e-(-this.valign-o.descent)-o.height:0;case"center":case"baseline":return.5*e;case"bottom":return o.height>e?e+o.descent+this.valign:e}})()}}size(){const{width:t,height:e}=this._size(),{angle:s}=this;if(null==s||0==s)return{width:t,height:e};{const i=Math.cos(Math.abs(s)),n=Math.sin(Math.abs(s));return{width:Math.abs(t*i+e*n),height:Math.abs(t*n+e*i)}}}get_image_dimensions(){const t=(0,d.font_metrics)(this.font),e=this.svg_element.getAttribute("style")?.split(";");if(null!=e){const s=new Map;e.forEach((t=>{const[e,i]=t.split(":");""!=e.trim()&&s.set(e.trim(),i.trim())}));const i=(0,d.parse_css_length)(s.get("vertical-align"));"ex"==i?.unit?this.valign=i.value*t.x_height:"px"==i?.unit&&(this.valign=i.value)}const s=(()=>{const t=this.svg_element.getAttribute("width"),e=this.svg_element.getAttribute("height");return{width:null!=t&&t.endsWith("ex")?parseFloat(t):1,height:null!=e&&e.endsWith("ex")?parseFloat(e):1}})();return{width:t.x_height*s.width,height:t.x_height*s.height}}get truncated_text(){return this.model.text.length>6?`${this.model.text.substring(0,6)}...`:this.model.text}_size(){if(null==this.svg_image)return"failed"==this.provider.status||"not_started"==this.provider.status?{width:(0,u.text_width)(this.truncated_text,this.font),height:(0,d.font_metrics)(this.font).height}:{width:this._base_font_size,height:this._base_font_size};const t=(0,d.font_metrics)(this.font);let{width:e,height:s}=this.get_image_dimensions();s=Math.max(s,t.height);return{width:e*("%"==this.width?.unit?this.width.value:1),height:s*("%"==this.height?.unit?this.height.value:1)}}bbox(){const{p0:t,p1:e,p2:s,p3:i}=this.rect(),n=Math.min(t.x,e.x,s.x,i.x),h=Math.min(t.y,e.y,s.y,i.y),o=Math.max(t.x,e.x,s.x,i.x),r=Math.max(t.y,e.y,s.y,i.y);return new p.BBox({left:n,right:o,top:h,bottom:r})}rect(){const t=this._rect(),{angle:e}=this;if(null==e||0==e)return t;{const{sx:s,sy:i}=this.position,n=new x.AffineTransform;return n.translate(s,i),n.rotate(e),n.translate(-s,-i),n.apply_rect(t)}}paint_rect(t){const{p0:e,p1:s,p2:i,p3:n}=this.rect();t.save(),t.strokeStyle="red",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e.x),h(e.y)),t.lineTo(h(s.x),h(s.y)),t.lineTo(h(i.x),h(i.y)),t.lineTo(h(n.x),h(n.y)),t.closePath(),t.stroke(),t.restore()}paint_bbox(t){const{x:e,y:s,width:i,height:n}=this.bbox();t.save(),t.strokeStyle="blue",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e),h(s)),t.lineTo(h(e),h(s+n)),t.lineTo(h(e+i),h(s+n)),t.lineTo(h(e+i),h(s)),t.closePath(),t.stroke(),t.restore()}async request_image(){if(null==this.provider.MathJax)return;const t=this._process_text();if(null==t)return void(this._has_finished=!0);const e=t.children[0];this.svg_element=e,e.setAttribute("font",this.font),e.setAttribute("stroke",this.color);const s=e.outerHTML,i=`data:image/svg+xml;utf-8,${encodeURIComponent(s)}`;this.svg_image=await(0,l.load_image)(i)}async load_image(){await this.request_image(),this.parent.request_layout()}paint(t){null==this.svg_image&&("not_started"!=this.provider.status&&"loading"!=this.provider.status||this.provider.ready.connect((()=>this.load_image())),"loaded"==this.provider.status&&this.load_image()),t.save();const{sx:e,sy:s}=this.position,{angle:i}=this;null!=i&&0!=i&&(t.translate(e,s),t.rotate(i),t.translate(-e,-s));const{x:n,y:h}=this._computed_position();if(null!=this.svg_image){const{width:e,height:s}=this.get_image_dimensions();t.drawImage(this.svg_image,n,h,e,s)}else"failed"!=this.provider.status&&"not_started"!=this.provider.status||(t.fillStyle=this.color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic",t.fillText(this.truncated_text,n,h+(0,d.font_metrics)(this.font).ascent));t.restore(),this._has_finished||"failed"!=this.provider.status&&null==this.svg_image||(this._has_finished=!0,this.parent.notify_finished_after_paint())}}s.MathTextView=y,y.__name__="MathTextView";class v extends f.BaseText{constructor(t){super(t)}}s.MathText=v,v.__name__="MathText";class b extends y{get styled_text(){return this.text}_process_text(){}_size(){return{width:(0,u.text_width)(this.text,this.font),height:(0,d.font_metrics)(this.font).height}}paint(t){t.save();const{sx:e,sy:s}=this.position,{angle:i}=this;null!=i&&0!=i&&(t.translate(e,s),t.rotate(i),t.translate(-e,-s));const{x:n,y:h}=this._computed_position();t.fillStyle=this.color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic",t.fillText(this.text,n,h+(0,d.font_metrics)(this.font).ascent),t.restore(),this._has_finished=!0,this.parent.notify_finished_after_paint()}}s.AsciiView=b,b.__name__="AsciiView";class w extends v{constructor(t){super(t)}}s.Ascii=w,h=w,w.__name__="Ascii",h.prototype.default_view=b;class M extends y{get styled_text(){let t=this.text.trim(),e=t.match(/<math(.*?[^?])?>/s);return null==e?this.text.trim():(t=(0,g.insert_text_on_position)(t,t.indexOf(e[0])+e[0].length,`<mstyle displaystyle="true" mathcolor="${(0,c.color2hexrgb)(this.color)}" ${this.font.includes("bold")?'mathvariant="bold"':""}>`),e=t.match(/<\/[^>]*?math.*?>/s),null==e?this.text.trim():(0,g.insert_text_on_position)(t,t.indexOf(e[0]),"</mstyle>"))}_process_text(){const t=(0,d.font_metrics)(this.font);return this.provider.MathJax?.mathml2svg(this.styled_text,{em:this.base_font_size,ex:t.x_height})}}s.MathMLView=M,M.__name__="MathMLView";class z extends v{constructor(t){super(t)}}s.MathML=z,o=z,z.__name__="MathML",o.prototype.default_view=M;class T extends y{get styled_text(){const[t,e,s]=(0,c.color2rgba)(this.color);return`\\color[RGB]{${t}, ${e}, ${s}} ${this.font.includes("bold")?`\\pmb{${this.text}}`:this.text}`}_process_text(){const t=(0,d.font_metrics)(this.font);return this.provider.MathJax?.tex2svg(this.styled_text,{display:!this.model.inline,em:this.base_font_size,ex:t.x_height},(0,a.to_object)(this.model.macros))}}s.TeXView=T,T.__name__="TeXView";class $ extends v{constructor(t){super(t)}}s.TeX=$,r=$,$.__name__="TeX",r.prototype.default_view=T,r.define((({Bool:t,Float:e,Str:s,Dict:i,Tuple:n,Or:h})=>({macros:[i(h(s,n(s,e))),{}],inline:[t,!1]})))},
function _(i,e,t,s,n){s();const a=i(19);t.load_image=async function(i,e){return new o(i,e).promise};class o{constructor(i,e={}){this.image=new Image,this._finished=!1;const{attempts:t=1,timeout:s=1}=e,n=(()=>{if(i instanceof ArrayBuffer){const e=new Blob([i],{type:"image/png"});return URL.createObjectURL(e)}return i})();this.promise=new Promise(((i,o)=>{this.image.crossOrigin="anonymous";let r=0;this.image.onerror=()=>{if(++r==t){const i=`unable to load ${n} image after ${t} attempts`;if(a.logger.warn(i),null==this.image.crossOrigin)return void e.failed?.();a.logger.warn(`attempting to load ${n} without a cross origin policy`),this.image.crossOrigin=null,r=0}setTimeout((()=>this.image.src=n),s)},this.image.onload=()=>{this._finished=!0,e.loaded?.(this.image),i(this.image)},this.image.src=n}))}get finished(){return this._finished}}t.ImageLoader=o,o.__name__="ImageLoader"},
function _(t,e,s,i,n){i();const h=t(64),o=t(178),a=t(10),r=t(8),c=t(112),_=t(22);s.text_width=(()=>{const t=document.createElement("canvas").getContext("2d");let e="";return(s,i)=>(i!=e&&(e=i,t.font=i),t.measureText(s).width)})();class l{constructor(){this._position={sx:0,sy:0},this.font_size_scale=1,this.align="left",this._base_font_size=13,this._x_anchor="left",this._y_anchor="center"}set base_font_size(t){null!=t&&(this._base_font_size=t)}get base_font_size(){return this._base_font_size}set position(t){this._position=t}get position(){return this._position}infer_text_height(){return"ascent_descent"}bbox(){const{p0:t,p1:e,p2:s,p3:i}=this.rect(),n=Math.min(t.x,e.x,s.x,i.x),o=Math.min(t.y,e.y,s.y,i.y),a=Math.max(t.x,e.x,s.x,i.x),r=Math.max(t.y,e.y,s.y,i.y);return new h.BBox({left:n,right:a,top:o,bottom:r})}size(){const{width:t,height:e}=this._size(),{angle:s}=this;if(null==s||0==s)return{width:t,height:e};{const i=Math.cos(Math.abs(s)),n=Math.sin(Math.abs(s));return{width:Math.abs(t*i+e*n),height:Math.abs(t*n+e*i)}}}rect(){const t=this._rect(),{angle:e}=this;if(null==e||0==e)return t;{const{sx:s,sy:i}=this.position,n=new c.AffineTransform;return n.translate(s,i),n.rotate(e),n.translate(-s,-i),n.apply_rect(t)}}paint_rect(t){const{p0:e,p1:s,p2:i,p3:n}=this.rect();t.save(),t.strokeStyle="red",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e.x),h(e.y)),t.lineTo(h(s.x),h(s.y)),t.lineTo(h(i.x),h(i.y)),t.lineTo(h(n.x),h(n.y)),t.closePath(),t.stroke(),t.restore()}paint_bbox(t){const{x:e,y:s,width:i,height:n}=this.bbox();t.save(),t.strokeStyle="blue",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e),h(s)),t.lineTo(h(e),h(s+n)),t.lineTo(h(e+i),h(s+n)),t.lineTo(h(e+i),h(s)),t.closePath(),t.stroke(),t.restore()}}s.GraphicsBox=l,l.__name__="GraphicsBox";class x extends l{set visuals(t){const e=t.color,s=t.alpha,i=t.outline_color,n=t.font_style;let h=t.font_size;const a=t.font,{font_size_scale:r,base_font_size:c}=this,l=(0,o.parse_css_font_size)(h);if(null!=l){let{value:t,unit:e}=l;t*=r,"em"==e&&0!=c&&(t*=c,e="px"),h=`${t}${e}`}const x=`${n} ${h} ${a}`;this.font=x,this.color=(0,_.color2css)(e,s),this.outline_color=(0,_.color2css)(i,s),this.line_height=t.line_height;const u=t.align;this._visual_align=u,this._x_anchor=u;const p=t.baseline;this._y_anchor=(()=>{switch(p){case"top":return"top";case"middle":return"center";case"bottom":return"bottom";default:return"baseline"}})()}constructor({text:t}){super(),this._visual_align="left",this.text=t}infer_text_height(){if(this.text.includes("\n"))return"ascent_descent";{function t(t){for(const e of new Set(t))if(!("0"<=e&&e<="9"))switch(e){case",":case".":case"+":case"-":case"\u2212":case"e":continue;default:return!1}return!0}return t(this.text)?"cap":"ascent_descent"}}_text_line(t){const e=this.text_height_metric??this.infer_text_height(),s=(()=>{switch(e){case"x":case"x_descent":return t.x_height;case"cap":case"cap_descent":return t.cap_height;case"ascent":case"ascent_descent":return t.ascent}})(),i=(()=>{switch(e){case"x":case"cap":case"ascent":return 0;case"x_descent":case"cap_descent":case"ascent_descent":return t.descent}})();return{height:s+i,ascent:s,descent:i}}get nlines(){return this.text.split("\n").length}_size(){const{font:t}=this,e=(0,o.font_metrics)(t),i=(this.line_height-1)*e.height,n=""==this.text,h=this.text.split("\n"),r=h.length,c=h.map((e=>(0,s.text_width)(e,t))),_=this._text_line(e).height*r,l="%"==this.width?.unit?this.width.value:1,x="%"==this.height?.unit?this.height.value:1;return{width:(0,a.max)(c)*l,height:n?0:(_+i*(r-1))*x,metrics:e}}_computed_position(t,e,s){const{width:i,height:n}=t,{sx:h,sy:o,x_anchor:a=this._x_anchor,y_anchor:c=this._y_anchor}=this.position;return{x:h-(()=>{if((0,r.isNumber)(a))return a*i;switch(a){case"left":return 0;case"center":return.5*i;case"right":return i}})(),y:o-(()=>{if((0,r.isNumber)(c))return c*n;switch(c){case"top":return 0;case"center":return.5*n;case"bottom":return n;case"baseline":if(1!=s)return.5*n;switch(this.text_height_metric??this.infer_text_height()){case"x":case"x_descent":return e.x_height;case"cap":case"cap_descent":return e.cap_height;case"ascent":case"ascent_descent":return e.ascent}}})()}}_rect(){const{width:t,height:e,metrics:s}=this._size(),i=this.text.split("\n").length,{x:n,y:o}=this._computed_position({width:t,height:e},s,i);return new h.BBox({x:n,y:o,width:t,height:e}).rect}paint(t){const{font:e}=this,i=(0,o.font_metrics)(e),n=(this.line_height-1)*i.height,h=this.text.split("\n"),r=h.length,c=h.map((t=>(0,s.text_width)(t,e))),_=this._text_line(i),l=_.height*r,x="%"==this.width?.unit?this.width.value:1,u="%"==this.height?.unit?this.height.value:1,p=(0,a.max)(c)*x,f=(l+n*(r-1))*u;t.save(),t.fillStyle=this.color,t.strokeStyle=this.outline_color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic";const{sx:g,sy:d}=this.position,{align:b}=this,{angle:m}=this;null!=m&&0!=m&&(t.translate(g,d),t.rotate(m),t.translate(-g,-d));let{x:y,y:w}=this._computed_position({width:p,height:f},i,r);if("justify"==b)for(let i=0;i<r;i++){let o=y;const r=h[i].split(" "),c=r.length,l=r.map((t=>(0,s.text_width)(t,e))),x=(p-(0,a.sum)(l))/(c-1);for(let e=0;e<c;e++)t.fillText(r[e],o,w),t.strokeText(r[e],o,w),o+=l[e]+x;w+=_.height+n}else for(let e=0;e<r;e++){const s=y+(()=>{switch("auto"==b?this._visual_align:b){case"left":return 0;case"center":return.5*(p-c[e]);case"right":return p-c[e]}})(),i=h[e],o=w+_.ascent;t.fillText(i,s,o),t.strokeText(i,s,o),w+=_.height+n}t.restore()}}s.TextBox=x,x.__name__="TextBox";class u extends l{constructor(t,e){super(),this.base=t,this.expo=e}get children(){return[this.base,this.expo]}set base_font_size(t){super.base_font_size=t,this.base.base_font_size=t,this.expo.base_font_size=t}set position(t){this._position=t;const e=this.base.size(),s=this.expo.size(),i=this._shift_scale()*e.height,n=Math.max(e.height,i+s.height);this.base.position={sx:0,x_anchor:"left",sy:n,y_anchor:"bottom"},this.expo.position={sx:e.width,x_anchor:"left",sy:i,y_anchor:"bottom"}}get position(){return this._position}set visuals(t){this.expo.font_size_scale=.7,this.base.visuals=t,this.expo.visuals=t}_shift_scale(){if(this.base instanceof x&&1==this.base.nlines){const{x_height:t,cap_height:e}=(0,o.font_metrics)(this.base.font);return t/e}return 2/3}infer_text_height(){return this.base.infer_text_height()}_rect(){const t=this.base.bbox(),e=this.expo.bbox(),s=t.union(e),{x:i,y:n}=this._computed_position();return s.translate(i,n).rect}_size(){const t=this.base.size(),e=this.expo.size();return{width:t.width+e.width,height:Math.max(t.height,this._shift_scale()*t.height+e.height)}}paint(t){t.save();const{angle:e}=this;if(null!=e&&0!=e){const{sx:s,sy:i}=this.position;t.translate(s,i),t.rotate(e),t.translate(-s,-i)}const{x:s,y:i}=this._computed_position();t.translate(s,i),this.base.paint(t),this.expo.paint(t),t.restore()}paint_bbox(t){super.paint_bbox(t);const{x:e,y:s}=this._computed_position();t.save(),t.translate(e,s);for(const e of this.children)e.paint_bbox(t);t.restore()}_computed_position(){const{width:t,height:e}=this._size(),{sx:s,sy:i,x_anchor:n=this._x_anchor,y_anchor:h=this._y_anchor}=this.position;return{x:s-(()=>{if((0,r.isNumber)(n))return n*t;switch(n){case"left":return 0;case"center":return.5*t;case"right":return t}})(),y:i-(()=>{if((0,r.isNumber)(h))return h*e;switch(h){case"top":return 0;case"center":case"baseline":return.5*e;case"bottom":return e}})()}}}s.BaseExpo=u,u.__name__="BaseExpo";class p{constructor(t){this.items=t}set base_font_size(t){for(const e of this.items)e.base_font_size=t}get length(){return this.items.length}set visuals(t){for(const e of this.items)e.visuals=t;const e={x:0,cap:1,ascent:2,x_descent:3,cap_descent:4,ascent_descent:5},s=(0,a.max_by)(this.items.map((t=>t.infer_text_height())),(t=>e[t]));for(const t of this.items)t.text_height_metric=s}set angle(t){for(const e of this.items)e.angle=t}max_size(){let t=0,e=0;for(const s of this.items){const i=s.size();t=Math.max(t,i.width),e=Math.max(e,i.height)}return{width:t,height:e}}}s.GraphicsBoxes=p,p.__name__="GraphicsBoxes"},
function _(t,e,n,c,s){c();const a=t(12),o=t(8),r=(()=>{try{return"undefined"!=typeof OffscreenCanvas&&null!=new OffscreenCanvas(0,0).getContext("2d")}catch{return!1}})()?(t,e)=>new OffscreenCanvas(t,e):(t,e)=>{const n=document.createElement("canvas");return n.width=t,n.height=e,n},i=(()=>{const t=r(0,0).getContext("2d");return(0,a.assert)(null!=t,"can't obtain 2d context"),e=>{t.font=e;const n=t.measureText("M"),c=t.measureText("x"),s=t.measureText("\xc5\u015ag|"),r=s.fontBoundingBoxAscent,i=s.fontBoundingBoxDescent;if((0,o.is_defined)(r)&&(0,o.is_defined)(i))return{height:r+i,ascent:r,descent:i,cap_height:n.actualBoundingBoxAscent,x_height:c.actualBoundingBoxAscent};const u=s.actualBoundingBoxAscent,l=s.actualBoundingBoxDescent;if((0,o.is_defined)(u)&&(0,o.is_defined)(l))return{height:u+l,ascent:u,descent:l,cap_height:n.actualBoundingBoxAscent,x_height:c.actualBoundingBoxAscent};(0,a.unreachable)()}})(),u=(()=>{const t=document.createElement("canvas"),e=t.getContext("2d");let n=-1,c=-1;return(s,a=1)=>{e.font=s;const{width:o}=e.measureText("M"),r=o*a,i=Math.ceil(r),u=Math.ceil(2*r),l=Math.ceil(1.5*r);n<i&&(n=i,t.width=i),c<u&&(c=u,t.height=u),e.save(),e.scale(a,a),e.fillStyle="#f00",e.fillRect(0,0,i,u);const f=t=>{let e=0;for(let n=0;n<=l;n++)for(let c=0;c<i;c++,e+=4)if(255!=t[e])return l-n;return 0};e.font=s,e.fillStyle="#000";for(const t of"xa")e.fillText(t,0,l/a);const{data:d}=e.getImageData(0,0,i,u),h=f(d)/a;for(const t of"ASQ")e.fillText(t,0,l/a);const{data:g}=e.getImageData(0,0,i,u),x=f(g)/a;for(const t of"\xc5\u015agy")e.fillText(t,0,l/a);const{data:m}=e.getImageData(0,0,i,u),_=f(m)/a,B=(t=>{let e=t.length-4;for(let n=u;n>=l;n--)for(let c=0;c<i;c++,e-=4)if(255!=t[e])return n-l;return 0})(m)/a;return e.restore(),{height:_+B,ascent:_,cap_height:x,x_height:h,descent:B}}})(),l=(()=>{try{return i("normal 10px sans-serif"),i}catch{return u}})(),f=new Map;n.font_metrics=function(t){let e=f.get(t);if(null==e){const n=document.fonts.check(t);e={font:l(t)},n&&f.set(t,e)}return e.font},n.parse_css_font_size=function(t){const e=t.match(/^\s*(\d+(\.\d+)?)(\w+)\s*$/);if(null!=e){const[,t,,n]=e,c=Number(t);if(isFinite(c))return{value:c,unit:n}}return null},n.parse_css_length=function(t){const e=t.match(/^\s*(-?\d+(\.\d+)?)(\w+)\s*$/);if(null!=e){const[,t,,n]=e,c=Number(t);if(isFinite(c))return{value:c,unit:n}}return null}},
function _(t,e,a,r,n){var s=this&&this.__createBinding||(Object.create?function(t,e,a,r){void 0===r&&(r=a);var n=Object.getOwnPropertyDescriptor(e,a);n&&!("get"in n?!e.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return e[a]}}),Object.defineProperty(t,r,n)}:function(t,e,a,r){void 0===r&&(r=a),t[r]=e[a]}),i=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),o=this&&this.__importStar||function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var a in t)"default"!==a&&Object.prototype.hasOwnProperty.call(t,a)&&s(e,t,a);return i(e,t),e};r();const d=t(15),l=t(180);class u{constructor(){this.ready=new d.Signal0(this,"ready"),this.status="not_started"}}a.MathJaxProvider=u,u.__name__="MathJaxProvider";class c extends u{get MathJax(){return null}async fetch(){this.status="failed"}}a.NoProvider=c,c.__name__="NoProvider";class h extends u{get MathJax(){return"undefined"!=typeof MathJax?MathJax:null}async fetch(){const t=document.createElement("script");t.src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-svg.js",t.onload=()=>{this.status="loaded",this.ready.emit()},t.onerror=()=>{this.status="failed"},this.status="loading",document.head.appendChild(t)}}a.CDNProvider=h,h.__name__="CDNProvider";class _ extends u{get MathJax(){return this._mathjax}async fetch(){this.status="loading";try{const e=await(0,l.load_module)(Promise.resolve().then((()=>o(t(698)))));this.status=null==e?"failed":"loaded",this._mathjax=e,this.ready.emit()}catch(t){this.status="failed"}}}a.BundleProvider=_,_.__name__="BundleProvider",a.default_provider=new _},
function _(n,r,o,t,c){t(),o.load_module=async function(n){try{return await n}catch(n){if((r=n)instanceof Error&&"code"in r&&"MODULE_NOT_FOUND"===n.code)return null;throw n}var r}},
function _(e,t,i,n,s){var a;n();const x=e(173),_=e(177);class l extends x.BaseTextView{initialize(){super.initialize(),this._has_finished=!0}graphics(){return new _.TextBox({text:this.model.text})}}i.PlainTextView=l,l.__name__="PlainTextView";class r extends x.BaseText{constructor(e){super(e)}}i.PlainText=r,a=r,r.__name__="PlainText",a.prototype.default_view=l},
function _(t,n,e,i,r){i();const g=t(1),a=t(21),h=g.__importStar(t(20));e.Length=(0,a.NonNegative)(a.Int);var L;e.Anchor=(0,a.Or)(h.Anchor,(0,a.Tuple)((0,a.Or)(h.Align,h.HAlign,a.Percent),(0,a.Or)(h.Align,h.VAlign,a.Percent))),e.TextAnchor=(0,a.Or)(e.Anchor,a.Auto),e.Padding=(0,a.Or)(e.Length,(0,a.Tuple)(e.Length,e.Length),(L=e.Length,(0,a.PartialStruct)({x:L,y:L})),(0,a.Tuple)(e.Length,e.Length,e.Length,e.Length),(t=>(0,a.PartialStruct)({left:t,right:t,top:t,bottom:t}))(e.Length)),e.BorderRadius=(0,a.Or)(e.Length,(0,a.Tuple)(e.Length,e.Length,e.Length,e.Length),(0,a.PartialStruct)({top_left:e.Length,top_right:e.Length,bottom_right:e.Length,bottom_left:e.Length})),e.Index=(0,a.NonNegative)(a.Int),e.Span=(0,a.NonNegative)(a.Int);e.GridChild=t=>(0,a.Tuple)((0,a.Ref)(t),e.Index,e.Index,(0,a.Opt)(e.Span),(0,a.Opt)(e.Span)),e.GridSpacing=(0,a.Or)(e.Length,(0,a.Tuple)(e.Length,e.Length)),e.TrackAlign=(0,a.Enum)("start","center","end","auto"),e.TrackSize=a.Str,e.TrackSizing=(0,a.PartialStruct)({size:e.TrackSize,align:e.TrackAlign}),e.TrackSizingLike=(0,a.Or)(e.TrackSize,e.TrackSizing),e.TracksSizing=(0,a.Or)(e.TrackSizingLike,(0,a.List)(e.TrackSizingLike),(0,a.Mapping)(a.Int,e.TrackSizingLike))},
function _(t,e,r,n,o){n();const c=t(8),i=t(12);function s(t){if(!(0,c.isString)(t)){return{x:(()=>{const[e]=t;switch(e){case"start":case"left":return 0;case"center":return.5;case"end":case"right":return 1;default:return e}})(),y:(()=>{const[,e]=t;switch(e){case"start":case"top":return 0;case"center":return.5;case"end":case"bottom":return 1;default:return e}})()}}switch(t){case"top_left":return{x:0,y:0};case"top":case"top_center":return{x:.5,y:0};case"top_right":return{x:1,y:0};case"right":case"center_right":return{x:1,y:.5};case"bottom_right":return{x:1,y:1};case"bottom":case"bottom_center":return{x:.5,y:1};case"bottom_left":return{x:0,y:1};case"left":case"center_left":return{x:0,y:.5};case"center":case"center_center":return{x:.5,y:.5}}}r.anchor=s,r.text_anchor=function(t,e,r){return s("auto"!=t?t:[(()=>{switch(e){case"left":return"start";case"center":return"center";case"right":return"end"}})(),(()=>{switch(r){case"alphabetic":case"ideographic":case"hanging":case"middle":return"center";case"top":return"start";case"bottom":return"end"}})()])},r.padding=function(t){if((0,c.isNumber)(t))return{left:t,right:t,top:t,bottom:t};if(!(0,c.isPlainObject)(t)){if(2==t.length){const[e=0,r=0]=t;return{left:e,right:e,top:r,bottom:r}}{const[e=0,r=0,n=0,o=0]=t;return{left:e,right:r,top:n,bottom:o}}}if("x"in t||"y"in t){const{x:e=0,y:r=0}=t;return{left:e,right:e,top:r,bottom:r}}if("left"in t||"right"in t||"top"in t||"bottom"in t){const{left:e=0,right:r=0,top:n=0,bottom:o=0}=t;return{left:e,right:r,top:n,bottom:o}}(0,i.unreachable)()},r.border_radius=function(t){if((0,c.isNumber)(t))return{top_left:t,top_right:t,bottom_right:t,bottom_left:t};if((0,c.isPlainObject)(t))return{top_left:t.top_left??0,top_right:t.top_right??0,bottom_right:t.bottom_right??0,bottom_left:t.bottom_left??0};{const[e=0,r=0,n=0,o=0]=t;return{top_left:e,top_right:r,bottom_right:n,bottom_left:o}}}},
function _(t,o,e,i,n){i(),e.round_rect=function(t,o,e){let{top_left:i,top_right:n,bottom_right:c,bottom_left:h}=e;if(0!=i||0!=n||0!=c||0!=h){const{left:e,right:l,top:r,bottom:T,width:f,height:a}=o,_=Math.min(f/(i+n),a/(n+c),f/(c+h),a/(i+h));_<1&&(i*=_,n*=_,c*=_,h*=_),t.moveTo(e+i,r),t.lineTo(l-n,r),0!=n&&t.arcTo(l,r,l,r+n,n),t.lineTo(l,T-c),0!=c&&t.arcTo(l,T,l-c,T,c),t.lineTo(e+h,T),0!=h&&t.arcTo(e,T,e,T-h,h),t.lineTo(e,r+i),0!=i&&t.arcTo(e,r,e+i,r,i),t.closePath()}else{const{left:e,top:i,width:n,height:c}=o;t.rect(e,i,n,c)}}},
function _(e,s,t,a,_){a();const r=e(100),n=e(99),i=e(95),g=e(102),c=e(105),h=e(64),o=e(9),l=e(12),u=e(15),x=e(8);class y{get bbox(){return this._bbox}constructor(e,s,t,a,_={},r={},n={},i={}){this._bbox=new h.BBox,this.change=new u.Signal0(this,"change"),this.in_x_scale=e,this.in_y_scale=s,this.x_range=t,this.y_range=a,this.extra_x_ranges=_,this.extra_y_ranges=r,this.extra_x_scales=n,this.extra_y_scales=i,(0,l.assert)(e.properties.source_range.is_unset&&e.properties.target_range.is_unset),(0,l.assert)(s.properties.source_range.is_unset&&s.properties.target_range.is_unset),this._configure_scales()}_get_ranges(e,s){return new Map([...(0,o.entries)(s),["default",e]])}_get_scales(e,s,t,a){const _=new Map([...(0,o.entries)(s),["default",e]]),i=new Map;for(const[s,h]of t){if(h instanceof c.FactorRange!=e instanceof r.CategoricalScale)throw new Error(`Range ${h.type} is incompatible is Scale ${e.type}`);e instanceof n.LogScale&&h instanceof g.DataRange1d&&(h.scale_hint="log");const t=(_.get(s)??e).clone();t.setv({source_range:h,target_range:a}),i.set(s,t)}return i}_configure_frame_ranges(){const{bbox:e}=this;this._x_target=new i.Range1d({start:e.left,end:e.right}),this._y_target=new i.Range1d({start:e.bottom,end:e.top})}_configure_scales(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._x_scales=this._get_scales(this.in_x_scale,this.extra_x_scales,this._x_ranges,this._x_target),this._y_scales=this._get_scales(this.in_y_scale,this.extra_y_scales,this._y_ranges,this._y_target)}configure_scales(){this._configure_scales(),this.change.emit()}_update_scales(){this._configure_frame_ranges();for(const[,e]of this._x_scales)e.target_range=this._x_target;for(const[,e]of this._y_scales)e.target_range=this._y_target}set_geometry(e){this._bbox=e,this._update_scales()}get x_target(){return this._x_target}get y_target(){return this._y_target}get x_ranges(){return this._x_ranges}get y_ranges(){return this._y_ranges}get ranges(){return new Set([...this.x_ranges.values(),...this.y_ranges.values()])}get x_scales(){return this._x_scales}get y_scales(){return this._y_scales}get scales(){return new Set([...this.x_scales.values(),...this.y_scales.values()])}get x_scale(){return this._x_scales.get("default")}get y_scale(){return this._y_scales.get("default")}resolve_symbol(e){const s=this.bbox.resolve(e.symbol),{offset:t}=e;if((0,x.isNumber)(s))return s+t;{const{x:e,y:a}=s;return{x:e+t,y:a+t}}}}t.CartesianFrame=y,y.__name__="CartesianFrame"},
function _(t,e,i,s,a){var o;s();const n=t(1),l=t(187),r=t(188),_=t(189),h=t(190),c=n.__importStar(t(85)),d=t(20),u=t(24),b=t(170),m=t(10),f=t(9),x=t(8),g=t(177),p=t(105),v=t(173),w=t(56),k=t(12),j=t(8),y=t(64),z=t(174),M=t(21);i.LabelOverrides=(0,M.Or)((0,M.Dict)((0,M.Or)(M.Str,(0,M.Ref)(v.BaseText))),(0,M.Mapping)((0,M.Or)(M.Str,M.Float),(0,M.Or)(M.Str,(0,M.Ref)(v.BaseText))));const{abs:T}=Math;class A extends l.GuideRendererView{constructor(){super(...arguments),this._axis_label_view=null,this._major_label_views=new Map}get panel(){return this._panel}set panel(t){this._panel=new b.SidePanel(t.side,this.model.face)}get bbox(){if(null!=this.layout&&null==this.model.fixed_location)return this.layout.bbox;if(this.is_renderable){const{extents:t}=this,e=Math.round(t.tick+t.tick_label+t.axis_label);let{sx0:i,sy0:s,sx1:a,sy1:o}=this.rule_scoords;const{dimension:n,face:l}=this;return 0==n?"front"==l?s-=e:o+=e:"front"==l?i-=e:a+=e,y.BBox.from_lrtb({left:i,top:s,right:a,bottom:o})}return new y.BBox}*children(){yield*super.children(),null!=this._axis_label_view&&(yield this._axis_label_view),yield*this._major_label_views.values()}async lazy_initialize(){await super.lazy_initialize(),await this._init_axis_label(),await this._init_major_labels()}async _init_axis_label(){const{axis_label:t}=this.model;if(null!=t){const e=(0,j.isString)(t)?(0,z.parse_delimited_string)(t):t;this._axis_label_view=await(0,w.build_view)(e,{parent:this})}else this._axis_label_view=null}async _init_major_labels(){for(const[t,e]of(0,f.dict)(this.model.major_label_overrides)){const i=(0,j.isString)(e)?(0,z.parse_delimited_string)(e):e;this._major_label_views.set(t,await(0,w.build_view)(i,{parent:this}))}}update_layout(){this.layout=new b.SideLayout(this.panel,(()=>this.get_size()),!0),this.layout.on_resize((()=>this._coordinates=void 0))}get_size(){const{visible:t,fixed_location:e}=this.model;if(t&&null==e&&this.is_renderable){const{extents:t}=this;return{width:0,height:Math.round(t.tick+t.tick_label+t.axis_label)}}return{width:0,height:0}}get is_renderable(){const[t,e]=this.ranges;return t.is_valid&&e.is_valid&&t.span>0&&e.span>0}_render(){if(!this.is_renderable)return;const{tick_coords:t,extents:e}=this,i=this.layer.ctx;i.save(),this._draw_background(i,e),this._draw_rule(i,e),this._draw_major_ticks(i,e,t),this._draw_minor_ticks(i,e,t),this._draw_major_labels(i,e,t),this._draw_axis_label(i,e,t),this._paint?.(i,e,t),i.restore()}connect_signals(){super.connect_signals();const{axis_label:t,major_label_overrides:e}=this.model.properties;this.on_change(t,(async()=>{this._axis_label_view?.remove(),await this._init_axis_label()})),this.on_change(e,(async()=>{for(const t of this._major_label_views.values())t.remove();await this._init_major_labels()})),this.connect(this.model.change,(()=>this.plot_view.request_layout()))}get needs_clip(){return null!=this.model.fixed_location}_draw_background(t,e){if(!this.visuals.background_fill.doit)return;t.beginPath();const{x:i,y:s,width:a,height:o}=this.bbox;t.rect(i,s,a,o),this.visuals.background_fill.apply(t)}_draw_rule(t,e){if(!this.visuals.axis_line.doit)return;const{sx0:i,sy0:s,sx1:a,sy1:o}=this.rule_scoords;t.beginPath(),t.moveTo(i,s),t.lineTo(a,o),this.visuals.axis_line.apply(t)}_draw_major_ticks(t,e,i){const s=this.model.major_tick_in,a=this.model.major_tick_out,o=this.visuals.major_tick_line;this._draw_ticks(t,i.major,s,a,o)}_draw_minor_ticks(t,e,i){const s=this.model.minor_tick_in,a=this.model.minor_tick_out,o=this.visuals.minor_tick_line;this._draw_ticks(t,i.minor,s,a,o)}_draw_major_labels(t,e,i){const s=i.major,a=this.compute_labels(s[this.dimension]),o=this.model.major_label_orientation,n=e.tick+this.model.major_label_standoff,l=this.visuals.major_label_text;this._draw_oriented_labels(t,a,s,o,n,l)}_axis_label_extent(){if(null==this._axis_label_view)return 0;const t=this._axis_label_view.graphics(),e=this.model.axis_label_orientation;t.visuals=this.visuals.axis_label_text.values(),t.angle=this.panel.get_label_angle_heuristic(e),t.base_font_size=this.plot_view.base_font_size;const i=t.size(),s=0==this.dimension?i.height:i.width,a=this.model.axis_label_standoff;return s>0?a+s+3:0}_draw_axis_label(t,e,i){if(null==this._axis_label_view)return;const[s,a]=(()=>{const{bbox:t}=this,{side:e,face:i}=this.panel,[s]=this.ranges,{axis_label_align:a}=this.model;switch(e){case"above":case"below":{const[e,o]=(()=>{switch(a){case"start":return s.is_reversed?[t.right,"right"]:[t.left,"left"];case"center":return[t.hcenter,"center"];case"end":return s.is_reversed?[t.left,"left"]:[t.right,"right"]}})(),[n,l]="front"==i?[t.bottom,"bottom"]:[t.top,"top"];return[e,n,o,l]}case"left":case"right":{const[e,o]=(()=>{switch(a){case"start":return s.is_reversed?[t.top,"top"]:[t.bottom,"bottom"];case"center":return[t.vcenter,"center"];case"end":return s.is_reversed?[t.bottom,"bottom"]:[t.top,"top"]}})(),[n,l]="front"==i?[t.right,"right"]:[t.left,"left"];return[n,e,l,o]}}})(),[o,n]=this.normals,l=this.model.axis_label_orientation,r=e.tick+e.tick_label+this.model.axis_label_standoff,{vertical_align:_,align:h}=this.panel.get_label_text_heuristics(l),c={sx:s+o*r,sy:a+n*r,x_anchor:h,y_anchor:_},d=this._axis_label_view.graphics();d.visuals=this.visuals.axis_label_text.values(),d.angle=this.panel.get_label_angle_heuristic(l),d.base_font_size=this.plot_view.base_font_size,d.position=c,d.align=h,d.paint(t)}_draw_ticks(t,e,i,s,a){if(!a.doit)return;const[o,n]=this.scoords(e),[l,r]=this.normals,[_,h]=this.offsets,[c,d]=[l*(_-i),r*(h-i)],[u,b]=[l*(_+s),r*(h+s)];a.set_value(t),t.beginPath();for(let e=0;e<o.length;e++){const i=Math.round(o[e]+u),s=Math.round(n[e]+b),a=Math.round(o[e]+c),l=Math.round(n[e]+d);t.moveTo(i,s),t.lineTo(a,l)}t.stroke()}_draw_oriented_labels(t,e,i,s,a,o){if(!o.doit||0==e.length)return;const[n,l]=this.scoords(i),[r,_]=this.offsets,[h,c]=this.normals,d=h*(r+a),b=c*(_+a),{vertical_align:m,align:f}=this.panel.get_label_text_heuristics(s),x=this.panel.get_label_angle_heuristic(s);e.visuals=o.values(),e.angle=x,e.base_font_size=this.plot_view.base_font_size;for(let t=0;t<e.length;t++){const i=e.items[t];i.position={sx:n[t]+d,sy:l[t]+b,x_anchor:f,y_anchor:m},i instanceof g.TextBox&&(i.align=f)}const p=e.length,v=u.Indices.all_set(p),{items:w}=e,k=w.map((t=>t.bbox())),j=(()=>{const[t]=this.ranges;return t.is_reversed?0==this.dimension?(t,e)=>k[t].left-k[e].right:(t,e)=>k[e].top-k[t].bottom:0==this.dimension?(t,e)=>k[e].left-k[t].right:(t,e)=>k[t].top-k[e].bottom})(),{major_label_policy:y}=this.model,z=y.filter(v,k,j),M=[...z.ones()];if(0!=M.length){const t=this.canvas.bbox,e=e=>{const i=k[e];if(i.left<0){const t=-i.left,{position:s}=w[e];w[e].position={...s,sx:s.sx+t}}else if(i.right>t.width){const s=i.right-t.width,{position:a}=w[e];w[e].position={...a,sx:a.sx-s}}},i=e=>{const i=k[e];if(i.top<0){const t=-i.top,{position:s}=w[e];w[e].position={...s,sy:s.sy+t}}else if(i.bottom>t.height){const s=i.bottom-t.height,{position:a}=w[e];w[e].position={...a,sy:a.sy-s}}},s=M[0],a=M[M.length-1];0==this.dimension?(e(s),e(a)):(i(s),i(a))}for(const e of z){w[e].paint(t)}}_tick_extent(){const{major:t,minor:e}=this.tick_coords,i=this.dimension;return Math.max(0==t[i].length?0:this.model.major_tick_out,0==e[i].length?0:this.model.minor_tick_out)}_tick_label_extents(){const t=this.tick_coords.major,e=this.compute_labels(t[this.dimension]),i=this.model.major_label_orientation,s=this.model.major_label_standoff,a=this.visuals.major_label_text;return[this._oriented_labels_extent(e,i,s,a)]}get extents(){const t=this._tick_label_extents();return{tick:this._tick_extent(),tick_labels:t,tick_label:(0,m.sum)(t),axis_label:this._axis_label_extent()}}_oriented_labels_extent(t,e,i,s){if(0==t.length||!s.doit)return 0;const a=this.panel.get_label_angle_heuristic(e);t.visuals=s.values(),t.angle=a,t.base_font_size=this.plot_view.base_font_size;const o=t.max_size(),n=0==this.dimension?o.height:o.width;return n>0?i+n+3:0}get normals(){return this.panel.normals}get dimension(){return this.panel.dimension}compute_labels(t){const e=this.model.formatter.format_graphics(t,this),{_major_label_views:i}=this,s=new Set;for(let a=0;a<t.length;a++){const o=i.get(t[a]);null!=o&&(s.add(o),e[a]=o.graphics())}for(const t of this._major_label_views.values())s.has(t)||(t._has_finished=!0);return new g.GraphicsBoxes(e)}scoords(t){const[e,i]=t,[s,a]=this.coordinates.map_to_screen(e,i);if(null!=this.model.fixed_location)return[[...s],[...a]];{const{bbox:t}=this,{face:e}=this.panel;if(this.panel.is_vertical){const i="front"==e?t.right:t.left;return[(0,m.repeat)(i,s.length),[...a]]}{const i="front"==e?t.bottom:t.top;return[[...s],(0,m.repeat)(i,a.length)]}}}get offsets(){return[0,0]}get ranges(){const t=this.dimension,e=1-t,{ranges:i}=this.coordinates;return[i[t],i[e]]}get computed_bounds(){const[t]=this.ranges,e=this.model.bounds,i=[t.min,t.max];if("auto"==e)return[t.min,t.max];{let t,s;const[a,o]=e,[n,l]=i,{min:r,max:_}=Math;return T(a-o)>T(n-l)?(t=_(r(a,o),n),s=r(_(a,o),l)):(t=r(a,o),s=_(a,o)),[t,s]}}get rule_coords(){const t=this.dimension,e=1-t,[i]=this.ranges,[s,a]=this.computed_bounds,o=[new Array(2),new Array(2)];return o[t][0]=Math.max(s,i.min),o[t][1]=Math.min(a,i.max),o[t][0]>o[t][1]&&(o[t][0]=o[t][1]=NaN),o[e][0]=this.loc,o[e][1]=this.loc,o}get rule_scoords(){const[[t,e],[i,s]]=this.scoords(this.rule_coords);return{sx0:Math.round(t),sy0:Math.round(i),sx1:Math.round(e),sy1:Math.round(s)}}get tick_coords(){const t=this.dimension,e=1-t,[i]=this.ranges,[s,a]=this.computed_bounds,o=this.model.ticker.get_ticks(s,a,i,this.loc),n=o.major,l=o.minor,r=[[],[]],_=[[],[]],[h,c]=[i.min,i.max];for(let i=0;i<n.length;i++)n[i]<h||n[i]>c||(r[t].push(n[i]),r[e].push(this.loc));for(let i=0;i<l.length;i++)l[i]<h||l[i]>c||(_[t].push(l[i]),_[e].push(this.loc));return{major:r,minor:_}}get loc(){const{fixed_location:t}=this.model;if(null!=t){if((0,x.isNumber)(t))return t;const[,e]=this.ranges;if(e instanceof p.FactorRange)return e.synthetic(t);(0,k.unreachable)()}const[,e]=this.ranges;switch(this.panel.side){case"left":case"below":return e.start;case"right":case"above":return e.end}}get face(){return this.panel.face}serializable_state(){return{...super.serializable_state(),bbox:this.bbox}}remove(){this._axis_label_view?.remove();for(const t of this._major_label_views.values())t.remove();super.remove()}has_finished(){if(!super.has_finished())return!1;if(null!=this._axis_label_view&&!this._axis_label_view.has_finished())return!1;for(const t of this._major_label_views.values())if(!t.has_finished())return!1;return!0}}i.AxisView=A,A.__name__="AxisView";class L extends l.GuideRenderer{constructor(t){super(t)}}i.Axis=L,o=L,L.__name__="Axis",o.prototype.default_view=A,o.mixins([["axis_",c.Line],["major_tick_",c.Line],["minor_tick_",c.Line],["major_label_",c.Text],["axis_label_",c.Text],["background_",c.Fill]]),o.define((({Any:t,Int:e,Float:s,Str:a,Ref:o,Tuple:n,Or:l,Nullable:c,Auto:u,Enum:b})=>({dimension:[l(b(0,1),u),"auto"],face:[l(d.Face,u),"auto"],bounds:[l(n(s,s),u),"auto"],ticker:[o(r.Ticker)],formatter:[o(_.TickFormatter)],axis_label:[c(l(a,o(v.BaseText))),null],axis_label_standoff:[e,5],axis_label_orientation:[l(d.LabelOrientation,s),"parallel"],axis_label_align:[d.Align,"center"],major_label_standoff:[e,5],major_label_orientation:[l(d.LabelOrientation,s),"horizontal"],major_label_overrides:[i.LabelOverrides,new Map],major_label_policy:[o(h.LabelingPolicy),()=>new h.AllLabels],major_tick_in:[s,2],major_tick_out:[s,6],minor_tick_in:[s,0],minor_tick_out:[s,4],fixed_location:[c(l(s,t)),null]}))),o.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"11px",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"13px",axis_label_text_font_style:"italic",background_fill_color:null})},
function _(e,r,d,n,i){var s;n();const _=e(81);class u extends _.RendererView{}d.GuideRendererView=u,u.__name__="GuideRendererView";class c extends _.Renderer{constructor(e){super(e)}}d.GuideRenderer=c,s=c,c.__name__="GuideRenderer",s.override({level:"guide"})},
function _(c,e,n,s,o){s();const r=c(51);class t extends r.Model{constructor(c){super(c)}}n.Ticker=t,t.__name__="Ticker"},
function _(t,o,r,e,c){e();const a=t(51),m=t(177);class n extends a.Model{constructor(t){super(t)}format_graphics(t,o){return this.doFormat(t,o).map((t=>new m.TextBox({text:t})))}compute(t,o){return this.doFormat([t],o??{loc:0})[0]}v_compute(t,o){return this.doFormat(t,o??{loc:0})}}r.TickFormatter=n,n.__name__="TickFormatter"},
function _(e,n,s,t,i){var c,l;t();const r=e(51),o=e(9),a=e(40),u=e(8),d=e(24);class _ extends r.Model{constructor(e){super(e)}}s.LabelingPolicy=_,_.__name__="LabelingPolicy";class f extends _{constructor(e){super(e)}filter(e,n,s){return e}}s.AllLabels=f,f.__name__="AllLabels";class m extends _{constructor(e){super(e)}filter(e,n,s){const{min_distance:t}=this;let i=null;for(const n of e)null!=i&&s(i,n)<t?e.unset(n):i=n;return e}}s.NoOverlap=m,c=m,m.__name__="NoOverlap",c.define((({Float:e})=>({min_distance:[e,5]})));class v extends _{constructor(e){super(e)}get names(){return(0,o.keys)(this.args)}get values(){return(0,o.values)(this.args)}get func(){const e=(0,a.use_strict)(this.code);return new d.GeneratorFunction("indices","bboxes","distance",...this.names,e)}filter(e,n,s){const t=Object.create(null),i=this.func.call(t,e,n,s,...this.values);let c=i.next();if(c.done&&void 0!==c.value){const{value:n}=c;return n instanceof d.Indices?n:void 0===n?e:(0,u.isIterable)(n)?d.Indices.from_indices(e.size,n):d.Indices.all_unset(e.size)}{const n=[];do{n.push(c.value),c=i.next()}while(!c.done);return d.Indices.from_indices(e.size,n)}}}s.CustomLabelingPolicy=v,l=v,v.__name__="CustomLabelingPolicy",l.define((({Unknown:e,Str:n,Dict:s})=>({args:[s(e),{}],code:[n,""]})))},
function _(e,i,s,n,r){var t;n();const a=e(192),o=e(193),c=e(194);class _ extends a.ContinuousAxisView{}s.LinearAxisView=_,_.__name__="LinearAxisView";class u extends a.ContinuousAxis{constructor(e){super(e)}}s.LinearAxis=u,t=u,u.__name__="LinearAxis",t.prototype.default_view=_,t.override({ticker:()=>new c.BasicTicker,formatter:()=>new o.BasicTickFormatter})},
function _(s,n,i,o,u){o();const e=s(186);class t extends e.AxisView{}i.ContinuousAxisView=t,t.__name__="ContinuousAxisView";class _ extends e.Axis{constructor(s){super(s)}}i.ContinuousAxis=_,_.__name__="ContinuousAxis"},
function _(i,t,e,o,n){var r;o();const s=i(189),c=i(40);function _(i){let t="";for(const e of i)t+="-"==e?"\u2212":e;return t}e.unicode_replace=_;class a extends s.TickFormatter{constructor(i){super(i),this.last_precision=3}get scientific_limit_low(){return 10**this.power_limit_low}get scientific_limit_high(){return 10**this.power_limit_high}_need_sci(i){if(!this.use_scientific)return!1;const{scientific_limit_high:t}=this,{scientific_limit_low:e}=this,o=i.length<2?0:Math.abs(i[1]-i[0])/1e4;for(const n of i){const i=Math.abs(n);if(!(i<=o)&&(i>=t||i<=e))return!0}return!1}_format_with_precision(i,t,e){return t?i.map((i=>_(i.toExponential(e)))):i.map((i=>_((0,c.to_fixed)(i,e))))}_auto_precision(i,t){const e=new Array(i.length),o=this.last_precision<=15;i:for(let n=this.last_precision;o?n<=15:n>=1;o?n++:n--){if(t){e[0]=i[0].toExponential(n);for(let t=1;t<i.length;t++)if(e[t]==e[t-1])continue i;this.last_precision=n;break}e[0]=(0,c.to_fixed)(i[0],n);for(let t=1;t<i.length;t++)if(e[t]=(0,c.to_fixed)(i[t],n),e[t]==e[t-1])continue i;this.last_precision=n;break}return this.last_precision}doFormat(i,t){if(0==i.length)return[];const e=this._need_sci(i),o="auto"==this.precision?this._auto_precision(i,e):this.precision;return this._format_with_precision(i,e,o)}}e.BasicTickFormatter=a,r=a,a.__name__="BasicTickFormatter",r.define((({Bool:i,Int:t,Auto:e,Or:o})=>({precision:[o(t,e),"auto"],use_scientific:[i,!0],power_limit_high:[t,5],power_limit_low:[t,-3]})))},
function _(c,e,s,i,n){i();const r=c(195);class t extends r.AdaptiveTicker{constructor(c){super(c)}}s.BasicTicker=t,t.__name__="BasicTicker"},
function _(t,e,s,a,i){var n;a();const r=t(196),_=t(10),l=t(11);class h extends r.ContinuousTicker{constructor(t){super(t)}get_min_interval(){return this.min_interval}get_max_interval(){return this.max_interval??1/0}get extended_mantissas(){const t=(0,_.nth)(this.mantissas,-1)/this.base,e=(0,_.nth)(this.mantissas,0)*this.base;return[t,...this.mantissas,e]}get base_factor(){return 0==this.get_min_interval()?1:this.get_min_interval()}get_interval(t,e,s){const a=e-t,i=this.get_ideal_interval(t,e,s),n=Math.floor((0,l.log)(i/this.base_factor,this.base)),r=this.base**n*this.base_factor,h=this.extended_mantissas,m=h.map((t=>Math.abs(s-a/(t*r)))),o=h[(0,_.argmin)(m)]*r;return(0,l.clamp)(o,this.get_min_interval(),this.get_max_interval())}}s.AdaptiveTicker=h,n=h,h.__name__="AdaptiveTicker",n.define((({Float:t,List:e,Nullable:s})=>({base:[t,10],mantissas:[e(t),[1,2,5]],min_interval:[t,0],max_interval:[s(t),null]})))},
function _(t,n,i,s,e){var o;s();const r=t(188),c=t(10);class _ extends r.Ticker{constructor(t){super(t)}get_ticks(t,n,i,s){return this.get_ticks_no_defaults(t,n,s,this.desired_num_ticks)}get_ticks_no_defaults(t,n,i,s){const e=this.get_interval(t,n,s),o=Math.floor(t/e),r=Math.ceil(n/e);let _;_=isFinite(o)&&isFinite(r)?(0,c.range)(o,r+1):[];const u=_.map((t=>t*e)).filter((i=>t<=i&&i<=n)),a=this.num_minor_ticks,f=[];if(a>0&&u.length>0){const i=e/a,s=(0,c.range)(0,a).map((t=>t*i));for(const i of s.slice(1)){const s=u[0]-i;t<=s&&s<=n&&f.push(s)}for(const i of u)for(const e of s){const s=i+e;t<=s&&s<=n&&f.push(s)}}return{major:u,minor:f}}get_ideal_interval(t,n,i){return(n-t)/i}}i.ContinuousTicker=_,o=_,_.__name__="ContinuousTicker",o.define((({Int:t})=>({num_minor_ticks:[t,5],desired_num_ticks:[t,6]})))},
function _(e,i,r,c,k){c(),k("AdaptiveTicker",e(195).AdaptiveTicker),k("BasicTicker",e(194).BasicTicker),k("CategoricalTicker",e(198).CategoricalTicker),k("CompositeTicker",e(199).CompositeTicker),k("ContinuousTicker",e(196).ContinuousTicker),k("DatetimeTicker",e(200).DatetimeTicker),k("DaysTicker",e(201).DaysTicker),k("FixedTicker",e(206).FixedTicker),k("LogTicker",e(207).LogTicker),k("MercatorTicker",e(208).MercatorTicker),k("MonthsTicker",e(204).MonthsTicker),k("SingleIntervalTicker",e(202).SingleIntervalTicker),k("Ticker",e(188).Ticker),k("YearsTicker",e(205).YearsTicker),k("BinnedTicker",e(209).BinnedTicker)},
function _(t,c,o,s,e){s();const r=t(188);class i extends r.Ticker{constructor(t){super(t)}get_ticks(t,c,o,s){return{major:this._collect(o.factors,o,t,c),minor:[],tops:this._collect(o.tops??[],o,t,c),mids:this._collect(o.mids??[],o,t,c)}}_collect(t,c,o,s){const e=[];for(const r of t){const t=c.synthetic(r);t>o&&t<s&&e.push(r)}return e}}o.CategoricalTicker=i,i.__name__="CategoricalTicker"},
function _(t,e,i,s,r){var n;s();const _=t(196),a=t(10);class l extends _.ContinuousTicker{constructor(t){super(t)}get min_intervals(){return this.tickers.map((t=>t.get_min_interval()))}get max_intervals(){return this.tickers.map((t=>t.get_max_interval()))}get_min_interval(){return this.min_intervals[0]}get_max_interval(){return this.max_intervals[0]}get_best_ticker(t,e,i){const s=e-t,r=this.get_ideal_interval(t,e,i),n=[(0,a.sorted_index)(this.min_intervals,r)-1,(0,a.sorted_index)(this.max_intervals,r)],_=[this.min_intervals[n[0]],this.max_intervals[n[1]]].map((t=>Math.abs(i-s/t)));let l;if((0,a.is_empty)(_.filter((t=>!isNaN(t)))))l=this.tickers[0];else{const t=n[(0,a.argmin)(_)];l=this.tickers[t]}return l}get_interval(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)}get_ticks_no_defaults(t,e,i,s){return this.get_best_ticker(t,e,s).get_ticks_no_defaults(t,e,i,s)}}i.CompositeTicker=l,n=l,l.__name__="CompositeTicker",n.define((({List:t,Ref:e})=>({tickers:[t(e(_.ContinuousTicker)),[]]})))},
function _(e,n,i,a,s){var r;a();const t=e(10),c=e(195),m=e(199),_=e(201),k=e(204),o=e(205),T=e(203);class w extends m.CompositeTicker{constructor(e){super(e)}}i.DatetimeTicker=w,r=w,w.__name__="DatetimeTicker",r.override({num_minor_ticks:0,tickers:()=>[new c.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*T.ONE_MILLI,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:T.ONE_SECOND,max_interval:30*T.ONE_MINUTE,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:T.ONE_HOUR,max_interval:12*T.ONE_HOUR,num_minor_ticks:0}),new _.DaysTicker({days:(0,t.range)(1,32)}),new _.DaysTicker({days:(0,t.range)(1,31,3)}),new _.DaysTicker({days:[1,8,15,22]}),new _.DaysTicker({days:[1,15]}),new k.MonthsTicker({months:(0,t.range)(0,12,1)}),new k.MonthsTicker({months:(0,t.range)(0,12,2)}),new k.MonthsTicker({months:(0,t.range)(0,12,4)}),new k.MonthsTicker({months:(0,t.range)(0,12,6)}),new o.YearsTicker({})]})},
function _(t,e,n,s,o){var a;s();const i=t(202),r=t(203),c=t(10);class _ extends i.BaseSingleIntervalTicker{constructor(t){super(t)}initialize(){super.initialize();const t=this.days;t.length>1?this.interval=(t[1]-t[0])*r.ONE_DAY:this.interval=31*r.ONE_DAY}get_ticks_no_defaults(t,e,n,s){const o=function(t,e){const n=(0,r.last_month_no_later_than)(new Date(t)),s=(0,r.last_month_no_later_than)(new Date(e));s.setUTCMonth(s.getUTCMonth()+1);const o=[],a=n;for(;o.push((0,r.copy_date)(a)),a.setUTCMonth(a.getUTCMonth()+1),!(a>s););return o}(t,e),a=this.days;return{major:(0,c.concat)(o.map((t=>((t,e)=>{const n=t.getUTCMonth(),s=[];for(const o of a){const a=(0,r.copy_date)(t);a.setUTCDate(o),new Date(a.getTime()+e/2).getUTCMonth()==n&&s.push(a)}return s})(t,this.interval)))).map((t=>t.getTime())).filter((n=>t<=n&&n<=e)),minor:[]}}}n.DaysTicker=_,a=_,_.__name__="DaysTicker",a.define((({Int:t,List:e})=>({days:[e(t),[]]}))),a.override({num_minor_ticks:0})},
function _(e,n,t,r,i){var a;r();const l=e(196);class s extends l.ContinuousTicker{constructor(e){super(e)}get_interval(e,n,t){return this.interval}get_min_interval(){return this.interval}get_max_interval(){return this.interval}}t.BaseSingleIntervalTicker=s,s.__name__="BaseSingleIntervalTicker";class _ extends s{constructor(e){super(e)}}t.SingleIntervalTicker=_,a=_,_.__name__="SingleIntervalTicker",a.define((({Float:e})=>({interval:[e]})))},
function _(t,n,e,_,E){function N(t){return new Date(t.getTime())}function O(t){const n=N(t);return n.setUTCDate(1),n.setUTCHours(0),n.setUTCMinutes(0),n.setUTCSeconds(0),n.setUTCMilliseconds(0),n}_(),e.ONE_MILLI=1,e.ONE_SECOND=1e3,e.ONE_MINUTE=60*e.ONE_SECOND,e.ONE_HOUR=60*e.ONE_MINUTE,e.ONE_DAY=24*e.ONE_HOUR,e.ONE_MONTH=30*e.ONE_DAY,e.ONE_YEAR=365*e.ONE_DAY,e.copy_date=N,e.last_month_no_later_than=O,e.last_year_no_later_than=function(t){const n=O(t);return n.setUTCMonth(0),n}},
function _(t,e,n,a,s){var r;a();const i=t(202),o=t(203),l=t(10);class _ extends i.BaseSingleIntervalTicker{constructor(t){super(t)}initialize(){super.initialize();const t=this.months;t.length>1?this.interval=(t[1]-t[0])*o.ONE_MONTH:this.interval=12*o.ONE_MONTH}get_ticks_no_defaults(t,e,n,a){const s=function(t,e){const n=(0,o.last_year_no_later_than)(new Date(t)),a=(0,o.last_year_no_later_than)(new Date(e));a.setUTCFullYear(a.getUTCFullYear()+1);const s=[],r=n;for(;s.push((0,o.copy_date)(r)),r.setUTCFullYear(r.getUTCFullYear()+1),!(r>a););return s}(t,e),r=this.months;return{major:(0,l.concat)(s.map((t=>r.map((e=>{const n=(0,o.copy_date)(t);return n.setUTCMonth(e),n}))))).map((t=>t.getTime())).filter((n=>t<=n&&n<=e)),minor:[]}}}n.MonthsTicker=_,r=_,_.__name__="MonthsTicker",r.define((({Int:t,List:e})=>({months:[e(t),[]]})))},
function _(e,t,a,r,_){r();const n=e(194),s=e(202),i=e(203);class c extends s.BaseSingleIntervalTicker{constructor(e){super(e),this.interval=i.ONE_YEAR,this.basic_ticker=new n.BasicTicker({num_minor_ticks:0})}get_ticks_no_defaults(e,t,a,r){const _=(0,i.last_year_no_later_than)(new Date(e)).getUTCFullYear(),n=(0,i.last_year_no_later_than)(new Date(t)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(_,n,a,r).major.map((e=>Date.UTC(e,0,1))).filter((a=>e<=a&&a<=t)),minor:[]}}}a.YearsTicker=c,c.__name__="YearsTicker"},
function _(t,e,r,i,n){var s;i();const _=t(196);class c extends _.ContinuousTicker{constructor(t){super(t)}get_ticks_no_defaults(t,e,r,i){return{major:[...this.ticks],minor:[...this.minor_ticks]}}get_interval(t,e,r){return 0}get_min_interval(){return 0}get_max_interval(){return 0}}r.FixedTicker=c,s=c,c.__name__="FixedTicker",s.define((({Float:t,Arrayable:e})=>({ticks:[e(t),[]],minor_ticks:[e(t),[]]})))},
function _(t,o,e,s,n){var r;s();const i=t(195),a=t(10);class c extends i.AdaptiveTicker{constructor(t){super(t)}get_ticks_no_defaults(t,o,e,s){const n=this.num_minor_ticks,r=[],i=this.base,c=Math.log(t)/Math.log(i),f=Math.log(o)/Math.log(i),l=f-c;let h;if(isFinite(l)&&0!=l)if(l<2){const e=this.get_interval(t,o,s),i=Math.floor(t/e),c=Math.ceil(o/e);if(h=(0,a.range)(i,c+1).filter((t=>0!=t)).map((t=>t*e)).filter((e=>t<=e&&e<=o)),n>0&&h.length>0){const t=e/n,o=(0,a.range)(0,n).map((o=>o*t));for(const t of o.slice(1))r.push(h[0]-t);for(const t of h)for(const e of o)r.push(t+e)}}else{const t=Math.ceil(.999999*c),o=Math.floor(1.000001*f),e=Math.ceil((o-t)/9);if(h=(0,a.range)(t-1,o+1,e).map((t=>i**t)),n>0&&h.length>0){const t=i**e/n,o=(0,a.range)(1,n+1).map((o=>o*t));for(const t of o)r.push(h[0]/t);r.push(h[0]);for(const t of h)for(const e of o)r.push(t*e)}}else h=[];return{major:h.filter((e=>t<=e&&e<=o)),minor:r.filter((e=>t<=e&&e<=o))}}}e.LogTicker=c,r=c,c.__name__="LogTicker",r.override({mantissas:[1,5]})},
function _(t,o,n,s,r){var e;s();const i=t(194),c=t(20),_=t(131);class a extends i.BasicTicker{constructor(t){super(t)}get_ticks_no_defaults(t,o,n,s){if(null==this.dimension)throw new Error(`${this}.dimension wasn't configured`);return[t,o]=(0,_.clip_mercator)(t,o,this.dimension),"lon"==this.dimension?this._get_ticks_lon(t,o,n,s):this._get_ticks_lat(t,o,n,s)}_get_ticks_lon(t,o,n,s){const[r]=_.wgs84_mercator.invert(t,n),[e,i]=_.wgs84_mercator.invert(o,n),c=super.get_ticks_no_defaults(r,e,n,s),a=[];for(const t of c.major)if((0,_.in_bounds)(t,"lon")){const[o]=_.wgs84_mercator.compute(t,i);a.push(o)}const m=[];for(const t of c.minor)if((0,_.in_bounds)(t,"lon")){const[o]=_.wgs84_mercator.compute(t,i);m.push(o)}return{major:a,minor:m}}_get_ticks_lat(t,o,n,s){const[,r]=_.wgs84_mercator.invert(n,t),[e,i]=_.wgs84_mercator.invert(n,o),c=super.get_ticks_no_defaults(r,i,n,s),a=[];for(const t of c.major)if((0,_.in_bounds)(t,"lat")){const[,o]=_.wgs84_mercator.compute(e,t);a.push(o)}const m=[];for(const t of c.minor)if((0,_.in_bounds)(t,"lat")){const[,o]=_.wgs84_mercator.compute(e,t);m.push(o)}return{major:a,minor:m}}}n.MercatorTicker=a,e=a,a.__name__="MercatorTicker",e.define((({Nullable:t})=>({dimension:[t(c.LatLon),null]})))},
function _(e,n,t,r,i){var o;r();const a=e(188),s=e(210),c=e(13);class _ extends a.Ticker{constructor(e){super(e)}get_ticks(e,n,t,r){const{binning:i}=this.mapper.metrics,o=Math.max(0,(0,c.left_edge_index)(e,i)),a=Math.min((0,c.left_edge_index)(n,i)+1,i.length-1),s=[];for(let e=o;e<=a;e++)s.push(i[e]);const{num_major_ticks:_}=this,m=[],h="auto"==_?s.length:_,l=Math.max(1,Math.floor(s.length/h));for(let e=0;e<s.length;e+=l)m.push(s[e]);return{major:m,minor:[]}}}t.BinnedTicker=_,o=_,_.__name__="BinnedTicker",o.define((({Float:e,Ref:n,Or:t,Auto:r})=>({mapper:[n(s.ScanningColorMapper)],num_major_ticks:[t(e,r),8]})))},
function _(n,i,e,t,a){t();const o=n(211),_=n(13);class r extends o.ContinuousColorMapper{constructor(n){super(n)}index_to_value(n){return this._scan_data.binning[n]}value_to_index(n,i){const e=this._scan_data;return n<e.binning[0]?-1:n>e.binning[e.binning.length-1]?i:(0,_.left_edge_index)(n,e.binning)}}e.ScanningColorMapper=r,r.__name__="ScanningColorMapper"},
function _(t,o,e,n,l){var s;n();const i=t(212),c=t(214),a=t(10),h=t(8);class r extends i.ColorMapper{constructor(t){super(t),this._scan_data=null}connect_signals(){super.connect_signals();const t=()=>{for(const[t]of this.domain)this.connect(t.view.change,(()=>this.update_data())),this.connect(t.data_source.selected.change,(()=>this.update_data()))},{high:o,low:e,high_color:n,low_color:l,palette:s,nan_color:i}=this.properties;this.on_change([o,e,n,l,s,i],(()=>this.update_data())),this.connect(this.properties.domain.change,(()=>t())),t()}update_data(){const{domain:t,palette:o}=this,e=[...this._collect(t)];this._scan_data=this.scan(e,o.length),this.metrics_change.emit(),this.change.emit()}get metrics(){return null==this._scan_data&&this.update_data(),this._scan_data}*_collect(t){for(const[o,e]of t)for(const t of(0,h.isArray)(e)?e:[e]){if(o.view.properties.indices.is_unset)continue;const e=o.data_source.get_column(t);if(null==e)continue;let n=o.view.indices.select(e);const l=o.view.masked,s=o.data_source.selected.indices;let i;if(null!=l&&s.length>0?i=(0,a.intersection)([...l],s):null!=l?i=[...l]:s.length>0&&(i=s),null!=i&&(n=(0,a.map)(i,(t=>n[t]))),n.length>0&&!(0,h.isNumber)(n[0]))for(const t of n)yield*t;else yield*n}}_v_compute(t,o,e,n){const{nan_color:l}=n;let{low_color:s,high_color:i}=n;null==s&&(s=e[0]),null==i&&(i=e[e.length-1]);const{domain:c}=this,h=(0,a.is_empty)(c)?t:[...this._collect(c)];this._scan_data=this.scan(h,e.length),this.metrics_change.emit();for(let n=0,c=t.length;n<c;n++){const c=t[n];isNaN(c)?o[n]=l:o[n]=this.cmap(c,e,s,i)}}_colors(t){return{...super._colors(t),low_color:null!=this.low_color?t(this.low_color):void 0,high_color:null!=this.high_color?t(this.high_color):void 0}}cmap(t,o,e,n){const l=this.value_to_index(t,o.length);return l<0?e:l>=o.length?n:o[l]}}e.ContinuousColorMapper=r,s=r,r.__name__="ContinuousColorMapper",s.define((({Float:t,Str:o,Ref:e,Color:n,Or:l,Tuple:s,List:i,Nullable:a})=>({high:[a(t),null],low:[a(t),null],high_color:[a(n),null],low_color:[a(n),null],domain:[i(s(e(c.GlyphRenderer),l(o,i(o)))),[]]})))},
function _(t,e,r,n,o){var i;n();const _=t(213),c=t(15),a=t(24),s=t(22),l=t(27),p=t(30);function u(t){return(0,s.encode_rgba)((0,s.color2rgba)(t))}function h(t){const e=new Uint32Array(t.length);for(let r=0,n=t.length;r<n;r++)e[r]=u(t[r]);return e}r._convert_color=u,r._convert_palette=h;class g extends _.Mapper{constructor(t){super(t)}initialize(){super.initialize(),this.metrics_change=new c.Signal0(this,"metrics_change")}v_compute(t){const e=new Array(t.length);return this._v_compute(t,e,this.palette,this._colors((t=>t))),e}get rgba_mapper(){const t=this,e=h(this.palette),r=this._colors(u);return{v_compute(n){const o=(0,p.is_NDArray)(n)&&3==n.dimension?n.shape[2]:1,i=new a.ColorArray(n.length/o);return t._v_compute_uint32(n,i,e,r),new Uint8ClampedArray((0,l.to_big_endian)(i).buffer)}}}_colors(t){return{nan_color:t(this.nan_color)}}_v_compute_uint32(t,e,r,n){this._v_compute(t,e,r,n)}}r.ColorMapper=g,i=g,g.__name__="ColorMapper",i.define((({Color:t,List:e})=>({palette:[e(t)],nan_color:[t,"gray"]})))},
function _(r,e,n,s,o){s();const p=r(93);class t extends p.Transform{constructor(r){super(r)}compute(r){throw new Error("mapping single values is not supported")}}n.Mapper=t,t.__name__="Mapper"},
function _(e,t,i,s,l){var h;s();const n=e(215),a=e(216),o=e(226),_=e(227),c=e(230),d=e(231),r=e(232),p=e(218),g=e(125),y=e(233),u=e(24),m=e(13),v=e(9),w=e(56),f=e(26),b=e(105),V=e(223),z={fill:{},line:{}},G={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},x={fill:{fill_alpha:.2},line:{}},R={fill:{fill_alpha:.2},line:{}};class k extends n.DataRendererView{get glyph_view(){return this.glyph}*children(){yield*super.children(),yield this.cds_view,yield this.glyph,yield this.selection_glyph,yield this.nonselection_glyph,null!=this.hover_glyph&&(yield this.hover_glyph),yield this.muted_glyph,yield this.decimated_glyph}get data_source(){return this.model.properties.data_source}async lazy_initialize(){await super.lazy_initialize(),this.cds_view=await(0,w.build_view)(this.model.view,{parent:this});const e=this.model.glyph;this.glyph=await this.build_glyph_view(e);const t="fill"in this.glyph.visuals,i="line"in this.glyph.visuals,s={...e.attributes};function l(l){const h=(0,v.clone)(s);return t&&(0,v.extend)(h,l.fill),i&&(0,v.extend)(h,l.line),new e.constructor(h)}function h(e,t){return t instanceof p.Glyph?t:l("auto"==t?e:{fill:{},line:{}})}delete s.id;let{selection_glyph:n,nonselection_glyph:a,hover_glyph:o,muted_glyph:_}=this.model;n=h(z,n),this.selection_glyph=await this.build_glyph_view(n),a=h(x,a),this.nonselection_glyph=await this.build_glyph_view(a),null!=o&&(this.hover_glyph=await this.build_glyph_view(o)),_=h(R,_),this.muted_glyph=await this.build_glyph_view(_);const c=h(G,"auto");this.decimated_glyph=await this.build_glyph_view(c),this.selection_glyph.set_base(this.glyph),this.nonselection_glyph.set_base(this.glyph),this.hover_glyph?.set_base(this.glyph),this.muted_glyph.set_base(this.glyph),this.decimated_glyph.set_base(this.glyph),await this.set_data()}async build_glyph_view(e){return(0,w.build_view)(e,{parent:this})}remove(){this.cds_view.remove(),this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),this.hover_glyph?.remove(),this.muted_glyph.remove(),this.decimated_glyph.remove(),super.remove()}connect_signals(){super.connect_signals();const e=()=>this.request_render(),t=()=>this.update_data();this.connect(this.model.change,e),this.connect(this.glyph.model.change,t),this.connect(this.selection_glyph.model.change,t),this.connect(this.nonselection_glyph.model.change,t),null!=this.hover_glyph&&this.connect(this.hover_glyph.model.change,t),this.connect(this.muted_glyph.model.change,t),this.connect(this.decimated_glyph.model.change,t),this.connect(this.model.data_source.change,t),this.connect(this.model.data_source.streaming,t),this.connect(this.model.data_source.patching,(e=>this.update_data(e))),this.connect(this.model.data_source.selected.change,e),this.connect(this.model.data_source._select,e),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,(()=>{const{inspected:t}=this.model.data_source,i={indices:t.indices,line_indices:t.line_indices,multiline_indices:t.multiline_indices,image_indices:t.image_indices,selected_glyphs:t.selected_glyphs};(0,f.is_equal)(this._previous_inspected,i)||(this._previous_inspected=i,e())})),this.connect(this.model.properties.view.change,(async()=>{this.cds_view.remove(),this.cds_view=await(0,w.build_view)(this.model.view,{parent:this}),await t()})),this.connect(this.model.view.properties.indices.change,t),this.connect(this.model.view.properties.masked.change,(async()=>await this.set_visuals())),this.connect(this.model.properties.visible.change,(()=>this.plot_view.invalidate_dataranges=!0));const{x_ranges:i,y_ranges:s}=this.plot_view.frame;for(const[,e]of i)e instanceof b.FactorRange&&this.connect(e.invalidate_synthetic,t);for(const[,e]of s)e instanceof b.FactorRange&&this.connect(e.invalidate_synthetic,t);const{transformchange:l,exprchange:h}=this.model.glyph;this.connect(l,t),this.connect(h,t)}_update_masked_indices(){const e=this.glyph.mask_data();return this.model.view.masked=e,e}async update_data(e){await this.set_data(e),this.request_render()}async set_data(e){const t=this.model.data_source;this.all_indices=this.model.view.indices;const{all_indices:i}=this;await this.glyph.set_data(t,i,e),await this.decimated_glyph.set_data(t,i,e),await this.selection_glyph.set_data(t,i,e),await this.nonselection_glyph.set_data(t,i,e),await(this.hover_glyph?.set_data(t,i,e)),await this.muted_glyph.set_data(t,i,e),await this.set_visuals(),this._update_masked_indices();const{lod_factor:s}=this.plot_model,l=this.all_indices.count;this.decimated=new u.Indices(l);for(let e=0;e<l;e+=s)this.decimated.set(e);this.plot_view.invalidate_dataranges=!0}async set_visuals(){const e=this.model.data_source,{all_indices:t}=this;this.glyph.set_visuals(e,t),this.glyph.after_visuals(),await this.glyph.after_lazy_visuals(),this.decimated_glyph.set_visuals(e,t),this.decimated_glyph.after_visuals(),await this.decimated_glyph.after_lazy_visuals(),this.selection_glyph.set_visuals(e,t),this.selection_glyph.after_visuals(),await this.selection_glyph.after_lazy_visuals(),this.nonselection_glyph.set_visuals(e,t),this.nonselection_glyph.after_visuals(),await this.nonselection_glyph.after_lazy_visuals(),this.hover_glyph?.set_visuals(e,t),this.hover_glyph?.after_visuals(),await(this.hover_glyph?.after_lazy_visuals()),this.muted_glyph.set_visuals(e,t),this.muted_glyph.after_visuals(),await this.muted_glyph.after_lazy_visuals()}get has_webgl(){return this.glyph.has_webgl}_render(){const e=this.has_webgl;this.glyph.map_data(),this.decimated_glyph.map_data(),this.selection_glyph.map_data(),this.nonselection_glyph.map_data(),this.hover_glyph?.map_data(),this.muted_glyph.map_data();const t=[...this.all_indices];let i=[...this._update_masked_indices()];const{ctx:s}=this.layer;s.save();const{selected:l}=this.model.data_source,h=(()=>l.is_empty()?[]:this.glyph instanceof a.LineView&&l.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(i):l.indices)(),{inspected:n}=this.model.data_source;this._previous_inspected={indices:n.indices,line_indices:n.line_indices,multiline_indices:n.multiline_indices,image_indices:n.image_indices,selected_glyphs:n.selected_glyphs};const p=new Set((()=>n.is_empty()?[]:null!=n.selected_glyph?this.model.view.convert_indices_from_subset(i):n.indices.length>0?n.indices:Object.keys(n.multiline_indices).map((e=>parseInt(e))))()),g=(0,m.filter)(i,(e=>p.has(t[e]))),{lod_threshold:y}=this.plot_model;let u,v,w;if(null!=this.model.document&&this.model.document.interactive_duration()>0&&!e&&null!=y&&t.length>y?(i=[...this.decimated],u=this.decimated_glyph,v=this.decimated_glyph,w=this.selection_glyph):(u=this.model.muted?this.muted_glyph:this.glyph,v=this.nonselection_glyph,w=this.selection_glyph),null!=this.hover_glyph&&0!=g.length){const e=new Set(i);for(const t of g)e.delete(t);i=[...e]}if(0==h.length)if(this.glyph instanceof a.LineView)null!=this.hover_glyph&&0!=g.length?this.hover_glyph.render(s,this.model.view.convert_indices_from_subset(g)):u.render(s,t);else if(this.glyph instanceof o.PatchView||this.glyph instanceof c.HAreaView||this.glyph instanceof r.VAreaView||this.glyph instanceof d.VAreaStepView||this.glyph instanceof _.HAreaStepView)if(0==n.selected_glyphs.length||null==this.hover_glyph)u.render(s,t);else for(const e of n.selected_glyphs)e==this.glyph.model&&this.hover_glyph.render(s,t);else u.render(s,i),null!=this.hover_glyph&&0!=g.length&&this.hover_glyph.render(s,g);else{const e=new Set(h),l=new Array,n=new Array;if(this.glyph instanceof a.LineView)for(const i of t)e.has(i)?l.push(i):n.push(i);else for(const s of i)e.has(t[s])?l.push(s):n.push(s);v.render(s,n),w.render(s,l),null!=this.hover_glyph&&(this.glyph instanceof a.LineView?this.hover_glyph.render(s,this.model.view.convert_indices_from_subset(g)):this.hover_glyph.render(s,g))}s.restore()}get_reference_point(e,t){if(null!=e){const i=this.model.data_source.get_column(e);if(null!=i)for(const[e,s]of this.model.view.indices_map)if(i[e]==t)return s}return 0}draw_legend(e,t,i,s,l,h,n,a){if(0==this.glyph.data_size)return;const o=(()=>{if(null==a)return this.get_reference_point(h,n);{const{indices_map:e}=this.model.view;return e.get(a)}})();null!=o&&this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:s,y1:l},o)}hit_test(e){if(!this.model.visible)return null;const t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)}}i.GlyphRendererView=k,k.__name__="GlyphRendererView";class S extends n.DataRenderer{constructor(e){super(e)}get_selection_manager(){return this.data_source.selection_manager}add_decoration(e,t){const i=new V.Decoration({marking:e,node:t}),s=[this.glyph,this.selection_glyph,this.nonselection_glyph,this.hover_glyph,this.muted_glyph];for(const e of s)e instanceof p.Glyph&&(e.decorations=[...e.decorations,i]);return i}}i.GlyphRenderer=S,h=S,S.__name__="GlyphRenderer",h.prototype.default_view=k,h.define((({Bool:e,Auto:t,Or:i,Ref:s,Null:l,Nullable:h})=>({data_source:[s(g.ColumnarDataSource)],view:[s(y.CDSView),()=>new y.CDSView],glyph:[s(p.Glyph)],hover_glyph:[h(s(p.Glyph)),null],nonselection_glyph:[i(s(p.Glyph),t,l),"auto"],selection_glyph:[i(s(p.Glyph),t,l),"auto"],muted_glyph:[i(s(p.Glyph),t,l),"auto"],muted:[e,!1]})))},
function _(e,r,t,n,s){var a,o;n();const _=e(81),i=e(102);class c extends _.RendererView{constructor(){super(...arguments),this[a]=!0}get xscale(){return this.coordinates.x_scale}get yscale(){return this.coordinates.y_scale}bounds(){return this.glyph_view.bounds()}log_bounds(){return this.glyph_view.log_bounds()}}t.DataRendererView=c,a=i.auto_ranged,c.__name__="DataRendererView";class d extends _.Renderer{constructor(e){super(e)}get selection_manager(){return this.get_selection_manager()}}t.DataRenderer=d,o=d,d.__name__="DataRenderer",o.override({level:"glyph"})},
function _(e,t,i,n,s){var l;n();const o=e(1),r=e(217),_=e(224),h=o.__importStar(e(85)),c=o.__importStar(e(225)),a=e(127);class d extends r.XYGlyphView{async load_glglyph(){const{LineGL:t}=await Promise.resolve().then((()=>o.__importStar(e(558))));return t}_render(e,t,i){const{sx:n,sy:s}={...this,...i},l=this.parent.nonselection_glyph==this;let o=null;const r=e=>null!=o&&e-o!=1;let _=!0;e.beginPath();for(const i of t){const t=n[i],h=s[i];l&&!_&&null!=o&&i-o>1&&isFinite(n[o+1]+s[o+1])&&e.lineTo(n[o+1],s[o+1]),isFinite(t+h)?(_||r(i)?(l&&i>0&&isFinite(n[i-1]+s[i-1])?(e.moveTo(n[i-1],s[i-1]),e.lineTo(t,h)):e.moveTo(t,h),_=!1):e.lineTo(t,h),o=i):_=!0}if(l&&!_&&null!=o){const t=n.length;o<t-1&&isFinite(n[o+1]+s[o+1])&&e.lineTo(n[o+1],s[o+1])}this.visuals.line.set_value(e),e.stroke()}_hit_point(e){const t=new a.Selection,i={x:e.sx,y:e.sy};let n=9999;const s=Math.max(2,this.line_width.value/2);for(let e=0,l=this.sx.length-1;e<l;e++){const l={x:this.sx[e],y:this.sy[e]},o={x:this.sx[e+1],y:this.sy[e+1]},r=c.dist_to_segment(i,l,o);r<s&&r<n&&(n=r,t.add_to_selected_glyphs(this.model),t.view=this,t.line_indices=[e])}return t}_hit_span(e){const{sx:t,sy:i}=e;let n,s;"v"==e.direction?(n=this.renderer.yscale.invert(i),s=this.y):(n=this.renderer.xscale.invert(t),s=this.x);const l=[];for(let e=0,t=s.length-1;e<t;e++){const t=s[e],i=s[e+1];(t<=n&&n<=i||i<=n&&n<=t)&&l.push(e)}const o=new a.Selection;return 0!=l.length&&(o.add_to_selected_glyphs(this.model),o.view=this,o.line_indices=l),o}get_interpolation_hit(e,t){const[i,n,s,l]=[this.x[e],this.y[e],this.x[e+1],this.y[e+1]];return(0,_.line_interpolation)(this.renderer,t,i,n,s,l)}draw_legend_for_index(e,t,i){(0,_.generic_line_scalar_legend)(this.visuals,e,t)}}i.LineView=d,d.__name__="LineView";class y extends r.XYGlyph{constructor(e){super(e)}}i.Line=y,l=y,y.__name__="Line",l.prototype.default_view=d,l.mixins(h.LineScalar)},
function _(e,t,s,i,n){var _;i();const a=e(1),o=e(131),c=a.__importStar(e(18)),p=e(218);class r extends p.GlyphView{_project_data(){o.inplace.project_xy(this.x,this.y)}_index_data(e){const{x:t,y:s,data_size:i}=this;for(let n=0;n<i;n++){const i=t[n],_=s[n];e.add_point(i,_)}}scenterxy(e){return[this.sx[e],this.sy[e]]}}s.XYGlyphView=r,r.__name__="XYGlyphView";class d extends p.Glyph{constructor(e){super(e)}}s.XYGlyph=d,_=d,d.__name__="XYGlyph",_.define((({})=>({x:[c.XCoordinateSpec,{field:"x"}],y:[c.YCoordinateSpec,{field:"y"}]})))},
function _(e,t,i,s,n){var r;s();const a=e(1),_=a.__importStar(e(18)),o=a.__importStar(e(64)),h=a.__importStar(e(82)),l=a.__importStar(e(39)),c=e(29),d=e(58),u=e(51),f=e(56),p=e(19),y=e(24),g=e(219),m=e(13),b=e(26),w=e(220),x=e(12),S=e(105),v=e(127),z=e(223),{abs:q,ceil:$}=Math;i.inherit=Symbol("inherit");class C extends d.View{constructor(){super(...arguments),this._index=null,this._data_size=null,this._nohit_warned=new Set,this.decorations=new Map,this._base=null}get renderer(){return this.parent}get has_webgl(){return null!=this.glglyph}get index(){const{_index:e}=this;if(null!=e)return e;throw new Error(`${this}.index_data() wasn't called`)}get data_size(){const{base:e}=this;if(null!=e)return e.data_size;{const{_data_size:e}=this;if(null!=e)return e;throw new Error(`${this}.set_data() wasn't called`)}}initialize(){super.initialize(),this.visuals=new h.Visuals(this)}*children(){yield*super.children(),yield*this.decorations.values()}async lazy_initialize(){await super.lazy_initialize(),await(0,f.build_views)(this.decorations,this.model.decorations,{parent:this.parent});const{webgl:e}=this.canvas;if(null!=e&&null!=this.load_glglyph){const t=await this.load_glglyph();this.glglyph=new t(e.regl_wrapper,this)}}request_render(){this.parent.request_render()}get canvas(){return this.renderer.parent.canvas_view}render(e,t,i){if(null!=this.glglyph)this.glglyph.render(e,t,this.base??this);else{if(null!=this.canvas.webgl&&c.settings.force_webgl)throw new Error(`${this} doesn't support webgl rendering`);this._render(e,t,i)}}has_finished(){return!0}notify_finished(){this.renderer.notify_finished()}_bounds(e){return e}bounds(){return this._bounds(this.index.bbox)}log_bounds(){const{x0:e,x1:t}=this.index.bounds(o.positive_x()),{y0:i,y1:s}=this.index.bounds(o.positive_y());return this._bounds({x0:e,y0:i,x1:t,y1:s})}get_anchor_point(e,t,[i,s]){switch(e){case"center":case"center_center":{const[e,n]=this.scenterxy(t,i,s);return{x:e,y:n}}default:return null}}sdist(e,t,i,s="edge",n=!1){const r=t.length,a=new y.ScreenArray(r),_=e.s_compute;if("center"==s)for(let e=0;e<r;e++){const s=t[e],n=i.get(e)/2,r=_(s-n),o=_(s+n);a[e]=q(o-r)}else for(let e=0;e<r;e++){const s=t[e],n=_(s),r=_(s+i.get(e));a[e]=q(r-n)}return n&&(0,m.inplace_map)(a,(e=>$(e))),a}draw_legend_for_index(e,t,i){}hit_test(e){const t=(()=>{switch(e.type){case"point":return this._hit_point?.(e);case"span":return this._hit_span?.(e);case"rect":return this._hit_rect?.(e);case"poly":return this._hit_poly?.(e)}})();return null!=t?t:(this._nohit_warned.has(e.type)||(p.logger.debug(`'${e.type}' selection not available for ${this.model.type}`),this._nohit_warned.add(e.type)),null)}_hit_rect_against_index(e){const{sx0:t,sx1:i,sy0:s,sy1:n}=e,[r,a]=this.renderer.coordinates.x_scale.r_invert(t,i),[_,o]=this.renderer.coordinates.y_scale.r_invert(s,n),h=[...this.index.indices({x0:r,x1:a,y0:_,y1:o})];return new v.Selection({indices:h})}_project_data(){}*_iter_visuals(){for(const e of this.visuals)for(const t of e)(t instanceof _.VectorSpec||t instanceof _.ScalarSpec)&&(yield t)}get base(){return this._base}set_base(e){e!=this&&e instanceof this.constructor?this._base=e:this._base=null}_define_or_inherit_attr(e,t){const s=t();s===i.inherit?this._inherit_attr(e):this._define_attr(e,s)}_define_attr(e,t){Object.defineProperty(this,e,{configurable:!0,enumerable:!0,value:t}),this._define_inherited(e,!1)}_inherit_attr(e){const{base:t}=this;(0,x.assert)(null!=t),this._inherit_from(e,t)}_inherit_from(e,t){Object.defineProperty(this,e,{configurable:!0,enumerable:!0,get:()=>t[e]}),this._define_inherited(e,!0)}_define_inherited(e,t){Object.defineProperty(this,`inherited_${e}`,{configurable:!0,enumerable:!0,value:t})}_can_inherit_from(e,t){const i=t.model.property(e.attr),s=e.get_value(),n=i.get_value();try{return(0,b.is_equal)(s,n)}catch(e){if(e instanceof b.EqNotImplemented)return!1;throw e}}_is_inherited(e){return this[`inherited_${e.attr}`]}set_visuals(e,t){for(const i of this._iter_visuals()){const{base:s}=this;if(null!=s&&this._can_inherit_from(i,s))this._inherit_from(i.attr,s);else{const s=i.uniform(e).select(t);this._define_attr(i.attr,s)}}for(const e of this.visuals)e.update();this.glglyph?.set_visuals_changed()}_transform_array(e,t){const{x_source:i,y_source:s}=this.renderer.coordinates,n="x"==e.dimension?i:s;if(n instanceof S.FactorRange)if(e instanceof _.CoordinateSpec)t=n.v_synthetic(t);else if(e instanceof _.CoordinateSeqSpec)for(let e=0;e<t.length;e++)t[e]=n.v_synthetic(t[e]);else _.CoordinateSeqSeqSeqSpec;let r;return r=e instanceof _.CoordinateSeqSpec?g.RaggedArray.from(t,Float64Array):(_.CoordinateSeqSeqSeqSpec,t),r}async set_data(e,t,i){const s=new Set(this._iter_visuals()),{base:n}=this;this._data_size=t.count;for(const i of this.model)if((i instanceof _.VectorSpec||i instanceof _.ScalarSpec)&&!s.has(i))if(null!=n&&this._can_inherit_from(i,n))this._inherit_from(i.attr,n),(i instanceof _.DistanceSpec||i instanceof _.ScreenSizeSpec)&&this._inherit_from(`max_${i.attr}`,n);else if(i instanceof _.BaseCoordinateSpec){const s=this._transform_array(i,t.select(i.array(e)));this._define_attr(i.attr,s)}else{const s=i.uniform(e).select(t);if(this._define_attr(i.attr,s),i instanceof _.DistanceSpec||i instanceof _.ScreenSizeSpec){const e=l.max(s);this._define_attr(`max_${i.attr}`,e)}}this.renderer.plot_view.model.use_map&&this._project_data(),this._set_data(i??null),await this._set_lazy_data(i??null);for(const i of this.decorations.values())i.marking.set_data(e,t);this.glglyph?.set_data_changed(),null==n&&this.index_data()}_set_data(e){}async _set_lazy_data(e){}after_visuals(){}async after_lazy_visuals(){}get _index_size(){return this.data_size}index_data(){const e=new w.SpatialIndex(this._index_size);this._index_data(e),e.finish(),this._index=e}mask_data(){return null==this._mask_data?y.Indices.all_set(this.data_size):this._mask_data()}map_data(){const{x_scale:e,y_scale:t}=this.renderer.coordinates,{base:i}=this,s=i=>{const s="x"==i.dimension?e:t,n=this[i.attr];return n instanceof g.RaggedArray?new g.RaggedArray(n.offsets,s.v_compute(n.data)):s.v_compute(n)};for(const e of this.model)if(e instanceof _.BaseCoordinateSpec)if(null!=i&&this._is_inherited(e))this._inherit_from(`s${e.attr}`,i);else{const t=s(e);this._define_attr(`s${e.attr}`,t)}this._map_data(),this.glglyph?.set_data_mapped()}_map_data(){}}i.GlyphView=C,C.__name__="GlyphView";class V extends u.Model{constructor(e){super(e)}}i.Glyph=V,r=V,V.__name__="Glyph",r.define((({List:e,Ref:t})=>({decorations:[e(t(z.Decoration)),[]]})))},
function _(t,s,e,r,a){var n;r();const o=t(26),h=t(12);class i{constructor(t,s){this.offsets=t,this.data=s}[(n=Symbol.toStringTag,o.equals)](t,s){return s.arrays(this.offsets,t.offsets)&&s.arrays(this.data,t.data)}get length(){return this.offsets.length}clone(){return new i(this.offsets.slice(),this.data.slice())}static from(t,s){const e=t.length;let r=0;const a=(()=>{const s=new Uint32Array(e);for(let a=0;a<e;a++){const e=t[a].length;s[a]=r,r+=e}return r<256?new Uint8Array(s):r<65536?new Uint16Array(s):s})(),n=new s(r);for(let s=0;s<e;s++)n.set(t[s],a[s]);return new i(a,n)}*[Symbol.iterator](){const{offsets:t,length:s}=this;for(let e=0;e<s;e++)yield this.data.subarray(t[e],t[e+1])}_check_bounds(t){(0,h.assert)(0<=t&&t<this.length,`Out of bounds: 0 <= ${t} < ${this.length}`)}get(t){this._check_bounds(t);const{offsets:s}=this;return this.data.subarray(s[t],s[t+1])}set(t,s){this._check_bounds(t),this.data.set(s,this.offsets[t])}}e.RaggedArray=i,i.__name__="RaggedArray",i[n]="RaggedArray"},
function _(t,i,e,n,s){n();const d=t(1).__importDefault(t(221)),o=t(24),x=t(64);function h(t,i){let e=0,n=i.length-1;for(;e<n;){const s=e+n>>1;i[s]>t?n=s:e=s+1}return i[e]}class r extends d.default{get boxes(){return this._boxes}search_indices(t,i,e,n){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let s=this._boxes.length-4;const d=[],x=new o.Indices(this.numItems);for(;void 0!==s;){const o=Math.min(s+4*this.nodeSize,h(s,this._levelBounds));for(let h=s;h<o;h+=4){const o=0|this._indices[h>>2],r=this._boxes[h+0],_=this._boxes[h+1],a=this._boxes[h+2],c=this._boxes[h+3];e<r||n<_||t>a||i>c||(s<4*this.numItems?x.set(o):d.push(o))}s=d.pop()}return x}}r.__name__="_FlatBush";class _{constructor(t){this.index=null,t>0&&(this.index=new r(t))}add_rect(t,i,e,n){isFinite(t+i+e+n)?this.index?.add(t,i,e,n):this.add_empty()}add_point(t,i){isFinite(t+i)?this.index?.add(t,i,t,i):this.add_empty()}add_empty(){this.index?.add(1/0,1/0,-1/0,-1/0)}finish(){this.index?.finish()}_normalize(t){let{x0:i,y0:e,x1:n,y1:s}=t;return i>n&&([i,n]=[n,i]),e>s&&([e,s]=[s,e]),{x0:i,y0:e,x1:n,y1:s}}get bbox(){if(null==this.index)return(0,x.empty)();{const{minX:t,minY:i,maxX:e,maxY:n}=this.index;return{x0:t,y0:i,x1:e,y1:n}}}indices(t){if(null==this.index)return new o.Indices(0);{const{x0:i,y0:e,x1:n,y1:s}=this._normalize(t);return this.index.search_indices(i,e,n,s)}}bounds(t){const i=(0,x.empty)();if(null==this.index)return i;const{boxes:e}=this.index;for(const n of this.indices(t)){const s=e[4*n+0],d=e[4*n+1],o=e[4*n+2],x=e[4*n+3];s>=t.x0&&s<i.x0&&(i.x0=s),o<=t.x1&&o>i.x1&&(i.x1=o),d>=t.y0&&d<i.y0&&(i.y0=d),x<=t.y1&&x>i.y1&&(i.y1=x)}return i}}e.SpatialIndex=_,_.__name__="SpatialIndex"},
function _(t,i,s,e,n){e();const h=t(1).__importDefault(t(222)),r=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class o{static from(t,i=0){if(i%8!=0)throw new Error("byteOffset must be 8-byte aligned.");if(!t||void 0===t.byteLength||t.buffer)throw new Error("Data must be an instance of ArrayBuffer or SharedArrayBuffer.");const[s,e]=new Uint8Array(t,i+0,2);if(251!==s)throw new Error("Data does not appear to be in a Flatbush format.");const n=e>>4;if(3!==n)throw new Error(`Got v${n} data when expected v3.`);const h=r[15&e];if(!h)throw new Error("Unrecognized array type.");const[a]=new Uint16Array(t,i+2,1),[d]=new Uint32Array(t,i+4,1);return new o(d,a,h,void 0,t,i)}constructor(t,i=16,s=Float64Array,e=ArrayBuffer,n,o=0){if(void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error(`Unexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+i,2),65535),this.byteOffset=o;let a=t,d=a;this._levelBounds=[4*a];do{a=Math.ceil(a/this.nodeSize),d+=a,this._levelBounds.push(4*d)}while(1!==a);this.ArrayType=s,this.IndexArrayType=d<16384?Uint16Array:Uint32Array;const _=r.indexOf(this.ArrayType),f=4*d*this.ArrayType.BYTES_PER_ELEMENT;if(_<0)throw new Error(`Unexpected typed array class: ${s}.`);n&&void 0!==n.byteLength&&!n.buffer?(this.data=n,this._boxes=new this.ArrayType(this.data,o+8,4*d),this._indices=new this.IndexArrayType(this.data,o+8+f,d),this._pos=4*d,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new e(8+f+d*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*d),this._indices=new this.IndexArrayType(this.data,8+f,d),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+_]),new Uint16Array(this.data,2,1)[0]=i,new Uint32Array(this.data,4,1)[0]=t),this._queue=new h.default}add(t,i,s=t,e=i){const n=this._pos>>2,h=this._boxes;return this._indices[n]=n,h[this._pos++]=t,h[this._pos++]=i,h[this._pos++]=s,h[this._pos++]=e,t<this.minX&&(this.minX=t),i<this.minY&&(this.minY=i),s>this.maxX&&(this.maxX=s),e>this.maxY&&(this.maxY=e),n}finish(){if(this._pos>>2!==this.numItems)throw new Error(`Added ${this._pos>>2} items when expected ${this.numItems}.`);const t=this._boxes;if(this.numItems<=this.nodeSize)return t[this._pos++]=this.minX,t[this._pos++]=this.minY,t[this._pos++]=this.maxX,void(t[this._pos++]=this.maxY);const i=this.maxX-this.minX||1,s=this.maxY-this.minY||1,e=new Uint32Array(this.numItems);for(let n=0,h=0;n<this.numItems;n++){const r=t[h++],o=t[h++],a=t[h++],d=t[h++],_=Math.floor(65535*((r+a)/2-this.minX)/i),f=Math.floor(65535*((o+d)/2-this.minY)/s);e[n]=m(_,f)}_(e,t,this._indices,0,this.numItems-1,this.nodeSize);for(let i=0,s=0;i<this._levelBounds.length-1;i++){const e=this._levelBounds[i];for(;s<e;){const i=s;let n=t[s++],h=t[s++],r=t[s++],o=t[s++];for(let i=1;i<this.nodeSize&&s<e;i++)n=Math.min(n,t[s++]),h=Math.min(h,t[s++]),r=Math.max(r,t[s++]),o=Math.max(o,t[s++]);this._indices[this._pos>>2]=i,t[this._pos++]=n,t[this._pos++]=h,t[this._pos++]=r,t[this._pos++]=o}}}search(t,i,s,e,n){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let h=this._boxes.length-4;const r=[],o=[];for(;void 0!==h;){const a=Math.min(h+4*this.nodeSize,d(h,this._levelBounds));for(let d=h;d<a;d+=4){if(s<this._boxes[d])continue;if(e<this._boxes[d+1])continue;if(t>this._boxes[d+2])continue;if(i>this._boxes[d+3])continue;const a=0|this._indices[d>>2];h>=4*this.numItems?r.push(a):(void 0===n||n(a))&&o.push(a)}h=r.pop()}return o}neighbors(t,i,s=1/0,e=1/0,n){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let h=this._boxes.length-4;const r=this._queue,o=[],_=e*e;t:for(;void 0!==h;){const e=Math.min(h+4*this.nodeSize,d(h,this._levelBounds));for(let s=h;s<e;s+=4){const e=0|this._indices[s>>2],o=a(t,this._boxes[s],this._boxes[s+2]),d=a(i,this._boxes[s+1],this._boxes[s+3]),f=o*o+d*d;f>_||(h>=4*this.numItems?r.push(e<<1,f):(void 0===n||n(e))&&r.push(1+(e<<1),f))}for(;r.length&&1&r.peek();){if(r.peekValue()>_)break t;if(o.push(r.pop()>>1),o.length===s)break t}h=r.length?r.pop()>>1:void 0}return r.clear(),o}}function a(t,i,s){return t<i?i-t:t<=s?0:t-s}function d(t,i){let s=0,e=i.length-1;for(;s<e;){const n=s+e>>1;i[n]>t?e=n:s=n+1}return i[s]}function _(t,i,s,e,n,h){if(Math.floor(e/h)>=Math.floor(n/h))return;const r=t[e+n>>1];let o=e-1,a=n+1;for(;;){do{o++}while(t[o]<r);do{a--}while(t[a]>r);if(o>=a)break;f(t,i,s,o,a)}_(t,i,s,e,a,h),_(t,i,s,a+1,n,h)}function f(t,i,s,e,n){const h=t[e];t[e]=t[n],t[n]=h;const r=4*e,o=4*n,a=i[r],d=i[r+1],_=i[r+2],f=i[r+3];i[r]=i[o],i[r+1]=i[o+1],i[r+2]=i[o+2],i[r+3]=i[o+3],i[o]=a,i[o+1]=d,i[o+2]=_,i[o+3]=f;const m=s[e];s[e]=s[n],s[n]=m}function m(t,i){let s=t^i,e=65535^s,n=65535^(t|i),h=t&(65535^i),r=s|e>>1,o=s>>1^s,a=n>>1^e&h>>1^n,d=s&n>>1^h>>1^h;s=r,e=o,n=a,h=d,r=s&s>>2^e&e>>2,o=s&e>>2^e&(s^e)>>2,a^=s&n>>2^e&h>>2,d^=e&n>>2^(s^e)&h>>2,s=r,e=o,n=a,h=d,r=s&s>>4^e&e>>4,o=s&e>>4^e&(s^e)>>4,a^=s&n>>4^e&h>>4,d^=e&n>>4^(s^e)&h>>4,s=r,e=o,n=a,h=d,a^=s&n>>8^e&h>>8,d^=e&n>>8^(s^e)&h>>8,s=a^a>>1,e=d^d>>1;let _=t^i,f=e|65535^(_|s);return _=16711935&(_|_<<8),_=252645135&(_|_<<4),_=858993459&(_|_<<2),_=1431655765&(_|_<<1),f=16711935&(f|f<<8),f=252645135&(f|f<<4),f=858993459&(f|f<<2),f=1431655765&(f|f<<1),(f<<1|_)>>>0}s.default=o},
function _(s,t,i,h,e){h();i.default=class{constructor(){this.ids=[],this.values=[],this.length=0}clear(){this.length=0}push(s,t){let i=this.length++;for(;i>0;){const s=i-1>>1,h=this.values[s];if(t>=h)break;this.ids[i]=this.ids[s],this.values[i]=h,i=s}this.ids[i]=s,this.values[i]=t}pop(){if(0===this.length)return;const s=this.ids[0];if(this.length--,this.length>0){const s=this.ids[0]=this.ids[this.length],t=this.values[0]=this.values[this.length],i=this.length>>1;let h=0;for(;h<i;){let s=1+(h<<1);const i=s+1;let e=this.ids[s],l=this.values[s];const n=this.values[i];if(i<this.length&&n<l&&(s=i,e=this.ids[i],l=n),l>=t)break;this.ids[h]=e,this.values[h]=l,h=s}this.ids[h]=s,this.values[h]=t}return s}peek(){if(0!==this.length)return this.ids[0]}peekValue(){if(0!==this.length)return this.values[0]}shrink(){this.ids.length=this.values.length=this.length}}},
function _(e,i,n,a,t){var r;a();const o=e(166),s=e(51),d=e(58),l=e(56);class c extends d.View{*children(){yield*super.children(),yield this.marking}async lazy_initialize(){await super.lazy_initialize(),this.marking=await(0,l.build_view)(this.model.marking,{parent:this.parent})}}n.DecorationView=c,c.__name__="DecorationView";class _ extends s.Model{constructor(e){super(e)}}n.Decoration=_,r=_,_.__name__="Decoration",r.prototype.default_view=c,r.define((({Enum:e,Ref:i})=>({marking:[i(o.Marking)],node:[e("start","middle","end")]})))},
function _(e,n,t,a,i){a();const l=e(1).__importStar(e(225));function r(e,n,{x0:t,x1:a,y0:i,y1:l},r){n.save(),n.beginPath(),n.moveTo(t,(i+l)/2),n.lineTo(a,(i+l)/2),e.line.apply(n,r),n.restore()}function c(e,n,{x0:t,x1:a,y0:i,y1:l},r){const c=.1*Math.abs(a-t),_=.1*Math.abs(l-i),o=t+c,s=a-c,y=i+_,p=l-_;n.beginPath(),n.rect(o,y,s-o,p-y),e.fill.apply(n,r),e.hatch?.apply(n,r),e.line?.apply(n,r)}t.generic_line_scalar_legend=function(e,n,{x0:t,x1:a,y0:i,y1:l}){n.save(),n.beginPath(),n.moveTo(t,(i+l)/2),n.lineTo(a,(i+l)/2),e.line.apply(n),n.restore()},t.generic_line_vector_legend=r,t.generic_line_legend=r,t.generic_area_scalar_legend=function(e,n,{x0:t,x1:a,y0:i,y1:l}){const r=.1*Math.abs(a-t),c=.1*Math.abs(l-i),_=t+r,o=a-r,s=i+c,y=l-c;n.beginPath(),n.rect(_,s,o-_,y-s),e.fill.apply(n),e.hatch?.apply(n),e.line?.apply(n)},t.generic_area_vector_legend=c,t.generic_area_legend=c,t.line_interpolation=function(e,n,t,a,i,r){const{sx:c,sy:_}=n;let o,s,y,p;"point"==n.type?([y,p]=e.yscale.r_invert(_-1,_+1),[o,s]=e.xscale.r_invert(c-1,c+1)):"v"==n.direction?([y,p]=e.yscale.r_invert(_,_),[o,s]=[Math.min(t-1,i-1),Math.max(t+1,i+1)]):([o,s]=e.xscale.r_invert(c,c),[y,p]=[Math.min(a-1,r-1),Math.max(a+1,r+1)]);const{x:g,y:h}=l.check_2_segments_intersect(o,y,s,p,t,a,i,r);return[g,h]}},
function _(t,n,e,i,r){function s(t,n){return(t.x-n.x)**2+(t.y-n.y)**2}function o(t,n,e){const i=s(n,e);if(0==i)return s(t,n);const r=((t.x-n.x)*(e.x-n.x)+(t.y-n.y)*(e.y-n.y))/i;if(r<0)return s(t,n);if(r>1)return s(t,e);return s(t,{x:n.x+r*(e.x-n.x),y:n.y+r*(e.y-n.y)})}i(),e.point_in_poly=function(t,n,e,i){let r=!1,s=e[e.length-1],o=i[i.length-1];for(let u=0;u<e.length;u++){const c=e[u],_=i[u];o<n!=_<n&&s+(n-o)/(_-o)*(c-s)<t&&(r=!r),s=c,o=_}return r},e.point_in_ellipse=function(t,n,e,i,r,s,o){return((Math.cos(e)/r)**2+(Math.sin(e)/i)**2)*(t-s)**2+2*Math.cos(e)*Math.sin(e)*((1/r)**2-(1/i)**2)*(t-s)*(n-o)+((Math.cos(e)/i)**2+(Math.sin(e)/r)**2)*(n-o)**2<=1},e.dist_2_pts=s,e.dist_to_segment_squared=o,e.dist_to_segment=function(t,n,e){return Math.sqrt(o(t,n,e))},e.check_2_segments_intersect=function(t,n,e,i,r,s,o,u){const c=(u-s)*(e-t)-(o-r)*(i-n);if(0==c)return{hit:!1,x:null,y:null};{let _=n-s,h=t-r;const l=(e-t)*_-(i-n)*h;_=((o-r)*_-(u-s)*h)/c,h=l/c;return{hit:_>0&&_<1&&h>0&&h<1,x:t+_*(e-t),y:n+_*(i-n)}}}},
function _(t,s,e,i,a){var l;i();const n=t(1),_=t(217),o=t(224),c=n.__importStar(t(225)),h=n.__importStar(t(85)),r=t(127);class p extends _.XYGlyphView{_render(t,s,e){const{sx:i,sy:a}={...this,...e};let l=!0;t.beginPath();for(const e of s){const s=i[e],n=a[e];isFinite(s+n)?l?(t.moveTo(s,n),l=!1):t.lineTo(s,n):(t.closePath(),l=!0)}t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t),this.visuals.line.apply(t)}draw_legend_for_index(t,s,e){(0,o.generic_area_scalar_legend)(this.visuals,t,s)}_hit_point(t){const s=new r.Selection;return c.point_in_poly(t.sx,t.sy,this.sx,this.sy)&&(s.add_to_selected_glyphs(this.model),s.view=this),s}}e.PatchView=p,p.__name__="PatchView";class d extends _.XYGlyph{constructor(t){super(t)}}e.Patch=d,l=d,d.__name__="Patch",l.prototype.default_view=p,l.mixins([h.LineScalar,h.FillScalar,h.HatchScalar])},
function _(e,t,s,i,n){var o;i();const _=e(1),r=e(228),a=_.__importStar(e(225)),l=_.__importStar(e(18)),h=e(20),c=e(229),p=e(127);class d extends r.AreaView{_index_data(e){const{min:t,max:s}=Math,{x1:i,x2:n,y:o}=this;for(let _=0;_<this.data_size;_++){const r=i[_],a=n[_],l=o[_];e.add_rect(t(r,a),l,s(r,a),l)}}_step_path(e,t,s,i,n,o){let _=s[n],r=i[n];const a=n<o?1:-1;for(let l=n+a;l!=o;l+=a){switch(t){case"before":e.lineTo(s[l],r),e.lineTo(s[l],i[l]);break;case"after":e.lineTo(_,i[l]),e.lineTo(s[l],i[l]);break;case"center":{const t=(r+i[l])/2;e.lineTo(_,t),e.lineTo(s[l],t),e.lineTo(s[l],i[l]);break}}_=s[l],r=i[l]}}_render(e,t,s){const{sx1:i,sx2:n,sy:o}={...this,...s},_=this.model.step_mode,r=(0,c.flip_step_mode)(this.model.step_mode);e.beginPath(),e.moveTo(i[0],o[0]),this._step_path(e,_,i,o,0,o.length),this._step_path(e,r,n,o,o.length,-1),e.closePath(),this.visuals.fill.apply(e),this.visuals.hatch.apply(e)}scenterxy(e){return[(this.sx1[e]+this.sx2[e])/2,this.sy[e]]}_line_selection_for(e){return new p.Selection({line_indices:[e],selected_glyphs:[this.model],view:this})}_hit_point_before(e){const{sy:t,sx1:s,sx2:i}=this;for(let n=1;n<this.data_size;n++){const o=[s[n],s[n],i[n],i[n]],_=[t[n-1],t[n],t[n],t[n-1]];if(a.point_in_poly(e.sx,e.sy,o,_))return this._line_selection_for(n)}return new p.Selection}_hit_point_after(e){const{sy:t,sx1:s,sx2:i}=this;for(let n=0;n<this.data_size-1;n++){const o=[s[n],s[n],i[n],i[n]],_=[t[n],t[n+1],t[n+1],t[n]];if(a.point_in_poly(e.sx,e.sy,o,_))return this._line_selection_for(n)}return new p.Selection}_hit_point_center(e){const{sy:t,sx1:s,sx2:i}=this;for(let n=0;n<this.data_size;n++){const o=(t[n-1]+t[n])/2,_=(t[n]+t[n+1])/2,r=[s[n],s[n],i[n],i[n]],l=(()=>0==n?[t[n],_,_,t[n]]:n==this.data_size-1?[o,t[n],t[n],o]:[o,_,_,o])();if(a.point_in_poly(e.sx,e.sy,r,l))return this._line_selection_for(n)}return new p.Selection}_hit_point(e){switch(this.model.step_mode){case"before":return this._hit_point_before(e);case"after":return this._hit_point_after(e);case"center":return this._hit_point_center(e)}}}s.HAreaStepView=d,d.__name__="HAreaStepView";class f extends r.Area{constructor(e){super(e)}}s.HAreaStep=f,o=f,f.__name__="HAreaStep",o.prototype.default_view=d,o.define((({})=>({x1:[l.XCoordinateSpec,{field:"x1"}],x2:[l.XCoordinateSpec,{field:"x2"}],y:[l.YCoordinateSpec,{field:"y"}],step_mode:[h.StepMode,"before"]})))},
function _(e,a,r,_,s){var n;_();const i=e(1),l=e(218),c=e(224),t=i.__importStar(e(85));class d extends l.GlyphView{draw_legend_for_index(e,a,r){(0,c.generic_area_scalar_legend)(this.visuals,e,a)}}r.AreaView=d,d.__name__="AreaView";class o extends l.Glyph{constructor(e){super(e)}}r.Area=o,n=o,o.__name__="Area",n.mixins([t.FillScalar,t.HatchScalar])},
function _(e,r,t,n,c){n(),t.flip_step_mode=function(e){switch(e){case"before":return"after";case"after":return"before";case"center":return"center"}}},
function _(t,s,e,i,n){var a;i();const o=t(1),h=t(228),r=o.__importStar(t(225)),l=o.__importStar(t(18)),_=t(127);class c extends h.AreaView{_index_data(t){const{min:s,max:e}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this.x1[n],a=this.x2[n],o=this.y[n];t.add_rect(s(i,a),o,e(i,a),o)}}_render(t,s,e){const{sx1:i,sx2:n,sy:a}={...this,...e};t.beginPath();for(let s=0,e=i.length;s<e;s++)t.lineTo(i[s],a[s]);for(let s=n.length-1;s>=0;s--)t.lineTo(n[s],a[s]);t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t)}_hit_point(t){const s=this.sy.length,e=new _.Selection;for(let i=0,n=s-1;i<n;i++){const s=[this.sx1[i],this.sx1[i+1],this.sx2[i+1],this.sx2[i]],n=[this.sy[i],this.sy[i+1],this.sy[i+1],this.sy[i]];if(r.point_in_poly(t.sx,t.sy,s,n)){e.add_to_selected_glyphs(this.model),e.view=this,e.line_indices=[i];break}}return e}scenterxy(t){return[(this.sx1[t]+this.sx2[t])/2,this.sy[t]]}}e.HAreaView=c,c.__name__="HAreaView";class d extends h.Area{constructor(t){super(t)}}e.HArea=d,a=d,d.__name__="HArea",a.prototype.default_view=c,a.define((({})=>({x1:[l.XCoordinateSpec,{field:"x1"}],x2:[l.XCoordinateSpec,{field:"x2"}],y:[l.YCoordinateSpec,{field:"y"}]})))},
function _(e,t,s,i,n){var o;i();const _=e(1),r=e(228),a=_.__importStar(e(225)),l=_.__importStar(e(18)),h=e(20),c=e(229),p=e(127);class d extends r.AreaView{_index_data(e){const{min:t,max:s}=Math,{x:i,y1:n,y2:o}=this;for(let _=0;_<this.data_size;_++){const r=i[_],a=n[_],l=o[_];e.add_rect(r,t(a,l),r,s(a,l))}}_step_path(e,t,s,i,n,o){let _=s[n],r=i[n];const a=n<o?1:-1;for(let l=n+a;l!=o;l+=a){switch(t){case"before":e.lineTo(_,i[l]),e.lineTo(s[l],i[l]);break;case"after":e.lineTo(s[l],r),e.lineTo(s[l],i[l]);break;case"center":{const t=(_+s[l])/2;e.lineTo(t,r),e.lineTo(t,i[l]),e.lineTo(s[l],i[l]);break}}_=s[l],r=i[l]}}_render(e,t,s){const{sx:i,sy1:n,sy2:o}={...this,...s},_=this.model.step_mode,r=(0,c.flip_step_mode)(this.model.step_mode);e.beginPath(),e.moveTo(i[0],n[0]),this._step_path(e,_,i,n,0,i.length),this._step_path(e,r,i,o,i.length,-1),e.closePath(),this.visuals.fill.apply(e),this.visuals.hatch.apply(e)}scenterxy(e){return[this.sx[e],(this.sy1[e]+this.sy2[e])/2]}_line_selection_for(e){return new p.Selection({line_indices:[e],selected_glyphs:[this.model],view:this})}_hit_point_before(e){const{sx:t,sy1:s,sy2:i}=this;for(let n=1;n<this.data_size;n++){const o=[t[n-1],t[n],t[n],t[n-1]],_=[s[n],s[n],i[n],i[n]];if(a.point_in_poly(e.sx,e.sy,o,_))return this._line_selection_for(n)}return new p.Selection}_hit_point_after(e){const{sx:t,sy1:s,sy2:i}=this;for(let n=0;n<this.data_size-1;n++){const o=[t[n],t[n+1],t[n+1],t[n]],_=[s[n],s[n],i[n],i[n]];if(a.point_in_poly(e.sx,e.sy,o,_))return this._line_selection_for(n)}return new p.Selection}_hit_point_center(e){const{sx:t,sy1:s,sy2:i}=this;for(let n=0;n<this.data_size;n++){const o=(t[n-1]+t[n])/2,_=(t[n]+t[n+1])/2,r=(()=>0==n?[t[n],_,_,t[n]]:n==this.data_size-1?[o,t[n],t[n],o]:[o,_,_,o])(),l=[s[n],s[n],i[n],i[n]];if(a.point_in_poly(e.sx,e.sy,r,l))return this._line_selection_for(n)}return new p.Selection}_hit_point(e){switch(this.model.step_mode){case"before":return this._hit_point_before(e);case"after":return this._hit_point_after(e);case"center":return this._hit_point_center(e)}}}s.VAreaStepView=d,d.__name__="VAreaStepView";class f extends r.Area{constructor(e){super(e)}}s.VAreaStep=f,o=f,f.__name__="VAreaStep",o.prototype.default_view=d,o.define((({})=>({x:[l.XCoordinateSpec,{field:"x"}],y1:[l.YCoordinateSpec,{field:"y1"}],y2:[l.YCoordinateSpec,{field:"y2"}],step_mode:[h.StepMode,"before"]})))},
function _(t,s,e,i,n){var a;i();const o=t(1),h=t(228),r=o.__importStar(t(225)),l=o.__importStar(t(18)),_=t(127);class c extends h.AreaView{_index_data(t){const{min:s,max:e}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this.x[n],a=this.y1[n],o=this.y2[n];t.add_rect(i,s(a,o),i,e(a,o))}}_render(t,s,e){const{sx:i,sy1:n,sy2:a}={...this,...e};t.beginPath();for(let s=0,e=n.length;s<e;s++)t.lineTo(i[s],n[s]);for(let s=a.length-1;s>=0;s--)t.lineTo(i[s],a[s]);t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t)}scenterxy(t){return[this.sx[t],(this.sy1[t]+this.sy2[t])/2]}_hit_point(t){const s=this.sx.length,e=new _.Selection;for(let i=0,n=s-1;i<n;i++){const s=[this.sx[i],this.sx[i+1],this.sx[i+1],this.sx[i]],n=[this.sy1[i],this.sy1[i+1],this.sy2[i+1],this.sy2[i]];if(r.point_in_poly(t.sx,t.sy,s,n)){e.add_to_selected_glyphs(this.model),e.view=this,e.line_indices=[i];break}}return e}}e.VAreaView=c,c.__name__="VAreaView";class d extends h.Area{constructor(t){super(t)}}e.VArea=d,a=d,d.__name__="VArea",a.prototype.default_view=c,a.define((({})=>({x:[l.XCoordinateSpec,{field:"x"}],y1:[l.YCoordinateSpec,{field:"y1"}],y2:[l.YCoordinateSpec,{field:"y2"}]})))},
function _(e,t,i,n,s){var c;n();const a=e(51),o=e(58),r=e(24),l=e(234),_=e(235),d=e(236);class h extends o.View{initialize(){super.initialize(),this.compute_indices()}connect_signals(){super.connect_signals();const e=()=>{this.compute_indices()},t=t=>{this.connect(t.change,e)},i=t=>{this.disconnect(t.change,e)};let{filter:n}=this.model;t(n),this.on_change(this.model.properties.filter,(()=>{i(n),n=this.model.filter,t(n),e()}));const s=t=>{this.connect(t.change,e),this.connect(t.streaming,e),this.connect(t.patching,e),this.connect(t.properties.data.change,e)},c=t=>{this.disconnect(t.change,e),this.disconnect(t.streaming,e),this.disconnect(t.patching,e),this.disconnect(t.properties.data.change,e)};let a=this.parent.data_source.get_value();s(a),this.on_change(this.parent.data_source,(()=>{c(a),a=this.parent.data_source.get_value(),s(a),e()}))}compute_indices(){const e=this.parent.data_source.get_value(),t=e.get_length()??1,i=r.Indices.all_set(t),n=this.model.filter.compute_indices(e);i.intersect(n),this.model.indices=i,this.model._indices_map_to_subset()}}i.CDSViewView=h,h.__name__="CDSViewView";class p extends a.Model{constructor(e){super(e)}_indices_map_to_subset(){this._indices=[...this.indices],this.indices_map=new Map;const{_indices:e,indices_map:t}=this,i=e.length;for(let n=0;n<i;n++)t.set(e[n],n)}convert_selection_from_subset(e){return e.map((e=>this._indices[e]))}convert_selection_to_subset(e){return e.map((e=>this.indices_map.get(e)))}convert_indices_from_subset(e){return e.map((e=>this._indices[e]))}get filters(){const{filter:e}=this;return e instanceof d.IntersectionFilter?e.operands:e instanceof _.AllIndices?[]:[e]}set filters(e){0==e.length?this.filter=new _.AllIndices:1==e.length?this.filter=e[0]:this.filter=new d.IntersectionFilter({operands:e})}}i.CDSView=p,c=p,p.__name__="CDSView",c.prototype.default_view=h,c.define((({Ref:e})=>({filter:[e(l.Filter),()=>new _.AllIndices]}))),c.internal((({Int:e,Mapping:t,Ref:i,Nullable:n})=>({indices:[i(r.Indices)],indices_map:[t(e,e),new Map],masked:[n(i(r.Indices)),null]})))},
function _(e,t,n,s,c){s();const o=e(51);class r extends o.Model{constructor(e){super(e)}}n.Filter=r,r.__name__="Filter"},
function _(e,n,s,t,c){t();const l=e(234),_=e(24);class i extends l.Filter{constructor(e){super(e)}compute_indices(e){const n=e.get_length()??1;return _.Indices.all_set(n)}}s.AllIndices=i,i.__name__="AllIndices"},
function _(e,t,n,s,c){s();const i=e(237);class o extends i.CompositeFilter{constructor(e){super(e)}_inplace_op(e,t){e.intersect(t)}}n.IntersectionFilter=o,o.__name__="IntersectionFilter"},
function _(e,t,n,s,o){var i;s();const c=e(234),r=e(24);class a extends c.Filter{constructor(e){super(e)}connect_signals(){super.connect_signals();const e=()=>{this.change.emit()},t=t=>{for(const n of t)this.connect(n.change,e)},n=t=>{for(const n of t)this.disconnect(n.change,e)};let s=(()=>{const{operands:e}=this.properties;return e.is_unset?[]:e.get_value()})();t(s),this.on_change(this.properties.operands,(()=>{n(s),s=this.operands,t(s)}))}compute_indices(e){const{operands:t}=this;if(0==t.length){const t=e.get_length()??1;return r.Indices.all_set(t)}{const[n,...s]=t.map((t=>t.compute_indices(e)));for(const e of s)this._inplace_op(n,e);return n}}}n.CompositeFilter=a,i=a,a.__name__="CompositeFilter",i.define((({List:e,Ref:t})=>({operands:[e(t(c.Filter))]})))},
function _(t,r,a,e,i){e(),i("BasicTickFormatter",t(193).BasicTickFormatter),i("CategoricalTickFormatter",t(239).CategoricalTickFormatter),i("DatetimeTickFormatter",t(240).DatetimeTickFormatter),i("CustomJSTickFormatter",t(245).CustomJSTickFormatter),i("LogTickFormatter",t(246).LogTickFormatter),i("MercatorTickFormatter",t(247).MercatorTickFormatter),i("NumeralTickFormatter",t(248).NumeralTickFormatter),i("PrintfTickFormatter",t(249).PrintfTickFormatter),i("TickFormatter",t(189).TickFormatter)},
function _(t,r,o,c,a){c();const e=t(189),n=t(10);class i extends e.TickFormatter{constructor(t){super(t)}doFormat(t,r){return(0,n.copy)(t)}}o.CategoricalTickFormatter=i,i.__name__="CategoricalTickFormatter"},
function _(e,t,o,n,r){var s;n();const i=e(1),c=e(20),u=e(34),_=e(241),l=e(8),m=e(189),a=e(203),d=i.__importDefault(e(244));o.resolution_order=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"],o.tm_index_for_resolution=new Map;for(const e of o.resolution_order)o.tm_index_for_resolution.set(e,0);function h(e,t){const o=1.1*e*1e3,n=1e3*t;return o<a.ONE_MILLI?"microseconds":o<a.ONE_SECOND?"milliseconds":o<a.ONE_MINUTE?n>=a.ONE_MINUTE?"minsec":"seconds":o<a.ONE_HOUR?n>=a.ONE_HOUR?"hourmin":"minutes":o<a.ONE_DAY?"hours":o<a.ONE_MONTH?"days":o<a.ONE_YEAR?"months":"years"}function f(e){return(0,d.default)(e,"%Y %m %d %H %M %S").split(/\s+/).map((e=>parseInt(e,10)))}function x(e,t){const o=(0,_.sprintf)("$1%06d",N(e));return-1==(t=t.replace(/((^|[^%])(%%)*)%f/,o)).indexOf("%")?t:(0,d.default)(e,t)}function N(e){let t=Math.round(e/1e3%1*1e6);return e<0&&(t=(1e6+t)%1e6),t}o.tm_index_for_resolution.set("seconds",5),o.tm_index_for_resolution.set("minsec",4),o.tm_index_for_resolution.set("minutes",4),o.tm_index_for_resolution.set("hourmin",3),o.tm_index_for_resolution.set("hours",3),o._get_resolution=h,o._mktime=f,o._strftime=x,o._us=N;class O extends m.TickFormatter{constructor(e){super(e)}doFormat(e,t,o){if(0==e.length)return[];const n=Math.abs(e[e.length-1]-e[0])/1e3,r=n/(e.length-1),s=(0,l.is_undefined)(o)?h(r,n):o,i=[];for(const[t,o]of(0,u.enumerate)(e)){const n=this._compute_label(t,s),r=this._add_context(t,n,o,e.length,s);i.push(r)}return i}_compute_label(e,t){const n=x(e,this[t]),r=f(e),s=o.resolution_order.indexOf(t);let i=n,c=!1,u=s,_=t;for(;0==r[o.tm_index_for_resolution.get(o.resolution_order[u])]&&(u+=1,u!=o.resolution_order.length);){if(("minsec"==t||"hourmin"==t)&&!c){if("minsec"==t&&0==r[4]&&0!=r[5]||"hourmin"==t&&0==r[3]&&0!=r[4]){_=o.resolution_order[s-1],i=x(e,this[_]);break}c=!0}_=o.resolution_order[u],i=x(e,this[_])}const m=_,{strip_leading_zeros:a}=this;if((0,l.isBoolean)(a)&&a||(0,l.isArray)(a)&&a.includes(m)){const e=i.replace(/^0+/g,"");return e==i||Number.isInteger(Number(e[0]))?e:`0${e}`}return i}_add_context(e,t,o,n,r){const s=this.context_location,i=this.context_which;if(null==this.context)return t;if("start"==i&&0==o||"end"==i&&o==n-1||"center"==i&&o==Math.floor(n/2)||"all"==i){const o=(0,l.isString)(this.context)?x(e,this.context):this.context.doFormat([e],{loc:0},r)[0];if(""==o)return t;switch(s){case"above":return`${o}\n${t}`;case"below":return`${t}\n${o}`;case"left":return`${o} ${t}`;case"right":return`${t} ${o}`}}return t}}o.DatetimeTickFormatter=O,s=O,O.__name__="DatetimeTickFormatter",s.define((({Bool:e,Nullable:t,Or:o,Ref:n,Str:r,Arrayable:i})=>({microseconds:[r,"%fus"],milliseconds:[r,"%3Nms"],seconds:[r,"%Ss"],minsec:[r,":%M:%S"],minutes:[r,":%M"],hourmin:[r,"%H:%M"],hours:[r,"%Hh"],days:[r,"%m/%d"],months:[r,"%m/%Y"],years:[r,"%Y"],strip_leading_zeros:[o(e,i(c.ResolutionType)),!1],context:[t(o(r,n(s))),null],context_which:[c.ContextWhich,"start"],context_location:[c.Location,"below"]})))},
function _(r,e,t,n,i){n();const u=r(1),a=u.__importStar(r(242)),l=r(243),s=u.__importDefault(r(244)),o=r(21),f=r(19),c=r(9),m=r(30),p=r(8);function _(r,...e){return(0,l.sprintf)(r,...e)}function d(r,e,t){if((0,p.isNumber)(r)){return _((()=>{switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}})(),r)}return`${r}`}function N(r,e,n){if(null==e)return d;if(null!=n){const e=(0,c.dict)(n).get(r);if(null!=e){if((0,p.isString)(e)){if(e in t.DEFAULT_FORMATTERS)return t.DEFAULT_FORMATTERS[e];throw new Error(`Unknown tooltip field formatter type '${e}'`)}return function(r,t,n){return e.format(r,t,n)}}}return t.DEFAULT_FORMATTERS.numeral}t.FormatterType=(0,o.Enum)("numeral","printf","datetime"),t.DEFAULT_FORMATTERS={numeral:(r,e,t)=>a.format(r,e),datetime:(r,e,t)=>(0,s.default)(r,e),printf:(r,e,t)=>_(e,r)},t.sprintf=_,t.basic_formatter=d,t.get_formatter=N;const T="???";function g(r,e,t){const n=e.get_column(r);if(null==n)return null;if(null==t)return null;if((0,p.isNumber)(t))return n[t];const i=n[t.index];if((0,p.isTypedArray)(i)||(0,p.isArray)(i)){if((0,p.isArray)(i[0])){return i[t.j][t.i]}return(0,m.is_NDArray)(i)&&3==i.dimension?i.slice(t.flat_index*i.shape[2],(t.flat_index+1)*i.shape[2]):i[t.flat_index]}return i}function h(r,e,t,n,i){switch(r){case"$":return function(r,e){return r in e?e[r]:(f.logger.warn(`unknown special variable '$${r}'`),T)}(e,i);case"@":return g(e,t,n)}}t._get_column_value=g,t.get_value=h,t.replace_placeholders=function(r,e,t,n,i={},u){let a,l;if((0,p.isString)(r)?(a=r,l=!1):(a=r.html,l=!0),a=a.replace(/@\$name/g,(r=>`@{${i.name}}`)),a=$(a,((r,a,s,o,f)=>{const c=h(r,a,e,t,i);if("safe"==s)return l=!0,null==c?T:(0,p.isNumber)(c)&&isNaN(c)?"NaN":`${c}`;{const r=(()=>{if(null==c)return T;if((0,p.isNumber)(c)&&isNaN(c))return"NaN";return`${N(f,s,n)(c,s??"",i)}`})();return null!=u?u(r):r}})),l){return[...(new DOMParser).parseFromString(a,"text/html").body.childNodes]}return a};const A=/((?:[$@][\p{Letter}\p{Number}_]+)|(?:[$@]\{(?:[^{}]+)\}))(?:\{([^{}]+)\})?/gu;function $(r,e){let t=0;return r.replace(A,((r,n,i)=>{const u=n[0],a=n.substring(1).replace(/^{/,"").replace(/}$/,"").trim();return e(u,a,i,t++,n)??T}))}t.process_placeholders=$},
function _(e,n,t,r,i){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var a,o={},l=o,c="en-US",u=null,s="0,0";void 0!==n&&n.exports;function f(e){this._value=e}function d(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function h(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+d(i-r.length),n>0&&(a+="."+d(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function p(e,n,t){var r;return r=n.indexOf("$")>-1?function(e,n,t){var r,i,a=n,l=a.indexOf("$"),u=a.indexOf("("),s=a.indexOf("+"),f=a.indexOf("-"),d="",h="";-1===a.indexOf("$")?"infix"===o[c].currency.position?(h=o[c].currency.symbol,o[c].currency.spaceSeparated&&(h=" "+h+" ")):o[c].currency.spaceSeparated&&(d=" "):a.indexOf(" $")>-1?(d=" ",a=a.replace(" $","")):a.indexOf("$ ")>-1?(d=" ",a=a.replace("$ ","")):a=a.replace("$","");if(i=m(e,a,t,h),-1===n.indexOf("$"))switch(o[c].currency.position){case"postfix":i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[c].currency.symbol),i=i.join("")):i=i+d+o[c].currency.symbol;break;case"infix":break;case"prefix":i.indexOf("(")>-1||i.indexOf("-")>-1?(i=i.split(""),r=Math.max(u,f)+1,i.splice(r,0,o[c].currency.symbol+d),i=i.join("")):i=o[c].currency.symbol+d+i;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else l<=1?i.indexOf("(")>-1||i.indexOf("+")>-1||i.indexOf("-")>-1?(r=1,(l<u||l<s||l<f)&&(r=0),(i=i.split("")).splice(r,0,o[c].currency.symbol+d),i=i.join("")):i=o[c].currency.symbol+d+i:i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[c].currency.symbol),i=i.join("")):i=i+d+o[c].currency.symbol;return i}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");r=m(e,n,t),r.indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):m(e,n,t),r}function m(e,n,t,r){var i,a,l,s,f,d,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==u)return u;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(f=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(d=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,f)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===d?0:3*~~(d/3)-d)<0?M+3:M,i=0;i<M;i++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=o[c].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=o[c].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=o[c].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=o[c].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(a=Math.pow(1024,s),l=Math.pow(1024,s+1),e>=a&&e<l){C+=K[s],a>0&&(e/=a);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(a=Math.pow(1e3,s),l=Math.pow(1e3,s+1),e>=a&&e<l){C+=G[s],a>0&&(e/=a);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),o[c].ordinal&&(L+=o[c].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?h(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?h(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):h(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:o[c].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=h(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+o[c].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function x(e,n){o[e]=n}function g(e){c=e;var n=o[e].defaults;n&&n.format&&a.defaultFormat(n.format),n&&n.currencyFormat&&a.defaultCurrencyFormat(n.currencyFormat)}(a=function(e){return a.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=a.fn.unformat(e)),new f(Number(e))}).version="1.6.2",a.isNumbro=function(e){return e instanceof f},a.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;l[t]||(Object.keys(l).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.setCulture=function(e,n){var t=e,r=e.split("-")[1],i=null;o[t]||(r&&Object.keys(o).forEach((function(e){i||e.split("-")[1]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return c;if(e&&!n){if(!l[e])throw new Error("Unknown language : "+e);g(e)}return!n&&l[e]||x(e,n),a},a.culture=function(e,n){if(!e)return c;if(e&&!n){if(!o[e])throw new Error("Unknown culture : "+e);g(e)}return!n&&o[e]||x(e,n),a},a.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return l[c];if(!l[e])throw new Error("Unknown language : "+e);return l[e]},a.cultureData=function(e){if(!e)return o[c];if(!o[e])throw new Error("Unknown culture : "+e);return o[e]},a.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),a.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),l},a.cultures=function(){return o},a.zeroFormat=function(e){u="string"==typeof e?e:null},a.defaultFormat=function(e){s="string"==typeof e?e:"0.0"},a.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},a.validate=function(e,n){var t,r,i,o,l,c,u,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{u=a.cultureData(n)}catch(e){u=a.cultureData(a.culture())}return i=u.currency.symbol,l=u.abbreviations,t=u.delimiters.decimal,r="."===u.delimiters.thousands?"\\.":u.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===i))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(c=new RegExp(r+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(c):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(c)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(c)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,r){return null!=t&&t!==a.culture()&&a.setCulture(t),p(Number(e),null!=n?n:s,r??Math.round)}}},
function _(e,n,t,r,i){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(t){return function(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}(function(n){if(i[n])return i[n];var t,r=n,s=[],a=0;for(;r;){if(null!==(t=e.text.exec(r)))s.push(t[0]);else if(null!==(t=e.modulo.exec(r)))s.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");s.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return i[n]=s}(t),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}var i=Object.create(null);void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,t,n,r,o){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(t,e,s,n,r){var c;n();const a=t(189),i=t(9),o=t(40);class u extends a.TickFormatter{constructor(t){super(t)}get names(){return(0,i.keys)(this.args)}get values(){return(0,i.values)(this.args)}_make_func(){const t=(0,o.use_strict)(this.code);return new Function("tick","index","ticks",...this.names,t)}doFormat(t,e){const s=this._make_func().bind({});return t.map(((t,e,n)=>`${s(t,e,n,...this.values)}`))}}s.CustomJSTickFormatter=u,c=u,u.__name__="CustomJSTickFormatter",c.define((({Unknown:t,Str:e,Dict:s})=>({args:[s(t),{}],code:[e,""]})))},
function _(e,t,n,r,o){var i;r();const s=e(189),a=e(193),c=e(207),l=e(177),{abs:u,log:x,round:_}=Math;class p extends s.TickFormatter{constructor(e){super(e)}initialize(){super.initialize(),this.basic_formatter=new a.BasicTickFormatter}format_graphics(e,t){if(0==e.length)return[];const n=this.ticker?.base??10,r=this._exponents(e,n);return null==r?this.basic_formatter.format_graphics(e,t):r.map((e=>{if(u(e)<this.min_exponent){const t=new l.TextBox({text:(0,a.unicode_replace)(`${n**e}`)}),r=new l.TextBox({text:""});return new l.BaseExpo(t,r)}{const t=new l.TextBox({text:(0,a.unicode_replace)(`${n}`)}),r=new l.TextBox({text:(0,a.unicode_replace)(`${e}`)});return new l.BaseExpo(t,r)}}))}_exponents(e,t){let n=null;const r=[];for(const o of e){const e=_(x(o)/x(t));if(n==e)return null;n=e,r.push(e)}return r}doFormat(e,t){if(0==e.length)return[];const n=this.ticker?.base??10,r=this._exponents(e,n);return null==r?this.basic_formatter.doFormat(e,t):r.map((e=>u(e)<this.min_exponent?(0,a.unicode_replace)(`${n**e}`):(0,a.unicode_replace)(`${n}^${e}`)))}}n.LogTickFormatter=p,i=p,p.__name__="LogTickFormatter",i.define((({Int:e,Ref:t,Nullable:n})=>({ticker:[n(t(c.LogTicker)),null],min_exponent:[e,0]})))},
function _(r,t,e,o,n){var i;o();const c=r(193),s=r(20),a=r(131);class l extends c.BasicTickFormatter{constructor(r){super(r)}doFormat(r,t){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==r.length)return[];const e=r.length,o=new Array(e);if("lon"==this.dimension)for(let n=0;n<e;n++){const[e]=a.wgs84_mercator.invert(r[n],t.loc);o[n]=e}else for(let n=0;n<e;n++){const[,e]=a.wgs84_mercator.invert(t.loc,r[n]);o[n]=e}return super.doFormat(o,t)}}e.MercatorTickFormatter=l,i=l,l.__name__="MercatorTickFormatter",i.define((({Nullable:r})=>({dimension:[r(s.LatLon),null]})))},
function _(r,n,t,o,e){var a;o();const u=r(1).__importStar(r(242)),c=r(189),i=r(20);class s extends c.TickFormatter{constructor(r){super(r)}get _rounding_fn(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}doFormat(r,n){const{format:t,language:o,_rounding_fn:e}=this;return r.map((r=>u.format(r,t,o,e)))}}t.NumeralTickFormatter=s,a=s,s.__name__="NumeralTickFormatter",a.define((({Str:r})=>({format:[r,"0,0"],language:[r,"en"],rounding:[i.RoundingFunction,"round"]})))},
function _(t,r,n,o,a){var e;o();const i=t(189),s=t(241);class c extends i.TickFormatter{constructor(t){super(t)}doFormat(t,r){return t.map((t=>(0,s.sprintf)(this.format,t)))}}n.PrintfTickFormatter=c,e=c,c.__name__="PrintfTickFormatter",e.define((({Str:t})=>({format:[t,"%s"]})))},
function _(a,e,l,c,o){c(),o("CategoricalScale",a(100).CategoricalScale),o("CompositeScale",a(101).CompositeScale),o("ContinuousScale",a(98).ContinuousScale),o("LinearInterpolationScale",a(251).LinearInterpolationScale),o("LinearScale",a(97).LinearScale),o("LogScale",a(99).LogScale),o("Scale",a(92).Scale)},
function _(e,n,r,t,a){var i;t();const s=e(92),o=e(97),c=e(13);class _ extends s.Scale{constructor(e){super(e)}initialize(){super.initialize();const{source_range:e,target_range:n}=this.properties;e.is_unset||n.is_unset||(this.linear_scale=new o.LinearScale({source_range:e.get_value(),target_range:n.get_value()}))}connect_signals(){super.connect_signals();const{source_range:e,target_range:n}=this.properties;this.on_change([e,n],(()=>{this.linear_scale=new o.LinearScale({source_range:this.source_range,target_range:this.target_range})}))}get s_compute(){throw new Error("not implemented")}get s_invert(){throw new Error("not implemented")}compute(e){return e}v_compute(e){const{binning:n}=this,{start:r,end:t}=this.source_range,a=r,i=t,s=n.length,o=(t-r)/(s-1),_=new Float64Array(s);for(let e=0;e<s;e++)_[e]=r+e*o;const l=(0,c.map)(e,(e=>{if(e<a)return a;if(e>i)return i;const r=(0,c.left_edge_index)(e,n);if(-1==r)return a;if(r>=s-1)return i;const t=n[r],o=(e-t)/(n[r+1]-t),l=_[r];return l+o*(_[r+1]-l)}));return this.linear_scale.v_compute(l)}invert(e){return e}v_invert(e){return new Float64Array(e)}}r.LinearInterpolationScale=_,i=_,_.__name__="LinearInterpolationScale",i.internal((({Float:e,Arrayable:n,Ref:r})=>({binning:[n(e)],linear_scale:[r(o.LinearScale)]})))},
function _(a,n,e,g,R){g(),R("DataRange",a(103).DataRange),R("DataRange1d",a(102).DataRange1d),R("FactorRange",a(105).FactorRange),R("Range",a(94).Range),R("Range1d",a(95).Range1d)},
function _(a,t,o,e,i){e();var u=a(171);i("Sizeable",u.Sizeable),i("SizingPolicy",u.SizingPolicy);var l=a(172);i("Layoutable",l.Layoutable),i("ContentLayoutable",l.ContentLayoutable),i("TextLayout",l.TextLayout),i("FixedLayout",l.FixedLayout);var n=a(254);i("HStack",n.HStack),i("VStack",n.VStack);var y=a(255);i("Grid",y.Grid),i("Row",y.Row),i("Column",y.Column)},
function _(t,e,h,i,r){i();const s=t(172),o=t(64),{max:n,round:c}=Math;class a extends s.Layoutable{constructor(){super(...arguments),this.children=[]}*[Symbol.iterator](){yield*this.children}}h.Stack=a,a.__name__="Stack";class l extends a{_measure(t){let e=0,h=0;for(const t of this.children){const i=t.measure({width:0,height:0});e+=i.width,h=n(h,i.height)}return{width:e,height:h}}_set_geometry(t,e){if(super._set_geometry(t,e),t.is_empty)for(const t of this.children)t.set_geometry(new o.BBox);else{const e=this.absolute?t.top:0;let h=this.absolute?t.left:0;const{height:i}=t;for(const t of this.children){const{width:r}=t.measure({width:0,height:0});t.set_geometry(new o.BBox({left:h,width:r,top:e,height:i})),h+=r}}}}h.HStack=l,l.__name__="HStack";class d extends a{_measure(t){let e=0,h=0;for(const t of this.children){const i=t.measure({width:0,height:0});e=n(e,i.width),h+=i.height}return{width:e,height:h}}_set_geometry(t,e){if(super._set_geometry(t,e),t.is_empty)for(const t of this.children)t.set_geometry(new o.BBox);else{const e=this.absolute?t.left:0;let h=this.absolute?t.top:0;const{width:i}=t;for(const t of this.children){const{height:r}=t.measure({width:0,height:0});t.set_geometry(new o.BBox({top:h,height:r,left:e,width:i})),h+=r}}}}h.VStack=d,d.__name__="VStack";class g extends s.Layoutable{constructor(){super(...arguments),this.children=[]}*[Symbol.iterator](){yield*this.children}_measure(t){const{width_policy:e,height_policy:h}=this.sizing,{min:i,max:r}=Math;let s=0,o=0;for(const e of this.children){const{width:h,height:i}=e.measure(t);s=r(s,h),o=r(o,i)}return{width:(()=>{const{width:h}=this.sizing;if(t.width==1/0)return"fixed"==e?h??s:s;switch(e){case"fixed":return h??s;case"min":return s;case"fit":return null!=h?i(t.width,h):t.width;case"max":return null!=h?r(t.width,h):t.width}})(),height:(()=>{const{height:e}=this.sizing;if(t.height==1/0)return"fixed"==h?e??o:o;switch(h){case"fixed":return e??o;case"min":return o;case"fit":return null!=e?i(t.height,e):t.height;case"max":return null!=e?r(t.height,e):t.height}})()}}_set_geometry(t,e){if(super._set_geometry(t,e),t.is_empty)for(const t of this.children)t.set_geometry(new o.BBox);else{const e=this.absolute?t:t.relative(),{left:h,right:i,top:r,bottom:s}=e,n=c(e.vcenter),a=c(e.hcenter);for(const e of this.children){const{margin:c,halign:l="start",valign:d="start"}=e.sizing,{width:g,height:u,inner:_}=e.measure(t),w=(()=>{switch(`${d}_${l}`){case"start_start":return new o.BBox({left:h+c.left,top:r+c.top,width:g,height:u});case"start_center":return new o.BBox({hcenter:a,top:r+c.top,width:g,height:u});case"start_end":return new o.BBox({right:i-c.right,top:r+c.top,width:g,height:u});case"center_start":return new o.BBox({left:h+c.left,vcenter:n,width:g,height:u});case"center_center":return new o.BBox({hcenter:a,vcenter:n,width:g,height:u});case"center_end":return new o.BBox({right:i-c.right,vcenter:n,width:g,height:u});case"end_start":return new o.BBox({left:h+c.left,bottom:s-c.bottom,width:g,height:u});case"end_center":return new o.BBox({hcenter:a,bottom:s-c.bottom,width:g,height:u});case"end_end":return new o.BBox({right:i-c.right,bottom:s-c.bottom,width:g,height:u})}})(),m=null==_?w:new o.BBox({left:w.left+_.left,top:w.top+_.top,right:w.right-_.right,bottom:w.bottom-_.bottom});e.set_geometry(w,m)}}}}h.NodeLayout=g,g.__name__="NodeLayout"},
function _(t,i,s,e,o){e();const n=t(171),r=t(172),h=t(8),l=t(64),c=t(10),{max:a,round:p}=Math;class g{constructor(t){this._map=new Map,this.def=t}get(t){let i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i}apply(t,i){const s=this.get(t);this._map.set(t,i(s))}}s.DefaultMap=g,g.__name__="DefaultMap";class _{constructor(){this._items=[],this._nrows=0,this._ncols=0}get size(){return this._items.length}get nrows(){return this._nrows}get ncols(){return this._ncols}add(t,i){const{r1:s,c1:e}=t;this._nrows=a(this._nrows,s+1),this._ncols=a(this._ncols,e+1),this._items.push({span:t,data:i})}at(t,i){return this._items.filter((({span:s})=>s.r0<=t&&t<=s.r1&&s.c0<=i&&i<=s.c1)).map((({data:t})=>t))}row(t){return this._items.filter((({span:i})=>i.r0<=t&&t<=i.r1)).map((({data:t})=>t))}col(t){return this._items.filter((({span:i})=>i.c0<=t&&t<=i.c1)).map((({data:t})=>t))}*[Symbol.iterator](){yield*this._items}foreach(t){for(const{span:i,data:s}of this._items)t(i,s)}map(t){const i=new _;for(const{span:s,data:e}of this._items)i.add(s,t(s,e));return i}}s.Container=_,_.__name__="Container";class f extends r.Layoutable{*[Symbol.iterator](){for(const{layout:t}of this.items)yield t}constructor(t=[]){super(),this.rows="auto",this.cols="auto",this.spacing=0,this.items=t}is_width_expanding(){if(super.is_width_expanding())return!0;if("fixed"==this.sizing.width_policy)return!1;const{cols:t}=this._state;return(0,c.some)(t,(t=>"max"==t.policy))}is_height_expanding(){if(super.is_height_expanding())return!0;if("fixed"==this.sizing.height_policy)return!1;const{rows:t}=this._state;return(0,c.some)(t,(t=>"max"==t.policy))}_init(){super._init();const t=new _;for(const{layout:i,row:s,col:e,row_span:o=1,col_span:n=1}of this.items)if(i.sizing.visible){const r=s,h=e,l=s+o-1,c=e+n-1;t.add({r0:r,c0:h,r1:l,c1:c},i)}const{nrows:i,ncols:s}=t,e=new Array(i);for(let s=0;s<i;s++){const i=(()=>{const t=(0,h.isPlainObject)(this.rows)?this.rows[s]??this.rows["*"]:this.rows;return null==t?{policy:"auto"}:(0,h.isNumber)(t)?{policy:"fixed",height:t}:(0,h.isString)(t)?{policy:t}:t})(),o=i.align??"auto";"fixed"==i.policy?e[s]={policy:"fixed",height:i.height,align:o}:"min"==i.policy?e[s]={policy:"min",align:o}:"fit"==i.policy||"max"==i.policy?e[s]={policy:i.policy,flex:i.flex??1,align:o}:(0,c.some)(t.row(s),(t=>t.is_height_expanding()))?e[s]={policy:"max",flex:1,align:o}:e[s]={policy:"min",align:o}}const o=new Array(s);for(let i=0;i<s;i++){const s=(()=>{const t=(0,h.isPlainObject)(this.cols)?this.cols[i]??this.cols["*"]:this.cols;return null==t?{policy:"auto"}:(0,h.isNumber)(t)?{policy:"fixed",width:t}:(0,h.isString)(t)?{policy:t}:t})(),e=s.align??"auto";"fixed"==s.policy?o[i]={policy:"fixed",width:s.width,align:e}:"min"==s.policy?o[i]={policy:"min",align:e}:"fit"==s.policy||"max"==s.policy?o[i]={policy:s.policy,flex:s.flex??1,align:e}:(0,c.some)(t.col(i),(t=>t.is_width_expanding()))?o[i]={policy:"max",flex:1,align:e}:o[i]={policy:"min",align:e}}const[n,r]=(0,h.isNumber)(this.spacing)?[this.spacing,this.spacing]:this.spacing;this._state={items:t,nrows:i,ncols:s,rows:e,cols:o,rspacing:n,cspacing:r}}_measure_totals(t,i){const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state;return{height:(0,c.sum)(t)+(s-1)*o,width:(0,c.sum)(i)+(e-1)*n}}_measure_cells(t){const{items:i,nrows:s,ncols:e,rows:o,cols:r,rspacing:h,cspacing:l}=this._state,c=new Array(s);for(let t=0;t<s;t++){const i=o[t];c[t]="fixed"==i.policy?i.height:0}const g=new Array(e);for(let t=0;t<e;t++){const i=r[t];g[t]="fixed"==i.policy?i.width:0}const f=new _;i.foreach(((i,s)=>{const{r0:e,c0:_,r1:d,c1:w}=i,m=(d-e)*h,u=(w-_)*l;let y=0;for(let i=e;i<=d;i++)y+=t(i,_).height;y+=m;let x=0;for(let i=_;i<=w;i++)x+=t(e,i).width;x+=u;const z=s.measure({width:x,height:y});f.add(i,{layout:s,size_hint:z});const b=new n.Sizeable(z).grow_by(s.sizing.margin);b.height-=m,b.width-=u;const B=[];for(let t=e;t<=d;t++){const i=o[t];"fixed"==i.policy?b.height-=i.height:B.push(t)}if(b.height>0){const t=p(b.height/B.length);for(const i of B)c[i]=a(c[i],t)}const S=[];for(let t=_;t<=w;t++){const i=r[t];"fixed"==i.policy?b.width-=i.width:S.push(t)}if(b.width>0){const t=p(b.width/S.length);for(const i of S)g[i]=a(g[i],t)}}));return{size:this._measure_totals(c,g),row_heights:c,col_widths:g,size_hints:f}}_measure_grid(t){const{nrows:i,ncols:s,rows:e,cols:o,rspacing:n,cspacing:r}=this._state,h=this._measure_cells(((t,i)=>{const s=e[t],n=o[i];return{width:"fixed"==n.policy?n.width:1/0,height:"fixed"==s.policy?s.height:1/0}}));let l;l="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:h.size.height;let c,g=0;for(let t=0;t<i;t++){const i=e[t];"fit"==i.policy||"max"==i.policy?g+=i.flex:l-=h.row_heights[t]}if(l-=(i-1)*n,0!=g&&l>0)for(let t=0;t<i;t++){const i=e[t];if("fit"==i.policy||"max"==i.policy){const s=p(l*(i.flex/g));l-=s,h.row_heights[t]=s,g-=i.flex}}else if(l<0){let t=0;for(let s=0;s<i;s++){"fixed"!=e[s].policy&&t++}let s=-l;for(let o=0;o<i;o++){if("fixed"!=e[o].policy){const i=h.row_heights[o],e=p(s/t);h.row_heights[o]=a(i-e,0),s-=e>i?i:e,t--}}}c="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:h.size.width;let _=0;for(let t=0;t<s;t++){const i=o[t];"fit"==i.policy||"max"==i.policy?_+=i.flex:c-=h.col_widths[t]}if(c-=(s-1)*r,0!=_&&c>0)for(let t=0;t<s;t++){const i=o[t];if("fit"==i.policy||"max"==i.policy){const s=p(c*(i.flex/_));c-=s,h.col_widths[t]=s,_-=i.flex}}else if(c<0){let t=0;for(let i=0;i<s;i++){"fixed"!=o[i].policy&&t++}let i=-c;for(let e=0;e<s;e++){if("fixed"!=o[e].policy){const s=h.col_widths[e],o=p(i/t);h.col_widths[e]=a(s-o,0),i-=o>s?s:o,t--}}}const{row_heights:f,col_widths:d,size_hints:w}=this._measure_cells(((t,i)=>({width:h.col_widths[i],height:h.row_heights[t]})));return{size:this._measure_totals(f,d),row_heights:f,col_widths:d,size_hints:w}}_measure(t){const{size:i}=this._measure_grid(t);return i}_set_geometry(t,i){super._set_geometry(t,i);const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state,{row_heights:r,col_widths:h,size_hints:c}=this._measure_grid(t),_=this._state.rows.map(((t,i)=>({...t,top:0,height:r[i],get bottom(){return this.top+this.height}}))),f=this._state.cols.map(((t,i)=>({...t,left:0,width:h[i],get right(){return this.left+this.width}}))),d=c.map(((t,i)=>({...i,outer:new l.BBox,inner:new l.BBox})));for(let i=0,e=this.absolute?t.top:this.position.top;i<s;i++){const t=_[i];t.top=e,e+=t.height+o}for(let i=0,s=this.absolute?t.left:this.position.left;i<e;i++){const t=f[i];t.left=s,s+=t.width+n}d.foreach((({r0:t,c0:i,r1:s,c1:e},r)=>{const{layout:h,size_hint:c}=r,{sizing:a}=h,{width:g,height:d}=c,w=function(t,i){let s=(i-t)*n;for(let e=t;e<=i;e++)s+=f[e].width;return s}(i,e),m=function(t,i){let s=(i-t)*o;for(let e=t;e<=i;e++)s+=_[e].height;return s}(t,s),u=i==e&&"auto"!=f[i].align?f[i].align:a.halign,y=t==s&&"auto"!=_[t].align?_[t].align:a.valign;let x=f[i].left;"start"==u?x+=a.margin.left:"center"==u?x+=p((w-g)/2):"end"==u&&(x+=w-a.margin.right-g);let z=_[t].top;"start"==y?z+=a.margin.top:"center"==y?z+=p((m-d)/2):"end"==y&&(z+=m-a.margin.bottom-d),r.outer=new l.BBox({left:x,top:z,width:g,height:d})}));const w=_.map((()=>({start:new g((()=>0)),end:new g((()=>0))}))),m=f.map((()=>({start:new g((()=>0)),end:new g((()=>0))})));d.foreach((({r0:t,c0:i,r1:s,c1:e},{size_hint:o,outer:n})=>{const{inner:r}=o;null!=r&&(w[t].start.apply(n.top,(t=>a(t,r.top))),w[s].end.apply(_[s].bottom-n.bottom,(t=>a(t,r.bottom))),m[i].start.apply(n.left,(t=>a(t,r.left))),m[e].end.apply(f[e].right-n.right,(t=>a(t,r.right))))})),d.foreach((({r0:t,c0:i,r1:s,c1:e},o)=>{const{size_hint:n,outer:r}=o,h=t=>{const i=this.absolute?r:r.relative(),s=i.left+t.left,e=i.top+t.top,o=i.right-t.right,n=i.bottom-t.bottom;return new l.BBox({left:s,top:e,right:o,bottom:n})};if(null!=n.inner){let l=h(n.inner);const c=w[t].start.get(r.top),a=w[s].end.get(_[s].bottom-r.bottom),p=m[i].start.get(r.left),g=m[e].end.get(f[e].right-r.right);try{l=h({top:c,bottom:a,left:p,right:g})}catch{}o.inner=l}else o.inner=r})),d.foreach(((t,{layout:i,outer:s,inner:e})=>{i.set_geometry(s,e)}))}}s.Grid=f,f.__name__="Grid";class d extends f{constructor(t){super(),this.items=t.map(((t,i)=>({layout:t,row:0,col:i}))),this.rows="fit"}}s.Row=d,d.__name__="Row";class w extends f{constructor(t){super(),this.items=t.map(((t,i)=>({layout:t,row:i,col:0}))),this.cols="fit"}}s.Column=w,w.__name__="Column"},
function _(t,e,i,h,o){h();const n=t(171),s=t(172),r=t(64);class _ extends s.Layoutable{constructor(){super(...arguments),this.aligns={left:!0,right:!0,top:!0,bottom:!0},this.min_border={left:0,top:0,right:0,bottom:0},this.padding={left:0,top:0,right:0,bottom:0},this.center_border_width=0}*[Symbol.iterator](){yield this.top_panel,yield this.bottom_panel,yield this.left_panel,yield this.right_panel,yield this.center_panel}_measure(t){t=new n.Sizeable({width:"fixed"==this.sizing.width_policy||t.width==1/0?this.sizing.width:t.width,height:"fixed"==this.sizing.height_policy||t.height==1/0?this.sizing.height:t.height});const e=this.left_panel.measure({width:0,height:t.height}),i=Math.max(e.width,this.min_border.left)+this.padding.left,h=this.right_panel.measure({width:0,height:t.height}),o=Math.max(h.width,this.min_border.right)+this.padding.right,s=this.top_panel.measure({width:t.width,height:0}),r=Math.max(s.height,this.min_border.top)+this.padding.top,_=this.bottom_panel.measure({width:t.width,height:0}),g=Math.max(_.height,this.min_border.bottom)+this.padding.bottom,l=new n.Sizeable(t).shrink_by({left:i,right:o,top:r,bottom:g}),a=this.center_panel.measure(l);return{width:i+a.width+o,height:r+a.height+g,inner:{left:i,right:o,top:r,bottom:g},align:(()=>{const{width_policy:t,height_policy:e}=this.center_panel.sizing;return{...this.aligns,fixed_width:"fixed"==t,fixed_height:"fixed"==e}})()}}_set_geometry(t,e){if(super._set_geometry(t,e),this.sizing.visible){this.center_panel.set_geometry(e);const i=this.left_panel.measure({width:0,height:t.height}),h=this.right_panel.measure({width:0,height:t.height}),o=this.top_panel.measure({width:t.width,height:0}),n=this.bottom_panel.measure({width:t.width,height:0}),{left:s,top:_,right:g,bottom:l}=e;this.top_panel.set_geometry(new r.BBox({left:s,right:g,bottom:_,height:o.height})),this.bottom_panel.set_geometry(new r.BBox({left:s,right:g,top:l,height:n.height})),this.left_panel.set_geometry(new r.BBox({top:_,bottom:l,right:s,width:i.width})),this.right_panel.set_geometry(new r.BBox({top:_,bottom:l,left:g,width:h.width}));const a=e.shrink_by(this.center_border_width);if(null!=this.inner_top_panel){const{left:t,right:e,top:i,width:h}=a,o=this.inner_top_panel.measure({width:h,height:0});this.inner_top_panel.set_geometry(new r.BBox({left:t,right:e,top:i,height:o.height}))}if(null!=this.inner_bottom_panel){const{left:t,right:e,bottom:i,width:h}=a,o=this.inner_bottom_panel.measure({width:h,height:0});this.inner_bottom_panel.set_geometry(new r.BBox({left:t,right:e,bottom:i,height:o.height}))}if(null!=this.inner_left_panel){const{top:t,bottom:e,left:i,height:h}=a,o=this.inner_left_panel.measure({width:0,height:h});this.inner_left_panel.set_geometry(new r.BBox({top:t,bottom:e,left:i,width:o.width}))}if(null!=this.inner_right_panel){const{top:t,bottom:e,right:i,height:h}=a,o=this.inner_right_panel.measure({width:0,height:h});this.inner_right_panel.set_geometry(new r.BBox({top:t,bottom:e,right:i,width:o.width}))}}else this.center_panel.set_geometry(new r.BBox),this.top_panel.set_geometry(new r.BBox),this.bottom_panel.set_geometry(new r.BBox),this.left_panel.set_geometry(new r.BBox),this.right_panel.set_geometry(new r.BBox),this.inner_top_panel?.set_geometry(new r.BBox),this.inner_bottom_panel?.set_geometry(new r.BBox),this.inner_left_panel?.set_geometry(new r.BBox),this.inner_right_panel?.set_geometry(new r.BBox)}}i.BorderLayout=_,_.__name__="BorderLayout"},
function _(e,s,_,i,l){var t;i();const o=e(1),r=e(258),p=o.__importStar(e(85));class h extends r.UpperLowerView{paint(e){e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let s=0,_=this._lower_sx.length;s<_;s++)e.lineTo(this._lower_sx[s],this._lower_sy[s]);for(let s=this._upper_sx.length-1;s>=0;s--)e.lineTo(this._upper_sx[s],this._upper_sy[s]);e.closePath(),this.visuals.fill.apply(e),e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let s=0,_=this._lower_sx.length;s<_;s++)e.lineTo(this._lower_sx[s],this._lower_sy[s]);this.visuals.line.apply(e),e.beginPath(),e.moveTo(this._upper_sx[0],this._upper_sy[0]);for(let s=0,_=this._upper_sx.length;s<_;s++)e.lineTo(this._upper_sx[s],this._upper_sy[s]);this.visuals.line.apply(e)}}_.BandView=h,h.__name__="BandView";class n extends r.UpperLower{constructor(e){super(e)}}_.Band=n,t=n,n.__name__="Band",t.prototype.default_view=h,t.mixins([p.Line,p.Fill]),t.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},
function _(e,t,s,r,i){var n;r();const a=e(1),o=e(124),_=e(24),c=e(20),p=a.__importStar(e(18));class h extends o.DataAnnotationView{map_data(){const{frame:e}=this.plot_view,t=this.model.dimension,s=this.coordinates.x_scale,r=this.coordinates.y_scale,i="height"==t?r:s,n="height"==t?s:r,a="height"==t?e.bbox.yview:e.bbox.xview,o="height"==t?e.bbox.xview:e.bbox.yview,c=(()=>{switch(this.model.properties.lower.units){case"canvas":return new _.ScreenArray(this._lower);case"screen":return a.v_compute(this._lower);case"data":return i.v_compute(this._lower)}})(),p=(()=>{switch(this.model.properties.upper.units){case"canvas":return new _.ScreenArray(this._upper);case"screen":return a.v_compute(this._upper);case"data":return i.v_compute(this._upper)}})(),h=(()=>{switch(this.model.properties.base.units){case"canvas":return new _.ScreenArray(this._base);case"screen":return o.v_compute(this._base);case"data":return n.v_compute(this._base)}})(),[u,d]="height"==t?[1,0]:[0,1],w=[c,h],l=[p,h];this._lower_sx=w[u],this._lower_sy=w[d],this._upper_sx=l[u],this._upper_sy=l[d]}}s.UpperLowerView=h,h.__name__="UpperLowerView";class u extends p.CoordinateSpec{constructor(){super(...arguments),this._value=p.unset}get dimension(){return"width"==this.obj.dimension?"x":"y"}get units(){return this._value===p.unset?"data":this._value.units??"data"}}s.XOrYCoordinateSpec=u,u.__name__="XOrYCoordinateSpec";class d extends o.DataAnnotation{constructor(e){super(e)}}s.UpperLower=d,n=d,d.__name__="UpperLower",n.define((()=>({dimension:[c.Dimension,"height"],lower:[u,{field:"lower"}],upper:[u,{field:"upper"}],base:[u,{field:"base"}]})))},
function _(t,e,o,i,r){var s,n;i();const a=t(1),l=t(79),h=t(102),_=a.__importStar(t(85)),c=t(20),m=t(10),b=t(64),d=t(15),u=t(11),p=t(12),f=t(182),g=a.__importStar(t(260)),v=t(184),x=a.__importStar(t(183)),w=t(59),y=t(60);o.EDGE_TOLERANCE=2.5;const{abs:N}=Math;class C extends l.AnnotationView{constructor(){super(...arguments),this.bbox=new b.BBox,this[s]=!0,this._pan_state=null,this._pinch_state=null,this._is_hovered=!1}serializable_state(){return{...super.serializable_state(),bbox:this.bbox.round()}}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}bounds(){const{left:t,left_units:e,right:o,right_units:i,top:r,top_units:s,bottom:n,bottom_units:a}=this.model,l="data"==e&&!(t instanceof y.Coordinate),h="data"==i&&!(o instanceof y.Coordinate),_="data"==s&&!(r instanceof y.Coordinate),c="data"==a&&!(n instanceof y.Coordinate),[m,b]=l&&h?t<=o?[t,o]:[o,t]:l?[t,t]:h?[o,o]:[NaN,NaN],[d,u]=_&&c?r<=n?[r,n]:[n,r]:_?[r,r]:c?[n,n]:[NaN,NaN];return{x0:m,x1:b,y0:d,y1:u}}log_bounds(){return(0,b.empty)()}get mappers(){function t(t,e,o,i){switch(t){case"canvas":return i;case"screen":return o;case"data":return e}}const e=this.model,{x_scale:o,y_scale:i}=this.coordinates,{x_view:r,y_view:s}=this.plot_view.frame.bbox,{x_screen:n,y_screen:a}=this.plot_view.canvas.bbox;return{left:t(e.left_units,o,r,n),right:t(e.right_units,o,r,n),top:t(e.top_units,i,s,a),bottom:t(e.bottom_units,i,s,a)}}get border_radius(){return x.border_radius(this.model.border_radius)}compute_geometry(){super.compute_geometry();const t=(t,e,o)=>e instanceof y.Coordinate?this.resolve_as_scalar(e,t):o.compute(e),{left:e,right:o,top:i,bottom:r}=this.model,{mappers:s}=this;this.bbox=b.BBox.from_lrtb({left:t("x",e,s.left),right:t("x",o,s.right),top:t("y",i,s.top),bottom:t("y",r,s.bottom)})}_render(){if(!this.bbox.is_valid)return;const{ctx:t}=this.layer;t.save(),t.beginPath(),(0,v.round_rect)(t,this.bbox,this.border_radius);const{_is_hovered:e,visuals:o}=this,i=e&&o.hover_fill.doit?o.hover_fill:o.fill,r=e&&o.hover_hatch.doit?o.hover_hatch:o.hatch,s=e&&o.hover_line.doit?o.hover_line:o.line;i.apply(t),r.apply(t),s.apply(t),t.restore()}interactive_bbox(){const t=this.model.line_width+o.EDGE_TOLERANCE;return this.bbox.grow_by(t)}interactive_hit(t,e){if(!this.model.visible||!this.model.editable)return!1;return this.interactive_bbox().contains(t,e)}_hit_test(t,e){const{left:i,right:r,bottom:s,top:n}=this.bbox,a=Math.max(o.EDGE_TOLERANCE,this.model.line_width/2),l=N(i-t),h=N(r-t),_=N(n-e),c=N(s-e),m=l<a&&l<h,b=h<a&&h<l,d=_<a&&_<c,u=c<a&&c<_;return d&&m?"top_left":d&&b?"top_right":u&&m?"bottom_left":u&&b?"bottom_right":m?"left":b?"right":d?"top":u?"bottom":this.bbox.contains(t,e)?"area":null}get resizable(){const{resizable:t}=this.model;return{left:"left"==t||"x"==t||"all"==t,right:"right"==t||"x"==t||"all"==t,top:"top"==t||"y"==t||"all"==t,bottom:"bottom"==t||"y"==t||"all"==t}}_can_hit(t){const{left:e,right:o,top:i,bottom:r}=this.resizable;switch(t){case"top_left":return i&&e;case"top_right":return i&&o;case"bottom_left":return r&&e;case"bottom_right":return r&&o;case"left":return e;case"right":return o;case"top":return i;case"bottom":return r;case"area":return"none"!=this.model.movable}}on_pan_start(t){if(this.model.visible&&this.model.editable){const{sx:e,sy:o}=t,i=this._hit_test(e,o);if(null!=i&&this._can_hit(i))return this._pan_state={bbox:this.bbox.clone(),target:i},this.model.pan.emit(["pan:start",t.modifiers]),!0}return!1}on_pan(t){(0,p.assert)(null!=this._pan_state);const{mappers:e}=this,o=(t,e,o)=>e instanceof y.Coordinate?this.resolve_as_scalar(e,t):null==e?NaN:o.compute(e),i=b.BBox.from_lrtb({left:o("x",this.model.left_limit,e.left),right:o("x",this.model.right_limit,e.right),top:o("y",this.model.top_limit,e.top),bottom:o("y",this.model.bottom_limit,e.bottom)}),[r,s,n,a]=(()=>{const{dx:e,dy:o}=t,{target:i}=this._pan_state,{symmetric:r}=this.model,[s,n]=r?[-e,-o]:[0,0];switch(i){case"top_left":return[e,s,o,n];case"top_right":return[s,e,o,n];case"bottom_left":return[e,s,n,o];case"bottom_right":return[s,e,n,o];case"left":return[e,s,0,0];case"right":return[s,e,0,0];case"top":return[0,0,o,n];case"bottom":return[0,0,n,o];case"area":switch(this.model.movable){case"both":return[e,e,o,o];case"x":return[e,e,0,0];case"y":return[0,0,o,o];case"none":return[0,0,0,0]}}})(),l=(()=>{const t=(t,e)=>(0,m.min)([t,e]),e=t=>t<0?-1:t>0?1:0,{bbox:o}=this._pan_state;let{left:l,right:h,left_sign:_,right_sign:c}=(()=>{const t=o.left+r,i=o.right+s,n=e(r),a=e(s);return t<=i?{left:t,right:i,left_sign:n,right_sign:a}:{left:i,right:t,left_sign:a,right_sign:n}})(),{top:d,bottom:u,top_sign:p,bottom_sign:f}=(()=>{const t=o.top+n,i=o.bottom+a,r=e(n),s=e(a);return t<=i?{top:t,bottom:i,top_sign:r,bottom_sign:s}:{top:i,bottom:t,top_sign:s,bottom_sign:r}})();const g=l-i.left,v=i.right-h,x=t(g<0?g:NaN,v<0?v:NaN);isFinite(x)&&x<0&&(l+=-_*-x,h+=-c*-x);const w=d-i.top,y=i.bottom-u,N=t(w<0?w:NaN,y<0?y:NaN);return isFinite(N)&&N<0&&(d+=-p*-N,u+=-f*-N),b.BBox.from_lrtb({left:l,right:h,top:d,bottom:u})})(),{min_width:h,min_height:_,max_width:c,max_height:d}=this.model,{left:f,right:g,top:v,bottom:x}=this.model,w={left:e.left.invert(l.left),right:e.right.invert(l.right),top:e.top.invert(l.top),bottom:e.bottom.invert(l.bottom)};if(0<h||c<1/0)if(0!=r&&0==s){const t=w.right-c,e=w.right-h;w.left=(0,u.clamp)(w.left,t,e)}else if(0==r&&0!=s){const t=w.left+h,e=w.left+c;w.right=(0,u.clamp)(w.right,t,e)}if(0<_||d<1/0)if(0!=n&&0==a){const t=w.bottom+d,e=w.bottom+_;w.top=(0,u.clamp)(w.top,t,e)}else if(0==n&&0!=a){const t=w.top-_,e=w.top-d;w.bottom=(0,u.clamp)(w.bottom,t,e)}const N={left:f instanceof y.Coordinate?f:w.left,right:g instanceof y.Coordinate?g:w.right,top:v instanceof y.Coordinate?v:w.top,bottom:x instanceof y.Coordinate?x:w.bottom};this.model.update(N),this.model.pan.emit(["pan",t.modifiers])}on_pan_end(t){this._pan_state=null,this.model.pan.emit(["pan:end",t.modifiers])}on_pinch_start(t){if(this.model.visible&&this.model.editable&&"none"!=this.model.resizable){const{sx:e,sy:o}=t;if(this.bbox.contains(e,o))return this._pinch_state={bbox:this.bbox.clone()},this.model.pan.emit(["pan:start",t.modifiers]),!0}return!1}on_pinch(t){(0,p.assert)(null!=this._pinch_state);const e=(()=>{const{scale:e}=t,{bbox:o}=this._pinch_state,{left:i,top:r,right:s,bottom:n,width:a,height:l}=o,h=a*(e-1),_=l*(e-1),{resizable:c}=this,m=c.left?-h/2:0,d=c.right?h/2:0,u=c.top?-_/2:0,p=c.bottom?_/2:0;return b.BBox.from_lrtb({left:i+m,right:s+d,top:r+u,bottom:n+p})})(),o=(()=>{const{left:t,right:o,top:i,bottom:r}=this.model,{mappers:s}=this;return{left:t instanceof y.Coordinate?t:s.left.invert(e.left),right:o instanceof y.Coordinate?o:s.right.invert(e.right),top:i instanceof y.Coordinate?i:s.top.invert(e.top),bottom:r instanceof y.Coordinate?r:s.bottom.invert(e.bottom)}})();this.model.update(o),this.model.pan.emit(["pan",t.modifiers])}on_pinch_end(t){this._pinch_state=null,this.model.pan.emit(["pan:end",t.modifiers])}get _has_hover(){const{hover_line:t,hover_fill:e,hover_hatch:o}=this.visuals;return t.doit||e.doit||o.doit}on_enter(t){const{_has_hover:e}=this;return e&&(this._is_hovered=!0,this.request_paint()),e}on_move(t){}on_leave(t){this._has_hover&&(this._is_hovered=!1,this.request_paint())}cursor(t,e){const o=this._pan_state?.target??this._hit_test(t,e);if(null==o||!this._can_hit(o))return null;switch(o){case"top_left":return this.model.tl_cursor;case"top_right":return this.model.tr_cursor;case"bottom_left":return this.model.bl_cursor;case"bottom_right":return this.model.br_cursor;case"left":case"right":return this.model.ew_cursor;case"top":case"bottom":return this.model.ns_cursor;case"area":switch(this.model.movable){case"both":return this.model.in_cursor;case"x":return this.model.ew_cursor;case"y":return this.model.ns_cursor;case"none":return null}}}}o.BoxAnnotationView=C,s=h.auto_ranged,C.__name__="BoxAnnotationView";class B extends l.Annotation{constructor(t){super(t),this.pan=new d.Signal(this,"pan")}update({left:t,right:e,top:o,bottom:i}){this.setv({left:t,right:e,top:o,bottom:i,visible:!0})}clear(){this.visible=!1}}o.BoxAnnotation=B,n=B,B.__name__="BoxAnnotation",n.prototype.default_view=C,n.mixins([_.Line,_.Fill,_.Hatch,["hover_",_.Line],["hover_",_.Fill],["hover_",_.Hatch]]),n.define((({Bool:t,Float:e,Ref:o,Or:i,NonNegative:r,Positive:s})=>({top:[i(e,o(y.Coordinate)),()=>new w.Node({target:"frame",symbol:"top"})],bottom:[i(e,o(y.Coordinate)),()=>new w.Node({target:"frame",symbol:"bottom"})],left:[i(e,o(y.Coordinate)),()=>new w.Node({target:"frame",symbol:"left"})],right:[i(e,o(y.Coordinate)),()=>new w.Node({target:"frame",symbol:"right"})],top_units:[c.CoordinateUnits,"data"],bottom_units:[c.CoordinateUnits,"data"],left_units:[c.CoordinateUnits,"data"],right_units:[c.CoordinateUnits,"data"],top_limit:[g.Limit,null],bottom_limit:[g.Limit,null],left_limit:[g.Limit,null],right_limit:[g.Limit,null],min_width:[r(e),0],min_height:[r(e),0],max_width:[s(e),1/0],max_height:[s(e),1/0],border_radius:[f.BorderRadius,0],editable:[t,!1],resizable:[g.Resizable,"all"],movable:[g.Movable,"both"],symmetric:[t,!1]}))),n.internal((({Str:t})=>({tl_cursor:[t,"nwse-resize"],tr_cursor:[t,"nesw-resize"],bl_cursor:[t,"nesw-resize"],br_cursor:[t,"nwse-resize"],ew_cursor:[t,"ew-resize"],ns_cursor:[t,"ns-resize"],in_cursor:[t,"move"]}))),n.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3,hover_fill_color:null,hover_fill_alpha:.4,hover_line_color:null,hover_line_alpha:.3})},
function _(t,o,e,n,l){n();const r=t(21),m=t(59);e.Corner=(0,r.Enum)("top_left","top_right","bottom_left","bottom_right"),e.Edge=(0,r.Enum)("left","right","top","bottom"),e.HitTarget=(0,r.Enum)(...e.Corner,...e.Edge,"area"),e.Resizable=(0,r.Enum)("none","left","right","top","bottom","x","y","all"),e.Movable=(0,r.Enum)("none","x","y","both"),e.Limit=(0,r.Nullable)((0,r.Or)(r.Float,(0,r.Ref)(m.Node)))},
function _(e,i,n,t,a){var o;t();const l=e(167),r=e(262),s=e(238),_=e(212),c=e(267),h=e(252),p=e(250),g=e(197),m=e(10),d=e(12);class u extends l.BaseColorBarView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.color_mapper.change,(async()=>{this._title_view.remove(),this._axis_view.remove(),this.initialize(),await this.lazy_initialize(),this.plot_view.invalidate_layout()})),this.connect(this.model.color_mapper.metrics_change,(()=>this._metrics_changed())),this.connect(this.model.properties.display_low.change,(()=>this._metrics_changed())),this.connect(this.model.properties.display_high.change,(()=>this._metrics_changed()))}get color_mapper(){let e=this.model.color_mapper;return e instanceof c.WeightedStackColorMapper&&(e=e.alpha_mapper),e}update_layout(){super.update_layout(),this._set_canvas_image()}_create_axis(){const{color_mapper:e}=this;return e instanceof c.CategoricalColorMapper?new r.CategoricalAxis:e instanceof c.LogColorMapper?new r.LogAxis:new r.LinearAxis}_create_formatter(){const{color_mapper:e}=this;return this._ticker instanceof g.LogTicker?new s.LogTickFormatter:e instanceof c.CategoricalColorMapper?new s.CategoricalTickFormatter:new s.BasicTickFormatter}_create_major_range(){const{color_mapper:e}=this;if(e instanceof c.CategoricalColorMapper)return new h.FactorRange({factors:e.factors});if(e instanceof c.ContinuousColorMapper){const{min:i,max:n}=this._continuous_metrics(e);return new h.Range1d({start:i,end:n})}(0,d.unreachable)()}_create_major_scale(){const{color_mapper:e}=this;return e instanceof c.LinearColorMapper?new p.LinearScale:e instanceof c.LogColorMapper?new p.LogScale:e instanceof c.ScanningColorMapper?new p.LinearInterpolationScale({binning:this._scanning_binning(e)}):e instanceof c.CategoricalColorMapper?new p.CategoricalScale:void(0,d.unreachable)()}_create_ticker(){const{color_mapper:e}=this;return e instanceof c.LogColorMapper?new g.LogTicker:e instanceof c.ScanningColorMapper?new g.BinnedTicker({mapper:e}):e instanceof c.CategoricalColorMapper?new g.CategoricalTicker:new g.BasicTicker}_continuous_metrics(e){const{display_low:i,display_high:n}=this.model;let{min:t,max:a}=e.metrics;if(null!=n&&null!=i&&n<i)return this._index_low=0,this._index_high=-1,{min:NaN,max:NaN};if(this._index_high=null,null!=n){const i=e.palette.length,t=e.value_to_index(n,i);t<i-1&&(this._index_high=t,a=e.index_to_value(t+1))}if(this._index_low=null,null!=i){const n=e.value_to_index(i,e.palette.length);n>0&&(this._index_low=n,t=e.index_to_value(n))}return{min:t,max:a}}_get_major_size_factor(){return this.color_mapper.palette.length}_metrics_changed(){const e=this._major_range,i=this._major_scale,{color_mapper:n}=this;if(n instanceof c.ScanningColorMapper&&i instanceof p.LinearInterpolationScale){const e=this._scanning_binning(n);i.binning=e;const t="vertical"==this.orientation,a=t?this._frame.y_scale:this._frame.x_scale;if(a instanceof p.LinearInterpolationScale){a.binning=e;const i=t?this._frame.y_range:this._frame.x_range;i instanceof h.Range1d&&(i.start=e[0],i.end=e[e.length-1])}}else if(n instanceof c.ContinuousColorMapper&&e instanceof h.Range1d){const{min:i,max:t}=this._continuous_metrics(n);e.setv({start:i,end:t})}this._set_canvas_image(),this.plot_view.request_layout()}_paint_colors(e,i){const{x:n,y:t,width:a,height:o}=i;e.save(),e.globalAlpha=this.model.scale_alpha,null!=this._image&&(e.imageSmoothingEnabled=!1,e.drawImage(this._image,n,t,a,o)),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(e),e.strokeRect(n,t,a,o)),e.restore()}_scanning_binning(e){let{binning:i,force_low_cutoff:n}=e.metrics;const{display_high:t}=this.model;let{display_low:a}=this.model;if(n&&(null==a||e.metrics.min>a)&&(a=e.metrics.min),null!=t&&null!=a&&t<a)return this._index_low=0,this._index_high=-1,[NaN];if(this._index_high=null,null!=t){const n=e.value_to_index(t,i.length);n<i.length-1&&(this._index_high=n)}if(this._index_low=null,null!=a){const n=e.value_to_index(a,i.length);n>0&&(this._index_low=n)}if(null!=this._index_low||null!=this._index_high){const e=null!=this._index_low?this._index_low:0,n=(null!=this._index_high?this._index_high+1:i.length-1)-e+1;if(n>0){const t=new Array(n);for(let a=0;a<n;a++)t[a]=i[a+e];i=t}else i=[NaN]}return i}_set_canvas_image(){const{orientation:e}=this;let{palette:i}=this.color_mapper;if(null==this._index_high&&null==this._index_low||(i=i.slice(null!=this._index_low?this._index_low:0,null!=this._index_high?this._index_high+1:i.length)),i.length<1)return void(this._image=null);"vertical"==e&&(i=(0,m.reversed)(i));const[n,t]="vertical"==e?[1,i.length]:[i.length,1],a=this._image=document.createElement("canvas");a.width=n,a.height=t;const o=a.getContext("2d"),l=o.getImageData(0,0,n,t),r=new c.LinearColorMapper({palette:i}).rgba_mapper.v_compute((0,m.range)(0,i.length));l.data.set(r),o.putImageData(l,0,0)}}n.ColorBarView=u,u.__name__="ColorBarView";class f extends l.BaseColorBar{constructor(e){super(e)}}n.ColorBar=f,o=f,f.__name__="ColorBar",o.prototype.default_view=u,o.define((({Nullable:e,Float:i,Ref:n})=>({color_mapper:[n(_.ColorMapper)],display_low:[e(i),null],display_high:[e(i),null]})))},
function _(i,s,x,A,o){A(),o("Axis",i(186).Axis),o("CategoricalAxis",i(263).CategoricalAxis),o("ContinuousAxis",i(192).ContinuousAxis),o("DatetimeAxis",i(264).DatetimeAxis),o("LinearAxis",i(191).LinearAxis),o("LogAxis",i(265).LogAxis),o("MercatorAxis",i(266).MercatorAxis)},
function _(t,s,o,e,i){var r;e();const a=t(1),l=t(186),_=t(198),n=t(239),p=a.__importStar(t(85)),c=t(20),h=t(177),m=t(8);class u extends l.AxisView{_paint(t,s,o){this._draw_group_separators(t,s,o)}_draw_group_separators(t,s,o){const[e]=this.ranges,[i,r]=this.computed_bounds;if(null==e.tops||e.tops.length<2||!this.visuals.separator_line.doit)return;const a=this.dimension,l=1-a,_=[[],[]];let n=0;for(let t=0;t<e.tops.length-1;t++){let s,o;for(let i=n;i<e.factors.length;i++)if(e.factors[i][0]==e.tops[t+1]){[s,o]=[e.factors[i-1],e.factors[i]],n=i;break}const p=(e.synthetic(s)+e.synthetic(o))/2;p>i&&p<r&&(_[a].push(p),_[l].push(this.loc))}const p=this.extents.tick_label;this._draw_ticks(t,_,-3,p-6,this.visuals.separator_line)}_draw_major_labels(t,s,o){const e=this._get_factor_info();let i=s.tick+this.model.major_label_standoff;for(let o=0;o<e.length;o++){const[r,a,l,_]=e[o];this._draw_oriented_labels(t,r,a,l,i,_),i+=s.tick_labels[o]}}_tick_label_extents(){const t=this._get_factor_info(),s=[];for(const[o,,e,i]of t){const t=this._oriented_labels_extent(o,e,this.model.major_label_standoff,i);s.push(t)}return s}_get_factor_info(){const[t]=this.ranges,[s,o]=this.computed_bounds,e=this.loc,i=this.model.ticker.get_ticks(s,o,t,e),r=this.tick_coords,a=[],l=t=>new h.GraphicsBoxes(t.map((t=>(0,m.isString)(t)?new h.TextBox({text:t}):t))),_=t=>l(this.model.formatter.doFormat(t,this));if(1==t.levels){const t=_(i.major);a.push([t,r.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){const t=_(i.major.map((t=>t[1])));a.push([t,r.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([l(i.tops),r.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){const t=_(i.major.map((t=>t[2]))),s=i.mids.map((t=>t[1]));a.push([t,r.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([l(s),r.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),a.push([l(i.tops),r.tops,this.model.group_label_orientation,this.visuals.group_text])}return a}get tick_coords(){const t=this.dimension,s=1-t,[o]=this.ranges,[e,i]=this.computed_bounds,r=this.model.ticker.get_ticks(e,i,o,this.loc),a={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return a.major[t]=r.major,a.major[s]=r.major.map((()=>this.loc)),3==o.levels&&(a.mids[t]=r.mids,a.mids[s]=r.mids.map((()=>this.loc))),o.levels>1&&(a.tops[t]=r.tops,a.tops[s]=r.tops.map((()=>this.loc))),a}}o.CategoricalAxisView=u,u.__name__="CategoricalAxisView";class d extends l.Axis{constructor(t){super(t)}}o.CategoricalAxis=d,r=d,d.__name__="CategoricalAxis",r.prototype.default_view=u,r.mixins([["separator_",p.Line],["group_",p.Text],["subgroup_",p.Text]]),r.define((({Float:t,Or:s})=>({group_label_orientation:[s(c.LabelOrientation,t),"parallel"],subgroup_label_orientation:[s(c.LabelOrientation,t),"parallel"]}))),r.override({ticker:()=>new _.CategoricalTicker,formatter:()=>new n.CategoricalTickFormatter,separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"11px",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"11px"})},
function _(e,t,i,s,a){var n;s();const o=e(192),r=e(240),m=e(200);class _ extends o.ContinuousAxisView{}i.DatetimeAxisView=_,_.__name__="DatetimeAxisView";class c extends o.ContinuousAxis{constructor(e){super(e)}}i.DatetimeAxis=c,n=c,c.__name__="DatetimeAxis",n.prototype.default_view=_,n.override({ticker:()=>new m.DatetimeTicker,formatter:()=>new r.DatetimeTickFormatter})},
function _(e,o,i,s,t){var n;s();const r=e(192),_=e(246),c=e(207);class a extends r.ContinuousAxisView{}i.LogAxisView=a,a.__name__="LogAxisView";class u extends r.ContinuousAxis{constructor(e){super(e)}}i.LogAxis=u,n=u,u.__name__="LogAxis",n.prototype.default_view=a,n.override({ticker:()=>new c.LogTicker,formatter:()=>new _.LogTickFormatter})},
function _(e,r,t,i,a){var o;i();const s=e(186),c=e(191),n=e(247),_=e(208);class x extends s.AxisView{}t.MercatorAxisView=x,x.__name__="MercatorAxisView";class d extends c.LinearAxis{constructor(e){super(e)}}t.MercatorAxis=d,o=d,d.__name__="MercatorAxis",o.prototype.default_view=x,o.override({ticker:()=>new _.MercatorTicker({dimension:"lat"}),formatter:()=>new n.MercatorTickFormatter({dimension:"lat"})})},
function _(r,o,a,p,e){p(),e("CategoricalColorMapper",r(268).CategoricalColorMapper),e("CategoricalMarkerMapper",r(270).CategoricalMarkerMapper),e("CategoricalPatternMapper",r(271).CategoricalPatternMapper),e("ContinuousColorMapper",r(211).ContinuousColorMapper),e("ColorMapper",r(212).ColorMapper),e("LinearColorMapper",r(272).LinearColorMapper),e("LogColorMapper",r(273).LogColorMapper),e("ScanningColorMapper",r(210).ScanningColorMapper),e("EqHistColorMapper",r(274).EqHistColorMapper),e("StackColorMapper",r(275).StackColorMapper),e("WeightedStackColorMapper",r(276).WeightedStackColorMapper)},
function _(t,o,a,r,e){var c;r();const l=t(269),s=t(212),n=t(105);class _ extends s.ColorMapper{constructor(t){super(t)}_v_compute(t,o,a,{nan_color:r}){(0,l.cat_v_compute)(t,this.factors,a,o,this.start,this.end,r)}}a.CategoricalColorMapper=_,c=_,_.__name__="CategoricalColorMapper",c.define((({Float:t,Nullable:o})=>({factors:[n.FactorSeq],start:[t,0],end:[o(t),null]})))},
function _(n,t,e,o,i){o();const c=n(13),f=n(8);function l(n,t){if(n.length!=t.length)return!1;const e=n.length;for(let o=0;o<e;o++)if(n[o]!==t[o])return!1;return!0}e._cat_equals=l,e.cat_v_compute=function(n,t,e,o,i,r,s){let u=0;for(const _ of n){let n;if((0,f.isArray)(_)){const e=_.slice(i,r??void 0);n=1==e.length?(0,c.index_of)(t,e[0]):(0,c.find_index)(t,(n=>l(n,e)))}else n=(0,c.index_of)(t,_);const d=n in e?e[n]:s;o[u++]=d}}},
function _(e,r,a,t,s){var c;t();const l=e(269),n=e(105),o=e(213),u=e(20);class i extends o.Mapper{constructor(e){super(e)}v_compute(e){const r=new Array(e.length);return(0,l.cat_v_compute)(e,this.factors,this.markers,r,this.start,this.end,this.default_value),r}}a.CategoricalMarkerMapper=i,c=i,i.__name__="CategoricalMarkerMapper",c.define((({Float:e,List:r,Nullable:a})=>({factors:[n.FactorSeq],markers:[r(u.MarkerType)],start:[e,0],end:[a(e),null],default_value:[u.MarkerType,"circle"]})))},
function _(t,e,a,r,n){var s;r();const c=t(269),l=t(105),o=t(213),p=t(20);class u extends o.Mapper{constructor(t){super(t)}v_compute(t){const e=new Array(t.length);return(0,c.cat_v_compute)(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e}}a.CategoricalPatternMapper=u,s=u,u.__name__="CategoricalPatternMapper",s.define((({Float:t,List:e,Nullable:a})=>({factors:[l.FactorSeq],patterns:[e(p.HatchPatternType)],start:[t,0],end:[a(t),null],default_value:[p.HatchPatternType," "]})))},
function _(n,r,o,t,a){t();const e=n(211),i=n(13),s=n(11);class _ extends e.ContinuousColorMapper{constructor(n){super(n)}scan(n,r){const o=null!=this.low?this.low:(0,i.min)(n),t=null!=this.high?this.high:(0,i.max)(n);return{max:t,min:o,norm_factor:1/(t-o),normed_interval:1/r}}index_to_value(n){const r=this._scan_data;return r.min+r.normed_interval*n/r.norm_factor}value_to_index(n,r){const o=this._scan_data;if(n==o.max)return r-1;const t=(n-o.min)*o.norm_factor,a=Math.floor(t/o.normed_interval);return(0,s.clamp)(a,-1,r)}}o.LinearColorMapper=_,_.__name__="LinearColorMapper"},
function _(n,t,a,o,s){o();const r=n(211),e=n(13),i=n(11);class l extends r.ContinuousColorMapper{constructor(n){super(n)}scan(n,t){const a=null!=this.low?this.low:(0,e.min)(n),o=null!=this.high?this.high:(0,e.max)(n);return{max:o,min:a,scale:t/Math.log(o/a)}}index_to_value(n){const t=this._scan_data;return t.min*Math.exp(n/t.scale)}value_to_index(n,t){const a=this._scan_data;if(n==a.max)return t-1;if(n>a.max)return t;if(n<a.min)return-1;const o=Math.log(n/a.min),s=Math.floor(o*a.scale);return(0,i.clamp)(s,-1,t)}}a.LogColorMapper=l,l.__name__="LogColorMapper"},
function _(e,n,s,t,l){var o;t();const i=e(210),r=e(13),c=e(10);class a extends i.ScanningColorMapper{constructor(e){super(e)}scan(e,n){const s=null!=this.low?this.low:(0,r.min)(e),t=null!=this.high?this.high:(0,r.max)(e),l=this.bins,o=(0,c.linspace)(s,t,l+1),i=(0,r.bin_counts)(e,o);let a=0;for(let e=0;e<l;e++)0!=i[e]&&a++;const _=new Array(a+1),h=new Array(a+1);for(let e=0,n=1;e<l;e++)0!=i[e]&&(_[n]=i[e],h[n]=(o[e]+o[e+1])/2,n++);_[0]=0,h[0]=2*h[1]-h[a];const f=(0,c.cumsum)(_),p=f[1],u=f[a]-p;for(let e=1;e<=a;e++)f[e]=(f[e]-p)/u;f[0]=-1;let{rescale_discrete_levels:m}=this,d=0;if(m){const e=-.5/98,n=e*a+(1.5-2*e);n>1?d=1-n:m=!1}const g=(0,c.linspace)(d,1,n+1),w=(0,r.interpolate)(g,f,h);let b=!1;if(m){const e=(0,r.sorted_index)(w,s);s<w[e]&&e>0&&(w[e-1]=s),b=!0}else w[0]=s;return w[w.length-1]=t,{min:s,max:t,binning:w,force_low_cutoff:b}}}s.EqHistColorMapper=a,o=a,a.__name__="EqHistColorMapper",o.define((({Bool:e,Int:n})=>({bins:[n,65536],rescale_discrete_levels:[e,!1]})))},
function _(o,r,a,c,e){c();const p=o(212);class t extends p.ColorMapper{constructor(o){super(o)}}a.StackColorMapper=t,t.__name__="StackColorMapper"},
function _(e,t,o,a,r){var l;a();const n=e(212),s=e(211),c=e(275),_=e(24),i=e(13),p=e(12),u=e(22);class h extends c.StackColorMapper{constructor(e){super(e)}_mix_colors(e,t,o,a){if(isNaN(a))return t;let r=0,l=0,n=0,s=0;const c=o.length;if(0!=a)for(let t=0;t<c;t++){if(isNaN(o[t]))continue;const c=o[t]/a;r+=e[4*t]*c,l+=e[4*t+1]*c,n+=e[4*t+2]*c,s+=e[4*t+3]*c}else{let t=0;for(let a=0;a<c;a++)0==o[a]&&(r+=e[4*a],l+=e[4*a+1],n+=e[4*a+2],s+=e[4*a+3],t++);r/=t,l/=t,n/=t,s/=t}return(0,u.encode_rgba)([(0,u.byte)(r),(0,u.byte)(l),(0,u.byte)(n),(0,u.byte)(s)])}_v_compute(e,t,o,a){(0,p.unreachable)()}_v_compute_uint32(e,t,o,a){const r=t.length,l=o.length,s=e.length/r;(0,p.assert)(s==l,`Expected ${s} not ${l} colors in palette`);const c=new _.RGBAArray(4*l);for(let e=0;e<l;e++){const[t,a,r,l]=(0,u.decode_rgba)(o[e]);c[4*e]=t,c[4*e+1]=a,c[4*e+2]=r,c[4*e+3]=l}const h=this.color_baseline,b=h??(0,i.min)(e),{nan_color:f}=a,m=new Array(r),N=new Array(l);for(let o=0;o<r;o++){let a=NaN;for(let t=0;t<l;t++){const r=o*l+t,n=0==b?e[r]:Math.max(e[r]-b,0);N[t]=n,isNaN(n)||(isNaN(a)?a=n:a+=n)}t[o]=this._mix_colors(c,f,N,a),m[o]=a+b*l}const y=(0,n._convert_palette)(this.alpha_mapper.palette),d=new Uint32Array(r);this.alpha_mapper._v_compute(m,d,y,a);for(let e=0;e<r;e++){const o=(0,u.byte)((255&t[e])*(255&d[e])/255);t[e]=4294967040&t[e]|o}}}o.WeightedStackColorMapper=h,l=h,h.__name__="WeightedStackColorMapper",l.define((({List:e,Nullable:t,Float:o,Ref:a,Str:r})=>({alpha_mapper:[a(s.ContinuousColorMapper)],color_baseline:[t(o),null],stack_labels:[t(e(r)),null]})))},
function _(e,t,i,r,l){var n;r();const o=e(167),s=e(252),a=e(214),_=e(56),h=e(12);class d extends o.BaseColorBarView{*children(){yield*super.children(),yield this._fill_view,yield this._line_view}async lazy_initialize(){await super.lazy_initialize();const{fill_renderer:e,line_renderer:t}=this.model;this._fill_view=await(0,_.build_view)(e,{parent:this.parent}),this._line_view=await(0,_.build_view)(t,{parent:this.parent})}remove(){this._fill_view.remove(),this._line_view.remove(),super.remove()}_create_major_range(){const e=this.model.levels;return e.length>0?new s.Range1d({start:e[0],end:e[e.length-1]}):new s.Range1d({start:0,end:1})}_paint_colors(e,t){const i="vertical"==this.orientation,r=this.model.levels,l=this._major_scale;l.source_range=this._major_range,l.target_range=i?new s.Range1d({start:t.bottom,end:t.top}):new s.Range1d({start:t.left,end:t.right});const n=l.v_compute(r),o=this._fill_view.glyph,a=o.data_size;if(a>0){(0,h.assert)(r.length==a+1,"Inconsistent number of filled contour levels"),e.save();for(let r=0;r<a;r++)e.beginPath(),i?e.rect(t.left,n[r],t.width,n[r+1]-n[r]):e.rect(n[r],t.top,n[r+1]-n[r],t.height),o.visuals.fill.apply(e,r),o.visuals.hatch.apply(e,r);e.restore()}const _=this._line_view.glyph,d=_.data_size;if(d>0){(0,h.assert)(r.length==d,"Inconsistent number of line contour levels"),e.save();for(let r=0;r<d;r++)e.beginPath(),i?(e.moveTo(t.left,n[r]),e.lineTo(t.right,n[r])):(e.moveTo(n[r],t.bottom),e.lineTo(n[r],t.top)),_.visuals.line.set_vectorize(e,r),e.stroke();e.restore()}}}i.ContourColorBarView=d,d.__name__="ContourColorBarView";class v extends o.BaseColorBar{constructor(e){super(e)}}i.ContourColorBar=v,n=v,v.__name__="ContourColorBar",n.prototype.default_view=d,n.define((({List:e,Float:t,Ref:i})=>({fill_renderer:[i(a.GlyphRenderer)],line_renderer:[i(a.GlyphRenderer)],levels:[e(t),[]]})))},
function _(t,e,n,s,a){var i;s();const o=t(1),r=t(169),_=t(11),l=t(20),h=t(12),c=t(15),u=t(112),d=t(182),x=o.__importStar(t(183)),p=t(60);function m(t,e){return{x:t,y:e}}class g extends r.TextAnnotationView{constructor(){super(...arguments),this._pan_state=null}get mappers(){function t(t,e,n,s){switch(t){case"canvas":return s;case"screen":return n;case"data":return e}}const e=this.model,n=this.layout??this.plot_view.frame,{x_scale:s,y_scale:a}=this.coordinates,{x_view:i,y_view:o}=n.bbox,{x_screen:r,y_screen:_}=this.plot_view.canvas.bbox;return{x:t(e.x_units,s,i,r),y:t(e.y_units,a,o,_)}}get anchor(){const{align:t,baseline:e}=this.visuals.text.values();return x.text_anchor(this.model.anchor,t,e)}get angle(){const{angle:t,angle_units:e,direction:n}=this.model;return(0,_.compute_angle)(t,e,n)}get origin(){const{mappers:t}=this,{x:e,y:n,x_offset:s,y_offset:a}=this.model,i=(t,e,n)=>e instanceof p.Coordinate?this.resolve_as_scalar(e,t):n.compute(e);return{sx:i("x",e,t.x)+s,sy:i("y",n,t.y)-a}}interactive_hit(t,e){return!(!this.model.visible||!this.model.editable)&&"area"==this._hit_test(t,e)}_hit_test(t,e){const{sx:n,sy:s,anchor:a,angle:i,width:o,height:r}=this._rect,{x:_,y:l}=(0,u.rotate_around)(m(t,e),m(n,s),-i),h=n-a.x*o,c=s-a.y*r;return h<=_&&_<=h+o&&c<=l&&l<=c+r?"area":null}_can_hit(t){return!0}on_pan_start(t){if(this.model.visible&&this.model.editable){const{sx:e,sy:n}=t,s=this._hit_test(e,n);if(null!=s&&this._can_hit(s))return this._pan_state={angle:this.angle,base:{sx:e,sy:n},target:s,action:"rotate"},this.model.pan.emit(["pan:start",t.modifiers]),!0}return!1}on_pan(t){(0,h.assert)(null!=this._pan_state);const{dx:e,dy:n}=t,{angle:s,base:a}=this._pan_state,{origin:i}=this,o=(0,_.atan2)([i.sx,i.sy],[a.sx,a.sy]),r=(s+((0,_.atan2)([i.sx,i.sy],[a.sx+e,a.sy+n])-o))%(2*Math.PI),{angle_units:l,direction:c}=this.model;this.model.angle=(0,_.invert_angle)(r,l,c),this.model.pan.emit(["pan",t.modifiers])}on_pan_end(t){this._pan_state=null,this.model.pan.emit(["pan:end",t.modifiers])}cursor(t,e){const n=this._pan_state?.target??this._hit_test(t,e);return null!=n&&this._can_hit(n)?"var(--bokeh-cursor-rotate)":null}}n.LabelView=g,g.__name__="LabelView";class y extends r.TextAnnotation{constructor(t){super(t),this.pan=new c.Signal(this,"pan")}}n.Label=y,i=y,y.__name__="Label",i.prototype.default_view=g,i.define((({Bool:t,Float:e,Angle:n,Or:s,Ref:a})=>({anchor:[d.TextAnchor,"auto"],x:[s(e,a(p.Coordinate))],y:[s(e,a(p.Coordinate))],x_units:[l.CoordinateUnits,"data"],y_units:[l.CoordinateUnits,"data"],x_offset:[e,0],y_offset:[e,0],angle:[n,0],angle_units:[l.AngleUnits,"rad"],direction:[l.Direction,"anticlock"],editable:[t,!1]})))},
function _(t,e,i,s,a){var n;s();const o=t(1),l=t(124),r=o.__importStar(t(85)),c=t(20),_=t(177),u=o.__importStar(t(18)),x=t(24);class h extends l.DataAnnotationView{map_data(){const{x_scale:t,y_scale:e}=this.coordinates,i=null!=this.layout?this.layout:this.plot_view.frame;this.sx=(()=>{switch(this.model.x_units){case"canvas":return new x.ScreenArray(this._x);case"screen":return i.bbox.xview.v_compute(this._x);case"data":return t.v_compute(this._x)}})(),this.sy=(()=>{switch(this.model.y_units){case"canvas":return new x.ScreenArray(this._y);case"screen":return i.bbox.yview.v_compute(this._y);case"data":return e.v_compute(this._y)}})()}paint(){const{ctx:t}=this.layer;for(let e=0,i=this.text.length;e<i;e++){const i=this.x_offset.get(e),s=this.y_offset.get(e),a=this.sx[e]+i,n=this.sy[e]-s,o=this.angle.get(e),l=this.text.get(e);isFinite(a+n+o)&&null!=l&&this._paint(t,e,`${l}`,a,n,o)}}_paint(t,e,i,s,a,n){const o=new _.TextBox({text:i});o.angle=n,o.position={sx:s,sy:a},o.visuals=this.visuals.text.values(e);const{background_fill:l,border_line:r}=this.visuals;if(l.doit||r.doit){const{p0:i,p1:s,p2:a,p3:n}=o.rect();t.beginPath(),t.moveTo(i.x,i.y),t.lineTo(s.x,s.y),t.lineTo(a.x,a.y),t.lineTo(n.x,n.y),t.closePath(),this.visuals.background_fill.apply(t,e),this.visuals.border_line.apply(t,e)}this.visuals.text.doit&&o.paint(t)}}i.LabelSetView=h,h.__name__="LabelSetView";class d extends l.DataAnnotation{constructor(t){super(t)}}i.LabelSet=d,n=d,d.__name__="LabelSet",n.prototype.default_view=h,n.mixins([r.TextVector,["border_",r.LineVector],["background_",r.FillVector]]),n.define((()=>({x:[u.XCoordinateSpec,{field:"x"}],y:[u.YCoordinateSpec,{field:"y"}],x_units:[c.CoordinateUnits,"data"],y_units:[c.CoordinateUnits,"data"],text:[u.NullStringSpec,{field:"text"}],angle:[u.AngleSpec,0],x_offset:[u.NumberSpec,{value:0}],y_offset:[u.NumberSpec,{value:0}]}))),n.override({background_fill_color:null,border_line_color:null})},
function _(t,e,i,s,n){var o;s();const l=t(1),r=t(79),a=t(281),c=t(20),h=l.__importStar(t(85)),_=t(15),d=t(170),b=t(64),u=t(10),g=t(34),p=t(8),m=t(177),f=t(253),{max:x,ceil:w}=Math;class y extends f.ContentLayoutable{constructor(t,e,i,s){super(),this.item=t,this.label=e,this.text=i,this.settings=s}get field(){return this.item.get_field_from_label_prop()}_content_size(){const t=this.text.size(),{glyph_width:e,glyph_height:i,label_standoff:s,label_width:n,label_height:o}=this.settings,l=e+s+x(t.width,n),r=x(i,t.height,o);return new f.Sizeable({width:l,height:r})}}y.__name__="LegendEntry";class v extends r.AnnotationView{constructor(){super(...arguments),this.bbox=new b.BBox}_get_size(){const{width:t,height:e}=this.bbox,{margin:i}=this.model;return{width:t+2*i,height:e+2*i}}update_layout(){this.update_geometry();const{panel:t}=this;this.layout=null!=t?new d.SideLayout(t,(()=>this.get_size())):void 0}connect_signals(){super.connect_signals();const t=()=>this.request_render();this.connect(this.model.change,t),this.connect(this.model.item_change,t)}get padding(){return null!=this.model.border_line_color?this.model.padding:0}update_geometry(){super.update_geometry();const{spacing:t,orientation:e}=this.model,i="vertical"==e,{padding:s}=this,n=s,o=s,{title:l}=this.model,r=new m.TextBox({text:l??""});r.position={sx:0,sy:0,x_anchor:"left",y_anchor:"top"},r.visuals=this.visuals.title_text.values();const a=new d.SidePanel(this.model.title_location);r.angle=a.get_label_angle_heuristic("parallel");const c=[];for(const t of this.model.items){t.legend=this.model;const e=t.get_labels_list_from_label_prop();for(const i of e){const e=new m.TextBox({text:`${i}`});e.position={sx:0,sy:0,x_anchor:"left",y_anchor:"center"},e.visuals=this.visuals.label_text.values();const s=new y(t,i,e,this.model);s.set_sizing({visible:t.visible}),c.push({layout:s,row:0,col:0})}}const{ncols:h,nrows:_}=(()=>{let{ncols:t,nrows:e}=this.model;const s=c.length;return i?("auto"!=e||(e="auto"!=t?w(s/t):1/0),t=1/0):("auto"!=t||(t="auto"!=e?w(s/e):1/0),e=1/0),{ncols:t,nrows:e}})();let u=0,g=0;for(const t of c)t.row=u,t.col=g,i?(u+=1,u>=_&&(u=0,g+=1)):(g+=1,g>=h&&(g=0,u+=1));const p=new f.Grid(c);this.grid=p,p.spacing=t,p.set_sizing();const x=new f.TextLayout(r);this.title_panel=x;const v=""!=r.text&&this.visuals.title_text.doit;x.set_sizing({visible:v});const k=(()=>{if(!v)return new f.Column([p]);switch(this.model.title_location){case"above":return new f.Column([x,p]);case"below":return new f.Column([p,x]);case"left":return new f.Row([x,p]);case"right":return new f.Row([p,x])}})();this.border_box=k,k.position={left:n,top:o},k.spacing=this.model.title_standoff,k.set_sizing(),k.compute();const L=s+k.bbox.width+s,z=s+k.bbox.height+s;this.bbox=new b.BBox({left:0,top:0,width:L,height:z})}compute_geometry(){super.compute_geometry();const{margin:t,location:e}=this.model,{width:i,height:s}=this.bbox,n=null!=this.layout?this.layout:this.plot_view.frame,[o,l]=n.bbox.ranges;let r,a;if((0,p.isString)(e))switch(e){case"top_left":r=o.start+t,a=l.start+t;break;case"top":case"top_center":r=(o.end+o.start)/2-i/2,a=l.start+t;break;case"top_right":r=o.end-t-i,a=l.start+t;break;case"bottom_right":r=o.end-t-i,a=l.end-t-s;break;case"bottom":case"bottom_center":r=(o.end+o.start)/2-i/2,a=l.end-t-s;break;case"bottom_left":r=o.start+t,a=l.end-t-s;break;case"left":case"center_left":r=o.start+t,a=(l.end+l.start)/2-s/2;break;case"center":case"center_center":r=(o.end+o.start)/2-i/2,a=(l.end+l.start)/2-s/2;break;case"right":case"center_right":r=o.end-t-i,a=(l.end+l.start)/2-s/2}else{const[t,i]=e;r=n.bbox.xview.compute(t),a=n.bbox.yview.compute(i)-s}this.bbox=new b.BBox({left:r,top:a,width:i,height:s})}interactive_hit(t,e){return this.bbox.contains(t,e)}_hit_test(t,e){const{left:i,top:s}=this.bbox;t-=i+this.grid.bbox.left,e-=s+this.grid.bbox.top;for(const i of this.grid)if(i.bbox.contains(t,e))return{type:"entry",entry:i};return null}cursor(t,e){return"none"==this.model.click_policy?null:null!=this._hit_test(t,e)?"pointer":null}on_hit(t,e){const i=(()=>{switch(this.model.click_policy){case"hide":return t=>t.visible=!t.visible;case"mute":return t=>t.muted=!t.muted;case"none":return t=>{}}})(),s=this._hit_test(t,e);if(null!=s){const{renderers:t}=s.entry.item;for(const e of t)i(e);return!0}return!1}_render(){if(this.update_geometry(),this.compute_geometry(),0==this.model.items.length)return;if(!(0,u.some)(this.model.items,(t=>t.visible)))return;const{ctx:t}=this.layer;t.save(),this._draw_legend_box(t),this._draw_legend_items(t),this._draw_title(t),t.restore()}_draw_legend_box(t){const{x:e,y:i,width:s,height:n}=this.bbox;t.beginPath(),t.rect(e,i,s,n),this.visuals.background_fill.apply(t),this.visuals.border_line.apply(t)}_draw_title(t){const{title:e}=this.model;if(null==e||0==e.length||!this.visuals.title_text.doit)return;const{left:i,top:s}=this.bbox;switch(t.save(),t.translate(i,s),t.translate(this.title_panel.bbox.left,this.title_panel.bbox.top),this.model.title_location){case"left":t.translate(0,this.title_panel.bbox.height);break;case"right":t.translate(this.title_panel.bbox.width,0)}this.title_panel.text.paint(t),t.restore()}_draw_legend_items(t){const e=(()=>{switch(this.model.click_policy){case"none":return t=>!0;case"hide":return t=>(0,u.every)(t.renderers,(t=>t.visible));case"mute":return t=>(0,u.every)(t.renderers,(t=>!t.muted))}})(),i=(t,e,i)=>{if(!this.visuals.item_background_fill.doit)return!1;switch(this.model.item_background_policy){case"every":return!0;case"even":return e%2==0==(i%2==0);case"odd":return e%2==0!=(i%2==0);case"none":return!1}},{left:s,top:n}=this.bbox;t.translate(s,n),t.translate(this.grid.bbox.left,this.grid.bbox.top);for(const[{layout:s,row:n,col:o},l]of(0,g.enumerate)(this.grid.items)){const{bbox:l,text:r,item:a,label:c,field:h,settings:_}=s,{glyph_width:d,glyph_height:b,label_standoff:u}=_,{left:g,top:p,width:m,height:f}=l;t.translate(g,p),i(0,n,o)&&(t.beginPath(),t.rect(0,0,m,f),this.visuals.item_background_fill.apply(t));const x=f/2,w=0,y=x-b/2,v=w+d,k=y+b;for(const e of a.renderers){const i=this.plot_view.renderer_view(e);i?.draw_legend(t,w,v,y,k,h,c,a.index)}t.translate(v+u,x),r.paint(t),t.translate(-v-u,-x),e(a)||(t.beginPath(),t.rect(0,0,m,f),this.visuals.inactive_fill.set_value(t),t.fill()),t.translate(-g,-p)}t.translate(-this.grid.bbox.left,-this.grid.bbox.top),t.translate(-s,-n)}}i.LegendView=v,v.__name__="LegendView";class k extends r.Annotation{constructor(t){super(t)}initialize(){super.initialize(),this.item_change=new _.Signal0(this,"item_change")}}i.Legend=k,o=k,k.__name__="Legend",o.prototype.default_view=v,o.mixins([["label_",h.Text],["title_",h.Text],["inactive_",h.Fill],["border_",h.Line],["background_",h.Fill],["item_background_",h.Fill]]),o.define((({Float:t,Int:e,Str:i,List:s,Tuple:n,Or:o,Ref:l,Nullable:r,Positive:h,Auto:_})=>({orientation:[c.Orientation,"vertical"],ncols:[o(h(e),_),"auto"],nrows:[o(h(e),_),"auto"],location:[o(c.LegendLocation,n(t,t)),"top_right"],title:[r(i),null],title_location:[c.Location,"above"],title_standoff:[t,5],label_standoff:[t,5],glyph_height:[t,20],glyph_width:[t,20],label_height:[t,20],label_width:[t,20],margin:[t,10],padding:[t,10],spacing:[t,3],items:[s(l(a.LegendItem)),[]],click_policy:[c.LegendClickPolicy,"none"],item_background_policy:[c.AlternationPolicy,"none"]}))),o.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,item_background_fill_color:"#f1f1f1",item_background_fill_alpha:.8,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(e,r,n,l,t){var i;l();const s=e(1),o=e(51),_=e(214),a=e(125),u=e(28),d=s.__importStar(e(18)),c=e(19),h=e(10);class f extends o.Model{constructor(e){super(e)}_check_data_sources_on_renderers(){if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;const e=this.renderers[0].data_source;for(const r of this.renderers)if(r.data_source!=e)return!1}return!0}_check_field_label_on_data_source(){const e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;const r=this.renderers[0].data_source;if(!(0,h.includes)(r.columns(),e))return!1}return!0}initialize(){super.initialize(),this.legend=null,this.connect(this.change,(()=>this.legend?.item_change.emit()));this._check_data_sources_on_renderers()||c.logger.error("Non matching data sources on legend item renderers");this._check_field_label_on_data_source()||c.logger.error(`Bad column name on label: ${this.label}`)}get_field_from_label_prop(){const{label:e}=this;return(0,u.isField)(e)?e.field:null}get_labels_list_from_label_prop(){if(!this.visible)return[];const{index:e}=this;if(null!=e&&this.renderers.every((r=>!r.view.indices_map.has(e))))return[];if((0,u.isValue)(this.label)){const{value:e}=this.label;return null!=e?[e]:[]}const r=this.get_field_from_label_prop();if(null!=r){let e;if(0==this.renderers.length)return["No source found"];if(e=this.renderers[0].data_source,e instanceof a.ColumnarDataSource){const n=e.get_column(r);return null!=n?(0,h.uniq)(Array.from(n)):["Invalid field"]}}return[]}}n.LegendItem=f,i=f,f.__name__="LegendItem",i.define((({Bool:e,Int:r,List:n,Ref:l,Nullable:t})=>({label:[d.NullStringSpec,null],renderers:[n(l(_.GlyphRenderer)),[]],index:[t(r),null],visible:[e,!0]})))},
function _(t,e,s,n,i){var o,r;n();const a=t(1),l=t(79),h=t(102),_=a.__importStar(t(85)),c=t(20),y=t(225),d=t(15),p=t(64),u=t(13),v=t(12);class x{constructor(t=[],e=[]){this.xs=t,this.ys=e,(0,v.assert)(t.length==e.length)}clone(){return new x(this.xs.slice(),this.ys.slice())}[Symbol.iterator](){return this.nodes()}*nodes(){const{xs:t,ys:e,n:s}=this;for(let n=0;n<s;n++)yield[t[n],e[n],n]}*edges(){const{xs:t,ys:e,n:s}=this;for(let n=1;n<s;n++){const s={x:t[n-1],y:e[n-1]},i={x:t[n],y:e[n]};yield[s,i,n-1]}if(s>=3){const n={x:t[s-1],y:e[s-1]},i={x:t[0],y:e[0]};yield[n,i,s-1]}}contains(t,e){return(0,y.point_in_poly)(t,e,this.xs,this.ys)}get bbox(){const[t,e,s,n]=(0,u.minmax2)(this.xs,this.ys);return new p.BBox({x0:t,x1:e,y0:s,y1:n})}get n(){return this.xs.length}translate(t,e,...s){const n=this.clone(),{xs:i,ys:o,n:r}=n;if(0!=s.length)for(const n of s){const s=n%r;i[s]+=t,o[s]+=e}else for(let s=0;s<r;s++)i[s]+=t,o[s]+=e;return n}}x.__name__="Polygon";class m extends l.AnnotationView{constructor(){super(...arguments),this.poly=new x,this[o]=!0,this._pan_state=null,this._is_hovered=!1}serializable_state(){return{...super.serializable_state(),bbox:this.poly.bbox.round()}}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}bounds(){const{xs_units:t,ys_units:e}=this.model;if("data"==t&&"data"==e){const{xs:t,ys:e}=this.model,[s,n,i,o]=(0,u.minmax2)(t,e);return{x0:s,x1:n,y0:i,y1:o}}return(0,p.empty)()}log_bounds(){return(0,p.empty)()}_mappers(){const t=(t,e,s,n)=>{switch(t){case"canvas":return n;case"screen":return s;case"data":return e}},e=this.model,{frame:s,canvas:n}=this.plot_view,{x_scale:i,y_scale:o}=s,{x_view:r,y_view:a}=s.bbox,{x_screen:l,y_screen:h}=n.bbox;return{x:t(e.xs_units,i,r,l),y:t(e.ys_units,o,a,h)}}_render(){const{xs:t,ys:e}=this.model;(0,v.assert)(t.length==e.length),this.poly=(()=>{const{x:s,y:n}=this._mappers();return new x(s.v_compute(t),n.v_compute(e))})();const{ctx:s}=this.layer;s.beginPath();for(const[t,e]of this.poly)s.lineTo(t,e);const{_is_hovered:n,visuals:i}=this,o=n&&i.hover_fill.doit?i.hover_fill:i.fill,r=n&&i.hover_hatch.doit?i.hover_hatch:i.hatch,a=n&&i.hover_line.doit?i.hover_line:i.line;this.poly.n>=3&&(s.closePath(),o.apply(s),r.apply(s)),a.apply(s)}interactive_hit(t,e){return!(!this.model.visible||!this.model.editable)&&this.poly.contains(t,e)}_hit_test(t,e){const{abs:s}=Math,n=Math.max(2.5,this.model.line_width/2);for(const[i,o,r]of this.poly)if(s(i-t)<n&&s(o-e)<n)return{type:"node",i:r};const i={x:t,y:e};let o=null,r=1/0;for(const[t,e,s]of this.poly.edges()){const a=(0,y.dist_to_segment)(i,t,e);a<n&&a<r&&(r=a,o=s)}return null!=o?{type:"edge",i:o}:this.poly.contains(t,e)?{type:"area"}:null}_can_hit(t){return!0}on_pan_start(t){if(this.model.visible&&this.model.editable){const{sx:e,sy:s}=t,n=this._hit_test(e,s);if(null!=n&&this._can_hit(n))return this._pan_state={poly:this.poly.clone(),target:n},this.model.pan.emit(["pan:start",t.modifiers]),!0}return!1}on_pan(t){(0,v.assert)(null!=this._pan_state);const e=(()=>{const{poly:e,target:s}=this._pan_state,{dx:n,dy:i}=t;switch(s.type){case"node":{const{i:t}=s;return e.translate(n,i,t)}case"edge":{const{i:t}=s;return e.translate(n,i,t,t+1)}case"area":return e.translate(n,i)}})(),{x:s,y:n}=this._mappers(),i=s.v_invert(e.xs),o=n.v_invert(e.ys);this.model.update({xs:i,ys:o}),this.model.pan.emit(["pan",t.modifiers])}on_pan_end(t){this._pan_state=null,this.model.pan.emit(["pan:end",t.modifiers])}get _has_hover(){const{hover_line:t,hover_fill:e,hover_hatch:s}=this.visuals;return t.doit||e.doit||s.doit}on_enter(t){const{_has_hover:e}=this;return e&&(this._is_hovered=!0,this.request_paint()),e}on_move(t){}on_leave(t){this._has_hover&&(this._is_hovered=!1,this.request_paint())}cursor(t,e){const s=this._pan_state?.target??this._hit_test(t,e);if(null==s||!this._can_hit(s))return null;switch(s.type){case"node":case"edge":case"area":return"move"}}}s.PolyAnnotationView=m,o=h.auto_ranged,m.__name__="PolyAnnotationView";class f extends l.Annotation{constructor(t){super(t),this.pan=new d.Signal(this,"pan")}update({xs:t,ys:e}){this.setv({xs:t.slice(),ys:e.slice(),visible:!0})}clear(){this.setv({xs:[],ys:[],visible:!1})}}s.PolyAnnotation=f,r=f,f.__name__="PolyAnnotation",r.prototype.default_view=m,r.mixins([_.Line,_.Fill,_.Hatch,["hover_",_.Line],["hover_",_.Fill],["hover_",_.Hatch]]),r.define((({Bool:t,Float:e,Arrayable:s})=>({xs:[s(e),[]],ys:[s(e),[]],xs_units:[c.CoordinateUnits,"data"],ys_units:[c.CoordinateUnits,"data"],editable:[t,!1]}))),r.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3,hover_fill_color:null,hover_fill_alpha:.4,hover_line_color:null,hover_line_alpha:.3})},
function _(t,e,i,a,s){var o;a();const n=t(1),l=t(79),r=t(284),h=t(94),_=t(95),c=t(20),u=n.__importStar(t(85)),d=t(177),g=t(170),b=t(64),x=t(253),w=t(255),p=t(191),m=t(188),y=t(206),f=t(97),v=t(91),z=t(56),k=t(11),L=t(12),S=t(34),B=t(241),T=t(21),{round:A}=Math,R=(0,T.Enum)("adaptive","exact");class F extends l.AnnotationView{constructor(){super(...arguments),this.bbox=new b.BBox}_get_size(){const{width:t,height:e}=this.bbox,{margin:i}=this.model;return{width:t+2*i,height:e+2*i}}initialize(){super.initialize();const{ticker:t}=this.model;this.axis=new p.LinearAxis({ticker:t,...u.attrs_of(this.model,"bar_",u.Line,"axis_")}),this.range=(()=>{const{range:t,orientation:e}=this.model;if("auto"!=t)return t;{const{frame:t}=this.parent;switch(e){case"horizontal":return t.x_range;case"vertical":return t.y_range}}})()}async lazy_initialize(){await super.lazy_initialize();const t=(()=>{const t=new _.Range1d,e=new _.Range1d,i=new _.Range1d,a=new _.Range1d;return this.axis_scale=new f.LinearScale({source_range:t,target_range:e}),this.cross_scale=new f.LinearScale({source_range:i,target_range:a}),"horizontal"==this.model.orientation?new v.CoordinateTransform(this.axis_scale,this.cross_scale):new v.CoordinateTransform(this.cross_scale,this.axis_scale)})();this.axis_view=await(0,z.build_view)(this.axis,{parent:this.plot_view}),this.axis_view.coordinates=t,this.axis_view.panel=new g.SidePanel("horizontal"==this.model.orientation?"below":"right"),this.axis_view.update_layout()}remove(){this.axis_view.remove(),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>{this.request_render()})),this.connect(this.range.change,(()=>{this.request_render()}))}update_layout(){this.update_geometry();const{panel:t}=this;this.layout=null!=t?new g.SideLayout(t,(()=>this.get_size())):void 0}update_geometry(){super.update_geometry()}get horizontal(){return"horizontal"==this.model.orientation}text_layout(t){const{text:e,location:i,align:a,visuals:s}=t,{orientation:o}=this.model,n=new d.TextBox({text:e}),l=new g.SidePanel(i);n.visuals=s.values();const r=(()=>{switch(i){case"above":case"below":return"horizontal";default:return o}})();n.angle=l.get_label_angle_heuristic(r),n.base_font_size=this.plot_view.base_font_size,n.position={sx:0,sy:0,x_anchor:"left",y_anchor:"top"},n.align="auto";const h=new x.TextLayout(n);h.absolute=!0;const _="horizontal"==o,c=_?a:void 0,u=_?void 0:a;return h.set_sizing({width_policy:"min",height_policy:"min",visible:""!=e&&s.doit,halign:c,valign:u}),h}compute_geometry(){super.compute_geometry();const{orientation:t,bar_length:e,length_sizing:i,padding:a,margin:s,location:o}=this.model,{border_line:n,bar_line:l}=this.visuals,r=l.line_width.get_value(),h=n.line_width.get_value(),{frame:_}=this.parent,c="horizontal"==t?_.bbox.width:_.bbox.height,u=0<=e&&e<=1?e:(0,k.clamp)(e/c,0,1),{new_value:d,new_unit:g,scale_factor:p,exact:m}=(()=>{const{unit:t,dimensional:e}=this.model,a=this.range.span*u;return e.compute(a,t,"exact"==i)})(),y=A(c*u*p),f=(()=>{const{label:t}=this.model;return(0,B.process_placeholders)(t,((t,e,i)=>{switch(e){case"value":return m?null!=i?(0,B.sprintf)(i,d):d.toFixed(2):`${d}`;case"unit":if("short"===(i??"short"))return g;default:return null}}))})();this.label_layout=this.text_layout({text:f,location:this.model.label_location,align:this.model.label_align,visuals:this.visuals.label_text}),this.title_layout=this.text_layout({text:this.model.title,location:this.model.title_location,align:this.model.title_align,visuals:this.visuals.title_text});const v="horizontal"==t?{width:y,height:r}:{width:r,height:y},z=this.axis_view.layout;(0,L.assert)(null!=z),this.axis_layout=z,z.absolute=!0,"horizontal"==t?z.set_sizing({width_policy:"fixed",width:v.width,height_policy:"min",valign:"center"}):z.set_sizing({width_policy:"min",height_policy:"fixed",height:v.height,halign:"center"}),this.box_layout=(()=>{const t={above:[],below:[],left:[],right:[]};function e(e,i,a){e.visible&&t[i].push(function(t,e){const i=new x.FixedLayout;return i.absolute=!0,i.set_sizing("left"==t||"right"==t?{width_policy:"fixed",width:e}:{height_policy:"fixed",height:e}),i}(i,a),e)}e(this.label_layout,this.model.label_location,this.model.label_standoff),e(this.title_layout,this.model.title_location,this.model.title_standoff);const i=t.above.length,a=t.left.length,s=[{layout:z,row:i,col:a}];for(const[e,o]of(0,S.enumerate)(t.above))s.push({layout:e,row:i-o-1,col:a});for(const[e,o]of(0,S.enumerate)(t.below))s.push({layout:e,row:i+o+1,col:a});for(const[e,o]of(0,S.enumerate)(t.left))s.push({layout:e,row:i,col:a-o-1});for(const[e,o]of(0,S.enumerate)(t.right))s.push({layout:e,row:i,col:a+o+1});return new w.Grid(s)})();const{box_layout:T}=this;T.absolute=!0,T.position={left:a,top:a},T.set_sizing(),T.compute();const[R,F]=(()=>{const{x_range:e,y_range:i}=this.axis_view.bbox;return"horizontal"==t?[e,i]:[i,e]})();this.axis_scale.source_range.end=d,this.axis_scale.target_range.setv(R),this.cross_scale.source_range.end=1,this.cross_scale.target_range.setv(F);const P=h+a+T.bbox.width+a+h,V=h+a+T.bbox.height+a+h,q=null!=this.layout?this.layout:this.plot_view.frame,[C,M]=q.bbox.ranges,{sx:N,sy:O}=(()=>{switch(o){case"top_left":return{sx:C.start+s,sy:M.start+s};case"top":case"top_center":return{sx:(C.end+C.start)/2-P/2,sy:M.start+s};case"top_right":return{sx:C.end-s-P,sy:M.start+s};case"bottom_right":return{sx:C.end-s-P,sy:M.end-s-V};case"bottom":case"bottom_center":return{sx:(C.end+C.start)/2-P/2,sy:M.end-s-V};case"bottom_left":return{sx:C.start+s,sy:M.end-s-V};case"left":case"center_left":return{sx:C.start+s,sy:(M.end+M.start)/2-V/2};case"center":case"center_center":return{sx:(C.end+C.start)/2-P/2,sy:(M.end+M.start)/2-V/2};case"right":case"center_right":return{sx:C.end-s-P,sy:(M.end+M.start)/2-V/2}}})();this.bbox=new b.BBox({left:N,top:O,width:P,height:V})}_draw_box(t){const{width:e,height:i}=this.bbox;t.beginPath(),t.rect(0,0,e,i),this.visuals.background_fill.apply(t),this.visuals.background_hatch.apply(t),this.visuals.border_line.apply(t)}_draw_axis(t){this.axis_view.render()}_draw_text(t,e,i){const{bbox:a}=e,[s,o]=(()=>{const{orientation:t}=this.model,e="horizontal"==t;switch(i){case"left":return e?[0,0]:[0,a.height];case"right":return e?[0,0]:[a.width,0];case"above":case"below":return[0,0]}})(),{left:n,top:l}=a.translate(s,o);t.translate(n,l),e.text.paint(t),t.translate(-n,-l)}_draw_label(t){this._draw_text(t,this.label_layout,this.model.label_location)}_draw_title(t){this._draw_text(t,this.title_layout,this.model.title_location)}_render(){this.update_geometry(),this.compute_geometry();const{ctx:t}=this.layer,{left:e,top:i}=this.bbox;t.translate(e,i),this.box_layout.visible&&this._draw_box(t),this.axis_layout.visible&&this._draw_axis(t),this.label_layout.visible&&this._draw_label(t),this.title_layout.visible&&this._draw_title(t),t.translate(-e,-i)}}i.ScaleBarView=F,F.__name__="ScaleBarView";class P extends l.Annotation{constructor(t){super(t)}}i.ScaleBar=P,o=P,P.__name__="ScaleBar",o.prototype.default_view=F,o.mixins([["bar_",u.Line],["label_",u.Text],["title_",u.Text],["border_",u.Line],["background_",u.Fill],["background_",u.Hatch]]),o.define((({NonNegative:t,Float:e,Str:i,Ref:a,Or:s,Auto:o})=>({range:[s(a(h.Range),o),"auto"],unit:[i,"m"],dimensional:[a(r.Dimensional),()=>new r.MetricLength],orientation:[c.Orientation,"horizontal"],bar_length:[t(e),.2],length_sizing:[R,"adaptive"],location:[c.Anchor,"top_right"],label:[i,"@{value} @{unit}"],label_align:[c.Align,"center"],label_location:[c.Location,"below"],label_standoff:[e,5],title:[i,""],title_align:[c.Align,"center"],title_location:[c.Location,"above"],title_standoff:[e,5],margin:[e,10],padding:[e,10],ticker:[a(m.Ticker),()=>new y.FixedTicker({ticks:[]})]}))),o.override({bar_line_width:2,border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(e,t,n,s,r){var i,c,a,o,l,u,_;s();const m=e(51),d=e(12),f=e(9),p=e(13),{min:h}=Math;class g extends m.Model{constructor(e){super(e)}compute(e,t,n){const s=(()=>{const{include:e,exclude:t}=this,n=(0,f.entries)(this.get_basis()).map((([e,[t,n,s]])=>({name:e,factor:t,tex_name:n,long_name:s}))).filter((({name:n})=>(null==e||e.includes(n))&&!t.includes(n)));return(0,p.sort_by)(n,(({factor:e})=>e))})(),{ticks:r}=this,i=s.find((({name:e})=>e==t));(0,d.assert)(null!=i);const c=e*i.factor,[a,o]=(()=>{const e=(0,p.bisect_right_by)(s,c,(({factor:e})=>e));if(e>0){const{name:t,factor:n}=s[e-1];return[t,c/n]}return[t,c]})();n=n??0==r.length;const l=(()=>{if(n)return o;{const e=(0,p.bisect_right)(r,o);return r[h(e,r.length-1)]}})();return{new_value:l,new_unit:a,scale_factor:l*(c/o)/e/i.factor,exact:n}}}n.Dimensional=g,i=g,g.__name__="Dimensional",i.define((({Nullable:e,List:t,Str:n,Float:s})=>({ticks:[t(s)],include:[e(t(n)),null],exclude:[t(n),[]]})));class b extends g{constructor(e){super(e)}get_basis(){return this.basis}}n.CustomDimensional=b,c=b,b.__name__="CustomDimensional",c.define((({Dict:e,Tuple:t,Float:n,Str:s,Or:r})=>({basis:[e(r(t(n,s),t(n,s,s)))]})));class x extends g{constructor(e){super(e)}get_basis(){const{base_unit:e,full_unit:t}=this,n={};for(const[s,r,i,c]of a._metric_basis){const a=`${i}${e}`,o=null!=t?`${c}${t}`:void 0;n[`${s}${e}`]=[r,a,o]}return n}}n.Metric=x,a=x,x.__name__="Metric",a.define((({Str:e,Nullable:t})=>({base_unit:[e],full_unit:[t(e),null]}))),a.override({ticks:[1,2,5,10,15,20,25,50,75,100,125,150,200,250,500,750]}),x._metric_basis=[["Q",1e30,"Q","quetta"],["R",1e27,"R","ronna"],["Y",1e24,"Y","yotta"],["Z",1e21,"Z","zetta"],["E",1e18,"E","exa"],["P",1e15,"P","peta"],["T",1e12,"T","tera"],["G",1e9,"G","giga"],["M",1e6,"M","mega"],["k",1e3,"k","kilo"],["h",100,"h","hecto"],["",1,"",""],["d",.1,"d","deci"],["c",.01,"c","centi"],["m",.001,"m","milli"],["\xb5",1e-6,"\\mu","micro"],["n",1e-9,"n","nano"],["p",1e-12,"p","pico"],["f",1e-15,"f","femto"],["a",1e-18,"a","atto"],["z",1e-21,"z","zepto"],["y",1e-24,"y","yocto"],["r",1e-27,"r","ronto"],["q",1e-30,"q","quecto"]];class M extends x{constructor(e){super(e)}get_basis(){const e=super.get_basis(),t={};for(const[n,[s,r]]of(0,f.entries)(e))t[`${n}\u207b1`]=[s**-1,`${r}^{-1}`];return t}}n.ReciprocalMetric=M,M.__name__="ReciprocalMetric";class y extends x{constructor(e){super(e)}}n.MetricLength=y,o=y,y.__name__="MetricLength",o.override({base_unit:"m",exclude:["dm","hm"]});class k extends M{constructor(e){super(e)}}n.ReciprocalMetricLength=k,l=k,k.__name__="ReciprocalMetricLength",l.override({base_unit:"m",exclude:["dm","hm"]});class v extends b{constructor(e){super(e)}}n.ImperialLength=v,u=v,v.__name__="ImperialLength",u.override({basis:{in:[1/12,"in","inch"],ft:[1,"ft","foot"],yd:[3,"yd","yard"],ch:[66,"ch","chain"],fur:[660,"fur","furlong"],mi:[5280,"mi","mile"],lea:[15840,"lea","league"]},ticks:[1,3,6,12,60]});class $ extends b{constructor(e){super(e)}}n.Angular=$,_=$,$.__name__="Angular",_.override({basis:{"\xb0":[1,"^\\circ","degree"],"'":[1/60,"^\\prime","minute"],"''":[1/3600,"^{\\prime\\prime}","second"]},ticks:[1,3,6,12,60,120,240,360]})},
function _(e,l,o,i,t){var n;i();const s=e(1),a=e(79),_=s.__importStar(e(85));class c extends a.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_render(){const{gradient:e,y_intercept:l}=this.model;if(null==e||null==l)return;const{frame:o}=this.plot_view,i=this.coordinates.x_scale,t=this.coordinates.y_scale,[n,s,a,_]=(()=>{if(0==e){const e=t.compute(l),i=e;return[o.bbox.left,o.bbox.right,e,i]}{const n=o.bbox.top,s=o.bbox.bottom,a=t.invert(n),_=t.invert(s),c=(a-l)/e,r=(_-l)/e,h=i.compute(c),b=i.compute(r);return h<=b?[h,b,n,s]:[b,h,s,n]}})(),{ctx:c}=this.layer;if(c.save(),this.visuals.above_fill.doit||this.visuals.above_hatch.doit){const{left:e,right:l,top:i,bottom:t}=o.bbox;c.beginPath(),c.moveTo(n,a),c.lineTo(n,a),c.lineTo(s,_),c.lineTo(s,_),a<=_?(s<l&&c.lineTo(l,t),c.lineTo(l,i),c.lineTo(e,i)):(c.lineTo(l,i),c.lineTo(e,i),n>e&&c.lineTo(e,t)),c.closePath(),this.visuals.above_fill.apply(c),this.visuals.above_hatch.apply(c)}if(this.visuals.below_fill.doit||this.visuals.below_hatch.doit){const{left:e,right:l,top:i,bottom:t}=o.bbox;c.beginPath(),c.moveTo(n,a),c.lineTo(n,a),c.lineTo(s,_),a<=_?(c.lineTo(l,t),c.lineTo(e,t),n>e&&c.lineTo(e,i)):(s<l&&c.lineTo(l,i),c.lineTo(l,t),c.lineTo(e,t)),c.closePath(),this.visuals.below_fill.apply(c),this.visuals.below_hatch.apply(c)}c.beginPath(),c.moveTo(n,a),c.lineTo(s,_),this.visuals.line.apply(c),c.restore()}}o.SlopeView=c,c.__name__="SlopeView";class r extends a.Annotation{constructor(e){super(e)}}o.Slope=r,n=r,r.__name__="Slope",n.prototype.default_view=c,n.mixins([_.Line,["above_",_.Fill],["above_",_.Hatch],["below_",_.Fill],["below_",_.Hatch]]),n.define((({Float:e,Nullable:l})=>({gradient:[l(e),null],y_intercept:[l(e),null]}))),n.override({line_color:"black",above_fill_color:null,above_fill_alpha:.4,below_fill_color:null,below_fill_alpha:.4})},
function _(t,e,i,n,s){var o;n();const a=t(1),r=t(79),l=a.__importStar(t(85)),h=t(20),_=t(225),c=t(15),d=t(12);class u{constructor(t,e){this.p0=t,this.p1=e}clone(){return new u({...this.p0},{...this.p1})}hit_test(t,e=2.5){return(0,_.dist_to_segment)(t,this.p0,this.p1)<e}translate(t,e){const{p0:i,p1:n}=this,s={x:i.x+t,y:i.y+e},o={x:n.x+t,y:n.y+e};return new u(s,o)}}u.__name__="Line";class p extends r.AnnotationView{constructor(){super(...arguments),this._pan_state=null,this._is_hovered=!1}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.plot_view.request_paint(this)))}_render(){const{location:t,location_units:e}=this.model;if(null==t)return;function i(t,e,i,n,s){switch(e){case"canvas":return s.compute(t);case"screen":return n.compute(t);case"data":return i.compute(t)}}const{frame:n,canvas:s}=this.plot_view,{x_scale:o,y_scale:a}=this.coordinates;let r,l,h,_;"width"==this.model.dimension?(h=i(t,e,a,n.bbox.yview,s.bbox.y_screen),l=n.bbox.left,_=n.bbox.width,r=this.model.line_width):(h=n.bbox.top,l=i(t,e,o,n.bbox.xview,s.bbox.y_screen),_=this.model.line_width,r=n.bbox.height);const c={x:l,y:h},d={x:l+_,y:h+r};this.line=new u(c,d);const{_is_hovered:p,visuals:m}=this,v=p&&m.hover_line.doit?m.hover_line:m.line,{ctx:b}=this.layer;b.save(),b.beginPath(),this.visuals.line.set_value(b),b.moveTo(l,h),"width"==this.model.dimension?b.lineTo(l+_,h):b.lineTo(l,h+r),v.apply(b),b.restore()}interactive_hit(t,e){return!(!this.model.visible||!this.model.editable)&&null!=this._hit_test(t,e)}_hit_test(t,e){const i=Math.max(2.5,this.model.line_width/2);return this.line.hit_test({x:t,y:e},i)?"edge":null}_can_hit(t){return!0}on_pan_start(t){if(this.model.visible&&this.model.editable){const{sx:e,sy:i}=t,n=this._hit_test(e,i);if(null!=n&&this._can_hit(n))return this._pan_state={line:this.line.clone(),target:n},this.model.pan.emit(["pan:start",t.modifiers]),!0}return!1}on_pan(t){function e(t,e,i,n,s){switch(e){case"canvas":return s.invert(t);case"screen":return n.invert(t);case"data":return i.invert(t)}}(0,d.assert)(null!=this._pan_state);const i=(()=>{const{dx:e,dy:i}=t,{line:n}=this._pan_state;return"width"==this.model.dimension?n.translate(0,i).p0.y:n.translate(e,0).p0.x})(),n=(()=>{const{location_units:t}=this.model,{frame:n,canvas:s}=this.plot_view,{x_scale:o,y_scale:a}=this.coordinates;return"width"==this.model.dimension?e(i,t,a,n.bbox.yview,s.bbox.y_screen):e(i,t,o,n.bbox.xview,s.bbox.y_screen)})();this.model.location=n,this.model.pan.emit(["pan",t.modifiers])}on_pan_end(t){this._pan_state=null,this.model.pan.emit(["pan:end",t.modifiers])}get _has_hover(){const{hover_line:t}=this.visuals;return t.doit}on_enter(t){const{_has_hover:e}=this;return e&&(this._is_hovered=!0,this.request_paint()),e}on_move(t){}on_leave(t){this._has_hover&&(this._is_hovered=!1,this.request_paint())}cursor(t,e){const i=this._pan_state?.target??this._hit_test(t,e);return null!=i&&this._can_hit(i)?"width"==this.model.dimension?"ns-resize":"ew-resize":null}}i.SpanView=p,p.__name__="SpanView";class m extends r.Annotation{constructor(t){super(t),this.pan=new c.Signal(this,"pan")}}i.Span=m,o=m,m.__name__="Span",o.prototype.default_view=p,o.mixins([l.Line,["hover_",l.Line]]),o.define((({Bool:t,Float:e,Nullable:i})=>({location:[i(e),null],location_units:[h.CoordinateUnits,"data"],dimension:[h.Dimension,"width"],editable:[t,!1]}))),o.override({line_color:"black",hover_line_color:null,hover_line_alpha:.3})},
function _(e,i,t,o,s){var l;o();const a=e(79),n=e(288),r=e(56),h=e(63),_=e(170),v=e(64);class b extends a.AnnotationView{constructor(){super(...arguments),this.el=(0,h.div)(),this._previous_bbox=new v.BBox}update_layout(){this.layout=new _.SideLayout(this.panel,(()=>this.get_size()),!0)}has_finished(){return super.has_finished()&&this.toolbar_view.has_finished()}*children(){yield*super.children(),yield this.toolbar_view}async lazy_initialize(){await super.lazy_initialize(),this.toolbar_view=await(0,r.build_view)(this.model.toolbar,{parent:this.canvas})}connect_signals(){super.connect_signals(),this.plot_view.mouseenter.connect((()=>{this.toolbar_view.set_visibility(!0)})),this.plot_view.mouseleave.connect((()=>{this.toolbar_view.set_visibility(!1)}))}remove(){this.toolbar_view.remove(),(0,h.remove)(this.el),super.remove()}_render(){(0,h.display)(this.el);const{bbox:e}=this.layout;if(!this._previous_bbox.equals(e)){(0,h.position)(this.el,e),this._previous_bbox=e,(0,h.empty)(this.el),this.el.style.position="absolute";const{style:i}=this.toolbar_view.el;this.toolbar_view.model.horizontal?(i.width="100%",i.height="unset"):(i.width="unset",i.height="100%"),this.toolbar_view.render(),this.plot_view.canvas_view.add_event(this.el),this.el.appendChild(this.toolbar_view.el),this.toolbar_view.after_render()}this.model.visible||(0,h.undisplay)(this.el)}_get_size(){const{tools:e,logo:i}=this.model.toolbar;return{width:30*e.length+(null!=i?25:0)+15,height:30}}}t.ToolbarPanelView=b,b.__name__="ToolbarPanelView";class d extends a.Annotation{constructor(e){super(e)}}t.ToolbarPanel=d,l=d,d.__name__="ToolbarPanel",l.prototype.default_view=b,l.define((({Ref:e})=>({toolbar:[e(n.Toolbar)]})))},
function _(t,e,o,s,i){var l;s();const n=t(1),a=t(19),r=t(63),c=t(56),h=t(107),_=t(20),u=t(10),v=t(34),p=t(9),d=t(8),f=t(289),g=t(290),m=t(291),b=t(296),w=t(298),y=t(299),T=t(301),x=t(293),z=n.__importStar(t(302)),L=z,C=n.__importStar(t(303)),I=C,P=n.__importDefault(t(121));class S extends h.UIElementView{constructor(){super(...arguments),this._tool_button_views=new Map,this._items=[],this._visible=null}get tool_buttons(){return this._tool_buttons.flat()}get overflow_el(){return this._overflow_el}get visible(){return!!this.model.visible&&(!this.model.autohide||(this._visible??!1))}*children(){yield*super.children(),yield*this._tool_button_views.values()}has_finished(){if(!super.has_finished())return!1;for(const t of this._tool_button_views.values())if(!t.has_finished())return!1;return!0}initialize(){super.initialize();const{location:t}=this.model,e="left"==t||"above"==t,o=this.model.horizontal?"vertical":"horizontal";this._overflow_menu=new x.ContextMenu([],{target:this.el,orientation:o,reversed:e,prevent_hide:t=>t.composedPath().includes(this._overflow_el)})}async lazy_initialize(){await super.lazy_initialize(),await this._build_tool_button_views()}connect_signals(){super.connect_signals();const{buttons:t,tools:e,location:o,autohide:s}=this.model.properties;this.on_change([t,e],(async()=>{await this._build_tool_button_views(),this.render()})),this.on_change(o,(()=>{this.render()})),this.on_change(s,(()=>{this._on_visible_change()}))}stylesheets(){return[...super.stylesheets(),z.default,C.default,P.default]}remove(){(0,c.remove_views)(this._tool_button_views),super.remove()}async _build_tool_button_views(){this._tool_buttons=(()=>{const{buttons:t}=this.model;if("auto"==t){return[...(0,p.values)(this.model.gestures).map((t=>t.tools)),this.model.actions,this.model.inspectors,this.model.auxiliaries].map((t=>t.filter((t=>t.visible)).map((t=>t.tool_button()))))}return(0,u.split)(t,null)})(),await(0,c.build_views)(this._tool_button_views,this._tool_buttons.flat(),{parent:this})}set_visibility(t){t!=this._visible&&(this._visible=t,this._on_visible_change())}_on_visible_change(){this.el.classList.toggle(L.hidden,!this.visible)}_after_resize(){super._after_resize(),this._after_render()}render(){super.render(),this.el.classList.add(L[this.model.location]),this.el.classList.toggle(L.inner,this.model.inner),this._on_visible_change();const{horizontal:t}=this.model;this._overflow_el=(0,r.div)({class:L.tool_overflow,tabIndex:0},t?"\u22ee":"\u22ef");const e=()=>{const t=(()=>{switch(this.model.location){case"right":return{left_of:this._overflow_el};case"left":return{right_of:this._overflow_el};case"above":return{below:this._overflow_el};case"below":return{above:this._overflow_el}}})();this._overflow_menu.toggle(t)};if(this._overflow_el.addEventListener("click",(()=>{e()})),this._overflow_el.addEventListener("keydown",(t=>{"Enter"==t.key&&e()})),this._items=[],null!=this.model.logo){const t="grey"===this.model.logo?I.grey:null,e=(0,r.a)({href:"https://bokeh.org/",target:"_blank",class:[I.logo,I.logo_small,t]});this._items.push(e),this.shadow_el.appendChild(e)}for(const[,t]of this._tool_button_views)t.render(),t.after_render();const o=this._tool_buttons.map((t=>t.map((t=>this._tool_button_views.get(t).el)))).filter((t=>0!=t.length)),s=()=>(0,r.div)({class:L.divider});for(const t of(0,v.join)(o,s))this._items.push(t),this.shadow_el.appendChild(t)}_after_render(){super._after_render(),(0,u.clear)(this._overflow_menu.items),this.shadow_el.contains(this._overflow_el)&&this.shadow_el.removeChild(this._overflow_el);for(const t of this._items)this.shadow_el.contains(t)||this.shadow_el.append(t);const{horizontal:t}=this.model,{bbox:e}=this,o=t?L.right:L.above;let s=0,i=!1;for(const l of this._items)if(i)this.shadow_el.removeChild(l),this._overflow_menu.items.push({custom:l,class:o});else{const{width:n,height:a}=l.getBoundingClientRect();s+=t?n:a,i=t?s>e.width-15:s>e.height-15,i&&(this.shadow_el.removeChild(l),this.shadow_el.appendChild(this._overflow_el),this._overflow_menu.items.push({custom:l,class:o}))}}}o.ToolbarView=S,S.__name__="ToolbarView";const k=t(21),A=(0,k.Or)((0,k.Ref)(b.GestureTool),(0,k.Ref)(g.ToolProxy)),E=(0,k.Struct)({tools:(0,k.List)(A),active:(0,k.Nullable)(A)}),R=(0,k.Struct)({pan:E,scroll:E,pinch:E,rotate:E,move:E,tap:E,doubletap:E,press:E,pressup:E,multi:E});function B(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},multi:{tools:[],active:null}}}o.Drag=f.Tool,o.Inspection=f.Tool,o.Scroll=f.Tool,o.Tap=f.Tool;class $ extends h.UIElement{constructor(t){super(t)}get horizontal(){return"above"==this.location||"below"==this.location}get vertical(){return"left"==this.location||"right"==this.location}connect_signals(){super.connect_signals();const{tools:t,active_drag:e,active_inspect:o,active_scroll:s,active_tap:i,active_multi:l}=this.properties;this.on_change([t,e,o,s,i,l],(()=>{this._init_tools(),this._activate_tools()}))}initialize(){super.initialize(),this._init_tools(),this._activate_tools()}_init_tools(){const t=new Set;function e(e,o){const s=(e instanceof g.ToolProxy?e.underlying:e)instanceof o;return s&&t.add(e),s}const o=this.tools.filter((t=>e(t,w.InspectTool)));this.inspectors=o;const s=this.tools.filter((t=>e(t,T.HelpTool)));this.help=s;const i=this.tools.filter((t=>e(t,y.ActionTool)));this.actions=i;const l={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},multi:{tools:[],active:null}};for(const t of this.tools)e(t,b.GestureTool)&&l[t.event_role].tools.push(t);for(const t of(0,p.typed_keys)(l)){const e=this.gestures[t];e.tools=(0,u.sort_by)(l[t].tools,(t=>t.default_order)),null!=e.active&&(0,u.every)(e.tools,(t=>t.id!=e.active?.id))&&(e.active=null)}const n=this.tools.filter((e=>!t.has(e)));this.auxiliaries=n}_activate_tools(){if("auto"==this.active_inspect);else if(null==this.active_inspect)for(const t of this.inspectors)t.active=!1;else if((0,d.isArray)(this.active_inspect)){const t=(0,u.intersection)(this.active_inspect,this.inspectors);t.length!=this.active_inspect.length&&(this.active_inspect=t);for(const t of this.inspectors)(0,u.includes)(this.active_inspect,t)||(t.active=!1)}else{let t=!1;for(const e of this.inspectors)e!=this.active_inspect?e.active=!1:t=!0;t||(this.active_inspect=null)}const t=t=>{t.active?this._active_change(t):t.active=!0};for(const t of(0,p.values)(this.gestures))for(const e of t.tools)this.connect(e.properties.active.change,(()=>this._active_change(e)));function e(t){switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi";default:return null}}function o(t){return"tap"==t||"pan"==t}for(const[s,i]of(0,p.entries)(this.gestures)){const l=s,n=e(l);if(null!=n){const e=this[n];if("auto"==e)0!=i.tools.length&&o(l)&&t(i.tools[0]);else if(null!=e)(0,u.includes)(this.tools,e)?t(e):this[n]=null;else{this.gestures[l].active=null;for(const t of this.gestures[l].tools)t.active=!1}}}}_active_change(t){const{event_types:e}=t;for(const o of e)if(t.active){const e=this.gestures[o].active;null!=e&&t!=e&&(a.logger.debug(`Toolbar: deactivating tool: ${e} for event type '${o}'`),e.active=!1),this.gestures[o].active=t,a.logger.debug(`Toolbar: activating tool: ${t} for event type '${o}'`)}else this.gestures[o].active=null}}o.Toolbar=$,l=$,$.__name__="Toolbar",l.prototype.default_view=S,l.define((({Bool:t,List:e,Or:s,Ref:i,Nullable:l,Auto:n})=>({tools:[e(s(i(f.Tool),i(g.ToolProxy))),[]],logo:[l(_.Logo),"normal"],autohide:[t,!1],active_drag:[l(s(i(o.Drag),n)),"auto"],active_inspect:[l(s(i(o.Inspection),e(i(o.Inspection)),n)),"auto"],active_scroll:[l(s(i(o.Scroll),n)),"auto"],active_tap:[l(s(i(o.Tap),n)),"auto"],active_multi:[l(s(i(b.GestureTool),n)),"auto"]}))),l.internal((({List:t,Bool:e,Ref:o,Or:s,Null:i,Auto:l})=>({buttons:[s(t(s(o(m.ToolButton),i)),l),"auto"],location:[_.Location,"right"],inner:[e,!1],gestures:[R,B],actions:[t(s(o(y.ActionTool),o(g.ToolProxy))),[]],inspectors:[t(s(o(w.InspectTool),o(g.ToolProxy))),[]],auxiliaries:[t(s(o(f.Tool),o(g.ToolProxy))),[]],help:[t(s(o(T.HelpTool),o(g.ToolProxy))),[]]})))},
function _(t,e,n,o,i){var s;o();const r=t(58),a=t(20),l=t(10),c=t(8),_=t(51);class d extends r.View{connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>{this.model.active?this.activate():this.deactivate()}))}get overlays(){return[]}activate(){}deactivate(){}}n.ToolView=d,d.__name__="ToolView";class h extends _.Model{constructor(t){super(t)}get event_role(){const{event_type:t}=this;return(0,c.isString)(t)?t:"multi"}get event_types(){const{event_type:t}=this;return null==t?[]:(0,c.isString)(t)?[t]:t}get tooltip(){return this.description??this.tool_name}get computed_icon(){const{icon:t,tool_icon:e}=this;return t??(null!=e?`.${e}`:void 0)}get menu(){return null}_get_dim_limits([t,e],[n,o],i,s){const r=i.bbox.h_range;let a;"width"==s||"both"==s?(a=[(0,l.min)([t,n]),(0,l.max)([t,n])],a=[(0,l.max)([a[0],r.start]),(0,l.min)([a[1],r.end])]):a=[r.start,r.end];const c=i.bbox.v_range;let _;return"height"==s||"both"==s?(_=[(0,l.min)([e,o]),(0,l.max)([e,o])],_=[(0,l.max)([_[0],c.start]),(0,l.min)([_[1],c.end])]):_=[c.start,c.end],[a,_]}_get_dim_tooltip(t){const{description:e,tool_name:n}=this;return null!=e?e:"both"==t?n:"auto"==t?`${n} (either x, y or both dimensions)`:`${n} (${"width"==t?"x":"y"}-axis)`}static register_alias(t,e){this.prototype._known_aliases.set(t,e)}static from_string(t){const e=this.prototype._known_aliases.get(t);if(null!=e)return e();{const e=[...this.prototype._known_aliases.keys()];throw new Error(`unexpected tool name '${t}', possible tools are ${e.join(", ")}`)}}}n.Tool=h,s=h,h.__name__="Tool",s.prototype._known_aliases=new Map,s.define((({Bool:t,Str:e,Regex:n,Nullable:o,Or:i})=>({icon:[o(i(a.ToolIcon,n(/^--/),n(/^\./),n(/^data:image/))),null],description:[o(e),null],visible:[t,!0]}))),s.internal((({Bool:t})=>({active:[t,!1],disabled:[t,!1]})))},
function _(t,o,e,s,n){var i;s();const l=t(15),r=t(51),c=t(289),u=t(34);class h extends r.Model{constructor(t){super(t)}get underlying(){return this.tools[0]}tool_button(){const t=this.tools[0].tool_button();return t.tool=this,t}get event_type(){return this.tools[0].event_type}get event_role(){return this.tools[0].event_role}get event_types(){return this.tools[0].event_types}get default_order(){return this.tools[0].default_order}get tooltip(){return this.tools[0].tooltip}get tool_name(){return this.tools[0].tool_name}get computed_icon(){return this.tools[0].computed_icon}get toggleable(){const t=this.tools[0];return"toggleable"in t&&t.toggleable}get visible(){return this.tools[0].visible}initialize(){super.initialize(),this.do=new l.Signal0(this,"do")}connect_signals(){super.connect_signals(),this.connect(this.do,(()=>this.doit())),this.connect(this.properties.active.change,(()=>this.set_active()));for(const t of this.tools)this.connect(t.properties.active.change,(()=>{this.active=t.active}))}doit(){for(const t of this.tools)t.do.emit()}set_active(){for(const t of this.tools)t.active=this.active}get menu(){const{menu:t}=this.tools[0];if(null==t)return null;const o=[];for(const[e,s]of(0,u.enumerate)(t))if(null==e)o.push(null);else{const t=()=>{for(const t of this.tools)t.menu?.[s]?.handler?.()};o.push({...e,handler:t})}return o}}e.ToolProxy=h,i=h,h.__name__="ToolProxy",i.define((({Bool:t,List:o,Ref:e})=>({tools:[o(e(c.Tool)),[]],active:[t,t=>(0,u.some)(t.tools,(t=>t.active))],disabled:[t,!1]})))},
function _(e,t,s,o,i){var l;o();const n=e(1),a=e(107),r=e(289),c=e(290),h=e(292),d=e(63),u=e(20),_=e(293),m=e(10),p=n.__importStar(e(295)),g=p,v=n.__importDefault(e(121));class f extends a.UIElementView{initialize(){super.initialize();const{location:e}=this.parent.model,t="left"==e||"above"==e,s=this.parent.model.horizontal?"vertical":"horizontal",o=this.model.tool.menu??[];this._menu=new _.ContextMenu(t?(0,m.reversed)(o):o,{target:this.parent.el,orientation:s,prevent_hide:e=>e.composedPath().includes(this.el)}),this._ui_gestures=new h.UIGestures(this.el,{on_tap:e=>{this._menu.is_open?this._menu.hide():e.native.composedPath().includes(this.el)&&this._clicked()},on_press:()=>{this._pressed()}}),this.el.addEventListener("keydown",(e=>{switch(e.key){case"Enter":this._clicked();break;case" ":this._pressed()}}))}connect_signals(){super.connect_signals(),this._ui_gestures.connect_signals(),this.connect(this.model.change,(()=>this.render())),this.connect(this.model.tool.change,(()=>this.render()))}remove(){this._ui_gestures.remove(),this._menu.remove(),super.remove()}stylesheets(){return[...super.stylesheets(),p.default,v.default]}render(){super.render(),this.class_list.add(g[this.parent.model.location]),this.model.tool.disabled&&this.class_list.add(g.disabled);const e=(0,d.div)({class:g.tool_icon});this.shadow_el.appendChild(e);const t=this.model.icon??this.model.tool.computed_icon;if(null!=t)if(t.startsWith("data:image")){const s=`url("${encodeURI(t)}")`;e.style.backgroundImage=s}else if(t.startsWith("--"))e.style.backgroundImage=`var(${t})`;else if(t.startsWith(".")){const s=t.substring(1);e.classList.add(s)}else if(u.ToolIcon.valid(t)){const s=`bk-tool-icon-${t.replace(/_/g,"-")}`;e.classList.add(s)}if(null!=this.model.tool.menu){const e=(0,d.div)({class:g.tool_chevron});this.shadow_el.appendChild(e)}const s=this.model.tooltip??this.model.tool.tooltip;this.el.title=s,this.el.tabIndex=0}_pressed(){const e=(()=>{switch(this.parent.model.location){case"right":return{left_of:this.el};case"left":return{right_of:this.el};case"above":return{below:this.el};case"below":return{above:this.el}}})();this._menu.toggle(e)}}s.ToolButtonView=f,f.__name__="ToolButtonView";class b extends a.UIElement{constructor(e){super(e)}}s.ToolButton=b,l=b,b.__name__="ToolButton",l.define((({Str:e,Regex:t,Ref:s,Nullable:o,Or:i})=>({tool:[i(s(r.Tool),s(c.ToolProxy))],icon:[o(i(u.ToolIcon,t(/^--/),t(/^\./),t(/^data:image/))),null],tooltip:[o(e),null]})))},
function _(t,s,e,i,n){i();const a=t(63),_=t(12);class r{constructor(t,s,e={}){this.phase="idle",this.pointers=new Map,this.press_timer=null,this.tap_timestamp=-1/0,this.last_scale=null,this.last_rotation=null,this.hit_area=t,this.handlers=s,this.must_be_target=e.must_be_target??!1,this._pointer_over=this._pointer_over.bind(this),this._pointer_out=this._pointer_out.bind(this),this._pointer_down=this._pointer_down.bind(this),this._pointer_move=this._pointer_move.bind(this),this._pointer_up=this._pointer_up.bind(this),this._pointer_cancel=this._pointer_cancel.bind(this)}connect_signals(){this.hit_area.addEventListener("pointerover",this._pointer_over),this.hit_area.addEventListener("pointerout",this._pointer_out),this.hit_area.addEventListener("pointerdown",this._pointer_down),this.hit_area.addEventListener("pointermove",this._pointer_move),this.hit_area.addEventListener("pointerup",this._pointer_up),this.hit_area.addEventListener("pointercancel",this._pointer_cancel)}disconnect_signals(){this.hit_area.removeEventListener("pointerover",this._pointer_over),this.hit_area.removeEventListener("pointerout",this._pointer_out),this.hit_area.removeEventListener("pointerdown",this._pointer_down),this.hit_area.removeEventListener("pointermove",this._pointer_move),this.hit_area.removeEventListener("pointerup",this._pointer_up),this.hit_area.removeEventListener("pointercancel",this._pointer_cancel)}remove(){this.disconnect_signals()}_self_is_target(t){return t.composedPath()[0]==this.hit_area}_is_event_target(t){return!this.must_be_target||this._self_is_target(t)}get _is_multi_gesture(){return this.pointers.size>=2}_within_threshold(t){const{dx:s,dy:e}=this._movement(t);return s**2+e**2<=r.move_threshold**2}get _any_movement(){return[...this.pointers.values()].some((t=>!this._within_threshold(t)))}_start_timeout(){(0,_.assert)(null==this.press_timer),this.press_timer=setTimeout((()=>this._pointer_timeout()),r.press_threshold)}_cancel_timeout(){const{press_timer:t}=this;null!=t&&(clearTimeout(t),this.press_timer=null)}_pointer_timeout(){(0,_.assert)("started"==this.phase),(0,_.assert)(!this._is_multi_gesture),this.phase="pressing",this.press_timer=null;const[t]=this.pointers.values();this.on_press(t.init)}_pointer_over(t){this._is_event_target(t)&&t.isPrimary&&this.on_enter(t)}_pointer_out(t){this._is_event_target(t)&&t.isPrimary&&this.on_leave(t)}_pointer_down(t){if(this._is_event_target(t)&&!this._is_multi_gesture&&!(this.pointers.has(t.pointerId)||t.isPrimary&&"mouse"==t.pointerType&&t.buttons!=a.MouseButton.Left))switch(this.pointers.set(t.pointerId,{init:t,last:t}),this.hit_area.setPointerCapture(t.pointerId),this.phase){case"idle":this.phase="started",this._start_timeout();break;case"started":this._cancel_timeout()}}_pointer_move(t){if(!this._is_event_target(t))return;t.isPrimary&&this.on_move(t);const s=this.pointers.get(t.pointerId);if(null!=s)switch(s.last=t,this.phase){case"idle":(0,_.unreachable)();case"started":case"transitional":if(!this._any_movement)return;if(this._cancel_timeout(),this._is_multi_gesture){const[t,s]=this.pointers.values(),e=this._scale(t,s),i=this._rotation(t,s);Math.abs(e-1)>r.pinch_threshold?(this.phase="pinching",this.on_pinch_start(t.init,s.init,1),this.on_pinch(t.last,s.last,e),this.last_scale=e):Math.abs(i)>r.rotate_threshold&&(this.phase="rotating",this.on_rotate_start(t.init,s.init,0),this.on_rotate(s.last,s.last,i),this.last_rotation=i)}else{this.phase="panning";const[t]=this.pointers.values(),{dx:s,dy:e}=this._movement(t);this.on_pan_start(t.init,0,0),this.on_pan(t.last,s,e)}break;case"pressing":break;case"panning":{const[s]=this.pointers.values(),{dx:e,dy:i}=this._movement(s);this.on_pan(t,e,i);break}case"pinching":{const[t,s]=this.pointers.values(),e=this._scale(t,s);e!=this.last_scale&&(this.on_pinch(t.last,s.last,e),this.last_scale=e);break}case"rotating":{const[t,s]=this.pointers.values(),e=this._rotation(t,s);e!=this.last_rotation&&(this.on_rotate(t.last,s.last,e),this.last_rotation=e);break}}}_pointer_up(t){if(!this._is_event_target(t))return;const s=this.pointers.get(t.pointerId);if(null!=s){switch(s.last=t,this._cancel_timeout(),this.phase){case"idle":(0,_.unreachable)();case"started":{const[t]=this.pointers.values(),{tap_timestamp:s}=this;t.last.timeStamp-s<r.doubletap_threshold?(this.tap_timestamp=-1/0,this.on_doubletap(t.last)):(this.tap_timestamp=t.last.timeStamp,this.on_tap(t.last)),this.phase="idle";break}case"transitional":this.phase="idle";break;case"pressing":{const[t]=this.pointers.values();this.on_pressup(t.last),this.phase="idle";break}case"panning":{const[s]=this.pointers.values(),{dx:e,dy:i}=this._movement(s);this.on_pan_end(t,e,i),this.phase="idle";break}case"pinching":{const[t,s]=this.pointers.values(),e=this._scale(t,s);this.on_pinch_end(t.last,s.last,e),this.phase="transitional",this.last_scale=null;break}case"rotating":{const[t,s]=this.pointers.values(),e=this._rotation(t,s);this.on_rotate_end(t.last,s.last,e),this.phase="transitional",this.last_rotation=null;break}}if(this.pointers.delete(t.pointerId),"transitional"==this.phase){const[t]=this.pointers.values();t.init=t.last}}}_pointer_cancel(t){if(this.pointers.has(t.pointerId)){switch(this._cancel_timeout(),this.phase){case"idle":(0,_.unreachable)();case"started":case"pressing":case"transitional":this.phase="idle";break;case"panning":{const[s]=this.pointers.values(),{dx:e,dy:i}=this._movement(s);this.on_pan_end(t,e,i),this.phase="idle";break}case"pinching":{const[t,s]=this.pointers.values(),e=this._scale(t,s);this.on_pinch_end(t.last,s.last,e),this.phase="transitional",this.last_scale=null;break}case"rotating":{const[t,s]=this.pointers.values(),e=this._rotation(t,s);this.on_rotate_end(t.last,s.last,e),this.phase="transitional",this.last_rotation=null;break}}if(this.pointers.delete(t.pointerId),"transitional"==this.phase){const[t]=this.pointers.values();t.init=t.last}}}on_tap(t){const{on_tap:s}=this.handlers;null!=s&&s(this._tap_event("tap",t))}on_doubletap(t){const{on_doubletap:s}=this.handlers;null!=s&&s(this._tap_event("double_tap",t))}on_press(t){const{on_press:s}=this.handlers;null!=s&&s(this._tap_event("press",t))}on_pressup(t){const{on_pressup:s}=this.handlers;null!=s&&s(this._tap_event("press_up",t))}on_enter(t){const{on_enter:s}=this.handlers;null!=s&&s(this._move_event("enter",t))}on_move(t){const{on_move:s}=this.handlers;null!=s&&s(this._move_event("move",t))}on_leave(t){const{on_leave:s}=this.handlers;null!=s&&s(this._move_event("leave",t))}on_pan_start(t,s,e){const{on_pan_start:i}=this.handlers;null!=i&&i(this._pan_event("pan_start",t,s,e))}on_pan(t,s,e){const{on_pan:i}=this.handlers;null!=i&&i(this._pan_event("pan",t,s,e))}on_pan_end(t,s,e){const{on_pan_end:i}=this.handlers;null!=i&&i(this._pan_event("pan_end",t,s,e))}on_pinch_start(t,s,e){const{on_pinch_start:i}=this.handlers;null!=i&&i(this._pinch_event("pinch_start",t,s,e))}on_pinch(t,s,e){const{on_pinch:i}=this.handlers;null!=i&&i(this._pinch_event("pinch",t,s,e))}on_pinch_end(t,s,e){const{on_pinch_end:i}=this.handlers;null!=i&&i(this._pinch_event("pinch_end",t,s,e))}on_rotate_start(t,s,e){const{on_rotate_start:i}=this.handlers;null!=i&&i(this._rotate_event("rotate_start",t,s,e))}on_rotate(t,s,e){const{on_rotate:i}=this.handlers;null!=i&&i(this._rotate_event("rotate",t,s,e))}on_rotate_end(t,s,e){const{on_rotate_end:i}=this.handlers;null!=i&&i(this._rotate_event("rotate_end",t,s,e))}_get_sxy(t){const{pageX:s,pageY:e}=t,{left:i,top:n}=(0,a.offset_bbox)(this.hit_area);return{sx:s-i,sy:e-n}}_get_modifiers(t){return{shift:t.shiftKey,ctrl:t.ctrlKey,alt:t.altKey}}_tap_event(t,s){return{type:t,...this._get_sxy(s),modifiers:this._get_modifiers(s),native:s}}_move_event(t,s){return{type:t,...this._get_sxy(s),modifiers:this._get_modifiers(s),native:s}}_pan_event(t,s,e,i){return{type:t,...this._get_sxy(s),dx:e,dy:i,modifiers:this._get_modifiers(s),native:s}}_pinch_event(t,s,e,i){const{sx:n,sy:a}=this._get_sxy(s),{sx:_,sy:r}=this._get_sxy(e);return{type:t,sx:(n+_)/2,sy:(a+r)/2,scale:i,modifiers:this._get_modifiers(s),native:s}}_rotate_event(t,s,e,i){const{sx:n,sy:a}=this._get_sxy(s),{sx:_,sy:r}=this._get_sxy(e);return{type:t,sx:(n+_)/2,sy:(a+r)/2,rotation:i,modifiers:this._get_modifiers(s),native:s}}_movement(t){return{dx:t.last.x-t.init.x,dy:t.last.y-t.init.y}}_distance(t,s){const e=s.x-t.x,i=s.y-t.y;return Math.sqrt(e**2+i**2)}_angle(t,s){const e=s.x-t.x,i=s.y-t.y;return 180*Math.atan2(i,e)/Math.PI}_scale(t,s){return this._distance(t.last,s.last)/this._distance(t.init,s.init)}_rotation(t,s){return this._angle(s.last,t.last)+this._angle(s.init,t.init)}}e.UIGestures=r,r.__name__="UIGestures",r.move_threshold=5,r.press_threshold=300,r.doubletap_threshold=300,r.pinch_threshold=0,r.rotate_threshold=0},
function _(t,e,i,n,s){n();const o=t(1),l=t(63),h=t(10),r=t(8),d=t(34),a=o.__importStar(t(294)),_=a,u=o.__importDefault(t(121)),c=o.__importDefault(t(66));class m{get is_open(){return this._open}get can_open(){return 0!=this.items.length}constructor(t,e){this.el=(0,l.div)(),this._open=!1,this._item_click=(t,e)=>{this.entry_handler?.(t,e),t.handler?.(),this.hide()},this._on_mousedown=t=>{t.composedPath().includes(this.el)||this.prevent_hide?.(t)||this.hide()},this._on_keydown=t=>{"Escape"==t.key&&this.hide()},this._on_blur=()=>{this.hide()},this.items=t,this.target=e.target,this.orientation=e.orientation??"vertical",this.reversed=e.reversed??!1,this.prevent_hide=e.prevent_hide,this.extra_styles=e.extra_styles??[],this.entry_handler=e.entry_handler,this.shadow_el=this.el.attachShadow({mode:"open"}),this.class_list=new l.ClassList(this.el.classList)}remove(){this._unlisten(),(0,l.remove)(this.el)}_listen(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)}_unlisten(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)}_position(t){const e=(()=>{if("left_of"in t){const{left:e,top:i}=t.left_of.getBoundingClientRect();return{right:e,top:i}}if("right_of"in t){const{top:e,right:i}=t.right_of.getBoundingClientRect();return{left:i,top:e}}if("below"in t){const{left:e,bottom:i}=t.below.getBoundingClientRect();return{left:e,top:i}}if("above"in t){const{left:e,top:i}=t.above.getBoundingClientRect();return{left:e,bottom:i}}return t})(),i=this.el.offsetParent??document.body,n=(()=>{const t=i.getBoundingClientRect(),e=getComputedStyle(i);return{left:t.left-parseFloat(e.marginLeft),right:t.right+parseFloat(e.marginRight),top:t.top-parseFloat(e.marginTop),bottom:t.bottom+parseFloat(e.marginBottom)}})(),{style:s}=this.el;s.left=null!=e.left?e.left-n.left+"px":"auto",s.top=null!=e.top?e.top-n.top+"px":"auto",s.right=null!=e.right?n.right-e.right+"px":"auto",s.bottom=null!=e.bottom?n.bottom-e.bottom+"px":"auto"}stylesheets(){return[c.default,a.default,u.default,...this.extra_styles]}empty(){(0,l.empty)(this.shadow_el),this.class_list.clear()}render(){this.empty();for(const t of this.stylesheets()){((0,r.isString)(t)?new l.InlineStyleSheet(t):t).install(this.shadow_el)}this.class_list.add(_[this.orientation]);const t=this.reversed?(0,h.reversed)(this.items):this.items;for(const[e,i]of(0,d.enumerate)(t)){let t;if(null==e)t=(0,l.div)({class:_.divider});else{if(null!=e.if&&!e.if())continue;if(null!=e.custom)t=e.custom;else{const n=null!=e.icon?(0,l.div)({class:[_.menu_icon,e.icon]}):null,s=[e.active?.()?_.active:null,e.class];t=(0,l.div)({class:s,title:e.tooltip,tabIndex:0},n,e.label,e.content),t.addEventListener("click",(()=>{this._item_click(e,i)})),t.addEventListener("keydown",(t=>{"Enter"==t.key&&this._item_click(e,i)}))}}this.shadow_el.appendChild(t)}}show(t){if(0!=this.items.length&&!this._open){if(this.render(),0==this.shadow_el.children.length)return;(this.target.shadowRoot??this.target).appendChild(this.el),this._position(t??{left:0,top:0}),this._listen(),this._open=!0}}hide(){this._open&&(this._open=!1,this._unlisten(),(0,l.remove)(this.el))}toggle(t){this._open?this.hide():this.show(t)}}i.ContextMenu=m,m.__name__="ContextMenu"},
function _(r,o,e,i,t){i(),e.menu_icon="bk-menu-icon",e.horizontal="bk-horizontal",e.vertical="bk-vertical",e.divider="bk-divider",e.active="bk-active",e.default=".bk-menu-icon{width:28px;height:28px;mask-size:60% 60%;mask-position:center center;mask-repeat:no-repeat;-webkit-mask-size:60% 60%;-webkit-mask-position:center center;-webkit-mask-repeat:no-repeat;background-size:60%;background-color:transparent;background-repeat:no-repeat;background-position:center center;}:host{position:absolute;display:inline-flex;flex-wrap:nowrap;user-select:none;-webkit-user-select:none;width:auto;height:auto;z-index:var(--bokeh-top-level);cursor:pointer;font-size:var(--font-size);background-color:#fff;border:1px solid #ccc;border-radius:var(--border-radius);box-shadow:2px 4px 8px rgba(0, 0, 0, 0.175);}:host(.bk-horizontal){flex-direction:row;}:host(.bk-vertical){flex-direction:column;}.bk-divider{cursor:default;overflow:hidden;background-color:#e5e5e5;}:host(.bk-horizontal) > .bk-divider{width:1px;margin:5px 0;}:host(.bk-vertical) > .bk-divider{height:1px;margin:0 5px;}:host > :not(.bk-divider){border:1px solid transparent;--active-tool-highlight:#26aae1;}:host > :not(.bk-divider).bk-active{border-color:var(--active-tool-highlight);}:host > :not(.bk-divider):hover{background-color:#f9f9f9;}:host > :not(.bk-divider):focus,:host > :not(.bk-divider):focus-visible{outline:1px dotted var(--active-tool-highlight);outline-offset:-1px;}:host > :not(.bk-divider)::-moz-focus-inner{border:0;}:host(.bk-horizontal) > :not(.bk-divider):first-child{border-top-left-radius:var(--border-radius);border-bottom-left-radius:var(--border-radius);}:host(.bk-horizontal) > :not(.bk-divider):last-child{border-top-right-radius:var(--border-radius);border-bottom-right-radius:var(--border-radius);}:host(.bk-vertical) > :not(.bk-divider):first-child{border-top-left-radius:var(--border-radius);border-top-right-radius:var(--border-radius);}:host(.bk-vertical) > :not(.bk-divider):last-child{border-bottom-left-radius:var(--border-radius);border-bottom-right-radius:var(--border-radius);}"},
function _(o,t,e,r,i){r(),e.tool_icon="bk-tool-icon",e.disabled="bk-disabled",e.tool_chevron="bk-tool-chevron",e.above="bk-above",e.below="bk-below",e.left="bk-left",e.right="bk-right",e.active="bk-active",e.default=":host{--button-width:30px;--button-height:30px;--button-color:lightgray;--button-border:2px;--active-tool-highlight:#26aae1;--active-tool-border:var(--button-border) solid transparent;}:host{position:relative;width:var(--button-width);height:var(--button-height);cursor:pointer;user-select:none;-webkit-user-select:none;touch-action:none;}.bk-tool-icon{position:relative;top:calc(var(--button-border)/2);width:calc(var(--button-width) - var(--button-border));height:calc(var(--button-height) - var(--button-border));mask-size:60% 60%;mask-position:center center;mask-repeat:no-repeat;-webkit-mask-size:60% 60%;-webkit-mask-position:center center;-webkit-mask-repeat:no-repeat;background-size:60% 60%;background-origin:border-box;background-position:center center;background-repeat:no-repeat;}:host(.bk-disabled) .bk-tool-icon{background-color:var(--bokeh-icon-color-disabled);cursor:not-allowed;}.bk-tool-chevron{position:absolute;visibility:hidden;width:8px;height:8px;mask-size:100% 100%;mask-position:center center;mask-repeat:no-repeat;-webkit-mask-size:100% 100%;-webkit-mask-position:center center;-webkit-mask-repeat:no-repeat;}:host(:hover) .bk-tool-chevron{visibility:visible;}:host(.bk-above) .bk-tool-chevron{right:0;bottom:0;background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-chevron-down);-webkit-mask-image:var(--bokeh-icon-chevron-down);}:host(.bk-below) .bk-tool-chevron{right:0;top:0;background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-chevron-up);-webkit-mask-image:var(--bokeh-icon-chevron-up);}:host(.bk-left) .bk-tool-chevron{right:0;bottom:0;background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-chevron-right);-webkit-mask-image:var(--bokeh-icon-chevron-right);}:host(.bk-right) .bk-tool-chevron{left:0;bottom:0;background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-chevron-left);-webkit-mask-image:var(--bokeh-icon-chevron-left);}:host(:hover){background-color:rgba(192, 192, 192, 0.15);}:host(:focus),:host(:focus-visible){outline:1px dotted var(--active-tool-highlight);outline-offset:-1px;}:host::-moz-focus-inner{border:0;}:host(.bk-above){border-bottom:var(--active-tool-border);}:host(.bk-above.bk-active){border-bottom-color:var(--active-tool-highlight);}:host(.bk-below){border-top:var(--active-tool-border);}:host(.bk-below.bk-active){border-top-color:var(--active-tool-highlight);}:host(.bk-right){border-left:var(--active-tool-border);}:host(.bk-right.bk-active){border-left-color:var(--active-tool-highlight);}:host(.bk-left){border-right:var(--active-tool-border);}:host(.bk-left.bk-active){border-right-color:var(--active-tool-highlight);}"},
function _(e,o,t,n,s){n();const r=e(289),l=e(297);class u extends r.ToolView{get plot_view(){return this.parent}}t.GestureToolView=u,u.__name__="GestureToolView";class _ extends r.Tool{constructor(e){super(e)}tool_button(){return new l.OnOffButton({tool:this})}}t.GestureTool=_,_.__name__="GestureTool"},
function _(t,e,o,n,s){var i;n();const c=t(1),_=t(291),l=c.__importStar(t(295));class a extends _.ToolButtonView{_toggle_active(){this.class_list.toggle(l.active,this.model.tool.active)}connect_signals(){super.connect_signals();const{active:t}=this.model.tool.properties;this.on_change(t,(()=>{this._toggle_active()}))}render(){super.render(),this._toggle_active()}_clicked(){const{active:t}=this.model.tool;this.model.tool.active=!t}}o.OnOffButtonView=a,a.__name__="OnOffButtonView";class r extends _.ToolButton{constructor(t){super(t)}}o.OnOffButton=r,i=r,r.__name__="OnOffButton",i.prototype.default_view=a},
function _(e,t,o,n,s){var i;n();const l=e(1),r=e(289),_=e(297),c=l.__importStar(e(18));class a extends r.ToolView{get plot_view(){return this.parent}}o.InspectToolView=a,a.__name__="InspectToolView";class p extends r.Tool{constructor(e){super(e),this.event_type="move"}tool_button(){return new _.OnOffButton({tool:this})}}o.InspectTool=p,i=p,p.__name__="InspectTool",i.define((()=>({toggleable:[new c.PropertyAlias("visible")]}))),i.override({active:!0})},
function _(o,t,n,s,i){s();const e=o(289),c=o(300),l=o(15);class _ extends e.ToolView{connect_signals(){super.connect_signals(),this.connect(this.model.do,(o=>this.doit(o)))}}n.ActionToolView=_,_.__name__="ActionToolView";class a extends e.Tool{constructor(o){super(o),this.do=new l.Signal(this,"do")}tool_button(){return new c.ClickButton({tool:this})}}n.ActionTool=a,a.__name__="ActionTool"},
function _(t,o,e,n,i){var c;n();const l=t(291);class _ extends l.ToolButtonView{_clicked(){this.model.tool.do.emit(void 0)}}e.ClickButtonView=_,_.__name__="ClickButtonView";class s extends l.ToolButton{constructor(t){super(t)}}e.ClickButton=s,c=s,s.__name__="ClickButton",c.prototype.default_view=_},
function _(o,e,t,l,i){var n;l();const s=o(299),r=o(121);class c extends s.ActionToolView{doit(){window.open(this.model.redirect)}}t.HelpToolView=c,c.__name__="HelpToolView";class _ extends s.ActionTool{constructor(o){super(o),this.tool_name="Help",this.tool_icon=r.tool_icon_help}}t.HelpTool=_,n=_,_.__name__="HelpTool",n.prototype.default_view=c,n.define((({Str:o})=>({redirect:[o,"https://docs.bokeh.org/en/latest/docs/user_guide/interaction/tools.html"]}))),n.override({description:"Click the question mark to learn more about Bokeh plot tools."}),n.register_alias("help",(()=>new n))},
function _(o,t,e,i,l){i(),e.inner="bk-inner",e.hidden="bk-hidden",e.logo="bk-logo",e.above="bk-above",e.below="bk-below",e.left="bk-left",e.right="bk-right",e.divider="bk-divider",e.tool_overflow="bk-tool-overflow",e.horizontal="bk-horizontal",e.vertical="bk-vertical",e.default=':host{--button-width:30px;--button-height:30px;--button-color:lightgray;}:host{display:flex;flex-wrap:nowrap;align-items:center;user-select:none;-webkit-user-select:none;}:host(.bk-inner){background-color:white;opacity:0.8;}:host(.bk-hidden){visibility:hidden;opacity:0;transition:visibility 0.3s linear, opacity 0.3s linear;}.bk-logo{flex-shrink:0;}:host(.bk-above),:host(.bk-below){flex-direction:row;justify-content:flex-end;}:host(.bk-above) .bk-logo,:host(.bk-below) .bk-logo{order:1;margin-left:5px;margin-right:0px;}:host(.bk-left),:host(.bk-right){flex-direction:column;justify-content:flex-start;}:host(.bk-left) .bk-logo,:host(.bk-right) .bk-logo{order:0;margin-bottom:5px;margin-top:0px;}.bk-divider{content:" ";display:inline-block;background-color:var(--button-color);}:host(.bk-above) .bk-divider,:host(.bk-below) .bk-divider{height:10px;width:1px;}:host(.bk-left) .bk-divider,:host(.bk-right) .bk-divider{height:1px;width:10px;}.bk-tool-overflow{color:gray;display:flex;align-items:center;}.bk-tool-overflow:hover{background-color:rgba(192, 192, 192, 0.15);}.bk-tool-overflow:focus,.bk-tool-overflow:focus-visible{outline:1px dotted var(--active-tool-highlight);outline-offset:-1px;}.bk-tool-overflow::-moz-focus-inner{border:0;}:host(.bk-above) .bk-tool-overflow,:host(.bk-below) .bk-tool-overflow,:host(.bk-horizontal) .bk-tool-overflow{width:calc(var(--button-width)/2);height:var(--button-height);flex-direction:row;}:host(.bk-left) .bk-tool-overflow,:host(.bk-right) .bk-tool-overflow,:host(.bk-vertical) .bk-tool-overflow{width:var(--button-width);height:calc(var(--button-height)/2);flex-direction:column;}'},
function _(A,l,g,o,d){o(),g.logo="bk-logo",g.grey="bk-grey",g.logo_small="bk-logo-small",g.default=".bk-logo{margin:5px;position:relative;display:block;background-repeat:no-repeat;}.bk-logo.bk-grey{filter:grayscale(100%);}.bk-logo-small{width:20px;height:20px;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);}"},
function _(e,t,s,i,r){var l;i();const a=e(258),h=e(165),_=e(24),n=e(56),o=e(85);class d extends a.UpperLowerView{*children(){yield*super.children();const{lower_head:e,upper_head:t}=this;null!=e&&(yield e),null!=t&&(yield t)}async lazy_initialize(){await super.lazy_initialize();const{lower_head:e,upper_head:t}=this.model;null!=e&&(this.lower_head=await(0,n.build_view)(e,{parent:this})),null!=t&&(this.upper_head=await(0,n.build_view)(t,{parent:this}))}set_data(e){super.set_data(e);const t=_.Indices.all_set(this._lower.length);this.lower_head?.set_data(e,t),this.upper_head?.set_data(e,t)}paint(e){if(this.visuals.line.doit)for(let t=0,s=this._lower_sx.length;t<s;t++)e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),this.visuals.line.apply(e,t);const t="height"==this.model.dimension?0:Math.PI/2;if(null!=this.lower_head)for(let s=0,i=this._lower_sx.length;s<i;s++)e.save(),e.translate(this._lower_sx[s],this._lower_sy[s]),e.rotate(t+Math.PI),this.lower_head.render(e,s),e.restore();if(null!=this.upper_head)for(let s=0,i=this._upper_sx.length;s<i;s++)e.save(),e.translate(this._upper_sx[s],this._upper_sy[s]),e.rotate(t),this.upper_head.render(e,s),e.restore()}}s.WhiskerView=d,d.__name__="WhiskerView";class p extends a.UpperLower{constructor(e){super(e)}}s.Whisker=p,l=p,p.__name__="Whisker",l.prototype.default_view=d,l.mixins(o.LineVector),l.define((({Ref:e,Nullable:t})=>({lower_head:[t(e(h.ArrowHead)),()=>new h.TeeHead({size:10})],upper_head:[t(e(h.ArrowHead)),()=>new h.TeeHead({size:10})]}))),l.override({level:"underlay"})},
function _(L,e,T,l,H){l(),H("HTMLLabel",L(306).HTMLLabel),H("HTMLLabelSet",L(308).HTMLLabelSet),H("HTMLTitle",L(309).HTMLTitle)},
function _(t,e,s,i,o){var n;i();const a=t(1),l=t(307),r=t(11),_=t(20),c=t(177),d=t(170),u=a.__importStar(t(85));class h extends l.TextAnnotationView{update_layout(){const{panel:t}=this;this.layout=null!=t?new d.SideLayout(t,(()=>this.get_size()),!1):void 0}_get_size(){const{text:t}=this.model,e=new c.TextBox({text:t}),{angle:s,angle_units:i}=this.model;e.angle=(0,r.compute_angle)(s,i),e.visuals=this.visuals.text.values();const o=e.size(),{padding:n}=this;return{width:o.width+n.left+n.right,height:o.height+n.top+n.bottom}}_render(){const{angle:t,angle_units:e}=this.model,s=(0,r.compute_angle)(t,e),i=null!=this.layout?this.layout:this.plot_view.frame,o=this.coordinates.x_scale,n=this.coordinates.y_scale;let a=(()=>{switch(this.model.x_units){case"canvas":return this.model.x;case"screen":return i.bbox.xview.compute(this.model.x);case"data":return o.compute(this.model.x)}})(),l=(()=>{switch(this.model.y_units){case"canvas":return this.model.y;case"screen":return i.bbox.yview.compute(this.model.y);case"data":return n.compute(this.model.y)}})();a+=this.model.x_offset,l-=this.model.y_offset,this._paint(this.layer.ctx,this.model.text,a,l,s)}}s.HTMLLabelView=h,h.__name__="HTMLLabelView";class m extends l.TextAnnotation{constructor(t){super(t)}}s.HTMLLabel=m,n=m,m.__name__="HTMLLabel",n.prototype.default_view=h,n.mixins([u.Text,["border_",u.Line],["background_",u.Fill],["background_",u.Hatch]]),n.define((({Float:t,Str:e,Angle:s})=>({x:[t],x_units:[_.CoordinateUnits,"data"],y:[t],y_units:[_.CoordinateUnits,"data"],text:[e,""],angle:[s,0],angle_units:[_.AngleUnits,"rad"],x_offset:[t,0],y_offset:[t,0]}))),n.override({background_fill_color:null,background_hatch_color:null,border_line_color:null})},
function _(t,e,s,i,r){var n;i();const o=t(1),l=t(79),a=t(63),d=t(170),u=t(182),h=o.__importStar(t(183));class p extends l.AnnotationView{update_layout(){const{panel:t}=this;this.layout=null!=t?new d.SideLayout(t,(()=>this.get_size()),!0):void 0}initialize(){super.initialize(),this.el=(0,a.div)(),this.plot_view.canvas_view.add_overlay(this.el)}remove(){(0,a.remove)(this.el),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.render()))}render(){this.model.visible||(0,a.undisplay)(this.el),super.render()}get padding(){return h.padding(this.model.padding)}get border_radius(){return h.border_radius(this.model.border_radius)}_paint(t,e,s,i,r){const{el:n}=this;(0,a.undisplay)(n),n.textContent=e,this.visuals.text.set_value(t),n.style.position="absolute",n.style.left=`${s}px`,n.style.top=`${i}px`,n.style.color=t.fillStyle,n.style.webkitTextStroke=`1px ${t.strokeStyle}`,n.style.font=t.font,n.style.lineHeight="normal",n.style.whiteSpace="pre",n.style.padding=(()=>{const{left:t,right:e,top:s,bottom:i}=this.padding;return`${s}px ${e}px ${i}px ${t}px`})(),n.style.borderRadius=(()=>{const{top_left:t,top_right:e,bottom_right:s,bottom_left:i}=this.border_radius;return`${t}px ${e}px ${s}px ${i}px`})();const[o,l]=(()=>{switch(this.visuals.text.text_align.get_value()){case"left":return["left","0%"];case"center":return["center","-50%"];case"right":return["right","-100%"]}})(),[d,u]=(()=>{switch(this.visuals.text.text_baseline.get_value()){case"top":return["top","0%"];case"middle":default:return["center","-50%"];case"bottom":return["bottom","-100%"]}})();let h=`translate(${l}, ${u})`;0!=r&&(h+=`rotate(${r}rad)`),n.style.transformOrigin=`${o} ${d}`,n.style.transform=h,this.layout,this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),n.style.backgroundColor=t.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),n.style.borderStyle=t.getLineDash().length<2?"solid":"dashed",n.style.borderWidth=`${t.lineWidth}px`,n.style.borderColor=t.strokeStyle),(0,a.display)(n)}}s.TextAnnotationView=p,p.__name__="TextAnnotationView";class _ extends l.Annotation{constructor(t){super(t)}}s.TextAnnotation=_,n=_,_.__name__="TextAnnotation",n.define((()=>({padding:[u.Padding,0],border_radius:[u.BorderRadius,0]})))},
function _(t,e,s,i,r){var o;i();const l=t(1),a=t(124),n=l.__importStar(t(85)),c=t(20),h=t(63),_=l.__importStar(t(18)),u=t(24),d=t(12);class y extends a.DataAnnotationView{constructor(){super(...arguments),this.els=[]}set_data(t){super.set_data(t),this.els.forEach((t=>(0,h.remove)(t))),this.els=[];for(const t of this.text){const t=(0,h.div)({style:{display:"none"}});this.plot_view.canvas_view.add_overlay(t),this.els.push(t)}}remove(){this.els.forEach((t=>(0,h.remove)(t))),this.els=[],super.remove()}_rerender(){this.render()}map_data(){const{x_scale:t,y_scale:e}=this.coordinates,s=null!=this.layout?this.layout:this.plot_view.frame;this.sx=(()=>{switch(this.model.x_units){case"canvas":return new u.ScreenArray(this._x);case"screen":return s.bbox.xview.v_compute(this._x);case"data":return t.v_compute(this._x)}})(),this.sy=(()=>{switch(this.model.y_units){case"canvas":return new u.ScreenArray(this._y);case"screen":return s.bbox.yview.v_compute(this._y);case"data":return e.v_compute(this._y)}})()}paint(){const{ctx:t}=this.layer;for(let e=0,s=this.text.length;e<s;e++){const s=this.x_offset.get(e),i=this.y_offset.get(e),r=this.sx[e]+s,o=this.sy[e]-i,l=this.angle.get(e),a=this.text.get(e);isFinite(r+o+l)&&null!=a&&this._paint(t,e,a,r,o,l)}}_paint(t,e,s,i,r,o){(0,d.assert)(e in this.els);const l=this.els[e];l.textContent=s,this.visuals.text.set_vectorize(t,e),l.style.position="absolute",l.style.left=`${i}px`,l.style.top=`${r}px`,l.style.color=t.fillStyle,l.style.webkitTextStroke=`1px ${t.strokeStyle}`,l.style.font=t.font,l.style.lineHeight="normal",l.style.whiteSpace="pre";const[a,n]=(()=>{switch(this.visuals.text.text_align.get(e)){case"left":return["left","0%"];case"center":return["center","-50%"];case"right":return["right","-100%"]}})(),[c,_]=(()=>{switch(this.visuals.text.text_baseline.get(e)){case"top":return["top","0%"];case"middle":default:return["center","-50%"];case"bottom":return["bottom","-100%"]}})();let u=`translate(${n}, ${_})`;0!=o&&(u+=`rotate(${o}rad)`),l.style.transformOrigin=`${a} ${c}`,l.style.transform=u,this.layout,this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),l.style.backgroundColor=t.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),l.style.borderStyle=t.getLineDash().length<2?"solid":"dashed",l.style.borderWidth=`${t.lineWidth}px`,l.style.borderColor=t.strokeStyle),(0,h.display)(l)}}s.HTMLLabelSetView=y,y.__name__="HTMLLabelSetView";class p extends a.DataAnnotation{constructor(t){super(t)}}s.HTMLLabelSet=p,o=p,p.__name__="HTMLLabelSet",o.prototype.default_view=y,o.mixins([n.TextVector,["border_",n.LineVector],["background_",n.FillVector]]),o.define((()=>({x:[_.XCoordinateSpec,{field:"x"}],y:[_.YCoordinateSpec,{field:"y"}],x_units:[c.CoordinateUnits,"data"],y_units:[c.CoordinateUnits,"data"],text:[_.NullStringSpec,{field:"text"}],angle:[_.AngleSpec,0],x_offset:[_.NumberSpec,{value:0}],y_offset:[_.NumberSpec,{value:0}]}))),o.override({background_fill_color:null,border_line_color:null})},
function _(t,e,i,o,l){var a;o();const s=t(1),n=t(307),r=t(20),c=t(177),h=s.__importStar(t(85));class _ extends n.TextAnnotationView{_get_location(){const t=this.model.offset,e=this.model.standoff/2;let i,o;const{bbox:l}=this.layout;switch(this.panel.side){case"above":case"below":switch(this.model.vertical_align){case"top":o=l.top+e;break;case"middle":o=l.vcenter;break;case"bottom":o=l.bottom-e}switch(this.model.align){case"left":i=l.left+t;break;case"center":i=l.hcenter;break;case"right":i=l.right-t}break;case"left":switch(this.model.vertical_align){case"top":i=l.left+e;break;case"middle":i=l.hcenter;break;case"bottom":i=l.right-e}switch(this.model.align){case"left":o=l.bottom-t;break;case"center":o=l.vcenter;break;case"right":o=l.top+t}break;case"right":switch(this.model.vertical_align){case"top":i=l.right-e;break;case"middle":i=l.hcenter;break;case"bottom":i=l.left+e}switch(this.model.align){case"left":o=l.top+t;break;case"center":o=l.vcenter;break;case"right":o=l.bottom-t}}return[i,o]}_render(){const{text:t}=this.model;if(0==t.length)return;this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;const[e,i]=this._get_location(),o=this.panel.get_label_angle_heuristic("parallel");this._paint(this.layer.ctx,t,e,i,o)}_get_size(){const{text:t}=this.model,e=new c.TextBox({text:t});e.visuals=this.visuals.text.values();const i=e.size(),{padding:o}=this,l=i.width+o.left+o.right,a=i.height+o.top+o.bottom;return{width:l,height:0==a?0:2+a+this.model.standoff}}}i.HTMLTitleView=_,_.__name__="HTMLTitleView";class d extends n.TextAnnotation{constructor(t){super(t)}}i.HTMLTitle=d,a=d,d.__name__="HTMLTitle",a.prototype.default_view=_,a.mixins([h.Text,["border_",h.Line],["background_",h.Fill],["background_",h.Hatch]]),a.define((({Float:t,Str:e})=>({text:[e,""],vertical_align:[r.VerticalAlign,"bottom"],align:[r.TextAlign,"left"],offset:[t,0],standoff:[t,10]}))),a.prototype._props.text_align.options.internal=!0,a.prototype._props.text_baseline.options.internal=!0,a.override({text_font_size:"13px",text_font_style:"bold",text_line_height:1,background_fill_color:null,background_hatch_color:null,border_line_color:null})},
function _(i,e,l,o,g){o(),g("CustomJS",i(311).CustomJS),g("OpenURL",i(312).OpenURL),g("SetValue",i(313).SetValue),g("ToggleVisibility",i(314).ToggleVisibility),g("OpenDialog",i(315).OpenDialog),g("CloseDialog",i(319).CloseDialog)},
function _(require,module,exports,__esModule,__esExport){var _a;__esModule();const callback_1=require(117),object_1=require(9),array_1=require(10),string_1=require(40),logging_1=require(19),types_1=require(8),standalone_1=require(54);class CustomJS extends callback_1.Callback{constructor(t){super(t),this._state=null}connect_signals(){super.connect_signals();const{args:t,code:e,module:s}=this.properties;this.on_change([t,e,s],(()=>this._state=null))}async _compile_module(){const url=URL.createObjectURL(new Blob([this.code],{type:"text/javascript"}));try{const module=await eval(`import("${url}")`);return(0,types_1.isFunction)(module.default)?module.default:(logging_1.logger.warn("custom ES module didn't export a default function"),()=>{})}finally{URL.revokeObjectURL(url)}}async _compile_function(){const[t=[],e=[]]=(0,array_1.unzip)((0,object_1.entries)(this.args)),s=(0,string_1.use_strict)(this.code),o=new Function(...t,"cb_obj","cb_data","cb_context",s);return function(...t){return o.call(this,...e,...t)}}_is_es_module(t){return t.split("\n").some((t=>t.trimStart().startsWith("export default")))}async _compile(){const t=(()=>"auto"==this.module?this._is_es_module(this.code):this.module)();return t?{func:await this._compile_module(),module:t}:{func:await this._compile_function(),module:t}}async state(){return null==this._state&&(this._state=await this._compile()),this._state}async execute(t,e={}){const{func:s,module:o}=await this.state(),n={index:standalone_1.index};return o?s((0,object_1.to_object)(this.args),t,e,n):s.call(t,t,e,n)}}exports.CustomJS=CustomJS,_a=CustomJS,CustomJS.__name__="CustomJS",_a.define((({Unknown:t,Str:e,Dict:s,Auto:o,Or:n,Bool:i})=>({args:[s(t),{}],code:[e],module:[n(o,i),"auto"]})))},
function _(e,t,o,n,s){var i;n();const c=e(117),r=e(241),a=e(8);class d extends c.Callback{constructor(e){super(e)}navigate(e){this.same_tab?window.location.href=e:window.open(e)}execute(e,{source:t}){const o=e=>{const o=(0,r.replace_placeholders)(this.url,t,e,void 0,void 0,encodeURI);if(!(0,a.isString)(o))throw new Error("HTML output is not supported in this context");this.navigate(o)},{selected:n}=t;for(const e of n.indices)o(e);for(const e of n.line_indices)o(e)}}o.OpenURL=d,i=d,d.__name__="OpenURL",i.define((({Bool:e,Str:t})=>({url:[t,"http://"],same_tab:[e,!1]})))},
function _(e,t,r,o,a){var n;o();const s=e(117),c=e(14),l=e(19);class u extends s.Callback{constructor(e){super(e)}execute(){const{obj:e,attr:t,value:r}=this;t in e.properties?e.setv({[t]:r}):l.logger.error(`${e.type}.${t} is not a property`)}}r.SetValue=u,n=u,u.__name__="SetValue",n.define((({Str:e,Unknown:t,Ref:r})=>({obj:[r(c.HasProps)],attr:[e],value:[t]})))},
function _(e,i,t,s,l){var n;s();const c=e(117),a=e(107);class o extends c.Callback{constructor(e){super(e)}execute(){const{target:e}=this;e.visible=!e.visible}}t.ToggleVisibility=o,n=o,o.__name__="ToggleVisibility",n.define((({Ref:e})=>({target:[e(a.UIElement)]})))},
function _(e,n,a,i,l){var o;i();const t=e(117),c=e(316);class s extends t.Callback{constructor(e){super(e)}async execute(){const{dialog:e}=this,n=e.document?.views_manager;if(null!=n){let a=n.find_one(e);null==a&&(a=await n.build_view(e)),a.open()}}}a.OpenDialog=s,o=s,s.__name__="OpenDialog",o.define((({Ref:e})=>({dialog:[e(c.Dialog)]})))},
function _(t,e,i,s,n){var o;s();const l=t(1),r=t(107),a=t(122),h=t(317),_=t(63),m=t(8),c=t(56),d=t(64),p=t(10),b=t(34),u=t(12),g=l.__importStar(t(260)),f=t(60),x=t(21),v=l.__importStar(t(318)),z=v,w=l.__importDefault(t(121)),y=((0,x.Or)((0,x.Ref)(r.UIElement),(0,x.Ref)(a.DOMNode)),[]),L=(()=>{const t=(0,_.div)(),e=t.attachShadow({mode:"open"});return new _.InlineStyleSheet("\n:host {\n  display: flex;\n  flex-direction: column;\n  flex-wrap: nowrap;\n  position: fixed;\n  left: 0;\n  bottom: 0;\n  width: max-content;\n  height: max-content;\n}\n:host:empty {\n  display: none;\n}\n").install(e),(0,_.dom_ready)().then((()=>document.body.append(t))),t})();class E extends r.UIElementView{constructor(){super(...arguments),this._position=new _.InlineStyleSheet,this._stacking=new _.InlineStyleSheet,this._has_rendered=!1,this._pinned=!1,this._normal_bbox=null,this._collapsed=!1,this._minimized=!1,this._maximized=!1}*children(){yield*super.children(),yield this._title,yield this._content}stylesheets(){return[...super.stylesheets(),v.default,w.default,this._position,this._stacking]}async lazy_initialize(){await super.lazy_initialize();const t=(()=>{const{title:t}=this.model;return(0,m.isString)(t)||null==t?new h.Text({content:t??""}):t})(),e=(()=>{const{content:t}=this.model;return(0,m.isString)(t)?new h.Text({content:t}):t})();this._title=await(0,c.build_view)(t,{parent:this}),this._content=await(0,c.build_view)(e,{parent:this})}connect_signals(){super.connect_signals();const{visible:t}=this.model.properties;this.connect(t.change,(()=>this._toggle(this.model.visible)))}remove(){(0,p.remove)(y,this),this._content.remove(),this._title.remove(),super.remove()}_reposition(t){this._position.replace(":host",{left:"left"in t?(0,_.px)(t.left):"unset",right:"right"in t?(0,_.px)(t.right):"unset",top:"top"in t?(0,_.px)(t.top):"unset",bottom:"bottom"in t?(0,_.px)(t.bottom):"unset",width:"width"in t?(0,_.px)(t.width):"unset",height:"height"in t?(0,_.px)(t.height):"unset"}),this.update_bbox()}render(){super.render(),this._title.render_to(null),this._content.render_to(null);const t=(0,_.div)({class:z.inner});this.shadow_el.append(t);const e=(0,_.div)({class:z.header}),i=(0,_.div)({class:z.content},this._content.el),s=(0,_.div)({class:z.footer});t.append(e),t.append(i),t.append(s);const n=(0,_.div)({class:z.grip}),o=(0,_.div)({class:z.title},n,this._title.el),l=(0,_.div)({class:z.controls});e.append(o,l);const r=(0,_.div)({class:[z.ctrl,z.pin],title:"Pin"});r.addEventListener("click",(()=>this.pin())),this._pin_el=r;const a=(0,_.div)({class:[z.ctrl,z.collapse],title:"Collapse"});a.addEventListener("click",(()=>this.collapse())),this._collapse_el=a;const h=(0,_.div)({class:[z.ctrl,z.minimize],title:"Minimize"});h.addEventListener("click",(()=>this.minimize())),this._minimize_el=h;const m=(0,_.div)({class:[z.ctrl,z.maximize],title:"Maximize"});m.addEventListener("click",(()=>this.maximize())),this._maximize_el=m;const c=(0,_.div)({class:[z.ctrl,z.close],title:"Close"});c.addEventListener("click",(()=>this.close())),this._close_el=c,this.model.pinnable&&l.append(r),this.model.collapsible&&l.append(a),this.model.minimizable&&l.append(h),this.model.maximizable&&l.append(m),this.model.closable&&l.append(c);const d=this._handles={area:o,top:(0,_.div)({class:[z.handle,z.resize_top]}),bottom:(0,_.div)({class:[z.handle,z.resize_bottom]}),left:(0,_.div)({class:[z.handle,z.resize_left]}),right:(0,_.div)({class:[z.handle,z.resize_right]}),top_left:(0,_.div)({class:[z.handle,z.resize_top_left]}),top_right:(0,_.div)({class:[z.handle,z.resize_top_right]}),bottom_left:(0,_.div)({class:[z.handle,z.resize_bottom_left]}),bottom_right:(0,_.div)({class:[z.handle,z.resize_bottom_right]})};this.shadow_el.append(d.top,d.bottom,d.left,d.right,d.top_left,d.top_right,d.bottom_left,d.bottom_right);let p=null;const b=()=>{p=null,document.removeEventListener("pointermove",g),document.removeEventListener("pointerup",f),document.removeEventListener("keydown",x),this.el.classList.remove(z.interacting)},g=t=>{(0,u.assert)(null!=p),t.preventDefault(),this.el.classList.add(z.interacting);const e=t.x-p.xy.x,i=t.y-p.xy.y,{target:s,bbox:n}=p,o=this._move_bbox(s,n,e,i);this._reposition(o)},f=t=>{(0,u.assert)(null!=p),t.preventDefault(),b()},x=t=>{if("Escape"==t.key){(0,u.assert)(null!=p),t.preventDefault();const{left:e,top:i,width:s,height:n}=p.bbox;this._reposition({left:e,top:i,width:s,height:n}),b()}};this.el.addEventListener("pointerdown",(t=>{(0,u.assert)(null==p),this.bring_to_front();const e=this._hit_target(t.composedPath());if(null==e||!this._can_hit(e))return;t.preventDefault();const{x:i,y:s}=t;p={bbox:(0,_.bounding_box)(this.el),xy:{x:i,y:s},target:e},document.addEventListener("pointermove",g),document.addEventListener("pointerup",f),document.addEventListener("keydown",x);this._handles[e].setPointerCapture(t.pointerId)})),o.addEventListener("wheel",(t=>{const e=t.deltaY;(e<0&&!this._collapsed||e>0&&this._collapsed)&&(t.preventDefault(),t.stopPropagation(),this.collapse())})),this._has_rendered=!0}get resizable(){const{resizable:t}=this.model;return{left:"left"==t||"x"==t||"all"==t,right:"right"==t||"x"==t||"all"==t,top:"top"==t||"y"==t||"all"==t,bottom:"bottom"==t||"y"==t||"all"==t}}_hit_target(t){const{_handles:e}=this;for(const i of t)switch(i){case e.area:return"area";case e.top:return"top";case e.bottom:return"bottom";case e.left:return"left";case e.right:return"right";case e.top_left:return"top_left";case e.top_right:return"top_right";case e.bottom_left:return"bottom_left";case e.bottom_right:return"bottom_right"}return null}_can_hit(t){if(this._minimized||this._maximized)return!1;const{left:e,right:i,top:s,bottom:n}=this.resizable;switch(t){case"top_left":return s&&e;case"top_right":return s&&i;case"bottom_left":return n&&e;case"bottom_right":return n&&i;case"left":return e;case"right":return i;case"top":return s;case"bottom":return n;case"area":return"none"!=this.model.movable}}_move_bbox(t,e,i,s){const n=(t,e)=>e instanceof f.Coordinate?this.resolve_as_scalar(e,t):NaN,o=d.BBox.from_lrtb({left:n("x",this.model.left_limit),right:n("x",this.model.right_limit),top:n("y",this.model.top_limit),bottom:n("y",this.model.bottom_limit)}),[l,r,a,h]=(()=>{const{symmetric:e}=this.model,[n,o]=e?[-i,-s]:[0,0];switch(t){case"top_left":return[i,n,s,o];case"top_right":return[n,i,s,o];case"bottom_left":return[i,n,o,s];case"bottom_right":return[n,i,o,s];case"left":return[i,n,0,0];case"right":return[n,i,0,0];case"top":return[0,0,s,o];case"bottom":return[0,0,o,s];case"area":switch(this.model.movable){case"both":return[i,i,s,s];case"x":return[i,i,0,0];case"y":return[0,0,s,s];case"none":return[0,0,0,0]}}})(),_=(t,e)=>(0,p.min)([t,e]),m=t=>t<0?-1:t>0?1:0;let{left:c,right:b,left_sign:u,right_sign:g}=(()=>{const t=e.left+l,i=e.right+r,s=m(l),n=m(r);return t<=i?{left:t,right:i,left_sign:s,right_sign:n}:{left:i,right:t,left_sign:n,right_sign:s}})(),{top:x,bottom:v,top_sign:z,bottom_sign:w}=(()=>{const t=e.top+a,i=e.bottom+h,s=m(a),n=m(h);return t<=i?{top:t,bottom:i,top_sign:s,bottom_sign:n}:{top:i,bottom:t,top_sign:n,bottom_sign:s}})();const y=c-o.left,L=o.right-b,E=_(y<0?y:NaN,L<0?L:NaN);isFinite(E)&&E<0&&(c+=-u*-E,b+=-g*-E);const N=x-o.top,k=o.bottom-v,D=_(N<0?N:NaN,k<0?k:NaN);return isFinite(D)&&D<0&&(x+=-z*-D,v+=-w*-D),d.BBox.from_lrtb({left:c,right:b,top:x,bottom:v})}pin(){const{_pinned:t}=this;for(const e of y)e==this?this._pin(!t):e._pin(!1);t||this.bring_to_front()}_pin(t){this._pinned!=t&&(this._pinned=t,this.el.classList.toggle(z.pinned,this._pinned),this._pin_el.title=this._pinned?"Unpin":"Pin")}collapse(){const t=(()=>{if(this._collapsed){const{_normal_bbox:t}=this;return(0,u.assert)(null!=t),this._normal_bbox=null,t}{this._minimize(!1),this._maximize(!1),null==this._normal_bbox&&(this._normal_bbox=(0,_.bounding_box)(this.el));const{left:t,top:e,width:i}=this._normal_bbox;return{left:t,top:e,width:i,height:"max-content"}}})();this._reposition(t),this._collapse(!this._collapsed)}_collapse(t){this._collapsed!=t&&(this._collapsed=t,this.el.classList.toggle(z.collapsed,this._collapsed),this._collapse_el.title=this._collapsed?"Restore":"Collapse")}minimize(){const t=(()=>{if(this._minimized){const{_normal_bbox:t}=this;return(0,u.assert)(null!=t),this._normal_bbox=null,t}return this._pin(!1),this._collapse(!1),this._maximize(!1),null==this._normal_bbox&&(this._normal_bbox=(0,_.bounding_box)(this.el)),{width:"auto",height:"max-content"}})();this._reposition(t),this._minimize(!this._minimized)}_minimize(t){if(this._minimized!=t){this._minimized=t;(t?L.shadowRoot??L:document.body).append(this.el),this.el.classList.toggle(z.minimized,this._minimized),this._minimize_el.title=this._minimized?"Restore":"Minimize"}}maximize(){const t=(()=>{if(this._maximized){const{_normal_bbox:t}=this;return(0,u.assert)(null!=t),this._normal_bbox=null,t}return this._collapse(!1),this._minimize(!1),null==this._normal_bbox&&(this._normal_bbox=(0,_.bounding_box)(this.el)),{left:0,top:0,width:"100%",height:"100%"}})();this._reposition(t),this._maximize(!this._maximized)}_maximize(t){this._maximized!=t&&(this._maximized=t,this.el.classList.toggle(z.maximized,this._maximized),this._maximize_el.title=this._maximized?"Restore":"Maximize")}restore(){this._collapse(!1),this._minimize(!1),this._maximize(!1);const{_normal_bbox:t}=this;null!=t&&(this._reposition(t),this._normal_bbox=null)}_toggle(t){t?(this._has_rendered||this.render(),this.el.isConnected||(y.push(this),document.body.append(this.el)),this.bring_to_front()):((0,p.remove)(y,this),this.el.remove())}open(){this.model.setv({visible:!0},{check_eq:!1})}close(){switch(this.model.close_action){case"hide":this.model.visible=!1;break;case"destroy":this.remove()}}bring_to_front(){const t=(0,p.find)(y,(t=>t._pinned));null!=t&&(0,p.remove)(y,t),(0,p.remove)(y,this),y.push(this),null!=t&&y.push(t);for(const[t,e]of(0,b.enumerate)(y))t._stacking.replace(":host",{"z-index":`${e}`})}}i.DialogView=E,E.__name__="DialogView";class N extends r.UIElement{constructor(t){super(t)}}i.Dialog=N,o=N,N.__name__="Dialog",o.prototype.default_view=E,o.define((({Bool:t,Str:e,Ref:i,Or:s,Nullable:n,Enum:o})=>({title:[n(s(e,i(a.DOMNode),i(r.UIElement))),null],content:[s(e,i(a.DOMNode),i(r.UIElement))],pinnable:[t,!0],collapsible:[t,!0],minimizable:[t,!0],maximizable:[t,!0],closable:[t,!0],close_action:[o("hide","destroy"),"destroy"],resizable:[g.Resizable,"all"],movable:[g.Movable,"both"],symmetric:[t,!1],top_limit:[g.Limit,null],bottom_limit:[g.Limit,null],left_limit:[g.Limit,null],right_limit:[g.Limit,null]})))},
function _(e,t,n,r,o){var s;r();const _=e(122);class c extends _.DOMNodeView{render(){this.el.textContent=this.model.content}after_render(){this.finish()}_createElement(){return document.createTextNode("")}}n.TextView=c,c.__name__="TextView";class d extends _.DOMNode{constructor(e){super(e)}}n.Text=d,s=d,d.__name__="Text",s.prototype.default_view=c,s.define((({Str:e})=>({content:[e,""]})))},
function _(e,i,o,r,t){r(),o.interacting="bk-interacting",o.inner="bk-inner",o.header="bk-header",o.content="bk-content",o.collapsed="bk-collapsed",o.minimized="bk-minimized",o.footer="bk-footer",o.grip="bk-grip",o.title="bk-title",o.controls="bk-controls",o.ctrl="bk-ctrl",o.pin="bk-pin",o.pinned="bk-pinned",o.collapse="bk-collapse",o.minimize="bk-minimize",o.maximize="bk-maximize",o.maximized="bk-maximized",o.close="bk-close",o.handle="bk-handle",o.resize_top="bk-resize-top",o.resize_bottom="bk-resize-bottom",o.resize_left="bk-resize-left",o.resize_right="bk-resize-right",o.resize_top_left="bk-resize-top-left",o.resize_top_right="bk-resize-top-right",o.resize_bottom_left="bk-resize-bottom-left",o.resize_bottom_right="bk-resize-bottom-right",o.default=":host{--bokeh-bg-color:white;--bokeh-border-color:#e5e5e5;--bokeh-shadow-color:#e5e5e5;--bokeh-ctrl-size:16px;--bokeh-ctrl-color:gray;}:host{position:fixed;left:200px;top:200px;width:600px;height:600px;width:80vw;height:60vh;}:host(.bk-interacting){opacity:0.9;}.bk-inner{position:relative;display:flex;flex-direction:column;flex-wrap:nowrap;width:100%;height:100%;overflow:hidden;border-radius:4px;background-color:var(--bokeh-bg-color);border:1px solid var(--bokeh-border-color);box-shadow:5px 5px 10px var(--bokeh-shadow-color);}.bk-header{position:relative;display:flex;flex:0;gap:1em;padding:5px;background-color:lightgray;}.bk-content{position:relative;display:flex;flex:1;overflow:auto;}:host(.bk-collapsed) .bk-content,:host(.bk-minimized) .bk-content,:host(.bk-collapsed) .bk-footer,:host(.bk-minimized) .bk-footer{display:none;}.bk-footer{position:relative;display:flex;flex:0;}.bk-grip{width:var(--bokeh-ctrl-size);height:var(--bokeh-ctrl-size);background-color:var(--bokeh-ctrl-color);background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-y-grip);-webkit-mask-image:var(--bokeh-icon-y-grip);mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;}.bk-title{position:relative;display:flex;flex:1;cursor:move;white-space:nowrap;}.bk-controls{position:relative;display:flex;flex:0;}.bk-ctrl{width:var(--bokeh-ctrl-size);height:var(--bokeh-ctrl-size);cursor:pointer;mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;background-color:var(--bokeh-ctrl-color);}.bk-ctrl:hover{background-color:red;}.bk-pin{mask-image:var(--bokeh-icon-pin);-webkit-mask-image:var(--bokeh-icon-pin);}:host(.bk-pinned) .bk-pin{mask-image:var(--bokeh-icon-unpin);-webkit-mask-image:var(--bokeh-icon-unpin);}.bk-collapse{mask-image:var(--bokeh-icon-chevron-up);-webkit-mask-image:var(--bokeh-icon-chevron-up);}:host(.bk-collapsed) .bk-collapse{mask-image:var(--bokeh-icon-chevron-down);-webkit-mask-image:var(--bokeh-icon-chevron-down);}.bk-minimize{mask-image:var(--bokeh-icon-arrow-down-to-bar);-webkit-mask-image:var(--bokeh-icon-arrow-down-to-bar);}:host(.bk-minimized) .bk-minimize{mask-image:var(--bokeh-icon-arrow-up-from-bar);-webkit-mask-image:var(--bokeh-icon-arrow-up-from-bar);}.bk-maximize{mask-image:var(--bokeh-icon-maximize);-webkit-mask-image:var(--bokeh-icon-maximize);}:host(.bk-maximized) .bk-maximize{mask-image:var(--bokeh-icon-minimize);-webkit-mask-image:var(--bokeh-icon-minimize);}.bk-close{mask-image:var(--bokeh-icon-x);-webkit-mask-image:var(--bokeh-icon-x);}:host{--resize-radius:3px;--resize-depth:calc(2*var(--resize-radius));}:host(.bk-minimized){position:relative;}:host(.bk-minimized) .bk-handle,:host(.bk-maximized) .bk-handle{display:none;}:host(.bk-minimized) .bk-title,:host(.bk-maximized) .bk-title{cursor:default;}.bk-resize-top{position:absolute;top:0;left:var(--resize-radius);width:calc(100% - var(--resize-depth));height:var(--resize-depth);transform:translate(0, -50%);cursor:ns-resize;}.bk-resize-bottom{position:absolute;bottom:0;left:var(--resize-radius);width:calc(100% - var(--resize-depth));height:var(--resize-depth);transform:translate(0, 50%);cursor:ns-resize;}.bk-resize-left{position:absolute;left:0;top:var(--resize-radius);width:var(--resize-depth);height:calc(100% - var(--resize-depth));transform:translate(-50%, 0);cursor:ew-resize;}.bk-resize-right{position:absolute;right:0;top:var(--resize-radius);width:var(--resize-depth);height:calc(100% - var(--resize-depth));transform:translate(50%, 0);cursor:ew-resize;}.bk-resize-top-left{position:absolute;top:0;left:0;width:var(--resize-depth);height:var(--resize-depth);transform:translate(-50%, -50%);cursor:nw-resize;}.bk-resize-top-right{position:absolute;top:0;right:0;width:var(--resize-depth);height:var(--resize-depth);transform:translate(50%, -50%);cursor:ne-resize;}.bk-resize-bottom-left{position:absolute;bottom:0;left:0;width:var(--resize-depth);height:var(--resize-depth);transform:translate(-50%, 50%);cursor:sw-resize;}.bk-resize-bottom-right{position:absolute;bottom:0;right:0;width:var(--resize-depth);height:var(--resize-depth);transform:translate(50%, 50%);cursor:se-resize;}"},
function _(e,o,a,n,s){var c;n();const l=e(117),i=e(316);class t extends l.Callback{constructor(e){super(e)}async execute(){const{dialog:e}=this;e.document?.views_manager?.find_one(e)?.close()}}a.CloseDialog=t,c=t,t.__name__="CloseDialog",c.define((({Ref:e})=>({dialog:[e(i.Dialog)]})))},
function _(a,n,e,r,s){r(),s("Canvas",a(321).Canvas),s("CartesianFrame",a(185).CartesianFrame)},
function _(e,t,s,i,a){var r;i();const l=e(1),n=e(29),h=e(19),o=e(63),_=e(20),p=e(322),c=e(180),u=e(110),d=e(107),v=e(63),b=l.__importStar(e(324)),w=l.__importDefault(e(121));const g=(()=>{let t;return async()=>void 0!==t?t:t=await async function(){const t=document.createElement("canvas"),s=t.getContext("webgl",{alpha:!0,antialias:!1,depth:!1,premultipliedAlpha:!0});if(null!=s){const i=await(0,c.load_module)(Promise.resolve().then((()=>l.__importStar(e(533)))));if(null!=i){const e=i.get_regl(s);if(e.has_webgl)return{canvas:t,regl_wrapper:e};h.logger.trace("WebGL is supported, but not the required extensions")}else h.logger.trace("WebGL is supported, but bokehjs(.min).js bundle is not available")}else h.logger.trace("WebGL is not supported");return null}()})();class y extends d.UIElementView{constructor(){super(...arguments),this.webgl=null,this._size=new v.InlineStyleSheet,this.plot_views=[]}initialize(){super.initialize(),this.underlays_el=(0,o.div)({class:b.layer}),this.primary=this.create_layer(),this.overlays=this.create_layer(),this.overlays_el=(0,o.div)({class:b.layer}),this.events_el=(0,o.div)({class:[b.layer,b.events]}),this.ui_event_bus=new p.UIEventBus(this)}get layers(){return[this.underlays_el,this.primary,this.overlays,this.overlays_el,this.events_el]}async lazy_initialize(){if(await super.lazy_initialize(),"webgl"==this.model.output_backend&&(this.webgl=await g(),n.settings.force_webgl&&null==this.webgl))throw new Error("webgl is not available")}remove(){this.ui_event_bus.remove(),super.remove()}stylesheets(){return[...super.stylesheets(),b.default,w.default,this._size]}render(){super.render();const e=[this.underlays_el,this.primary.el,this.overlays.el,this.overlays_el,this.events_el];(0,o.append)(this.shadow_el,...e)}add_underlay(e){this.underlays_el.appendChild(e)}add_overlay(e){this.overlays_el.appendChild(e)}add_event(e){this.events_el.appendChild(e)}get pixel_ratio(){return this.primary.pixel_ratio}_update_bbox(){const e=super._update_bbox();if(e){const{width:e,height:t}=this.bbox;this._size.replace(`.${b.layer}`,{width:(0,o.px)(e),height:(0,o.px)(t)}),this.primary.resize(e,t),this.overlays.resize(e,t)}return e}after_resize(){0!=this.plot_views.length?this.finish():super.after_resize()}_after_resize(){super._after_resize();const{width:e,height:t}=this.bbox;this.primary.resize(e,t),this.overlays.resize(e,t)}resize(){this._update_bbox(),this._after_resize()}prepare_webgl(e){const{webgl:t}=this;if(null!=t){const{width:s,height:i}=this.bbox;t.canvas.width=this.pixel_ratio*s,t.canvas.height=this.pixel_ratio*i;const[a,r,l,n]=e,{xview:h,yview:o}=this.bbox,_=h.compute(a),p=o.compute(r+n),c=this.pixel_ratio;t.regl_wrapper.set_scissor(c*_,c*p,c*l,c*n),this._clear_webgl()}}blit_webgl(e){const{webgl:t}=this;if(null!=t&&t.canvas.width*t.canvas.height>0){if(h.logger.debug("Blitting WebGL canvas"),e.restore(),e.drawImage(t.canvas,0,0),e.save(),this.model.hidpi){const t=this.pixel_ratio;e.scale(t,t),e.translate(.5,.5)}this._clear_webgl()}}_clear_webgl(){const{webgl:e}=this;if(null!=e){const{regl_wrapper:t,canvas:s}=e;t.clear(s.width,s.height)}}compose(){const e=this.create_layer(),{width:t,height:s}=this.bbox;return e.resize(t,s),e.ctx.drawImage(this.primary.canvas,0,0),e.ctx.drawImage(this.overlays.canvas,0,0),e}create_layer(){const{output_backend:e,hidpi:t}=this.model;return new u.CanvasLayer(e,t)}to_blob(){return this.compose().to_blob()}}s.CanvasView=y,y.__name__="CanvasView";class m extends d.UIElement{constructor(e){super(e)}}s.Canvas=m,r=m,m.__name__="Canvas",r.prototype.default_view=y,r.define((({Bool:e})=>({hidpi:[e,!0],output_backend:[_.OutputBackend,"canvas"]})))},
function _(t,e,n,i,s){i();const r=t(1),_=t(292),o=t(15),a=t(63),h=r.__importStar(t(53)),l=t(323),c=t(10),p=t(8),u=t(290);function v(t){return(0,p.isObject)(t)&&"on_enter"in t&&"on_move"in t&&"on_leave"in t}function d(t){return(0,p.isObject)(t)&&"on_pan_start"in t&&"on_pan"in t&&"on_pan_end"in t}function g(t){return(0,p.isObject)(t)&&"on_pinch_start"in t&&"on_pinch"in t&&"on_pinch_end"in t}function w(t){return(0,p.isObject)(t)&&"on_rotate_start"in t&&"on_rotate"in t&&"on_rotate_end"in t}n.is_Tapable=function(t){return(0,p.isObject)(t)&&"on_tap"in t},n.is_Moveable=v,n.is_Pannable=d,n.is_Pinchable=g,n.is_Rotatable=w,n.is_Scrollable=function(t){return(0,p.isObject)(t)&&"on_scroll"in t},n.is_Keyable=function(t){return(0,p.isObject)(t)&&"on_keydown"in t&&"on_keyup"in t};class m{constructor(t){this.pan_start=new o.Signal(this,"pan:start"),this.pan=new o.Signal(this,"pan"),this.pan_end=new o.Signal(this,"pan:end"),this.pinch_start=new o.Signal(this,"pinch:start"),this.pinch=new o.Signal(this,"pinch"),this.pinch_end=new o.Signal(this,"pinch:end"),this.rotate_start=new o.Signal(this,"rotate:start"),this.rotate=new o.Signal(this,"rotate"),this.rotate_end=new o.Signal(this,"rotate:end"),this.tap=new o.Signal(this,"tap"),this.doubletap=new o.Signal(this,"doubletap"),this.press=new o.Signal(this,"press"),this.pressup=new o.Signal(this,"pressup"),this.move_enter=new o.Signal(this,"move:enter"),this.move=new o.Signal(this,"move"),this.move_exit=new o.Signal(this,"move:exit"),this.scroll=new o.Signal(this,"scroll"),this.keydown=new o.Signal(this,"keydown"),this.keyup=new o.Signal(this,"keyup"),this._prev_move=null,this._curr_pan=null,this._curr_pinch=null,this._curr_rotate=null,this._current_pan_view=null,this._current_pinch_view=null,this._current_rotate_view=null,this._current_move_view=null,this.canvas_view=t,this.hit_area=t.events_el,this.on_tap=this.on_tap.bind(this),this.on_doubletap=this.on_doubletap.bind(this),this.on_press=this.on_press.bind(this),this.on_pressup=this.on_pressup.bind(this),this.on_enter=this.on_enter.bind(this),this.on_move=this.on_move.bind(this),this.on_leave=this.on_leave.bind(this),this.on_pan_start=this.on_pan_start.bind(this),this.on_pan=this.on_pan.bind(this),this.on_pan_end=this.on_pan_end.bind(this),this.on_pinch_start=this.on_pinch_start.bind(this),this.on_pinch=this.on_pinch.bind(this),this.on_pinch_end=this.on_pinch_end.bind(this),this.on_rotate_start=this.on_rotate_start.bind(this),this.on_rotate=this.on_rotate.bind(this),this.on_rotate_end=this.on_rotate_end.bind(this),this.ui_gestures=new _.UIGestures(this.hit_area,this,{must_be_target:!0}),this.ui_gestures.connect_signals(),this.on_context_menu=this.on_context_menu.bind(this),this.on_mouse_wheel=this.on_mouse_wheel.bind(this),this.on_key_down=this.on_key_down.bind(this),this.on_key_up=this.on_key_up.bind(this),this.hit_area.addEventListener("contextmenu",this.on_context_menu),this.hit_area.addEventListener("wheel",this.on_mouse_wheel),document.addEventListener("keydown",this.on_key_down),document.addEventListener("keyup",this.on_key_up)}remove(){this.ui_gestures.remove(),this.hit_area.removeEventListener("contextmenu",this.on_context_menu),this.hit_area.removeEventListener("wheel",this.on_mouse_wheel),document.removeEventListener("keydown",this.on_key_down),document.removeEventListener("keyup",this.on_key_up)}register_tool(t){const{model:e}=t,n=n=>i=>{null!=i.tool&&i.tool!=e||n.call(t,i.e)};null!=t._pan_start&&t.connect(this.pan_start,n(t._pan_start)),null!=t._pan&&t.connect(this.pan,n(t._pan)),null!=t._pan_end&&t.connect(this.pan_end,n(t._pan_end)),null!=t._pinch_start&&t.connect(this.pinch_start,n(t._pinch_start)),null!=t._pinch&&t.connect(this.pinch,n(t._pinch)),null!=t._pinch_end&&t.connect(this.pinch_end,n(t._pinch_end)),null!=t._rotate_start&&t.connect(this.rotate_start,n(t._rotate_start)),null!=t._rotate&&t.connect(this.rotate,n(t._rotate)),null!=t._rotate_end&&t.connect(this.rotate_end,n(t._rotate_end)),null!=t._move_enter&&t.connect(this.move_enter,n(t._move_enter)),null!=t._move&&t.connect(this.move,n(t._move)),null!=t._move_exit&&t.connect(this.move_exit,n(t._move_exit)),null!=t._tap&&t.connect(this.tap,n(t._tap)),null!=t._doubletap&&t.connect(this.doubletap,n(t._doubletap)),null!=t._press&&t.connect(this.press,n(t._press)),null!=t._pressup&&t.connect(this.pressup,n(t._pressup)),null!=t._scroll&&t.connect(this.scroll,n(t._scroll)),null!=t._keydown&&t.connect(this.keydown,n(t._keydown)),null!=t._keyup&&t.connect(this.keyup,n(t._keyup))}hit_test_renderers(t,e,n){const i=t.get_renderer_views();for(const t of(0,c.reversed)(i))if(t.interactive_hit?.(e,n))return t;return null}set_cursor(t){this.hit_area.style.cursor=t??"default"}hit_test_frame(t,e,n){return t.frame.bbox.contains(e,n)}hit_test_plot(t,e){for(const n of this.canvas_view.plot_views)if(n.bbox.relative().contains(t,e))return n;return null}_trigger(t,e){if(!this.hit_area.isConnected)return;const{sx:n,sy:i,native:s}=e,r=this.hit_test_plot(n,i),_=t=>{const[s,r]=[n,i];return{...e,sx:s,sy:r}};if("pan_start"==e.type||"pan"==e.type||"pan_end"==e.type){let n;if("pan_start"==e.type&&null!=r?(this._curr_pan={plot_view:r},n=r):"pan"==e.type&&null!=this._curr_pan?n=this._curr_pan.plot_view:"pan_end"==e.type&&null!=this._curr_pan?(n=this._curr_pan.plot_view,this._curr_pan=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("pinch_start"==e.type||"pinch"==e.type||"pinch_end"==e.type){let n;if("pinch_start"==e.type&&null!=r?(this._curr_pinch={plot_view:r},n=r):"pinch"==e.type&&null!=this._curr_pinch?n=this._curr_pinch.plot_view:"pinch_end"==e.type&&null!=this._curr_pinch?(n=this._curr_pinch.plot_view,this._curr_pinch=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("rotate_start"==e.type||"rotate"==e.type||"rotate_end"==e.type){let n;if("rotate_start"==e.type&&null!=r?(this._curr_rotate={plot_view:r},n=r):"rotate"==e.type&&null!=this._curr_rotate?n=this._curr_rotate.plot_view:"rotate_end"==e.type&&null!=this._curr_rotate?(n=this._curr_rotate.plot_view,this._curr_rotate=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("enter"==e.type||"move"==e.type||"leave"==e.type){const o=this._prev_move?.plot_view;if(null!=o&&("leave"==e.type||o!=r)){const{sx:t,sy:e}=_();this.__trigger(o,this.move_exit,{type:"leave",sx:t,sy:e,modifiers:{shift:!1,ctrl:!1,alt:!1},native:s},s)}if(null!=r&&("enter"==e.type||o!=r)){const{sx:t,sy:e}=_();this.__trigger(r,this.move_enter,{type:"enter",sx:t,sy:e,modifiers:{shift:!1,ctrl:!1,alt:!1},native:s},s)}if(null!=r&&"move"==e.type){const e=_();this.__trigger(r,t,e,s)}this._prev_move={sx:n,sy:i,plot_view:r}}else if(null!=r){const e=_();this.__trigger(r,t,e,s)}}__trigger(t,e,n,i){const s=t.model.toolbar.gestures,r=e.name,_=r.split(":")[0],o=this.hit_test_renderers(t,n.sx,n.sy);if("pan"==_){if(null!=this._current_pan_view)return"pan"==r?this._current_pan_view.on_pan(n):"pan:end"==r&&(this._current_pan_view.on_pan_end(n),this._current_pan_view=null),void i.preventDefault();if(null!=o&&"pan:start"==r&&d(o)&&o.on_pan_start(n))return this._current_pan_view=o,void i.preventDefault()}else if("pinch"==_){if(null!=this._current_pinch_view)return"pinch"==r?this._current_pinch_view.on_pinch(n):"pinch:end"==r&&(this._current_pinch_view.on_pinch_end(n),this._current_pinch_view=null),void i.preventDefault();if(null!=o&&"pinch:start"==r&&g(o)&&o.on_pinch_start(n))return this._current_pinch_view=o,void i.preventDefault()}else if("rotate"==_){if(null!=this._current_rotate_view)return"rotate"==r?this._current_rotate_view.on_rotate(n):"rotate:end"==r&&(this._current_rotate_view.on_rotate_end(n),this._current_rotate_view=null),void i.preventDefault();if(null!=o&&"rotate:start"==r&&w(o)&&o.on_rotate_start(n))return this._current_rotate_view=o,void i.preventDefault()}else"move"==_&&(this._current_move_view==o?this._current_move_view?.on_move(n):(this._current_move_view?.on_leave(n),this._current_move_view=null,null!=o&&v(o)&&o.on_enter(n)&&(this._current_move_view=o)));switch(_){case"move":{const i=s.move.active;null!=i&&this.trigger(e,n,i);const r=t.model.toolbar.inspectors.filter((t=>t.active)),_=(()=>{const e=this._current_pan_view??this._current_pinch_view??this._current_rotate_view??this._current_move_view??o??function(e){if(null!=e){const n=e instanceof u.ToolProxy?e.tools[0]:e;return t.tool_views.get(n)??null}return null}(i);if(null!=e){const t=e.cursor(n.sx,n.sy);if(null!=t)return t}return this.hit_test_frame(t,n.sx,n.sy)&&!(0,c.is_empty)(r)?"crosshair":null})();this.set_cursor(_),null==o||o.model.propagate_hover||(0,c.is_empty)(r)||(e=this.move_exit),r.map((t=>this.trigger(e,n,t)));break}case"tap":{const r=i.composedPath();if(0!=r.length&&r[0]!=this.hit_area)return;if(o?.on_hit?.(n.sx,n.sy),this.hit_test_frame(t,n.sx,n.sy)){const t=s.tap.active;null!=t&&this.trigger(e,n,t)}break}case"doubletap":if(this.hit_test_frame(t,n.sx,n.sy)){const t=s.doubletap.active??s.tap.active;null!=t&&this.trigger(e,n,t)}break;case"press":if(this.hit_test_frame(t,n.sx,n.sy)){const t=s.press.active??s.tap.active;null!=t&&this.trigger(e,n,t)}break;case"pinch":{const t=s.pinch.active??s.scroll.active;null!=t&&(i.preventDefault(),i.stopPropagation(),this.trigger(e,n,t));break}case"scroll":{const t=s.scroll.active;null!=t&&(i.preventDefault(),i.stopPropagation(),this.trigger(e,n,t));break}case"pan":{const t=s.pan.active;null!=t&&(i.preventDefault(),i.stopPropagation(),this.trigger(e,n,t));break}default:{const t=s[_].active;null!=t&&this.trigger(e,n,t)}}this._trigger_bokeh_event(t,n)}trigger(t,e,n=null){t.emit({tool:n,e})}_trigger_bokeh_event(t,e){const n=(()=>{const{sx:n,sy:i,modifiers:s}=e,r=t.frame.x_scale.invert(n),_=t.frame.y_scale.invert(i);switch(e.type){case"wheel":return new h.MouseWheel(n,i,r,_,e.delta,s);case"enter":return new h.MouseEnter(n,i,r,_,s);case"move":return new h.MouseMove(n,i,r,_,s);case"leave":return new h.MouseLeave(n,i,r,_,s);case"tap":return new h.Tap(n,i,r,_,s);case"double_tap":return new h.DoubleTap(n,i,r,_,s);case"press":return new h.Press(n,i,r,_,s);case"press_up":return new h.PressUp(n,i,r,_,s);case"pan_start":return new h.PanStart(n,i,r,_,s);case"pan":return new h.Pan(n,i,r,_,e.dx,e.dy,s);case"pan_end":return new h.PanEnd(n,i,r,_,s);case"pinch_start":return new h.PinchStart(n,i,r,_,s);case"pinch":return new h.Pinch(n,i,r,_,e.scale,s);case"pinch_end":return new h.PinchEnd(n,i,r,_,s);case"rotate_start":return new h.RotateStart(n,i,r,_,s);case"rotate":return new h.Rotate(n,i,r,_,e.rotation,s);case"rotate_end":return new h.RotateEnd(n,i,r,_,s);default:return null}})();null!=n&&t.model.trigger_event(n)}_get_sxy(t){const{pageX:e,pageY:n}=t,{left:i,top:s}=(0,a.offset_bbox)(this.hit_area);return{sx:e-i,sy:n-s}}_get_modifiers(t){return{shift:t.shiftKey,ctrl:t.ctrlKey,alt:t.altKey}}_scroll_event(t){return{type:t.type,...this._get_sxy(t),delta:(0,l.getDeltaY)(t),modifiers:this._get_modifiers(t),native:t}}_key_event(t){return{type:t.type,key:t.key,modifiers:this._get_modifiers(t),native:t}}on_tap(t){this._trigger(this.tap,t)}on_doubletap(t){this._trigger(this.doubletap,t)}on_press(t){this._trigger(this.press,t)}on_pressup(t){this._trigger(this.pressup,t)}on_enter(t){this._trigger(this.move_enter,t)}on_move(t){this._trigger(this.move,t)}on_leave(t){this._trigger(this.move_exit,t)}on_pan_start(t){this._trigger(this.pan_start,t)}on_pan(t){this._trigger(this.pan,t)}on_pan_end(t){this._trigger(this.pan_end,t)}on_pinch_start(t){this._trigger(this.pinch_start,t)}on_pinch(t){this._trigger(this.pinch,t)}on_pinch_end(t){this._trigger(this.pinch_end,t)}on_rotate_start(t){this._trigger(this.rotate_start,t)}on_rotate(t){this._trigger(this.rotate,t)}on_rotate_end(t){this._trigger(this.rotate_end,t)}on_mouse_wheel(t){this._trigger(this.scroll,this._scroll_event(t))}on_context_menu(t){}on_key_down(t){this.trigger(this.keydown,this._key_event(t))}on_key_up(t){this.trigger(this.keyup,this._key_event(t))}}n.UIEventBus=m,m.__name__="UIEventBus"},
function _(t,e,n,a,r){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function o(t){const e=getComputedStyle(t).fontSize,n=parseInt(e,10);return isNaN(n)?null:n}a(),n.getDeltaY=function(t){let e=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:e*=o((n=t.target).offsetParent??document.body)??o(n)??16;break;case t.DOM_DELTA_PAGE:e*=function(t){return t.clientHeight}(t.target)}var n;return e}},
function _(e,t,n,o,a){o(),n.layer="bk-layer",n.events="bk-events",n.default=".bk-layer{position:absolute;top:0;left:0;width:100%;height:100%;}.bk-events{touch-action:none;}"},
function _(d,e,n,o,i){o(),i("CoordinateMapping",d(91).CoordinateMapping),i("Node",d(59).Node),i("XY",d(61).XY),i("Indexed",d(62).Indexed)},
function _(m,o,n,r,a){r(),a("Expression",m(327).Expression),a("CustomJSExpr",m(328).CustomJSExpr),a("Stack",m(329).Stack),a("CumSum",m(330).CumSum),a("ScalarExpression",m(327).ScalarExpression),a("Minimum",m(331).Minimum),a("Maximum",m(332).Maximum);var s=m(333);a("XComponent",s.XComponent),a("YComponent",s.YComponent),a("PolarTransform",m(334).PolarTransform)},
function _(e,t,s,i,r){i();const n=e(51);class _ extends n.Model{constructor(e){super(e)}initialize(){super.initialize(),this._result=new Map}v_compute(e){let t=this._result.get(e);return(void 0===t||e.changed_for(this))&&(t=this._v_compute(e),this._result.set(e,t)),t}}s.Expression=_,_.__name__="Expression";class o extends n.Model{constructor(e){super(e)}initialize(){super.initialize(),this._result=new Map}compute(e){let t=this._result.get(e);return(void 0===t||e.changed_for(this))&&(t=this._compute(e),this._result.set(e,t)),t}}s.ScalarExpression=o,o.__name__="ScalarExpression"},
function _(e,s,t,n,r){var a;n();const o=e(14),c=e(327),i=e(24),u=e(10),l=e(9),h=e(40),g=e(8);class p extends c.Expression{constructor(e){super(e)}connect_signals(){super.connect_signals();for(const e of(0,l.values)(this.args))e instanceof o.HasProps&&e.change.connect((()=>{this._result.clear(),this.change.emit()}))}get names(){return(0,l.keys)(this.args)}get values(){return(0,l.values)(this.args)}get func(){const e=(0,h.use_strict)(this.code);return new i.GeneratorFunction(...this.names,e)}_v_compute(e){const s=this.func.apply(e,this.values);let t=s.next();if(t.done&&void 0!==t.value){const{value:s}=t;return(0,g.isArray)(s)||(0,g.isTypedArray)(s)?s:(0,g.isIterable)(s)?[...s]:(0,u.repeat)(s,e.length)}{const e=[];do{e.push(t.value),t=s.next()}while(!t.done);return e}}}t.CustomJSExpr=p,a=p,p.__name__="CustomJSExpr",a.define((({Unknown:e,Str:s,Dict:t})=>({args:[t(e),{}],code:[s,""]})))},
function _(t,n,e,s,o){var c;s();const r=t(327),a=t(9);class i extends r.Expression{constructor(t){super(t)}_v_compute(t){const n=t.get_length()??0,e=new Float64Array(n);for(const s of this.fields){const o=(0,a.dict)(t.data).get(s);if(null!=o){const t=Math.min(n,o.length);for(let n=0;n<t;n++)e[n]+=o[n]}}return e}}e.Stack=i,c=i,i.__name__="Stack",c.define((({Str:t,List:n})=>({fields:[n(t),[]]})))},
function _(e,t,n,o,r){var i;o();const s=e(327),u=e(9);class c extends s.Expression{constructor(e){super(e)}_v_compute(e){const t=new Float64Array(e.get_length()??0),n=(0,u.dict)(e.data).get(this.field)??[],o=this.include_zero?1:0;t[0]=this.include_zero?0:n[0];for(let e=1;e<t.length;e++)t[e]=t[e-1]+n[e-o];return t}}n.CumSum=c,i=c,c.__name__="CumSum",i.define((({Bool:e,Str:t})=>({field:[t],include_zero:[e,!1]})))},
function _(i,t,n,e,a){var s;e();const c=i(327),r=i(9),m=i(10);class o extends c.ScalarExpression{constructor(i){super(i)}_compute(i){const t=(0,r.dict)(i.data).get(this.field)??[];return Math.min(this.initial,(0,m.min)(t))}}n.Minimum=o,s=o,o.__name__="Minimum",s.define((({Float:i,Str:t})=>({field:[t],initial:[i,1/0]})))},
function _(t,i,a,e,n){var s;e();const c=t(327),r=t(9),m=t(10);class o extends c.ScalarExpression{constructor(t){super(t)}_compute(t){const i=(0,r.dict)(t.data).get(this.field)??[];return Math.max(this.initial,(0,m.max)(i))}}a.Maximum=o,s=o,o.__name__="Maximum",s.define((({Float:t,Str:i})=>({field:[i],initial:[t,-1/0]})))},
function _(n,e,t,o,r){var s;o();const _=n(327);class m extends _.Expression{constructor(n){super(n)}get x(){return new c({transform:this})}get y(){return new u({transform:this})}}t.CoordinateTransform=m,m.__name__="CoordinateTransform";class a extends _.Expression{constructor(n){super(n)}}t.XYComponent=a,s=a,a.__name__="XYComponent",s.define((({Ref:n})=>({transform:[n(m)]})));class c extends a{constructor(n){super(n)}_v_compute(n){return this.transform.v_compute(n).x}}t.XComponent=c,c.__name__="XComponent";class u extends a{constructor(n){super(n)}_v_compute(n){return this.transform.v_compute(n).y}}t.YComponent=u,u.__name__="YComponent"},
function _(r,t,e,n,o){var i;n();const a=r(1),s=r(333),c=r(20),l=a.__importStar(r(18));class d extends s.CoordinateTransform{constructor(r){super(r)}_v_compute(r){const t=this.properties.radius.uniform(r),e=this.properties.angle.uniform(r),n="anticlock"==this.direction?-1:1,o=Math.min(t.length,e.length),i=new Float64Array(o),a=new Float64Array(o);for(let r=0;r<o;r++){const o=t.get(r),s=e.get(r)*n;i[r]=o*Math.cos(s),a[r]=o*Math.sin(s)}return{x:i,y:a}}}e.PolarTransform=d,i=d,d.__name__="PolarTransform",i.define((({})=>({radius:[l.DistanceSpec,{field:"radius"}],angle:[l.AngleSpec,{field:"angle"}],direction:[c.Direction,"anticlock"]})))},
function _(e,i,r,t,l){t(),l("BooleanFilter",e(336).BooleanFilter),l("CustomJSFilter",e(337).CustomJSFilter),l("Filter",e(234).Filter),l("GroupFilter",e(338).GroupFilter),l("IndexFilter",e(339).IndexFilter),l("AllIndices",e(235).AllIndices),l("InversionFilter",e(340).InversionFilter),l("IntersectionFilter",e(236).IntersectionFilter),l("UnionFilter",e(341).UnionFilter),l("DifferenceFilter",e(342).DifferenceFilter),l("SymmetricDifferenceFilter",e(343).SymmetricDifferenceFilter)},
function _(e,l,n,o,t){var s;o();const a=e(234),r=e(24);class c extends a.Filter{constructor(e){super(e)}compute_indices(e){const l=e.get_length()??1,{booleans:n}=this;return null==n?r.Indices.all_set(l):r.Indices.from_booleans(l,n)}}n.BooleanFilter=c,s=c,c.__name__="BooleanFilter",s.define((({Bool:e,Iterable:l,Nullable:n})=>({booleans:[n(l(e)),null]})))},
function _(e,r,s,t,n){var i;t();const o=e(234),c=e(24),u=e(9),a=e(8),l=e(40);class f extends o.Filter{constructor(e){super(e)}get names(){return(0,u.keys)(this.args)}get values(){return(0,u.values)(this.args)}get func(){const e=(0,l.use_strict)(this.code);return new Function(...this.names,"source",e)}compute_indices(e){const r=e.get_length()??1,s=this.func(...this.values,e);if(null==s)return c.Indices.all_set(r);if((0,a.isArrayOf)(s,a.isInteger))return c.Indices.from_indices(r,s);if((0,a.isArrayOf)(s,a.isBoolean))return c.Indices.from_booleans(r,s);throw new Error(`expect an array of integers or booleans, or null, got ${s}`)}}s.CustomJSFilter=f,i=f,f.__name__="CustomJSFilter",i.define((({Unknown:e,Str:r,Dict:s})=>({args:[s(e),{}],code:[r,""]})))},
function _(e,n,t,o,r){var s;o();const u=e(234),c=e(24),i=e(19);class l extends u.Filter{constructor(e){super(e)}compute_indices(e){const n=e.get_column(this.column_name),t=e.get_length()??1;if(null==n)return i.logger.warn(`${this}: groupby column '${this.column_name}' not found in the data source`),c.Indices.all_set(t);{const e=new c.Indices(t,0);for(let t=0;t<e.size;t++)n[t]===this.group&&e.set(t);return e}}}t.GroupFilter=l,s=l,l.__name__="GroupFilter",s.define((({Str:e})=>({column_name:[e],group:[e]})))},
function _(e,n,t,i,l){var s;i();const c=e(234),r=e(24);class d extends c.Filter{constructor(e){super(e)}compute_indices(e){const n=e.get_length()??1,{indices:t}=this;return null==t?r.Indices.all_set(n):r.Indices.from_indices(n,t)}}t.IndexFilter=d,s=d,d.__name__="IndexFilter",s.define((({Int:e,Iterable:n,Nullable:t})=>({indices:[t(n(e)),null]})))},
function _(e,n,t,s,o){var i;s();const r=e(234);class c extends r.Filter{constructor(e){super(e)}connect_signals(){super.connect_signals();const e=()=>{this.change.emit()},n=n=>{for(const t of n)this.connect(t.change,e)},t=n=>{for(const t of n)this.disconnect(t.change,e)};let s=(()=>{const{operand:e}=this.properties;return e.is_unset?[]:[e.get_value()]})();n(s),this.on_change(this.properties.operand,(()=>{t(s),s=[this.operand],n(s)}))}compute_indices(e){const n=this.operand.compute_indices(e);return n.invert(),n}}t.InversionFilter=c,i=c,c.__name__="InversionFilter",i.define((({Ref:e})=>({operand:[e(r.Filter)]})))},
function _(n,e,o,t,i){t();const s=n(237);class _ extends s.CompositeFilter{constructor(n){super(n)}_inplace_op(n,e){n.add(e)}}o.UnionFilter=_,_.__name__="UnionFilter"},
function _(e,t,c,n,r){n();const i=e(237);class s extends i.CompositeFilter{constructor(e){super(e)}_inplace_op(e,t){e.subtract(t)}}c.DifferenceFilter=s,s.__name__="DifferenceFilter"},
function _(e,t,c,r,i){r();const n=e(237);class s extends n.CompositeFilter{constructor(e){super(e)}_inplace_op(e,t){e.symmetric_subtract(t)}}c.SymmetricDifferenceFilter=s,s.__name__="SymmetricDifferenceFilter"},
function _(e,a,t,l,r){l(),r("AnnularWedge",e(345).AnnularWedge),r("Annulus",e(346).Annulus),r("Arc",e(347).Arc),r("Bezier",e(348).Bezier),r("Block",e(350).Block),r("Circle",e(352).Circle),r("Ellipse",e(353).Ellipse),r("Glyph",e(218).Glyph),r("HArea",e(230).HArea),r("HAreaStep",e(227).HAreaStep),r("HBar",e(355).HBar),r("HexTile",e(356).HexTile),r("HSpan",e(357).HSpan),r("HStrip",e(358).HStrip),r("Image",e(359).Image),r("ImageRGBA",e(361).ImageRGBA),r("ImageStack",e(362).ImageStack),r("ImageURL",e(363).ImageURL),r("Line",e(216).Line),r("MathMLGlyph",e(364).MathMLGlyph),r("MultiLine",e(367).MultiLine),r("MultiPolygons",e(368).MultiPolygons),r("Patch",e(226).Patch),r("Patches",e(369).Patches),r("Quad",e(370).Quad),r("Quadratic",e(371).Quadratic),r("Ray",e(372).Ray),r("Rect",e(373).Rect),r("Scatter",e(374).Scatter),r("Segment",e(377).Segment),r("Spline",e(378).Spline),r("Step",e(380).Step),r("TeXGlyph",e(381).TeXGlyph),r("Text",e(366).Text),r("VArea",e(232).VArea),r("VAreaStep",e(231).VAreaStep),r("VBar",e(382).VBar),r("VSpan",e(383).VSpan),r("VStrip",e(384).VStrip),r("Wedge",e(385).Wedge)},
function _(e,t,i,s,r){var n;s();const a=e(1),_=e(217),h=e(218),d=e(224),o=e(85),u=e(24),l=e(20),c=a.__importStar(e(18)),g=e(11),p=e(127),x=e(13);class m extends _.XYGlyphView{async load_glglyph(){const{AnnularWedgeGL:t}=await Promise.resolve().then((()=>a.__importStar(e(546))));return t}_map_data(){this._define_or_inherit_attr("sinner_radius",(()=>"data"==this.model.properties.inner_radius.units?this.inherited_x&&this.inherited_inner_radius?h.inherit:this.sdist(this.renderer.xscale,this.x,this.inner_radius):this.inherited_inner_radius?h.inherit:(0,u.to_screen)(this.inner_radius))),this._define_or_inherit_attr("souter_radius",(()=>"data"==this.model.properties.outer_radius.units?this.inherited_x&&this.inherited_outer_radius?h.inherit:this.sdist(this.renderer.xscale,this.x,this.outer_radius):this.inherited_outer_radius?h.inherit:(0,u.to_screen)(this.outer_radius))),this._define_or_inherit_attr("max_souter_radius",(()=>(0,x.max)(this.souter_radius)))}_render(e,t,i){const{sx:s,sy:r,start_angle:n,end_angle:a,sinner_radius:_,souter_radius:h}={...this,...i},d="anticlock"==this.model.direction;for(const i of t){const t=s[i],o=r[i],u=_[i],l=h[i],c=n.get(i),g=a.get(i);if(!isFinite(t+o+u+l+c+g))continue;const p=g-c;e.translate(t,o),e.rotate(c),e.beginPath(),e.moveTo(l,0),e.arc(0,0,l,0,p,d),e.rotate(p),e.lineTo(u,0),e.arc(0,0,u,0,-p,!d),e.closePath(),e.rotate(-p-c),e.translate(-t,-o),this.visuals.fill.apply(e,i),this.visuals.hatch.apply(e,i),this.visuals.line.apply(e,i)}}_hit_point(e){const{sx:t,sy:i}=e,s=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(i),n=t-this.max_souter_radius,a=t+this.max_souter_radius,[_,h]=this.renderer.xscale.r_invert(n,a),d=i-this.max_souter_radius,o=i+this.max_souter_radius,[u,l]=this.renderer.yscale.r_invert(d,o),c=[];for(const e of this.index.indices({x0:_,x1:h,y0:u,y1:l})){const t=this.souter_radius[e]**2,i=this.sinner_radius[e]**2,[n,a]=this.renderer.xscale.r_compute(s,this.x[e]),[_,h]=this.renderer.yscale.r_compute(r,this.y[e]),d=(n-a)**2+(_-h)**2;d<=t&&d>=i&&c.push(e)}const x="anticlock"==this.model.direction,m=[];for(const e of c){const s=Math.atan2(i-this.sy[e],t-this.sx[e]);(Math.abs(this.start_angle.get(e)-this.end_angle.get(e))>=2*Math.PI||(0,g.angle_between)(-s,-this.start_angle.get(e),-this.end_angle.get(e),x))&&m.push(e)}return new p.Selection({indices:m})}draw_legend_for_index(e,t,i){(0,d.generic_area_vector_legend)(this.visuals,e,t,i)}scenterxy(e){const t=(this.sinner_radius[e]+this.souter_radius[e])/2,i=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+t*Math.cos(i),this.sy[e]+t*Math.sin(i)]}}i.AnnularWedgeView=m,m.__name__="AnnularWedgeView";class f extends _.XYGlyph{constructor(e){super(e)}}i.AnnularWedge=f,n=f,f.__name__="AnnularWedge",n.prototype.default_view=m,n.mixins([o.LineVector,o.FillVector,o.HatchVector]),n.define((({})=>({direction:[l.Direction,"anticlock"],inner_radius:[c.DistanceSpec,{field:"inner_radius"}],outer_radius:[c.DistanceSpec,{field:"outer_radius"}],start_angle:[c.AngleSpec,{field:"start_angle"}],end_angle:[c.AngleSpec,{field:"end_angle"}]})))},
function _(i,e,s,r,t){var n;r();const a=i(1),_=i(217),u=i(218),h=i(24),d=i(85),o=a.__importStar(i(18)),c=i(127);class l extends _.XYGlyphView{async load_glglyph(){const{AnnulusGL:e}=await Promise.resolve().then((()=>a.__importStar(i(553))));return e}_map_data(){this._define_or_inherit_attr("sinner_radius",(()=>"data"==this.model.properties.inner_radius.units?this.inherited_x&&this.inherited_inner_radius?u.inherit:this.sdist(this.renderer.xscale,this.x,this.inner_radius):this.inherited_inner_radius?u.inherit:(0,h.to_screen)(this.inner_radius))),this._define_or_inherit_attr("souter_radius",(()=>"data"==this.model.properties.outer_radius.units?this.inherited_x&&this.inherited_outer_radius?u.inherit:this.sdist(this.renderer.xscale,this.x,this.outer_radius):this.inherited_outer_radius?u.inherit:(0,h.to_screen)(this.outer_radius)))}_render(i,e,s){const{sx:r,sy:t,sinner_radius:n,souter_radius:a}={...this,...s};for(const s of e){const e=r[s],_=t[s],u=n[s],h=a[s];isFinite(e+_+u+h)&&(i.beginPath(),i.arc(e,_,u,0,2*Math.PI,!0),i.moveTo(e+h,_),i.arc(e,_,h,2*Math.PI,0,!1),this.visuals.fill.apply(i,s),this.visuals.hatch.apply(i,s),this.visuals.line.apply(i,s))}}_hit_point(i){const{sx:e,sy:s}=i,r=this.renderer.xscale.invert(e),t=this.renderer.yscale.invert(s);let n,a,_,u;if("data"==this.model.properties.outer_radius.units)n=r-this.max_outer_radius,_=r+this.max_outer_radius,a=t-this.max_outer_radius,u=t+this.max_outer_radius;else{const i=e-this.max_outer_radius,r=e+this.max_outer_radius;[n,_]=this.renderer.xscale.r_invert(i,r);const t=s-this.max_outer_radius,h=s+this.max_outer_radius;[a,u]=this.renderer.yscale.r_invert(t,h)}const h=[];for(const i of this.index.indices({x0:n,x1:_,y0:a,y1:u})){const e=this.souter_radius[i]**2,s=this.sinner_radius[i]**2,[n,a]=this.renderer.xscale.r_compute(r,this.x[i]),[_,u]=this.renderer.yscale.r_compute(t,this.y[i]),d=(n-a)**2+(_-u)**2;d<=e&&d>=s&&h.push(i)}return new c.Selection({indices:h})}draw_legend_for_index(i,{x0:e,y0:s,x1:r,y1:t},n){const a=n+1,_=new Array(a);_[n]=(e+r)/2;const u=new Array(a);u[n]=(s+t)/2;const h=.5*Math.min(Math.abs(r-e),Math.abs(t-s)),d=new Array(a);d[n]=.4*h;const o=new Array(a);o[n]=.8*h,this._render(i,[n],{sx:_,sy:u,sinner_radius:d,souter_radius:o})}}s.AnnulusView=l,l.__name__="AnnulusView";class x extends _.XYGlyph{constructor(i){super(i)}}s.Annulus=x,n=x,x.__name__="Annulus",n.prototype.default_view=l,n.mixins([d.LineVector,d.FillVector,d.HatchVector]),n.define((({})=>({inner_radius:[o.DistanceSpec,{field:"inner_radius"}],outer_radius:[o.DistanceSpec,{field:"outer_radius"}]})))},
function _(e,i,t,s,n){var r;s();const a=e(1),d=e(217),o=e(218),c=e(224),_=e(85),l=e(24),h=e(20),u=a.__importStar(e(18));class f extends d.XYGlyphView{_map_data(){this._define_or_inherit_attr("sradius",(()=>"data"==this.model.properties.radius.units?this.inherited_x&&this.inherited_radius?o.inherit:this.sdist(this.renderer.xscale,this.x,this.radius):this.inherited_radius?o.inherit:(0,l.to_screen)(this.radius)))}_render(e,i,t){if(!this.visuals.line.doit)return;const{sx:s,sy:n,sradius:r,start_angle:a,end_angle:d}={...this,...t},o="anticlock"==this.model.direction;for(const t of i){const i=s[t],c=n[t],_=r[t],l=a.get(t),h=d.get(t);isFinite(i+c+_+l+h)&&(this._render_decorations(e,t,i,c,_,l,h,o),e.beginPath(),e.arc(i,c,_,l,h,o),this.visuals.line.apply(e,t))}}_render_decorations(e,i,t,s,n,r,a,d){const{sin:o,cos:c,PI:_}=Math;for(const d of this.decorations.values()){if(e.save(),"start"==d.model.node){const i=n*c(r)+t,a=n*o(r)+s;e.translate(i,a),e.rotate(r+_)}else if("end"==d.model.node){const i=n*Math.cos(a)+t,r=n*Math.sin(a)+s;e.translate(i,r),e.rotate(a)}d.marking.render(e,i),e.restore()}}draw_legend_for_index(e,i,t){(0,c.generic_line_vector_legend)(this.visuals,e,i,t)}}t.ArcView=f,f.__name__="ArcView";class g extends d.XYGlyph{constructor(e){super(e)}}t.Arc=g,r=g,g.__name__="Arc",r.prototype.default_view=f,r.mixins(_.LineVector),r.define((({})=>({direction:[h.Direction,"anticlock"],radius:[u.DistanceSpec,{field:"radius"}],start_angle:[u.AngleSpec,{field:"start_angle"}],end_angle:[u.AngleSpec,{field:"end_angle"}]})))},
function _(e,i,t,c,s){var n;c();const o=e(1),r=e(85),d=e(218),a=e(224),x=e(131),y=e(349),_=o.__importStar(e(18));class l extends d.GlyphView{_project_data(){x.inplace.project_xy(this.x0,this.y0),x.inplace.project_xy(this.x1,this.y1)}_index_data(e){const{data_size:i,x0:t,y0:c,x1:s,y1:n,cx0:o,cy0:r,cx1:d,cy1:a}=this;for(let x=0;x<i;x++){const i=t[x],_=c[x],l=s[x],p=n[x],f=o[x],h=r[x],u=d[x],C=a[x];if(isFinite(i+l+_+p+f+h+u+C)){const{x0:t,y0:c,x1:s,y1:n}=(0,y.cbb)(i,_,f,h,u,C,l,p);e.add_rect(t,c,s,n)}else e.add_empty()}}_render(e,i,t){if(!this.visuals.line.doit)return;const{sx0:c,sy0:s,sx1:n,sy1:o,scx0:r,scy0:d,scx1:a,scy1:x}={...this,...t};for(const t of i){const i=c[t],y=s[t],_=n[t],l=o[t],p=r[t],f=d[t],h=a[t],u=x[t];isFinite(i+y+_+l+p+f+h+u)&&(e.beginPath(),e.moveTo(i,y),e.bezierCurveTo(p,f,h,u,_,l),this.visuals.line.apply(e,t))}}draw_legend_for_index(e,i,t){(0,a.generic_line_vector_legend)(this.visuals,e,i,t)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}t.BezierView=l,l.__name__="BezierView";class p extends d.Glyph{constructor(e){super(e)}}t.Bezier=p,n=p,p.__name__="Bezier",n.prototype.default_view=l,n.define((({})=>({x0:[_.XCoordinateSpec,{field:"x0"}],y0:[_.YCoordinateSpec,{field:"y0"}],x1:[_.XCoordinateSpec,{field:"x1"}],y1:[_.YCoordinateSpec,{field:"y1"}],cx0:[_.XCoordinateSpec,{field:"cx0"}],cy0:[_.YCoordinateSpec,{field:"cy0"}],cx1:[_.XCoordinateSpec,{field:"cx1"}],cy1:[_.YCoordinateSpec,{field:"cy1"}]}))),n.mixins(r.LineVector)},
function _(n,t,o,c,s){c();const r=n(13),{abs:u,sqrt:e,min:i,max:f}=Math;o.qbb=function(n,t,o,c,s,r){function u(n,t,o){if(t==(n+o)/2)return[n,o];{const c=(n-t)/(n-2*t+o),s=n*(1-c)**2+2*t*(1-c)*c+o*c**2;return[i(n,o,s),f(n,o,s)]}}const[e,a]=u(n,o,s),[x,y]=u(t,c,r);return{x0:e,x1:a,y0:x,y1:y}},o.cbb=function(n,t,o,c,s,i,f,a){const x=f,y=a;f=o,a=c;const b=s,h=i,l=[];for(let o=0;o<=2;o++){let c,s,r;if(0==o?(s=6*n-12*f+6*b,c=-3*n+9*f-9*b+3*x,r=3*f-3*n):(s=6*t-12*a+6*h,c=-3*t+9*a-9*h+3*y,r=3*a-3*t),u(c)<1e-12){if(u(s)<1e-12)continue;const n=-r/s;0<n&&n<1&&l.push(n);continue}const i=s**2-4*r*c,m=e(i);if(i<0)continue;const p=(-s+m)/(2*c);0<p&&p<1&&l.push(p);const q=(-s-m)/(2*c);0<q&&q<1&&l.push(q)}const m=l.length;let p=m;const q=Array(m+2),A=Array(m+2);for(;p-- >0;){const o=l[p],c=1-o,s=c**3*n+3*c**2*o*f+3*c*o**2*b+o**3*x,r=c**3*t+3*c**2*o*a+3*c*o**2*h+o**3*y;q[p]=s,A[p]=r}q[m]=n,A[m]=t,q[m+1]=x,A[m+1]=y;const[g,M,_,d]=(0,r.minmax2)(q,A);return{x0:g,x1:M,y0:_,y1:d}}},
function _(t,e,i,s,r){var h;s();const n=t(1),_=t(351),a=t(11),o=t(24),c=n.__importStar(t(18));class d extends _.LRTBView{scenterxy(t){return[this.sleft[t]/2+this.sright[t]/2,this.stop[t]/2+this.sbottom[t]/2]}_lrtb(t){const e=this.x[t],i=this.y[t],s=this.width.get(t),r=this.height.get(t),[h,n]=(0,a.minmax)(e,e+s),[_,o]=(0,a.minmax)(i,i+r);return{l:h,r:n,t:o,b:_}}_map_data(){const{sx:t,sy:e}=this,i=t.length;if(this.inherited_x&&this.inherited_width)this._inherit_attr("sleft"),this._inherit_attr("sright");else{const e=this.sdist(this.renderer.xscale,this.x,this.width,"edge"),s=new o.ScreenArray(i),r=new o.ScreenArray(i);for(let h=0;h<i;h++)s[h]=t[h],r[h]=t[h]+e[h];this._define_attr("sleft",s),this._define_attr("sright",r)}if(this.inherited_y&&this.inherited_height)this._inherit_attr("stop"),this._inherit_attr("sbottom");else{const t=this.sdist(this.renderer.yscale,this.y,this.height,"edge"),s=new o.ScreenArray(i),r=new o.ScreenArray(i);for(let h=0;h<i;h++)s[h]=e[h]-t[h],r[h]=e[h];this._define_attr("stop",s),this._define_attr("sbottom",r)}this._clamp_to_viewport()}}i.BlockView=d,d.__name__="BlockView";class l extends _.LRTB{constructor(t){super(t)}}i.Block=l,h=l,l.__name__="Block",h.prototype.default_view=d,h.define((({})=>({x:[c.XCoordinateSpec,{field:"x"}],y:[c.YCoordinateSpec,{field:"y"}],width:[c.DistanceSpec,{value:1}],height:[c.DistanceSpec,{value:1}]})))},
function _(t,e,r,s,i){var n;s();const a=t(1),o=t(85),_=t(218),c=t(224),h=t(127),d=t(64),l=t(13),p=t(182),x=a.__importStar(t(183)),m=t(184);class u extends _.GlyphView{async load_glglyph(){const{LRTBGL:e}=await Promise.resolve().then((()=>a.__importStar(t(560))));return e}get_anchor_point(t,e,r){const s=Math.min(this.sleft[e],this.sright[e]),i=Math.max(this.sright[e],this.sleft[e]),n=Math.min(this.stop[e],this.sbottom[e]),a=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:s,y:n};case"top":case"top_center":return{x:(s+i)/2,y:n};case"top_right":return{x:i,y:n};case"bottom_left":return{x:s,y:a};case"bottom":case"bottom_center":return{x:(s+i)/2,y:a};case"bottom_right":return{x:i,y:a};case"left":case"center_left":return{x:s,y:(n+a)/2};case"center":case"center_center":return{x:(s+i)/2,y:(n+a)/2};case"right":case"center_right":return{x:i,y:(n+a)/2}}}_set_data(t){super._set_data(t),this.border_radius=x.border_radius(this.model.border_radius)}_index_data(t){const{min:e,max:r}=Math,{data_size:s}=this;for(let i=0;i<s;i++){const{l:s,r:n,t:a,b:o}=this._lrtb(i);t.add_rect(e(s,n),e(a,o),r(n,s),r(a,o))}}_render(t,e,r){const{sleft:s,sright:i,stop:n,sbottom:a,border_radius:o}={...this,...r};for(const r of e){const e=s[r],_=n[r],c=i[r],h=a[r];if(!isFinite(e+_+c+h))continue;t.beginPath();const l=d.BBox.from_lrtb({left:e,right:c,top:_,bottom:h});(0,m.round_rect)(t,l,o),this.visuals.fill.apply(t,r),this.visuals.hatch.apply(t,r),this.visuals.line.apply(t,r)}}_clamp_to_viewport(){const{min:t,max:e}=Math,{h_range:r,v_range:s}=this.renderer.plot_view.frame.bbox;this.inherited_sleft||(0,l.inplace_map)(this.sleft,(t=>e(t,r.start))),this.inherited_sright||(0,l.inplace_map)(this.sright,(e=>t(e,r.end))),this.inherited_stop||(0,l.inplace_map)(this.stop,(t=>e(t,s.start))),this.inherited_sbottom||(0,l.inplace_map)(this.sbottom,(e=>t(e,s.end)))}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){const{sx:e,sy:r}=t,s=this.renderer.xscale.invert(e),i=this.renderer.yscale.invert(r),n=[...this.index.indices({x0:s,y0:i,x1:s,y1:i})];return new h.Selection({indices:n})}_hit_span(t){const{sx:e,sy:r}=t;let s;if("v"==t.direction){const t=this.renderer.yscale.invert(r),e=this.renderer.plot_view.frame.bbox.h_range,[i,n]=this.renderer.xscale.r_invert(e.start,e.end);s=[...this.index.indices({x0:i,y0:t,x1:n,y1:t})]}else{const t=this.renderer.xscale.invert(e),r=this.renderer.plot_view.frame.bbox.v_range,[i,n]=this.renderer.yscale.r_invert(r.start,r.end);s=[...this.index.indices({x0:t,y0:i,x1:t,y1:n})]}return new h.Selection({indices:s})}draw_legend_for_index(t,e,r){(0,c.generic_area_vector_legend)(this.visuals,t,e,r)}}r.LRTBView=u,u.__name__="LRTBView";class y extends _.Glyph{constructor(t){super(t)}}r.LRTB=y,n=y,y.__name__="LRTB",n.mixins([o.LineVector,o.FillVector,o.HatchVector]),n.define((()=>({border_radius:[p.BorderRadius,0]})))},
function _(e,i,s,t,r){var n;t();const a=e(1),d=e(217),h=e(218),c=e(85),o=e(24),_=e(20),l=a.__importStar(e(225)),u=a.__importStar(e(18)),x=e(10),y=e(13),p=e(127);class m extends d.XYGlyphView{async load_glglyph(){const{CircleGL:i}=await Promise.resolve().then((()=>a.__importStar(e(555))));return i}_index_data(e){const{x:i,y:s,radius:t,data_size:r}=this;for(let n=0;n<r;n++){const r=i[n],a=s[n],d=t.get(n);e.add_rect(r-d,a-d,r+d,a+d)}}_map_data(){this._define_or_inherit_attr("sradius",(()=>{if("data"!=this.model.properties.radius.units)return this.inherited_sradius?h.inherit:(0,o.to_screen)(this.radius);{const e=()=>this.sdist(this.renderer.xscale,this.x,this.radius),i=()=>this.sdist(this.renderer.yscale,this.y,this.radius),{radius_dimension:s}=this.model;switch(s){case"x":return this.inherited_x&&this.inherited_radius?h.inherit:e();case"y":return this.inherited_y&&this.inherited_radius?h.inherit:i();case"min":case"max":return this.inherited_x&&this.inherited_y&&this.inherited_radius?h.inherit:(0,x.elementwise)(e(),i(),Math[s])}}}))}_mask_data(){const{frame:e}=this.renderer.plot_view,i=e.x_target,s=e.y_target;let t,r;return"data"==this.model.properties.radius.units?(t=i.map((e=>this.renderer.xscale.invert(e))).widen(this.max_radius),r=s.map((e=>this.renderer.yscale.invert(e))).widen(this.max_radius)):(t=i.widen(this.max_radius).map((e=>this.renderer.xscale.invert(e))),r=s.widen(this.max_radius).map((e=>this.renderer.yscale.invert(e)))),this.index.indices({x0:t.start,x1:t.end,y0:r.start,y1:r.end})}_render(e,i,s){const{sx:t,sy:r,sradius:n}={...this,...s};for(const s of i){const i=t[s],a=r[s],d=n[s];isFinite(i+a+d)&&(e.beginPath(),e.arc(i,a,d,0,2*Math.PI,!1),this.visuals.fill.apply(e,s),this.visuals.hatch.apply(e,s),this.visuals.line.apply(e,s))}}_hit_point(e){const{sx:i,sy:s}=e,t=this.renderer.xscale.invert(i),r=this.renderer.yscale.invert(s),{hit_dilation:n}=this.model,[a,d,h,c]=(()=>{if("data"==this.model.properties.radius.units){const e=this.max_radius*n;return[t-e,t+e,r-e,r+e]}{const e=this.max_radius*n,t=i-e,r=i+e,a=s-e,d=s+e,[h,c]=this.renderer.xscale.r_invert(t,r),[o,_]=this.renderer.yscale.r_invert(a,d);return[h,c,o,_]}})(),o=this.index.indices({x0:a,x1:d,y0:h,y1:c}),_=[];if("data"==this.model.properties.radius.units)for(const e of o){const i=(this.sradius[e]*n)**2,[s,a]=this.renderer.xscale.r_compute(t,this.x[e]),[d,h]=this.renderer.yscale.r_compute(r,this.y[e]);(s-a)**2+(d-h)**2<=i&&_.push(e)}else for(const e of o){const t=(this.sradius[e]*n)**2;(this.sx[e]-i)**2+(this.sy[e]-s)**2<=t&&_.push(e)}return new p.Selection({indices:_})}_hit_span(e){const{sx:i,sy:s}=e,t=this.bounds(),[r,n,a,d]=(()=>{const r=this.max_radius;if("h"==e.direction){const e=i-r,s=i+r,[n,a]=this.renderer.xscale.r_invert(e,s),{y0:d,y1:h}=t;return[n,a,d,h]}{const e=s-r,i=s+r,{x0:n,x1:a}=t,[d,h]=this.renderer.yscale.r_invert(e,i);return[n,a,d,h]}})(),h=[...this.index.indices({x0:r,x1:n,y0:a,y1:d})];return new p.Selection({indices:h})}_hit_rect(e){const{sx0:i,sx1:s,sy0:t,sy1:r}=e,[n,a]=this.renderer.xscale.r_invert(i,s),[d,h]=this.renderer.yscale.r_invert(t,r),c=this.index.indices({x0:n,x1:a,y0:d,y1:h}),o=[];for(const e of c){const n=this.sx[e],a=this.sy[e];i<=n&&n<=s&&t<=a&&a<=r&&o.push(e)}return new p.Selection({indices:o})}_hit_poly(e){const{sx:i,sy:s}=e,t=(()=>{const[e,t,r,n]=(0,y.minmax2)(i,s),[a,d]=this.renderer.xscale.r_invert(e,t),[h,c]=this.renderer.yscale.r_invert(r,n);return this.index.indices({x0:a,x1:d,y0:h,y1:c})})(),r=[];for(const e of t)l.point_in_poly(this.sx[e],this.sy[e],i,s)&&r.push(e);return new p.Selection({indices:r})}draw_legend_for_index(e,{x0:i,y0:s,x1:t,y1:r},n){const a=n+1,d=new Array(a);d[n]=(i+t)/2;const h=new Array(a);h[n]=(s+r)/2;const c=new Array(a);c[n]=.2*Math.min(Math.abs(t-i),Math.abs(r-s)),this._render(e,[n],{sx:d,sy:h,sradius:c})}}s.CircleView=m,m.__name__="CircleView";class f extends d.XYGlyph{constructor(e){super(e)}}s.Circle=f,n=f,f.__name__="Circle",n.prototype.default_view=m,n.mixins([c.LineVector,c.FillVector,c.HatchVector]),n.define((({Float:e})=>({radius:[u.DistanceSpec,{field:"radius"}],radius_dimension:[_.RadiusDimension,"x"],hit_dilation:[e,1]})))},
function _(t,i,e,s,h){var r;s();const n=t(1),a=t(354),d=t(218),_=n.__importStar(t(225)),l=t(24),o=t(127),c=n.__importStar(t(18));class p extends a.CenterRotatableView{_map_data(){this._define_or_inherit_attr("swidth",(()=>"data"==this.model.properties.width.units?this.inherited_x&&this.inherited_width?d.inherit:this.sdist(this.renderer.xscale,this.x,this.width,"center"):this.inherited_width?d.inherit:(0,l.to_screen)(this.width))),this._define_or_inherit_attr("sheight",(()=>"data"==this.model.properties.height.units?this.inherited_y&&this.inherited_height?d.inherit:this.sdist(this.renderer.yscale,this.y,this.height,"center"):this.inherited_height?d.inherit:(0,l.to_screen)(this.height)))}_render(t,i,e){const{sx:s,sy:h,swidth:r,sheight:n,angle:a}={...this,...e};for(const e of i){const i=s[e],d=h[e],_=r[e],l=n[e],o=a.get(e);isFinite(i+d+_+l+o)&&(t.beginPath(),t.ellipse(i,d,_/2,l/2,o,0,2*Math.PI),this.visuals.fill.apply(t,e),this.visuals.hatch.apply(t,e),this.visuals.line.apply(t,e))}}_hit_point(t){let i,e,s,h,r,n,a,d,l;const{sx:c,sy:p}=t,w=this.renderer.xscale.invert(c),x=this.renderer.yscale.invert(p);"data"==this.model.properties.width.units?(i=w-this.max_width,e=w+this.max_width):(n=c-this.max_width,a=c+this.max_width,[i,e]=this.renderer.xscale.r_invert(n,a)),"data"==this.model.properties.height.units?(s=x-this.max_height,h=x+this.max_height):(d=p-this.max_height,l=p+this.max_height,[s,h]=this.renderer.yscale.r_invert(d,l));const g=this.index.indices({x0:i,x1:e,y0:s,y1:h}),y=[];for(const t of g)r=_.point_in_ellipse(c,p,this.angle.get(t),this.sheight[t]/2,this.swidth[t]/2,this.sx[t],this.sy[t]),r&&y.push(t);return new o.Selection({indices:y})}draw_legend_for_index(t,{x0:i,y0:e,x1:s,y1:h},r){const n=r+1,a=new Array(n);a[r]=(i+s)/2;const d=new Array(n);d[r]=(e+h)/2;const _=this.swidth[r]/this.sheight[r],l=.8*Math.min(Math.abs(s-i),Math.abs(h-e)),o=new Array(n),p=new Array(n);_>1?(o[r]=l,p[r]=l/_):(o[r]=l*_,p[r]=l);const w=new c.UniformScalar(0,n);this._render(t,[r],{sx:a,sy:d,swidth:o,sheight:p,angle:w})}}e.EllipseView=p,p.__name__="EllipseView";class w extends a.CenterRotatable{constructor(t){super(t)}}e.Ellipse=w,r=w,w.__name__="Ellipse",r.prototype.default_view=p},
function _(e,t,i,a,n){var r;a();const s=e(1),h=e(217),o=e(85),_=s.__importStar(e(18));class c extends h.XYGlyphView{get max_w2(){return"data"==this.model.properties.width.units?this.max_width/2:0}get max_h2(){return"data"==this.model.properties.height.units?this.max_height/2:0}_bounds({x0:e,x1:t,y0:i,y1:a}){const{max_w2:n,max_h2:r}=this;return{x0:e-n,x1:t+n,y0:i-r,y1:a+r}}}i.CenterRotatableView=c,c.__name__="CenterRotatableView";class l extends h.XYGlyph{constructor(e){super(e)}}i.CenterRotatable=l,r=l,l.__name__="CenterRotatable",r.mixins([o.LineVector,o.FillVector,o.HatchVector]),r.define((({})=>({angle:[_.AngleSpec,0],width:[_.DistanceSpec,{field:"width"}],height:[_.DistanceSpec,{field:"height"}]})))},
function _(t,e,i,s,r){var h;s();const n=t(1),a=t(351),_=t(24),o=n.__importStar(t(18));class c extends a.LRTBView{scenterxy(t){return[(this.sleft[t]+this.sright[t])/2,this.sy[t]]}_lrtb(t){const e=this.left[t],i=this.right[t],s=this.y[t],r=this.height.get(t)/2;return{l:Math.min(e,i),r:Math.max(e,i),t:s+r,b:s-r}}_map_data(){if(this.inherited_y&&this.inherited_height)this._inherit_attr("sheight"),this._inherit_attr("stop"),this._inherit_attr("sbottom");else{const t=this.sdist(this.renderer.yscale,this.y,this.height,"center"),{sy:e}=this,i=this.sy.length,s=new _.ScreenArray(i),r=new _.ScreenArray(i);for(let h=0;h<i;h++){const i=e[h],n=t[h];s[h]=i-n/2,r[h]=i+n/2}this._define_attr("sheight",t),this._define_attr("stop",s),this._define_attr("sbottom",r)}this._clamp_to_viewport()}}i.HBarView=c,c.__name__="HBarView";class d extends a.LRTB{constructor(t){super(t)}}i.HBar=d,h=d,d.__name__="HBar",h.prototype.default_view=c,h.define((({})=>({left:[o.XCoordinateSpec,{value:0}],y:[o.YCoordinateSpec,{field:"y"}],height:[o.DistanceSpec,{value:1}],right:[o.XCoordinateSpec,{field:"right"}]})))},
function _(e,t,s,i,r){var n;i();const a=e(1),o=e(218),c=a.__importStar(e(225)),l=a.__importStar(e(18)),_=e(85),h=e(20),d=e(131),p=e(224),x=e(127);class y extends o.GlyphView{async load_glglyph(){const{HexTileGL:t}=await Promise.resolve().then((()=>a.__importStar(e(556))));return t}scenterxy(e){return[this.sx[e],this.sy[e]]}_set_data(){const{orientation:e,size:t,aspect_scale:s}=this.model,{q:i,r}=this,n=this.q.length,a=new Float64Array(n),o=new Float64Array(n),c=Math.sqrt(3);if("pointytop"==e)for(let e=0;e<n;e++){const n=i.get(e),l=r.get(e)/2;a[e]=t*c*(n+l)/s,o[e]=-3*t*l}else for(let e=0;e<n;e++){const n=i.get(e)/2,l=r.get(e);a[e]=3*t*n,o[e]=-t*c*(l+n)*s}this._define_attr("x",a),this._define_attr("y",o)}_project_data(){d.inplace.project_xy(this.x,this.y)}_index_data(e){let t=this.model.size,s=Math.sqrt(3)*t/2;"flattop"==this.model.orientation?([s,t]=[t,s],t*=this.model.aspect_scale):s/=this.model.aspect_scale;const{x:i,y:r,data_size:n}=this;for(let a=0;a<n;a++){const n=i[a],o=r[a];e.add_rect(n-s,o-t,n+s,o+t)}}map_data(){const[e,t]=this.renderer.coordinates.map_to_screen(this.x,this.y),[s,i]=this._get_unscaled_vertices();this._define_attr("sx",e),this._define_attr("sy",t),this._define_attr("svx",s),this._define_attr("svy",i),this.glglyph?.set_data_mapped()}_get_unscaled_vertices(){const e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){const s=this.renderer.yscale,i=this.renderer.xscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t,a=r/2;return[[0,-n,-n,0,n,n],[r,a,-a,-r,-a,a]]}{const s=this.renderer.xscale,i=this.renderer.yscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t,a=r/2;return[[r,a,-a,-r,-a,a],[0,-n,-n,0,n,n]]}}_render(e,t,s){const{sx:i,sy:r,svx:n,svy:a,scale:o}={...this,...s};for(const s of t){const t=i[s],c=r[s],l=o.get(s);if(isFinite(t+c+l)){e.translate(t,c),e.beginPath();for(let t=0;t<6;t++)e.lineTo(n[t]*l,a[t]*l);e.closePath(),e.translate(-t,-c),this.visuals.fill.apply(e,s),this.visuals.hatch.apply(e,s),this.visuals.line.apply(e,s)}}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s),n=this.index.indices({x0:i,y0:r,x1:i,y1:r}),a=[];for(const e of n)c.point_in_poly(t-this.sx[e],s-this.sy[e],this.svx,this.svy)&&a.push(e);return new x.Selection({indices:a})}_hit_span(e){const t=(()=>{if("v"==e.direction){const{sy:t}=e,s=this.renderer.yscale.invert(t),i=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(i.start,i.end);return{x0:r,y0:s,x1:n,y1:s}}{const{sx:t}=e,s=this.renderer.xscale.invert(t),i=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(i.start,i.end);return{x0:s,y0:r,x1:s,y1:n}}})(),s=[...this.index.indices(t)];return new x.Selection({indices:s})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:r}=e,[n,a]=this.renderer.xscale.r_invert(t,s),[o,c]=this.renderer.yscale.r_invert(i,r),l=[...this.index.indices({x0:n,x1:a,y0:o,y1:c})];return new x.Selection({indices:l})}draw_legend_for_index(e,t,s){(0,p.generic_area_vector_legend)(this.visuals,e,t,s)}}s.HexTileView=y,y.__name__="HexTileView";class u extends o.Glyph{constructor(e){super(e)}}s.HexTile=u,n=u,u.__name__="HexTile",n.prototype.default_view=y,n.mixins([_.LineVector,_.FillVector,_.HatchVector]),n.define((({Float:e})=>({r:[l.NumberSpec,{field:"r"}],q:[l.NumberSpec,{field:"q"}],scale:[l.NumberSpec,1],size:[e,1],aspect_scale:[e,1],orientation:[h.HexTileOrientation,"pointytop"]}))),n.override({line_color:null})},
function _(t,e,i,n,s){var r;n();const _=t(1),a=t(218),o=t(224),d=t(127),c=t(85),h=_.__importStar(t(39)),p=t(13),l=t(10),y=_.__importStar(t(18)),{abs:f,max:u}=Math;class x extends a.GlyphView{after_visuals(){super.after_visuals(),this.max_line_width=h.max(this.line_width)}_index_data(t){for(const e of this.y)t.add_point(0,e)}_bounds(t){const{y0:e,y1:i}=t;return{x0:NaN,x1:NaN,y0:e,y1:i}}_map_data(){super._map_data();const{round:t}=Math;if(!this.inherited_sy){const e=(0,p.map)(this.sy,(e=>t(e)));this._define_attr("sy",e)}}scenterxy(t){const{hcenter:e}=this.renderer.plot_view.frame.bbox;return[e,this.sy[t]]}_render(t,e,i){const{sy:n}={...this,...i},{left:s,right:r}=this.renderer.plot_view.frame.bbox;for(const i of e){const e=n[i];isFinite(e)&&(t.beginPath(),t.moveTo(s,e),t.lineTo(r,e),this.visuals.line.apply(t,i))}}_get_candidates(t,e){const{max_line_width:i}=this,[n,s]=this.renderer.yscale.r_invert(t-i,(e??t)+i);return this.index.indices({x0:0,x1:0,y0:n,y1:s})}_find_spans(t,e){const{sy:i,line_width:n}=this,s=[];for(const r of t){e(i[r],n.get(r))&&s.push(r)}return s}_hit_point(t){const{sy:e}=t,i=this._get_candidates(e),n=this._find_spans(i,((t,i)=>f(t-e)<=u(i/2,2)));return new d.Selection({indices:n})}_hit_span(t){const e=(()=>{if("v"==t.direction)return(0,l.range)(0,this.data_size);{const{sy:e}=t,i=this._get_candidates(e);return this._find_spans(i,((t,i)=>f(t-e)<=u(i/2,2)))}})();return new d.Selection({indices:e})}_hit_rect(t){const e=(()=>{const{sy0:e,sy1:i}=t,n=this._get_candidates(e,i);return this._find_spans(n,((t,n)=>e-n/2<=t&&t<=i+n/2))})();return new d.Selection({indices:e})}draw_legend_for_index(t,e,i){(0,o.generic_line_vector_legend)(this.visuals,t,e,i)}}i.HSpanView=x,x.__name__="HSpanView";class m extends a.Glyph{constructor(t){super(t)}}i.HSpan=m,r=m,m.__name__="HSpan",r.prototype.default_view=x,r.mixins([c.LineVector]),r.define((()=>({y:[y.YCoordinateSpec,{field:"y"}]})))},
function _(t,e,i,s,r){var n;s();const a=t(1),_=t(218),o=t(224),h=t(127),c=t(85),d=t(24),l=t(13),y=a.__importStar(t(34)),p=t(10),f=a.__importStar(t(18));class u extends _.GlyphView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e&&e.regl_wrapper.has_webgl){const{LRTBGL:i}=await Promise.resolve().then((()=>a.__importStar(t(560))));this.glglyph=new i(e.regl_wrapper,this)}}get sleft(){const{left:t}=this.renderer.plot_view.frame.bbox,e=this.data_size,i=new d.ScreenArray(e);return i.fill(t),i}get sright(){const{right:t}=this.renderer.plot_view.frame.bbox,e=this.data_size,i=new d.ScreenArray(e);return i.fill(t),i}get stop(){return this.sy0}get sbottom(){return this.sy1}_set_data(t){super._set_data(t);const{abs:e}=Math,{max:i,map:s,zip:r}=y,{y0:n,y1:a}=this;if(this.inherited_y0&&this.inherited_y1)this._inherit_attr("max_height");else{const t=i(s(r(n,a),(([t,i])=>e(t-i))));this._define_attr("max_height",t)}}_index_data(t){const{y0:e,y1:i,data_size:s}=this;for(let r=0;r<s;r++){const s=e[r],n=i[r];t.add_rect(0,s,0,n)}}_bounds(t){const{y0:e,y1:i}=t;return{x0:NaN,x1:NaN,y0:e,y1:i}}_map_data(){super._map_data();const{round:t}=Math;if(!this.inherited_sy0){const e=(0,l.map)(this.sy0,(e=>t(e)));this._define_attr("sy0",e)}if(!this.inherited_sy1){const e=(0,l.map)(this.sy1,(e=>t(e)));this._define_attr("sy1",e)}}scenterxy(t){const{hcenter:e}=this.renderer.plot_view.frame.bbox;return[e,(this.sy0[t]+this.sy1[t])/2]}_render(t,e,i){const{sy0:s,sy1:r}={...this,...i},{left:n,right:a,width:_}=this.renderer.plot_view.frame.bbox;for(const i of e){const e=s[i],o=r[i];isFinite(e+o)&&(t.beginPath(),t.rect(n,e,_,o-e),this.visuals.fill.apply(t,i),this.visuals.hatch.apply(t,i),t.beginPath(),t.moveTo(n,e),t.lineTo(a,e),t.moveTo(n,o),t.lineTo(a,o),this.visuals.line.apply(t,i))}}_get_candidates(t,e){const{max_height:i}=this,[s,r]=this.renderer.yscale.r_invert(t,e??t),n=s-i,a=r+i;return this.index.indices({x0:0,x1:0,y0:n,y1:a})}_find_strips(t,e){function i(t,i){return t<=i?e(t,i):e(i,t)}const{sy0:s,sy1:r}=this,n=[];for(const e of t){i(s[e],r[e])&&n.push(e)}return n}_hit_point(t){const{sy:e}=t,i=this._get_candidates(e),s=this._find_strips(i,((t,i)=>t<=e&&e<=i));return new h.Selection({indices:s})}_hit_span(t){const e=(()=>{if("v"==t.direction)return(0,p.range)(0,this.data_size);{const{sy:e}=t,i=this._get_candidates(e);return this._find_strips(i,((t,i)=>t<=e&&e<=i))}})();return new h.Selection({indices:e})}_hit_rect(t){const e=(()=>{const{sy0:e,sy1:i}=t,s=this._get_candidates(e,i);return this._find_strips(s,((t,s)=>e<=t&&t<=i&&e<=s&&s<=i))})();return new h.Selection({indices:e})}draw_legend_for_index(t,e,i){(0,o.generic_area_vector_legend)(this.visuals,t,e,i)}}i.HStripView=u,u.__name__="HStripView";class g extends _.Glyph{constructor(t){super(t)}}i.HStrip=g,n=g,g.__name__="HStrip",n.prototype.default_view=u,n.mixins([c.LineVector,c.FillVector,c.HatchVector]),n.define((()=>({y0:[f.YCoordinateSpec,{field:"y0"}],y1:[f.YCoordinateSpec,{field:"y1"}]})))},
function _(e,t,a,r,n){var i,o=this&&this.__createBinding||(Object.create?function(e,t,a,r){void 0===r&&(r=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,r,n)}:function(e,t,a,r){void 0===r&&(r=a),e[r]=t[a]}),l=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a in e)"default"!==a&&Object.prototype.hasOwnProperty.call(e,a)&&o(t,e,a);return l(t,e),t};r();const _=e(360),c=e(212),u=e(272);class d extends _.ImageBaseView{async load_glglyph(){const{ImageGL:t}=await Promise.resolve().then((()=>s(e(557))));return t}connect_signals(){super.connect_signals(),this.connect(this.model.color_mapper.change,(()=>this._update_image()))}_update_image(){null!=this.glglyph&&this.glglyph.set_image_changed(),null!=this.image_data&&(this._set_data(null),this.renderer.request_render())}_flat_img_to_buf8(e){return this.model.color_mapper.rgba_mapper.v_compute(e)}}a.ImageView=d,d.__name__="ImageView";class f extends _.ImageBase{constructor(e){super(e)}}a.Image=f,i=f,f.__name__="Image",i.prototype.default_view=d,i.define((({Ref:e})=>({color_mapper:[e(c.ColorMapper),()=>new u.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})]})))},
function _(t,e,i,s,r){var a;s();const n=t(1),h=t(217),_=t(218),o=t(24),d=t(20),c=n.__importStar(t(18)),l=n.__importStar(t(85)),g=t(127),m=t(12),x=t(182),u=t(183);class y extends h.XYGlyphView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,(()=>this.renderer.request_render()))}get image_dimension(){return 2}get xy_scale(){switch(this.model.origin){case"bottom_left":return{x:1,y:-1};case"top_left":return{x:1,y:1};case"bottom_right":return{x:-1,y:-1};case"top_right":return{x:-1,y:1}}}get xy_offset(){switch(this.model.origin){case"bottom_left":return{x:0,y:1};case"top_left":return{x:0,y:0};case"bottom_right":return{x:1,y:1};case"top_right":return{x:1,y:0}}}get xy_anchor(){return(0,u.anchor)(this.model.anchor)}get xy_sign(){const t=this.renderer.xscale.source_range,e=this.renderer.yscale.source_range;return{x:t.is_reversed?-1:1,y:e.is_reversed?-1:1}}_render(t,e,i){const{image_data:s,sx:r,sy:a,sdw:n,sdh:h}={...this,...i},{xy_sign:_,xy_scale:o,xy_offset:d,xy_anchor:c}=this;if((0,m.assert)(null!=s),t.save(),t.imageSmoothingEnabled=!1,this.visuals.image.doit)for(const i of e){const e=s[i],l=r[i],g=a[i],m=n[i],x=h[i];if(null==e||!isFinite(l+g+m+x))continue;const u=_.x*c.x*m,y=_.y*c.y*x;t.save(),t.translate(l-u,g-y),t.scale(_.x*o.x,_.y*o.y),this.visuals.image.set_vectorize(t,i),t.drawImage(e,-d.x*m,-d.y*x,m,x),t.restore()}t.restore()}_set_data(t){const e=this.data_size;null!=this.image_data&&this.image_data.length==e||(this.image_data=new Array(e).fill(null),this._width=new Uint32Array(e),this._height=new Uint32Array(e));const{image_dimension:i}=this;for(let s=0;s<e;s++){if(null!=t&&!t.includes(s))continue;const e=this.image.get(s);(0,m.assert)(e.dimension==i,`expected a ${i}D array, not ${e.dimension}D`);const[r,a]=e.shape;this._height[s]=r,this._width[s]=a;const n=this._flat_img_to_buf8(e);this._set_image_data_from_buffer(s,n)}}_index_data(t){const{data_size:e}=this;for(let i=0;i<e;i++){const[e,s,r,a]=this._lrtb(i);t.add_rect(e,a,s,r)}}_lrtb(t){const e=this.dw.get(t),i=this.dh.get(t),s=this.x[t],r=this.y[t],{xy_anchor:a}=this,[n,h]=[s-a.x*e,s+(1-a.x)*e],[_,o]=[r+a.y*i,r-(1-a.y)*i],[d,c]=n<=h?[n,h]:[h,n],[l,g]=_<=o?[_,o]:[o,_];return[d,c,g,l]}_get_or_create_canvas(t){(0,m.assert)(null!=this.image_data);const e=this.image_data[t];if(null!=e&&e.width==this._width[t]&&e.height==this._height[t])return e;{const e=document.createElement("canvas");return e.width=this._width[t],e.height=this._height[t],e}}_set_image_data_from_buffer(t,e){(0,m.assert)(null!=this.image_data);const i=this._get_or_create_canvas(t),s=i.getContext("2d"),r=s.getImageData(0,0,this._width[t],this._height[t]);r.data.set(e),s.putImageData(r,0,0),this.image_data[t]=i}_map_data(){this._define_or_inherit_attr("sdw",(()=>"data"==this.model.properties.dw.units?this.inherited_x&&this.inherited_dw?_.inherit:this.sdist(this.renderer.xscale,this.x,this.dw,"edge",this.model.dilate):this.inherited_dw?_.inherit:(0,o.to_screen)(this.dw))),this._define_or_inherit_attr("sdh",(()=>"data"==this.model.properties.dh.units?this.inherited_y&&this.inherited_dh?_.inherit:this.sdist(this.renderer.yscale,this.y,this.dh,"edge",this.model.dilate):this.inherited_dh?_.inherit:(0,o.to_screen)(this.dh)))}_image_index(t,e,i){const[s,r,a,n]=this._lrtb(t),h=this._width[t],_=(r-s)/h,o=(a-n)/this._height[t],d=Math.floor((e-s)/_),c=Math.floor((i-n)/o);return{index:t,i:d,j:c,flat_index:c*h+d}}_hit_point(t){const{sx:e,sy:i}=t,s=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),a=this.index.indices({x0:s,x1:s,y0:r,y1:r}),n=new g.Selection,h=[];for(const t of a)isFinite(e)&&isFinite(i)&&(h.push(t),n.image_indices.push(this._image_index(t,s,r)));return n.indices=h,n}}i.ImageBaseView=y,y.__name__="ImageBaseView";class f extends h.XYGlyph{constructor(t){super(t)}}i.ImageBase=f,a=f,f.__name__="ImageBase",a.mixins(l.ImageVector),a.define((({Bool:t})=>({image:[c.NDArraySpec,{field:"image"}],dw:[c.DistanceSpec,{field:"dw"}],dh:[c.DistanceSpec,{field:"dh"}],dilate:[t,!1],origin:[d.ImageOrigin,"bottom_left"],anchor:[x.Anchor,"bottom_left"]})))},
function _(e,t,r,n,a){var i,o=this&&this.__createBinding||(Object.create?function(e,t,r,n){void 0===n&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){void 0===n&&(n=r),e[n]=t[r]}),u=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&o(t,e,r);return u(t,e),t};n();const c=e(360),l=e(8);class _ extends c.ImageBaseView{async load_glglyph(){const{ImageGL:t}=await Promise.resolve().then((()=>s(e(557))));return t}_flat_img_to_buf8(e){const t=(0,l.isTypedArray)(e)?e:new Uint32Array(e);return new Uint8ClampedArray(t.buffer)}}r.ImageRGBAView=_,_.__name__="ImageRGBAView";class f extends c.ImageBase{constructor(e){super(e)}}r.ImageRGBA=f,i=f,f.__name__="ImageRGBA",i.prototype.default_view=_},
function _(e,t,a,r,n){var i,o=this&&this.__createBinding||(Object.create?function(e,t,a,r){void 0===r&&(r=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,r,n)}:function(e,t,a,r){void 0===r&&(r=a),e[r]=t[a]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),c=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a in e)"default"!==a&&Object.prototype.hasOwnProperty.call(e,a)&&o(t,e,a);return s(t,e),t};r();const _=e(360),l=e(275);class u extends _.ImageBaseView{async load_glglyph(){const{ImageGL:t}=await Promise.resolve().then((()=>c(e(557))));return t}connect_signals(){super.connect_signals(),this.connect(this.model.color_mapper.change,(()=>this._update_image()))}get image_dimension(){return 3}_update_image(){null!=this.glglyph&&this.glglyph.set_image_changed(),null!=this.image_data&&(this._set_data(null),this.renderer.request_render())}_flat_img_to_buf8(e){return this.model.color_mapper.rgba_mapper.v_compute(e)}}a.ImageStackView=u,u.__name__="ImageStackView";class g extends _.ImageBase{constructor(e){super(e)}}a.ImageStack=g,i=g,g.__name__="ImageStack",i.prototype.default_view=u,i.define((({Ref:e})=>({color_mapper:[e(l.StackColorMapper)]})))},
function _(e,t,i,s,r){var n;s();const a=e(1),h=e(217),l=e(218),o=e(24),d=e(20),_=a.__importStar(e(18)),c=e(10),u=e(13),m=e(176),g=a.__importStar(e(183));class p extends h.XYGlyphView{constructor(){super(...arguments),this._images_rendered=!1,this.image=new Array(0),this._set_data_iteration=0}connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,(()=>this.renderer.request_render()))}_index_data(e){const{data_size:t}=this;for(let i=0;i<t;i++)e.add_empty()}_set_data(){if(this.inherited_url)return;this._set_data_iteration++;const{url:e}=this,t=e.length;this.image=(0,c.resize)(this.image,t,null),this.loaders=new Array(t).fill(null),this.resolved=new o.Indices(t);const{retry_attempts:i,retry_timeout:s}=this.model,{_set_data_iteration:r}=this;for(let n=0;n<t;n++){const t=e.get(n);if(""==t)continue;const a=new m.ImageLoader(t,{loaded:e=>{this._set_data_iteration!=r||this.resolved.get(n)||(this.resolved.set(n),this.image[n]=e,this.loaders[n]=null,this.renderer.request_render())},failed:()=>{if(this._set_data_iteration==r){this.resolved.set(n),this.loaders[n]=null;null!=this.image[n]&&(this.image[n]=null,this.renderer.request_render())}},attempts:i+1,timeout:s});this.loaders[n]=a}const n="data"==this.model.properties.w.units,a="data"==this.model.properties.h.units,h=this.data_size,l=new o.ScreenArray(n?2*h:h),d=new o.ScreenArray(a?2*h:h);this.anchor=g.anchor(this.model.anchor);const{x:_,y:p}=this.anchor;function f(e,t){const i=e-_*t;return[i,i+t]}function w(e,t){const i=e+p*t;return[i,i-t]}if(n)for(let e=0;e<h;e++)[l[e],l[h+e]]=f(this.x[e],this.w.get(e)??0);else l.set(this.x,0);if(a)for(let e=0;e<h;e++)[d[e],d[h+e]]=w(this.y[e],this.h.get(e)??0);else d.set(this.y,0);const[y,x,b,v]=(0,u.minmax2)(l,d);this._bounds_rect={x0:y,x1:x,y0:b,y1:v}}has_finished(){return super.has_finished()&&this._images_rendered}_map_data(){const e=()=>this.w.map((e=>e??NaN)),t=()=>this.h.map((e=>e??NaN));this._define_or_inherit_attr("sw",(()=>"data"==this.model.properties.w.units?this.inherited_x&&this.inherited_w?l.inherit:this.sdist(this.renderer.xscale,this.x,e(),"edge",this.model.dilate):this.inherited_w?l.inherit:(0,o.to_screen)(e()))),this._define_or_inherit_attr("sh",(()=>"data"==this.model.properties.h.units?this.inherited_y&&this.inherited_h?l.inherit:this.sdist(this.renderer.yscale,this.y,t(),"edge",this.model.dilate):this.inherited_h?l.inherit:(0,o.to_screen)(t())))}_render(e,t,i){const{sx:s,sy:r,sw:n,sh:a,angle:h,global_alpha:l}={...this,...i},{image:o,loaders:d,resolved:_}=this,{frame:c}=this.renderer.plot_view,{left:u,top:m,width:g,height:p}=c.bbox;e.beginPath(),e.rect(u+1,m+1,g-2,p-2),e.clip();let f=!0;for(const i of t){const t=d[i];if(!isFinite(s[i]+r[i]+h.get(i)+l.get(i)))continue;_.get(i)||(null!=t&&t.image.complete?(o[i]=t.image,d[i]=null,_.set(i)):f=!1);const c=o[i];null!=c&&(0==c.naturalWidth&&0==c.naturalHeight||this._render_image(e,i,c,s,r,n,a,h,l))}f&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())}_render_image(e,t,i,s,r,n,a,h,l){isFinite(n[t])||(n[t]=i.width),isFinite(a[t])||(a[t]=i.height);const o=n[t],d=a[t],{anchor:_}=this,c=_.x*o,u=_.y*d,m=s[t]-c,g=r[t]-u,p=h.get(t),f=l.get(t);e.save(),e.globalAlpha=f;const w=o/2,y=d/2;0!=p?(e.translate(m,g),e.translate(w,y),e.rotate(p),e.translate(-w,-y),e.drawImage(i,0,0,o,d),e.translate(w,y),e.rotate(-p),e.translate(-w,-y),e.translate(-m,-g)):e.drawImage(i,m,g,o,d),e.restore()}bounds(){return this._bounds_rect}}i.ImageURLView=p,p.__name__="ImageURLView";class f extends h.XYGlyph{constructor(e){super(e)}}i.ImageURL=f,n=f,f.__name__="ImageURL",n.prototype.default_view=p,n.define((({Bool:e,Int:t})=>({url:[_.StringSpec,{field:"url"}],anchor:[d.Anchor,"top_left"],global_alpha:[_.NumberSpec,{value:1}],angle:[_.AngleSpec,0],w:[_.NullDistanceSpec,null],h:[_.NullDistanceSpec,null],dilate:[e,!1],retry_attempts:[t,0],retry_timeout:[t,0]})))},
function _(t,e,a,h,l){var M;h();const _=t(365),n=t(175);class p extends _.MathTextGlyphView{_build_label(t){return new n.MathML({text:t})}}a.MathMLGlyphView=p,p.__name__="MathMLGlyphView";class s extends _.MathTextGlyph{constructor(t){super(t)}}a.MathMLGlyph=s,M=s,s.__name__="MathMLGlyph",M.prototype.default_view=p},
function _(e,t,s,i,l){i();const a=e(366),n=e(175),h=e(56),r=e(8),_=e(34);class u extends a.TextView{constructor(){super(...arguments),this._label_views=new Map}remove(){(0,h.remove_views)(this._label_views),super.remove()}*children(){yield*super.children(),yield*this._label_views.values()}has_finished(){if(!super.has_finished())return!1;for(const e of this._label_views.values())if(!e.has_finished())return!1;return!0}async _build_labels(){const{text:e}=this.base??this,t=Array.from(e,(e=>null==e?null:this._build_label(e)));await(0,h.build_views)(this._label_views,t.filter(r.non_null),{parent:this.renderer}),this.labels=t.map((e=>null==e?null:this._label_views.get(e).graphics()))}async after_lazy_visuals(){await super.after_lazy_visuals();const e=[...this._label_views.values()].map((e=>e instanceof n.MathTextView?e.request_image():null));await Promise.allSettled(e);const{left:t,right:s,top:i,bottom:l}=this.padding;for(const[e,a]of(0,_.enumerate)(this.labels)){if(null==e)continue;if(!(e instanceof n.MathTextView))continue;const h=e.size(),r=t+h.width+s,_=i+h.height+l;this.swidth[a]=r,this.sheight[a]=_}}}s.MathTextGlyphView=u,u.__name__="MathTextGlyphView";class o extends a.Text{constructor(e){super(e)}}s.MathTextGlyph=o,o.__name__="MathTextGlyph"},
function _(t,e,s,a,i){var n;a();const r=t(1),o=t(217),l=r.__importStar(t(85)),_=r.__importStar(t(18)),c=t(39),h=t(127),d=t(64),u=t(34),x=t(112),f=t(177),g=t(182),p=r.__importStar(t(183)),y=t(184);class b extends _.DataSpec{}b.__name__="TextAnchorSpec";class w extends o.XYGlyphView{async _build_labels(){const{text:t}=this.base??this;this.labels=Array.from(t,(t=>{if(null==t)return null;{const e=`${t}`;return new f.TextBox({text:e})}}))}async _set_lazy_data(){await this._build_labels()}after_visuals(){super.after_visuals();const t=this.data_size,{anchor:e}=this.base??this,{padding:s,border_radius:a}=this.model,{text_align:i,text_baseline:n}=this.visuals.text;if(e.is_Scalar()&&"auto"!=e.value)this.anchor_=new c.UniformScalar(p.anchor(e.value),t);else if(e.is_Scalar()&&i.is_Scalar()&&n.is_Scalar())this.anchor_=new c.UniformScalar(p.text_anchor(e.value,i.value,n.value),t);else{const s=new Array(t);for(let a=0;a<t;a++){const t=e.get(a),r=i.get(a),o=n.get(a);s[a]=p.text_anchor(t,r,o)}this.anchor_=new c.UniformVector(s)}this.padding=p.padding(s),this.border_radius=p.border_radius(a),this.swidth=new Float32Array(t),this.sheight=new Float32Array(t);const{left:r,right:o,top:l,bottom:_}=this.padding;for(const[t,e]of(0,u.enumerate)(this.labels)){if(null==t)continue;t.visuals=this.visuals.text.values(e),t.position={sx:0,sy:0,x_anchor:"left",y_anchor:"top"},t.align="auto";const s=t.size(),a=r+s.width+o,i=l+s.height+_;this.swidth[e]=a,this.sheight[e]=i}}_render(t,e,s){const{sx:a,sy:i,x_offset:n,y_offset:r,angle:o}={...this,...s},{text:l,background_fill:_,background_hatch:c,border_line:h}=this.visuals,{anchor_:u,border_radius:x,padding:f}=this,{labels:g,swidth:p,sheight:b}=this;for(const s of e){const e=a[s]+n.get(s),w=i[s]+r.get(s),v=o.get(s),N=g[s];if(!isFinite(e+w+v)||null==N)continue;const m=p[s],S=b[s],T=u.get(s),V=T.x*m,A=T.y*S;if(t.translate(e,w),t.rotate(v),t.translate(-V,-A),_.v_doit(s)||c.v_doit(s)||h.v_doit(s)){t.beginPath();const e=new d.BBox({x:0,y:0,width:m,height:S});(0,y.round_rect)(t,e,x),_.apply(t,s),c.apply(t,s),h.apply(t,s)}if(l.v_doit(s)){const{left:e,top:s}=f;t.translate(e,s),N.paint(t),t.translate(-e,-s)}t.translate(V,A),t.rotate(-v),t.translate(-e,-w)}}_hit_point(t){const e={x:t.sx,y:t.sy},{sx:s,sy:a,x_offset:i,y_offset:n,angle:r,labels:o}=this,{anchor_:l}=this,{swidth:_,sheight:c}=this,d=this.data_size,u=[];for(let t=0;t<d;t++){const h=s[t]+i.get(t),d=a[t]+n.get(t),f=r.get(t),g=o[t];if(!isFinite(h+d+f)||null==g)continue;const p=_[t],y=c[t],b=l.get(t),w=b.x*p,v=b.y*y,{x:N,y:m}=(0,x.rotate_around)(e,{x:h,y:d},-f),S=h-w,T=d-v;S<=N&&N<=S+p&&T<=m&&m<=T+y&&u.push(t)}return new h.Selection({indices:u})}rect_i(t){const{sx:e,sy:s,x_offset:a,y_offset:i,angle:n,labels:r}=this,{anchor_:o}=this,{swidth:l,sheight:_}=this,c=e[t]+a.get(t),h=s[t]+i.get(t),u=n.get(t),f=r[t];if(!isFinite(c+h+u)||null==f)return{p0:{x:NaN,y:NaN},p1:{x:NaN,y:NaN},p2:{x:NaN,y:NaN},p3:{x:NaN,y:NaN}};const g=l[t],p=_[t],y=o.get(t),b=y.x*g,w=y.y*p,v=new d.BBox({x:c-b,y:h-w,width:g,height:p}),{rect:N}=v;if(0==u)return N;{const t=new x.AffineTransform;return t.rotate_around(c,h,u),t.apply_rect(N)}}scenterxy(t){const{p0:e,p1:s,p2:a,p3:i}=this.rect_i(t);return[(e.x+s.x+a.x+i.x)/4,(e.y+s.y+a.y+i.y)/4]}}s.TextView=w,w.__name__="TextView";class v extends o.XYGlyph{constructor(t){super(t)}}s.Text=v,n=v,v.__name__="Text",n.prototype.default_view=w,n.mixins([l.TextVector,["border_",l.LineVector],["background_",l.FillVector],["background_",l.HatchVector]]),n.define((()=>({text:[_.NullStringSpec,{field:"text"}],angle:[_.AngleSpec,0],x_offset:[_.NumberSpec,0],y_offset:[_.NumberSpec,0],anchor:[b,{value:"auto"}],padding:[g.Padding,0],border_radius:[g.BorderRadius,0]}))),n.override({border_line_color:null,background_fill_color:null,background_hatch_color:null})},
function _(e,t,s,i,n){var r;i();const o=e(1),l=e(131),_=e(85),c=o.__importStar(e(225)),a=o.__importStar(e(18)),h=e(13),d=e(218),g=e(224),x=e(127);class y extends d.GlyphView{async load_glglyph(){const{MultiLineGL:t}=await Promise.resolve().then((()=>o.__importStar(e(561))));return t}_project_data(){l.inplace.project_xy(this.xs.data,this.ys.data)}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const t=this.xs.get(s),i=this.ys.get(s),[n,r,o,l]=(0,h.minmax2)(t,i);e.add_rect(n,o,r,l)}}_render(e,t,s){const{sxs:i,sys:n}={...this,...s};for(const s of t){const t=i.get(s),r=n.get(s),o=Math.min(t.length,r.length);let l=!0;e.beginPath();for(let s=0;s<o;s++){const i=t[s],n=r[s];isFinite(i+n)?l?(e.moveTo(i,n),l=!1):e.lineTo(i,n):l=!0}this.visuals.line.set_vectorize(e,s),e.stroke()}}_hit_point(e){const t={x:e.sx,y:e.sy};let s=9999;const i=new Map;for(let e=0,n=this.sxs.length;e<n;e++){const n=Math.max(2,this.line_width.get(e)/2),r=this.sxs.get(e),o=this.sys.get(e);let l=null;for(let e=0,i=r.length-1;e<i;e++){const i={x:r[e],y:o[e]},_={x:r[e+1],y:o[e+1]},a=c.dist_to_segment(t,i,_);a<n&&a<s&&(s=a,l=[e])}null!=l&&i.set(e,l)}return new x.Selection({indices:[...i.keys()],multiline_indices:i})}_hit_span(e){const{sx:t,sy:s}=e;let i,n;"v"==e.direction?(i=this.renderer.yscale.invert(s),n=this.ys):(i=this.renderer.xscale.invert(t),n=this.xs);const r=new Map;for(let e=0,t=n.length;e<t;e++){const t=n.get(e),s=[];for(let e=0,n=t.length-1;e<n;e++)t[e]<=i&&i<=t[e+1]&&s.push(e);s.length>0&&r.set(e,s)}return new x.Selection({indices:[...r.keys()],multiline_indices:r})}get_interpolation_hit(e,t,s){const i=this.xs.get(e),n=this.ys.get(e),r=i[t],o=n[t],l=i[t+1],_=n[t+1];return(0,g.line_interpolation)(this.renderer,s,r,o,l,_)}draw_legend_for_index(e,t,s){(0,g.generic_line_vector_legend)(this.visuals,e,t,s)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}s.MultiLineView=y,y.__name__="MultiLineView";class p extends d.Glyph{constructor(e){super(e)}}s.MultiLine=p,r=p,p.__name__="MultiLine",r.prototype.default_view=y,r.define((({})=>({xs:[a.XCoordinateSeqSpec,{field:"xs"}],ys:[a.YCoordinateSeqSpec,{field:"ys"}]}))),r.mixins(_.LineVector)},
function _(e,t,s,n,i){var r;n();const o=e(1),l=e(220),h=e(218),a=e(224),_=e(13),c=e(13),d=e(85),y=o.__importStar(e(225)),f=o.__importStar(e(18)),x=e(127),g=e(12);class p extends h.GlyphView{_project_data(){}_index_data(e){const{min:t,max:s}=Math,{data_size:n}=this;for(let i=0;i<n;i++){const n=this.xs[i],r=this.ys[i];if(0==n.length||0==r.length){e.add_empty();continue}let o=1/0,l=-1/0,h=1/0,a=-1/0;for(let e=0,i=n.length;e<i;e++){const i=n[e][0],c=r[e][0];if(0!=i.length&&0!=c.length){const[e,n,r,d]=(0,_.minmax2)(i,c);o=t(o,e),l=s(l,n),h=t(h,r),a=s(a,d)}}e.add_rect(o,h,l,a)}this._hole_index=this._index_hole_data()}_index_hole_data(){const{min:e,max:t}=Math,{data_size:s}=this,n=new l.SpatialIndex(s);for(let i=0;i<s;i++){const s=this.xs[i],r=this.ys[i];if(0==s.length||0==r.length){n.add_empty();continue}let o=1/0,l=-1/0,h=1/0,a=-1/0;for(let n=0,i=s.length;n<i;n++){const i=s[n],c=r[n];if(i.length>1&&c.length>1)for(let s=1,n=i.length;s<n;s++){const[n,r,d,y]=(0,_.minmax2)(i[s],c[s]);o=e(o,n),l=t(l,r),h=e(h,d),a=t(a,y)}}n.add_rect(o,h,l,a)}return n.finish(),n}_mask_data(){const{x_range:e,y_range:t}=this.renderer.plot_view.frame;return this.index.indices({x0:e.min,x1:e.max,y0:t.min,y1:t.max})}_render(e,t,s){if(!this.visuals.fill.doit&&!this.visuals.line.doit)return;const{sxs:n,sys:i}={...this,...s};for(const s of t){e.beginPath();const t=n[s],r=i[s],o=Math.min(t.length,r.length);for(let s=0;s<o;s++){const n=t[s],i=r[s],o=Math.min(n.length,i.length);for(let t=0;t<o;t++){const s=n[t],r=i[t],o=Math.min(s.length,r.length);for(let t=0;t<o;t++){const n=s[t],i=r[t];0==t?e.moveTo(n,i):e.lineTo(n,i)}e.closePath()}}this.visuals.fill.apply(e,s,"evenodd"),this.visuals.hatch.apply(e,s,"evenodd"),this.visuals.line.apply(e,s)}}_hit_poly(e){const{sx:t,sy:s,greedy:n=!1}=e,i=(()=>{const e=this.renderer.xscale.v_invert(t),n=this.renderer.yscale.v_invert(s),[i,r,o,l]=(0,_.minmax2)(e,n);return this.index.indices({x0:i,x1:r,y0:o,y1:l})})(),r=[];for(const e of i){const i=this.sxs[e],o=this.sys[e];let l=!n;const h=i.length;for(let e=0;e<h;e++){const r=i[e][0],h=o[e][0],a=r.length;for(let e=0;e<a;e++){const i=r[e],o=h[e];if(y.point_in_poly(i,o,t,s)){if(n){l=!0;break}}else if(!n){l=!1;break}}if(n){if(l)break}else if(!l)break}l&&r.push(e)}return new x.Selection({indices:r})}_hit_rect(e){const{sx0:t,sx1:s,sy0:n,sy1:i,greedy:r}=e,o=[t,s,s,t],l=[n,n,i,i];return this._hit_poly({type:"poly",sx:o,sy:l,greedy:r})}_hit_point(e){const{sx:t,sy:s}=e,n=this.renderer.xscale.invert(t),i=this.renderer.yscale.invert(s),r=this.index.indices({x0:n,y0:i,x1:n,y1:i}),o=this._hole_index.indices({x0:n,y0:i,x1:n,y1:i}),l=[];for(const e of r){const n=this.sxs[e],i=this.sys[e];for(let r=0,h=n.length;r<h;r++){const h=n[r].length;if(y.point_in_poly(t,s,n[r][0],i[r][0]))if(1==h)l.push(e);else if(o.get(e)){if(h>1){let o=!1;for(let e=1;e<h;e++){const l=n[r][e],h=i[r][e];if(y.point_in_poly(t,s,l,h)){o=!0;break}}o||l.push(e)}}else l.push(e)}}return new x.Selection({indices:l})}_get_snap_coord(e){return(0,c.sum)(e)/e.length}scenterxy(e,t,s){if(1==this.sxs[e].length){return[this._get_snap_coord(this.sxs[e][0][0]),this._get_snap_coord(this.sys[e][0][0])]}{const n=this.sxs[e],i=this.sys[e];for(let e=0,r=n.length;e<r;e++)if(y.point_in_poly(t,s,n[e][0],i[e][0])){return[this._get_snap_coord(n[e][0]),this._get_snap_coord(i[e][0])]}}(0,g.unreachable)()}map_data(){if(this.inherited_xs&&this.inherited_ys)this._inherit_attr("sxs"),this._inherit_attr("sys");else{const{xs:e,ys:t}=this,s=e.length,n=new Array(s),i=new Array(s);for(let r=0;r<s;r++){const s=e[r].length;n[r]=new Array(s),i[r]=new Array(s);for(let o=0;o<s;o++){const s=e[r][o].length;n[r][o]=new Array(s),i[r][o]=new Array(s);for(let l=0;l<s;l++){const[s,h]=this.renderer.coordinates.map_to_screen(e[r][o][l],t[r][o][l]);n[r][o][l]=s,i[r][o][l]=h}}}this._define_attr("sxs",n),this._define_attr("sys",i)}}draw_legend_for_index(e,t,s){(0,a.generic_area_vector_legend)(this.visuals,e,t,s)}}s.MultiPolygonsView=p,p.__name__="MultiPolygonsView";class u extends h.Glyph{constructor(e){super(e)}}s.MultiPolygons=u,r=u,u.__name__="MultiPolygons",r.prototype.default_view=p,r.define((({})=>({xs:[f.XCoordinateSeqSeqSeqSpec,{field:"xs"}],ys:[f.YCoordinateSeqSeqSeqSpec,{field:"ys"}]}))),r.mixins([d.LineVector,d.FillVector,d.HatchVector])},
function _(e,t,s,i,n){var r;i();const o=e(1),a=e(218),c=e(224),_=e(13),h=e(85),l=o.__importStar(e(225)),y=o.__importStar(e(18)),d=e(127),p=e(12),x=e(131);class f extends a.GlyphView{_project_data(){x.inplace.project_xy(this.xs.data,this.ys.data)}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const t=this.xs.get(s),i=this.ys.get(s),[n,r,o,a]=(0,_.minmax2)(t,i);e.add_rect(n,o,r,a)}}_mask_data(){const{x_range:e,y_range:t}=this.renderer.plot_view.frame;return this.index.indices({x0:e.min,x1:e.max,y0:t.min,y1:t.max})}_render(e,t,s){const{sxs:i,sys:n}={...this,...s};for(const s of t){const t=i.get(s),r=n.get(s);let o=!0;e.beginPath();const a=Math.min(t.length,r.length);for(let s=0;s<a;s++){const i=t[s],n=r[s];isFinite(i+n)?o?(e.moveTo(i,n),o=!1):e.lineTo(i,n):(e.closePath(),o=!0)}e.closePath(),this.visuals.fill.apply(e,s),this.visuals.hatch.apply(e,s),this.visuals.line.apply(e,s)}}_hit_poly(e){const{sx:t,sy:s,greedy:i=!1}=e,n=(()=>{const e=this.renderer.xscale.v_invert(t),i=this.renderer.yscale.v_invert(s),[n,r,o,a]=(0,_.minmax2)(e,i);return this.index.indices({x0:n,x1:r,y0:o,y1:a})})(),r=[];for(const e of n){const n=this.sxs.get(e),o=this.sys.get(e),a=n.length;if(0==a)continue;let c=!i;for(let e=0;e<a;e++){const r=n[e],a=o[e];if(l.point_in_poly(r,a,t,s)){if(i){c=!0;break}}else if(!i){c=!1;break}}c&&r.push(e)}return new d.Selection({indices:r})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n,greedy:r}=e,o=[t,s,s,t],a=[i,i,n,n];return this._hit_poly({type:"poly",sx:o,sy:a,greedy:r})}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),n=this.renderer.yscale.invert(s),r=this.index.indices({x0:i,y0:n,x1:i,y1:n}),o=[];for(const e of r){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;for(let a=0,c=0;;c++){if(isNaN(i[c])||c==r){const r=i.subarray(a,c),_=n.subarray(a,c);if(l.point_in_poly(t,s,r,_)){o.push(e);break}a=c+1}if(c==r)break}}return new d.Selection({indices:o})}_get_snap_coord(e){return(0,_.sum)(e)/e.length}scenterxy(e,t,s){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;let o=!1;for(let e=0,a=0;;a++){const c=isNaN(i[a]);if(o=o||c,a==r&&!o){return[this._get_snap_coord(i),this._get_snap_coord(n)]}if(c||a==r){const r=i.subarray(e,a),o=n.subarray(e,a);if(l.point_in_poly(t,s,r,o)){return[this._get_snap_coord(r),this._get_snap_coord(o)]}e=a+1}if(a==r)break}(0,p.unreachable)()}draw_legend_for_index(e,t,s){(0,c.generic_area_vector_legend)(this.visuals,e,t,s)}}s.PatchesView=f,f.__name__="PatchesView";class g extends a.Glyph{constructor(e){super(e)}}s.Patches=g,r=g,g.__name__="Patches",r.prototype.default_view=f,r.define((({})=>({xs:[y.XCoordinateSeqSpec,{field:"xs"}],ys:[y.YCoordinateSeqSpec,{field:"ys"}]}))),r.mixins([h.LineVector,h.FillVector,h.HatchVector])},
function _(t,e,i,o,r){var s;o();const d=t(1),n=t(351),a=d.__importStar(t(18));class l extends n.LRTBView{scenterxy(t){return[this.sleft[t]/2+this.sright[t]/2,this.stop[t]/2+this.sbottom[t]/2]}_lrtb(t){return{l:this.left[t],r:this.right[t],t:this.top[t],b:this.bottom[t]}}}i.QuadView=l,l.__name__="QuadView";class _ extends n.LRTB{constructor(t){super(t)}}i.Quad=_,s=_,_.__name__="Quad",s.prototype.default_view=l,s.define((({})=>({right:[a.XCoordinateSpec,{field:"right"}],bottom:[a.YCoordinateSpec,{field:"bottom"}],left:[a.XCoordinateSpec,{field:"left"}],top:[a.YCoordinateSpec,{field:"top"}]})))},
function _(e,i,t,s,n){var c;s();const o=e(1),r=e(85),a=e(131),d=e(218),_=e(224),l=e(349),x=o.__importStar(e(18));class y extends d.GlyphView{_project_data(){a.inplace.project_xy(this.x0,this.y0),a.inplace.project_xy(this.x1,this.y1)}_index_data(e){const{x0:i,x1:t,y0:s,y1:n,cx:c,cy:o,data_size:r}=this;for(let a=0;a<r;a++){const r=i[a],d=t[a],_=s[a],x=n[a],y=c[a],p=o[a];if(isFinite(r+d+_+x+y+p)){const{x0:i,y0:t,x1:s,y1:n}=(0,l.qbb)(r,_,y,p,d,x);e.add_rect(i,t,s,n)}else e.add_empty()}}_render(e,i,t){if(!this.visuals.line.doit)return;const{sx0:s,sy0:n,sx1:c,sy1:o,scx:r,scy:a}={...this,...t};for(const t of i){const i=s[t],d=n[t],_=c[t],l=o[t],x=r[t],y=a[t];isFinite(i+d+_+l+x+y)&&(e.beginPath(),e.moveTo(i,d),e.quadraticCurveTo(x,y,_,l),this.visuals.line.apply(e,t))}}draw_legend_for_index(e,i,t){(0,_.generic_line_vector_legend)(this.visuals,e,i,t)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}t.QuadraticView=y,y.__name__="QuadraticView";class p extends d.Glyph{constructor(e){super(e)}}t.Quadratic=p,c=p,p.__name__="Quadratic",c.prototype.default_view=y,c.define((({})=>({x0:[x.XCoordinateSpec,{field:"x0"}],y0:[x.YCoordinateSpec,{field:"y0"}],x1:[x.XCoordinateSpec,{field:"x1"}],y1:[x.YCoordinateSpec,{field:"y1"}],cx:[x.XCoordinateSpec,{field:"cx"}],cy:[x.YCoordinateSpec,{field:"cy"}]}))),c.mixins(r.LineVector)},
function _(e,t,i,n,s){var h;n();const r=e(1),l=e(217),a=e(218),_=e(224),o=e(85),d=e(24),g=r.__importStar(e(18));class c extends l.XYGlyphView{_map_data(){if(this._define_or_inherit_attr("slength",(()=>"data"==this.model.properties.length.units?this.inherited_x&&this.inherited_length?a.inherit:this.sdist(this.renderer.xscale,this.x,this.length):this.inherited_length?a.inherit:(0,d.to_screen)(this.length))),!this.inherited_slength){const{width:e,height:t}=this.renderer.plot_view.frame.bbox,i=2*(e+t),{slength:n}=this,s=n.length;for(let e=0;e<s;e++)0==n[e]&&(n[e]=i)}}_render(e,t,i){if(!this.visuals.line.doit)return;const{sx:n,sy:s,slength:h,angle:r}={...this,...i};for(const i of t){const t=n[i],l=s[i],a=r.get(i),_=h[i];isFinite(t+l+a+_)&&(e.translate(t,l),e.rotate(a),e.beginPath(),e.moveTo(0,0),e.lineTo(_,0),this.visuals.line.apply(e,i),e.rotate(-a),e.translate(-t,-l))}}draw_legend_for_index(e,t,i){(0,_.generic_line_vector_legend)(this.visuals,e,t,i)}}i.RayView=c,c.__name__="RayView";class p extends l.XYGlyph{constructor(e){super(e)}}i.Ray=p,h=p,p.__name__="Ray",h.prototype.default_view=c,h.mixins(o.LineVector),h.define((({})=>({length:[g.DistanceSpec,0],angle:[g.AngleSpec,0]})))},
function _(t,e,i,s,r){var _;s();const n=t(1),h=t(354),a=t(224),d=t(24),o=t(13),l=t(127),c=t(64),x=t(112),y=t(182),f=n.__importStar(t(183)),g=t(184),{abs:w,sqrt:u}=Math;class p extends h.CenterRotatableView{async load_glglyph(){const{RectGL:e}=await Promise.resolve().then((()=>n.__importStar(t(563))));return e}_set_data(t){super._set_data(t),this.border_radius=f.border_radius(this.model.border_radius)}_map_data(){const t=this.data_size;if(this.inherited_x&&this.inherited_width)this._inherit_attr("swidth"),this._inherit_attr("sx0");else{let e,i;if("data"==this.model.properties.width.units)[e,i]=this._map_dist_corner_for_data_side_length(this.x,this.width,this.renderer.xscale);else{e=(0,d.to_screen)(this.width),i=new d.ScreenArray(t);const{sx:s}=this;for(let r=0;r<t;r++)i[r]=s[r]-e[r]/2}this._define_attr("swidth",e),this._define_attr("sx0",i)}if(this.inherited_y&&this.inherited_height)this._inherit_attr("sheight"),this._inherit_attr("sy1");else{let e,i;if("data"==this.model.properties.height.units)[e,i]=this._map_dist_corner_for_data_side_length(this.y,this.height,this.renderer.yscale);else{e=(0,d.to_screen)(this.height),i=new d.ScreenArray(t);const{sy:s}=this;for(let r=0;r<t;r++)i[r]=s[r]-e[r]/2}this._define_attr("sheight",e),this._define_attr("sy1",i)}if(this.inherited_swidth&&this.inherited_sheight)this._inherit_attr("max_x2_ddist"),this._inherit_attr("max_y2_ddist");else{const{sx0:e,sy1:i,swidth:s,sheight:r}=this,_=new d.ScreenArray(t);for(let e=0;e<t;e++){const t=s[e],i=r[e];_[e]=u(t**2+i**2)/2}const n=new d.ScreenArray(t),h=new d.ScreenArray(t);for(let _=0;_<t;_++)n[_]=e[_]+s[_]/2,h[_]=i[_]+r[_]/2;const a=(0,o.max)(this._ddist(0,n,_)),l=(0,o.max)(this._ddist(1,h,_));this._define_attr("max_x2_ddist",a),this._define_attr("max_y2_ddist",l)}}_render(t,e,i){const{sx:s,sy:r,sx0:_,sy1:n,swidth:h,sheight:a,angle:d,border_radius:o}={...this,...i};for(const i of e){const e=s[i],l=r[i],x=_[i],y=n[i],f=h[i],w=a[i],u=d.get(i);if(isFinite(e+l+x+y+f+w+u)&&(0!=f&&0!=w)){if(t.beginPath(),0!=u){t.translate(e,l),t.rotate(u);const i=new c.BBox({x:-f/2,y:-w/2,width:f,height:w});(0,g.round_rect)(t,i,o),t.rotate(-u),t.translate(-e,-l)}else{const e=new c.BBox({x,y,width:f,height:w});(0,g.round_rect)(t,e,o)}this.visuals.fill.apply(t,i),this.visuals.hatch.apply(t,i),this.visuals.line.apply(t,i)}}}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){const e={x:t.sx,y:t.sy},i=this.renderer.xscale.invert(e.x),s=this.renderer.yscale.invert(e.y),r=this.index.indices({x0:i-this.max_x2_ddist,x1:i+this.max_x2_ddist,y0:s-this.max_y2_ddist,y1:s+this.max_y2_ddist}),{sx:_,sy:n,sx0:h,sy1:a,swidth:d,sheight:o,angle:c}=this,y=[];for(const t of r){const i=_[t],s=n[t],r=h[t],l=a[t],f=d[t],g=o[t],w=c.get(t),u=(0,x.rotate_around)(e,{x:i,y:s},-w),p=u.x-r,m=u.y-l;0<=p&&p<=f&&0<=m&&m<=g&&y.push(t)}return new l.Selection({indices:y})}_map_dist_corner_for_data_side_length(t,e,i){const s=t.length,r=new Float64Array(s),_=new Float64Array(s);for(let i=0;i<s;i++){const s=t[i],n=e.get(i)/2;r[i]=s-n,_[i]=s+n}const n=i.v_compute(r),h=i.v_compute(_),a=this.sdist(i,r,e,"edge",this.model.dilate);let d=n;for(let t=0;t<s;t++){const e=n[t],i=h[t];if(!isNaN(e+i)&&e!=i){d=e<i?n:h;break}}return[a,d]}_ddist(t,e,i){const s=(0,d.infer_type)(e,i),r=0==t?this.renderer.xscale:this.renderer.yscale,_=e,n=_.length,h=new s(n);for(let t=0;t<n;t++)h[t]=_[t]+i[t];const a=r.v_invert(_),o=r.v_invert(h),l=a.length,c=new s(l);for(let t=0;t<l;t++)c[t]=w(o[t]-a[t]);return c}draw_legend_for_index(t,e,i){(0,a.generic_area_vector_legend)(this.visuals,t,e,i)}}i.RectView=p,p.__name__="RectView";class m extends h.CenterRotatable{constructor(t){super(t)}}i.Rect=m,_=m,m.__name__="Rect",_.prototype.default_view=p,_.define((({Bool:t})=>({border_radius:[y.BorderRadius,0],dilate:[t,!1]})))},
function _(e,t,r,a,n){var s;a();const i=e(1),o=e(375),_=e(376),c=i.__importStar(e(18));class l extends o.MarkerView{async load_glglyph(){const{MultiMarkerGL:t}=await Promise.resolve().then((()=>i.__importStar(e(562))));return t}_render(e,t,r){const{sx:a,sy:n,size:s,angle:i,marker:o}={...this,...r};for(const r of t){const t=a[r],c=n[r],l=s.get(r),g=i.get(r),d=o.get(r);if(!isFinite(t+c+l+g)||null==d)continue;const m=l/2;e.beginPath(),e.translate(t,c),0!=g&&e.rotate(g),_.marker_funcs[d](e,r,m,this.visuals),0!=g&&e.rotate(-g),e.translate(-t,-c)}}draw_legend_for_index(e,{x0:t,x1:r,y0:a,y1:n},s){const i=s+1,o=this.marker.get(s),_={...this._get_legend_args({x0:t,x1:r,y0:a,y1:n},s),marker:new c.UniformScalar(o,i)};this._render(e,[s],_)}}r.ScatterView=l,l.__name__="ScatterView";class g extends o.Marker{constructor(e){super(e)}}r.Scatter=g,s=g,g.__name__="Scatter",s.prototype.default_view=l,s.define((()=>({marker:[c.MarkerSpec,{value:"circle"}]})))},
function _(e,t,s,i,n){var r;i();const a=e(1),c=e(217),o=e(85),_=a.__importStar(e(225)),h=a.__importStar(e(18)),x=e(13),d=e(127);class l extends c.XYGlyphView{_render(e,t,s){const{sx:i,sy:n,size:r,angle:a}={...this,...s};for(const s of t){const t=i[s],c=n[s],o=r.get(s),_=a.get(s);if(!isFinite(t+c+o+_))continue;const h=o/2;e.beginPath(),e.translate(t,c),0!=_&&e.rotate(_),this._render_one(e,s,h,this.visuals),0!=_&&e.rotate(-_),e.translate(-t,-c)}}_mask_data(){const{x_target:e,y_target:t}=this.renderer.plot_view.frame,s=e.widen(this.max_size).map((e=>this.renderer.xscale.invert(e))),i=t.widen(this.max_size).map((e=>this.renderer.yscale.invert(e)));return this.index.indices({x0:s.start,x1:s.end,y0:i.start,y1:i.end})}_hit_point(e){const{sx:t,sy:s}=e,{max_size:i}=this,{hit_dilation:n}=this.model,r=t-i*n,a=t+i*n,[c,o]=this.renderer.xscale.r_invert(r,a),_=s-i*n,h=s+i*n,[x,l]=this.renderer.yscale.r_invert(_,h),y=this.index.indices({x0:c,x1:o,y0:x,y1:l}),m=[];for(const e of y){const i=this.size.get(e)/2*n;Math.abs(this.sx[e]-t)<=i&&Math.abs(this.sy[e]-s)<=i&&m.push(e)}return new d.Selection({indices:m})}_hit_span(e){const{sx:t,sy:s}=e,i=this.bounds(),n=this.max_size/2,[r,a,c,o]=(()=>{if("h"==e.direction){const{y0:e,y1:s}=i,r=t-n,a=t+n,[c,o]=this.renderer.xscale.r_invert(r,a);return[c,o,e,s]}{const{x0:e,x1:t}=i,r=s-n,a=s+n,[c,o]=this.renderer.yscale.r_invert(r,a);return[e,t,c,o]}})(),_=[...this.index.indices({x0:r,x1:a,y0:c,y1:o})];return new d.Selection({indices:_})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,[r,a]=this.renderer.xscale.r_invert(t,s),[c,o]=this.renderer.yscale.r_invert(i,n),_=[...this.index.indices({x0:r,x1:a,y0:c,y1:o})];return new d.Selection({indices:_})}_hit_poly(e){const{sx:t,sy:s}=e,i=(()=>{const e=this.renderer.xscale.v_invert(t),i=this.renderer.yscale.v_invert(s),[n,r,a,c]=(0,x.minmax2)(e,i);return this.index.indices({x0:n,x1:r,y0:a,y1:c})})(),n=[];for(const e of i)_.point_in_poly(this.sx[e],this.sy[e],t,s)&&n.push(e);return new d.Selection({indices:n})}_get_legend_args({x0:e,x1:t,y0:s,y1:i},n){const r=n+1,a=new Array(r),c=new Array(r);a[n]=(e+t)/2,c[n]=(s+i)/2;const o=.4*Math.min(Math.abs(t-e),Math.abs(i-s));return{sx:a,sy:c,size:new h.UniformScalar(o,r),angle:new h.UniformScalar(0,r)}}draw_legend_for_index(e,{x0:t,x1:s,y0:i,y1:n},r){const a=this._get_legend_args({x0:t,x1:s,y0:i,y1:n},r);this._render(e,[r],a)}}s.MarkerView=l,l.__name__="MarkerView";class y extends c.XYGlyph{constructor(e){super(e)}}s.Marker=y,r=y,y.__name__="Marker",r.mixins([o.LineVector,o.FillVector,o.HatchVector]),r.define((({Float:e})=>({size:[h.ScreenSizeSpec,{value:4}],angle:[h.AngleSpec,0],hit_dilation:[e,1]})))},
function _(l,n,o,i,a){i();const t=Math.sqrt(3),e=Math.sqrt(5),p=(e+1)/4,c=Math.sqrt((5-e)/8),h=(e-1)/4,u=Math.sqrt((5+e)/8);function f(l,n){l.rotate(Math.PI/4),y(l,n),l.rotate(-Math.PI/4)}function r(l,n){const o=n*t,i=o/3;l.moveTo(-o/2,-i),l.lineTo(0,0),l.lineTo(o/2,-i),l.lineTo(0,0),l.lineTo(0,n)}function y(l,n){l.moveTo(0,n),l.lineTo(0,-n),l.moveTo(-n,0),l.lineTo(n,0)}function T(l,n){l.moveTo(0,n),l.lineTo(n/1.5,0),l.lineTo(0,-n),l.lineTo(-n/1.5,0),l.closePath()}function s(l,n){const o=n*t,i=o/3;l.moveTo(-n,i),l.lineTo(n,i),l.lineTo(0,i-o),l.closePath()}function v(l,n,o,i){l.arc(0,0,o,0,2*Math.PI,!1),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function d(l,n,o,i){T(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function P(l,n,o,i){!function(l,n){l.beginPath(),l.arc(0,0,n/4,0,2*Math.PI,!1),l.closePath()}(l,o),i.line.set_vectorize(l,n),l.fillStyle=l.strokeStyle,l.fill()}function m(l,n,o,i){!function(l,n){const o=n/2,i=t*o;l.moveTo(n,0),l.lineTo(o,-i),l.lineTo(-o,-i),l.lineTo(-n,0),l.lineTo(-o,i),l.lineTo(o,i),l.closePath()}(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function _(l,n,o,i){const a=2*o;l.rect(-o,-o,a,a),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function q(l,n,o,i){!function(l,n){const o=Math.sqrt(5-2*e)*n;l.moveTo(0,-n),l.lineTo(o*h,o*u-n),l.lineTo(o*(1+h),o*u-n),l.lineTo(o*(1+h-p),o*(u+c)-n),l.lineTo(o*(1+2*h-p),o*(2*u+c)-n),l.lineTo(0,2*o*u-n),l.lineTo(-o*(1+2*h-p),o*(2*u+c)-n),l.lineTo(-o*(1+h-p),o*(u+c)-n),l.lineTo(-o*(1+h),o*u-n),l.lineTo(-o*h,o*u-n),l.closePath()}(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function M(l,n,o,i){s(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}o.marker_funcs={asterisk:function(l,n,o,i){y(l,o),f(l,o),i.line.apply(l,n)},circle:v,circle_cross:function(l,n,o,i){l.arc(0,0,o,0,2*Math.PI,!1),i.fill.apply(l,n),i.hatch.apply(l,n),y(l,o),i.line.apply(l,n)},circle_dot:function(l,n,o,i){v(l,n,o,i),P(l,n,o,i)},circle_y:function(l,n,o,i){l.arc(0,0,o,0,2*Math.PI,!1),i.fill.apply(l,n),i.hatch.apply(l,n),r(l,o),i.line.apply(l,n)},circle_x:function(l,n,o,i){l.arc(0,0,o,0,2*Math.PI,!1),i.fill.apply(l,n),i.hatch.apply(l,n),f(l,o),i.line.apply(l,n)},cross:function(l,n,o,i){y(l,o),i.line.apply(l,n)},diamond:d,diamond_dot:function(l,n,o,i){d(l,n,o,i),P(l,n,o,i)},diamond_cross:function(l,n,o,i){T(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),l.moveTo(0,o),l.lineTo(0,-o),l.moveTo(-o/1.5,0),l.lineTo(o/1.5,0),i.line.apply(l,n)},dot:P,hex:m,hex_dot:function(l,n,o,i){m(l,n,o,i),P(l,n,o,i)},inverted_triangle:function(l,n,o,i){l.rotate(Math.PI),s(l,o),l.rotate(-Math.PI),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)},plus:function(l,n,o,i){const a=3*o/8,t=[a,a,o,o,a,a,-a,-a,-o,-o,-a,-a],e=[o,a,a,-a,-a,-o,-o,-a,-a,a,a,o];l.beginPath();for(let n=0;n<12;n++)l.lineTo(t[n],e[n]);l.closePath(),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)},square:_,square_cross:function(l,n,o,i){const a=2*o;l.rect(-o,-o,a,a),i.fill.apply(l,n),i.hatch.apply(l,n),y(l,o),i.line.apply(l,n)},square_dot:function(l,n,o,i){_(l,n,o,i),P(l,n,o,i)},square_pin:function(l,n,o,i){const a=3*o/8;l.moveTo(-o,-o),l.quadraticCurveTo(0,-a,o,-o),l.quadraticCurveTo(a,0,o,o),l.quadraticCurveTo(0,a,-o,o),l.quadraticCurveTo(-a,0,-o,-o),l.closePath(),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)},square_x:function(l,n,o,i){const a=2*o;l.rect(-o,-o,a,a),i.fill.apply(l,n),i.hatch.apply(l,n),l.moveTo(-o,o),l.lineTo(o,-o),l.moveTo(-o,-o),l.lineTo(o,o),i.line.apply(l,n)},star:q,star_dot:function(l,n,o,i){q(l,n,o,i),P(l,n,o,i)},triangle:M,triangle_dot:function(l,n,o,i){M(l,n,o,i),P(l,n,o,i)},triangle_pin:function(l,n,o,i){const a=o*t,e=a/3,p=3*e/8;l.moveTo(-o,e),l.quadraticCurveTo(0,p,o,e),l.quadraticCurveTo(t*p/2,p/2,0,e-a),l.quadraticCurveTo(-t*p/2,p/2,-o,e),l.closePath(),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)},dash:function(l,n,o,i){!function(l,n){l.moveTo(-n,0),l.lineTo(n,0)}(l,o),i.line.apply(l,n)},x:function(l,n,o,i){f(l,o),i.line.apply(l,n)},y:function(l,n,o,i){r(l,o),i.line.apply(l,n)}}},
function _(e,t,s,i,n){var r;i();const o=e(1),a=o.__importStar(e(225)),d=o.__importStar(e(18)),h=e(85),c=e(131),_=e(11),x=e(218),l=e(224),y=e(127);class p extends x.GlyphView{_project_data(){c.inplace.project_xy(this.x0,this.y0),c.inplace.project_xy(this.x1,this.y1)}_index_data(e){const{min:t,max:s}=Math,{x0:i,x1:n,y0:r,y1:o,data_size:a}=this;for(let d=0;d<a;d++){const a=i[d],h=n[d],c=r[d],_=o[d];e.add_rect(t(a,h),t(c,_),s(a,h),s(c,_))}}_render(e,t,s){if(!this.visuals.line.doit)return;const{sx0:i,sy0:n,sx1:r,sy1:o}={...this,...s};for(const s of t){const t=i[s],a=n[s],d=r[s],h=o[s];isFinite(t+a+d+h)&&(this._render_decorations(e,s,t,a,d,h),e.beginPath(),e.moveTo(t,a),e.lineTo(d,h),this.visuals.line.apply(e,s))}}_render_decorations(e,t,s,i,n,r){const{PI:o}=Math,a=(0,_.atan2)([s,i],[n,r])+o/2;for(const d of this.decorations.values())e.save(),"start"==d.model.node?(e.translate(s,i),e.rotate(a+o)):"end"==d.model.node&&(e.translate(n,r),e.rotate(a)),d.marking.render(e,t),e.restore()}_hit_point(e){const{sx:t,sy:s}=e,i={x:t,y:s},[n,r]=this.renderer.xscale.r_invert(t-2,t+2),[o,d]=this.renderer.yscale.r_invert(s-2,s+2),h=this.index.indices({x0:n,y0:o,x1:r,y1:d}),c=[];for(const e of h){const t=Math.max(2,this.line_width.get(e)/2)**2,s={x:this.sx0[e],y:this.sy0[e]},n={x:this.sx1[e],y:this.sy1[e]};a.dist_to_segment_squared(i,s,n)<t&&c.push(e)}return new y.Selection({indices:c})}_hit_span(e){const[t,s]=this.renderer.plot_view.frame.bbox.ranges,{sx:i,sy:n}=e;let r,o,a;"v"==e.direction?(a=this.renderer.yscale.invert(n),[r,o]=[this.y0,this.y1]):(a=this.renderer.xscale.invert(i),[r,o]=[this.x0,this.x1]);const d=[],[h,c]=this.renderer.xscale.r_invert(t.start,t.end),[_,x]=this.renderer.yscale.r_invert(s.start,s.end),l=this.index.indices({x0:h,y0:_,x1:c,y1:x});for(const t of l){(r[t]<=a&&a<=o[t]||o[t]<=a&&a<=r[t])&&d.push(t);const s=1.5+this.line_width.get(t)/2;r[t]==o[t]&&("h"==e.direction?Math.abs(this.sx0[t]-i)<=s&&d.push(t):Math.abs(this.sy0[t]-n)<=s&&d.push(t))}return new y.Selection({indices:d})}scenterxy(e){return[this.sx0[e]/2+this.sx1[e]/2,this.sy0[e]/2+this.sy1[e]/2]}draw_legend_for_index(e,t,s){(0,l.generic_line_vector_legend)(this.visuals,e,t,s)}}s.SegmentView=p,p.__name__="SegmentView";class f extends x.Glyph{constructor(e){super(e)}}s.Segment=f,r=f,f.__name__="Segment",r.prototype.default_view=p,r.define((({})=>({x0:[d.XCoordinateSpec,{field:"x0"}],y0:[d.YCoordinateSpec,{field:"y0"}],x1:[d.XCoordinateSpec,{field:"x1"}],y1:[d.YCoordinateSpec,{field:"y1"}]}))),r.mixins(h.LineVector)},
function _(t,e,s,i,n){var _;i();const o=t(1),l=t(217),a=o.__importStar(t(85)),r=t(379);class c extends l.XYGlyphView{_set_data(){const{tension:t,closed:e}=this.model,[s,i]=(0,r.catmullrom_spline)(this.x,this.y,20,t,e);this._define_attr("xt",s),this._define_attr("yt",i)}_map_data(){const{x_scale:t,y_scale:e}=this.renderer.coordinates,s=t.v_compute(this.xt),i=e.v_compute(this.yt);this._define_attr("sxt",s),this._define_attr("syt",i)}_render(t,e,s){const{sxt:i,syt:n}={...this,...s};let _=!0;t.beginPath();const o=i.length;for(let e=0;e<o;e++){const s=i[e],o=n[e];isFinite(s+o)?_?(t.moveTo(s,o),_=!1):t.lineTo(s,o):_=!0}this.visuals.line.set_value(t),t.stroke()}}s.SplineView=c,c.__name__="SplineView";class d extends l.XYGlyph{constructor(t){super(t)}}s.Spline=d,_=d,d.__name__="Spline",_.prototype.default_view=c,_.mixins(a.LineScalar),_.define((({Bool:t,Float:e})=>({tension:[e,.5],closed:[t,!1]})))},
function _(n,t,e,o,s){o();const c=n(24),l=n(12);e.catmullrom_spline=function(n,t,e=10,o=.5,s=!1){(0,l.assert)(n.length==t.length);const r=n.length,f=s?r+1:r,w=(0,c.infer_type)(n,t),i=new w(f+2),u=new w(f+2);i.set(n,1),u.set(t,1),s?(i[0]=n[r-1],u[0]=t[r-1],i[f]=n[0],u[f]=t[0],i[f+1]=n[1],u[f+1]=t[1]):(i[0]=n[0],u[0]=t[0],i[f+1]=n[r-1],u[f+1]=t[r-1]);const g=new w(4*(e+1));for(let n=0,t=0;n<=e;n++){const o=n/e,s=o**2,c=o*s;g[t++]=2*c-3*s+1,g[t++]=-2*c+3*s,g[t++]=c-2*s+o,g[t++]=c-s}const h=new w((f-1)*(e+1)),_=new w((f-1)*(e+1));for(let n=1,t=0;n<f;n++){const s=(i[n+1]-i[n-1])*o,c=(u[n+1]-u[n-1])*o,l=(i[n+2]-i[n])*o,r=(u[n+2]-u[n])*o;for(let o=0;o<=4*e;t++){const e=g[o++],f=g[o++],w=g[o++],a=g[o++];h[t]=e*i[n]+f*i[n+1]+w*s+a*l,_[t]=e*u[n]+f*u[n+1]+w*c+a*r}}return[h,_]}},
function _(e,t,r,n,s){var i;n();const _=e(1),a=e(217),o=e(224),l=_.__importStar(e(85)),d=e(20),c=e(12);class h extends a.XYGlyphView{async load_glglyph(){const{StepGL:t}=await Promise.resolve().then((()=>_.__importStar(e(564))));return t}_render(e,t,r){const n=t.length;if(n<2)return;const{sx:s,sy:i}={...this,...r},_=this.model.mode;this.visuals.line.set_value(e);let a=!1,o=!1;const l=t[0];let d=isFinite(s[l]+i[l]);"center"==_&&(a=this._render_xy(e,a,d?s[l]:NaN,i[l]));for(const r of t){const t=isFinite(s[r+1]+i[r+1]);switch(_){case"before":a=this._render_xy(e,a,d?s[r]:NaN,i[r]),r<s.length-1&&(a=this._render_xy(e,a,d&&t?s[r]:NaN,i[r+1]));break;case"after":a=this._render_xy(e,a,d?s[r]:NaN,i[r]),r<s.length-1&&(a=this._render_xy(e,a,d&&t?s[r+1]:NaN,i[r]));break;case"center":if(d&&t){const t=(s[r]+s[r+1])/2;a=this._render_xy(e,a,t,i[r]),a=this._render_xy(e,a,t,i[r+1])}else o&&(a=this._render_xy(e,a,d?s[r]:NaN,i[r])),a=this._render_xy(e,a,t?s[r+1]:NaN,i[r+1]);break;default:(0,c.unreachable)()}o=d,d=t}if(a){const r=t[n-1];this._render_xy(e,a,d?s[r]:NaN,i[r])&&e.stroke()}}_render_xy(e,t,r,n){return isFinite(r+n)?t?e.lineTo(r,n):(e.beginPath(),e.moveTo(r,n),t=!0):t&&(e.stroke(),t=!1),t}draw_legend_for_index(e,t,r){(0,o.generic_line_scalar_legend)(this.visuals,e,t)}}r.StepView=h,h.__name__="StepView";class y extends a.XYGlyph{constructor(e){super(e)}}r.Step=y,i=y,y.__name__="Step",i.prototype.default_view=h,i.mixins(l.LineScalar),i.define((()=>({mode:[d.StepMode,"before"]})))},
function _(e,t,n,i,l){var s;i();const a=e(365),o=e(175),r=e(21),c=e(174),_=(0,r.Or)((0,r.Enum)("inline","block"),r.Auto);class p extends a.MathTextGlyphView{_build_label(e){const{macros:t,display:n}=this.model;if("auto"==n){const n=(0,c.parse_delimited_string)(e);return n instanceof o.TeX&&(n.macros=t),n}return new o.TeX({text:e,macros:t,inline:"inline"==n})}}n.TeXGlyphView=p,p.__name__="TeXGlyphView";class u extends a.MathTextGlyph{constructor(e){super(e)}}n.TeXGlyph=u,s=u,u.__name__="TeXGlyph",s.prototype.default_view=p,s.define((({Float:e,Str:t,Dict:n,Tuple:i,Or:l})=>({macros:[n(l(t,i(t,e))),{}],display:[_,"auto"]})))},
function _(t,e,i,s,r){var h;s();const n=t(1),a=t(351),_=t(24),o=n.__importStar(t(18));class d extends a.LRTBView{scenterxy(t){return[this.sx[t],(this.stop[t]+this.sbottom[t])/2]}_lrtb(t){const e=this.width.get(t)/2,i=this.x[t],s=this.top[t],r=this.bottom[t];return{l:i-e,r:i+e,t:Math.max(s,r),b:Math.min(s,r)}}_map_data(){if(this.inherited_x&&this.inherited_width)this._inherit_attr("swidth"),this._inherit_attr("sleft"),this._inherit_attr("sright");else{const t=this.sdist(this.renderer.xscale,this.x,this.width,"center"),{sx:e}=this,i=e.length,s=new _.ScreenArray(i),r=new _.ScreenArray(i);for(let h=0;h<i;h++){const i=e[h],n=t[h];s[h]=i-n/2,r[h]=i+n/2}this._define_attr("swidth",t),this._define_attr("sleft",s),this._define_attr("sright",r)}this._clamp_to_viewport()}}i.VBarView=d,d.__name__="VBarView";class c extends a.LRTB{constructor(t){super(t)}}i.VBar=c,h=c,c.__name__="VBar",h.prototype.default_view=d,h.define((({})=>({x:[o.XCoordinateSpec,{field:"x"}],bottom:[o.YCoordinateSpec,{value:0}],width:[o.DistanceSpec,{value:1}],top:[o.YCoordinateSpec,{field:"top"}]})))},
function _(t,e,n,i,s){var _;i();const r=t(1),a=t(218),o=t(224),d=t(127),c=t(85),h=r.__importStar(t(39)),x=t(13),p=t(10),l=r.__importStar(t(18)),{abs:u,max:f}=Math;class m extends a.GlyphView{after_visuals(){super.after_visuals(),this.max_line_width=h.max(this.line_width)}_index_data(t){for(const e of this.x)t.add_point(e,0)}_bounds(t){const{x0:e,x1:n}=t;return{x0:e,x1:n,y0:NaN,y1:NaN}}_map_data(){super._map_data();const{round:t}=Math;if(!this.inherited_sx){const e=(0,x.map)(this.sx,(e=>t(e)));this._define_attr("sx",e)}}scenterxy(t){const{vcenter:e}=this.renderer.plot_view.frame.bbox;return[this.sx[t],e]}_render(t,e,n){const{sx:i}={...this,...n},{top:s,bottom:_}=this.renderer.plot_view.frame.bbox;for(const n of e){const e=i[n];isFinite(e)&&(t.beginPath(),t.moveTo(e,s),t.lineTo(e,_),this.visuals.line.apply(t,n))}}_get_candidates(t,e){const{max_line_width:n}=this,[i,s]=this.renderer.xscale.r_invert(t-n,(e??t)+n);return this.index.indices({x0:i,x1:s,y0:0,y1:0})}_find_spans(t,e){const{sx:n,line_width:i}=this,s=[];for(const _ of t){e(n[_],i.get(_))&&s.push(_)}return s}_hit_point(t){const{sx:e}=t,n=this._get_candidates(e),i=this._find_spans(n,((t,n)=>u(t-e)<=f(n,2)));return new d.Selection({indices:i})}_hit_span(t){const e=(()=>{if("h"==t.direction)return(0,p.range)(0,this.data_size);{const{sx:e}=t,n=this._get_candidates(e);return this._find_spans(n,((t,n)=>u(t-e)<=f(n/2,2)))}})();return new d.Selection({indices:e})}_hit_rect(t){const e=(()=>{const{sx0:e,sx1:n}=t,i=this._get_candidates(e,n);return this._find_spans(i,((t,i)=>e-i/2<=t&&t<=n+i/2))})();return new d.Selection({indices:e})}draw_legend_for_index(t,e,n){(0,o.generic_line_vector_legend)(this.visuals,t,e,n)}}n.VSpanView=m,m.__name__="VSpanView";class w extends a.Glyph{constructor(t){super(t)}}n.VSpan=w,_=w,w.__name__="VSpan",_.prototype.default_view=m,_.mixins([c.LineVector]),_.define((()=>({x:[l.XCoordinateSpec,{field:"x"}]})))},
function _(t,e,i,s,r){var n;s();const a=t(1),_=t(218),o=t(224),h=t(127),c=t(85),d=t(24),l=t(13),x=a.__importStar(t(34)),p=t(10),f=a.__importStar(t(18));class u extends _.GlyphView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e&&e.regl_wrapper.has_webgl){const{LRTBGL:i}=await Promise.resolve().then((()=>a.__importStar(t(560))));this.glglyph=new i(e.regl_wrapper,this)}}get sleft(){return this.sx0}get sright(){return this.sx1}get stop(){const{top:t}=this.renderer.plot_view.frame.bbox,e=this.data_size,i=new d.ScreenArray(e);return i.fill(t),i}get sbottom(){const{bottom:t}=this.renderer.plot_view.frame.bbox,e=this.data_size,i=new d.ScreenArray(e);return i.fill(t),i}_set_data(t){super._set_data(t);const{abs:e}=Math,{max:i,map:s,zip:r}=x,{x0:n,x1:a}=this;if(this.inherited_x0&&this.inherited_x1)this._inherit_attr("max_width");else{const t=i(s(r(n,a),(([t,i])=>e(t-i))));this._define_attr("max_width",t)}}_index_data(t){const{x0:e,x1:i,data_size:s}=this;for(let r=0;r<s;r++){const s=e[r],n=i[r];t.add_rect(s,0,n,0)}}_bounds(t){const{x0:e,x1:i}=t;return{x0:e,x1:i,y0:NaN,y1:NaN}}_map_data(){super._map_data();const{round:t}=Math;if(!this.inherited_sx0){const e=(0,l.map)(this.sx0,(e=>t(e)));this._define_attr("sx0",e)}if(!this.inherited_sx1){const e=(0,l.map)(this.sx1,(e=>t(e)));this._define_attr("sx1",e)}}scenterxy(t){const{vcenter:e}=this.renderer.plot_view.frame.bbox;return[(this.sx0[t]+this.sx1[t])/2,e]}_render(t,e,i){const{sx0:s,sx1:r}={...this,...i},{top:n,bottom:a,height:_}=this.renderer.plot_view.frame.bbox;for(const i of e){const e=s[i],o=r[i];isFinite(e+o)&&(t.beginPath(),t.rect(e,n,o-e,_),this.visuals.fill.apply(t,i),this.visuals.hatch.apply(t,i),t.beginPath(),t.moveTo(e,n),t.lineTo(e,a),t.moveTo(o,n),t.lineTo(o,a),this.visuals.line.apply(t,i))}}_get_candidates(t,e){const{max_width:i}=this,[s,r]=this.renderer.xscale.r_invert(t,e??t),n=s-i,a=r+i;return this.index.indices({x0:n,x1:a,y0:0,y1:0})}_find_strips(t,e){function i(t,i){return t<=i?e(t,i):e(i,t)}const{sx0:s,sx1:r}=this,n=[];for(const e of t){i(s[e],r[e])&&n.push(e)}return n}_hit_point(t){const{sx:e}=t,i=this._get_candidates(e),s=this._find_strips(i,((t,i)=>t<=e&&e<=i));return new h.Selection({indices:s})}_hit_span(t){const e=(()=>{if("h"==t.direction)return(0,p.range)(0,this.data_size);{const{sx:e}=t,i=this._get_candidates(e);return this._find_strips(i,((t,i)=>t<=e&&e<=i))}})();return new h.Selection({indices:e})}_hit_rect(t){const e=(()=>{const{sx0:e,sx1:i}=t,s=this._get_candidates(e,i);return this._find_strips(s,((t,s)=>e<=t&&t<=i&&e<=s&&s<=i))})();return new h.Selection({indices:e})}draw_legend_for_index(t,e,i){(0,o.generic_area_vector_legend)(this.visuals,t,e,i)}}i.VStripView=u,u.__name__="VStripView";class w extends _.Glyph{constructor(t){super(t)}}i.VStrip=w,n=w,w.__name__="VStrip",n.prototype.default_view=u,n.mixins([c.LineVector,c.FillVector,c.HatchVector]),n.define((()=>({x0:[f.XCoordinateSpec,{field:"x0"}],x1:[f.XCoordinateSpec,{field:"x1"}]})))},
function _(e,t,s,i,r){var n;i();const a=e(1),h=e(217),d=e(218),_=e(224),c=e(85),l=e(24),o=e(20),g=a.__importStar(e(18)),u=e(11),p=e(127),x=e(13);class y extends h.XYGlyphView{async load_glglyph(){const{WedgeGL:t}=await Promise.resolve().then((()=>a.__importStar(e(565))));return t}_map_data(){this._define_or_inherit_attr("sradius",(()=>"data"==this.model.properties.radius.units?this.inherited_x&&this.inherited_radius?d.inherit:this.sdist(this.renderer.xscale,this.x,this.radius):this.inherited_radius?d.inherit:(0,l.to_screen)(this.radius))),this._define_or_inherit_attr("max_sradius",(()=>(0,x.max)(this.sradius)))}_render(e,t,s){const{sx:i,sy:r,sradius:n,start_angle:a,end_angle:h}={...this,...s},d="anticlock"==this.model.direction;for(const s of t){const t=i[s],_=r[s],c=n[s],l=a.get(s),o=h.get(s);isFinite(t+_+c+l+o)&&(e.beginPath(),e.arc(t,_,c,l,o,d),e.lineTo(t,_),e.closePath(),this.visuals.fill.apply(e,s),this.visuals.hatch.apply(e,s),this.visuals.line.apply(e,s))}}_hit_point(e){let t,s,i,r,n;const{sx:a,sy:h}=e,d=this.renderer.xscale.invert(a),_=this.renderer.yscale.invert(h);s=a-this.max_sradius,i=a+this.max_sradius;const[c,l]=this.renderer.xscale.r_invert(s,i);r=h-this.max_sradius,n=h+this.max_sradius;const[o,g]=this.renderer.yscale.r_invert(r,n),x=[];for(const e of this.index.indices({x0:c,x1:l,y0:o,y1:g})){const a=this.sradius[e]**2;[s,i]=this.renderer.xscale.r_compute(d,this.x[e]),[r,n]=this.renderer.yscale.r_compute(_,this.y[e]),t=(s-i)**2+(r-n)**2,t<=a&&x.push(e)}const y="anticlock"==this.model.direction,m=[];for(const e of x){const t=Math.atan2(h-this.sy[e],a-this.sx[e]);(Math.abs(this.start_angle.get(e)-this.end_angle.get(e))>=2*Math.PI||(0,u.angle_between)(-t,-this.start_angle.get(e),-this.end_angle.get(e),y))&&m.push(e)}return new p.Selection({indices:m})}draw_legend_for_index(e,t,s){(0,_.generic_area_vector_legend)(this.visuals,e,t,s)}scenterxy(e){const t=this.sradius[e]/2,s=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+t*Math.cos(s),this.sy[e]+t*Math.sin(s)]}}s.WedgeView=y,y.__name__="WedgeView";class m extends h.XYGlyph{constructor(e){super(e)}}s.Wedge=m,n=m,m.__name__="Wedge",n.prototype.default_view=y,n.mixins([c.LineVector,c.FillVector,c.HatchVector]),n.define((({})=>({direction:[o.Direction,"anticlock"],radius:[g.DistanceSpec,{field:"radius"}],start_angle:[g.AngleSpec,{field:"start_angle"}],end_angle:[g.AngleSpec,{field:"end_angle"}]})))},
function _(n,i,o,a,r){a(),r("Decoration",n(223).Decoration),r("Marking",n(166).Marking)},
function _(t,_,r,o,a){o();const e=t(1);e.__exportStar(t(388),r),e.__exportStar(t(389),r),e.__exportStar(t(390),r)},
function _(e,t,n,d,s){d();const o=e(51),r=e(13),i=e(10),_=e(9),c=e(127);class a extends o.Model{constructor(e){super(e)}_hit_test(e,t,n){if(!t.model.visible)return null;const d=n.glyph.hit_test(e);return null==d?null:n.model.view.convert_selection_from_subset(d)}}n.GraphHitTestPolicy=a,a.__name__="GraphHitTestPolicy";class l extends a{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.edge_view)}do_selection(e,t,n,d){if(null==e)return!1;const s=t.edge_renderer.data_source.selected;return s.update(e,n,d),t.edge_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const{edge_renderer:o}=n.model,r=o.get_selection_manager().get_or_create_inspector(n.edge_view.model);return r.update(e,d,s),n.edge_view.model.data_source.setv({inspected:r},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view.model,{geometry:t}]),!r.is_empty()}}n.EdgesOnly=l,l.__name__="EdgesOnly";class u extends a{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.node_view)}do_selection(e,t,n,d){if(null==e)return!1;const s=t.node_renderer.data_source.selected;return s.update(e,n,d),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const{node_renderer:o}=n.model,r=o.get_selection_manager().get_or_create_inspector(n.node_view.model);return r.update(e,d,s),n.node_view.model.data_source.setv({inspected:r},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view.model,{geometry:t}]),!r.is_empty()}}n.NodesOnly=u,u.__name__="NodesOnly";class m extends a{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.node_view)}get_linked_edges(e,t,n){const d=(0,_.dict)(e.data).get("index")??[],s=(()=>{switch(n){case"selection":return(0,r.map)(e.selected.indices,(e=>d[e]));case"inspection":return(0,r.map)(e.inspected.indices,(e=>d[e]))}})(),o=(0,_.dict)(t.data),a=o.get("start")??[],l=o.get("end")??[],u=[],m=a.length;for(let e=0;e<m;e++)((0,i.contains)(s,a[e])||(0,i.contains)(s,l[e]))&&u.push(e);const p=new c.Selection;for(const e of u)p.multiline_indices.set(e,[0]);return p.indices=u,p}do_selection(e,t,n,d){if(null==e)return!1;const s=t.node_renderer.data_source.selected;s.update(e,n,d);const o=t.edge_renderer.data_source.selected,r=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(r,n,d),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model);o.update(e,d,s),n.node_view.model.data_source.setv({inspected:o},{silent:!0});const r=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model),i=this.get_linked_edges(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return r.update(i,d,s),n.edge_view.model.data_source.setv({inspected:r},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view.model,{geometry:t}]),!o.is_empty()}}n.NodesAndLinkedEdges=m,m.__name__="NodesAndLinkedEdges";class p extends a{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.edge_view)}get_linked_nodes(e,t,n){const d=(()=>{switch(n){case"selection":return t.selected.indices;case"inspection":return t.inspected.indices}})(),s=(0,_.dict)(t.data),o=s.get("start")??[],a=s.get("end")??[],l=[];for(const e of d)l.push(o[e],a[e]);const u=(0,_.dict)(e.data).get("index")??[],m=(0,i.uniq)(l).map((e=>(0,r.index_of)(u,e)));return new c.Selection({indices:m})}do_selection(e,t,n,d){if(null==e)return!1;const s=t.edge_renderer.data_source.selected;s.update(e,n,d);const o=t.node_renderer.data_source.selected,r=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(r,n,d),t.edge_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model);o.update(e,d,s),n.edge_view.model.data_source.setv({inspected:o},{silent:!0});const r=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model),i=this.get_linked_nodes(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return r.update(i,d,s),n.node_view.model.data_source.setv({inspected:r},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view.model,{geometry:t}]),!o.is_empty()}}n.EdgesAndLinkedNodes=p,p.__name__="EdgesAndLinkedNodes";class g extends a{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.node_view)}get_adjacent_nodes(e,t,n){const d=(0,_.dict)(e.data).get("index")??[],s=(()=>{switch(n){case"selection":return(0,r.map)(e.selected.indices,(e=>d[e]));case"inspection":return(0,r.map)(e.inspected.indices,(e=>d[e]))}})(),o=(0,_.dict)(t.data),a=o.get("start")??[],l=o.get("end")??[],u=[],m=[];for(let e=0;e<a.length;e++)(0,i.contains)(s,a[e])&&(u.push(l[e]),m.push(a[e])),(0,i.contains)(s,l[e])&&(u.push(a[e]),m.push(l[e]));for(let e=0;e<m.length;e++)u.push(m[e]);const p=(0,i.uniq)(u).map((e=>(0,r.index_of)(d,e)));return new c.Selection({indices:p})}do_selection(e,t,n,d){if(null==e)return!1;const s=t.node_renderer.data_source.selected;s.update(e,n,d);const o=this.get_adjacent_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.is_empty()||s.update(o,n,d),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model);o.update(e,d,s),n.node_view.model.data_source.setv({inspected:o},{silent:!0});const r=this.get_adjacent_nodes(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return r.is_empty()||(o.update(r,d,s),n.node_view.model.data_source.setv({inspected:o},{silent:!0})),n.node_view.model.data_source.inspect.emit([n.node_view.model,{geometry:t}]),!o.is_empty()}}n.NodesAndAdjacentNodes=g,g.__name__="NodesAndAdjacentNodes"},
function _(e,o,t,r,n){var s;r();const a=e(51),d=e(333);class _ extends a.Model{constructor(e){super(e)}get node_coordinates(){return new u({layout:this})}get edge_coordinates(){return new i({layout:this})}}t.LayoutProvider=_,_.__name__="LayoutProvider";class c extends d.CoordinateTransform{constructor(e){super(e)}}t.GraphCoordinates=c,s=c,c.__name__="GraphCoordinates",s.define((({Ref:e})=>({layout:[e(_)]})));class u extends c{constructor(e){super(e)}_v_compute(e){const[o,t]=this.layout.get_node_coordinates(e);return{x:o,y:t}}}t.NodeCoordinates=u,u.__name__="NodeCoordinates";class i extends c{constructor(e){super(e)}_v_compute(e){const[o,t]=this.layout.get_edge_coordinates(e);return{x:o,y:t}}}t.EdgeCoordinates=i,i.__name__="EdgeCoordinates"},
function _(t,a,e,r,o){var n;r();const s=t(389),i=t(9),l=t(21);e.GraphLayout=(0,l.Or)((0,l.Dict)((0,l.Arrayable)(l.Float)),(0,l.Mapping)((0,l.Or)(l.Int,l.Str),(0,l.Arrayable)(l.Float)));class c extends s.LayoutProvider{constructor(t){super(t)}get_node_coordinates(t){const a=(0,i.dict)(t.data).get("index")??[],e=a.length,r=new Float64Array(e),o=new Float64Array(e),n=(0,i.dict)(this.graph_layout);for(let t=0;t<e;t++){const e=a[t],[s,i]=n.get(e)??[NaN,NaN];r[t]=s,o[t]=i}return[r,o]}get_edge_coordinates(t){const a=(0,i.dict)(t.data),e=a.get("start")??[],r=a.get("end")??[],o=Math.min(e.length,r.length),n=[],s=[],l=a.get("xs"),c=a.get("ys"),u=null!=l&&null!=c,g=(0,i.dict)(this.graph_layout);for(let t=0;t<o;t++){const a=g.has(e[t])&&g.has(r[t]);if(u&&a)n.push(l[t]),s.push(c[t]);else{const a=g.get(e[t])??[NaN,NaN],o=g.get(r[t])??[NaN,NaN];n.push([a[0],o[0]]),s.push([a[1],o[1]])}}return[n,s]}}e.StaticLayoutProvider=c,n=c,c.__name__="StaticLayoutProvider",n.define((()=>({graph_layout:[e.GraphLayout,new Map]})))},
function _(i,d,n,r,G){r(),G("Grid",i(392).Grid)},
function _(i,e,s,n,t){var r;n();const o=i(1),d=i(262),a=i(187),_=i(188),l=o.__importStar(i(85)),h=i(8);class u extends a.GuideRendererView{_render(){const i=this.layer.ctx;i.save(),this._draw_regions(i),this._draw_minor_grids(i),this._draw_grids(i),i.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_draw_regions(i){if(!this.visuals.band_fill.doit&&!this.visuals.band_hatch.doit)return;const[e,s]=this.grid_coords("major",!1);for(let n=0;n<e.length-1;n++){if(n%2!=1)continue;const[t,r]=this.coordinates.map_to_screen(e[n],s[n]),[o,d]=this.coordinates.map_to_screen(e[n+1],s[n+1]);i.beginPath(),i.rect(t[0],r[0],o[1]-t[0],d[1]-r[0]),this.visuals.band_fill.apply(i),this.visuals.band_hatch.apply(i)}}_draw_grids(i){if(!this.visuals.grid_line.doit)return;const[e,s]=this.grid_coords("major");this._draw_grid_helper(i,this.visuals.grid_line,e,s)}_draw_minor_grids(i){if(!this.visuals.minor_grid_line.doit)return;const[e,s]=this.grid_coords("minor");this._draw_grid_helper(i,this.visuals.minor_grid_line,e,s)}_draw_grid_helper(i,e,s,n){e.set_value(i),i.beginPath();for(let e=0;e<s.length;e++){const[t,r]=this.coordinates.map_to_screen(s[e],n[e]);i.moveTo(Math.round(t[0]),Math.round(r[0]));for(let e=1;e<t.length;e++)i.lineTo(Math.round(t[e]),Math.round(r[e]))}i.stroke()}ranges(){const i=this.model.dimension,e=1-i,{ranges:s}=this.coordinates;return[s[i],s[e]]}computed_bounds(){const[i]=this.ranges(),e=this.model.bounds,s=[i.min,i.max];let n,t;if((0,h.isArray)(e))n=Math.min(e[0],e[1]),t=Math.max(e[0],e[1]),n<s[0]&&(n=s[0]),t>s[1]&&(t=s[1]);else{[n,t]=s;for(const i of this.plot_view.axis_views)i.dimension==this.model.dimension&&i.model.x_range_name==this.model.x_range_name&&i.model.y_range_name==this.model.y_range_name&&([n,t]=i.computed_bounds)}return[n,t]}grid_coords(i,e=!0){const s=this.model.dimension,n=1-s,[t,r]=this.ranges(),[o,d]=(()=>{const[i,e]=this.computed_bounds();return[Math.min(i,e),Math.max(i,e)]})(),a=[[],[]],_=this.model.get_ticker();if(null==_)return a;const l=_.get_ticks(o,d,t,r.min)[i],h=t.min,u=t.max,[c,m]=(()=>{const{cross_bounds:i}=this.model;return"auto"==i?[r.min,r.max]:i})();e||(l[0]!=h&&l.splice(0,0,h),l[l.length-1]!=u&&l.push(u));for(let i=0;i<l.length;i++){if((l[i]==h||l[i]==u)&&e)continue;const t=[],r=[],o=2;for(let e=0;e<o;e++){const s=c+(m-c)/(o-1)*e;t.push(l[i]),r.push(s)}a[s].push(t),a[n].push(r)}return a}}s.GridView=u,u.__name__="GridView";class c extends a.GuideRenderer{constructor(i){super(i)}get_ticker(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null}}s.Grid=c,r=c,c.__name__="Grid",r.prototype.default_view=u,r.mixins([["grid_",l.Line],["minor_grid_",l.Line],["band_",l.Fill],["band_",l.Hatch]]),r.define((({Float:i,Auto:e,Enum:s,Ref:n,Tuple:t,Or:r,Nullable:o})=>({bounds:[r(t(i,i),e),"auto"],cross_bounds:[r(t(i,i),e),"auto"],dimension:[s(0,1),0],axis:[o(n(d.Axis)),null],ticker:[o(n(_.Ticker)),null]}))),r.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})},
function _(o,x,B,a,l){a(),l("Column",o(394).Column),l("FlexBox",o(395).FlexBox),l("GridBox",o(400).GridBox),l("GroupBox",o(402).GroupBox),l("HBox",o(404).HBox),l("LayoutDOM",o(396).LayoutDOM),l("Row",o(405).Row),l("ScrollBox",o(406).ScrollBox),l("Spacer",o(407).Spacer),l("TabPanel",o(408).TabPanel),l("Tabs",o(412).Tabs),l("VBox",o(414).VBox)},
function _(e,o,n,t,s){var u;t();const _=e(395);class c extends _.FlexBoxView{constructor(){super(...arguments),this._direction="column"}}n.ColumnView=c,c.__name__="ColumnView";class l extends _.FlexBox{constructor(e){super(e)}}n.Column=l,u=l,l.__name__="Column",u.prototype.default_view=c},
function _(t,e,i,o,s){var n;o();const a=t(396),c=t(399),l=t(255),r=t(107),h=t(63);class d extends a.LayoutDOMView{connect_signals(){super.connect_signals();const{children:t}=this.model.properties;this.on_change(t,(()=>this.update_children()))}get child_models(){return this.model.children}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"flex"}}_update_layout(){super._update_layout(),this.style.append(":host",{flex_direction:this._direction,gap:(0,h.px)(this.model.spacing)});const t=new l.Container;let e=0,i=0;for(const o of this.child_views){if(!(o instanceof a.LayoutDOMView))continue;const s=o.box_sizing(),n=(()=>{const t="row"==this._direction?s.width_policy:s.height_policy,e="row"==this._direction?s.width:s.height,i=null!=e?(0,h.px)(e):"auto";switch(t){case"auto":case"fixed":return`0 0 ${i}`;case"fit":return"1 1 auto";case"min":return"0 1 auto";case"max":return"1 0 0px"}})(),c=(()=>{switch("row"==this._direction?s.height_policy:s.width_policy){case"auto":case"fixed":case"fit":case"min":return"row"==this._direction?s.valign:s.halign;case"max":return"stretch"}})();o.style.append(":host",{flex:n,align_self:c}),"row"==this._direction?"max"==s.height_policy&&o.style.append(":host",{height:"auto"}):"max"==s.width_policy&&o.style.append(":host",{width:"auto"}),null!=o.layout&&(t.add({r0:e,c0:i,r1:e+1,c1:i+1},o),"row"==this._direction?i+=1:e+=1)}0!=t.size?(this.layout=new c.GridAlignmentLayout(t),this.layout.set_sizing()):delete this.layout}}i.FlexBoxView=d,d.__name__="FlexBoxView";class _ extends a.LayoutDOM{constructor(t){super(t)}}i.FlexBox=_,n=_,_.__name__="FlexBox",n.define((({Float:t,List:e,Ref:i})=>({children:[e(i(r.UIElement)),[]],spacing:[t,0]})))},
function _(t,e,i,s,a){var l;s();const o=t(397),n=t(19),r=t(15),h=t(20),u=t(63),_=t(8),d=t(56),c=t(253),f=t(16),p=t(110),m=t(12);class w extends o.PaneView{constructor(){super(...arguments),this._child_views=new Map,this.mouseenter=new r.Signal(this,"mouseenter"),this.mouseleave=new r.Signal(this,"mouseleave"),this.disabled=new r.Signal(this,"disabled"),this._resized=!1,this._auto_width="fit-content",this._auto_height="fit-content",this._layout_computed=!1,this._was_built=!1}get is_layout_root(){return this.is_root||!(this.parent instanceof w)}_after_resize(){this._resized=!0,super._after_resize(),this.is_layout_root&&!this._was_built?(n.logger.warn(`${this} wasn't built properly`),this.render_to(null)):this.compute_layout()}async lazy_initialize(){await super.lazy_initialize(),await this.build_child_views()}remove(){for(const t of this.child_views)t.remove();this._child_views.clear(),super.remove()}connect_signals(){super.connect_signals(),this.el.addEventListener("mouseenter",(t=>{this.mouseenter.emit(t)})),this.el.addEventListener("mouseleave",(t=>{this.mouseleave.emit(t)})),this.parent instanceof w&&this.connect(this.parent.disabled,(t=>{this.disabled.emit(t||this.model.disabled)}));const t=this.model.properties;this.on_change(t.disabled,(()=>{this.disabled.emit(this.model.disabled)})),this.on_change([t.css_classes,t.stylesheets,t.width,t.height,t.min_width,t.min_height,t.max_width,t.max_height,t.margin,t.width_policy,t.height_policy,t.flow_mode,t.sizing_mode,t.aspect_ratio,t.visible],(()=>this.invalidate_layout()))}*children(){yield*super.children(),yield*this.child_views}get child_views(){return this.child_models.map((t=>this._child_views.get(t))).filter(_.isNotNull)}get layoutable_views(){return this.child_views.filter((t=>t instanceof w))}async build_child_views(){const{created:t,removed:e}=await(0,d.build_views)(this._child_views,this.child_models,{parent:this});for(const t of e)this._resize_observer.unobserve(t.el);for(const e of t)this._resize_observer.observe(e.el,{box:"border-box"});return t}render(){super.render();for(const t of this.child_views)t.render(),this.shadow_el.appendChild(t.el)}_update_children(){}async update_children(){const t=new Set(await this.build_child_views());if(0!=t.size){for(const t of this.child_views)t.el.remove();for(const e of this.child_views){t.has(e)?e.render_to(this.shadow_el):this.shadow_el.append(e.el)}}this._update_children(),this.invalidate_layout()}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"flow"}}_update_layout(){function t(t,e,i,s){switch(t){case"auto":return null!=e?(0,u.px)(e):i;case"fixed":return null!=e?(0,u.px)(e):"fit-content";case"fit":return"fit-content";case"min":return"min-content";case"max":return null==s?"100%":`calc(100% - ${s})`}}function e(t){return(0,_.isNumber)(t)?(0,u.px)(t):`${t.percent}%`}const i={},s=this._intrinsic_display();i.display=function(t){const{inner:e,outer:i}=t;switch(`${e} ${i}`){case"block flow":return"block";case"inline flow":return"inline";case"block flow-root":return"flow-root";case"inline flow-root":return"inline-block";case"block flex":return"flex";case"inline flex":return"inline-flex";case"block grid":return"grid";case"inline grid":return"inline-grid";case"block table":return"table";case"inline table":return"inline-table";default:(0,m.unreachable)()}}(s);const a=this.box_sizing(),{width_policy:l,height_policy:o,width:n,height:r,aspect_ratio:h}=a,d=(()=>{if("auto"==h){if(null!=n&&null!=r)return n/r}else if((0,_.isNumber)(h))return h;return null})();"auto"==h?i.aspect_ratio=null!=n&&null!=r?`${n} / ${r}`:"auto":(0,_.isNumber)(h)&&(i.aspect_ratio=`${h}`);const{margin:c}=this.model,f=(()=>{if(null!=c){if((0,_.isNumber)(c))return i.margin=(0,u.px)(c),{width:(0,u.px)(2*c),height:(0,u.px)(2*c)};if(2==c.length){const[t,e]=c;return i.margin=`${(0,u.px)(t)} ${(0,u.px)(e)}`,{width:(0,u.px)(2*e),height:(0,u.px)(2*t)}}{const[t,e,s,a]=c;return i.margin=`${(0,u.px)(t)} ${(0,u.px)(e)} ${(0,u.px)(s)} ${(0,u.px)(a)}`,{width:(0,u.px)(a+e),height:(0,u.px)(t+s)}}}return{width:null,height:null}})(),[p,w]=(()=>{const e=t(l,n,this._auto_width,f.width),i=t(o,r,this._auto_height,f.height);if(null!=h){if(l!=o)return"fixed"==l?[e,"auto"]:"fixed"==o?["auto",i]:"max"==l?[e,"auto"]:"max"==o?["auto",i]:["auto","auto"];if("fixed"!=l&&"fixed"!=o&&null!=d)return d>=1?[e,"auto"]:["auto",i]}return[e,i]})();i.width=p,i.height=w;const{min_width:y,max_width:g}=this.model,{min_height:b,max_height:x}=this.model;i.min_width=null==y?"0px":e(y),i.min_height=null==b?"0px":e(b),this.is_layout_root?(null!=g&&(i.max_width=e(g)),null!=x&&(i.max_height=e(x))):(null!=g?i.max_width=`min(${e(g)}, 100%)`:"fixed"!=l&&(i.max_width="100%"),null!=x?i.max_height=`min(${e(x)}, 100%)`:"fixed"!=o&&(i.max_height="100%"));const{resizable:v}=this.model;if(!1!==v){const t=(()=>{switch(v){case"width":return"horizontal";case"height":return"vertical";case!0:case"both":return"both"}})();i.resize=t,i.overflow="auto"}this.style.append(":host",i)}update_layout(){this.update_style();for(const t of this.layoutable_views)t.update_layout();this._update_layout()}get is_managed(){return this.parent instanceof w}_measure_layout(){}measure_layout(){for(const t of this.layoutable_views)t.measure_layout();this._measure_layout()}compute_layout(){this.parent instanceof w?this.parent.compute_layout():(this.measure_layout(),this.update_bbox(),this._compute_layout(),this.after_layout()),this._layout_computed=!0}_compute_layout(){if(null!=this.layout){this.layout.compute(this.bbox.size);for(const t of this.layoutable_views)null==t.layout?t._compute_layout():t._propagate_layout()}else for(const t of this.layoutable_views)t._compute_layout()}_propagate_layout(){for(const t of this.layoutable_views)null==t.layout&&t._compute_layout()}update_bbox(){for(const t of this.layoutable_views)t.update_bbox();const t=super.update_bbox();return null!=this.layout&&(this.layout.visible=this.is_displayed),t}_after_layout(){}after_layout(){for(const t of this.layoutable_views)t.after_layout();this._after_layout()}render_to(t){null!=t&&t.appendChild(this.el),this.render(),this.r_after_render(),this._was_built=!0,this.notify_finished()}r_after_render(){for(const t of this.child_views)t instanceof w?t.r_after_render():t.after_render();this.after_render()}after_render(){this._after_render(),this.is_managed||this.invalidate_layout(),this._has_finished||(this.is_displayed?(0,f.defer)().then((()=>{this._resized||this.finish()})):this.finish())}invalidate_layout(){this.parent instanceof w?this.parent.invalidate_layout():(this.update_layout(),this.compute_layout())}invalidate_render(){this.render(),this.invalidate_layout()}has_finished(){if(!super.has_finished())return!1;if(this.is_layout_root&&!this._layout_computed)return!1;for(const t of this.child_views)if(!t.has_finished())return!1;return!0}box_sizing(){let{width_policy:t,height_policy:e,aspect_ratio:i}=this.model;const{sizing_mode:s}=this.model;if(null!=s)if("inherit"==s){if(this.parent instanceof w){const s=this.parent.box_sizing();t=s.width_policy,e=s.height_policy,null==i&&(i=s.aspect_ratio)}}else if("fixed"==s)t=e="fixed";else if("stretch_both"==s)t=e="max";else if("stretch_width"==s)t="max";else if("stretch_height"==s)e="max";else switch(null==i&&(i="auto"),s){case"scale_width":t="max",e="min";break;case"scale_height":t="min",e="max";break;case"scale_both":t="max",e="max"}const[a,l]=(()=>{const{align:t}=this.model;return"auto"==t?[void 0,void 0]:(0,_.isArray)(t)?t:[t,t]})(),{width:o,height:n}=this.model;return{width_policy:t,height_policy:e,width:o,height:n,aspect_ratio:i,halign:a,valign:l}}export(t="auto",e=!0){const i=(()=>{switch(t){case"auto":case"png":return"canvas";case"svg":return"svg"}})(),s=new p.CanvasLayer(i,e),{x:a,y:l,width:o,height:n}=this.bbox;s.resize(o,n);const r=getComputedStyle(this.el).backgroundColor;s.ctx.fillStyle=r,s.ctx.fillRect(a,l,o,n);for(const i of this.child_views){const a=i.export(t,e),{x:l,y:o}=i.bbox.scale(s.pixel_ratio);s.ctx.drawImage(a.canvas,l,o)}return s}serializable_state(){return{...super.serializable_state(),children:this.child_views.map((t=>t.serializable_state()))}}}i.LayoutDOMView=w,w.__name__="LayoutDOMView";class y extends o.Pane{constructor(t){super(t)}}i.LayoutDOM=y,l=y,y.__name__="LayoutDOM",l.define((t=>{const{Bool:e,Float:i,Auto:s,Tuple:a,Or:l,Null:o,Nullable:n}=t,r=a(i,i),u=a(i,i,i,i);return{width:[n(i),null],height:[n(i),null],min_width:[n(i),null],min_height:[n(i),null],max_width:[n(i),null],max_height:[n(i),null],margin:[n(l(i,r,u)),null],width_policy:[l(c.SizingPolicy,s),"auto"],height_policy:[l(c.SizingPolicy,s),"auto"],aspect_ratio:[l(i,s,o),null],flow_mode:[h.FlowMode,"block"],sizing_mode:[n(h.SizingMode),null],disabled:[e,!1],align:[l(h.Align,a(h.Align,h.Align),s),"auto"],resizable:[l(e,h.Dimensions),!1]}}))},
function _(e,t,s,i,n){var l;i();const r=e(107),a=e(122),_=e(398),o=e(56),h=e(21);s.ElementLike=(0,h.Or)((0,h.Ref)(r.UIElement),(0,h.Ref)(a.DOMNode),(0,h.Ref)(_.HTML));class m extends r.UIElementView{constructor(){super(...arguments),this._element_views=new Map}get elements(){return this.model.elements}get element_views(){return this.elements.map((e=>this._element_views.get(e)))}*children(){yield*super.children(),yield*this.element_views}async lazy_initialize(){await super.lazy_initialize(),await this._build_elements()}async _build_elements(){return await(0,o.build_views)(this._element_views,this.elements,{parent:this})}async _update_elements(){const{created:e}=await this._build_elements(),t=new Set(e);if(0!=t.size){for(const e of this.element_views)e.el.remove();for(const e of this.element_views){t.has(e)?e.render_to(this.shadow_el):this.shadow_el.append(e.el)}}}remove(){(0,o.remove_views)(this._element_views),super.remove()}connect_signals(){super.connect_signals();const{elements:e}=this.model.properties;this.on_change(e,(async()=>{await this._update_elements()}))}render(){super.render();for(const e of this.element_views)e.render_to(this.shadow_el)}has_finished(){if(!super.has_finished())return!1;for(const e of this.element_views)if(!e.has_finished())return!1;return!0}serializable_state(){const{children:e,...t}=super.serializable_state();return{...t,children:[...e??[],...this.element_views.map((e=>e.serializable_state()))]}}}s.PaneView=m,m.__name__="PaneView";class d extends r.UIElement{constructor(e){super(e)}}s.Pane=d,l=d,d.__name__="Pane",l.prototype.default_view=m,l.define((({List:e})=>({elements:[e(s.ElementLike),[]]})))},
function _(e,t,r,i,s){var n;i();const o=e(122),l=e(107),a=e(56),d=e(63),f=e(12),c=e(8),h=e(21),_=(0,h.Or)((0,h.Ref)(o.DOMNode),(0,h.Ref)(l.UIElement)),u=h.Str;class m extends o.DOMNodeView{constructor(){super(...arguments),this._refs=new Map}get refs(){const{html:e,refs:t}=this.model;return[...(0,c.isArray)(e)?e.filter((e=>!(0,c.isString)(e))):[],...t]}*children(){yield*super.children(),yield*this._refs.values()}async lazy_initialize(){await super.lazy_initialize(),await(0,a.build_views)(this._refs,this.refs)}remove(){(0,a.remove_views)(this._refs),super.remove()}render(){(0,d.empty)(this.el);const e=(()=>{const{html:e}=this.model;return(0,c.isArray)(e)?e.map((e=>(0,c.isString)(e)?e:`<ref id="${e.id}"></ref>`)).join(""):e})(),t=(()=>(0,c.isString)(e)?this.parse_html(e):[e])();this.el.append(...t),this.finish()}parse_html(e){const t=(new DOMParser).parseFromString(e,"text/html"),r=t.createNodeIterator(t,NodeFilter.SHOW_ELEMENT,(e=>"ref"==e.nodeName.toLowerCase()?NodeFilter.FILTER_ACCEPT:NodeFilter.FILTER_REJECT));let i;e:for(;null!=(i=r.nextNode());){(0,f.assert)(i instanceof Element);const e=i.getAttribute("id");if(null!=e){for(const[t,r]of this._refs)if(t.id==e){r.render(),i.replaceWith(r.el);continue e}i.replaceWith((0,d.span)(`<not found: id=${e}>`));continue}const t=i.getAttribute("name");if(null==t);else{for(const[e,r]of this._refs)if(e.name==t){r.render(),i.replaceWith(r.el);continue e}i.replaceWith((0,d.span)(`<not found: name=${t}>`))}}return[...t.body.childNodes]}}r.HTMLView=m,m.__name__="HTMLView";class p extends o.DOMNode{constructor(e){super(e)}}r.HTML=p,n=p,p.__name__="HTML",n.prototype.default_view=m,n.define((({Node:e,List:t,Or:r})=>({html:[r(e,u,t(r(u,_)))],refs:[t(_),[]]})))},
function _(t,o,e,r,i){r();const n=t(172),h=t(64),l=t(12),{max:s}=Math;class f extends n.Layoutable{constructor(t){super(),this.children=t}_measure(t){return{width:0,height:0}}compute(t={}){const{width:o,height:e}=t;(0,l.assert)(null!=o&&null!=e);const r={width:o,height:e},i=new h.BBox({left:0,top:0,width:o,height:e});let n;if(null!=r.inner){const{left:t,top:i,right:l,bottom:s}=r.inner;n=new h.BBox({left:t,top:i,right:o-l,bottom:e-s})}this.set_geometry(i,n)}_set_geometry(t,o){super._set_geometry(t,o);const e=this.children.map(((t,o)=>{const{layout:e,bbox:r}=o;(0,l.assert)(null!=e);const i=e.measure(r);return{child:o,layout:e,bbox:r,size_hint:i}})),r=Array(e.nrows).fill(null).map((()=>({top:0,bottom:0}))),i=Array(e.ncols).fill(null).map((()=>({left:0,right:0})));e.foreach((({r0:t,c0:o,r1:e,c1:n},{size_hint:h})=>{const{inner:l}=h;null!=l&&(i[o].left=s(i[o].left,l.left),i[n].right=s(i[n].right,l.right),r[t].top=s(r[t].top,l.top),r[e].bottom=s(r[e].bottom,l.bottom))})),e.foreach((({r0:t,c0:o,r1:e,c1:n},{layout:l,size_hint:s,bbox:f})=>{const g=f,m=null==s.inner?void 0:(()=>{const{inner:l,align:f}=s,m=f?.left??!0,u=f?.right??!0,c=f?.top??!0,b=f?.bottom??!0,p=f?.fixed_width??!1,a=f?.fixed_height??!1,{left:d,right:_}=(()=>{if(p){const t=g.width-l.right-l.left;if(m){const e=i[o].left;return{left:e,right:g.width-(e+t)}}if(u){const o=i[n].right;return{left:g.width-(o+t),right:o}}return{left:l.left,right:l.right}}return{left:m?i[o].left:l.left,right:u?i[n].right:l.right}})(),{top:w,bottom:y}=(()=>{if(a){const o=g.height-l.bottom-l.top;if(c){const e=r[t].top;return{top:e,bottom:g.height-(e+o)}}if(b){const t=r[e].bottom;return{top:g.height-(t+o),bottom:t}}return{top:l.top,bottom:l.bottom}}return{top:c?r[t].top:l.top,bottom:b?r[e].bottom:l.bottom}})(),{width:x,height:B}=g;return h.BBox.from_lrtb({left:d,top:w,right:x-_,bottom:B-y})})();l.set_geometry(g,m)}))}}e.GridAlignmentLayout=f,f.__name__="GridAlignmentLayout"},
function _(e,i,s,n,r){var t;n();const o=e(401),l=e(182),c=e(107);class d extends o.CSSGridBoxView{connect_signals(){super.connect_signals();const{children:e,rows:i,cols:s}=this.model.properties;this.on_change(e,(()=>this.update_children())),this.on_change([i,s],(()=>this.invalidate_layout()))}get _children(){return this.model.children}get _rows(){return this.model.rows}get _cols(){return this.model.cols}}s.GridBoxView=d,d.__name__="GridBoxView";class _ extends o.CSSGridBox{constructor(e){super(e)}}s.GridBox=_,t=_,_.__name__="GridBox",t.prototype.default_view=d,t.define((({List:e,Nullable:i})=>({children:[e((0,l.GridChild)(c.UIElement)),[]],rows:[i(l.TracksSizing),null],cols:[i(l.TracksSizing),null]})))},
function _(i,n,s,t,e){var o;t();const a=i(396),r=i(399),l=i(182),c=i(63),_=i(255),d=i(34),u=i(8),{max:p}=Math;class g extends a.LayoutDOMView{connect_signals(){super.connect_signals();const{spacing:i}=this.model.properties;this.on_change(i,(()=>this.invalidate_layout()))}get child_models(){return this._children.map((([i])=>i))}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"grid"}}_update_layout(){super._update_layout();const i={},[n,s]=(()=>{const{spacing:i}=this.model;return(0,u.isNumber)(i)?[i,i]:i})();i.row_gap=(0,c.px)(n),i.column_gap=(0,c.px)(s);let t=0,e=0;const o=new _.Container;for(const[[,i,n,s=1,r=1],l]of(0,d.enumerate)(this._children)){const c=this.child_views[l];t=p(t,i+s),e=p(e,n+r);const _={};if(_.grid_row_start=`${i+1}`,_.grid_row_end=`span ${s}`,_.grid_column_start=`${n+1}`,_.grid_column_end=`span ${r}`,c.style.append(":host",_),c instanceof a.LayoutDOMView&&null!=c.layout){const t=i,e=n,a=i+s-1,l=n+r-1;o.add({r0:t,c0:e,r1:a,c1:l},c)}}const{_rows:l,_cols:g}=this;function h(i,n){if(i instanceof Map)for(const[s,t]of i.entries())(0,u.isString)(t)?n[s].size=t:n[s]=t;else if((0,u.isArray)(i))for(const[s,t]of(0,d.enumerate)(i))(0,u.isString)(s)?n[t].size=s:n[t]=s;else if(null!=i)for(const s of n)(0,u.isString)(i)?s.size=i:(s.size=i.size,s.align=i.align)}l instanceof Map?t=p(t,...l.keys()):(0,u.isArray)(l)&&(t=p(t,l.length)),g instanceof Map?e=p(e,...g.keys()):(0,u.isArray)(g)&&(e=p(e,g.length));const f=Array(t).fill(null).map((()=>({}))),m=Array(e).fill(null).map((()=>({})));h(l,f),h(g,m);for(const[[,i,n],s]of(0,d.enumerate)(this._children)){const t=this.child_views[s],{halign:e,valign:o}=t.box_sizing();t.style.append(":host",{justify_self:e??m[n].align,align_self:o??f[i].align})}const y="auto";i.grid_template_rows=f.map((({size:i})=>i??y)).join(" "),i.grid_template_columns=m.map((({size:i})=>i??y)).join(" "),this.style.append(":host",i),0!=o.size?(this.layout=new r.GridAlignmentLayout(o),this.layout.set_sizing()):delete this.layout}}s.CSSGridBoxView=g,g.__name__="CSSGridBoxView";class h extends a.LayoutDOM{constructor(i){super(i)}}s.CSSGridBox=h,o=h,h.__name__="CSSGridBox",o.define((()=>({spacing:[l.GridSpacing,0]})))},
function _(e,t,s,l,i){var c;l();const h=e(1),d=e(396),o=e(107),n=e(63),a=h.__importDefault(e(403));class _ extends d.LayoutDOMView{stylesheets(){return[...super.stylesheets(),a.default]}connect_signals(){super.connect_signals();const{child:e}=this.model.properties;this.on_change(e,(()=>this.update_children()));const{checkable:t,disabled:s}=this.model.properties;this.on_change(t,(()=>{(0,n.display)(this.checkbox_el,this.model.checkable)})),this.on_change(s,(()=>{this.checkbox_el.checked=!this.model.disabled}))}get child_models(){return[this.model.child]}render(){super.render();const{checkable:e,disabled:t,title:s}=this.model;this.checkbox_el=(0,n.input)({type:"checkbox",checked:!t}),this.checkbox_el.addEventListener("change",(()=>{this.model.disabled=!this.checkbox_el.checked})),(0,n.display)(this.checkbox_el,e);const l=(0,n.legend)({},this.checkbox_el,s),i=this.child_views.map((e=>e.el));this.fieldset_el=(0,n.fieldset)({},l,...i),this.shadow_el.appendChild(this.fieldset_el)}_update_children(){const e=this.child_views.map((e=>e.el));this.fieldset_el.append(...e)}}s.GroupBoxView=_,_.__name__="GroupBoxView";class r extends d.LayoutDOM{constructor(e){super(e)}}s.GroupBox=r,c=r,r.__name__="GroupBox",c.prototype.default_view=_,c.define((({Bool:e,Str:t,Nullable:s,Ref:l})=>({title:[s(t),null],child:[l(o.UIElement)],checkable:[e,!1]})))},
function _(d,a,e,l,i){l(),e.default="legend{display:flex;gap:0.5em;padding:0 calc(var(--padding-horizontal) / 2);}fieldset{border:1px solid #ccc;}"},
function _(e,n,t,s,l){var i;s();const o=e(401),c=e(182),r=e(107),a=e(21),d=(0,a.Struct)({child:(0,a.Ref)(r.UIElement),col:(0,a.Opt)(c.Index),span:(0,a.Opt)(c.Span)});class _ extends o.CSSGridBoxView{connect_signals(){super.connect_signals();const{children:e,cols:n}=this.model.properties;this.on_change(e,(()=>this.update_children())),this.on_change(n,(()=>this.invalidate_layout()))}get _children(){return this.model.children.map((({child:e,col:n,span:t},s)=>[e,0,n??s,1,t??1]))}get _rows(){return null}get _cols(){return this.model.cols}}t.HBoxView=_,_.__name__="HBoxView";class h extends o.CSSGridBox{constructor(e){super(e)}}t.HBox=h,i=h,h.__name__="HBox",i.prototype.default_view=_,i.define((({List:e,Nullable:n})=>({children:[e(d),[]],cols:[n(c.TracksSizing),null]})))},
function _(e,o,t,s,_){var n;s();const r=e(395);class c extends r.FlexBoxView{constructor(){super(...arguments),this._direction="row"}}t.RowView=c,c.__name__="RowView";class w extends r.FlexBox{constructor(e){super(e)}}t.Row=w,n=w,w.__name__="Row",n.prototype.default_view=c},
function _(e,l,o,t,r){var s;t();const a=e(396),c=e(107),i=e(20);class n extends a.LayoutDOMView{stylesheets(){return[...super.stylesheets()]}connect_signals(){super.connect_signals();const{child:e,horizontal_scrollbar:l,vertical_scrollbar:o}=this.model.properties;this.on_change(e,(()=>this.update_children())),this.on_change([l,o],(()=>this.invalidate_layout()))}get child_models(){return[this.model.child]}_update_layout(){function e(e){switch(e){case"auto":return"auto";case"visible":return"scroll";case"hidden":return"hidden"}}super._update_layout();const{horizontal_scrollbar:l,vertical_scrollbar:o}=this.model;this.style.append(":host",{overflow_x:e(l),overflow_y:e(o)})}}o.ScrollBoxView=n,n.__name__="ScrollBoxView";class _ extends a.LayoutDOM{constructor(e){super(e)}}o.ScrollBox=_,s=_,_.__name__="ScrollBox",s.prototype.default_view=n,s.define((({Ref:e})=>({child:[e(c.UIElement)],horizontal_scrollbar:[i.ScrollbarPolicy,"auto"],vertical_scrollbar:[i.ScrollbarPolicy,"auto"]})))},
function _(t,e,a,o,_){var r;o();const s=t(396);class c extends s.LayoutDOMView{constructor(){super(...arguments),this._auto_width="auto",this._auto_height="auto"}get child_models(){return[]}}a.SpacerView=c,c.__name__="SpacerView";class u extends s.LayoutDOM{constructor(t){super(t)}}a.Spacer=u,r=u,u.__name__="Spacer",r.prototype.default_view=c},
function _(l,e,o,t,n){var a;t();const s=l(409),c=l(51),i=l(107);class d extends c.Model{constructor(l){super(l)}}o.TabPanel=d,a=d,d.__name__="TabPanel",a.define((({Bool:l,Str:e,Ref:o,Nullable:t})=>({title:[e,""],tooltip:[t(o(s.Tooltip)),null],child:[o(i.UIElement)],closable:[l,!1],disabled:[l,!1]})))},
function _(e,t,i,r,s){var n;r();const o=e(1),l=e(107),c=e(122),a=e(60),h=e(410),_=e(20),u=e(63),d=e(57),p=e(8),g=e(12),m=e(64),f=e(19),w=e(56),b=e(51),v=globalThis.Node,y=o.__importStar(e(411)),x=y,z=o.__importDefault(e(121));class E extends l.UIElementView{constructor(){super(...arguments),this._element_view=null}get target(){return this._target}set target(e){this._target=e}_init_target(){const{target:e}=this.model,t=(()=>{if(e instanceof l.UIElement)return this.owner.find_one(e)?.el??null;if(e instanceof h.Selector)return e.find_one(document);if(e instanceof v)return e;{const{parent:e}=this;return e instanceof d.DOMElementView?e.el:null}})();t instanceof Element?this._target=t:(f.logger.warn(`unable to resolve target '${e}' for '${this}'`),this._target=document.body)}initialize(){super.initialize(),this._init_target()}*children(){yield*super.children(),null!=this._element_view&&(yield this._element_view)}async lazy_initialize(){await super.lazy_initialize();const{content:e}=this.model;e instanceof b.Model&&(this._element_view=await(0,w.build_view)(e,{parent:this})),this.render()}connect_signals(){super.connect_signals(),this._observer=new ResizeObserver((()=>{this._reposition()})),this._observer.observe(this.target);let e=!1;document.addEventListener("scroll",this._scroll_listener=()=>{e||(requestAnimationFrame((()=>{this._reposition(),e=!1})),e=!0)},{capture:!0});const{target:t,content:i,closable:r,interactive:s,position:n,attachment:o,visible:l}=this.model.properties;this.on_change(t,(()=>{this._init_target(),this._observer.disconnect(),this._observer.observe(this.target),this.render()})),this.on_change([i,r,s],(()=>this.render())),this.on_change([n,o,l],(()=>this._reposition()))}disconnect_signals(){null!=this._scroll_listener&&(document.removeEventListener("scroll",this._scroll_listener,{capture:!0}),delete this._scroll_listener),super.disconnect_signals()}remove(){this._element_view?.remove(),this._observer.disconnect(),super.remove()}stylesheets(){return[...super.stylesheets(),y.default,z.default]}get content(){const{content:e}=this.model;return(0,p.isString)(e)?document.createTextNode(e):e instanceof b.Model?((0,g.assert)(null!=this._element_view),this._element_view.el):e}render(){super.render(),this._element_view?.render_to(null),this.arrow_el=(0,u.div)({class:[x.arrow]}),this.content_el=(0,u.div)({class:x.tooltip_content},this.content),this.shadow_el.append(this.arrow_el,this.content_el),this.class_list.toggle(x.closable,this.model.closable);const e=(0,u.div)({class:x.close});this.shadow_el.append(e),e.addEventListener("click",(()=>{this.model.visible=!1})),this.el.classList.toggle(x.show_arrow,this.model.show_arrow),this.el.classList.toggle(x.non_interactive,!this.model.interactive),this._reposition()}_anchor_to_align(e){switch(e){case"top_left":return["top","left"];case"top":case"top_center":return["top","center"];case"top_right":return["top","right"];case"left":case"center_left":return["center","left"];case"center":case"center_center":return["center","center"];case"right":case"center_right":return["center","right"];case"bottom_left":return["bottom","left"];case"bottom":case"bottom_center":return["bottom","center"];case"bottom_right":return["bottom","right"]}}_reposition(){const{position:e,visible:t}=this.model;if(null==e||!t)return void this.el.remove();(document.body.shadowRoot??document.body).append(this.el);const i=(0,u.bounding_box)(this.target),[r,s]=(()=>{if((0,p.isString)(e)){const[t,r]=this._anchor_to_align(e);return[(()=>{switch(r){case"left":return i.left;case"center":return i.hcenter;case"right":return i.right}})(),(()=>{switch(t){case"top":return i.top;case"center":return i.vcenter;case"bottom":return i.bottom}})()]}if((0,p.isArray)(e)){const[t,r]=e;return[i.left+t,i.top+r]}{const{x:t,y:r}=this.resolve_as_xy(e);return[i.left+t,i.top+r]}})(),n=new m.BBox({x:0,y:0,width:window.innerWidth,height:window.innerHeight}),o=(0,u.box_size)(this.arrow_el),l=(()=>{const t=(()=>{const{attachment:t}=this.model;if("auto"==t){if((0,p.isString)(e)){const[t,i]=this._anchor_to_align(e);if("center"!=i)return"left"==i?"left":"right";if("center"!=t)return"top"==t?"above":"below"}return"horizontal"}return t})(),l=(0,u.box_size)(this.el),c=l.width+o.width,a=l.height+o.height;switch(t){case"horizontal":return r<i.hcenter?r+c<=n.right?"right":"left":r-c>=n.left?"left":"right";case"vertical":return s<i.vcenter?s+a<=n.bottom?"below":"above":s-a>=n.top?"above":"below";default:return t}})();this.class_list.remove(x.right,x.left,x.above,x.below),this.class_list.add((()=>{switch(l){case"left":return x.right;case"right":return x.left;case"above":return x.below;case"below":return x.above}})()),this.arrow_el.style.left=`${r}px`,this.arrow_el.style.top=`${s}px`;const{left:c,top:a}=(()=>{const{width:e,height:t}=(0,u.box_size)(this.el);function i(e){return e<n.top?n.top:e+t>n.bottom?n.bottom-t:e}function c(t){return t<n.left?n.left:t+e>n.right?n.right-e:t}switch(l){case"left":return{left:r-e-o.width,top:i(s-t/2)};case"right":return{left:r+o.width,top:i(s-t/2)};case"above":return{left:c(r-e/2),top:s-t-o.height};case"below":return{left:c(r-e/2),top:s+o.height}}})();this.el.style.top=`${a}px`,this.el.style.left=`${c}px`}}i.TooltipView=E,E.__name__="TooltipView";class T extends l.UIElement{constructor(e){super(e)}show({x:e,y:t}){this.setv({position:[e,t],visible:!0},{check_eq:!1})}clear(){this.position=null}}i.Tooltip=T,n=T,T.__name__="Tooltip",n.prototype.default_view=E,n.define((({Bool:e,Float:t,Str:i,Tuple:r,Or:s,Ref:n,Nullable:o,Auto:u})=>({target:[s(n(l.UIElement),n(h.Selector),n(v),u),"auto"],position:[o(s(_.Anchor,r(t,t),n(a.Coordinate))),null],content:[s(i,n(c.DOMNode),n(l.UIElement),n(v))],attachment:[s(_.TooltipAttachment,u),"auto"],show_arrow:[e,!0],closable:[e,!1],interactive:[e,!0]}))),n.override({visible:!1})},
function _(e,r,t,c,n){var o;c();const s=e(51);class _ extends s.Model{constructor(e){super(e)}}t.Selector=_,o=_,_.__name__="Selector",o.define((({Str:e})=>({query:[e]})))},
function _(o,t,r,e,i){e(),r.non_interactive="bk-non-interactive",r.arrow="bk-arrow",r.show_arrow="bk-show-arrow",r.left="bk-left",r.right="bk-right",r.above="bk-above",r.below="bk-below",r.tooltip_content="bk-tooltip-content",r.tooltip_row_label="bk-tooltip-row-label",r.tooltip_row_value="bk-tooltip-row-value",r.tooltip_color_block="bk-tooltip-color-block",r.closable="bk-closable",r.close="bk-close",r.default=':host{--tooltip-border:#e5e5e5;--tooltip-color:white;--tooltip-text:#2f2f2f;--tooltip-arrow-color:#909599;--tooltip-arrow-width:10px;--tooltip-arrow-height:10px;--tooltip-arrow-half-width:7px;--tooltip-arrow-half-height:7px;}:host{width:max-content;font-weight:300;font-size:var(--font-size);position:fixed;padding:5px;border:1px solid var(--tooltip-border);color:var(--tooltip-text);background-color:var(--tooltip-color);opacity:0.95;z-index:var(--bokeh-top-level);}:host(.bk-non-interactive){pointer-events:none;}.bk-arrow{pointer-events:none;position:fixed;width:0;height:0;content:" ";border-style:solid;border-color:transparent;}:host(:not(.bk-show-arrow)) .bk-arrow{display:none;}:host(.bk-left) .bk-arrow,:host(.bk-right) .bk-arrow{border-width:var(--tooltip-arrow-half-height) 0 var(--tooltip-arrow-half-height) 0;}:host(.bk-above) .bk-arrow,:host(.bk-below) .bk-arrow{border-width:0 var(--tooltip-arrow-half-width) 0 var(--tooltip-arrow-half-width);}:host(.bk-left) .bk-arrow{transform:translate(0%, -50%);border-right-width:var(--tooltip-arrow-width);border-right-color:var(--tooltip-arrow-color);}:host(.bk-right) .bk-arrow{transform:translate(-100%, -50%);border-left-width:var(--tooltip-arrow-width);border-left-color:var(--tooltip-arrow-color);}:host(.bk-above) .bk-arrow{transform:translate(-50%, 0%);border-bottom-width:var(--tooltip-arrow-height);border-bottom-color:var(--tooltip-arrow-color);}:host(.bk-below) .bk-arrow{transform:translate(-50%, -100%);border-top-width:var(--tooltip-arrow-height);border-top-color:var(--tooltip-arrow-color);}.bk-tooltip-content > div:not(:first-child){margin-top:5px;border-top:var(--tooltip-border) 1px dashed;}.bk-tooltip-row-label{text-align:right;color:#26aae1;}.bk-tooltip-row-value{color:none;}.bk-tooltip-color-block{width:12px;height:12px;margin-left:5px;margin-right:5px;outline:#dddddd solid 1px;display:inline-block;}:host(:not(.bk-closable)) .bk-close{display:none;}.bk-close{position:absolute;top:2px;right:2px;width:12px;height:12px;cursor:pointer;background-color:gray;mask-image:var(--bokeh-icon-x);mask-size:contain;mask-repeat:no-repeat;-webkit-mask-image:var(--bokeh-icon-x);-webkit-mask-size:contain;-webkit-mask-repeat:no-repeat;}.bk-close:hover{background-color:red;}'},
function _(e,t,s,i,a){var l;i();const o=e(1),n=e(56),d=e(63),c=e(10),r=e(255),h=e(20),_=e(396),u=e(408),p=e(399),v=o.__importStar(e(413)),m=v,b=o.__importDefault(e(121));class f extends _.LayoutDOMView{constructor(){super(...arguments),this.tooltip_views=new Map}connect_signals(){super.connect_signals();const{tabs:e,active:t}=this.model.properties;this.on_change(e,(async()=>{this._update_headers(),await this.update_children()})),this.on_change(t,(()=>{this.update_active()}))}async lazy_initialize(){await super.lazy_initialize();const{tabs:e}=this.model,t=e.map((e=>e.tooltip)).filter((e=>null!=e));await(0,n.build_views)(this.tooltip_views,t,{parent:this})}stylesheets(){return[...super.stylesheets(),v.default,b.default]}get child_models(){return this.model.tabs.map((e=>e.child))}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"grid"}}_update_layout(){super._update_layout();const e=this.model.tabs_location;this.class_list.remove([...h.Location].map((e=>m[e]))),this.class_list.add(m[e]);const t=new r.Container;for(const e of this.child_views)e.style.append(":host",{grid_area:"stack"}),e instanceof _.LayoutDOMView&&null!=e.layout&&t.add({r0:0,c0:0,r1:1,c1:1},e);0!=t.size?(this.layout=new p.GridAlignmentLayout(t),this.layout.set_sizing()):delete this.layout}_after_layout(){super._after_layout();const{child_views:e}=this;for(const t of e)(0,d.hide)(t.el);const{active:t}=this.model;if(t in e){const s=e[t];(0,d.show)(s.el)}}render(){super.render(),this.header_el=(0,d.div)({class:m.header}),this.shadow_el.append(this.header_el),this._update_headers()}_update_headers(){const{active:e}=this.model,t=this.model.tabs.map(((t,s)=>{const i=(0,d.div)({class:[m.tab,s==e?m.active:null],tabIndex:0},t.title);i.addEventListener("click",(e=>{this.model.disabled||e.target==e.currentTarget&&this.change_active(s)}));const a=null!=t.tooltip?this.tooltip_views.get(t.tooltip):null;if(null!=a){a.model.target=i;const e=e=>{a.model.visible=e};i.addEventListener("mouseenter",(()=>{e(!0)})),i.addEventListener("mouseleave",(()=>{e(!1)}))}if(t.closable){const e=(0,d.div)({class:m.close});e.addEventListener("click",(e=>{if(e.target==e.currentTarget){this.model.tabs=(0,c.remove_at)(this.model.tabs,s);const e=this.model.tabs.length;this.model.active>e-1&&(this.model.active=e-1)}})),i.appendChild(e)}return(this.model.disabled||t.disabled)&&i.classList.add(m.disabled),i}));this.header_els=t,(0,d.empty)(this.header_el),this.header_el.append(...t)}change_active(e){e!=this.model.active&&(this.model.active=e)}update_active(){const e=this.model.active,{header_els:t}=this;for(const e of t)e.classList.remove(m.active);e in t&&t[e].classList.add(m.active);const{child_views:s}=this;for(const e of s)(0,d.hide)(e.el);e in s&&(0,d.show)(s[e].el)}}s.TabsView=f,f.__name__="TabsView";class w extends _.LayoutDOM{constructor(e){super(e)}}s.Tabs=w,l=w,w.__name__="Tabs",l.prototype.default_view=f,l.define((({Int:e,List:t,Ref:s})=>({tabs:[t(s(u.TabPanel)),[]],tabs_location:[h.Location,"above"],active:[e,0]})))},
function _(e,r,o,t,a){t(),o.above="bk-above",o.below="bk-below",o.left="bk-left",o.right="bk-right",o.header="bk-header",o.tab="bk-tab",o.active="bk-active",o.close="bk-close",o.disabled="bk-disabled",o.default=':host{display:grid;}:host(.bk-above){grid-template:"header" max-content "stack" 1fr / 1fr;}:host(.bk-below){grid-template:"stack" 1fr "header" max-content / 1fr;}:host(.bk-left){grid-template:"header stack" 1fr / max-content 1fr;}:host(.bk-right){grid-template:"stack header" 1fr / 1fr max-content;}.bk-header{grid-area:"header";display:flex;flex-wrap:nowrap;align-items:stretch;user-select:none;-webkit-user-select:none;}:host(.bk-above) .bk-header,:host(.bk-below) .bk-header{flex-direction:row;}:host(.bk-left) .bk-header,:host(.bk-right) .bk-header{flex-direction:column;}:host(.bk-above) .bk-header{border-bottom:1px solid #e6e6e6;}:host(.bk-right) .bk-header{border-left:1px solid #e6e6e6;}:host(.bk-below) .bk-header{border-top:1px solid #e6e6e6;}:host(.bk-left) .bk-header{border-right:1px solid #e6e6e6;}.bk-tab{padding:4px 8px;border:solid transparent;outline:0;outline-offset:-5px;white-space:nowrap;cursor:pointer;text-align:center;}.bk-tab:hover{background-color:#f2f2f2;}.bk-tab:focus,.bk-tab:active{outline:1px dotted #ccc;}.bk-tab.bk-active{color:#4d4d4d;background-color:white;border-color:#e6e6e6;}.bk-tab .bk-close{margin-left:10px;}.bk-tab.bk-disabled{cursor:not-allowed;pointer-events:none;opacity:0.65;}:host(.bk-above) .bk-tab{border-width:3px 1px 0px 1px;border-radius:var(--border-radius) var(--border-radius) 0 0;}:host(.bk-right) .bk-tab{border-width:1px 3px 1px 0px;border-radius:0 var(--border-radius) var(--border-radius) 0;}:host(.bk-below) .bk-tab{border-width:0px 1px 3px 1px;border-radius:0 0 var(--border-radius) var(--border-radius);}:host(.bk-left) .bk-tab{border-width:1px 0px 1px 3px;border-radius:var(--border-radius) 0 0 var(--border-radius);}.bk-close{display:inline-block;vertical-align:middle;width:14px;height:14px;cursor:pointer;background-color:gray;mask-image:var(--bokeh-icon-x);mask-size:contain;mask-repeat:no-repeat;-webkit-mask-image:var(--bokeh-icon-x);-webkit-mask-size:contain;-webkit-mask-repeat:no-repeat;}.bk-close:hover{background-color:red;}'},
function _(e,n,t,s,i){var o;s();const r=e(401),l=e(182),c=e(107),a=e(21),d=(0,a.Struct)({child:(0,a.Ref)(c.UIElement),row:(0,a.Opt)(l.Index),span:(0,a.Opt)(l.Span)});class _ extends r.CSSGridBoxView{connect_signals(){super.connect_signals();const{children:e,rows:n}=this.model.properties;this.on_change(e,(()=>this.update_children())),this.on_change(n,(()=>this.invalidate_layout()))}get _children(){return this.model.children.map((({child:e,row:n,span:t},s)=>[e,n??s,0,t??1,1]))}get _rows(){return this.model.rows}get _cols(){return null}}t.VBoxView=_,_.__name__="VBoxView";class h extends r.CSSGridBox{constructor(e){super(e)}}t.VBox=h,o=h,h.__name__="VBox",o.prototype.default_view=_,o.define((({List:e,Nullable:n})=>({children:[e(d),[]],rows:[n(l.TracksSizing),null]})))},
function _(t,a,i,e,M){e();var T=t(175);M("MathText",T.MathText),M("Ascii",T.Ascii),M("MathML",T.MathML),M("TeX",T.TeX),M("PlainText",t(181).PlainText)},
function _(r,o,t,e,n){e(),n("CustomJSTransform",r(417).CustomJSTransform),n("Dodge",r(418).Dodge),n("Interpolator",r(420).Interpolator),n("Jitter",r(421).Jitter),n("LinearInterpolator",r(423).LinearInterpolator),n("StepInterpolator",r(424).StepInterpolator),n("Transform",r(93).Transform)},
function _(r,t,s,n,e){var a;n();const u=r(93),o=r(9),m=r(40);class _ extends u.Transform{constructor(r){super(r)}get names(){return(0,o.keys)(this.args)}get values(){return(0,o.values)(this.args)}_make_transform(r,t){return new Function(...this.names,r,(0,m.use_strict)(t))}get scalar_transform(){return this._make_transform("x",this.func)}get vector_transform(){return this._make_transform("xs",this.v_func)}compute(r){return this.scalar_transform(...this.values,r)}v_compute(r){return this.vector_transform(...this.values,r)}}s.CustomJSTransform=_,a=_,_.__name__="CustomJSTransform",a.define((({Unknown:r,Str:t,Dict:s})=>({args:[s(r),{}],func:[t,""],v_func:[t,""]})))},
function _(e,n,o,t,a){var r;t();const s=e(419);class u extends s.RangeTransform{constructor(e){super(e)}_compute(e){return e+this.value}}o.Dodge=u,r=u,u.__name__="Dodge",r.define((({Float:e})=>({value:[e,0]})))},
function _(e,n,t,r,a){var s;r();const c=e(93),o=e(94),i=e(105),u=e(24),h=e(8),l=e(12);class g extends c.Transform{constructor(e){super(e)}v_compute(e){let n;this.range instanceof i.FactorRange?n=this.range.v_synthetic(e):(0,h.isArrayableOf)(e,h.isNumber)?n=e:(0,l.unreachable)();const t=new((0,u.infer_type)(n))(n.length);for(let e=0;e<n.length;e++){const r=n[e];t[e]=this._compute(r)}return t}compute(e){return this.range instanceof i.FactorRange?this._compute(this.range.synthetic(e)):(0,h.isNumber)(e)?this._compute(e):void(0,l.unreachable)()}}t.RangeTransform=g,s=g,g.__name__="RangeTransform",s.define((({Ref:e,Nullable:n})=>({range:[n(e(o.Range)),null]})))},
function _(t,e,r,n,s){var o;n();const i=t(93),a=t(125),h=t(24),l=t(10),d=t(8);class c extends i.Transform{constructor(t){super(t),this._sorted_dirty=!0}connect_signals(){super.connect_signals(),this.connect(this.change,(()=>this._sorted_dirty=!0))}v_compute(t){const e=new((0,h.infer_type)(t))(t.length);for(let r=0;r<t.length;r++){const n=t[r];e[r]=this.compute(n)}return e}sort(t=!1){if(!this._sorted_dirty)return;let e,r;if((0,d.isString)(this.x)&&(0,d.isString)(this.y)&&null!=this.data){const t=this.data.columns();if(!(0,l.includes)(t,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!(0,l.includes)(t,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");e=this.data.get_column(this.x),r=this.data.get_column(this.y)}else{if(!(0,d.isArray)(this.x)||!(0,d.isArray)(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");e=this.x,r=this.y}if(e.length!==r.length)throw new Error("The length for x and y do not match");if(e.length<2)throw new Error("x and y must have at least two elements to support interpolation");const n=e.length,s=new Uint32Array(n);for(let t=0;t<n;t++)s[t]=t;const o=t?-1:1;s.sort(((t,r)=>o*(e[t]-e[r]))),this._x_sorted=new((0,h.infer_type)(e))(n),this._y_sorted=new((0,h.infer_type)(r))(n);for(let t=0;t<n;t++)this._x_sorted[t]=e[s[t]],this._y_sorted[t]=r[s[t]];this._sorted_dirty=!1}}r.Interpolator=c,o=c,c.__name__="Interpolator",o.define((({Bool:t,Float:e,Str:r,Ref:n,List:s,Or:o,Nullable:i})=>({x:[o(r,s(e))],y:[o(r,s(e))],data:[i(n(a.ColumnarDataSource)),null],clip:[t,!0]})))},
function _(t,e,n,r,i){var s;r();const o=t(419),a=t(105),u=t(422),_=t(20),h=t(13),m=t(113);class c extends o.RangeTransform{constructor(t){super(t),this._previous_offsets=null}initialize(){super.initialize(),this._generator=this.random_generator?.generator()??new m.SystemRandom}v_compute(t){const e=(()=>this.range instanceof a.FactorRange?this.range.v_synthetic(t):t)(),n=(()=>{const t=e.length;return this._previous_offsets?.length!=t&&(this._previous_offsets=this._v_compute(t)),this._previous_offsets})();return(0,h.map)(n,((t,n)=>t+e[n]))}_compute(){const{mean:t,width:e}=this;switch(this.distribution){case"uniform":return this._generator.uniform(t,e);case"normal":return this._generator.normal(t,e)}}_v_compute(t){const{mean:e,width:n}=this;switch(this.distribution){case"uniform":return this._generator.uniforms(e,n,t);case"normal":return this._generator.normals(e,n,t)}}}n.Jitter=c,s=c,c.__name__="Jitter",s.define((({Float:t})=>({mean:[t,0],width:[t,1],distribution:[_.Distribution,"uniform"]}))),s.internal((({Nullable:t,Ref:e})=>({random_generator:[t(e(u.RandomGenerator)),null]})))},
function _(n,e,o,r,t){r();const a=n(51);class s extends a.Model{constructor(n){super(n)}}o.RandomGenerator=s,s.__name__="RandomGenerator"},
function _(t,s,_,r,e){r();const i=t(10),o=t(420);class n extends o.Interpolator{constructor(t){super(t)}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];const s=(0,i.find_last_index)(this._x_sorted,(s=>s<t)),_=this._x_sorted[s],r=this._x_sorted[s+1],e=this._y_sorted[s],o=this._y_sorted[s+1];return e+(t-_)/(r-_)*(o-e)}}_.LinearInterpolator=n,n.__name__="LinearInterpolator"},
function _(t,e,s,r,o){var _;r();const i=t(420),n=t(20),d=t(10);class h extends i.Interpolator{constructor(t){super(t)}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}let e;switch(this.mode){case"after":e=(0,d.find_last_index)(this._x_sorted,(e=>t>=e));break;case"before":e=(0,d.find_index)(this._x_sorted,(e=>t<=e));break;case"center":{const s=(0,d.map)(this._x_sorted,(e=>Math.abs(e-t))),r=(0,d.min)(s);e=(0,d.find_index)(s,(t=>r===t));break}default:throw new Error(`unknown mode: ${this.mode}`)}return-1!=e?this._y_sorted[e]:NaN}}s.StepInterpolator=h,_=h,h.__name__="StepInterpolator",_.define((()=>({mode:[n.StepMode,"after"]})))},
function _(p,o,t,i,a){i(),a("MapOptions",p(426).MapOptions),a("GMapOptions",p(426).GMapOptions),a("GMapPlot",p(426).GMapPlot),a("GMap",p(439).GMap),a("Plot",p(427).Plot),a("GridPlot",p(440).GridPlot),a("Figure",p(441).Figure)},
function _(e,t,a,o,n){var p,l,s;o();const _=e(427),r=e(20),i=e(51),c=e(95),d=e(438);n("GMapPlotView",d.GMapPlotView);class u extends i.Model{constructor(e){super(e)}}a.MapOptions=u,p=u,u.__name__="MapOptions",p.define((({Int:e,Float:t})=>({lat:[t],lng:[t],zoom:[e,12]})));class M extends u{constructor(e){super(e)}}a.GMapOptions=M,l=M,M.__name__="GMapOptions",l.define((({Bool:e,Int:t,Str:a,Nullable:o})=>({map_type:[r.MapType,"roadmap"],scale_control:[e,!1],styles:[o(a),null],tilt:[t,45]})));class m extends _.Plot{constructor(e){super(e),this.use_map=!0}}a.GMapPlot=m,s=m,m.__name__="GMapPlot",s.prototype.default_view=d.GMapPlotView,s.define((({Str:e,Bytes:t,Ref:a})=>({map_options:[a(M)],api_key:[t],api_version:[e,"weekly"]}))),s.override({x_range:()=>new c.Range1d,y_range:()=>new c.Range1d,background_fill_alpha:0})},
function _(e,t,o,r,n){var a;r();const l=e(1),i=l.__importStar(e(85)),s=l.__importStar(e(18)),_=e(15),d=e(20),c=e(10),h=e(44),u=e(8),f=e(396),b=e(186),g=e(392),p=e(79),m=e(168),w=e(97),y=e(288),v=e(398),x=e(94),S=e(92),R=e(130),A=e(81),L=e(215),T=e(214),D=e(289),P=e(102),k=e(428);n("PlotView",k.PlotView);class O extends f.LayoutDOM{constructor(e){super(e),this.use_map=!1,this.reset=new _.Signal0(this,"reset")}add_layout(e,t="center"){const o=this.properties[t].get_value();this.setv({[t]:[...o,e]})}remove_layout(e){const t=t=>{(0,c.remove_by)(t,(t=>t==e))};t(this.left),t(this.right),t(this.above),t(this.below),t(this.center)}get data_renderers(){return this.renderers.filter((e=>e instanceof L.DataRenderer))}add_renderers(...e){this.renderers=[...this.renderers,...e]}add_glyph(e,t=new R.ColumnDataSource,o={}){const r=new T.GlyphRenderer({...o,data_source:t,glyph:e});return this.add_renderers(r),r}add_tools(...e){const t=e.map((e=>e instanceof D.Tool?e:D.Tool.from_string(e)));this.toolbar.tools=[...this.toolbar.tools,...t]}remove_tools(...e){this.toolbar.tools=[...(0,h.difference)(new Set(this.toolbar.tools),new Set(e))]}get panels(){return[...this.side_panels,...this.center]}get side_panels(){const{above:e,below:t,left:o,right:r}=this;return(0,c.concat)([e,t,o,r])}}o.Plot=O,a=O,O.__name__="Plot",a.prototype.default_view=k.PlotView,a.mixins([["outline_",i.Line],["background_",i.Fill],["border_",i.Fill]]),a.define((({Bool:e,Float:t,Str:o,List:r,Dict:n,Or:a,Ref:l,Null:i,Nullable:_,Struct:c,Opt:h})=>({toolbar:[l(y.Toolbar),()=>new y.Toolbar],toolbar_location:[_(d.Location),"right"],toolbar_sticky:[e,!0],toolbar_inner:[e,!1],frame_width:[_(t),null],frame_height:[_(t),null],frame_align:[a(e,c({left:h(e),right:h(e),top:h(e),bottom:h(e)})),!0],title:[a(l(m.Title),o,i),"",{convert:e=>(0,u.isString)(e)?new m.Title({text:e}):e}],title_location:[_(d.Location),"above"],above:[r(a(l(p.Annotation),l(b.Axis))),[]],below:[r(a(l(p.Annotation),l(b.Axis))),[]],left:[r(a(l(p.Annotation),l(b.Axis))),[]],right:[r(a(l(p.Annotation),l(b.Axis))),[]],center:[r(a(l(p.Annotation),l(g.Grid))),[]],renderers:[r(l(A.Renderer)),[]],x_range:[l(x.Range),()=>new P.DataRange1d],y_range:[l(x.Range),()=>new P.DataRange1d],x_scale:[l(S.Scale),()=>new w.LinearScale],y_scale:[l(S.Scale),()=>new w.LinearScale],extra_x_ranges:[n(l(x.Range)),{}],extra_y_ranges:[n(l(x.Range)),{}],extra_x_scales:[n(l(S.Scale)),{}],extra_y_scales:[n(l(S.Scale)),{}],lod_factor:[t,10],lod_interval:[t,300],lod_threshold:[_(t),2e3],lod_timeout:[t,500],hidpi:[e,!0],output_backend:[d.OutputBackend,"canvas"],min_border:[_(t),5],min_border_top:[_(t),null],min_border_left:[_(t),null],min_border_bottom:[_(t),null],min_border_right:[_(t),null],inner_width:[t,s.unset,{readonly:!0}],inner_height:[t,s.unset,{readonly:!0}],outer_width:[t,s.unset,{readonly:!0}],outer_height:[t,s.unset,{readonly:!0}],match_aspect:[e,!1],aspect_scale:[t,1],reset_policy:[d.ResetPolicy,"standard"],hold_render:[e,!1],attribution:[r(a(o,l(v.HTML))),[]]}))),a.override({width:600,height:600,outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})},
function _(e,t,i,s,n){s();const a=e(1),r=e(185),o=e(321),l=e(81),_=e(290),h=e(396),d=e(79),c=e(168),u=e(186),p=e(287),g=e(102),m=e(429),f=e(431),b=e(53),v=e(56),w=e(82),y=e(19),x=e(53),z=e(15),k=e(433),S=e(8),N=e(10),$=e(34),M=e(110),q=e(254),V=e(256),P=e(255),R=e(170),T=e(64),B=e(178),C=e(434),A=e(435),D=e(29),H=e(63),L=e(59),F=a.__importDefault(e(436)),I=a.__importDefault(e(437)),{max:E}=Math;class O extends h.LayoutDOMView{constructor(){super(...arguments),this._render_count=0,this.repainted=new z.Signal0(this,"repainted"),this._computed_style=new H.InlineStyleSheet,this._outer_bbox=new T.BBox,this._inner_bbox=new T.BBox,this._needs_paint=!0,this._invalidated_painters=new Set,this._invalidate_all=!0,this.renderer_views=new Map,this.tool_views=new Map,this._needs_notify=!1}get canvas(){return this.canvas_view}stylesheets(){return[...super.stylesheets(),F.default,this._computed_style]}get toolbar_panel(){return null!=this._toolbar?this.renderer_view(this._toolbar):void 0}get state(){return this._state_manager}set invalidate_dataranges(e){this._range_manager.invalidate_dataranges=e}get computed_renderer_views(){return this.computed_renderers.map((e=>this.renderer_views.get(e)))}renderer_view(e){const t=this.renderer_views.get(e);if(null==t)for(const[,t]of this.renderer_views){const i=t.renderer_view(e);if(null!=i)return i}return t}get auto_ranged_renderers(){return this.model.renderers.map((e=>this.renderer_view(e))).filter(g.is_auto_ranged)}get base_font_size(){const e=getComputedStyle(this.el).fontSize,t=(0,B.parse_css_font_size)(e);if(null!=t){const{value:e,unit:i}=t;if("px"==i)return e}return null}*children(){yield*super.children(),yield*this.renderer_views.values(),yield*this.tool_views.values()}get is_paused(){return null!=this._is_paused&&0!==this._is_paused}get child_models(){return[]}pause(){null==this._is_paused?this._is_paused=1:this._is_paused+=1}unpause(e=!1){if(null==this._is_paused)throw new Error("wasn't paused");this._is_paused=Math.max(this._is_paused-1,0),0!=this._is_paused||e||this.request_paint("everything")}notify_finished_after_paint(){this._needs_notify=!0}request_render(){this.request_paint("everything")}request_paint(e){this.invalidate_painters(e),this.schedule_paint()}invalidate_painters(e){if("everything"==e)this._invalidate_all=!0;else if((0,S.isArray)(e))for(const t of e){const e=(()=>t instanceof l.RendererView?t:this.renderer_view(t))();this._invalidated_painters.add(e)}else{const t=(()=>e instanceof l.RendererView?e:this.renderer_view(e))();this._invalidated_painters.add(t)}}schedule_paint(){if(!this.is_paused){const e=this.throttled_paint();this._ready=this._ready.then((()=>e))}}request_layout(){this.request_paint("everything")}reset(){"standard"==this.model.reset_policy&&(this.state.clear(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new b.Reset)}remove(){for(const e of this.frame.ranges.values())e.plots.delete(this);(0,v.remove_views)(this.renderer_views),(0,v.remove_views)(this.tool_views),super.remove()}get_context_menu(e){const{x:t,y:i}=e;for(const e of(0,N.reversed)([...this.renderer_views.values()]))if(null!=e.context_menu&&1==e.interactive_hit?.(t,i))return e.context_menu;return super.get_context_menu(e)}initialize(){this.pause(),super.initialize(),this.lod_started=!1,this.visuals=new w.Visuals(this),this._initial_state={selection:new Map},this.frame=new r.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges,this.model.extra_x_scales,this.model.extra_y_scales);for(const e of this.frame.ranges.values())e.plots.add(this);this._range_manager=new C.RangeManager(this),this._state_manager=new A.StateManager(this,this._initial_state),this.throttled_paint=(0,k.throttle)((()=>{this.is_destroyed||this.repaint()}),1e3/60);const{title_location:e,title:t}=this.model;null!=e&&null!=t&&(this._title=t instanceof c.Title?t:new c.Title({text:t}));const{toolbar_location:i,toolbar_inner:s,toolbar:n}=this.model;null!=i&&(this._toolbar=new p.ToolbarPanel({toolbar:n}),n.location=i,n.inner=s);const{hidpi:a,output_backend:l}=this.model;this._canvas=new o.Canvas({hidpi:a,output_backend:l}),this._attribution=new m.Panel({position:new L.Node({target:"frame",symbol:"bottom_right"}),anchor:"bottom_right",elements:[],css_variables:{"--max-width":new L.Node({target:"frame",symbol:"width"})},stylesheets:[I.default]})}get elements(){return[this._canvas,this._attribution,...super.elements]}async lazy_initialize(){await super.lazy_initialize(),this.canvas_view=this._element_views.get(this._canvas),this.canvas_view.plot_views=[this],await this.build_tool_views(),await this.build_renderer_views(),this._range_manager.update_dataranges()}box_sizing(){const{width_policy:e,height_policy:t,...i}=super.box_sizing(),{frame_width:s,frame_height:n}=this.model;return{...i,width_policy:null!=s&&"auto"==e?"fit":e,height_policy:null!=n&&"auto"==t?"fit":t}}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"grid"}}_update_layout(){super._update_layout(),this._invalidate_all=!0,this._needs_paint=!0;const e=new V.BorderLayout,{frame_align:t}=this.model;if(e.aligns=(()=>{if((0,S.isBoolean)(t))return{left:t,right:t,top:t,bottom:t};{const{left:e=!0,right:i=!0,top:s=!0,bottom:n=!0}=t;return{left:e,right:i,top:s,bottom:n}}})(),e.set_sizing({width_policy:"max",height_policy:"max"}),this.visuals.outline_line.doit){const t=this.visuals.outline_line.line_width.get_value();e.center_border_width=t}const i=(0,N.copy)(this.model.above),s=(0,N.copy)(this.model.below),n=(0,N.copy)(this.model.left),a=(0,N.copy)(this.model.right),r=[],o=[],l=[],_=[],h=(e,t=!1)=>{switch(e){case"above":return t?r:i;case"below":return t?o:s;case"left":return t?l:n;case"right":return t?_:a}},{title_location:u}=this.model;if(null!=u&&null!=this._title&&h(u).push(this._title),null!=this._toolbar){const{location:e}=this._toolbar.toolbar;if(this.model.toolbar_inner){h(e,!0).push(this._toolbar)}else{const t=h(e);let i=!0;if(this.model.toolbar_sticky)for(let s=0;s<t.length;s++){const n=t[s];if(n instanceof c.Title){t[s]="above"==e||"below"==e?[n,this._toolbar]:[this._toolbar,n],i=!1;break}}i&&t.push(this._toolbar)}}const g=(e,t)=>{const i=this.renderer_view(t);return i.panel=new R.SidePanel(e),i.update_layout?.(),i.layout},m=(e,t)=>{const i="above"==e||"below"==e,s=[];for(const n of t)if((0,S.isArray)(n)){const t=n.map((t=>{const s=g(e,t);if(null!=s){if(t instanceof p.ToolbarPanel){const e=i?"width_policy":"height_policy";s.set_sizing({...s.sizing,[e]:"min"})}return s}})).filter((e=>null!=e));let a;i?(a=new P.Row(t),a.set_sizing({width_policy:"max",height_policy:"min"})):(a=new P.Column(t),a.set_sizing({width_policy:"min",height_policy:"max"})),a.absolute=!0,s.push(a)}else{const t=g(e,n);null!=t&&s.push(t)}return s},f=this.model.min_border??0;e.min_border={left:this.model.min_border_left??f,top:this.model.min_border_top??f,right:this.model.min_border_right??f,bottom:this.model.min_border_bottom??f};const b=new q.NodeLayout,v=new q.VStack,w=new q.VStack,y=new q.HStack,x=new q.HStack,z=new q.VStack,k=new q.VStack,$=new q.HStack,M=new q.HStack;b.absolute=!0,v.absolute=!0,w.absolute=!0,y.absolute=!0,x.absolute=!0,z.absolute=!0,k.absolute=!0,$.absolute=!0,M.absolute=!0,b.children=this.model.center.filter((e=>e instanceof d.Annotation)).map((e=>{const t=this.renderer_view(e);return t.update_layout?.(),t.layout})).filter((e=>null!=e));const{frame_width:T,frame_height:B}=this.model;b.set_sizing({...null!=T?{width_policy:"fixed",width:T}:{width_policy:"fit"},...null!=B?{height_policy:"fixed",height:B}:{height_policy:"fit"}}),b.on_resize((e=>this.frame.set_geometry(e))),v.children=(0,N.reversed)(m("above",i)),w.children=m("below",s),y.children=(0,N.reversed)(m("left",n)),x.children=m("right",a),z.children=m("above",r),k.children=m("below",o),$.children=m("left",l),M.children=m("right",_),v.set_sizing({width_policy:"fit",height_policy:"min"}),w.set_sizing({width_policy:"fit",height_policy:"min"}),y.set_sizing({width_policy:"min",height_policy:"fit"}),x.set_sizing({width_policy:"min",height_policy:"fit"}),z.set_sizing({width_policy:"fit",height_policy:"min"}),k.set_sizing({width_policy:"fit",height_policy:"min"}),$.set_sizing({width_policy:"min",height_policy:"fit"}),M.set_sizing({width_policy:"min",height_policy:"fit"}),e.center_panel=b,e.top_panel=v,e.bottom_panel=w,e.left_panel=y,e.right_panel=x,0!=z.children.length&&(e.inner_top_panel=z),0!=k.children.length&&(e.inner_bottom_panel=k),0!=$.children.length&&(e.inner_left_panel=$),0!=M.children.length&&(e.inner_right_panel=M),this.layout=e}_measure_layout(){const{frame_width:e,frame_height:t}=this.model,i=null==e?"1fr":(0,H.px)(e),s=null==t?"1fr":(0,H.px)(t),{layout:n}=this,a=n.top_panel.measure({width:1/0,height:1/0}),r=n.bottom_panel.measure({width:1/0,height:1/0}),o=n.left_panel.measure({width:1/0,height:1/0}),l=n.right_panel.measure({width:1/0,height:1/0}),_=E(a.height,n.min_border.top),h=E(r.height,n.min_border.bottom),d=E(o.width,n.min_border.left),c=E(l.width,n.min_border.right);this._computed_style.replace(`\n      :host {\n        grid-template-rows: ${_}px ${s} ${h}px;\n        grid-template-columns: ${d}px ${i} ${c}px;\n      }\n    `)}get axis_views(){const e=[];for(const[,t]of this.renderer_views)t instanceof u.AxisView&&e.push(t);return e}update_range(e,t){this.pause(),this._range_manager.update(e,t),this.unpause()}reset_range(){this.pause(),this._range_manager.reset(),this.unpause(),this.trigger_ranges_update_event()}trigger_ranges_update_event(e=[]){const{x_ranges:t,y_ranges:i}=this._range_manager.ranges(),s=[...t,...i,...e],n=new Set(s.flatMap((e=>[...e.plots])));for(const e of n){const{x_range:t,y_range:i}=e.model,s=new x.RangesUpdate(t.start,t.end,i.start,i.end);e.model.trigger_event(s)}}get_selection(){const e=new Map;for(const t of this.model.data_renderers){const{selected:i}=t.selection_manager.source;e.set(t,i)}return e}update_selection(e){for(const t of this.model.data_renderers){const i=t.selection_manager.source;if(null!=e){const s=e.get(t);null!=s&&i.selected.update(s,!0)}else i.selection_manager.clear()}}reset_selection(){this.update_selection(null)}_invalidate_layout_if_needed(){(()=>{for(const e of this.model.side_panels){const t=this.renderer_views.get(e);if(t.layout?.has_size_changed())return this.invalidate_painters(t),!0}return!1})()&&this.compute_layout()}get_renderer_views(){return this.computed_renderers.map((e=>this.renderer_views.get(e)))}*_compute_renderers(){const{above:e,below:t,left:i,right:s,center:n,renderers:a}=this.model;yield*a,yield*e,yield*t,yield*i,yield*s,yield*n,null!=this._title&&(yield this._title),null!=this._toolbar&&(yield this._toolbar);for(const[,e]of this.tool_views)yield*e.overlays}_update_attribution(){const e=[...this.model.attribution,...this.computed_renderer_views.map((e=>e?.attribution))].filter(S.isNotNull).map((e=>(0,S.isString)(e)?new f.Div({children:[e]}):e));this._attribution.elements=e}async build_renderer_views(){this.computed_renderers=[...this._compute_renderers()],await(0,v.build_views)(this.renderer_views,this.computed_renderers,{parent:this}),this._update_attribution()}async build_tool_views(){const e=(0,$.flat_map)(this.model.toolbar.tools,(e=>e instanceof _.ToolProxy?e.tools:[e])),{created:t}=await(0,v.build_views)(this.tool_views,[...e],{parent:this});t.map((e=>this.canvas_view.ui_event_bus.register_tool(e)))}connect_signals(){super.connect_signals();const{extra_x_ranges:e,extra_y_ranges:t,extra_x_scales:i,extra_y_scales:s}=this.model.properties;this.on_change([e,t,i,s],(()=>{this.frame.x_range=this.model.x_range,this.frame.y_range=this.model.y_range,this.frame.in_x_scale=this.model.x_scale,this.frame.in_y_scale=this.model.y_scale,this.frame.extra_x_ranges=this.model.extra_x_ranges,this.frame.extra_y_ranges=this.model.extra_y_ranges,this.frame.extra_x_scales=this.model.extra_x_scales,this.frame.extra_y_scales=this.model.extra_y_scales,this.frame.configure_scales()}));const{above:n,below:a,left:r,right:o,center:l,renderers:_}=this.model.properties,h=[n,a,r,o,l];this.on_change(_,(async()=>{await this.build_renderer_views()})),this.on_change(h,(async()=>{await this.build_renderer_views(),this.invalidate_layout()})),this.connect(this.model.toolbar.properties.tools.change,(async()=>{await this.build_tool_views(),await this.build_renderer_views()}));const{x_ranges:d,y_ranges:c}=this.frame;for(const[,e]of d)this.connect(e.change,(()=>{this.request_paint("everything")}));for(const[,e]of c)this.connect(e.change,(()=>{this.request_paint("everything")}));this.connect(this.model.change,(()=>this.request_paint("everything"))),this.connect(this.model.reset,(()=>this.reset()));const{toolbar_location:u}=this.model.properties;this.on_change(u,(async()=>{const{toolbar_location:e}=this.model;if(null!=this._toolbar)null!=e?this._toolbar.toolbar.location=e:(this._toolbar=void 0,await this.build_renderer_views());else if(null!=e){const{toolbar:t,toolbar_inner:i}=this.model;this._toolbar=new p.ToolbarPanel({toolbar:t}),t.location=e,t.inner=i,await this.build_renderer_views()}this.invalidate_layout()}));const{hold_render:g}=this.model.properties;this.on_change(g,(()=>this._hold_render_changed()))}has_finished(){if(!super.has_finished())return!1;if(this.model.visible)for(const[,e]of this.renderer_views)if(!e.has_finished())return!1;return!0}_after_layout(){super._after_layout(),this.unpause(!0);const e=this.layout.left_panel.bbox,t=this.layout.right_panel.bbox,i=this.layout.center_panel.bbox,s=this.layout.top_panel.bbox,n=this.layout.bottom_panel.bbox,{bbox:a}=this,r=s.bottom,o=a.height-n.top,l=e.right,_=a.width-t.left;this.canvas.style.replace(`\n      .bk-layer.bk-events {\n        display: grid;\n        grid-template-areas:\n          ".    above  .    "\n          "left center right"\n          ".    below  .    ";\n        grid-template-rows: ${(0,H.px)(r)} ${(0,H.px)(i.height)} ${(0,H.px)(o)};\n        grid-template-columns: ${(0,H.px)(l)} ${(0,H.px)(i.width)} ${(0,H.px)(_)};\n      }\n    `);for(const[,e]of this.renderer_views)e instanceof d.AnnotationView&&e.after_layout?.();this.model.setv({inner_width:Math.round(this.frame.bbox.width),inner_height:Math.round(this.frame.bbox.height),outer_width:Math.round(this.bbox.width),outer_height:Math.round(this.bbox.height)},{no_change:!0}),this.model.match_aspect&&(this.pause(),this._range_manager.update_dataranges(),this.unpause(!0)),this._outer_bbox.equals(this.bbox)||(this.canvas_view.resize(),this._outer_bbox=this.bbox,this._invalidate_all=!0,this._needs_paint=!0);const{inner_bbox:h}=this.layout;this._inner_bbox.equals(h)||(this._inner_bbox=h,this._invalidate_all=!0,this._needs_paint=!0),this._needs_paint&&this.paint()}repaint(){this._invalidate_layout_if_needed(),this.paint()}paint(){if(!this.is_paused){if(this.is_displayed)y.logger.trace(`${this.toString()}.paint()`),this._actual_paint();else for(const e of this.computed_renderer_views)e.mark_finished();this._needs_notify&&(this._needs_notify=!1,this.notify_finished())}}_actual_paint(){y.logger.trace(`${this.toString()}._actual_paint ${this._render_count} start`);const{document:e}=this.model;if(null!=e){const t=e.interactive_duration();t>=0&&t<this.model.lod_interval?setTimeout((()=>{e.interactive_duration()>this.model.lod_timeout&&e.interactive_stop(),this.request_paint("everything")}),this.model.lod_timeout):e.interactive_stop()}this._range_manager.invalidate_dataranges&&(this._range_manager.update_dataranges(),this._invalidate_layout_if_needed());let t=!1,i=!1;if(this._invalidate_all)t=!0,i=!0;else for(const e of this._invalidated_painters){const{level:s}=e.model;if("overlay"!=s?t=!0:i=!0,t&&i)break}this._invalidated_painters.clear(),this._invalidate_all=!1;const s=[this.frame.bbox.left,this.frame.bbox.top,this.frame.bbox.width,this.frame.bbox.height],{primary:n,overlays:a}=this.canvas_view;t&&(n.prepare(),this.canvas_view.prepare_webgl(s),this._paint_empty(n.ctx,s),this._paint_outline(n.ctx,s),this._paint_levels(n.ctx,"image",s,!0),this._paint_levels(n.ctx,"underlay",s,!0),this._paint_levels(n.ctx,"glyph",s,!0),this._paint_levels(n.ctx,"guide",s,!1),this._paint_levels(n.ctx,"annotation",s,!1),n.finish()),(i||D.settings.wireframe)&&(a.prepare(),this._paint_levels(a.ctx,"overlay",s,!1),D.settings.wireframe&&this.paint_layout(a.ctx,this.layout),a.finish()),null==this._initial_state.range&&(this._initial_state.range=this._range_manager.compute_initial()??void 0);for(const e of this.element_views)e.reposition();this._needs_paint=!1,this.repainted.emit(),y.logger.trace(`${this.toString()}._actual_paint ${this._render_count} end`),this._render_count++}_paint_levels(e,t,i,s){for(const n of this.computed_renderers){if(n.level!=t)continue;const a=this.renderer_views.get(n);e.save(),(s||a.needs_clip)&&(e.beginPath(),e.rect(...i),e.clip()),a.render(),e.restore(),a.has_webgl&&this.canvas_view.blit_webgl(e)}}paint_layout(e,t){const{x:i,y:s,width:n,height:a}=t.bbox;e.strokeStyle="blue",e.strokeRect(i,s,n,a);for(const n of t)e.save(),t.absolute||e.translate(i,s),this.paint_layout(e,n),e.restore()}_paint_empty(e,t){const[i,s,n,a]=[0,0,this.bbox.width,this.bbox.height],[r,o,l,_]=t;this.visuals.border_fill.doit&&(e.save(),e.beginPath(),e.rect(i,s,n,a),e.rect(r,o,l,_),e.clip("evenodd"),e.beginPath(),e.rect(i,s,n,a),this.visuals.border_fill.apply(e),e.restore()),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),e.fillRect(r,o,l,_))}_paint_outline(e,t){if(this.visuals.outline_line.doit){e.save(),this.visuals.outline_line.set_value(e);let[i,s,n,a]=t;i+n==this.bbox.width&&(n-=1),s+a==this.bbox.height&&(a-=1),e.strokeRect(i,s,n,a),e.restore()}}export(e="auto",t=!0){const i=(()=>{switch(e){case"auto":return this.canvas_view.model.output_backend;case"png":return"canvas";case"svg":return"svg"}})(),s=new M.CanvasLayer(i,t),{width:n,height:a}=this.bbox;if(s.resize(n,a),0!=n&&0!=a){const{canvas:e}=this.canvas_view.compose();s.ctx.drawImage(e,0,0)}return s}serializable_state(){const{children:e,...t}=super.serializable_state(),i=this.get_renderer_views().filter((e=>e.model.syncable)).map((e=>e.serializable_state())).filter((e=>null!=e.bbox));return{...t,children:[...e??[],{type:"CartesianFrame",bbox:this.frame.bbox},...i]}}_hold_render_changed(){this.model.hold_render?this.pause():this.unpause()}resolve_frame(){return this.frame}resolve_canvas(){return this.canvas}resolve_plot(){return this}resolve_xy(e){const{x:t,y:i}=e,s=this.frame.x_scale.compute(t),n=this.frame.y_scale.compute(i);return this.frame.bbox.contains(s,n)?{x:s,y:n}:{x:NaN,y:NaN}}resolve_indexed(e){const{index:t,renderer:i}=e,s=this.renderer_view(i);if(null!=s&&s.has_finished()){const[e,i]=s.glyph.scenterxy(t,NaN,NaN);if(this.frame.bbox.contains(e,i))return{x:e,y:i}}return{x:NaN,y:NaN}}}i.PlotView=O,O.__name__="PlotView"},
function _(e,t,s,o,n){var i;o();const r=e(1),a=e(397),l=e(60),h=e(59),c=e(182),p=r.__importStar(e(183)),_=e(63),d=r.__importStar(e(430));class u extends a.PaneView{stylesheets(){return[...super.stylesheets(),d.default]}connect_signals(){super.connect_signals();const{position:e,anchor:t,width:s,height:o,elements:n}=this.model.properties;this.on_change([t,s,o,n],(()=>this.reposition())),this.on_transitive_change(e,(()=>this.reposition()))}reposition(e){super.reposition(e);const{position:t,visible:s,anchor:o,elements:n}=this.model;if(0==e||!s||0==n.length)return void this.el.remove();const{x:i,y:r}=this.resolve_as_xy(t);if(!isFinite(i+r))return void this.el.remove();const a=this.parent?.el??document.body,l=a.shadowRoot??a;this.el.isConnected||l.append(this.el),this.el.style.left=(0,_.px)(i),this.el.style.top=(0,_.px)(r);const h=p.anchor(o);this.el.style.transform=`translate(${-100*h.x}%, ${-100*h.y}%)`}}s.PanelView=u,u.__name__="PanelView";class m extends a.Pane{constructor(e){super(e)}}s.Panel=m,i=m,m.__name__="Panel",i.prototype.default_view=u,i.define((({Ref:e,Or:t,Auto:s,Int:o})=>({position:[e(l.Coordinate)],anchor:[c.Anchor,"top_left"],width:[t(s,o,e(h.Node)),"auto"],height:[t(s,o,e(h.Node)),"auto"]})))},
function _(o,t,i,n,u){n(),i.default=":host{position:absolute;background-color:white;}"},
function _(e,a,_,n,t){var l,s,i,m;n();const w=e(432);class o extends w.DOMElementView{}_.SpanView=o,o.__name__="SpanView",o.tag_name="span";class d extends w.DOMElement{}_.Span=d,l=d,d.__name__="Span",l.prototype.default_view=o;class p extends w.DOMElementView{}_.DivView=p,p.__name__="DivView",p.tag_name="div";class D extends w.DOMElement{}_.Div=D,s=D,D.__name__="Div",s.prototype.default_view=p;class V extends w.DOMElementView{}_.TableView=V,V.__name__="TableView",V.tag_name="table";class c extends w.DOMElement{}_.Table=c,i=c,c.__name__="Table",i.prototype.default_view=V;class v extends w.DOMElementView{}_.TableRowView=v,v.__name__="TableRowView",v.tag_name="tr";class b extends w.DOMElement{}_.TableRow=b,m=b,b.__name__="TableRow",m.prototype.default_view=v},
function _(e,i,s,t,l){var n;t();const r=e(122),d=e(107),h=e(56),c=e(8),o=e(65),a=e(63);class _ extends r.DOMNodeView{constructor(){super(...arguments),this.child_views=new Map}*children(){yield*super.children(),yield*this.child_views.values()}async lazy_initialize(){await super.lazy_initialize();const e=this.model.children.filter((e=>!(0,c.isString)(e)));await(0,h.build_views)(this.child_views,e,{parent:this})}remove(){(0,h.remove_views)(this.child_views),super.remove()}render(){(0,a.empty)(this.el),(0,o.apply_styles)(this.el.style,this.model.style);for(const e of this.model.children)if((0,c.isString)(e)){const i=document.createTextNode(e);this.el.appendChild(i)}else{this.child_views.get(e).render_to(this.el)}this.finish()}}s.DOMElementView=_,_.__name__="DOMElementView";class m extends r.DOMNode{constructor(e){super(e)}}s.DOMElement=m,n=m,m.__name__="DOMElement",n.define((({Str:e,List:i,Or:s,Ref:t})=>({style:[d.StylesLike,{}],children:[i(s(e,t(r.DOMNode),t(d.UIElement))),[]]})))},
function _(n,t,e,l,u){l(),e.throttle=function(n,t){let e,l=null,u=null,o=0,i=!1;const r=function(){return new Promise(((r,c)=>{e=r;const a=function(){o=Date.now(),l=null,u=null,i=!1;try{n(),r()}catch(n){c(n)}},m=Date.now(),s=t-(m-o);s<=0&&!i?(null!=l&&clearTimeout(l),i=!0,u=requestAnimationFrame(a)):null!=l||i?r():l=setTimeout((()=>u=requestAnimationFrame(a)),s)}))};return r.stop=function(){null!=l&&clearTimeout(l),null!=u&&cancelAnimationFrame(u),e()},r}},
function _(t,n,e,a,s){a();const o=t(102),r=t(19);class l{constructor(t){this.invalidate_dataranges=!0,this.parent=t}get frame(){return this.parent.frame}update(t,n={}){const e=new Map;for(const[n,a]of t.xrs)e.set(n,a);for(const[n,a]of t.yrs)e.set(n,a);n.scrolling&&this._update_ranges_together(e),this._update_ranges_individually(e,n)}ranges(){const t=new Set,n=new Set;for(const n of this.frame.x_ranges.values())t.add(n);for(const t of this.frame.y_ranges.values())n.add(t);for(const e of this.parent.model.data_renderers){const{coordinates:a}=e;null!=a&&(t.add(a.x_source),n.add(a.y_source))}return{x_ranges:[...t],y_ranges:[...n]}}reset(){const{x_ranges:t,y_ranges:n}=this.ranges();for(const n of t)n.reset();for(const t of n)t.reset();this.update_dataranges()}_update_dataranges(t){const n=new Map,e=new Map;let a=!1;for(const[,n]of t.x_ranges)n instanceof o.DataRange1d&&"log"==n.scale_hint&&(a=!0);for(const[,n]of t.y_ranges)n instanceof o.DataRange1d&&"log"==n.scale_hint&&(a=!0);for(const t of this.parent.auto_ranged_renderers){const s=t.bounds();if(n.set(t.model,s),a){const n=t.log_bounds();e.set(t.model,n)}}let s=!1,l=!1;const i=t.x_target.span,d=t.y_target.span;let _;!1!==this.parent.model.match_aspect&&0!=i&&0!=d&&(_=1/this.parent.model.aspect_scale*(i/d));for(const[,a]of t.x_ranges){if(a instanceof o.DataRange1d){const t="log"==a.scale_hint?e:n;a.update(t,0,this.parent,_),null!=a.follow&&(s=!0)}null!=a.bounds&&(l=!0)}for(const[,a]of t.y_ranges){if(a instanceof o.DataRange1d){const t="log"==a.scale_hint?e:n;a.update(t,1,this.parent,_),null!=a.follow&&(s=!0)}null!=a.bounds&&(l=!0)}if(s&&l){r.logger.warn("Follow enabled so bounds are unset.");for(const[,n]of t.x_ranges)n.bounds=null;for(const[,n]of t.y_ranges)n.bounds=null}}update_dataranges(){this._update_dataranges(this.frame);for(const t of this.parent.auto_ranged_renderers){const{coordinates:n}=t.model;null!=n&&this._update_dataranges(n)}null!=this.compute_initial()&&(this.invalidate_dataranges=!1)}compute_initial(){let t=!0;const{x_ranges:n,y_ranges:e}=this.frame,a=new Map,s=new Map;for(const[,e]of n){const{start:n,end:s}=e;if(isNaN(n+s)){t=!1;break}a.set(e,{start:n,end:s})}if(t)for(const[,n]of e){const{start:e,end:a}=n;if(isNaN(e+a)){t=!1;break}s.set(n,{start:e,end:a})}return t?{xrs:a,yrs:s}:(r.logger.warn("could not set initial ranges"),null)}_update_ranges_together(t){let n=1;for(const[e,a]of t)n=Math.min(n,this._get_weight_to_constrain_interval(e,a));if(n<1)for(const[e,a]of t)a.start=n*a.start+(1-n)*e.start,a.end=n*a.end+(1-n)*e.end}_update_ranges_individually(t,n={}){const e=n.panning??!1,a=n.scrolling??!1,s=n.maintain_focus??!1;let o=!1;for(const[n,s]of t){if(!a){const t=this._get_weight_to_constrain_interval(n,s);t<1&&(s.start=t*s.start+(1-t)*n.start,s.end=t*s.end+(1-t)*n.end)}if(null!=n.bounds){const[t,r]=n.computed_bounds,l=Math.abs(s.end-s.start);n.is_reversed?(t>s.end&&(o=!0,s.end=t,(e||a)&&(s.start=t+l)),r<s.start&&(o=!0,s.start=r,(e||a)&&(s.end=r-l))):(t>s.start&&(o=!0,s.start=t,(e||a)&&(s.end=t+l)),r<s.end&&(o=!0,s.end=r,(e||a)&&(s.start=r-l)))}}if(!(a&&o&&s))for(const[n,e]of t)n.have_updated_interactively=!0,n.start==e.start&&n.end==e.end||n.setv(e)}_get_weight_to_constrain_interval(t,n){const{min_interval:e}=t;let{max_interval:a}=t;if(null!=t.bounds&&"auto"!=t.bounds){const[n,e]=t.bounds;if(null!=n&&null!=e){const t=Math.abs(e-n);a=null!=a?Math.min(a,t):t}}let s=1;if(null!=e||null!=a){const o=Math.abs(t.end-t.start),r=Math.abs(n.end-n.start);null!=e&&e>0&&r<e&&(s=(o-e)/(o-r)),null!=a&&a>0&&r>a&&(s=(a-o)/(r-o)),s=Math.max(0,Math.min(1,s))}return s}}e.RangeManager=l,l.__name__="RangeManager"},
function _(t,i,e,s,n){s();const h=t(15);class a{constructor(t,i){this.history=[],this.index=-1,this.parent=t,this.initial_state=i,this.changed=new h.Signal0(this.parent,"state_changed")}_do_state_change(t){const i=t in this.history?this.history[t].state:this.initial_state;return null!=i.range&&this.parent.update_range(i.range),null!=i.selection&&this.parent.update_selection(i.selection),i}peek(){return this.can_undo?this.history[this.index]:null}push(t,i){const{history:e,index:s}=this,n=s in e?e[s].state:{},h={...this.initial_state,...n,...i};this.history=this.history.slice(0,this.index+1),this.history.push({type:t,state:h}),this.index=this.history.length-1,this.changed.emit()}clear(){this.history=[],this.index=-1,this.changed.emit()}undo(){if(this.can_undo){this.index-=1;const t=this._do_state_change(this.index);return this.changed.emit(),t}return null}redo(){if(this.can_redo){this.index+=1;const t=this._do_state_change(this.index);return this.changed.emit(),t}return null}get can_undo(){return this.index>=0}get can_redo(){return this.index<this.history.length-1}}e.StateManager=a,a.__name__="StateManager"},
function _(a,r,t,e,n){e(),t.Canvas="bk-Canvas",t.default=':host{display:grid;grid-template-areas:".    above  .    " "left center right" ".    below  .    ";grid-template-rows:0px 1fr 0px;grid-template-columns:0px 1fr 0px;}.bk-Canvas{grid-row-start:1;grid-row-end:span 3;grid-column-start:1;grid-column-end:span 3;}'},
function _(o,e,i,a,l){a(),i.default=":host{display:flex;flex-direction:column;flex-wrap:nowrap;padding:2px;background-color:rgba(255, 255, 255, 0.5);font-size:9px;line-height:1.05;white-space:nowrap;max-width:var(--max-width);}:host > *{overflow:hidden;text-overflow:ellipsis;text-align:right;}a{color:black;}"},
function _(t,e,s,i,o){i();const a=t(19),n=t(15),p=t(63),_=t(131),l=t(428);const h=new n.Signal0({},"gmaps_ready");class m extends l.PlotView{initialize(){super.initialize(),this._tiles_loaded=!1,this.zoom_count=0;const{zoom:t,lat:e,lng:s}=this.model.map_options;this.initial_zoom=t,this.initial_lat=e,this.initial_lng=s;const i=new TextDecoder("utf-8");if(this._api_key=i.decode(this.model.api_key),""==this._api_key){const t="https://developers.google.com/maps/documentation/javascript/get-api-key";a.logger.error(`api_key is required. See ${t} for more information on how to obtain your own.`)}}async lazy_initialize(){if(await super.lazy_initialize(),this.map_el=(0,p.div)({style:{position:"absolute"}}),this.canvas_view.add_underlay(this.map_el),"undefined"==typeof google||void 0===google.maps){if(void 0===window._bokeh_gmaps_callback){const{api_version:t}=this.model;!function(t,e){window._bokeh_gmaps_callback=()=>h.emit();const s=encodeURIComponent,i=document.createElement("script");i.type="text/javascript",i.src=`https://maps.googleapis.com/maps/api/js?v=${s(e)}&key=${s(t)}&callback=_bokeh_gmaps_callback`,document.body.appendChild(i)}(this._api_key,t)}h.connect((()=>{this._build_map(),this.request_paint("everything")}))}else this._build_map()}remove(){(0,p.remove)(this.map_el),super.remove()}update_range(t,e){if(null==t)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),super.reset_range();else if(null!=t.sdx||null!=t.sdy)this.map.panBy(t.sdx??0,t.sdy??0),super.update_range(t,e);else if(null!=t.factor){if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),super.update_range(t,e);const s=t.factor<0?-1:1,i=this.map.getZoom();if(null!=i){const t=i+s;if(t>=2){this.map.setZoom(t);const[e,s]=this._get_projected_bounds();s-e<0&&this.map.setZoom(i)}}this.unpause()}this._set_bokeh_ranges()}_build_map(){const{maps:t}=google;this.map_types={satellite:t.MapTypeId.SATELLITE,terrain:t.MapTypeId.TERRAIN,roadmap:t.MapTypeId.ROADMAP,hybrid:t.MapTypeId.HYBRID};const e=this.model.map_options,s={center:new t.LatLng(e.lat,e.lng),zoom:e.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[e.map_type],scaleControl:e.scale_control,tilt:e.tilt};null!=e.styles&&(s.styles=JSON.parse(e.styles)),this.map=new t.Map(this.map_el,s),t.event.addListener(this.map,"idle",(()=>this._set_bokeh_ranges())),t.event.addListener(this.map,"bounds_changed",(()=>this._set_bokeh_ranges())),t.event.addListenerOnce(this.map,"tilesloaded",(()=>this._render_finished())),this.connect(this.model.properties.map_options.change,(()=>this._update_options())),this.connect(this.model.map_options.properties.styles.change,(()=>this._update_styling())),this.connect(this.model.map_options.properties.lat.change,(()=>this._update_center("lat"))),this.connect(this.model.map_options.properties.lng.change,(()=>this._update_center("lng"))),this.connect(this.model.map_options.properties.zoom.change,(()=>this._update_zoom())),this.connect(this.model.map_options.properties.map_type.change,(()=>this._update_map_type())),this.connect(this.model.map_options.properties.scale_control.change,(()=>this._update_scale_control())),this.connect(this.model.map_options.properties.tilt.change,(()=>this._update_tilt()))}_render_finished(){this._tiles_loaded=!0,this.notify_finished()}has_finished(){return super.has_finished()&&!0===this._tiles_loaded}_get_latlon_bounds(){const t=this.map.getBounds(),e=t.getNorthEast(),s=t.getSouthWest();return[s.lng(),e.lng(),s.lat(),e.lat()]}_get_projected_bounds(){const[t,e,s,i]=this._get_latlon_bounds(),[o,a]=_.wgs84_mercator.compute(t,s),[n,p]=_.wgs84_mercator.compute(e,i);return[o,n,a,p]}_set_bokeh_ranges(){const[t,e,s,i]=this._get_projected_bounds();this.frame.x_range.setv({start:t,end:e}),this.frame.y_range.setv({start:s,end:i})}_update_center(t){const e=this.map.getCenter()?.toJSON();null!=e&&(e[t]=this.model.map_options[t],this.map.setCenter(e),this._set_bokeh_ranges())}_update_map_type(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})}_update_scale_control(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})}_update_tilt(){this.map.setOptions({tilt:this.model.map_options.tilt})}_update_options(){this._update_styling(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()}_update_styling(){const{styles:t}=this.model.map_options;this.map.setOptions({styles:null!=t?JSON.parse(t):null})}_update_zoom(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()}_after_layout(){super._after_layout();const{left:t,top:e,width:s,height:i}=this.frame.bbox;this.map_el.style.top=`${e}px`,this.map_el.style.left=`${t}px`,this.map_el.style.width=`${s}px`,this.map_el.style.height=`${i}px`}}s.GMapPlotView=m,m.__name__="GMapPlotView"},
function _(e,a,t,s,p){var _;s();const l=e(426);class r extends l.GMapPlotView{serializable_state(){return{...super.serializable_state(),type:"GMapPlot"}}}t.GMapView=r,r.__name__="GMapView";class i extends l.GMapPlot{constructor(e){super(e)}}t.GMap=i,_=i,i.__name__="GMap",_.prototype.default_view=r},
function _(i,o,t,e,s){var l;e();const n=i(396),a=i(400),r=i(182),c=i(288),_=i(299),d=i(56),h=i(20);class u extends n.LayoutDOMView{constructor(){super(...arguments),this._tool_views=new Map}get toolbar_view(){return this.child_views.find((i=>i.model==this.model.toolbar))}get grid_box_view(){return this.child_views.find((i=>i.model==this._grid_box))}_update_location(){const i=this.model.toolbar_location;null==i?this.model.toolbar.visible=!1:this.model.toolbar.setv({visible:!0,location:i})}initialize(){super.initialize(),this._update_location();const{children:i,rows:o,cols:t,spacing:e}=this.model;this._grid_box=new a.GridBox({children:i,rows:o,cols:t,spacing:e,sizing_mode:"inherit"})}async lazy_initialize(){await super.lazy_initialize(),await this.build_tool_views()}connect_signals(){super.connect_signals();const{toolbar:i,toolbar_location:o,children:t,rows:e,cols:s,spacing:l}=this.model.properties;this.on_change(o,(async()=>{this._update_location(),this.invalidate_layout()})),this.on_change([i,t,e,s,l],(async()=>{await this.update_children()})),this.on_change(this.model.toolbar.properties.tools,(async()=>{await this.build_tool_views()})),this.mouseenter.connect((()=>{this.toolbar_view.set_visibility(!0)})),this.mouseleave.connect((()=>{this.toolbar_view.set_visibility(!1)}))}remove(){(0,d.remove_views)(this._tool_views),super.remove()}async build_tool_views(){const i=this.model.toolbar.tools.filter((i=>i instanceof _.ActionTool));await(0,d.build_views)(this._tool_views,i,{parent:this})}*children(){yield*super.children(),yield*this._tool_views.values()}get child_models(){return[this.model.toolbar,this._grid_box]}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"flex"}}_update_layout(){super._update_layout();const{location:i}=this.model.toolbar,o=(()=>{switch(i){case"above":return"column";case"below":return"column-reverse";case"left":return"row";case"right":return"row-reverse"}})();this.style.append(":host",{flex_direction:o})}}t.GridPlotView=u,u.__name__="GridPlotView";class w extends n.LayoutDOM{constructor(i){super(i)}}t.GridPlot=w,l=w,w.__name__="GridPlot",l.prototype.default_view=u,l.define((({List:i,Ref:o,Nullable:t})=>({toolbar:[o(c.Toolbar),()=>new c.Toolbar],toolbar_location:[t(h.Location),"above"],children:[i((0,r.GridChild)(n.LayoutDOM)),[]],rows:[t(r.TracksSizing),null],cols:[t(r.TracksSizing),null],spacing:[r.GridSpacing,0]})))},
function _(e,t,r,s,i){var a;s();const _=e(427);class l extends _.PlotView{serializable_state(){return{...super.serializable_state(),type:"Plot"}}}r.FigureView=l,l.__name__="FigureView";class u extends _.Plot{constructor(e){super(e)}}r.Figure=u,a=u,u.__name__="Figure",a.prototype.default_view=l},
function _(t,_,n,o,r){o();t(1).__exportStar(t(190),n)},
function _(l,r,i,a,e){a(),e("ParkMillerLCG",l(444).ParkMillerLCG)},
function _(e,n,r,a,t){var l;a();const o=e(422),s=e(113);class d extends o.RandomGenerator{constructor(e){super(e)}generator(){return new s.LCGRandom(this.seed??Date.now())}}r.ParkMillerLCG=d,l=d,d.__name__="ParkMillerLCG",l.define((({Int:e,Nullable:n})=>({seed:[n(e),null]})))},
function _(e,r,n,d,R){d(),R("ContourRenderer",e(446).ContourRenderer),R("GlyphRenderer",e(214).GlyphRenderer),R("GraphRenderer",e(447).GraphRenderer),R("GuideRenderer",e(187).GuideRenderer);var G=e(81);R("Renderer",G.Renderer),R("RendererGroup",G.RendererGroup)},
function _(e,i,r,n,l){var t;n();const _=e(215),s=e(214),d=e(56);class a extends _.DataRendererView{*children(){yield*super.children(),yield this.fill_view,yield this.line_view}get glyph_view(){return this.fill_view.glyph.data_size>0?this.fill_view.glyph:this.line_view.glyph}async lazy_initialize(){await super.lazy_initialize();const{parent:e}=this,{fill_renderer:i,line_renderer:r}=this.model;this.fill_view=await(0,d.build_view)(i,{parent:e}),this.line_view=await(0,d.build_view)(r,{parent:e})}remove(){this.fill_view.remove(),this.line_view.remove(),super.remove()}_render(){this.fill_view.render(),this.line_view.render()}renderer_view(e){if(e instanceof s.GlyphRenderer){if(e==this.fill_view.model)return this.fill_view;if(e==this.line_view.model)return this.line_view}return super.renderer_view(e)}}r.ContourRendererView=a,a.__name__="ContourRendererView";class h extends _.DataRenderer{constructor(e){super(e)}get_selection_manager(){return this.fill_renderer.data_source.selection_manager}}r.ContourRenderer=h,t=h,h.__name__="ContourRenderer",t.prototype.default_view=a,t.define((({List:e,Float:i,Ref:r})=>({fill_renderer:[r(s.GlyphRenderer)],line_renderer:[r(s.GlyphRenderer)],levels:[e(i),[]]})))},
function _(e,r,i,n,t){var s;n();const d=e(215),o=e(214),a=e(389),l=e(388),h=e(56),_=e(217),p=e(367),y=e(369);class g extends d.DataRendererView{get glyph_view(){return this.node_view.glyph}*children(){yield*super.children(),yield this.edge_view,yield this.node_view}async lazy_initialize(){await super.lazy_initialize(),this.apply_coordinates();const{parent:e}=this,{edge_renderer:r,node_renderer:i}=this.model;this.edge_view=await(0,h.build_view)(r,{parent:e}),this.node_view=await(0,h.build_view)(i,{parent:e})}connect_signals(){super.connect_signals(),this.connect(this.model.layout_provider.change,(async()=>{this.apply_coordinates(),await this.edge_view.set_data(),await this.node_view.set_data(),this.request_render()}))}apply_coordinates(){const{edge_renderer:e,node_renderer:r}=this.model;if(!(e.glyph instanceof p.MultiLine||e.glyph instanceof y.Patches))throw new Error(`${this}.edge_renderer.glyph must be a MultiLine glyph`);if(!(r.glyph instanceof _.XYGlyph))throw new Error(`${this}.node_renderer.glyph must be a XYGlyph glyph`);const i=this.model.layout_provider.edge_coordinates,n=this.model.layout_provider.node_coordinates;e.glyph.properties.xs.internal=!0,e.glyph.properties.ys.internal=!0,r.glyph.properties.x.internal=!0,r.glyph.properties.y.internal=!0,e.glyph.xs={expr:i.x},e.glyph.ys={expr:i.y},r.glyph.x={expr:n.x},r.glyph.y={expr:n.y}}remove(){this.edge_view.remove(),this.node_view.remove(),super.remove()}_render(){this.edge_view.render(),this.node_view.render()}get has_webgl(){return this.edge_view.has_webgl||this.node_view.has_webgl}renderer_view(e){if(e instanceof o.GlyphRenderer){if(e==this.edge_view.model)return this.edge_view;if(e==this.node_view.model)return this.node_view}return super.renderer_view(e)}}i.GraphRendererView=g,g.__name__="GraphRendererView";class w extends d.DataRenderer{constructor(e){super(e)}get_selection_manager(){return this.node_renderer.data_source.selection_manager}}i.GraphRenderer=w,s=w,w.__name__="GraphRenderer",s.prototype.default_view=g,s.define((({Ref:e})=>({layout_provider:[e(a.LayoutProvider)],node_renderer:[e(o.GlyphRenderer)],edge_renderer:[e(o.GlyphRenderer)],selection_policy:[e(l.GraphHitTestPolicy),()=>new l.NodesOnly],inspection_policy:[e(l.GraphHitTestPolicy),()=>new l.NodesOnly]})))},
function _(e,t,n,o,c){o();e(1).__exportStar(e(128),n),c("Selection",e(127).Selection)},
function _(y,B,a,s,C){s(),C("ByID",y(450).ByID),C("ByClass",y(451).ByClass),C("ByCSS",y(452).ByCSS),C("ByXPath",y(453).ByXPath)},
function _(e,n,r,t,c){t();const o=e(410);class s extends o.Selector{constructor(e){super(e)}find_one(e){return e.querySelector(`#${this.query}`)}}r.ByID=s,s.__name__="ByID"},
function _(e,s,n,r,t){r();const c=e(410);class o extends c.Selector{constructor(e){super(e)}find_one(e){return e.querySelector(`.${this.query}`)}}n.ByClass=o,o.__name__="ByClass"},
function _(e,n,r,t,c){t();const o=e(410);class s extends o.Selector{constructor(e){super(e)}find_one(e){return e.querySelector(this.query)}}r.ByCSS=s,s.__name__="ByCSS"},
function _(e,t,n,r,a){r();const c=e(410);class o extends c.Selector{constructor(e){super(e)}find_one(e){return document.evaluate(this.query,e).iterateNext()}}n.ByXPath=o,o.__name__="ByXPath"},
function _(a,e,S,o,r){o(),r("ServerSentDataSource",a(455).ServerSentDataSource),r("AjaxDataSource",a(457).AjaxDataSource),r("ColumnDataSource",a(130).ColumnDataSource),r("ColumnarDataSource",a(125).ColumnarDataSource),r("CDSView",a(233).CDSView),r("DataSource",a(129).DataSource),r("GeoJSONDataSource",a(458).GeoJSONDataSource),r("WebDataSource",a(456).WebDataSource)},
function _(e,t,a,i,s){i();const n=e(456);class r extends n.WebDataSource{constructor(e){super(e),this.initialized=!1}setup(){if(!this.initialized){this.initialized=!0;new EventSource(this.data_url).onmessage=async e=>{await this.load_data(JSON.parse(e.data),this.mode,this.max_size??void 0)}}}}a.ServerSentDataSource=r,r.__name__="ServerSentDataSource"},
function _(t,e,a,n,s){var r;n();const c=t(130),l=t(20),i=t(50),o=t(9);class u extends c.ColumnDataSource{constructor(t){super(t)}get_column(t){return(0,o.dict)(this.data).get(t)??[]}get_length(){return super.get_length()??0}initialize(){super.initialize(),this.setup()}async load_data(t,e,a){const{adapter:n}=this;let s;switch(s=null!=n?await(0,i.execute)(n,this,{response:t}):t,e){case"replace":break;case"append":{const t=(0,o.dict)(this.data),e=(0,o.dict)(s);for(const n of this.columns()){const s=Array.from(t.get(n)??[]),r=Array.from(e.get(n)??[]),c=s.concat(r);e.set(n,null!=a?c.slice(-a):c)}break}}this.data=s}}a.WebDataSource=u,r=u,u.__name__="WebDataSource",r.define((({Any:t,Int:e,Str:a,Nullable:n})=>({max_size:[n(e),null],mode:[l.UpdateMode,"replace"],adapter:[n(t),null],data_url:[a]})))},
function _(t,e,i,s,a){var r;s();const n=t(456),o=t(20),l=t(19),d=t(9);class h extends n.WebDataSource{constructor(t){super(t),this.interval=null,this.initialized=!1}destroy(){null!=this.interval&&clearInterval(this.interval),super.destroy()}setup(){if(!this.initialized&&(this.initialized=!0,this.get_data(this.mode),null!=this.polling_interval)){const t=()=>this.get_data(this.mode,this.max_size,this.if_modified);this.interval=setInterval(t,this.polling_interval)}}get_data(t,e=null,i=!1){const s=this.prepare_request();s.addEventListener("load",(()=>this.do_load(s,t,e??void 0))),s.addEventListener("error",(()=>this.do_error(s))),s.send()}prepare_request(){const t=new XMLHttpRequest;t.open(this.method,this.data_url,!0),t.withCredentials=!1,t.setRequestHeader("Content-Type",this.content_type);for(const[e,i]of(0,d.entries)(this.http_headers))t.setRequestHeader(e,i);return t}async do_load(t,e,i){if(200==t.status){const s=JSON.parse(t.responseText);await this.load_data(s,e,i)}}do_error(t){l.logger.error(`Failed to fetch JSON from ${this.data_url} with code ${t.status}`)}}i.AjaxDataSource=h,r=h,h.__name__="AjaxDataSource",r.define((({Bool:t,Int:e,Str:i,Dict:s,Nullable:a})=>({polling_interval:[a(e),null],content_type:[i,"application/json"],http_headers:[s(i),{}],method:[o.HTTPMethod,"POST"],if_modified:[t,!1]})))},
function _(e,t,o,r,n){var s;r();const a=e(125),i=e(19),c=e(8),l=e(10),_=e(9);function g(e){return null!=e?e:NaN}class u extends a.ColumnarDataSource{constructor(e){super(e)}initialize(){super.initialize(),this._update_data()}connect_signals(){super.connect_signals(),this.connect(this.properties.geojson.change,(()=>this._update_data()))}_update_data(){this.data=this.geojson_to_column_data()}_get_new_list_array(e){return(0,l.range)(0,e).map((e=>[]))}_get_new_nan_array(e){return(0,l.range)(0,e).map((e=>NaN))}_add_properties(e,t,o,r){const n=e.properties??{},s=(0,_.dict)(t);for(const[e,a]of(0,_.dict)(n))s.has(e)||(t[e]=this._get_new_nan_array(r)),t[e][o]=g(a)}_add_geometry(e,t,o){function r(e,t){return e.concat([[NaN,NaN,NaN]]).concat(t)}switch(e.type){case"Point":{const[r,n,s]=e.coordinates;t.x[o]=r,t.y[o]=n,t.z[o]=g(s);break}case"LineString":{const{coordinates:r}=e;for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=g(a)}break}case"Polygon":{e.coordinates.length>1&&i.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");const r=e.coordinates[0];for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=g(a)}break}case"MultiPoint":i.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":{const n=e.coordinates.reduce(r);for(let e=0;e<n.length;e++){const[r,s,a]=n[e];t.xs[o][e]=r,t.ys[o][e]=s,t.zs[o][e]=g(a)}break}case"MultiPolygon":{const n=[];for(const t of e.coordinates)t.length>1&&i.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),n.push(t[0]);const s=n.reduce(r);for(let e=0;e<s.length;e++){const[r,n,a]=s[e];t.xs[o][e]=r,t.ys[o][e]=n,t.zs[o][e]=g(a)}break}default:throw new Error(`Invalid GeoJSON geometry type: ${e.type}`)}}geojson_to_column_data(){const e=JSON.parse(this.geojson);let t;switch(e.type){case"GeometryCollection":if((0,c.is_undefined)(e.geometries))throw new Error("No geometries found in GeometryCollection");if(0===e.geometries.length)throw new Error("geojson.geometries must have one or more items");t=e.geometries;break;case"FeatureCollection":if((0,c.is_undefined)(e.features))throw new Error("No features found in FeaturesCollection");if(0==e.features.length)throw new Error("geojson.features must have one or more items");t=e.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}let o=0;for(const e of t){const t="Feature"===e.type?e.geometry:e;"GeometryCollection"==t.type?o+=t.geometries.length:o+=1}const r={x:this._get_new_nan_array(o),y:this._get_new_nan_array(o),z:this._get_new_nan_array(o),xs:this._get_new_list_array(o),ys:this._get_new_list_array(o),zs:this._get_new_list_array(o)};let n=0;for(const e of t){const t="Feature"==e.type?e.geometry:e;if("GeometryCollection"==t.type)for(const s of t.geometries)this._add_geometry(s,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1;else this._add_geometry(t,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1}return r}}o.GeoJSONDataSource=u,s=u,u.__name__="GeoJSONDataSource",s.define((({Str:e})=>({geojson:[e]}))),s.internal((({Unknown:e,Dict:t,Arrayable:o})=>({data:[t(o(e)),{}]})))},
function _(e,r,T,o,S){o(),S("BBoxTileSource",e(460).BBoxTileSource),S("MercatorTileSource",e(461).MercatorTileSource),S("QUADKEYTileSource",e(464).QUADKEYTileSource),S("TileRenderer",e(465).TileRenderer),S("TileSource",e(462).TileSource),S("TMSTileSource",e(467).TMSTileSource),S("WMTSTileSource",e(466).WMTSTileSource)},
function _(e,t,r,o,l){var i;o();const s=e(461);class _ extends s.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars);let l,i,s,_;return this.use_latlon?[i,_,l,s]=this.get_tile_geographic_bounds(e,t,r):[i,_,l,s]=this.get_tile_meter_bounds(e,t,r),o.replace("{XMIN}",i.toString()).replace("{YMIN}",_.toString()).replace("{XMAX}",l.toString()).replace("{YMAX}",s.toString())}}r.BBoxTileSource=_,i=_,_.__name__="BBoxTileSource",i.define((({Bool:e})=>({use_latlon:[e,!1]})))},
function _(t,e,i,_,s){var r;_();const o=t(462),n=t(10),l=t(463);class u extends o.TileSource{constructor(t){super(t)}initialize(){super.initialize(),this._resolutions=(0,n.range)(this.min_zoom,this.max_zoom+1).map((t=>this.get_resolution(t)))}_computed_initial_resolution(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size}is_valid_tile(t,e,i){return!(!this.wrap_around&&(t<0||t>=2**i))&&!(e<0||e>=2**i)}parent_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=_.substring(0,_.length-1);return this.quadkey_to_tile_xyz(s)}get_resolution(t){return this._computed_initial_resolution()/2**t}get_resolution_by_extent(t,e,i){return[(t[2]-t[0])/i,(t[3]-t[1])/e]}get_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s);let o=0;for(const t of this._resolutions){if(r>t){if(0==o)return 0;if(o>0)return o-1}o+=1}return o-1}get_closest_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s),o=this._resolutions.reduce((function(t,e){return Math.abs(e-r)<Math.abs(t-r)?e:t}));return this._resolutions.indexOf(o)}snap_to_zoom_level(t,e,i,_){const[s,r,o,n]=t,l=this._resolutions[_];let u=i*l,a=e*l;if(!this.snap_to_zoom){const t=(o-s)/u,e=(n-r)/a;t>e?(u=o-s,a*=t):(u*=e,a=n-r)}const h=(u-(o-s))/2,c=(a-(n-r))/2;return[s-h,r-c,o+h,n+c]}tms_to_wmts(t,e,i){return[t,2**i-1-e,i]}wmts_to_tms(t,e,i){return[t,2**i-1-e,i]}pixels_to_meters(t,e,i){const _=this.get_resolution(i);return[t*_-this.x_origin_offset,e*_-this.y_origin_offset]}meters_to_pixels(t,e,i){const _=this.get_resolution(i);return[(t+this.x_origin_offset)/_,(e+this.y_origin_offset)/_]}pixels_to_tile(t,e){let i=Math.ceil(t/this.tile_size);i=0===i?i:i-1;return[i,Math.max(Math.ceil(e/this.tile_size)-1,0)]}pixels_to_raster(t,e,i){return[t,(this.tile_size<<i)-e]}meters_to_tile(t,e,i){const[_,s]=this.meters_to_pixels(t,e,i);return this.pixels_to_tile(_,s)}get_tile_meter_bounds(t,e,i){const[_,s]=this.pixels_to_meters(t*this.tile_size,e*this.tile_size,i),[r,o]=this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,i);return[_,s,r,o]}get_tile_geographic_bounds(t,e,i){const _=this.get_tile_meter_bounds(t,e,i),[s,r,o,n]=(0,l.meters_extent_to_geographic)(_);return[s,r,o,n]}get_tiles_by_extent(t,e,i=1){const[_,s,r,o]=t;let[n,l]=this.meters_to_tile(_,s,e),[u,a]=this.meters_to_tile(r,o,e);n-=i,l-=i,u+=i,a+=i;const h=[];for(let t=a;t>=l;t--)for(let i=n;i<=u;i++)this.is_valid_tile(i,t,e)&&h.push([i,t,e,this.get_tile_meter_bounds(i,t,e)]);return this.sort_tiles_from_center(h,[n,l,u,a]),h}quadkey_to_tile_xyz(t){let e=0,i=0;const _=t.length;for(let s=_;s>0;s--){const r=1<<s-1;switch(t.charAt(_-s)){case"0":continue;case"1":e|=r;break;case"2":i|=r;break;case"3":e|=r,i|=r;break;default:throw new TypeError(`Invalid Quadkey: ${t}`)}}return[e,i,_]}tile_xyz_to_quadkey(t,e,i){let _="";for(let s=i;s>0;s--){const i=1<<s-1;let r=0;0!=(t&i)&&(r+=1),0!=(e&i)&&(r+=2),_+=r.toString()}return _}children_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=[];for(let t=0;t<=3;t++){const[e,i,r]=this.quadkey_to_tile_xyz(_+t.toString()),o=this.get_tile_meter_bounds(e,i,r);s.push([e,i,r,o])}return s}get_closest_parent_by_tile_xyz(t,e,i){const _=this.calculate_world_x_by_tile_xyz(t,e,i);[t,e,i]=this.normalize_xyz(t,e,i);let s=this.tile_xyz_to_quadkey(t,e,i);for(;s.length>0;)if(s=s.substring(0,s.length-1),[t,e,i]=this.quadkey_to_tile_xyz(s),[t,e,i]=this.denormalize_xyz(t,e,i,_),this.tiles.has(this.tile_xyz_to_key(t,e,i)))return[t,e,i];return[0,0,0]}normalize_xyz(t,e,i){if(this.wrap_around){const _=2**i;return[(t%_+_)%_,e,i]}return[t,e,i]}denormalize_xyz(t,e,i,_){return[t+_*2**i,e,i]}denormalize_meters(t,e,i,_){return[t+2*_*Math.PI*6378137,e]}calculate_world_x_by_tile_xyz(t,e,i){return Math.floor(t/2**i)}}i.MercatorTileSource=u,r=u,u.__name__="MercatorTileSource",r.define((({Bool:t})=>({snap_to_zoom:[t,!1],wrap_around:[t,!0]}))),r.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})},
function _(e,t,r,i,l){var n;i();const a=e(51),s=e(9);class c extends a.Model{constructor(e){super(e)}initialize(){super.initialize(),this.tiles=new Map,this._normalize_case()}connect_signals(){super.connect_signals(),this.connect(this.change,(()=>this._clear_cache()))}string_lookup_replace(e,t){let r=e;for(const[e,i]of(0,s.entries)(t))r=r.replace(`{${e}}`,i);return r}_normalize_case(){const e=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=e}_clear_cache(){this.tiles=new Map}tile_xyz_to_key(e,t,r){return`${e}:${t}:${r}`}key_to_tile_xyz(e){const[t,r,i]=e.split(":").map((e=>parseInt(e)));return[t,r,i]}sort_tiles_from_center(e,t){const[r,i,l,n]=t,a=(l-r)/2+r,s=(n-i)/2+i;e.sort((function(e,t){return Math.sqrt((a-e[0])**2+(s-e[1])**2)-Math.sqrt((a-t[0])**2+(s-t[1])**2)}))}get_image_url(e,t,r){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",t.toString()).replace("{Z}",r.toString())}}r.TileSource=c,n=c,c.__name__="TileSource",n.define((({Float:e,Str:t,Dict:r,Nullable:i})=>({url:[t,""],tile_size:[e,256],max_zoom:[e,30],min_zoom:[e,0],extra_url_vars:[r(t),{}],attribution:[t,""],x_origin_offset:[e],y_origin_offset:[e],initial_resolution:[i(e),null]})))},
function _(t,e,r,n,o){n();const c=t(131);function _(t,e){return c.wgs84_mercator.compute(t,e)}function g(t,e){return c.wgs84_mercator.invert(t,e)}r.geographic_to_meters=_,r.meters_to_geographic=g,r.geographic_extent_to_meters=function(t){const[e,r,n,o]=t,[c,g]=_(e,r),[i,u]=_(n,o);return[c,g,i,u]},r.meters_extent_to_geographic=function(t){const[e,r,n,o]=t,[c,_]=g(e,r),[i,u]=g(n,o);return[c,_,i,u]}},
function _(e,t,r,s,_){s();const o=e(461);class c extends o.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const s=this.string_lookup_replace(this.url,this.extra_url_vars),[_,o,c]=this.tms_to_wmts(e,t,r),i=this.tile_xyz_to_quadkey(_,o,c);return s.replace("{Q}",i)}}r.QUADKEYTileSource=c,c.__name__="QUADKEYTileSource"},
function _(e,t,i,s,_){var n;s();const r=e(462),a=e(466),h=e(81),o=e(95),l=e(398),d=e(176),m=e(10),c=e(12);class g extends h.RendererView{constructor(){super(...arguments),this._tiles=null}mark_finished(){super.mark_finished(),this._tiles=[]}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render())),this.connect(this.model.tile_source.change,(()=>this.request_render()))}get_extent(){const{x_range:e,y_range:t}=this,i=e.start,s=t.start,_=e.end,n=t.end;return(0,c.assert)(isFinite(i)),(0,c.assert)(isFinite(s)),(0,c.assert)(isFinite(_)),(0,c.assert)(isFinite(n)),[i,s,_,n]}get map_plot(){return this.plot_model}get map_canvas(){return this.layer.ctx}get map_frame(){return this.plot_view.frame}get x_range(){return this.map_plot.x_range}get y_range(){return this.map_plot.y_range}_set_data(){this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0}get attribution(){return new l.HTML({html:[this.model.tile_source.attribution]})}_map_data(){this.initial_extent=this.get_extent();const e=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width),t=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width,e);this.x_range.start=t[0],this.y_range.start=t[1],this.x_range.end=t[2],this.y_range.end=t[3],this.x_range instanceof o.Range1d&&(this.x_range.reset_start=t[0],this.x_range.reset_end=t[2]),this.y_range instanceof o.Range1d&&(this.y_range.reset_start=t[1],this.y_range.reset_end=t[3])}_create_tile(e,t,i,s,_=!1){const n=this.model.tile_source.tile_xyz_to_quadkey(e,t,i),r=this.model.tile_source.tile_xyz_to_key(e,t,i);if(this.model.tile_source.tiles.has(r))return;const[a,h,o]=this.model.tile_source.normalize_xyz(e,t,i),l=this.model.tile_source.get_image_url(a,h,o),m={img:void 0,tile_coords:[e,t,i],normalized_coords:[a,h,o],quadkey:n,cache_key:r,bounds:s,loaded:!1,finished:!1,x_coord:s[0],y_coord:s[3]};this.model.tile_source.tiles.set(r,m),null==this._tiles&&(this._tiles=[]),this._tiles.push(m),new d.ImageLoader(l,{loaded:e=>{Object.assign(m,{img:e,loaded:!0}),_?(m.finished=!0,this.notify_finished()):this.request_render()},failed(){m.finished=!0}})}_enforce_aspect_ratio(){if(this._last_height!==this.map_frame.bbox.height||this._last_width!==this.map_frame.bbox.width){const e=this.get_extent(),t=this.model.tile_source.get_level_by_extent(e,this.map_frame.bbox.height,this.map_frame.bbox.width),i=this.model.tile_source.snap_to_zoom_level(e,this.map_frame.bbox.height,this.map_frame.bbox.width,t);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame.bbox.height,this._last_width=this.map_frame.bbox.width}}has_finished(){if(!super.has_finished())return!1;if(null==this._tiles)return!1;for(const e of this._tiles)if(!e.finished)return!1;return!0}_render(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()}_draw_tile(e){const t=this.model.tile_source.tiles.get(e);if(null!=t&&t.loaded){const[[e],[i]]=this.coordinates.map_to_screen([t.bounds[0]],[t.bounds[3]]),[[s],[_]]=this.coordinates.map_to_screen([t.bounds[2]],[t.bounds[1]]),n=s-e,r=_-i,a=e,h=i,o=this.map_canvas.imageSmoothingEnabled;this.map_canvas.imageSmoothingEnabled=this.model.smoothing,this.map_canvas.drawImage(t.img,a,h,n,r),this.map_canvas.imageSmoothingEnabled=o,t.finished=!0}}_set_rect(){const e=this.plot_model.outline_line_width,t=this.map_frame.bbox.left+e/2,i=this.map_frame.bbox.top+e/2,s=this.map_frame.bbox.width-e,_=this.map_frame.bbox.height-e;this.map_canvas.rect(t,i,s,_),this.map_canvas.clip()}_render_tiles(e){this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;for(const t of e)this._draw_tile(t);this.map_canvas.restore()}_prefetch_tiles(){const{tile_source:e}=this.model,t=this.get_extent(),i=this.map_frame.bbox.height,s=this.map_frame.bbox.width,_=this.model.tile_source.get_level_by_extent(t,i,s),n=this.model.tile_source.get_tiles_by_extent(t,_);for(let t=0,i=Math.min(10,n.length);t<i;t++){const[i,s,_]=n[t],r=this.model.tile_source.children_by_tile_xyz(i,s,_);for(const t of r){const[i,s,_,n]=t;e.tiles.has(e.tile_xyz_to_key(i,s,_))||this._create_tile(i,s,_,n,!0)}}}_fetch_tiles(e){for(const t of e){const[e,i,s,_]=t;this._create_tile(e,i,s,_)}}_update(){const{tile_source:e}=this.model,{min_zoom:t}=e,{max_zoom:i}=e;let s=this.get_extent();const _=this.extent[2]-this.extent[0]<s[2]-s[0],n=this.map_frame.bbox.height,r=this.map_frame.bbox.width;let a=e.get_level_by_extent(s,n,r),h=!1;a<t?(s=this.extent,a=t,h=!0):a>i&&(s=this.extent,a=i,h=!0),h&&(this.x_range.setv({start:s[0],end:s[2]}),this.y_range.setv({start:s[1],end:s[3]})),this.extent=s;const o=e.get_tiles_by_extent(s,a),l=[],d=[],c=[],g=[];for(const t of o){const[i,s,n]=t,r=e.tile_xyz_to_key(i,s,n),a=e.tiles.get(r);if(null!=a&&a.loaded)d.push(r);else if(this.model.render_parents){const[t,r,a]=e.get_closest_parent_by_tile_xyz(i,s,n),h=e.tile_xyz_to_key(t,r,a),o=e.tiles.get(h);if(null!=o&&o.loaded&&!(0,m.includes)(c,h)&&c.push(h),_){const t=e.children_by_tile_xyz(i,s,n);for(const[i,s,_]of t){const t=e.tile_xyz_to_key(i,s,_);e.tiles.has(t)&&g.push(t)}}}null==a&&l.push(t)}this._render_tiles(c),this._render_tiles(g),this._render_tiles(d),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout((()=>this._fetch_tiles(l)),65)}}i.TileRendererView=g,g.__name__="TileRendererView";class u extends h.Renderer{constructor(e){super(e)}}i.TileRenderer=u,n=u,u.__name__="TileRenderer",n.prototype.default_view=g,n.define((({Bool:e,Float:t,Ref:i})=>({alpha:[t,1],smoothing:[e,!0],tile_source:[i(r.TileSource),()=>new a.WMTSTileSource],render_parents:[e,!0]}))),n.override({level:"image"})},
function _(t,e,r,o,s){o();const c=t(461);class i extends c.MercatorTileSource{constructor(t){super(t)}get_image_url(t,e,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars),[s,c,i]=this.tms_to_wmts(t,e,r);return o.replace("{X}",s.toString()).replace("{Y}",c.toString()).replace("{Z}",i.toString())}}r.WMTSTileSource=i,i.__name__="WMTSTileSource"},
function _(e,r,t,c,o){c();const i=e(461);class l extends i.MercatorTileSource{constructor(e){super(e)}get_image_url(e,r,t){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",r.toString()).replace("{Z}",t.toString())}}t.TMSTileSource=l,l.__name__="TMSTileSource"},
function _(e,t,u,a,r){a(),r("CanvasTexture",e(469).CanvasTexture),r("ImageURLTexture",e(471).ImageURLTexture),r("Texture",e(470).Texture)},
function _(t,e,n,c,s){var r;c();const o=t(470),a=t(40);class u extends o.Texture{constructor(t){super(t)}get func(){const t=(0,a.use_strict)(this.code);return new Function("ctx","color","scale","weight",t)}get_pattern(t,e,n){const c=document.createElement("canvas");c.width=e,c.height=e;const s=c.getContext("2d");return this.func.call(this,s,t,e,n),c}}n.CanvasTexture=u,r=u,u.__name__="CanvasTexture",r.define((({Str:t})=>({code:[t]})))},
function _(e,t,n,r,o){var i;r();const s=e(51),u=e(20);class c extends s.Model{constructor(e){super(e)}}n.Texture=c,i=c,c.__name__="Texture",i.define((()=>({repetition:[u.TextureRepetition,"repeat"]})))},
function _(e,t,r,i,a){var n;i();const s=e(470),o=e(176);class u extends s.Texture{constructor(e){super(e)}initialize(){super.initialize(),this._loader=new o.ImageLoader(this.url)}get_pattern(e,t,r){const{_loader:i}=this;return this._loader.finished?i.image:i.promise}}r.ImageURLTexture=u,n=u,u.__name__="ImageURLTexture",n.define((({Str:e})=>({url:[e]})))},
function _(e,n,a,o,t){o();const l=e(1);l.__exportStar(e(473),a),l.__exportStar(e(478),a),t("Panel",e(429).Panel),t("Dialog",e(316).Dialog),t("Examiner",e(479).Examiner),t("Pane",e(397).Pane),t("Tooltip",e(409).Tooltip),t("UIElement",e(107).UIElement)},
function _(n,c,o,I,i){I(),i("BuiltinIcon",n(474).BuiltinIcon),i("SVGIcon",n(476).SVGIcon),i("TablerIcon",n(477).TablerIcon)},
function _(e,n,t,i,s){var o;i();const r=e(1),a=e(475),l=e(63),c=e(22),m=e(8),u=r.__importDefault(e(121));class _ extends a.IconView{constructor(){super(...arguments),this._style=new l.InlineStyleSheet}stylesheets(){return[...super.stylesheets(),u.default,this._style]}render(){super.render();const e=`var(--bokeh-icon-${this.model.icon_name})`,n=(0,c.color2css)(this.model.color),t=(()=>{const{size:e}=this.model;return(0,m.isNumber)(e)?`${e}px`:e})();this._style.replace(`\n      :host {\n        display: inline-block;\n        vertical-align: middle;\n        width: ${t};\n        height: ${t};\n        background-color: ${n};\n        mask-image: ${e};\n        mask-size: contain;\n        mask-repeat: no-repeat;\n        -webkit-mask-image: ${e};\n        -webkit-mask-size: contain;\n        -webkit-mask-repeat: no-repeat;\n      }\n    `)}}t.BuiltinIconView=_,_.__name__="BuiltinIconView";class d extends a.Icon{constructor(e){super(e)}}t.BuiltinIcon=d,o=d,d.__name__="BuiltinIcon",o.prototype.default_view=_,o.define((({Str:e,Color:n})=>({icon_name:[e],color:[n,"gray"]})))},
function _(e,n,s,c,t){var o;c();const i=e(107);class _ extends i.UIElementView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.render()))}}s.IconView=_,_.__name__="IconView";class a extends i.UIElement{constructor(e){super(e)}}s.Icon=a,o=a,a.__name__="Icon",o.define((({Float:e,Or:n,CSSLength:s})=>({size:[n(e,s),"1em"]})))},
function _(e,n,s,t,r){var i;t();const o=e(475),l=e(63),c=e(8);class a extends o.IconView{constructor(){super(...arguments),this._style=new l.InlineStyleSheet}stylesheets(){return[...super.stylesheets(),this._style]}render(){super.render();const e=(()=>{const{size:e}=this.model;return(0,c.isNumber)(e)?`${e}px`:e})();this._style.replace(`\n      :host {\n        display: inline-block;\n        vertical-align: middle;\n      }\n      :host svg {\n        width: ${e};\n        height: ${e};\n      }\n    `);const n=(new DOMParser).parseFromString(this.model.svg,"image/svg+xml");this.shadow_el.append(n.documentElement)}}s.SVGIconView=a,a.__name__="SVGIconView";class d extends o.Icon{constructor(e){super(e)}}s.SVGIcon=d,i=d,d.__name__="SVGIcon",i.prototype.default_view=a,i.define((({Str:e})=>({svg:[e]})))},
function _(e,n,t,s,r){var o,l;s();const i=e(475),a=e(63),c=e(8);class f extends i.IconView{constructor(){super(...arguments),this._tabler=new a.ImportedStyleSheet(`${o._url}/tabler-icons.min.css`),this._style=new a.InlineStyleSheet}stylesheets(){return[...super.stylesheets(),o._fonts,this._tabler,this._style]}render(){super.render();const e=(()=>{const{size:e}=this.model;return(0,c.isNumber)(e)?`${e}px`:e})();this._style.replace(`\n      :host {\n        display: inline-block;\n        vertical-align: middle;\n        font-size: ${e};\n      }\n    `);const n=(0,a.span)({class:["ti",`ti-${this.model.icon_name}`]});this.shadow_el.appendChild(n)}}t.TablerIconView=f,o=f,f.__name__="TablerIconView",f._url="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest",f._fonts=new a.GlobalInlineStyleSheet(`    /*!\n    * Tabler Icons 1.68.0 by tabler - https://tabler.io\n    * License - https://github.com/tabler/tabler-icons/blob/master/LICENSE\n    */\n  @font-face {\n    font-family: "tabler-icons";\n    font-style: normal;\n    font-weight: 400;\n    src: url("${o._url}/fonts/tabler-icons.eot");\n    src: url("${o._url}/fonts/tabler-icons.eot?#iefix") format("embedded-opentype"),\n         url("${o._url}/fonts/tabler-icons.woff2") format("woff2"),\n         url("${o._url}/fonts/tabler-icons.woff") format("woff"),\n         url("${o._url}/fonts/tabler-icons.ttf") format("truetype"),\n         url("${o._url}/fonts/tabler-icons.svg#tabler-icons") format("svg");\n  }\n\n  @media screen and (-webkit-min-device-pixel-ratio: 0) {\n    @font-face {\n      font-family: "tabler-icons";\n      src: url("${o._url}/fonts/tabler-icons.svg#tabler-icons") format("svg");\n    }\n  }\n`);class b extends i.Icon{constructor(e){super(e)}}t.TablerIcon=b,l=b,b.__name__="TablerIcon",l.prototype.default_view=f,l.define((({Str:e})=>({icon_name:[e]})))},
function _(e,t,i,m,n){m(),n("Menu",e(106).Menu),n("ActionItem",e(116).ActionItem),n("CheckableItem",e(118).CheckableItem),n("DividerItem",e(119).DividerItem)},
function _(t,s,e,n,o){var i;n();const a=t(1),l=t(107),r=a.__importStar(t(18)),c=t(14),d=t(63),p=t(42),h=t(51),u=t(8),f=t(9),_=t(10),m=t(34),g=t(15),v=t(38),b=a.__importDefault(t(480)),y=a.__importStar(t(481)),k=y;class x{constructor(t,s=5,e=3){this.visited=new WeakSet,this.depth=0,this.click=t,this.max_items=s,this.max_depth=e}to_html(t){if((0,u.isObject)(t)){if(this.visited.has(t))return(0,d.span)("<circular>");this.visited.add(t)}return null==t?this.null():(0,u.isBoolean)(t)?this.boolean(t):(0,u.isNumber)(t)?this.number(t):(0,u.isString)(t)?this.string(t):(0,u.isSymbol)(t)?this.symbol(t):t instanceof h.Model?this.model(t):t instanceof r.Property?this.property(t):(0,u.isPlainObject)(t)?this.object(t):(0,u.isArray)(t)?this.array(t):(0,u.isIterable)(t)?this.iterable(t):(0,d.span)((0,p.to_string)(t))}null(){return(0,d.span)({class:k.nullish},"null")}token(t){return(0,d.span)({class:k.token},t)}boolean(t){return(0,d.span)({class:k.boolean},`${t}`)}number(t){return(0,d.span)({class:k.number},`${t}`)}string(t){const s=t.includes("'"),e=t.includes('"'),n=s&&e?`\`${t.replace(/`/g,"\\`")}\``:e?`'${t}'`:`"${t}"`;return(0,d.span)({class:k.string},n)}symbol(t){return(0,d.span)({class:k.symbol},t.toString())}array(t){const s=this.token,e=[];let n=0;for(const s of t)if(e.push(this.to_html(s)),n++>this.max_items){e.push((0,d.span)("\u2026"));break}return(0,d.span)({class:k.array},s("["),...(0,m.interleave)(e,(()=>s(", "))),s("]"))}iterable(t){const s=this.token,e=Object(t)[Symbol.toStringTag]??"Object",n=this.array([...t]);return(0,d.span)({class:k.iterable},`${e}`,s("("),n,s(")"))}object(t){const s=this.token,e=[];let n=0;for(const[o,i]of(0,f.entries)(t))if(e.push((0,d.span)(`${o}`,s(": "),this.to_html(i))),n++>this.max_items){e.push((0,d.span)("\u2026"));break}return(0,d.span)({class:k.object},s("{"),...(0,m.interleave)(e,(()=>s(", "))),s("}"))}model(t){const s=this.token,e=(0,d.span)({class:k.model},t.constructor.__qualified__,s("("),this.to_html(t.id),s(")")),{click:n}=this;return null!=n&&(e.classList.add("ref"),e.addEventListener("click",(()=>n(t)))),e}property(t){const s=this.model(t.obj),e=(0,d.span)({class:k.attr},t.attr);return(0,d.span)(s,this.token("."),e)}}e.HTMLPrinter=x,x.__name__="HTMLPrinter";class w extends l.UIElementView{constructor(){super(...arguments),this.prev_listener=null,this.watched_props=new Set}stylesheets(){return[...super.stylesheets(),y.default,b.default]}render(){super.render(),null!=this.prev_listener&&v.diagnostics.disconnect(this.prev_listener);const t=[],s=[],e=[],n=new WeakMap;v.diagnostics.connect((o=>{if(o instanceof r.Property){for(const[s,e]of t)s==o.obj&&i(e);for(const[t,e]of s)if(t==o){const[,,,s]=e.children;a(t,e,s);break}for(const[t,s]of e)if(t==o){const[,e]=s.children;a(t,s,e);break}}function i(t){const s=n.get(t);null!=s&&s.cancel();const e=t.animate([{backgroundColor:"#def189"},{backgroundColor:"initial"}],{duration:2e3});n.set(t,e)}function a(t,s,e){s.classList.toggle("dirty",t.dirty),(0,d.empty)(e);const n=t.is_unset?(0,d.span)("unset"):C(t.get_value());e.appendChild(n),i(e)}}));const o=(()=>{const s=(0,d.input)({class:"filter",type:"text",placeholder:"Filter"});return s.addEventListener("keyup",(()=>{const e=s.value;for(const[s,n]of t){const t=s.constructor.__qualified__.includes(e);n.classList.toggle("hidden",!t)}})),(0,d.div)({class:"toolbar"},s)})(),i=(0,d.input)({type:"checkbox",checked:!0}),a=(0,d.input)({type:"checkbox",checked:!0}),l=()=>{for(const[t,e]of s){const s=i.checked,n=a.checked,o=!t.dirty&&!s||t.internal&&!n;e.classList.toggle("hidden",o)}};i.addEventListener("change",(()=>l())),a.addEventListener("change",(()=>l()));const p=(()=>{const t=(0,d.input)({class:"filter",type:"text",placeholder:"Filter"}),e=(0,d.span)({class:"checkbox"},(0,d.input)({type:"checkbox",checked:!0}),(0,d.span)("Group")),n=(0,d.span)({class:"checkbox"},i,(0,d.span)("Initial?")),o=(0,d.span)({class:"checkbox"},a,(0,d.span)("Internal?"));return t.addEventListener("keyup",(()=>{const e=t.value;for(const[t,n]of s){const s=t.attr.includes(e);n.classList.toggle("hidden",!s)}})),(0,d.div)({class:"toolbar"},t,e,n,o)})(),u=(()=>{const t=(0,d.input)({class:"filter",type:"text",placeholder:"Filter"});return t.addEventListener("keyup",(()=>{const s=t.value;for(const[t,n]of e){const e=t.attr.includes(s);n.classList.toggle("hidden",!e)}})),(0,d.div)({class:"toolbar"},t)})(),m=(0,d.div)({class:"models-list"}),b=(0,d.div)({class:"props-list"}),y=(0,d.div)({class:"watches-list"}),k=(0,d.div)({class:"models-panel"},o,m),w=(0,d.div)({class:"props-panel"},p,b),L=(0,d.div)({class:"watches-panel"},u,y),E=(0,d.div)({class:"col",style:{width:"100%"}},L,w),S=(0,d.div)({class:"examiner"},k,E);function j(t){t instanceof h.Model&&O(t)}function C(t){return new x(j).to_html(t)}const P=(s,e)=>{(0,_.clear)(t),(0,d.empty)(m);const n=null!=e?new Set(e.roots()):new Set;for(const e of s){const s=n.has(e)?(0,d.span)({class:"tag"},"root"):null,o=(0,d.span)({class:"model-ref",tabIndex:0},C(e),s);o.addEventListener("keydown",(t=>{"Enter"==t.key&&O(e)})),t.push([e,o]),m.appendChild(o)}},O=e=>{(0,_.clear)(s),(0,d.empty)(b);for(const[s,n]of t)n.classList.toggle("active",e==s);const n=(()=>{const t=[];let s=Object.getPrototypeOf(e);do{t.push([s.constructor,(0,f.keys)(s._props)]),s=Object.getPrototypeOf(s)}while(s.constructor!=c.HasProps);t.reverse();const n=[];for(const[,s]of t)s.splice(0,n.length),n.push(...s);return t})(),o=g.receivers_for_sender.get(e)??[];for(const[t,l]of n){if(0==l.length)continue;const n=(0,d.span)({class:["expander"]}),r=(0,d.div)({class:"base"},n,"inherited from"," ",(0,d.span)({class:"monospace"},t.__qualified__));b.appendChild(r);const c=[];for(const t of l){const n=e.property(t),l=n.kind.toString(),r=n.is_unset?(0,d.span)("unset"):C(n.get_value()),p=n.internal?(0,d.span)({class:"tag"},"internal"):null,h=o.filter((t=>t.signal==n.change)).length,u=0!=h?(0,d.span)({class:"tag"},`${h}`):null,f=this.watched_props.has(n),_=(0,d.input)({type:"checkbox",checked:f}),m=(0,d.div)({class:"prop-attr",tabIndex:0},_,(0,d.span)({class:"attr"},t),p),g=(0,d.div)({class:"prop-conns"},u),v=(0,d.div)({class:"prop-kind"},l),y=(0,d.div)({class:"prop-value"},r),k=n.dirty?"dirty":null,x=n.internal?"internal":null,w=i.checked,L=a.checked,E=!n.dirty&&!w||n.internal&&!L?"hidden":null,S=(0,d.div)({class:["prop",k,x,E]},m,g,v,y);c.push(S),s.push([n,S]),b.appendChild(S),_.addEventListener("change",(()=>{this.watched_props[_.checked?"add":"delete"](n),$()}))}r.addEventListener("click",(()=>{n.classList.toggle("closed");for(const t of c)t.classList.toggle("closed")}))}},$=()=>{if((0,_.clear)(e),(0,d.empty)(y),0==this.watched_props.size){const t=(0,d.div)({class:"nothing"},"No watched properties");y.appendChild(t)}else for(const t of this.watched_props){const s=(0,d.span)(C(t)),n=(0,d.span)(t.is_unset?(0,d.span)("unset"):C(t.get_value())),o=(0,d.div)({class:["prop",t.dirty?"dirty":null]},s,n);e.push([t,o]),y.appendChild(o)}};this.shadow_el.appendChild(S);const{target:I}=this.model;if(null!=I){const t=I.references(),{document:s}=I;P(t,s),O(I)}else{const{document:t}=this.model;if(null!=t){P(t._all_models.values(),t);const s=t.roots();if(0!=s.length){const[t]=s;O(t)}}}$()}}e.ExaminerView=w,w.__name__="ExaminerView";class L extends l.UIElement{constructor(t){super(t)}}e.Examiner=L,i=L,L.__name__="Examiner",i.prototype.default_view=w,i.define((({Ref:t,Nullable:s})=>({target:[s(t(c.HasProps)),null]})))},
function _(o,e,i,r,l){r(),i.default=':root{--common-padding:3px;--common-outline:#1a73e8 solid 1px;--panel-bg-color:#f1f3f4;--panel-border-color:#cacdd1;}.ref{cursor:pointer;}.monospace{font-family:var(--mono-font);}.hidden{display:none !important;}.col{display:flex;flex-direction:column;}.row{display:flex;flex-direction:row;}.toolbar{display:flex;flex-direction:row;gap:1em;background-color:var(--panel-bg-color);border-bottom:1px solid var(--panel-border-color);padding:var(--common-padding);}.checkbox{display:flex;flex-direction:row;align-items:center;gap:0.25em;}.filter:focus{outline:var(--common-outline);}.examiner{height:100%;display:flex;border:1px solid var(--panel-border-color);}.models-panel{display:flex;flex-direction:column;border-right:1px solid var(--panel-border-color);}.props-panel{display:flex;flex-direction:column;height:100%;overflow:auto;}.watches-panel{display:flex;flex-direction:column;border-bottom:1px solid var(--panel-border-color);}.models-list{display:flex;flex-direction:column;height:min-content;padding:var(--common-padding);overflow-x:hidden;overflow-y:auto;}.props-list{display:grid;grid-template-columns:min-content min-content 1fr 1fr;column-gap:1em;padding:var(--common-padding);}.watches-list{display:grid;grid-template-columns:1fr 1fr;column-gap:1em;padding:var(--common-padding);}.nothing{grid-column:1 / span 2;font-style:italic;text-align:center;}.prop{display:contents;}.prop.closed{display:none;}.prop > *{opacity:0.6;}.prop.dirty > *{opacity:1;}.model-ref{display:flex;align-items:center;flex-direction:row;font-family:var(--mono-font);}.model-ref:focus-visible{outline:var(--common-outline);}.model-ref:hover{background-color:#e2e2e2;}.model-ref.active{background-color:#c8e0ee;}.tag{margin-left:1em;padding:0 4px;font-size:60%;border-width:1px;border-style:solid;border-radius:4px;color:#202124;background-color:#f1f3f4;border-color:#cacdd1;}.expander{margin:0 2px;display:inline-block;vertical-align:middle;background-color:#5f6368;--open-image:url(\'data:image/svg+xml;utf8,    <svg xmlns="http://www.w3.org/2000/svg" width="6" height="6">      <path d="M 0 1 L 6 1 3 5 Z"/>    </svg>\');--closed-image:url(\'data:image/svg+xml;utf8,    <svg xmlns="http://www.w3.org/2000/svg" width="6" height="6">      <path d="M 1 0 L 5 3 1 6 Z"/>    </svg>\');}.expander{width:6px;height:6px;mask-image:var(--open-image);-webkit-mask-image:var(--open-image);}.expander.closed{width:6px;height:6px;mask-image:var(--closed-image);-webkit-mask-image:var(--closed-image);}.base{grid-column:1 / span 4;color:#5f6368;cursor:pointer;}.prop-attr,.prop-conns,.prop-kind,.prop-value{display:flex;flex-direction:row;align-items:center;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;font-family:var(--mono-font);}.prop-attr > input[type="checkbox"]{visibility:hidden;margin-right:0.25em;}.prop-attr > input[type="checkbox"]:checked,.prop-attr:hover > input{visibility:visible;}.prop-attr:focus-visible{outline:var(--common-outline);}'},
function _(o,b,l,r,k){r(),l.nullish="bk-nullish",l.token="bk-token",l.boolean="bk-boolean",l.number="bk-number",l.string="bk-string",l.symbol="bk-symbol",l.model="bk-model",l.attr="bk-attr",l.array="bk-array",l.object="bk-object",l.iterable="bk-iterable",l.default=".bk-nullish{color:#7724c1;}.bk-token{color:#881280;}.bk-boolean{color:#007500;}.bk-number{color:#1a1aa6;}.bk-string{color:#994500;}.bk-symbol{color:#c80000;}.bk-model{color:initial;}.bk-attr{color:#c80000;}.bk-array{color:initial;}.bk-object{color:initial;}.bk-iterable{color:initial;}"},
function _(o,t,r,n,l){n();const _=o(1);_.__exportStar(o(483),r),_.__exportStar(o(497),r),_.__exportStar(o(507),r),_.__exportStar(o(519),r),l("Tool",o(289).Tool),l("ToolProxy",o(290).ToolProxy),l("Toolbar",o(288).Toolbar),l("ToolButton",o(291).ToolButton),l("OnOffButton",o(297).OnOffButton),l("ClickButton",o(300).ClickButton)},
function _(o,l,T,e,n){e(),n("ActionTool",o(299).ActionTool),n("CopyTool",o(484).CopyTool),n("CustomAction",o(485).CustomAction),n("FullscreenTool",o(486).FullscreenTool),n("HelpTool",o(301).HelpTool),n("ExamineTool",o(487).ExamineTool),n("RedoTool",o(488).RedoTool),n("ResetTool",o(490).ResetTool),n("SaveTool",o(491).SaveTool),n("UndoTool",o(492).UndoTool),n("ZoomInTool",o(493).ZoomInTool),n("ZoomOutTool",o(496).ZoomOutTool)},
function _(o,t,e,i,a){var n;i();const c=o(299),p=o(121);class s extends c.ActionToolView{async copy(){const o=await this.parent.export().to_blob(),t=new ClipboardItem({[o.type]:o});await navigator.clipboard.write([t])}doit(){this.copy()}}e.CopyToolView=s,s.__name__="CopyToolView";class l extends c.ActionTool{constructor(o){super(o),this.tool_name="Copy",this.tool_icon=p.tool_icon_copy}}e.CopyTool=l,n=l,l.__name__="CopyTool",n.prototype.default_view=s,n.register_alias("copy",(()=>new n))},
function _(o,t,n,e,i){var c;e();const l=o(1),s=o(299),_=o(50),u=l.__importStar(o(121));class a extends s.ActionToolView{doit(){const{callback:o}=this.model;null!=o&&(0,_.execute)(o,this.model)}}n.CustomActionView=a,a.__name__="CustomActionView";class m extends s.ActionTool{constructor(o){super(o),this.tool_name="Custom Action",this.tool_icon=u.tool_icon_unknown}}n.CustomAction=m,c=m,m.__name__="CustomAction",c.prototype.default_view=a,c.define((({Any:o,Nullable:t})=>({callback:[t(o),null]}))),c.override({description:"Perform a Custom Action"})},
function _(e,l,t,n,o){var s;n();const c=e(1),r=e(299),u=c.__importStar(e(121)),i=void 0!==Element.prototype.webkitRequestFullscreen?(e,l)=>e.webkitRequestFullscreen(l):(e,l)=>e.requestFullscreen(l);class _ extends r.ActionToolView{async fullscreen(){null!=document.fullscreenElement?await document.exitFullscreen():await i(this.parent.el)}doit(){this.fullscreen()}}t.FullscreenToolView=_,_.__name__="FullscreenToolView";class a extends r.ActionTool{constructor(e){super(e),this.tool_name="Fullscreen",this.tool_icon=u.tool_icon_fullscreen}}t.FullscreenTool=a,s=a,a.__name__="FullscreenTool",s.prototype.default_view=_,s.register_alias("fullscreen",(()=>new s))},
function _(e,i,t,o,n){var a;o();const l=e(1),s=e(299),_=l.__importStar(e(121)),r=e(316),c=e(479),d=e(398),m=e(56),h=e(63),w=l.__importDefault(e(481));class p extends s.ActionToolView{*children(){yield*super.children(),yield this._dialog}async lazy_initialize(){await super.lazy_initialize();const e=this.parent.model,i=new c.HTMLPrinter,t=new r.Dialog({stylesheets:[w.default],title:new d.HTML({html:(0,h.div)("Examine ",i.to_html(e))}),content:new c.Examiner({target:e}),visible:!1,close_action:"hide"});this._dialog=await(0,m.build_view)(t,{parent:this.parent})}doit(){this._dialog.open()}}t.ExamineToolView=p,p.__name__="ExamineToolView";class x extends s.ActionTool{constructor(e){super(e),this.tool_name="Examine",this.tool_icon=_.tool_icon_settings}}t.ExamineTool=x,a=x,x.__name__="ExamineTool",a.prototype.default_view=p,a.register_alias("examine",(()=>new a))},
function _(o,e,t,s,i){var n;s();const l=o(489),_=o(121);class a extends l.PlotActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state.changed,(()=>this.model.disabled=!this.plot_view.state.can_redo))}doit(){const o=this.plot_view.state.redo();null!=o?.range&&this.plot_view.trigger_ranges_update_event()}}t.RedoToolView=a,a.__name__="RedoToolView";class d extends l.PlotActionTool{constructor(o){super(o),this.tool_name="Redo",this.tool_icon=_.tool_icon_redo}}t.RedoTool=d,n=d,d.__name__="RedoTool",n.prototype.default_view=a,n.override({disabled:!0}),n.register_alias("redo",(()=>new n))},
function _(o,t,n,e,l){e();const c=o(299);class i extends c.ActionToolView{get plot_view(){return this.parent}}n.PlotActionToolView=i,i.__name__="PlotActionToolView";class s extends c.ActionTool{constructor(o){super(o)}}n.PlotActionTool=s,s.__name__="PlotActionTool"},
function _(e,o,t,s,i){var l;s();const _=e(489),n=e(121);class c extends _.PlotActionToolView{doit(){this.plot_view.reset()}}t.ResetToolView=c,c.__name__="ResetToolView";class r extends _.PlotActionTool{constructor(e){super(e),this.tool_name="Reset",this.tool_icon=n.tool_icon_reset}}t.ResetTool=r,l=r,r.__name__="ResetTool",l.prototype.default_view=c,l.register_alias("reset",(()=>new l))},
function _(e,o,t,a,n){var i;a();const l=e(299),s=e(121);class c extends l.ActionToolView{async copy(){const e=await this.parent.export().to_blob(),o=new ClipboardItem({[e.type]:e});await navigator.clipboard.write([o])}async save(e){const o=await this.parent.export().to_blob(),t=document.createElement("a");t.href=URL.createObjectURL(o),t.download=e,t.target="_blank",t.dispatchEvent(new MouseEvent("click"))}doit(e="save"){switch(e){case"save":{const e=this.model.filename??prompt("Enter filename","bokeh_plot");null!=e&&this.save(e);break}case"copy":this.copy()}}}t.SaveToolView=c,c.__name__="SaveToolView";class r extends l.ActionTool{constructor(e){super(e),this.tool_name="Save",this.tool_icon=s.tool_icon_save}get menu(){return[{icon:"bk-tool-icon-copy",tooltip:"Copy image to clipboard",if:()=>"undefined"!=typeof ClipboardItem,handler:()=>{this.do.emit("copy")}}]}}t.SaveTool=r,i=r,r.__name__="SaveTool",i.prototype.default_view=c,i.define((({Str:e,Nullable:o})=>({filename:[o(e),null]}))),i.register_alias("save",(()=>new i))},
function _(o,t,e,n,s){var i;n();const l=o(489),_=o(121);class a extends l.PlotActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state.changed,(()=>this.model.disabled=!this.plot_view.state.can_undo))}doit(){const o=this.plot_view.state.undo();null!=o?.range&&this.plot_view.trigger_ranges_update_event()}}e.UndoToolView=a,a.__name__="UndoToolView";class d extends l.PlotActionTool{constructor(o){super(o),this.tool_name="Undo",this.tool_icon=_.tool_icon_undo}}e.UndoTool=d,i=d,d.__name__="UndoTool",i.prototype.default_view=a,i.override({disabled:!0}),i.register_alias("undo",(()=>new i))},
function _(o,e,n,i,s){var t;i();const _=o(494),a=o(121);class m extends _.ZoomBaseToolView{get factor(){return this.model.factor}}n.ZoomInToolView=m,m.__name__="ZoomInToolView";class l extends _.ZoomBaseTool{constructor(o){super(o),this.maintain_focus=!0,this.tool_name="Zoom In",this.tool_icon=a.tool_icon_zoom_in}}n.ZoomInTool=l,t=l,l.__name__="ZoomInTool",t.prototype.default_view=m,t.register_alias("zoom_in",(()=>new t({dimensions:"both"}))),t.register_alias("xzoom_in",(()=>new t({dimensions:"width"}))),t.register_alias("yzoom_in",(()=>new t({dimensions:"height"})))},
function _(e,o,t,s,n){var a;s();const i=e(489),r=e(215),l=e(101),c=e(20),_=e(495),d=e(12),m=e(19);class h extends i.PlotActionToolView{doit(){const{dimensions:e}=this.model,o="width"==e||"both"==e,t="height"==e||"both"==e,{frame:s}=this.plot_view,{x_target:n,y_target:a}=s,i=new Map(s.x_scales),r=new Map(s.y_scales),{renderers:c}=this.model;if("auto"!=c){const e=new Set,o=new Set;for(const t of c)null==t.coordinates&&(e.add(t.x_range_name),o.add(t.y_range_name));for(const o of i.keys())e.has(o)||i.delete(o);for(const e of r.keys())o.has(e)||r.delete(e)}const h=[...i.values()],u=[...r.values()],f="auto"!=c?c:this.plot_view.model.data_renderers;for(const e of f){if(null==e.coordinates)continue;const o=this.plot_view.renderer_view(e);(0,d.assert)(null!=o);const t=(e,o)=>{const{level:t}=this.model;for(let s=0;s<t;s++){if(!(e instanceof l.CompositeScale)){m.logger.warn(`can't reach sub-coordinate level ${t} for ${e} in ${o} dimension; stopped at ${s}`);break}e=e.source_scale}return e instanceof l.CompositeScale?e.target_scale:e},{x_scale:s,y_scale:n}=o.coordinates;h.push(t(s,"x")),u.push(t(n,"y"))}const p=(0,_.scale_range)(h,u,n,a,this.factor,o,t);this.plot_view.state.push("zoom_out",{range:p}),this.plot_view.update_range(p,{scrolling:!0,maintain_focus:this.model.maintain_focus}),this.model.document?.interactive_start(this.plot_view.model),this.plot_view.trigger_ranges_update_event()}}t.ZoomBaseToolView=h,h.__name__="ZoomBaseToolView";class u extends i.PlotActionTool{constructor(e){super(e)}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}t.ZoomBaseTool=u,a=u,u.__name__="ZoomBaseTool",a.define((({Percent:e,Or:o,List:t,Ref:s,Auto:n,NonNegative:a,Int:i})=>({factor:[e,.1],dimensions:[c.Dimensions,"both"],renderers:[o(t(s(r.DataRenderer)),n),"auto"],level:[a(i),0]})))},
function _(n,t,r,e,o){e();const s=n(11);function c(n,t,r){const[e,o]=(0,s.minmax)(n.start,n.end),c=r??(o+e)/2;return[e-(e-c)*t,o-(o-c)*t]}function a(n,t,r){const e=new Map;for(const o of n){const[n,s]=c(o.target_range,t,r),[a,f]=o.r_invert(n,s);e.set(o.source_range,{start:a,end:f})}return e}r.scale_interval=c,r.get_info=function(n,[t,r]){const e=new Map;for(const o of n){const[n,s]=o.r_invert(t,r);e.set(o.source_range,{start:n,end:s})}return e},r.rescale=a,r.scale_range=function(n,t,r,e,o,s=!0,c=!0,f){return{xrs:a(n,s?o:0,f?.x),yrs:a(t,c?o:0,f?.y),factor:o}}},
function _(o,t,e,s,i){var n;s();const _=o(494),a=o(121);class m extends _.ZoomBaseToolView{get factor(){const{factor:o}=this.model;return-o/(1-o)}}e.ZoomOutToolView=m,m.__name__="ZoomOutToolView";class l extends _.ZoomBaseTool{constructor(o){super(o),this.tool_name="Zoom Out",this.tool_icon=a.tool_icon_zoom_out}}e.ZoomOutTool=l,n=l,l.__name__="ZoomOutTool",n.prototype.default_view=m,n.define((({Bool:o})=>({maintain_focus:[o,!0]}))),n.register_alias("zoom_out",(()=>new n({dimensions:"both"}))),n.register_alias("xzoom_out",(()=>new n({dimensions:"width"}))),n.register_alias("yzoom_out",(()=>new n({dimensions:"height"})))},
function _(o,l,T,i,t){i(),t("EditTool",o(498).EditTool),t("BoxEditTool",o(499).BoxEditTool),t("FreehandDrawTool",o(500).FreehandDrawTool),t("LineEditTool",o(501).LineEditTool),t("PointDrawTool",o(503).PointDrawTool),t("PolyDrawTool",o(504).PolyDrawTool),t("PolyTool",o(505).PolyTool),t("PolyEditTool",o(506).PolyEditTool)},
function _(e,t,s,o,n){var i;o();const r=e(10),c=e(9),a=e(8),_=e(12),l=e(296);class d extends l.GestureToolView{constructor(){super(...arguments),this._mouse_in_frame=!0}_select_mode(e){const{shift:t,ctrl:s}=e.modifiers;return t||s?t&&!s?"append":!t&&s?"intersect":t&&s?"subtract":void(0,_.unreachable)():"replace"}_move_enter(e){this._mouse_in_frame=!0}_move_exit(e){this._mouse_in_frame=!1}_map_drag(e,t,s){if(!this.plot_view.frame.bbox.contains(e,t))return null;const o=this.plot_view.renderer_view(s);if(null==o)return null;return[o.coordinates.x_scale.invert(e),o.coordinates.y_scale.invert(t)]}_delete_selected(e){const t=e.data_source,s=t.selected.indices;s.sort();for(const e of t.columns()){const o=t.get_array(e);for(let e=0;e<s.length;e++){const t=s[e];o.splice(t-e,1)}}this._emit_cds_changes(t)}_pop_glyphs(e,t){const s=e.columns();if(0==t||0==s.length)return;const o=(0,c.dict)(e.data);for(const n of s){let s=e.get_array(n);const i=s.length-t+1;i<1||((0,a.isArray)(s)||(s=Array.from(s),o.set(n,s)),s.splice(0,i))}}_emit_cds_changes(e,t=!0,s=!0,o=!0){if(s&&e.selection_manager.clear(),t&&e.change.emit(),o){const{data:t}=e;e.setv({data:t},{check_eq:!1})}}_drag_points(e,t,s="both"){if(null==this._basepoint)return;const[o,n]=this._basepoint;for(const i of t){const t=this._map_drag(o,n,i),r=this._map_drag(e.sx,e.sy,i);if(null==r||null==t)continue;const[a,_]=r,[l,d]=t,[u,f]=[a-l,_-d],h=i.glyph,m=i.data_source,p=(0,c.dict)(m.data),[g,v]=[h.x.field,h.y.field];for(const e of m.selected.indices){if(g&&("width"==s||"both"==s)){(p.get(g)??[])[e]+=u}if(v&&("height"==s||"both"==s)){(p.get(v)??[])[e]+=f}}m.change.emit()}this._basepoint=[e.sx,e.sy]}_pad_empty_columns(e,t){const{inferred_defaults:s}=e,o=(0,c.dict)(e.default_values),n=(0,c.dict)(this.model.default_overrides);for(const i of e.columns())if(!(0,r.includes)(t,i)){const t=(()=>n.has(i)?n.get(i):o.has(i)?o.get(i):s.has(i)?s.get(i):this.model.empty_value)();e.get_array(i).push(t)}}_select_event(e,t,s){const o=this.plot_view.frame,{sx:n,sy:i}=e;if(!o.bbox.contains(n,i))return[];const r={type:"point",sx:n,sy:i},c=[];for(const e of s){const s=e.get_selection_manager(),o=e.data_source,n=this.plot_view.renderer_view(e);if(null!=n){s.select([n],r,!0,t)&&c.push(e),o.properties.selected.change.emit()}}return c}}s.EditToolView=d,d.__name__="EditToolView";class u extends l.GestureTool{constructor(e){super(e)}}s.EditTool=u,i=u,u.__name__="EditTool",i.define((({Unknown:e,Dict:t})=>({default_overrides:[t(e),{}],empty_value:[e,0]})))},
function _(e,i,s,t,l){var n;t();const o=e(20),d=e(28),r=e(217),_=e(373),f=e(350),a=e(370),c=e(355),h=e(382),p=e(358),u=e(384),m=e(214),F=e(498),b=e(121),x=e(12),y=e(9);class g extends F.EditToolView{constructor(){super(...arguments),this._recent_renderers=[]}_tap(e){null==this._draw_basepoint&&null==this._basepoint&&(this._recent_renderers=this._select_event(e,this._select_mode(e),this.model.renderers))}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const i of this.model.renderers)if("Backspace"==e.key)this._delete_selected(i);else if("Escape"==e.key){i.data_source.selection_manager.clear()}}_set_extent([e,i],[s,t],l,n=!1){const o=this._recent_renderers[0]??this.model.renderers[0],r=this.plot_view.renderer_view(o);if(null==r)return;const{glyph:m}=o,F=o.data_source,b=(0,y.dict)(F.data),[g,w]=r.coordinates.x_scale.r_invert(e,i),[v,B]=r.coordinates.y_scale.r_invert(s,t),E=(()=>{if(m instanceof _.Rect){const{x:e,y:i,width:s,height:t}=m;if((0,d.isField)(e)&&(0,d.isField)(i)&&(0,d.isField)(s)&&(0,d.isField)(t))return{[e.field]:(g+w)/2,[i.field]:(v+B)/2,[s.field]:w-g,[t.field]:B-v}}else if(m instanceof f.Block){const{x:e,y:i,width:s,height:t}=m;if((0,d.isField)(e)&&(0,d.isField)(i)&&(0,d.isField)(s)&&(0,d.isField)(t))return{[e.field]:g,[i.field]:v,[s.field]:w-g,[t.field]:B-v}}else if(m instanceof a.Quad){const{right:e,bottom:i,left:s,top:t}=m;if((0,d.isField)(e)&&(0,d.isField)(i)&&(0,d.isField)(s)&&(0,d.isField)(t))return{[e.field]:w,[i.field]:v,[s.field]:g,[t.field]:B}}else if(m instanceof c.HBar){const{left:e,y:i,height:s,right:t}=m;if((0,d.isField)(e)&&(0,d.isField)(i)&&(0,d.isField)(s)&&(0,d.isField)(t))return{[e.field]:g,[i.field]:(v+B)/2,[s.field]:B-v,[t.field]:w}}else if(m instanceof h.VBar){const{x:e,bottom:i,width:s,top:t}=m;if((0,d.isField)(e)&&(0,d.isField)(i)&&(0,d.isField)(s)&&(0,d.isField)(t))return{[e.field]:(g+w)/2,[i.field]:v,[s.field]:w-g,[t.field]:B}}else if(m instanceof p.HStrip){const{y0:e,y1:i}=m;if((0,d.isField)(e)&&(0,d.isField)(i))return{[e.field]:v,[i.field]:B}}else if(m instanceof u.VStrip){const{x0:e,x1:i}=m;if((0,d.isField)(e)&&(0,d.isField)(i))return{[e.field]:g,[i.field]:w}}else(0,x.unreachable)(`'${m.type}' is not supported"`);return null})();if(null!=E){if(l){this._pop_glyphs(F,this.model.num_objects);for(const[e,i]of(0,y.entries)(E))F.get_array(e).push(i);this._pad_empty_columns(F,(0,y.keys)(E))}else{const e=F.get_length();if(null==e)return;const i=e-1;for(const[e,s]of(0,y.entries)(E))b.get(e)[i]=s}this._emit_cds_changes(F,!0,!1,n)}}_update_box(e,i=!1,s=!1){if(null==this._draw_basepoint)return;const t=[e.sx,e.sy],l=this.plot_view.frame,n=this.model.dimensions,[o,d]=this.model._get_dim_limits(this._draw_basepoint,t,l,n);this._set_extent(o,d,i,s)}_press(e){this.model.active&&(null!=this._draw_basepoint?(this._update_box(e,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[e.sx,e.sy],this._select_event(e,"append",this.model.renderers),this._update_box(e,!0,!1)))}_move(e){this._update_box(e,!1,!1)}_pan_start(e){if(e.modifiers.shift){if(null!=this._draw_basepoint)return;this._draw_basepoint=[e.sx,e.sy],this._update_box(e,!0,!1)}else{if(null!=this._basepoint)return;this._recent_renderers=this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy]}}_pan(e,i=!1,s=!1){if(e.modifiers.shift){if(null==this._draw_basepoint)return;this._update_box(e,i,s)}else{if(null==this._basepoint)return;this._drag_points(e,this.model.renderers)}}_drag_points(e,i,s="both"){if(null==this._basepoint)return;const[t,l]=this._basepoint;for(const n of i){const i=this._map_drag(t,l,n),o=this._map_drag(e.sx,e.sy,n);if(null==o||null==i)continue;const[_,m]=o,[F,b]=i,g="width"==s||"both"==s?_-F:0,w="height"==s||"both"==s?m-b:0,{glyph:v}=n,B=n.data_source,E=(0,y.dict)(B.data),k={};if(v instanceof r.XYGlyph){const{x:e,y:i}=v;(0,d.isField)(e)&&(k[e.field]=g),(0,d.isField)(i)&&(k[i.field]=w)}else if(v instanceof f.Block){const{x:e,y:i}=v;(0,d.isField)(e)&&(k[e.field]=g),(0,d.isField)(i)&&(k[i.field]=w)}else if(v instanceof a.Quad){const{right:e,bottom:i,left:s,top:t}=v;(0,d.isField)(s)&&(0,d.isField)(e)&&(k[s.field]=g,k[e.field]=g),(0,d.isField)(t)&&(0,d.isField)(i)&&(k[t.field]=w,k[i.field]=w)}else if(v instanceof c.HBar){const{left:e,right:i,y:s}=v;(0,d.isField)(e)&&(0,d.isField)(i)&&(k[e.field]=g,k[i.field]=g),(0,d.isField)(s)&&(k[s.field]=w)}else if(v instanceof h.VBar){const{x:e,top:i,bottom:s}=v;(0,d.isField)(e)&&(k[e.field]=g),(0,d.isField)(i)&&(0,d.isField)(s)&&(k[i.field]=w,k[s.field]=w)}else if(v instanceof p.HStrip){const{y0:e,y1:i}=v;(0,d.isField)(e)&&(0,d.isField)(i)&&(k[e.field]=w,k[i.field]=w)}else if(v instanceof u.VStrip){const{x0:e,x1:i}=v;(0,d.isField)(e)&&(0,d.isField)(i)&&(k[e.field]=g,k[i.field]=g)}else(0,x.unreachable)(`'${v.type}' is not supported"`);for(const e of B.selected.indices)for(const[i,s]of(0,y.entries)(k)){(E.get(i)??[])[e]+=s}B.change.emit()}this._basepoint=[e.sx,e.sy]}_pan_end(e){if(this._pan(e,!1,!0),e.modifiers.shift)this._draw_basepoint=null;else{this._basepoint=null;for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0)}}}s.BoxEditToolView=g,g.__name__="BoxEditToolView";class w extends F.EditTool{constructor(e){super(e),this.tool_name="Box Edit Tool",this.tool_icon=b.tool_icon_box_edit,this.event_type=["tap","press","pan","move"],this.default_order=1}}s.BoxEditTool=w,n=w,w.__name__="BoxEditTool",n.prototype.default_view=g,n.define((({Int:e,List:i,Ref:s})=>({dimensions:[o.Dimensions,"both"],num_objects:[e,0],renderers:[i(s(m.GlyphRenderer)),[]]})))},
function _(e,t,r,a,s){var _;a();const o=e(9),n=e(8),d=e(498),i=e(214),l=e(121);class h extends d.EditToolView{_draw(e,t,r=!1){if(!this.model.active)return;const a=this.model.renderers[0],s=this._map_drag(e.sx,e.sy,a);if(null==s)return;const[_,d]=s,i=a.data_source,l=(0,o.dict)(i.data),h=a.glyph,[c,p]=[h.xs.field,h.ys.field];if("new"==t)this._pop_glyphs(i,this.model.num_objects),c&&i.get_array(c).push([_]),p&&i.get_array(p).push([d]),this._pad_empty_columns(i,[c,p]);else if("add"==t){if(c){const e=l.get(c)??[],t=e.length-1;let r=i.get_array(c)[t];(0,n.isArray)(r)||(r=Array.from(r),e[t]=r),r.push(_)}if(p){const e=l.get(p)??[],t=e.length-1;let r=i.get_array(p)[t];(0,n.isArray)(r)||(r=Array.from(r),e[t]=r),r.push(d)}}this._emit_cds_changes(i,!0,!0,r)}_pan_start(e){this._draw(e,"new")}_pan(e){this._draw(e,"add")}_pan_end(e){this._draw(e,"add",!0)}_tap(e){this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)"Escape"==e.key?t.data_source.selection_manager.clear():"Backspace"==e.key&&this._delete_selected(t)}}r.FreehandDrawToolView=h,h.__name__="FreehandDrawToolView";class c extends d.EditTool{constructor(e){super(e),this.tool_name="Freehand Draw Tool",this.tool_icon=l.tool_icon_freehand_draw,this.event_type=["pan","tap"],this.default_order=3}}r.FreehandDrawTool=c,_=c,c.__name__="FreehandDrawTool",_.prototype.default_view=h,_.define((({Int:e,List:t,Ref:r})=>({num_objects:[e,0],renderers:[t(r(i.GlyphRenderer)),[]]}))),_.register_alias("freehand_draw",(()=>new _))},
function _(e,t,s,i,r){var n;i();const _=e(20),d=e(9),o=e(214),l=e(502),c=e(121);class h extends l.LineToolView{constructor(){super(...arguments),this._drawing=!1}_press(e){if(!this.model.active)return;const t=this.model.renderers;for(const s of t){1==this._select_event(e,"replace",[s]).length&&(this._selected_renderer=s)}this._show_intersections(),this._update_line_cds()}_show_intersections(){if(!this.model.active)return;if(null==this._selected_renderer)return;if(0==this.model.renderers.length)return this._set_intersection([],[]),this._selected_renderer=null,void(this._drawing=!1);const e=this._selected_renderer.data_source,t=this._selected_renderer.glyph,[s,i]=[t.x.field,t.y.field],r=e.get_array(s),n=e.get_array(i);this._set_intersection(r,n)}_tap(e){const t=this.model.intersection_renderer;if(null==this._map_drag(e.sx,e.sy,t))return;if(this._drawing&&null!=this._selected_renderer){const s=this._select_mode(e);if(0==this._select_event(e,s,[t]).length)return}const s=this._select_mode(e);this._select_event(e,s,[t]),this._select_event(e,s,this.model.renderers)}_update_line_cds(){if(null==this._selected_renderer)return;const e=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,s=(0,d.dict)(t.data),[i,r]=[e.x.field,e.y.field];if(i&&r){const e=s.get(i),t=s.get(r);null!=e&&(0,d.dict)(this._selected_renderer.data_source.data).set(i,e),null!=t&&(0,d.dict)(this._selected_renderer.data_source.data).set(r,t)}this._emit_cds_changes(this._selected_renderer.data_source,!0,!0,!1)}_pan_start(e){this._select_event(e,"append",[this.model.intersection_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer],this.model.dimensions),null!=this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer]),this._emit_cds_changes(this.model.intersection_renderer.data_source,!1,!0,!0),null!=this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}activate(){this._drawing=!0}deactivate(){null!=this._selected_renderer&&(this._drawing&&(this._drawing=!1),this._hide_intersections())}}s.LineEditToolView=h,h.__name__="LineEditToolView";class a extends l.LineTool{constructor(e){super(e),this.tool_name="Line Edit Tool",this.tool_icon=c.tool_icon_line_edit,this.event_type=["tap","press","pan","move"],this.default_order=4}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}s.LineEditTool=a,n=a,a.__name__="LineEditTool",n.prototype.default_view=h,n.define((({List:e,Ref:t})=>({dimensions:[_.Dimensions,"both"],renderers:[e(t(o.GlyphRenderer)),[]]})))},
function _(e,i,t,n,s){var o;n();const r=e(9),_=e(8),c=e(498);class d extends c.EditToolView{_set_intersection(e,i){const t=this.model.intersection_renderer.glyph,n=this.model.intersection_renderer.data_source,s=(0,r.dict)(n.data),[o,c]=[t.x.field,t.y.field];o&&((0,_.isArray)(e)?s.set(o,e):t.x={value:e}),c&&((0,_.isArray)(i)?s.set(c,i):t.y={value:i}),this._emit_cds_changes(n,!0,!0,!1)}_hide_intersections(){this._set_intersection([],[])}}t.LineToolView=d,d.__name__="LineToolView";class l extends c.EditTool{constructor(e){super(e)}}t.LineTool=l,o=l,l.__name__="LineTool",o.define((({AnyRef:e})=>({intersection_renderer:[e()]})))},
function _(e,t,s,o,i){var _;o();const a=e(214),n=e(498),r=e(121);class d extends n.EditToolView{_tap(e){if(0!=this._select_event(e,this._select_mode(e),this.model.renderers).length||!this.model.add)return;const t=this.model.renderers[0],s=this._map_drag(e.sx,e.sy,t);if(null==s)return;const o=t.glyph,i=t.data_source,[_,a]=[o.x.field,o.y.field],[n,r]=s;this._pop_glyphs(i,this.model.num_objects),_&&i.get_array(_).push(n),a&&i.get_array(a).push(r),this._pad_empty_columns(i,[_,a]);const{data:d}=i;i.setv({data:d},{check_eq:!1})}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)"Backspace"==e.key?this._delete_selected(t):"Escape"==e.key&&t.data_source.selection_manager.clear()}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){this.model.drag&&null!=this._basepoint&&this._drag_points(e,this.model.renderers)}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0);this._basepoint=null}}}s.PointDrawToolView=d,d.__name__="PointDrawToolView";class l extends n.EditTool{constructor(e){super(e),this.tool_name="Point Draw Tool",this.tool_icon=r.tool_icon_point_draw,this.event_type=["tap","pan","move"],this.default_order=2}}s.PointDrawTool=l,_=l,l.__name__="PointDrawTool",_.prototype.default_view=d,_.define((({Bool:e,Int:t,List:s,Ref:o})=>({add:[e,!0],drag:[e,!0],num_objects:[t,0],renderers:[s(o(a.GlyphRenderer)),[]]})))},
function _(e,t,s,i,r){var o;i();const n=e(9),a=e(8),_=e(214),l=e(505),d=e(121);class h extends l.PolyToolView{constructor(){super(...arguments),this._drawing=!1,this._initialized=!1}_tap(e){this._drawing?this._draw(e,"add",!0):this._select_event(e,this._select_mode(e),this.model.renderers)}_draw(e,t,s=!1){const i=this.model.renderers[0],r=this._map_drag(e.sx,e.sy,i);if(this._initialized||this.activate(),null==r)return;const[o,_]=this._snap_to_vertex(e,...r),l=i.data_source,d=(0,n.dict)(l.data),h=i.glyph,[c,g]=[h.xs.field,h.ys.field];if("new"==t)this._pop_glyphs(l,this.model.num_objects),c&&l.get_array(c).push([o,o]),g&&l.get_array(g).push([_,_]),this._pad_empty_columns(l,[c,g]);else if("edit"==t){if(c){const e=d.get(c)??[],t=e[e.length-1];t[t.length-1]=o}if(g){const e=d.get(g)??[],t=e[e.length-1];t[t.length-1]=_}}else if("add"==t){if(c){const e=d.get(c)??[],t=e.length-1;let s=l.get_array(c)[t];const i=s[s.length-1];s[s.length-1]=o,(0,a.isArray)(s)||(s=Array.from(s),e[t]=s),s.push(i)}if(g){const e=d.get(g)??[],t=e.length-1;let s=l.get_array(g)[t];const i=s[s.length-1];s[s.length-1]=_,(0,a.isArray)(s)||(s=Array.from(s),e[t]=s),s.push(i)}}this._emit_cds_changes(l,!0,!1,s)}_show_vertices(){if(!this.model.active)return;const e=[],t=[];for(let s=0;s<this.model.renderers.length;s++){const i=this.model.renderers[s],r=i.data_source,o=i.glyph,[n,a]=[o.xs.field,o.ys.field];if(n)for(const t of r.get_array(n))e.push(...t);if(a)for(const e of r.get_array(a))t.push(...e);this._drawing&&s==this.model.renderers.length-1&&(e.splice(e.length-1,1),t.splice(t.length-1,1))}this._set_vertices(e,t)}_press(e){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(e,"edit",!0)):(this._drawing=!0,this._draw(e,"new",!0)))}_move(e){this._drawing&&this._draw(e,"edit")}_remove(){const e=this.model.renderers[0],t=e.data_source,s=(0,n.dict)(t.data),i=e.glyph,[r,o]=[i.xs.field,i.ys.field];if(r){const e=(s.get(r)??[]).length-1,i=t.get_array(r)[e];i.splice(i.length-1,1)}if(o){const e=(s.get(o)??[]).length-1,i=t.get_array(o)[e];i.splice(i.length-1,1)}this._emit_cds_changes(t)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)"Backspace"==e.key?this._delete_selected(t):"Escape"==e.key&&(this._drawing&&(this._remove(),this._drawing=!1),t.data_source.selection_manager.clear())}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){if(null==this._basepoint||!this.model.drag)return;const[t,s]=this._basepoint;for(const i of this.model.renderers){const r=this._map_drag(t,s,i),o=this._map_drag(e.sx,e.sy,i);if(null==o||null==r)continue;const a=i.data_source,_=i.glyph,[l,d]=[_.xs.field,_.ys.field];if(!l&&!d)continue;const[h,c]=o,[g,f]=r,[p,m]=[h-g,c-f],y=(0,n.dict)(a.data);for(const e of a.selected.indices){let t,s,i;if(l){s=(y.get(l)??[])[e]}if(d){i=(y.get(d)??[])[e],t=i.length}else t=s.length;for(let e=0;e<t;e++)s&&(s[e]+=p),i&&(i[e]+=m)}a.change.emit()}this._basepoint=[e.sx,e.sy]}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source);this._basepoint=null}}activate(){if(null!=this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)for(const e of this.model.renderers){const t=e.data_source;t.connect(t.properties.data.change,(()=>this._show_vertices()))}this._initialized=!0}}deactivate(){this._drawing&&(this._remove(),this._drawing=!1),null!=this.model.vertex_renderer&&this._hide_vertices()}}s.PolyDrawToolView=h,h.__name__="PolyDrawToolView";class c extends l.PolyTool{constructor(e){super(e),this.tool_name="Polygon Draw Tool",this.tool_icon=d.tool_icon_poly_draw,this.event_type=["pan","tap","press","move"],this.default_order=3}}s.PolyDrawTool=c,o=c,c.__name__="PolyDrawTool",o.prototype.default_view=h,o.define((({Bool:e,Int:t,List:s,Ref:i})=>({drag:[e,!0],num_objects:[t,0],renderers:[s(i(_.GlyphRenderer)),[]]})))},
function _(e,t,r,s,l){var i;s();const o=e(9),_=e(8),n=e(12),d=e(498);class a extends d.EditToolView{_set_vertices(e,t){const{vertex_renderer:r}=this.model;(0,n.assert)(null!=r);const s=r.glyph,l=r.data_source,[i,d]=[s.x.field,s.y.field],a=(0,o.dict)(l.data);i&&((0,_.isArray)(e)?a.set(i,e):s.x={value:e}),d&&((0,_.isArray)(t)?a.set(d,t):s.y={value:t}),this._emit_cds_changes(l,!0,!0,!1)}_hide_vertices(){this._set_vertices([],[])}_snap_to_vertex(e,t,r){if(null!=this.model.vertex_renderer){const s=this._select_event(e,"replace",[this.model.vertex_renderer]),l=this.model.vertex_renderer.data_source,i=this.model.vertex_renderer.glyph,[_,n]=[i.x.field,i.y.field];if(0!=s.length){const e=l.selected.indices[0],s=(0,o.dict)(l.data);_&&(t=s.get(_)[e]),n&&(r=s.get(n)[e]),l.selection_manager.clear()}}return[t,r]}}r.PolyToolView=a,a.__name__="PolyToolView";class c extends d.EditTool{constructor(e){super(e)}}r.PolyTool=c,i=c,c.__name__="PolyTool",i.define((({AnyRef:e,Nullable:t})=>({vertex_renderer:[t(e()),null]})))},
function _(e,t,r,s,i){var _;s();const n=e(8),d=e(9),l=e(214),c=e(505),a=e(121);class o extends c.PolyToolView{constructor(){super(...arguments),this._drawing=!1,this._cur_index=null}_press(e){if(null==this.model.vertex_renderer||!this.model.active)return;const t=this._map_drag(e.sx,e.sy,this.model.vertex_renderer);if(null==t)return;const[r,s]=t,i=this._select_event(e,"replace",[this.model.vertex_renderer]),_=this.model.vertex_renderer.data_source,n=this.model.vertex_renderer.glyph,[d,l]=[n.x.field,n.y.field];if(0!=i.length&&null!=this._selected_renderer){const e=_.selected.indices[0];this._drawing?(this._drawing=!1,_.selection_manager.clear()):(_.selected.indices=[e+1],d&&_.get_array(d).splice(e+1,0,r),l&&_.get_array(l).splice(e+1,0,s),this._drawing=!0),_.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(e)}_show_vertices(e){if(!this.model.active)return;if(0==this.model.renderers.length)return;const t=this.model.renderers[0],r=()=>this._update_vertices(t),s=t.data_source,i=this._select_event(e,"replace",this.model.renderers);if(0==i.length)return this._set_vertices([],[]),this._selected_renderer=null,this._drawing=!1,this._cur_index=null,void s.disconnect(s.properties.data.change,r);s.connect(s.properties.data.change,r),this._cur_index=i[0].data_source.selected.indices[0],this._update_vertices(i[0])}_update_vertices(e){const t=e.glyph,r=(0,d.dict)(e.data_source.data),s=this._cur_index,[i,_]=[t.xs.field,t.ys.field];if(this._drawing)return;if(null==s&&(i||_))return;let l,c;if(i&&null!=s){const e=r.get(i)??[];l=e[s],(0,n.isArray)(l)||(e[s]=l=Array.from(l))}else l=t.xs.value;if(_&&null!=s){const e=r.get(_)??[];c=e[s],(0,n.isArray)(c)||(e[s]=c=Array.from(c))}else c=t.ys.value;this._selected_renderer=e,this._set_vertices(l,c)}_move(e){if(this._drawing&&null!=this._selected_renderer){const t=this.model.vertex_renderer;if(null==t)return;const r=t.data_source,s=(0,d.dict)(r.data),i=t.glyph,_=this._map_drag(e.sx,e.sy,t);if(null==_)return;let[n,l]=_;const c=r.selected.indices;[n,l]=this._snap_to_vertex(e,n,l),r.selected.indices=c;const[a,o]=[i.x.field,i.y.field],h=c[0];a&&(s.get(a)[h]=n),o&&(s.get(o)[h]=l),r.change.emit(),this._selected_renderer.data_source.change.emit()}}_tap(e){const t=this.model.vertex_renderer;if(null==t)return;const r=this._map_drag(e.sx,e.sy,t);if(null==r)return;if(this._drawing&&null!=this._selected_renderer){let[s,i]=r;const _=t.data_source,n=t.glyph,[d,l]=[n.x.field,n.y.field],c=_.selected.indices;[s,i]=this._snap_to_vertex(e,s,i);const a=c[0];if(_.selected.indices=[a+1],d){const e=_.get_array(d),t=e[a];e[a]=s,e.splice(a+1,0,t)}if(l){const e=_.get_array(l),t=e[a];e[a]=i,e.splice(a+1,0,t)}return _.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}const s=this._select_mode(e);this._select_event(e,s,[t]),this._select_event(e,s,this.model.renderers)}_remove_vertex(){if(!this._drawing||null==this._selected_renderer)return;const e=this.model.vertex_renderer;if(null==e)return;const t=e.data_source,r=e.glyph,s=t.selected.indices[0],[i,_]=[r.x.field,r.y.field];i&&t.get_array(i).splice(s,1),_&&t.get_array(_).splice(s,1),t.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}_pan_start(e){null!=this.model.vertex_renderer&&(this._select_event(e,"append",[this.model.vertex_renderer]),this._basepoint=[e.sx,e.sy])}_pan(e){null!=this._basepoint&&null!=this.model.vertex_renderer&&(this._drag_points(e,[this.model.vertex_renderer]),null!=this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&null!=this.model.vertex_renderer&&(this._drag_points(e,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),null!=this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}_keyup(e){if(!this.model.active||!this._mouse_in_frame)return;let t;if(null!=this._selected_renderer){const{vertex_renderer:e}=this.model;t=null!=e?[e]:[]}else t=this.model.renderers;for(const r of t)"Backspace"==e.key?(this._delete_selected(r),null!=this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):"Escape"==e.key&&(this._drawing?(this._remove_vertex(),this._drawing=!1):null!=this._selected_renderer&&this._hide_vertices(),r.data_source.selection_manager.clear())}deactivate(){null!=this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())}}r.PolyEditToolView=o,o.__name__="PolyEditToolView";class h extends c.PolyTool{constructor(e){super(e),this.tool_name="Poly Edit Tool",this.tool_icon=a.tool_icon_poly_edit,this.event_type=["tap","press","pan","move"],this.default_order=4}}r.PolyEditTool=h,_=h,h.__name__="PolyEditTool",_.prototype.default_view=o,_.define((({List:e,Ref:t})=>({renderers:[e(t(l.GlyphRenderer)),[]]})))},
function _(o,l,e,T,t){T(),t("BoxSelectTool",o(508).BoxSelectTool),t("BoxZoomTool",o(511).BoxZoomTool),t("GestureTool",o(296).GestureTool),t("LassoSelectTool",o(512).LassoSelectTool),t("PanTool",o(514).PanTool),t("PolySelectTool",o(513).PolySelectTool),t("RangeTool",o(515).RangeTool),t("SelectTool",o(510).SelectTool),t("TapTool",o(516).TapTool),t("WheelPanTool",o(517).WheelPanTool),t("WheelZoomTool",o(518).WheelZoomTool)},
function _(t,e,i,o,s){var n;o();const l=t(1),_=t(509),r=t(259),a=t(60),c=t(20),h=l.__importStar(t(121));class p extends _.RegionSelectToolView{connect_signals(){super.connect_signals();const{pan:t}=this.model.overlay;this.connect(t,(([t,e])=>{if("pan"==t&&this._is_continuous(e)||"pan:end"==t){const{left:t,top:i,right:o,bottom:s}=this.model.overlay;if(!(t instanceof a.Coordinate||i instanceof a.Coordinate||o instanceof a.Coordinate||s instanceof a.Coordinate)){const n=this._compute_lrtb({left:t,right:o,top:i,bottom:s});this._do_select([n.left,n.right],[n.top,n.bottom],!1,this._select_mode(e))}}}));const{active:e}=this.model.properties;this.on_change(e,(()=>{this.model.active||this.model.persistent||this._clear_overlay()}))}_compute_limits(t){const e=this.plot_view.frame,i=this.model.dimensions;let o=this._base_point;if("center"==this.model.origin){const[e,i]=o,[s,n]=t;o=[e-(s-e),i-(n-i)]}return this.model._get_dim_limits(o,t,e,i)}_mappers(){const t=(t,e,i,o)=>{switch(t){case"canvas":return o;case"screen":return i;case"data":return e}},{overlay:e}=this.model,{frame:i,canvas:o}=this.plot_view,{x_scale:s,y_scale:n}=i,{x_view:l,y_view:_}=i.bbox,{x_screen:r,y_screen:a}=o.bbox;return{left:t(e.left_units,s,l,r),right:t(e.right_units,s,l,r),top:t(e.top_units,n,_,a),bottom:t(e.bottom_units,n,_,a)}}_compute_lrtb({left:t,right:e,top:i,bottom:o}){const s=this._mappers();return{left:s.left.compute(t),right:s.right.compute(e),top:s.top.compute(i),bottom:s.bottom.compute(o)}}_invert_lrtb({left:t,right:e,top:i,bottom:o}){const s=this._mappers();return{left:s.left.invert(t),right:s.right.invert(e),top:s.top.invert(i),bottom:s.bottom.invert(o)}}_pan_start(t){const{sx:e,sy:i}=t,{frame:o}=this.plot_view;o.bbox.contains(e,i)&&(this._clear_other_overlays(),this._base_point=[e,i])}_pan(t){if(null==this._base_point)return;const{sx:e,sy:i}=t,[o,s]=this._compute_limits([e,i]),[[n,l],[_,r]]=[o,s];this.model.overlay.update(this._invert_lrtb({left:n,right:l,top:_,bottom:r})),this._is_continuous(t.modifiers)&&this._do_select(o,s,!1,this._select_mode(t.modifiers))}_pan_end(t){if(null==this._base_point)return;const{sx:e,sy:i}=t,[o,s]=this._compute_limits([e,i]);this._do_select(o,s,!0,this._select_mode(t.modifiers)),this.model.persistent||this._clear_overlay(),this._base_point=null,this.plot_view.state.push("box_select",{selection:this.plot_view.get_selection()})}get _is_selecting(){return null!=this._base_point}_stop(){this._clear_overlay(),this._base_point=null}_keyup(t){if(this.model.active){if("Escape"==t.key){if(this._is_selecting)return void this._stop();if(this.model.overlay.visible)return void this._clear_overlay()}super._keyup(t)}}_clear_selection(){this.model.overlay.visible?this._clear_overlay():super._clear_selection()}_do_select([t,e],[i,o],s,n="replace"){const{greedy:l}=this.model,_={type:"rect",sx0:t,sx1:e,sy0:i,sy1:o,greedy:l};this._select(_,s,n)}}i.BoxSelectToolView=p,p.__name__="BoxSelectToolView";const m=()=>new r.BoxAnnotation({syncable:!1,level:"overlay",visible:!1,editable:!0,left:NaN,right:NaN,top:NaN,bottom:NaN,top_units:"data",left_units:"data",bottom_units:"data",right_units:"data",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class d extends _.RegionSelectTool{constructor(t){super(t),this.tool_name="Box Select",this.event_type="pan",this.default_order=30}initialize(){super.initialize();const[t,e]=(()=>{switch(this.dimensions){case"width":return["x","x"];case"height":return["y","y"];case"both":return["all","both"]}})(),i="center"==this.origin;this.overlay.setv({resizable:t,movable:e,symmetric:i})}get computed_icon(){const t=super.computed_icon;if(null!=t)return t;switch(this.dimensions){case"both":return`.${h.tool_icon_box_select}`;case"width":return`.${h.tool_icon_x_box_select}`;case"height":return`.${h.tool_icon_y_box_select}`}}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}i.BoxSelectTool=d,n=d,d.__name__="BoxSelectTool",n.prototype.default_view=p,n.define((({Ref:t})=>({dimensions:[c.Dimensions,"both"],overlay:[t(r.BoxAnnotation),m],origin:[c.BoxOrigin,"corner"]}))),n.register_alias("box_select",(()=>new n)),n.register_alias("xbox_select",(()=>new n({dimensions:"width"}))),n.register_alias("ybox_select",(()=>new n({dimensions:"height"})))},
function _(e,o,t,s,l){var n;s();const r=e(510);class c extends r.SelectToolView{get overlays(){return[...super.overlays,this.model.overlay]}_is_continuous(e){return this.model.continuous!=e.alt}_select(e,o,t){const s=this._computed_renderers_by_data_source();for(const[,l]of s){const s=l[0].get_selection_manager(),n=[];for(const e of l){const o=this.plot_view.renderer_view(e);null!=o&&n.push(o)}s.select(n,e,o,t)}this._emit_selection_event(e,o)}_clear_overlay(){super._clear_overlay(),this.model.overlay.clear()}}t.RegionSelectToolView=c,c.__name__="RegionSelectToolView";class _ extends r.SelectTool{constructor(e){super(e)}}t.RegionSelectTool=_,n=_,_.__name__="RegionSelectTool",n.define((({Bool:e})=>({continuous:[e,!1],persistent:[e,!1],greedy:[e,!1]})))},
function _(e,t,o,n,r){var i;n();const s=e(296),c=e(214),l=e(447),a=e(215),d=e(104),_=e(20),h=e(53),p=e(15),u=e(12),m=e(10);class v extends s.GestureToolView{connect_signals(){super.connect_signals(),this.model.invert.connect((()=>this._invert_selection())),this.model.clear.connect((()=>this._clear_selection()))}get computed_renderers(){const{renderers:e}=this.model,t=this.plot_view.model.data_renderers;return(0,d.compute_renderers)(e,t)}_computed_renderers_by_data_source(){const e=new Map;for(const t of this.computed_renderers){let o;if(t instanceof c.GlyphRenderer)o=t.data_source;else{if(!(t instanceof l.GraphRenderer))continue;o=t.node_renderer.data_source}const n=e.get(o)??[];e.set(o,[...n,t])}return e}_clear_overlay(){}_clear_other_overlays(){for(const e of this.plot_view.tool_views.values())e instanceof v&&e!=this&&e._clear_overlay()}_clear_selection(){const{computed_renderers:e}=this,t=(0,m.uniq)(e.map((e=>e.selection_manager)));for(const e of t)e.clear();this.plot_view.request_paint(e)}_invert_selection(){const{computed_renderers:e}=this,t=(0,m.uniq)(e.map((e=>e.selection_manager)));for(const e of t)e.invert();this.plot_view.request_paint(e)}_select_mode(e){const{shift:t,ctrl:o}=e;return t||o?t&&!o?"append":!t&&o?"intersect":t&&o?"subtract":void(0,u.unreachable)():this.model.mode}_keyup(e){this.model.active&&"Escape"==e.key&&this._clear_selection()}_emit_selection_event(e,t=!0){const{x_scale:o,y_scale:n}=this.plot_view.frame,r=(()=>{switch(e.type){case"point":{const{sx:t,sy:r}=e,i=o.invert(t),s=n.invert(r);return{...e,x:i,y:s}}case"span":{const{sx:t,sy:r}=e,i=o.invert(t),s=n.invert(r);return{...e,x:i,y:s}}case"rect":{const{sx0:t,sx1:r,sy0:i,sy1:s}=e,[c,l]=o.r_invert(t,r),[a,d]=n.r_invert(i,s);return{...e,x0:c,y0:a,x1:l,y1:d}}case"poly":{const{sx:t,sy:r}=e,i=o.v_invert(t),s=n.v_invert(r);return{...e,x:i,y:s}}}})();this.plot_view.model.trigger_event(new h.SelectionGeometry(r,t))}}o.SelectToolView=v,v.__name__="SelectToolView";class f extends s.GestureTool{constructor(e){super(e),this.invert=new p.Signal0(this,"invert"),this.clear=new p.Signal0(this,"clear")}get menu(){return[{icon:"bk-tool-icon-replace-mode",tooltip:"Replace the current selection",active:()=>"replace"==this.mode,handler:()=>{this.mode="replace",this.active=!0}},{icon:"bk-tool-icon-append-mode",tooltip:"Append to the current selection (Shift)",active:()=>"append"==this.mode,handler:()=>{this.mode="append",this.active=!0}},{icon:"bk-tool-icon-intersect-mode",tooltip:"Intersect with the current selection (Ctrl)",active:()=>"intersect"==this.mode,handler:()=>{this.mode="intersect",this.active=!0}},{icon:"bk-tool-icon-subtract-mode",tooltip:"Subtract from the current selection (Shift+Ctrl)",active:()=>"subtract"==this.mode,handler:()=>{this.mode="subtract",this.active=!0}},{icon:"bk-tool-icon-xor-mode",tooltip:"Symmetric difference with the current selection",active:()=>"xor"==this.mode,handler:()=>{this.mode="xor",this.active=!0}},null,{icon:"bk-tool-icon-invert-selection",tooltip:"Invert the current selection",handler:()=>{this.invert.emit()}},{icon:"bk-tool-icon-clear-selection",tooltip:"Clear the current selection and/or selection overlay (Esc)",handler:()=>{this.clear.emit()}}]}}o.SelectTool=f,i=f,f.__name__="SelectTool",i.define((({List:e,Ref:t,Or:o,Auto:n})=>({renderers:[o(e(t(a.DataRenderer)),n),"auto"],mode:[_.SelectionMode,"replace"]})))},
function _(o,t,e,i,s){var n;i();const a=o(1),_=o(296),r=o(259),l=o(20),h=a.__importStar(o(121));class c extends _.GestureToolView{constructor(){super(...arguments),this._base_point=null}get overlays(){return[...super.overlays,this.model.overlay]}_match_aspect([o,t],[e,i],s){const n=s.bbox.aspect,a=s.bbox.h_range.end,_=s.bbox.h_range.start,r=s.bbox.v_range.end,l=s.bbox.v_range.start;let h=Math.abs(o-e),c=Math.abs(t-i);const m=0==c?0:h/c,[d]=m>=n?[1,m/n]:[n/m,1];let p,u,b,x;return o<=e?(p=o,u=o+h*d,u>a&&(u=a)):(u=o,p=o-h*d,p<_&&(p=_)),h=Math.abs(u-p),t<=i?(x=t,b=t+h/n,b>r&&(b=r)):(b=t,x=t-h/n,x<l&&(x=l)),c=Math.abs(b-x),o<=e?u=o+n*c:p=o-n*c,[[p,u],[x,b]]}_compute_limits(o,t){const{frame:e}=this.plot_view;if("center"==this.model.origin){const[e,i]=o,[s,n]=t;o=[e-(s-e),i-(n-i)]}const i=(()=>{const{dimensions:e}=this.model;if("auto"==e){const[e,i]=o,[s,n]=t,a=Math.abs(e-s),_=Math.abs(i-n),r=5;return a<r&&_>r?"height":a>r&&_<r?"width":"both"}return e})();return this.model.match_aspect&&"both"==i?this._match_aspect(o,t,e):this.model._get_dim_limits(o,t,e,i)}_pan_start(o){const{sx:t,sy:e}=o;this.plot_view.frame.bbox.contains(t,e)&&(this._base_point=[t,e])}_pan(o){if(null==this._base_point)return;const[[t,e],[i,s]]=this._compute_limits(this._base_point,[o.sx,o.sy]);this.model.overlay.update({left:t,right:e,top:i,bottom:s})}_pan_end(o){if(null==this._base_point)return;const[t,e]=this._compute_limits(this._base_point,[o.sx,o.sy]);this._update(t,e),this._stop()}_stop(){this.model.overlay.clear(),this._base_point=null}_keydown(o){"Escape"==o.key&&this._stop()}_doubletap(o){const{state:t}=this.plot_view;"box_zoom"==t.peek()?.type&&t.undo()}_update([o,t],[e,i]){if(Math.abs(t-o)<=5||Math.abs(i-e)<=5)return;const{x_scales:s,y_scales:n}=this.plot_view.frame,a=new Map;for(const[,e]of s){const[i,s]=e.r_invert(o,t);a.set(e.source_range,{start:i,end:s})}const _=new Map;for(const[,o]of n){const[t,s]=o.r_invert(e,i);_.set(o.source_range,{start:t,end:s})}const r={xrs:a,yrs:_};this.plot_view.state.push("box_zoom",{range:r}),this.plot_view.update_range(r),this.plot_view.trigger_ranges_update_event()}}e.BoxZoomToolView=c,c.__name__="BoxZoomToolView";const m=()=>new r.BoxAnnotation({syncable:!1,level:"overlay",visible:!1,editable:!1,left:NaN,right:NaN,top:NaN,bottom:NaN,top_units:"canvas",left_units:"canvas",bottom_units:"canvas",right_units:"canvas",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class d extends _.GestureTool{constructor(o){super(o),this.tool_name="Box Zoom",this.event_type=["pan","doubletap"],this.default_order=20}get event_role(){return"pan"}get computed_icon(){const o=super.computed_icon;if(null!=o)return o;switch(this.dimensions){case"both":return`.${h.tool_icon_box_zoom}`;case"width":return`.${h.tool_icon_x_box_zoom}`;case"height":return`.${h.tool_icon_y_box_zoom}`;case"auto":return`.${h.tool_icon_auto_box_zoom}`}}get tooltip(){return this._get_dim_tooltip(this.dimensions)}get menu(){return[{icon:h.tool_icon_box_zoom,tooltip:"Box zoom in both dimensions",active:()=>"both"==this.dimensions,handler:()=>{this.dimensions="both",this.active=!0}},{icon:h.tool_icon_x_box_zoom,tooltip:"Box zoom in x-dimension",active:()=>"width"==this.dimensions,handler:()=>{this.dimensions="width",this.active=!0}},{icon:h.tool_icon_y_box_zoom,tooltip:"Box zoom in y-dimension",active:()=>"height"==this.dimensions,handler:()=>{this.dimensions="height",this.active=!0}},{icon:h.tool_icon_auto_box_zoom,tooltip:"Automatic mode (box zoom in x, y or both dimensions, depending on the mouse gesture)",active:()=>"auto"==this.dimensions,handler:()=>{this.dimensions="auto",this.active=!0}}]}}e.BoxZoomTool=d,n=d,d.__name__="BoxZoomTool",n.prototype.default_view=c,n.define((({Bool:o,Ref:t,Or:e,Auto:i})=>({dimensions:[e(l.Dimensions,i),"both"],overlay:[t(r.BoxAnnotation),m],match_aspect:[o,!1],origin:[l.BoxOrigin,"corner"]}))),n.register_alias("box_zoom",(()=>new n({dimensions:"both"}))),n.register_alias("xbox_zoom",(()=>new n({dimensions:"width"}))),n.register_alias("ybox_zoom",(()=>new n({dimensions:"height"}))),n.register_alias("auto_box_zoom",(()=>new n({dimensions:"auto"})))},
function _(e,s,t,o,i){var _;o();const l=e(509),n=e(282),c=e(513),r=e(12),a=e(121);class h extends l.RegionSelectToolView{constructor(){super(...arguments),this._is_selecting=!1}_mappers(){const e=(e,s,t,o)=>{switch(e){case"canvas":return o;case"screen":return t;case"data":return s}},{overlay:s}=this.model,{frame:t,canvas:o}=this.plot_view,{x_scale:i,y_scale:_}=t,{x_view:l,y_view:n}=t.bbox,{x_screen:c,y_screen:r}=o.bbox;return{x:e(s.xs_units,i,l,c),y:e(s.ys_units,_,n,r)}}_v_compute(e,s){const{x:t,y:o}=this._mappers();return[t.v_compute(e),o.v_compute(s)]}_v_invert(e,s){const{x:t,y:o}=this._mappers();return[t.v_invert(e),o.v_invert(s)]}connect_signals(){super.connect_signals();const{pan:e}=this.model.overlay;this.connect(e,(([e,s])=>{if("pan"==e&&this._is_continuous(s)||"pan:end"==e){const{xs:e,ys:t}=this.model.overlay,[o,i]=this._v_compute(e,t);this._do_select(o,i,!1,this._select_mode(s))}}));const{active:s}=this.model.properties;this.on_change(s,(()=>{this.model.active||this.model.persistent||this._clear_overlay()}))}_pan_start(e){const{sx:s,sy:t}=e,{frame:o}=this.plot_view;if(!o.bbox.contains(s,t))return;this._clear_other_overlays(),this._is_selecting=!0;const[i,_]=this._v_invert([s],[t]);this.model.overlay.update({xs:i,ys:_})}_pan(e){(0,r.assert)(this._is_selecting);const[s,t]=(()=>{const{xs:e,ys:s}=this.model.overlay,[t,o]=this._v_compute(e,s);return[[...t],[...o]]})(),[o,i]=this.plot_view.frame.bbox.clip(e.sx,e.sy);s.push(o),t.push(i);const[_,l]=this._v_invert(s,t);this.model.overlay.update({xs:_,ys:l}),this._is_continuous(e.modifiers)&&this._do_select(s,t,!1,this._select_mode(e.modifiers))}_pan_end(e){(0,r.assert)(this._is_selecting),this._is_selecting=!1;const{xs:s,ys:t}=this.model.overlay,[o,i]=this._v_compute(s,t);this._do_select(o,i,!0,this._select_mode(e.modifiers)),this.plot_view.state.push("lasso_select",{selection:this.plot_view.get_selection()}),this.model.persistent||this._clear_overlay()}_keyup(e){this.model.active&&("Escape"==e.key&&this.model.overlay.visible?this._clear_overlay():super._keyup(e))}_clear_selection(){this.model.overlay.visible?this._clear_overlay():super._clear_selection()}_do_select(e,s,t,o){const{greedy:i}=this.model,_={type:"poly",sx:e,sy:s,greedy:i};this._select(_,t,o)}}t.LassoSelectToolView=h,h.__name__="LassoSelectToolView";class v extends l.RegionSelectTool{constructor(e){super(e),this.tool_name="Lasso Select",this.tool_icon=a.tool_icon_lasso_select,this.event_type="pan",this.default_order=12}}t.LassoSelectTool=v,_=v,v.__name__="LassoSelectTool",_.prototype.default_view=h,_.define((({Ref:e})=>({overlay:[e(n.PolyAnnotation),c.DEFAULT_POLY_OVERLAY]}))),_.override({continuous:!0}),_.register_alias("lasso_select",(()=>new _))},
function _(e,s,t,i,o){var _;i();const l=e(509),n=e(282),c=e(121);class r extends l.RegionSelectToolView{constructor(){super(...arguments),this._is_selecting=!1}_mappers(){const e=(e,s,t,i)=>{switch(e){case"canvas":return i;case"screen":return t;case"data":return s}},{overlay:s}=this.model,{frame:t,canvas:i}=this.plot_view,{x_scale:o,y_scale:_}=t,{x_view:l,y_view:n}=t.bbox,{x_screen:c,y_screen:r}=i.bbox;return{x:e(s.xs_units,o,l,c),y:e(s.ys_units,_,n,r)}}_v_compute(e,s){const{x:t,y:i}=this._mappers();return[t.v_compute(e),i.v_compute(s)]}_v_invert(e,s){const{x:t,y:i}=this._mappers();return[t.v_invert(e),i.v_invert(s)]}connect_signals(){super.connect_signals();const{pan:e}=this.model.overlay;this.connect(e,(([e,s])=>{if("pan"==e&&this._is_continuous(s)||"pan:end"==e&&!this._is_selecting){const{xs:e,ys:t}=this.model.overlay,[i,o]=this._v_compute(e,t);this._do_select(i,o,!1,this._select_mode(s))}}));const{active:s}=this.model.properties;this.on_change(s,(()=>{this.model.active||this.model.persistent||this._clear_overlay()}))}_tap(e){const{sx:s,sy:t}=e,{frame:i}=this.plot_view;if(!i.bbox.contains(s,t))return;this._clear_other_overlays();const[o,_]=(()=>{if(this._is_selecting){const{xs:e,ys:s}=this.model.overlay,[t,i]=this._v_compute(e,s);return[[...t],[...i]]}return this._is_selecting=!0,[[],[]]})();o.push(s),_.push(t);const[l,n]=this._v_invert(o,_);this.model.overlay.update({xs:l,ys:n}),this._is_continuous(e.modifiers)&&this._do_select(o,_,!0,this._select_mode(e.modifiers))}_finish_selection(e){this._is_selecting=!1;const{xs:s,ys:t}=this.model.overlay,[i,o]=this._v_compute(s,t);this._do_select(i,o,!0,this._select_mode(e)),this.plot_view.state.push("poly_select",{selection:this.plot_view.get_selection()}),this.model.persistent||this._clear_overlay()}_press(e){this._finish_selection(e.modifiers)}_keyup(e){this.model.active&&("Enter"!=e.key?"Escape"==e.key&&this.model.overlay.visible?this._clear_overlay():super._keyup(e):this._finish_selection(e.modifiers))}_clear_selection(){this.model.overlay.visible?this._clear_overlay():(this._is_selecting=!1,super._clear_selection())}_clear_overlay(){this._is_selecting=!1,super._clear_overlay()}_do_select(e,s,t,i){const{greedy:o}=this.model,_={type:"poly",sx:e,sy:s,greedy:o};this._select(_,t,i)}}t.PolySelectToolView=r,r.__name__="PolySelectToolView";t.DEFAULT_POLY_OVERLAY=()=>new n.PolyAnnotation({syncable:!1,level:"overlay",visible:!1,editable:!0,xs_units:"data",ys_units:"data",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class a extends l.RegionSelectTool{constructor(e){super(e),this.tool_name="Poly Select",this.tool_icon=c.tool_icon_polygon_select,this.event_type="tap",this.default_order=11}}t.PolySelectTool=a,_=a,a.__name__="PolySelectTool",_.prototype.default_view=r,_.define((({Ref:e})=>({overlay:[e(n.PolyAnnotation),t.DEFAULT_POLY_OVERLAY]}))),_.register_alias("poly_select",(()=>new _))},
function _(t,i,n,s,e){var o;s();const a=t(1),_=t(296),r=t(20),h=a.__importStar(t(121));function d(t,i,n){const s=new Map;for(const[,e]of t){const[t,o]=e.r_invert(i,n);s.set(e.source_range,{start:t,end:o})}return s}n.update_ranges=d;class l extends _.GestureToolView{cursor(t,i){const n=this.plot_view.axis_views.find((n=>n.bbox.contains(t,i)));if(null==n)return this.plot_view.frame.bbox.contains(t,i)?"move":super.cursor(t,i);switch(n.dimension){case 0:return"ew-resize";case 1:return"ns-resize"}}_pan_start(t){this.last_dx=0,this.last_dy=0;const{sx:i,sy:n}=t,s=this.plot_view.frame.bbox;if(!s.contains(i,n)){const t=s.h_range,e=s.v_range;(i<t.start||i>t.end)&&(this.v_axis_only=!0),(n<e.start||n>e.end)&&(this.h_axis_only=!0)}this.model.document?.interactive_start(this.plot_view.model)}_pan(t){this._update(t.dx,t.dy),this.model.document?.interactive_start(this.plot_view.model)}_pan_end(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.state.push("pan",{range:this.pan_info}),this.plot_view.trigger_ranges_update_event()}_update(t,i){const n=this.plot_view.frame,s=t-this.last_dx,e=i-this.last_dy,o=n.bbox.h_range,a=o.start-s,_=o.end-s,r=n.bbox.v_range,h=r.start-e,l=r.end-e,c=this.model.dimensions;let p,m,u,v,w,x;"width"!=c&&"both"!=c||this.v_axis_only?(p=o.start,m=o.end,u=0):(p=a,m=_,u=-s),"height"!=c&&"both"!=c||this.h_axis_only?(v=r.start,w=r.end,x=0):(v=h,w=l,x=-e),this.last_dx=t,this.last_dy=i;const{x_scales:g,y_scales:y}=n,b=d(g,p,m),f=d(y,v,w);this.pan_info={xrs:b,yrs:f,sdx:u,sdy:x},this.plot_view.update_range(this.pan_info,{panning:!0})}}n.PanToolView=l,l.__name__="PanToolView";class c extends _.GestureTool{constructor(t){super(t),this.tool_name="Pan",this.event_type="pan",this.default_order=10}get tooltip(){return this._get_dim_tooltip(this.dimensions)}get computed_icon(){const t=super.computed_icon;if(null!=t)return t;switch(this.dimensions){case"both":return`.${h.tool_icon_pan}`;case"width":return`.${h.tool_icon_x_pan}`;case"height":return`.${h.tool_icon_y_pan}`}}get menu(){return[{icon:h.tool_icon_pan,tooltip:"Pan in both dimensions",active:()=>"both"==this.dimensions,handler:()=>{this.dimensions="both",this.active=!0}},{icon:h.tool_icon_x_pan,tooltip:"Pan in x-dimension",active:()=>"width"==this.dimensions,handler:()=>{this.dimensions="width",this.active=!0}},{icon:h.tool_icon_y_pan,tooltip:"Pan in y-dimension",active:()=>"height"==this.dimensions,handler:()=>{this.dimensions="height",this.active=!0}}]}}n.PanTool=c,o=c,c.__name__="PanTool",o.prototype.default_view=l,o.define((()=>({dimensions:[r.Dimensions,"both"]}))),o.register_alias("pan",(()=>new o({dimensions:"both"}))),o.register_alias("xpan",(()=>new o({dimensions:"width"}))),o.register_alias("ypan",(()=>new o({dimensions:"height"})))},
function _(e,t,o,n,i){var a;n();const l=e(289),r=e(297),s=e(259),_=e(94),h=e(19),g=e(12),d=e(8),m=e(121),c=e(59);class v extends l.ToolView{get overlays(){return[...super.overlays,this.model.overlay]}initialize(){super.initialize(),this.model.update_overlay_from_ranges()}connect_signals(){super.connect_signals();const e=()=>this.model.update_overlay_from_ranges();this.on_transitive_change(this.model.properties.x_range,e),this.on_transitive_change(this.model.properties.y_range,e),this.model.overlay.pan.connect((([e,t])=>{if("pan"==e)this.model.update_ranges_from_overlay();else if("pan:end"==e){const e=[this.model.x_range,this.model.y_range].filter(d.non_null);this.parent.trigger_ranges_update_event(e)}}));const{active:t,x_interaction:o,y_interaction:n}=this.model.properties;this.on_change([t,o,n],(()=>{this.model.update_constraints()}))}}o.RangeToolView=v,v.__name__="RangeToolView";const y=()=>new s.BoxAnnotation({syncable:!1,level:"overlay",visible:!0,editable:!0,propagate_hover:!0,left:NaN,right:NaN,top:NaN,bottom:NaN,left_limit:c.Node.frame.left,right_limit:c.Node.frame.right,top_limit:c.Node.frame.top,bottom_limit:c.Node.frame.bottom,fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:.5,line_dash:[2,2]});class p extends l.Tool{constructor(e){super(e),this._nodes=c.Node.frame.freeze(),this.tool_name="Range Tool",this.tool_icon=m.tool_icon_range}initialize(){super.initialize(),this.update_constraints()}update_constraints(){this.overlay.editable=this.active;const e=null!=this.x_range&&this.x_interaction,t=null!=this.y_range&&this.y_interaction;e&&t?(this.overlay.movable="both",this.overlay.resizable="all"):e?(this.overlay.movable="x",this.overlay.resizable="x"):t?(this.overlay.movable="y",this.overlay.resizable="y"):(this.overlay.movable="none",this.overlay.resizable="none");const{x_range:o,y_range:n}=this;null!=o&&(this.overlay.min_width=o.min_interval??0,this.overlay.max_width=o.max_interval??1/0),null!=n&&(this.overlay.min_height=n.min_interval??0,this.overlay.max_height=n.max_interval??1/0)}update_ranges_from_overlay(){const{left:e,right:t,top:o,bottom:n}=this.overlay,{x_range:i,y_range:a}=this,l=new Set,r=new Map,s=new Map;if(null!=i&&this.x_interaction){(0,g.assert)((0,d.isNumber)(e)&&(0,d.isNumber)(t)),r.set(i,{start:e,end:t});for(const e of i.plots)l.add(e)}if(null!=a&&this.y_interaction){(0,g.assert)((0,d.isNumber)(n)&&(0,d.isNumber)(o)),s.set(a,{start:n,end:o});for(const e of a.plots)l.add(e)}for(const e of l)e.update_range({xrs:r,yrs:s},{panning:!0,scrolling:!0})}update_overlay_from_ranges(){const{x_range:e,y_range:t}=this,o=null!=e,n=null!=t;this.overlay.update({left:o?e.start:this._nodes.left,right:o?e.end:this._nodes.right,top:n?t.end:this._nodes.top,bottom:n?t.start:this._nodes.bottom}),o||n||(h.logger.warn("RangeTool not configured with any Ranges."),this.overlay.clear())}tool_button(){return new r.OnOffButton({tool:this})}}o.RangeTool=p,a=p,p.__name__="RangeTool",a.prototype.default_view=v,a.define((({Bool:e,Ref:t,Nullable:o})=>({x_range:[o(t(_.Range)),null],y_range:[o(t(_.Range)),null],x_interaction:[e,!0],y_interaction:[e,!0],overlay:[t(s.BoxAnnotation),y]}))),a.override({active:!0})},
function _(e,t,s,i,o){var l;i();const r=e(510),a=e(50),n=e(20),c=e(21),_=e(8),d=e(121);s.Modifiers=(0,c.PartialStruct)({shift:c.Bool,ctrl:c.Bool,alt:c.Bool});class p extends r.SelectToolView{_tap(e){"tap"==this.model.gesture&&this._handle_tap(e)}_doubletap(e){"doubletap"==this.model.gesture&&this._handle_tap(e)}_handle_tap(e){const{modifiers:t}=this.model;if(null!=t.shift&&t.shift!=e.modifiers.shift)return;if(null!=t.ctrl&&t.ctrl!=e.modifiers.ctrl)return;if(null!=t.alt&&t.alt!=e.modifiers.alt)return;const{sx:s,sy:i}=e,{frame:o}=this.plot_view;if(!o.bbox.contains(s,i))return;this._clear_other_overlays();const l={type:"point",sx:s,sy:i};"select"==this.model.behavior?this._select(l,!0,this._select_mode(e.modifiers)):this._inspect(l,e.modifiers)}_select(e,t,s){const i=this._computed_renderers_by_data_source();for(const[,o]of i){const i=o[0].get_selection_manager(),l=o.map((e=>this.plot_view.renderer_view(e))).filter(_.non_null);if(i.select(l,e,t,s)){const[t]=l;this._emit_callback(t,e,i.source)}}this._emit_selection_event(e),this.plot_view.state.push("tap",{selection:this.plot_view.get_selection()})}_inspect(e,t){for(const s of this.computed_renderers){const i=this.plot_view.renderer_view(s);if(null==i)continue;const o=s.get_selection_manager();o.inspect(i,e)&&this._emit_callback(i,e,o.source,t)}}_emit_callback(e,t,s,i){const{callback:o}=this.model;if(null!=o){const l=e.coordinates.x_scale.invert(t.sx),r=e.coordinates.y_scale.invert(t.sy),n={geometries:{...t,x:l,y:r},source:s,event:{modifiers:i}};(0,a.execute)(o,this.model,n)}}}s.TapToolView=p,p.__name__="TapToolView";class h extends r.SelectTool{constructor(e){super(e),this.tool_name="Tap",this.tool_icon=d.tool_icon_tap_select,this.event_type="tap",this.default_order=10}}s.TapTool=h,l=h,h.__name__="