import socket
from collections import deque
from concurrent.futures import Future, ThreadPoolExecutor
from selectors import DefaultSelector
from types import FrameType

from gunicorn.config import Config
from gunicorn.glogging import Logger as GLogger
from gunicorn.http import RequestParser

from .._types import _AddressType
from . import base

class TConn:
    cfg: Config
    sock: socket.socket
    client: _AddressType
    server: _AddressType
    timeout: float | None
    parser: RequestParser | None
    initialized: bool

    def __init__(self, cfg: Config, sock: socket.socket, client: _AddressType, server: _AddressType) -> None: ...
    def init(self) -> None: ...
    def set_timeout(self) -> None: ...
    def close(self) -> None: ...

class ThreadWorker(base.Worker):
    worker_connections: int
    max_keepalived: int
    tpool: ThreadPoolExecutor
    poller: DefaultSelector
    futures: deque[Future[tuple[bool, TConn]]]
    nr_conns: int
    alive: bool

    @classmethod
    def check_config(cls, cfg: Config, log: GLogger) -> None: ...
    def init_process(self) -> None: ...
    def get_thread_pool(self) -> ThreadPoolExecutor: ...
    def handle_quit(self, sig: int, frame: FrameType | None) -> None: ...
    def enqueue_req(self, conn: TConn) -> None: ...
    def accept(self, server: _AddressType, listener: socket.socket) -> None: ...
    def on_client_socket_readable(self, conn: TConn, client: socket.socket) -> None: ...
    def murder_keepalived(self) -> None: ...
    def is_parent_alive(self) -> bool: ...
    def run(self) -> None: ...
    def finish_request(self, fs: Future[tuple[bool, TConn]]) -> None: ...
    def handle(self, conn: TConn) -> tuple[bool, TConn]: ...
    def handle_request(self, req: RequestParser, conn: TConn) -> bool: ...
