import abc
from _typeshed import Incomplete
from typing_extensions import Self

ConnectionError: Incomplete

class GlobalCache(metaclass=abc.ABCMeta):
    __metaclass__: Incomplete
    transient_errors: Incomplete
    strict_read: bool
    strict_write: bool
    @abc.abstractmethod
    def get(self, keys): ...
    @abc.abstractmethod
    def set(self, items, expires: Incomplete | None = ...): ...
    @abc.abstractmethod
    def delete(self, keys): ...
    @abc.abstractmethod
    def watch(self, items): ...
    @abc.abstractmethod
    def unwatch(self, keys): ...
    @abc.abstractmethod
    def compare_and_swap(self, items, expires: Incomplete | None = ...): ...
    @abc.abstractmethod
    def clear(self): ...

class _InProcessGlobalCache(GlobalCache):
    cache: Incomplete
    def __init__(self) -> None: ...
    def get(self, keys): ...
    def set(self, items, expires: Incomplete | None = ...) -> None: ...
    def delete(self, keys) -> None: ...
    def watch(self, items) -> None: ...
    def unwatch(self, keys) -> None: ...
    def compare_and_swap(self, items, expires: Incomplete | None = ...): ...
    def clear(self) -> None: ...

class RedisCache(GlobalCache):
    transient_errors: Incomplete
    @classmethod
    def from_environment(cls, strict_read: bool = ..., strict_write: bool = ...) -> Self: ...
    redis: Incomplete
    strict_read: Incomplete
    strict_write: Incomplete
    def __init__(self, redis, strict_read: bool = ..., strict_write: bool = ...) -> None: ...
    @property
    def pipes(self): ...
    def get(self, keys): ...
    def set(self, items, expires: Incomplete | None = ...) -> None: ...
    def delete(self, keys) -> None: ...
    def watch(self, items) -> None: ...
    def unwatch(self, keys) -> None: ...
    def compare_and_swap(self, items, expires: Incomplete | None = ...): ...
    def clear(self) -> None: ...

class MemcacheCache(GlobalCache):
    class KeyNotSet(Exception):
        key: Incomplete
        def __init__(self, key) -> None: ...
        def __eq__(self, other): ...

    transient_errors: Incomplete
    @classmethod
    def from_environment(cls, max_pool_size: int = ..., strict_read: bool = ..., strict_write: bool = ...) -> Self: ...
    client: Incomplete
    strict_read: Incomplete
    strict_write: Incomplete
    def __init__(self, client, strict_read: bool = ..., strict_write: bool = ...) -> None: ...
    @property
    def caskeys(self): ...
    def get(self, keys): ...
    def set(self, items, expires: Incomplete | None = ...): ...
    def delete(self, keys) -> None: ...
    def watch(self, items) -> None: ...
    def unwatch(self, keys) -> None: ...
    def compare_and_swap(self, items, expires: Incomplete | None = ...): ...
    def clear(self) -> None: ...
