from _typeshed import Incomplete
from collections.abc import Callable
from typing import type_check_only

from authlib.oauth2.rfc6750 import BearerTokenValidator
from authlib.oauth2.rfc7009 import RevocationEndpoint

@type_check_only
class _RevocationEndpoint(RevocationEndpoint):
    def query_token(self, token, token_type_hint): ...
    def revoke_token(self, token, request) -> None: ...

@type_check_only
class _BearerTokenValidator(BearerTokenValidator):
    def authenticate_token(self, token_string): ...

def create_query_client_func(session, client_model) -> Callable[[Incomplete], Incomplete]: ...
def create_save_token_func(session, token_model) -> Callable[[Incomplete, Incomplete], None]: ...
def create_query_token_func(session, token_model) -> Callable[[Incomplete, Incomplete], Incomplete]: ...
def create_revocation_endpoint(session, token_model) -> type[_RevocationEndpoint]: ...
def create_bearer_token_validator(session, token_model) -> type[_BearerTokenValidator]: ...
