from collections.abc import Iterable
from typing import Any
from typing_extensions import Self

__tracebackhide__: bool

class DictMixin:
    def contains_key(self, *keys: object) -> Self: ...
    def does_not_contain_key(self, *keys: object) -> Self: ...
    def contains_value(self, *values: object) -> Self: ...
    def does_not_contain_value(self, *values: object) -> Self: ...
    # The dicts can contain arbitrary keys and values
    def contains_entry(self, *args: Iterable[dict[Any, Any]], **kwargs: Any) -> Self: ...
    def does_not_contain_entry(self, *args: Iterable[dict[Any, Any]], **kwargs: Any) -> Self: ...
