
/* stddecl.q: shared declarations of the stdtypes modules
   $Id: stddecl.q,v 1.6 2007/10/04 01:19:57 agraef Exp $ */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

include stdlib;

/* Overloaded operations used by various stdtypes modules. Please note that
   this module is not to be imported directly, rather you should usually just
   import the relevant client modules (array.q, bag.q, etc.), or the umbrella
   module stdtypes.q if you want the entire collection. */

public stdlib::null A;		// tests whether A is empty
public member A X;		// tests whether A contains X
public ::list A;		// list the values stored in A
public ::list A as members;	// alias for backward compatibility
public list2 A;			// list values stored in 2D container
public stddecl::list2 A as members2; // alias for backward compatibility
public keys A;			// list the keys stored in A
public vals A;			// list the corresponding values

public first A, stdlib::last A;	// first and last member of A
public rmfirst A, rmlast A;	// remove first and last member from A
public insert A X;		// insert X into A
public stdlib::append A X;	// append X to the end of A
public delete A X;		// remove X from A
public update A K X;		// replace member K of A by X
public update2 A IJ X;		// update two-dimensional container
