/*
 * Decompiled with CFR 0.152.
 */
package org.qore.jni.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.qore.jni.QoreURLClassLoader;

class QoreJavaClassObject
implements JavaFileObject {
    public static final int OT_NORMAL = 0;
    public static final int OT_PENDING = 1;
    public static final int OT_INTERNAL = 2;
    private final String binaryName;
    private final QoreURLClassLoader classLoader;
    private final int type;

    public QoreJavaClassObject(String string, QoreURLClassLoader qoreURLClassLoader, int n) {
        this.binaryName = string;
        this.classLoader = qoreURLClassLoader;
        this.type = n;
    }

    @Override
    public URI toUri() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        try {
            byte[] byArray = this.type == 1 ? this.classLoader.removePendingByteCode(this.binaryName) : (this.type == 2 ? this.classLoader.getInternalClass(this.binaryName) : this.classLoader.generateByteCode(this.binaryName));
            return new ByteArrayInputStream(byArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.binaryName;
    }

    @Override
    public Reader openReader(boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getCharContent(boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.CLASS;
    }

    @Override
    public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
        String string2 = string + kind.extension;
        return kind.equals((Object)this.getKind()) && (string2.equals(this.getName()) || this.getName().endsWith("/" + string2));
    }

    @Override
    public NestingKind getNestingKind() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Modifier getAccessLevel() {
        throw new UnsupportedOperationException();
    }

    public String binaryName() {
        return this.binaryName;
    }

    public String toString() {
        return String.format("QoreJavaClassObject{binaryName=%s,type=%s}", this.binaryName, this.type == 0 ? "NORMAL" : (this.type == 1 ? "PENDING" : "INTERNAL"));
    }
}

