# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{haml-edge}
  s.version = "2.3.251"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Nathan Weizenbaum", "Hampton Catlin"]
  s.date = %q{2010-05-09}
  s.description = %q{      Haml (HTML Abstraction Markup Language) is a layer on top of XHTML or XML
      that's designed to express the structure of XHTML or XML documents
      in a non-repetitive, elegant, easy way,
      using indentation rather than closing tags
      and allowing Ruby to be embedded with ease.
      It was originally envisioned as a plugin for Ruby on Rails,
      but it can function as a stand-alone templating engine.
}
  s.email = %q{haml@googlegroups.com}
  s.executables = ["haml", "html2haml", "sass", "css2sass", "sass-convert"]
  s.extra_rdoc_files = ["README.md", "CONTRIBUTING", "MIT-LICENSE", "VERSION", "VERSION_NAME", "EDGE_GEM_VERSION", "REVISION"]
  s.files = ["rails/init.rb", "lib/haml.rb", "lib/haml/buffer.rb", "lib/haml/engine.rb", "lib/haml/error.rb", "lib/haml/exec.rb", "lib/haml/filters.rb", "lib/haml/helpers.rb", "lib/haml/helpers/action_view_extensions.rb", "lib/haml/helpers/action_view_mods.rb", "lib/haml/helpers/xss_mods.rb", "lib/haml/html.rb", "lib/haml/precompiler.rb", "lib/haml/railtie.rb", "lib/haml/template.rb", "lib/haml/shared.rb", "lib/haml/util.rb", "lib/haml/template/options.rb", "lib/haml/template/patch.rb", "lib/haml/template/plugin.rb", "lib/haml/version.rb", "lib/haml/html/erb.rb", "lib/haml/root.rb", "lib/haml/util/subset_map.rb", "lib/sass.rb", "lib/sass/css.rb", "lib/sass/engine.rb", "lib/sass/environment.rb", "lib/sass/error.rb", "lib/sass/files.rb", "lib/sass/plugin.rb", "lib/sass/repl.rb", "lib/sass/script.rb", "lib/sass/plugin/merb.rb", "lib/sass/plugin/rack.rb", "lib/sass/plugin/rails.rb", "lib/sass/plugin/staleness_checker.rb", "lib/sass/callbacks.rb", "lib/sass/less.rb", "lib/sass/script/bool.rb", "lib/sass/script/color.rb", "lib/sass/script/funcall.rb", "lib/sass/script/functions.rb", "lib/sass/script/lexer.rb", "lib/sass/script/literal.rb", "lib/sass/script/node.rb", "lib/sass/script/number.rb", "lib/sass/script/operation.rb", "lib/sass/script/parser.rb", "lib/sass/script/string.rb", "lib/sass/script/unary_operation.rb", "lib/sass/script/variable.rb", "lib/sass/script/css_lexer.rb", "lib/sass/script/css_parser.rb", "lib/sass/script/interpolation.rb", "lib/sass/script/string_interpolation.rb", "lib/sass/scss.rb", "lib/sass/scss/css_parser.rb", "lib/sass/scss/parser.rb", "lib/sass/scss/rx.rb", "lib/sass/scss/sass_parser.rb", "lib/sass/scss/script_lexer.rb", "lib/sass/scss/script_parser.rb", "lib/sass/scss/static_parser.rb", "lib/sass/selector.rb", "lib/sass/selector/abstract_sequence.rb", "lib/sass/selector/comma_sequence.rb", "lib/sass/selector/sequence.rb", "lib/sass/selector/simple.rb", "lib/sass/selector/simple_sequence.rb", "lib/sass/tree/comment_node.rb", "lib/sass/tree/debug_node.rb", "lib/sass/tree/directive_node.rb", "lib/sass/tree/for_node.rb", "lib/sass/tree/if_node.rb", "lib/sass/tree/import_node.rb", "lib/sass/tree/mixin_def_node.rb", "lib/sass/tree/mixin_node.rb", "lib/sass/tree/node.rb", "lib/sass/tree/prop_node.rb", "lib/sass/tree/rule_node.rb", "lib/sass/tree/variable_node.rb", "lib/sass/tree/while_node.rb", "lib/sass/tree/extend_node.rb", "lib/sass/tree/root_node.rb", "lib/sass/tree/warn_node.rb", "vendor/fssm/LICENSE", "vendor/fssm/README.markdown", "vendor/fssm/Rakefile", "vendor/fssm/VERSION.yml", "vendor/fssm/example.rb", "vendor/fssm/fssm.gemspec", "vendor/fssm/lib/fssm.rb", "vendor/fssm/lib/fssm/backends/fsevents.rb", "vendor/fssm/lib/fssm/backends/inotify.rb", "vendor/fssm/lib/fssm/backends/polling.rb", "vendor/fssm/lib/fssm/backends/rubycocoa/fsevents.rb", "vendor/fssm/lib/fssm/monitor.rb", "vendor/fssm/lib/fssm/path.rb", "vendor/fssm/lib/fssm/pathname.rb", "vendor/fssm/lib/fssm/state/directory.rb", "vendor/fssm/lib/fssm/state/file.rb", "vendor/fssm/lib/fssm/support.rb", "vendor/fssm/lib/fssm/tree.rb", "vendor/fssm/profile/prof-cache.rb", "vendor/fssm/profile/prof-fssm-pathname.html", "vendor/fssm/profile/prof-pathname.rb", "vendor/fssm/profile/prof-plain-pathname.html", "vendor/fssm/profile/prof.html", "vendor/fssm/spec/path_spec.rb", "vendor/fssm/spec/root/duck/quack.txt", "vendor/fssm/spec/root/file.css", "vendor/fssm/spec/root/file.rb", "vendor/fssm/spec/root/file.yml", "vendor/fssm/spec/root/moo/cow.txt", "vendor/fssm/spec/spec_helper.rb", "bin/css2sass", "bin/haml", "bin/html2haml", "bin/sass", "bin/sass-convert", "test/benchmark.rb", "test/haml/engine_test.rb", "test/haml/helper_test.rb", "test/haml/html2haml_test.rb", "test/haml/erb/_av_partial_1.erb", "test/haml/erb/_av_partial_2.erb", "test/haml/erb/action_view.erb", "test/haml/erb/standard.erb", "test/haml/html2haml/erb_tests.rb", "test/haml/markaby/standard.mab", "test/haml/mocks/article.rb", "test/haml/results/content_for_layout.xhtml", "test/haml/results/eval_suppressed.xhtml", "test/haml/results/filters.xhtml", "test/haml/results/helpers.xhtml", "test/haml/results/helpful.xhtml", "test/haml/results/just_stuff.xhtml", "test/haml/results/list.xhtml", "test/haml/results/nuke_inner_whitespace.xhtml", "test/haml/results/nuke_outer_whitespace.xhtml", "test/haml/results/original_engine.xhtml", "test/haml/results/partial_layout.xhtml", "test/haml/results/partials.xhtml", "test/haml/results/render_layout.xhtml", "test/haml/results/silent_script.xhtml", "test/haml/results/standard.xhtml", "test/haml/results/tag_parsing.xhtml", "test/haml/results/very_basic.xhtml", "test/haml/results/whitespace_handling.xhtml", "test/haml/spec/README.md", "test/haml/spec/lua_haml_spec.lua", "test/haml/spec/ruby_haml_test.rb", "test/haml/spec/tests.json", "test/haml/template_test.rb", "test/haml/util_test.rb", "test/haml/templates/_av_partial_1.haml", "test/haml/templates/_av_partial_1_ugly.haml", "test/haml/templates/_av_partial_2.haml", "test/haml/templates/_av_partial_2_ugly.haml", "test/haml/templates/_layout.erb", "test/haml/templates/_layout_for_partial.haml", "test/haml/templates/_partial.haml", "test/haml/templates/_text_area.haml", "test/haml/templates/action_view.haml", "test/haml/templates/action_view_ugly.haml", "test/haml/templates/breakage.haml", "test/haml/templates/content_for_layout.haml", "test/haml/templates/eval_suppressed.haml", "test/haml/templates/filters.haml", "test/haml/templates/helpers.haml", "test/haml/templates/helpful.haml", "test/haml/templates/just_stuff.haml", "test/haml/templates/list.haml", "test/haml/templates/nuke_inner_whitespace.haml", "test/haml/templates/nuke_outer_whitespace.haml", "test/haml/templates/original_engine.haml", "test/haml/templates/partial_layout.haml", "test/haml/templates/partialize.haml", "test/haml/templates/partials.haml", "test/haml/templates/render_layout.haml", "test/haml/templates/silent_script.haml", "test/haml/templates/standard.haml", "test/haml/templates/standard_ugly.haml", "test/haml/templates/tag_parsing.haml", "test/haml/templates/very_basic.haml", "test/haml/templates/whitespace_handling.haml", "test/haml/spec_test.rb", "test/haml/util/subset_map_test.rb", "test/linked_rails.rb", "test/sass/css2sass_test.rb", "test/sass/engine_test.rb", "test/sass/functions_test.rb", "test/sass/plugin_test.rb", "test/sass/script_test.rb", "test/sass/callbacks_test.rb", "test/sass/conversion_test.rb", "test/sass/data/hsl-rgb.txt", "test/sass/more_results/more1.css", "test/sass/more_results/more1_with_line_comments.css", "test/sass/more_results/more_import.css", "test/sass/more_templates/_more_partial.sass", "test/sass/more_templates/more1.sass", "test/sass/more_templates/more_import.sass", "test/sass/extend_test.rb", "test/sass/results/alt.css", "test/sass/results/basic.css", "test/sass/results/compact.css", "test/sass/results/complex.css", "test/sass/results/compressed.css", "test/sass/results/expanded.css", "test/sass/results/import.css", "test/sass/results/line_numbers.css", "test/sass/results/mixins.css", "test/sass/results/multiline.css", "test/sass/results/nested.css", "test/sass/results/parent_ref.css", "test/sass/results/script.css", "test/sass/results/options.css", "test/sass/results/scss_import.css", "test/sass/results/scss_importee.css", "test/sass/results/subdir/nested_subdir/nested_subdir.css", "test/sass/results/subdir/subdir.css", "test/sass/results/units.css", "test/sass/results/warn.css", "test/sass/results/warn_imported.css", "test/sass/less_conversion_test.rb", "test/sass/script_conversion_test.rb", "test/sass/templates/_partial.sass", "test/sass/templates/alt.sass", "test/sass/templates/basic.sass", "test/sass/templates/bork1.sass", "test/sass/templates/bork2.sass", "test/sass/templates/complex.sass", "test/sass/templates/import.sass", "test/sass/templates/compact.sass", "test/sass/templates/mixins.sass", "test/sass/templates/compressed.sass", "test/sass/templates/expanded.sass", "test/sass/templates/importee.sass", "test/sass/templates/line_numbers.sass", "test/sass/templates/parent_ref.sass", "test/sass/templates/script.sass", "test/sass/templates/units.sass", "test/sass/templates/bork3.sass", "test/sass/templates/multiline.sass", "test/sass/templates/nested.sass", "test/sass/templates/bork4.sass", "test/sass/templates/importee.less", "test/sass/templates/mixin_bork.sass", "test/sass/templates/nested_bork1.sass", "test/sass/templates/nested_bork2.sass", "test/sass/templates/nested_bork3.sass", "test/sass/templates/nested_bork4.sass", "test/sass/templates/nested_mixin_bork.sass", "test/sass/templates/options.sass", "test/sass/templates/scss_import.scss", "test/sass/templates/subdir/nested_subdir/_nested_partial.sass", "test/sass/templates/subdir/nested_subdir/nested_subdir.sass", "test/sass/templates/subdir/subdir.sass", "test/sass/templates/scss_importee.scss", "test/sass/templates/warn.sass", "test/sass/templates/warn_imported.sass", "test/sass/scss/css_test.rb", "test/sass/scss/rx_test.rb", "test/sass/scss/scss_test.rb", "test/sass/scss/test_helper.rb", "test/test_helper.rb", "extra/haml-mode.el", "extra/sass-mode.el", "extra/update_watch.rb", "Rakefile", "init.rb", ".yardopts", "README.md", "CONTRIBUTING", "MIT-LICENSE", "VERSION", "VERSION_NAME", "EDGE_GEM_VERSION", "REVISION"]
  s.homepage = %q{http://haml-lang.com/}
  s.rdoc_options = ["--title", "Haml", "--main", "README.rdoc", "--exclude", "lib/haml/buffer.rb", "--line-numbers", "--inline-source"]
  s.require_paths = ["lib"]
  s.rubyforge_project = %q{haml}
  s.rubygems_version = %q{1.3.7}
  s.summary = %q{An elegant, structured XHTML/XML templating engine. Comes with Sass, a similar CSS templating engine.}
  s.test_files = ["test/haml/engine_test.rb", "test/haml/helper_test.rb", "test/haml/html2haml_test.rb", "test/haml/spec/ruby_haml_test.rb", "test/haml/template_test.rb", "test/haml/util_test.rb", "test/haml/spec_test.rb", "test/haml/util/subset_map_test.rb", "test/sass/css2sass_test.rb", "test/sass/engine_test.rb", "test/sass/functions_test.rb", "test/sass/plugin_test.rb", "test/sass/script_test.rb", "test/sass/callbacks_test.rb", "test/sass/conversion_test.rb", "test/sass/extend_test.rb", "test/sass/less_conversion_test.rb", "test/sass/script_conversion_test.rb", "test/sass/scss/css_test.rb", "test/sass/scss/rx_test.rb", "test/sass/scss/scss_test.rb"]

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_development_dependency(%q<yard>, [">= 0.5.3"])
      s.add_development_dependency(%q<maruku>, [">= 0.5.9"])
    else
      s.add_dependency(%q<yard>, [">= 0.5.3"])
      s.add_dependency(%q<maruku>, [">= 0.5.9"])
    end
  else
    s.add_dependency(%q<yard>, [">= 0.5.3"])
    s.add_dependency(%q<maruku>, [">= 0.5.9"])
  end
end
