# code:
# * George Moschovitis  <gm@navel.gr>
#
# (c) 2002-2003 Navel, all rights reserved.
# $Id: array.rb 202 2005-01-17 10:44:13Z gmosx $

require "sync"

module N

# == SafeArray
#
# A thread-safe array. We use a sync object instead of a mutex,
# because it is re-entrant.
# An exclusive lock is needed when writing, a shared lock IS NEEDED
# when reading
#
class SafeArray < Array
	
	attr :sync

	# gmosx: delegator is not used.
	#
	def initialize(delegator = nil)
		@sync = ::Sync.new()
	end

	def << (value)
		return @sync.synchronize(::Sync::SH) {
			super
		}		
	end
	
	def delete_if(&block) 
		return @sync.synchronize(::Sync::SH) {
			super
		}				
	end
	
	def [](key)
		return @sync.synchronize(::Sync::SH) {
			super
		}
	end

	def []=(key, value)
		return @sync.synchronize(::Sync::EX) {
			super
		}
	end

	def delete(key)
		return @sync.synchronize(::Sync::EX) {
			super
		}
	end

	def clear
		@sync.synchronize(::Sync::EX) {
			super
		}
	end

	def size
		return @sync.synchronize(::Sync::SH) {
			super
		}
	end

	def shift
		return @sync.synchronize(::Sync::EX) {
			super
		}
	end

	def unshift(el)
		return @sync.synchronize(::Sync::EX) {
			super
		}
	end
		
end

end # module
