# = Og Mocking Example 
#
# A simple example to demonstrate how to mock Og.
# Very useful in test units.
#
# * George Moschovitis  <gm@navel.gr>
# (c) 2004-2005 Navel, all rights reserved.
# $Id: run.rb 185 2004-12-10 13:29:09Z gmosx $

$:.unshift File.join(File.dirname(__FILE__), '..', '..', 'lib')

require 'rubygems'
require 'flexmock'
require 'og'
require 'og/mock'

class Article
	prop_accessor :body, String

	def initialize(body = nil)
		@body = body
	end
end

class SimpleTest < Test::Unit::TestCase

	def setup
		@og = Og::MockDatabase.new
	end

	def teardown
		@og = nil
	end

	def test_me
		mocks = [
			Article.new('body1'),
			Article.new('body2'),
			Article.new('body3')
		]
		@og.mock_handle(:load_all) { |klass, extrasql| mocks }

		# differnt ways to call the mocked method...
		puts 'Here are the articles:', Article.all
		puts 'Here are the articles:', Article.load_all
		puts 'Here are the articles:', @og.load_all(Article)

		# 3 times called
		assert_equal(3, @og.mock_count(:load_all))
	end

end
