# code:
# * George Moschovitis  <gm@navel.gr>
#
# (c) 2004 Navel, all rights reserved.
# $Id: pool.rb 202 2005-01-17 10:44:13Z gmosx $

require "thread"
require "monitor"

module N

# = Pool
#
# Generalized object pool implementation. Implemented as a thread 
# safe stack. Exclusive locking is needed both for push and pop. 
#
# INVESTIGATE: Could use the SizedQueue/Queue.
#
class Pool < Array
	include MonitorMixin
	
	def initialize
		super
		@cv = new_cond()
	end

	# Add, restore an object to the pool.
	#
	def push(obj)
		synchronize do
			super
			@cv.signal()
		end
	end
	
	# Obtain an object from the pool.
	#
	def pop
		synchronize do
			@cv.wait_while { empty? }
			super
		end
	end

	# Obtains an object, passes it to a block for processing
	# and restores it to the pool.
	def obtain
		result = nil
		
		begin
			obj = pop()

			result = yield(obj)
		ensure
			push(obj)
		end

		return result
	end
	
end

end # module
