# = Og Mysql to PostgreSQL copy example 
#
# A simple example to demonstrate the flexibility of
# Og. Two connections to different databases are 
# created and data is copied from a MySQL database
# to a PostgreSQL database.
#
# Og makes it easier to switch to a REAL database :)
#
# * George Moschovitis  <gm@navel.gr>
# (c) 2004-2005 Navel, all rights reserved.
# $Id$

raise 'WARNING, this example does not work yet, for the moment ' + 
			'just have a look at the source code.'

$:.unshift File.join(File.dirname(__FILE__), '..', '..', 'lib')

require 'og'

# An example managed object.
# Looks like an ordinary Ruby object.

class Article
	prop_accessor :name, :body, String

	def initialize(name = nil, body = nil)
		@name, @body = name, body
	end
end

# Configure databases.

psql_config = {
	:address => 'localhost',
	:database => 'test',
	:backend => 'psql',
	:user => 'postgres',
	:password => 'navelrulez',
	:connection_count => 1
}

mysql_config = {
	:address => 'localhost',
	:database => 'mysql',
	:backend => 'psql',
	:user => 'postgres',
	:password => 'navelrulez',
	:connection_count => 1
}
=begin
mysql_config = {
	:address => 'localhost',
	:database => 'test',
	:backend => 'mysql',
	:user => 'root',
	:password => 'navelrulez',
	:connection_count => 1
}
=end

# Cleanup the databases, remove data from
# earlier executions.

Og::Database.drop!(psql_config)
Og::Database.drop!(mysql_config)

# Initialize Og.

psql = Og::Database.new(psql_config)
mysql = Og::Database.new(mysql_config)

# First populate the mysql database.

Og.use(mysql)

a1 = Article.create('name1', 'body1')
a1 = Article.create('name1', 'body1')
a1 = Article.create('name1', 'body1')

# Read all articles from Mysql.

articles = Article.all

# Switch to PostgreSQL.

Og.use(psql)

# Store all articles.

for article in articles
	article.save!
end

# Fetch an article from PostgreSQL
# as an example. Lookup by name.

article = Article['name1']
