# = Mixins 
#
# A collection of useful mixins. Use these to synthesize your 
# entities.
#
# code: 
# * George Moschovitis  <gm@navel.gr>
#
# (c) 2004 Navel, all rights reserved.
# $Id$

module N

# = Expirable
#
# Generic expiring functionality mixin. 
#
module Expirable
	attr_accessor :expires

	# Set the expires timeout for this entry.

	def expires_after(timeout = (60*60*24))
		@expires = Time.now + timeout
	end

	# Set the expire timeout for this entry. The timeout happens
	# after (base + rand(spread)) seconds.

	def expires_spread(base, spread)
		@expires = Time.now + base + rand(spread)
	end

	# Is this entry expired?

	def expired?
		if @expires.nil? or (Time.now > @expires)
			return true
		else
			return false
		end
	end
end

end # module
