# = Macros
#
# A powerfull macro implementation for Ruby. Allows definition
# of new macro.
#
# EXPERIMENTAL, not fully working yet
#
# code: 
# George Moschovitis  <gm@navel.gr>
#
# (c) 2004 Navel, all rights reserved.
# $Id: macro.rb 165 2004-11-18 12:04:04Z gmosx $

$__macros__ = {}
$__required__ = {}

module Kernel

alias_method :old_require, :require
def require(path)
	return if $__required__[path]
	
	source = File.read(path)
	
	# parse macro
	source.gsub!(/defmacro\s*\/(.*?)\/\s(.*?)endmacro/m) {
		$__macros__[Regexp.new($1)] = $2 ; ""
	}
	
	# expand macros	
	$__macros__.each { |match, replace|
		source.gsub!(match, replace)
	}
	
	$__required__[path] = true

	eval(source)
end

end

require "nitro/test1.rb"
require "nitro/test2.rb"

__END__

Examples:

defmacro /my_macro\((.*)\)/
	begin 
		my_function(\1)
	rescue => ex
		puts ex
	end 
endmacro

