# * George Moschovitis  <gm@navel.gr>
# (c) 2004-2005 Navel, all rights reserved.
# $Id: meta.rb 198 2004-12-22 11:26:59Z gmosx $

class Og

module Enchant

	# Enchant a managed class. Add useful DB related methods 
	# to the class and its instances. 
	
	def enchant(klass)
		klass.module_eval <<-"end_eval", __FILE__, __LINE__
			def self.create(*params, &block)
				obj = #{klass}.new(*params, &block)
				obj.save!
			end
				
			def self.save(obj)
				Og.db << obj
			end
			
			def self.load(oid_or_name)
				Og.db.load(oid_or_name, #{klass})
			end

			def self.get(oid_or_name)
				Og.db.load(oid_or_name, #{klass})
			end
			
			def self.[](oid_or_name)
				Og.db.load(oid_or_name, #{klass})
			end
			
			def self.load_all(extra_sql = nil)
				Og.db.load_all(#{klass}, extra_sql)
			end
			
			def self.all(extra_sql = nil)
				Og.db.load_all(#{klass}, extra_sql)
			end

			def self.count(sql = "SELECT COUNT(*) FROM #{klass::DBTABLE}")
				Og.db.count(sql, #{klass})
			end

			def self.select(sql)
				Og.db.select(sql, #{klass})
			end

			def self.select_one(sql)
				Og.db.select_one(sql, #{klass})
			end

			def self.one(sql)
				Og.db.select_one(sql, #{klass})
			end
			
			def self.delete(obj_or_oid)
				Og.db.delete(obj_or_oid, #{klass})
			end

			def each(&block)
				all.each(&block)
			end
			include Enumerable
			
			def save
				Og.db << self
				return self
			end
			alias_method :save!, :save
			
			def update_properties(updatesql)
				Og.db.pupdate(updatesql, self.oid, #{klass})
			end
			alias_method :pupdate!, :update_properties
			
			def delete!
				Og.db.delete(@oid, #{klass})
			end
		end_eval
	end

end
	
end
