# * George Moschovitis  <gm@navel.gr>
# * Thomas Quas  <tquas@yahoo.com>
# (c) 2004-2005 Navel, all rights reserved.
# $Id$

require 'og'

require 'rubygems'
require_gem 'flexmock'

class Og
	
# A utility object to Mock a Database in test units.
# Extends the standard FlexMock object.
#--
# TODO: Factor out common functionality with Database
# to avoid code duplication.

class MockDatabase < ::FlexMock 
	include Og::Enchant

	# Managed class metadata
	#
	class ManagedClassMeta
		# The managed class.
		attr_accessor :klass
		
		# A mapping of the database fields to the object properties.
		attr_accessor :field_index
		
		def initialize(klass = nil)
			@klass = klass
			@field_index = {}
		end
	end

	# hash of configuration options.
	
	attr_accessor :config

	# Pool of connections to the backend.
	
	attr_accessor :connection_pool

	# Managed classes.

	attr_accessor :managed_classes

	# Initialize the database interface.
	
	def initialize
		# Initialize FlexMock
		super
		
		@managed_classes = N::SafeHash.new
		
		Logger.info "Using mock database."
		
		if Og.auto_manage_classes
			# automatically manage classes with properties and metadata.
			# gmosx: Any idea how to optimize this?

			classes_to_manage = []
			ObjectSpace.each_object(Class) do |c|
				if c.respond_to?(:__props) and c.__props
					classes_to_manage << c
				end
			end
			Logger.info "Og auto manages the following classes:"
			Logger.info "#{classes_to_manage.inspect}"
			manage_classes(*classes_to_manage)
		end

		# use the newly created database.

		Og.use(self)
	end
		
	# Shutdown the database interface.
	
	def shutdown
	end
	alias_method :close, :shutdown

	# Get a connection from the pool to access the database.
	# Stores the connection in a thread-local variable.
	
	def get_connection
		# nop
	end
	alias_method :connection, :get_connection
	
	# Restore an unused connection to the pool.
	
	def put_connection
		# nop
	end	

	# Register a standard Ruby class as managed.
	
	def manage(klass)
		return if managed?(klass) or klass.ancestors.include?(Og::Unmanageable)
		
		@managed_classes[klass] = ManagedClassMeta.new(klass)
		
		# Add standard og methods to the class.
		convert(klass)
		
		# Add helper methods to the class.
		enchant(klass) if Og.enchant_managed_classes 
	end
	
	# Helper method to set multiple managed classes.
	
	def manage_classes(*klasses)
		for klass in klasses
			manage(klass)
		end
	end
	
	# Stop managing a Ruby class
	
	def unmanage(klass)
		@managed_classes.delete(klass)
	end
	
	# Is this class managed?
		
	def managed?(klass)
		return @managed_classes.include?(klass)
	end
	
	# Add standard og functionality to the class
	
	def convert(klass)
		klass.class_eval %{
			DBTABLE = "#{Og::Backend.table(klass)}"
			DBSEQ = "#{Og::Backend.table(klass)}_oids_seq" 
			
			def to_i()
				@oid
			end			
		}
	end

	# Automatically wrap connection methods.
	
	def self.wrap_method(method, args)
		args = args.split(/,/)
		class_eval %{
			def #{method}(#{args.join(", ")})
				# nop
			end
		}
	end

	def self.create_db!(config)
		# nop
	end

	def self.drop_db!(config)
		# nop
	end
end

end 
