# code:
# * George Moschovitis  <gm@navel.gr>
#
# Original code from Rails distribution.
# http://www.rubyonrails.com
#
# $Id$

#--
# Extends the module object with module and instance accessors 
# for class attributes, just like the native attr* accessors for 
# instance attributes. Aliases for classes are also provided.
#
# Example:
#
# mattr_accessor :my_attr, 'Default value'
#++
class Module # :nodoc:
	
  def mattr_reader(*params)
		default = if params.last.is_a?(Symbol) then nil else params.pop end
		
		
    for sym in params
			module_eval <<-"end_eval", __FILE__, __LINE__
			
        if not defined?(@@#{sym.id2name})
          @@#{sym.id2name} = #{default.inspect}
        end
        
        def self.#{sym.id2name}
          @@#{sym}
        end

        def #{sym.id2name}
          @@#{sym}
        end

        def call_#{sym.id2name}
          case @@#{sym.id2name}
            when Symbol then send(@@#{sym})
            when Proc   then @@#{sym}.call(self)
            when String then @@#{sym}
            else nil
          end
        end
				
      end_eval
    end
  end
  alias_method :cattr_reader, :mattr_reader
  
  def mattr_writer(*params)
		default = if params.last.is_a?(Symbol) then nil else params.pop end
		
    for sym in params
			module_eval <<-"end_eval", __FILE__, __LINE__

        if not defined?(@@#{sym.id2name})
          @@#{sym.id2name} = #{default.inspect.inspect}
        end
        
        def self.#{sym.id2name}=(obj)
          @@#{sym.id2name} = obj
        end

        def self.set_#{sym.id2name}(obj)
          @@#{sym.id2name} = obj
        end

        def #{sym.id2name}=(obj)
          @@#{sym} = obj
        end

      end_eval
    end
  end
  alias_method :cattr_writer, :cattr_writer
  
  def mattr_accessor(*syms)
    mattr_reader(*syms)
    mattr_writer(*syms)
  end
  alias_method :cattr_accessor, :mattr_accessor
	
end
