# General libraries used by various projects.
#
#-- 
# George Moschovitis  <gm@navel.gr>
# (c) 2004-2005 Navel, all rights reserved.
# $Id: glue.rb 215 2005-01-24 10:44:05Z gmosx $
#++

require 'English'
require 'pp'

require 'glue/property'
require 'glue/attribute'

# The standard namespace module.

module N; end

class NilClass

	# quite usefull for error tolerant apps.
	# a bit dangerous? Will have to rethink this.
	
	def empty?
		return true
	end
end

class Class
	#--
	# gmosx: is this really needed?
	#++
	
	def to_i
		return self.hash
	end
end

module Kernel

	# Pretty prints an exception/error object
	# usefull for helpfull debug messages
	#
	# Input:
	# The Exception/StandardError object
	#
	# Output:
	# the pretty printed string
	
	def pp_exception(ex)
		return %{#{ex.message}\n\tBACKTRACE:\n\t#{ex.backtrace.join("\n\t")}\n\tLOGGED FROM:\n\t#{caller[0]}}
	end

end

