#! /usr/bin/env ruby
# vim:sw=2:ai

# code: 
# * Thomas Quas  <tquas@yahoo.com>
# * George Moschovitis  <gm@navel.gr>
#
# $Id$

$LOAD_PATH.unshift 'lib'

require "test/unit"
require 'glue/logger'
require 'og/mock'

$DBG = false
$log = Logger.new( STDERR ) unless $log

class Dummy
  prop_accessor :date
  attr_reader :call_stack

  def og_pre_insert( oid )
    @call_stack << "pre_insert"
  end

  def og_post_insert( oid )
    @call_stack << "post_insert"
  end

  def og_pre_update( oid )
    @call_stack << "pre_update"
  end

  def og_post_update( oid )
    @call_stack << "post_update"
  end

  def self.og_pre_delete( conn, oid )
    raise "undeletable"
  end

  def initialize
    @call_stack = []
  end
end

# Tests the Og managed objects lifecycle.
class TC_CallbackTest < ::Test::Unit::TestCase
  def test_insert
    obj = Dummy.new
    obj.save!

    assert( obj.call_stack.shift == "pre_insert" )
    assert( obj.call_stack.shift == "post_insert" )
    assert( obj.call_stack.empty? )
  end

  def test_update
    obj = Dummy.new
    obj.save!
    obj.call_stack.shift
    obj.call_stack.shift

    obj.date = Time.now
    obj.save
    assert( obj.call_stack.shift == "pre_update" )
    assert( obj.call_stack.shift == "post_update" )
    assert( obj.call_stack.empty? )
  end

  def test_delete
    obj = Dummy.new
    obj.save!
    obj.call_stack.shift
    obj.call_stack.shift

    assert_raise( RuntimeError, "undeletable" ) { obj.delete! }
  end

  def setup
		psql = true

		if psql
			config = {
				:backend => "psql",
				:address => "localhost",
				:database => "test",
				:user => "postgres",
				:password => "navelrulez",
				:connection_count => 1
			}
		else
			config = {
				:backend => "mysql",
				:address => "localhost",
				:database => "test",
				:user => "root",
				:password => "navelrulez",
				:connection_count => 1
			}
		end
    Og::Database.drop_db!( config )
    $og = Og::Database.new( config )
    $og.get_connection()
  end
end
