# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = "ruby_parser"
  s.version = "2.0.4"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Ryan Davis"]
  s.date = "2009-08-18"
  s.description = "ruby_parser (RP) is a ruby parser written in pure ruby (utilizing\nracc--which does by default use a C extension). RP's output is\nthe same as ParseTree's output: s-expressions using ruby's arrays and\nbase types.\n\nAs an example:\n\n  def conditional1(arg1)\n    if arg1 == 0 then\n      return 1\n    end\n    return 0\n  end\n\nbecomes:\n\n  s(:defn, :conditional1,\n   s(:args, :arg1),\n   s(:scope,\n    s(:block,\n     s(:if,\n      s(:call, s(:lvar, :arg1), :==, s(:arglist, s(:lit, 0))),\n      s(:return, s(:lit, 1)),\n      nil),\n     s(:return, s(:lit, 0)))))"
  s.email = ["ryand-ruby@zenspider.com"]
  s.executables = ["ruby_parse"]
  s.extra_rdoc_files = ["History.txt", "Manifest.txt", "README.txt"]
  s.files = ["bin/ruby_parse", "History.txt", "Manifest.txt", "README.txt"]
  s.homepage = "http://parsetree.rubyforge.org/"
  s.rdoc_options = ["--main", "README.txt"]
  s.require_paths = ["lib"]
  s.rubyforge_project = "parsetree"
  s.rubygems_version = "1.8.23.2"
  s.summary = "ruby_parser (RP) is a ruby parser written in pure ruby (utilizing racc--which does by default use a C extension)"

  if s.respond_to? :specification_version then
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<sexp_processor>, ["~> 3.0"])
      s.add_development_dependency(%q<ParseTree>, ["~> 3.0"])
      s.add_development_dependency(%q<hoe>, [">= 2.3.3"])
    else
      s.add_dependency(%q<sexp_processor>, ["~> 3.0"])
      s.add_dependency(%q<ParseTree>, ["~> 3.0"])
      s.add_dependency(%q<hoe>, [">= 2.3.3"])
    end
  else
    s.add_dependency(%q<sexp_processor>, ["~> 3.0"])
    s.add_dependency(%q<ParseTree>, ["~> 3.0"])
    s.add_dependency(%q<hoe>, [">= 2.3.3"])
  end
end
