# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = "reek"
  s.version = "1.2.8"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Kevin Rutherford"]
  s.date = "2010-04-25"
  s.description = "Reek is a tool that examines Ruby classes, modules and methods\nand reports any code smells it finds.\n"
  s.email = ["kevin@rutherford-software.com"]
  s.executables = ["reek"]
  s.extra_rdoc_files = ["History.txt", "License.txt"]
  s.files = ["bin/reek", "History.txt", "License.txt"]
  s.homepage = "http://wiki.github.com/kevinrutherford/reek"
  s.post_install_message = "\nThank you for downloading Reek. For info:\n  - see the reek wiki http://wiki.github.com/kevinrutherford/reek\n  - follow @rubyreek on twitter\n"
  s.rdoc_options = ["--main", "README.md"]
  s.require_paths = ["lib"]
  s.rubyforge_project = "reek"
  s.rubygems_version = "1.8.23"
  s.summary = "Code smell detector for Ruby"

  if s.respond_to? :specification_version then
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<ruby_parser>, ["~> 2.0"])
      s.add_runtime_dependency(%q<ruby2ruby>, ["~> 1.2"])
      s.add_runtime_dependency(%q<sexp_processor>, ["~> 3.0"])
    else
      s.add_dependency(%q<ruby_parser>, ["~> 2.0"])
      s.add_dependency(%q<ruby2ruby>, ["~> 1.2"])
      s.add_dependency(%q<sexp_processor>, ["~> 3.0"])
    end
  else
    s.add_dependency(%q<ruby_parser>, ["~> 2.0"])
    s.add_dependency(%q<ruby2ruby>, ["~> 1.2"])
    s.add_dependency(%q<sexp_processor>, ["~> 3.0"])
  end
end
