#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/rainbow_colours/report_errors.rb'
# =========================================================================== #
module Colours

module RainbowColours # === Colours::RainbowColours

  # ========================================================================= #
  # === Colours::RainbowColours.report_no_such_file_or_directory
  # ========================================================================= #
  def self.report_no_such_file_or_directory(i)
    e "Colours::RainbowColours: #{i}: No such file or directory"
  end

  # ========================================================================= #
  # === Colours::RainbowColours.report_is_a_directory
  # ========================================================================= #
  def self.report_is_a_directory(i)
    e "Colours::RainbowColours: #{i}: Is a directory"
  end

  # ========================================================================= #
  # === Colours::RainbowColours.report_permission_denied
  # ========================================================================= #
  def self.report_permission_denied(i)
    e "Colours::RainbowColours: #{i}: Permission denied"
  end

end; end