#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/rainbow_colours/set_mode.rb'
# =========================================================================== #
module Colours

module RainbowColours

  # ========================================================================= #
  # === Colours::RainbowColours.set_mode
  # ========================================================================= #
  def self.set_mode(truecolor)
    begin
      unless Object.const_defined? :Paint
        require 'paint'
      end
      @paint_mode_detected ||= Paint.mode
      Paint.mode = truecolor ? 0xffffff : @paint_mode_detected
    rescue LoadError; end
  end

end; end