#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This file will pull in all .rb files that reside in the
# colours/toplevel_methods/ subdirectory.  
# =========================================================================== #
require 'colours/project/project.rb'

require_these_files = Dir["#{Colours.project_base_directory?}toplevel_methods/*.rb"]

if require_these_files.empty?
  # ===================================================================== #
  # If we can not find any of the files then we will use a hardcoded
  # approach, which follows next.
  # ===================================================================== #
  require_these_files = %w(
    toplevel_methods.rb
  )
end

require_these_files.each {|this_file|
  require "colours/toplevel_methods/#{File.basename(this_file)}"
}