#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
alias e puts
require 'colours'
rev = Colours.rev
# =========================================================================== #
# === ARROW
# =========================================================================== #
ARROW = '→'
# =========================================================================== #
# === PADDING_TO_USE
# =========================================================================== #
PADDING_TO_USE = 58
e
e 'The code in this file will test the various colour-methods, such as'
e 'sfancy(), sdir() and so forth.'
e
e "Let's show the colour-table we will be using here:"
e
pp ::Colours.colour_table?
e
e
e Colours.sfancy(    'Hello world (through sfancy())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.sfancy('').inspect
e Colours.sdir(      'Hello world (through sdir())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.sdir('').inspect
e Colours.simportant('Hello world (through simportant())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.simportant('').inspect
e Colours.swarn(     'Hello world (through swarn())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.swarn('').inspect
# e Colours.snormal(   'Hello world (through snormal())')+Colours.snormal('').inspect
# e Colours.sargument( 'Hello world (through sargument())')+Colours.sargument('').inspect
# ^^^ these two were removed in November 2023.
e Colours.sfile(     'Hello world (through sfile())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.sfile('').inspect
e Colours.ssymlink(  'Hello world (through ssymlink())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.ssymlink('').inspect
e Colours.scomments( 'Hello world (through scomments())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.scomments('').inspect
e
e "#{rev}Next we will use Colours.use_new_colour_table() and hope"
e "#{rev}that this will change the above colours."
Colours.use_new_colour_table
e
e "#{rev}Showing the new colour-table next:"
e
pp ::Colours.colour_table?
e
e Colours.sfancy(    'Hello world (through sfancy())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.sfancy('').inspect
e Colours.sdir(      'Hello world (through sdir())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.sdir('').inspect
e Colours.simportant('Hello world (through simportant())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.simportant('').inspect
e Colours.swarn(     'Hello world (through swarn())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.swarn('').inspect
# e Colours.snormal(   'Hello world (through snormal())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.snormal('').inspect
# e Colours.sargument( 'Hello world (through sargument())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.sargument('').inspect
e Colours.sfile(     'Hello world (through sfile())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.sfile('').inspect
e Colours.ssymlink(  'Hello world (through ssymlink())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.ssymlink('').inspect
e Colours.scomments( 'Hello world (through scomments())').ljust(PADDING_TO_USE)+" #{ARROW} "+Colours.scomments('').inspect
e