# =========================================================================== #
# Gemspec for Project Colours.
# =========================================================================== #
require 'colours/version/version.rb'
require 'roebe/toplevel_methods/misc.rb'

Gem::Specification.new { |s|

  s.name    = 'colours'
  s.version = ::Colours::VERSION
  s.date    = Time.now.strftime('%Y-%m-%d')

  DESCRIPTION = <<-EOF

This library is called colours. It unifies colour-related constants
and methods, including R,G,B values for colours and the commonly
known "HTML colours", such as "slateblue" or "royalblue" and so
on.

The primary use case for this project is to make commandline-scripts
display text on the terminal with colours.

For more information about this project, have a look at the online
documentation for this gem at the link called "documentation", at
the bottom right side of the colours gem homepage:

  #{::Colours::URL_TO_THE_DOCUMENTATION}

EOF

  s.summary     = DESCRIPTION
  s.description = DESCRIPTION

  s.authors  = ['Robert A. Heiler']
  s.email    = Roebe.email?
  s.files    = Dir['**/*']
  s.license  = 'MIT'
  s.homepage = 'https://rubygems.org/gems/colours'

  # ========================================================================= #
  # Show this message when a user installs this project.
  # ========================================================================= #
  s.post_install_message = <<-EOF

  This is the colours gem, a basic gem for colour-related output.

  Usage example:

    require 'colours'

  Have a look at methods such as sfancy() or simp(). These two methods
  are heavily used to colourize important text. The leading "s" stands
  for "string"; imp stands for "important" text.

  If you wish to test the konsole colours, try:

    colours --all_colours

  or

    Colours.test

  EOF

  s.required_ruby_version     = '>= '+Roebe.third_most_stable_version_of_ruby
  s.required_rubygems_version = '>= '+Gem::VERSION
  s.rubygems_version          = '>= '+Gem::VERSION

  # ========================================================================= #
  # No dependencies for this project.
  # ========================================================================= #

}