This file describes how to pick your own colours - or how to use
the Colours gem in general.

The colours-centric Hash will contain entries such as the following:

    sdir: :olivedrab

Now, what does this mean?

This is ultimately a hash entry, a key->value pair, with the key being
called :sdir (a Symbol), and the value being :olivedrab (also a 
Symbol).

"sdir" in turn is an abbreviation for "string_dir", which is short for
"string_directory". This means a String that keeps the colour stored
for when we wish to colourize a directory, such as /tmp/. So, when
such a directory is shown, the HTML colour "olivedrab" will be used.

:olivedrab is thus a HTML colour (== "olivedrab"), which is a beige-green
variant.

What this thus does means, in english, is basically to "use the colour
olivedrab, in order to display all directories in a coloured fashion".

If you wish to use another colour, simply change the Symbol on the
right hand side, aka :olivedrab, to another name, such as :steelblue
or :orange. The names that should be chosen here are HTML Colour
names.

If you wish to get an overview over all available HTML colours, via
ruby, you can do this via the Colours namespace like this:

    Colours.show_html_colours
