#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/autogenerated/html_colours_methods.rb'
# =========================================================================== #
# include ::Colours::HtmlColoursMethods
# =========================================================================== #
module Colours

module HtmlColoursMethods # === ::Colours::HtmlColoursMethods

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.aliceblue
  # ========================================================================= #
  def self.aliceblue(i = '', &block)
    return "\e[38;2;240;248;255m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;240;248;255m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.antiquewhite
  # ========================================================================= #
  def self.antiquewhite(i = '', &block)
    return "\e[38;2;250;235;215m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;250;235;215m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.aqua
  # ========================================================================= #
  def self.aqua(i = '', &block)
    return "\e[38;2;0;255;255m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;255;255m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.aquamarine
  # ========================================================================= #
  def self.aquamarine(i = '', &block)
    return "\e[38;2;127;255;212m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;127;255;212m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.azure
  # ========================================================================= #
  def self.azure(i = '', &block)
    return "\e[38;2;240;255;255m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;240;255;255m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.beige
  # ========================================================================= #
  def self.beige(i = '', &block)
    return "\e[38;2;245;245;220m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;245;245;220m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.bisque
  # ========================================================================= #
  def self.bisque(i = '', &block)
    return "\e[38;2;255;228;196m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;228;196m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.black
  # ========================================================================= #
  def self.black(i = '', &block)
    return "\e[38;2;0;0;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;0;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.blanchedalmond
  # ========================================================================= #
  def self.blanchedalmond(i = '', &block)
    return "\e[38;2;255;235;205m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;235;205m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.blue
  # ========================================================================= #
  def self.blue(i = '', &block)
    return "\e[38;2;0;0;255m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;0;255m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.blueviolet
  # ========================================================================= #
  def self.blueviolet(i = '', &block)
    return "\e[38;2;138;43;226m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;138;43;226m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.brown
  # ========================================================================= #
  def self.brown(i = '', &block)
    return "\e[38;2;165;42;42m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;165;42;42m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.burlywood
  # ========================================================================= #
  def self.burlywood(i = '', &block)
    return "\e[38;2;222;184;135m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;222;184;135m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.cadetblue
  # ========================================================================= #
  def self.cadetblue(i = '', &block)
    return "\e[38;2;95;158;160m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;95;158;160m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.chartreuse
  # ========================================================================= #
  def self.chartreuse(i = '', &block)
    return "\e[38;2;127;255;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;127;255;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.chocolate
  # ========================================================================= #
  def self.chocolate(i = '', &block)
    return "\e[38;2;210;105;30m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;210;105;30m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.coral
  # ========================================================================= #
  def self.coral(i = '', &block)
    return "\e[38;2;255;127;80m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;127;80m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.cornflowerblue
  # ========================================================================= #
  def self.cornflowerblue(i = '', &block)
    return "\e[38;2;100;149;237m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;100;149;237m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.cornsilk
  # ========================================================================= #
  def self.cornsilk(i = '', &block)
    return "\e[38;2;255;248;220m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;248;220m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.crimson
  # ========================================================================= #
  def self.crimson(i = '', &block)
    return "\e[38;2;220;20;60m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;220;20;60m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.cyan
  # ========================================================================= #
  def self.cyan(i = '', &block)
    return "\e[38;2;0;255;255m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;255;255m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkblue
  # ========================================================================= #
  def self.darkblue(i = '', &block)
    return "\e[38;2;0;0;139m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;0;139m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkcyan
  # ========================================================================= #
  def self.darkcyan(i = '', &block)
    return "\e[38;2;0;139;139m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;139;139m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkgoldenrod
  # ========================================================================= #
  def self.darkgoldenrod(i = '', &block)
    return "\e[38;2;184;134;11m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;184;134;11m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkgray
  # ========================================================================= #
  def self.darkgray(i = '', &block)
    return "\e[38;2;169;169;169m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;169;169;169m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkgreen
  # ========================================================================= #
  def self.darkgreen(i = '', &block)
    return "\e[38;2;0;100;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;100;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkgrey
  # ========================================================================= #
  def self.darkgrey(i = '', &block)
    return "\e[38;2;169;169;169m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;169;169;169m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkkhaki
  # ========================================================================= #
  def self.darkkhaki(i = '', &block)
    return "\e[38;2;189;183;107m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;189;183;107m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkmagenta
  # ========================================================================= #
  def self.darkmagenta(i = '', &block)
    return "\e[38;2;139;0;139m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;139;0;139m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkolivegreen
  # ========================================================================= #
  def self.darkolivegreen(i = '', &block)
    return "\e[38;2;85;107;47m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;85;107;47m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkorange
  # ========================================================================= #
  def self.darkorange(i = '', &block)
    return "\e[38;2;255;140;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;140;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkorchid
  # ========================================================================= #
  def self.darkorchid(i = '', &block)
    return "\e[38;2;153;50;204m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;153;50;204m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkred
  # ========================================================================= #
  def self.darkred(i = '', &block)
    return "\e[38;2;139;0;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;139;0;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darksalmon
  # ========================================================================= #
  def self.darksalmon(i = '', &block)
    return "\e[38;2;233;150;122m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;233;150;122m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkseagreen
  # ========================================================================= #
  def self.darkseagreen(i = '', &block)
    return "\e[38;2;143;188;143m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;143;188;143m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkslateblue
  # ========================================================================= #
  def self.darkslateblue(i = '', &block)
    return "\e[38;2;72;61;139m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;72;61;139m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkslategray
  # ========================================================================= #
  def self.darkslategray(i = '', &block)
    return "\e[38;2;47;79;79m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;47;79;79m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkslategrey
  # ========================================================================= #
  def self.darkslategrey(i = '', &block)
    return "\e[38;2;47;79;79m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;47;79;79m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkturquoise
  # ========================================================================= #
  def self.darkturquoise(i = '', &block)
    return "\e[38;2;0;206;209m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;206;209m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.darkviolet
  # ========================================================================= #
  def self.darkviolet(i = '', &block)
    return "\e[38;2;148;0;211m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;148;0;211m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.deeppink
  # ========================================================================= #
  def self.deeppink(i = '', &block)
    return "\e[38;2;255;20;147m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;20;147m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.deepskyblue
  # ========================================================================= #
  def self.deepskyblue(i = '', &block)
    return "\e[38;2;0;191;255m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;191;255m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.dimgray
  # ========================================================================= #
  def self.dimgray(i = '', &block)
    return "\e[38;2;105;105;105m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;105;105;105m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.dimgrey
  # ========================================================================= #
  def self.dimgrey(i = '', &block)
    return "\e[38;2;105;105;105m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;105;105;105m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.dodgerblue
  # ========================================================================= #
  def self.dodgerblue(i = '', &block)
    return "\e[38;2;30;144;255m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;30;144;255m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.firebrick
  # ========================================================================= #
  def self.firebrick(i = '', &block)
    return "\e[38;2;178;34;34m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;178;34;34m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.floralwhite
  # ========================================================================= #
  def self.floralwhite(i = '', &block)
    return "\e[38;2;255;250;240m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;250;240m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.forestgreen
  # ========================================================================= #
  def self.forestgreen(i = '', &block)
    return "\e[38;2;34;139;34m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;34;139;34m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.fuchsia
  # ========================================================================= #
  def self.fuchsia(i = '', &block)
    return "\e[38;2;255;0;255m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;0;255m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.gainsboro
  # ========================================================================= #
  def self.gainsboro(i = '', &block)
    return "\e[38;2;220;220;220m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;220;220;220m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.ghostwhite
  # ========================================================================= #
  def self.ghostwhite(i = '', &block)
    return "\e[38;2;248;248;255m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;248;248;255m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.gold
  # ========================================================================= #
  def self.gold(i = '', &block)
    return "\e[38;2;255;215;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;215;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.goldenrod
  # ========================================================================= #
  def self.goldenrod(i = '', &block)
    return "\e[38;2;218;165;32m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;218;165;32m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.gray
  # ========================================================================= #
  def self.gray(i = '', &block)
    return "\e[38;2;128;128;128m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;128;128;128m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.grey
  # ========================================================================= #
  def self.grey(i = '', &block)
    return "\e[38;2;128;128;128m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;128;128;128m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.green
  # ========================================================================= #
  def self.green(i = '', &block)
    return "\e[38;2;0;128;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;128;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.greenyellow
  # ========================================================================= #
  def self.greenyellow(i = '', &block)
    return "\e[38;2;173;255;47m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;173;255;47m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.honeydew
  # ========================================================================= #
  def self.honeydew(i = '', &block)
    return "\e[38;2;240;255;240m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;240;255;240m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.hotpink
  # ========================================================================= #
  def self.hotpink(i = '', &block)
    return "\e[38;2;255;105;180m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;105;180m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.indianred
  # ========================================================================= #
  def self.indianred(i = '', &block)
    return "\e[38;2;205;92;92m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;205;92;92m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.indigo
  # ========================================================================= #
  def self.indigo(i = '', &block)
    return "\e[38;2;75;0;130m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;75;0;130m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.ivory
  # ========================================================================= #
  def self.ivory(i = '', &block)
    return "\e[38;2;255;255;240m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;255;240m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.khaki
  # ========================================================================= #
  def self.khaki(i = '', &block)
    return "\e[38;2;240;230;140m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;240;230;140m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lavender
  # ========================================================================= #
  def self.lavender(i = '', &block)
    return "\e[38;2;230;230;250m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;230;230;250m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lavenderblush
  # ========================================================================= #
  def self.lavenderblush(i = '', &block)
    return "\e[38;2;255;240;245m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;240;245m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lawngreen
  # ========================================================================= #
  def self.lawngreen(i = '', &block)
    return "\e[38;2;124;252;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;124;252;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lemonchiffon
  # ========================================================================= #
  def self.lemonchiffon(i = '', &block)
    return "\e[38;2;255;250;205m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;250;205m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightblue
  # ========================================================================= #
  def self.lightblue(i = '', &block)
    return "\e[38;2;173;216;230m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;173;216;230m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightcoral
  # ========================================================================= #
  def self.lightcoral(i = '', &block)
    return "\e[38;2;240;128;128m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;240;128;128m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightcyan
  # ========================================================================= #
  def self.lightcyan(i = '', &block)
    return "\e[38;2;224;255;255m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;224;255;255m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightgoldenrodyellow
  # ========================================================================= #
  def self.lightgoldenrodyellow(i = '', &block)
    return "\e[38;2;250;250;210m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;250;250;210m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightgray
  # ========================================================================= #
  def self.lightgray(i = '', &block)
    return "\e[38;2;211;211;211m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;211;211;211m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightgrey
  # ========================================================================= #
  def self.lightgrey(i = '', &block)
    return "\e[38;2;211;211;211m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;211;211;211m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightgreen
  # ========================================================================= #
  def self.lightgreen(i = '', &block)
    return "\e[38;2;144;238;144m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;144;238;144m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightpink
  # ========================================================================= #
  def self.lightpink(i = '', &block)
    return "\e[38;2;255;182;193m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;182;193m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightsalmon
  # ========================================================================= #
  def self.lightsalmon(i = '', &block)
    return "\e[38;2;255;160;122m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;160;122m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightseagreen
  # ========================================================================= #
  def self.lightseagreen(i = '', &block)
    return "\e[38;2;32;178;170m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;32;178;170m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightskyblue
  # ========================================================================= #
  def self.lightskyblue(i = '', &block)
    return "\e[38;2;135;206;250m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;135;206;250m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightslategray
  # ========================================================================= #
  def self.lightslategray(i = '', &block)
    return "\e[38;2;119;136;153m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;119;136;153m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightslategrey
  # ========================================================================= #
  def self.lightslategrey(i = '', &block)
    return "\e[38;2;119;136;153m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;119;136;153m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightsteelblue
  # ========================================================================= #
  def self.lightsteelblue(i = '', &block)
    return "\e[38;2;176;196;222m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;176;196;222m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lightyellow
  # ========================================================================= #
  def self.lightyellow(i = '', &block)
    return "\e[38;2;255;255;224m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;255;224m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.lime
  # ========================================================================= #
  def self.lime(i = '', &block)
    return "\e[38;2;0;255;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;255;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.limegreen
  # ========================================================================= #
  def self.limegreen(i = '', &block)
    return "\e[38;2;50;205;50m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;50;205;50m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.linen
  # ========================================================================= #
  def self.linen(i = '', &block)
    return "\e[38;2;250;240;230m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;250;240;230m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.magenta
  # ========================================================================= #
  def self.magenta(i = '', &block)
    return "\e[38;2;255;0;255m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;0;255m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.maroon
  # ========================================================================= #
  def self.maroon(i = '', &block)
    return "\e[38;2;128;0;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;128;0;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.mediumaquamarine
  # ========================================================================= #
  def self.mediumaquamarine(i = '', &block)
    return "\e[38;2;102;205;170m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;102;205;170m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.mediumblue
  # ========================================================================= #
  def self.mediumblue(i = '', &block)
    return "\e[38;2;0;0;205m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;0;205m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.mediumorchid
  # ========================================================================= #
  def self.mediumorchid(i = '', &block)
    return "\e[38;2;186;85;211m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;186;85;211m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.mediumpurple
  # ========================================================================= #
  def self.mediumpurple(i = '', &block)
    return "\e[38;2;147;112;219m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;147;112;219m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.mediumseagreen
  # ========================================================================= #
  def self.mediumseagreen(i = '', &block)
    return "\e[38;2;60;179;113m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;60;179;113m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.mediumslateblue
  # ========================================================================= #
  def self.mediumslateblue(i = '', &block)
    return "\e[38;2;123;104;238m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;123;104;238m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.mediumspringgreen
  # ========================================================================= #
  def self.mediumspringgreen(i = '', &block)
    return "\e[38;2;0;250;154m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;250;154m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.mediumturquoise
  # ========================================================================= #
  def self.mediumturquoise(i = '', &block)
    return "\e[38;2;72;209;204m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;72;209;204m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.mediumvioletred
  # ========================================================================= #
  def self.mediumvioletred(i = '', &block)
    return "\e[38;2;199;21;133m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;199;21;133m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.midnightblue
  # ========================================================================= #
  def self.midnightblue(i = '', &block)
    return "\e[38;2;25;25;112m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;25;25;112m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.mintcream
  # ========================================================================= #
  def self.mintcream(i = '', &block)
    return "\e[38;2;245;255;250m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;245;255;250m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.mistyrose
  # ========================================================================= #
  def self.mistyrose(i = '', &block)
    return "\e[38;2;255;228;225m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;228;225m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.moccasin
  # ========================================================================= #
  def self.moccasin(i = '', &block)
    return "\e[38;2;255;228;181m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;228;181m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.navajowhite
  # ========================================================================= #
  def self.navajowhite(i = '', &block)
    return "\e[38;2;255;222;173m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;222;173m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.navy
  # ========================================================================= #
  def self.navy(i = '', &block)
    return "\e[38;2;0;0;128m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;0;128m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.oldlace
  # ========================================================================= #
  def self.oldlace(i = '', &block)
    return "\e[38;2;253;245;230m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;253;245;230m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.olive
  # ========================================================================= #
  def self.olive(i = '', &block)
    return "\e[38;2;128;128;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;128;128;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.olivedrab
  # ========================================================================= #
  def self.olivedrab(i = '', &block)
    return "\e[38;2;107;142;35m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;107;142;35m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.orange
  # ========================================================================= #
  def self.orange(i = '', &block)
    return "\e[38;2;255;165;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;165;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.orangered
  # ========================================================================= #
  def self.orangered(i = '', &block)
    return "\e[38;2;255;69;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;69;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.orchid
  # ========================================================================= #
  def self.orchid(i = '', &block)
    return "\e[38;2;218;112;214m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;218;112;214m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.palegoldenrod
  # ========================================================================= #
  def self.palegoldenrod(i = '', &block)
    return "\e[38;2;238;232;170m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;238;232;170m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.palegreen
  # ========================================================================= #
  def self.palegreen(i = '', &block)
    return "\e[38;2;152;251;152m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;152;251;152m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.paleturquoise
  # ========================================================================= #
  def self.paleturquoise(i = '', &block)
    return "\e[38;2;175;238;238m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;175;238;238m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.palevioletred
  # ========================================================================= #
  def self.palevioletred(i = '', &block)
    return "\e[38;2;219;112;147m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;219;112;147m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.papayawhip
  # ========================================================================= #
  def self.papayawhip(i = '', &block)
    return "\e[38;2;255;239;213m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;239;213m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.peachpuff
  # ========================================================================= #
  def self.peachpuff(i = '', &block)
    return "\e[38;2;255;218;185m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;218;185m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.peru
  # ========================================================================= #
  def self.peru(i = '', &block)
    return "\e[38;2;205;133;63m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;205;133;63m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.pink
  # ========================================================================= #
  def self.pink(i = '', &block)
    return "\e[38;2;255;192;203m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;192;203m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.plum
  # ========================================================================= #
  def self.plum(i = '', &block)
    return "\e[38;2;221;160;221m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;221;160;221m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.powderblue
  # ========================================================================= #
  def self.powderblue(i = '', &block)
    return "\e[38;2;176;224;230m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;176;224;230m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.purple
  # ========================================================================= #
  def self.purple(i = '', &block)
    return "\e[38;2;128;0;128m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;128;0;128m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.red
  # ========================================================================= #
  def self.red(i = '', &block)
    return "\e[38;2;255;0;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;0;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.rosybrown
  # ========================================================================= #
  def self.rosybrown(i = '', &block)
    return "\e[38;2;188;143;143m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;188;143;143m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.royalblue
  # ========================================================================= #
  def self.royalblue(i = '', &block)
    return "\e[38;2;65;105;225m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;65;105;225m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.saddlebrown
  # ========================================================================= #
  def self.saddlebrown(i = '', &block)
    return "\e[38;2;139;69;19m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;139;69;19m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.salmon
  # ========================================================================= #
  def self.salmon(i = '', &block)
    return "\e[38;2;250;128;114m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;250;128;114m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.sandybrown
  # ========================================================================= #
  def self.sandybrown(i = '', &block)
    return "\e[38;2;244;164;96m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;244;164;96m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.seagreen
  # ========================================================================= #
  def self.seagreen(i = '', &block)
    return "\e[38;2;46;139;87m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;46;139;87m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.seashell
  # ========================================================================= #
  def self.seashell(i = '', &block)
    return "\e[38;2;255;245;238m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;245;238m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.sienna
  # ========================================================================= #
  def self.sienna(i = '', &block)
    return "\e[38;2;160;82;45m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;160;82;45m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.silver
  # ========================================================================= #
  def self.silver(i = '', &block)
    return "\e[38;2;192;192;192m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;192;192;192m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.skyblue
  # ========================================================================= #
  def self.skyblue(i = '', &block)
    return "\e[38;2;135;206;235m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;135;206;235m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.slateblue
  # ========================================================================= #
  def self.slateblue(i = '', &block)
    return "\e[38;2;106;90;205m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;106;90;205m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.slategray
  # ========================================================================= #
  def self.slategray(i = '', &block)
    return "\e[38;2;112;128;144m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;112;128;144m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.slategrey
  # ========================================================================= #
  def self.slategrey(i = '', &block)
    return "\e[38;2;112;128;144m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;112;128;144m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.snow
  # ========================================================================= #
  def self.snow(i = '', &block)
    return "\e[38;2;255;250;250m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;250;250m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.springgreen
  # ========================================================================= #
  def self.springgreen(i = '', &block)
    return "\e[38;2;0;255;127m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;255;127m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.steelblue
  # ========================================================================= #
  def self.steelblue(i = '', &block)
    return "\e[38;2;70;130;180m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;70;130;180m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.tan
  # ========================================================================= #
  def self.tan(i = '', &block)
    return "\e[38;2;210;180;140m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;210;180;140m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.teal
  # ========================================================================= #
  def self.teal(i = '', &block)
    return "\e[38;2;0;128;128m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;0;128;128m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.thistle
  # ========================================================================= #
  def self.thistle(i = '', &block)
    return "\e[38;2;216;191;216m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;216;191;216m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.tomato
  # ========================================================================= #
  def self.tomato(i = '', &block)
    return "\e[38;2;255;99;71m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;99;71m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.turquoise
  # ========================================================================= #
  def self.turquoise(i = '', &block)
    return "\e[38;2;64;224;208m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;64;224;208m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.violet
  # ========================================================================= #
  def self.violet(i = '', &block)
    return "\e[38;2;238;130;238m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;238;130;238m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.wheat
  # ========================================================================= #
  def self.wheat(i = '', &block)
    return "\e[38;2;245;222;179m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;245;222;179m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.white
  # ========================================================================= #
  def self.white(i = '', &block)
    return "\e[38;2;255;255;255m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;255;255m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.whitesmoke
  # ========================================================================= #
  def self.whitesmoke(i = '', &block)
    return "\e[38;2;245;245;245m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;245;245;245m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.yellow
  # ========================================================================= #
  def self.yellow(i = '', &block)
    return "\e[38;2;255;255;0m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;255;255;0m#{i}\e[0m"
  end

  # ========================================================================= #
  # === Colours::HtmlColoursMethods.yellowgreen
  # ========================================================================= #
  def self.yellowgreen(i = '', &block)
    return "\e[38;2;154;205;50m#{i}" if block_given? and (yield == :omit_end)
    return "\e[38;2;154;205;50m#{i}\e[0m"
  end

end

end
