#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This class can be used if you want to subclass directly from the
# colours gem. It is in many ways a "dummy" class, but it also allows
# you to quickly subclass from it, if you  need methods such as
# royalblue() to work in your class. Other than that it may be better
# to work with the modules instead, e. g. "include Colours" specifically.
# =========================================================================== #
# require 'colours/base/base.rb'
# class Foobar < Colours::Base
# =========================================================================== #
module Colours

class Base # === Colours::Base

  require 'colours/constants/constants.rb' # For methods such as left?.
  require 'colours/requires/require_essentials.rb'
  require 'colours/toplevel_methods/toplevel_methods.rb'
  require 'colours/toplevel_methods/e.rb'
  require 'colours/module_256_colours/module_256_colours.rb'
  require 'colours/sfile_sdir_sfancy_swarn_simp_scomments_and_ssymlink/sfile_sdir_sfancy_swarn_simp_scomments_and_ssymlink.rb'
  require 'colours/html_colours/html_colours.rb'
  
  # =========================================================================== #
  # === e
  # =========================================================================== #
  def e(i = '')
    ::Colours.e(i)
  end

  # =========================================================================== #
  # === set_commandline_arguments
  # =========================================================================== #
  def set_commandline_arguments(i)
    @commandline_arguments = [i].flatten.compact
  end

  # =========================================================================== #
  # === commandline_arguments?
  # =========================================================================== #
  def commandline_arguments?
    @commandline_arguments
  end

  # =========================================================================== #
  # === first_argument?
  # =========================================================================== #
  def first_argument?
    @commandline_arguments.first
  end

  # =========================================================================== #
  # === second_argument?
  # =========================================================================== #
  def second_argument?
    @commandline_arguments[1]
  end

  # =========================================================================== #
  # === extend_module_256_colours
  # =========================================================================== #
  def extend_module_256_colours
    extend ::Colours::Module256Colours
  end

end; end

if __FILE__ == $PROGRAM_NAME
  alias e puts
  base = Colours::Base.new
  base.extend_module_256_colours
  e base.is_this_a_256_colour? 'LightSteelBlue3'
  e base.royalblue('hi there')
  e base.royalblue('hi there')
end # base.rb