#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Colours::Colour
#
# This file includes a standalone Colour class, as part of the Colours
# namespace.
# =========================================================================== #
module Colours

class Colour # === Colours::Colour

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      optional_input = nil
    )
    reset
    set_input(optional_input) if optional_input
  end

  # ========================================================================= #
  # === set_r
  # ========================================================================= #
  def set_r(i = nil)
    @r = i
  end

  # ========================================================================= #
  # === set_g
  # ========================================================================= #
  def set_g(i = nil)
    @g = i
  end

  # ========================================================================= #
  # === set_b
  # ========================================================================= #
  def set_b(i = nil)
    @b = i
  end

  # ========================================================================= #
  # === random_colour?
  # ========================================================================= #
  def random_colour?(
      optional_text = nil
    )
    if optional_text
      write_this_in_random_colour(optional_text)
    else
      ::Colours.random_colour?
    end
  end

  # ========================================================================= #
  # === set_rgb
  # ========================================================================= #
  def set_rgb(r,g,b)
    set_r(r)
    set_g(g)
    set_b(b)
  end

  # ========================================================================= #
  # === set_input
  # ========================================================================= #
  def set_input(i = nil)
    @input = i
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    set_r
    set_g
    set_b
  end

  # ========================================================================= #
  # === r?
  # ========================================================================= #
  def r?
    @r
  end

  # ========================================================================= #
  # === g?
  # ========================================================================= #
  def g?
    @g
  end

  # ========================================================================= #
  # === b?
  # ========================================================================= #
  def b?
    @b
  end

  # ========================================================================= #
  # === output_this_string
  # ========================================================================= #
  def output_this_string(
      i = DEFAULT_TEXT+N,
      r = r?,
      g = g?,
      b = b?
    )
    result = return_this_string(i,r,g,b)
    e result
  end; alias output_this                 output_this_string # === output_this
       alias output                      output_this_string # === output
       alias write_this_in_random_colour output_this_string # === write_this_in_random_colour

  # ========================================================================= #
  # === return_this_string
  # ========================================================================= #
  def return_this_string(
      i = DEFAULT_TEXT+N,
      r = r?,
      g = g?,
      b = b?
    )
    i = DEFAULT_TEXT if i == :default
    i = i.join(' ') if i.is_a? Array
    i = i.to_s.dup
    i = build_this_rgb_string(r, g, b)+i
    return i
  end

  # ========================================================================= #
  # === build_this_rgb_string
  # ========================================================================= #
  def build_this_rgb_string(r, g, b)
    Colours.build_this_rgb_string(r,g,b)
  end

  # ========================================================================= #
  # === random_colour
  #
  # Return a random colour here.
  # ========================================================================= #
  def random_colour(this_string_to_display = 'test')
    return_this_string(
      this_string_to_display, random_value, random_value, random_value
    )
  end; alias return_random_colour random_colour # === return_random_colour

  # ========================================================================= #
  # === seed_rgb_values
  #
  # Use this method to randomly obtain R,G,B values.
  # ========================================================================= #
  def seed_rgb_values
    set_rgb(random_value, random_value, random_value)
  end

  # ========================================================================= #
  # === random_value
  # ========================================================================= #
  def random_value
    rand(255)
  end

end; end