#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/eparse/eparse.rb'
# =========================================================================== #
module Colours

  require 'colours/toplevel_methods/e.rb'
  require 'colours/toplevel_methods/rev.rb'
  require 'colours/constants/constants.rb'

  # ========================================================================= #
  # === Colours::Eparse
  #
  # This is mostly a helper-class. It is not really in use, but it exists
  # so that other classes can query the colour definitions, stored as
  # constants, and methods, respectively.
  # ========================================================================= #
  class Eparse

    # ======================================================================= #
    # === Colours::Eparse::FIRST_COLOUR
    # ======================================================================= #
    FIRST_COLOUR   = COLOUR_GREEN
    
    # ======================================================================= #
    # === Colours::Eparse::SECOND_COLOUR
    # ======================================================================= #
    SECOND_COLOUR = COLOUR_TEAL

    # ======================================================================= #
    # === Colours::Eparse.colour_left
    # ======================================================================= #
    def self.colour_left(i = '')
      return "#{FIRST_COLOUR}#{i}#{REVERT}"
    end

    # ======================================================================= #
    # === Colours::Eparse.colour_right
    # ======================================================================= #
    def self.colour_right(i = '')
      return "#{SECOND_COLOUR}#{i}#{REVERT}"
    end

  end

  # ========================================================================= #
  # === Colours.rparse
  #
  # This method will return a string; the method eparse will output that
  # (colourized) String.
  # ========================================================================= #
  def self.rparse(i = '')
    _ = i.to_s # We require a String.
    split_at = ':' # <- Split at this character.
    # ======================================================================== #
    # If the input does not include a ':' but it does include a '#', then
    # we will use that character instead.
    #
    # However had, as of Jun 2017, I have disabled that check. Now '#' will
    # always overrule. My reasoning now is that '#' is more important than
    # ':', if it is part of the input-string.
    # ======================================================================== #
    split_at = '#' if _.include? '#'
    first_colour  = ::Colours::Eparse::FIRST_COLOUR
    second_colour = ::Colours::Eparse::SECOND_COLOUR
    if i.include? split_at
      splitted = _.split(split_at)
      _ = first_colour+
          splitted.first+
          split_at+
          second_colour+
          splitted[1..-1].join(split_at).dup
      _ << REVERT
    elsif i.include? ' '
      split_at = ' '
      splitted = _.split(/ /)
      index = splitted.find_index {|e| ! e.empty? }
      _ = first_colour+splitted[0..index].join(' ')+split_at+
          second_colour+splitted[index+1..-1].join(' ').dup
      _ << REVERT
    end
    return _
  end

  # ========================================================================= #
  # === Colours.eparse
  #
  # This method primarily exists because we can easily split a string
  # if it has a '#' token. The part that comes after the '#' token is
  # assumed to be a comment or an explanation.
  # ========================================================================= #
  def self.eparse(i = '')
    ::Colours.e(rparse(i)) # Defined in this file here.
  end

  # ========================================================================== #
  # === eparse                                                    (eparse tag)
  #
  # Input to this method could be like this:
  #
  #   eparse 'Foo: bla'
  #   eparse 'Foo: '+bla
  #
  # ========================================================================== #
  def eparse(i = '')
    ::Colours.eparse(i)
  end

end

if __FILE__ == $PROGRAM_NAME
  Colours.eparse('Hello there # how do you do, this is a test')
end