#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Colours::Essentials
# =========================================================================== #
# Note that the primary ANSI colours are:
#
#   black, red, green, yellow, blue, magenta, cyan, white
#
# =========================================================================== #
# require 'colours/essentials/essentials.rb'
# include ::Colours::Essentials
# =========================================================================== #
module Colours

module Essentials # === Colours::Essentials

  require 'colours/constants/constants.rb'

  # ========================================================================= #
  # === Colours::Essentials::NAMESPACE
  # ========================================================================= #
  NAMESPACE = const_get(inspect)

  # ========================================================================= #
  # === Colours::Essentials.yellow
  # ========================================================================= #
  def self.yellow(i = '')
    "#{COLOUR_YELLOW}#{i}#{REVERT}"
  end; self.instance_eval { alias yel   yellow } # === Colours.yel
       self.instance_eval { alias brown yellow } # === Colours.brown

  # ========================================================================= #
  # === Colours::Essentials.light_blue
  # ========================================================================= #
  def self.light_blue(i = '')
    "#{COLOUR_LIGHT_BLUE}#{i}#{REVERT}"
  end; self.instance_eval { alias lightblue light_blue } # === Colours.lightblue
       self.instance_eval { alias bold_blue light_blue } # === Colours.bold_blue

  # ========================================================================= #
  # === light_blue
  # ========================================================================= #
  def light_blue(i = '')
    NAMESPACE.light_blue(i)
  end; alias lightblue light_blue # === lightblue
       alias bold_blue light_blue # === bold_blue

  # ========================================================================= #
  # === Colours::Essentials.magenta
  # ========================================================================= #
  def self.magenta(i = '')
    "#{COLOUR_MAGENTA}#{i}#{REVERT}"
  end; self.instance_eval { alias purple magenta } # === Colours.purple

  # ========================================================================= #
  # === magenta
  # ========================================================================= #
  def magenta(i = '')
    NAMESPACE.magenta(i)
  end; alias purple magenta # === purple

  # ========================================================================= #
  # === Colours::Essentials.light_green
  # ========================================================================= #
  def self.light_green(i = '')
    "#{COLOUR_LIGHT_GREEN}#{i}#{REVERT}"
  end; self.instance_eval { alias lightgreen light_green } # === Colours::Essentials.lightgreen
       self.instance_eval { alias bold_green light_green } # === Colours::Essentials.bold_green

  # ========================================================================= #
  # === bold_green
  # ========================================================================= #
  def bold_green(i = '')
    ::NAMESPACE.bold_green(i)
  end; alias greenb bold_green # === greenb

  # ========================================================================= #
  # === Colours::Essentials.red
  # ========================================================================= #
  def self.red(i = '')
    "#{COLOUR_RED}#{i}#{REVERT}"
  end

  # ========================================================================= #
  # === red
  # ========================================================================= #
  def red(i = '')
    NAMESPACE.red(i)
  end

  # ========================================================================= #
  # === Colours.blue
  # ========================================================================= #
  def self.blue(i = '')
    "#{COLOUR_BLUE}#{i}#{REVERT}"
  end

  # ========================================================================= #
  # === blue
  # ========================================================================= #
  def blue(i = '')
    NAMESPACE.blue(i)
  end

  # ========================================================================= #
  # === light_green
  # ========================================================================= #
  def light_green(i = '')
    NAMESPACE.light_green(i)
  end

  # ========================================================================= #
  # === Colours.light_magenta
  # ========================================================================= #
  def self.light_magenta(i = '')
    "#{COLOUR_LIGHT_MAGENTA}#{i}#{REVERT}"
  end; self.instance_eval { alias lightmagenta light_magenta } # === Colours.lightmagenta
       self.instance_eval { alias light_purple light_magenta } # === Colours.light_purple

  # ========================================================================= #
  # === light_magenta
  # ========================================================================= #
  def light_magenta(i = '')
    NAMESPACE.light_magenta(i)
  end

  # ========================================================================= #
  # === yellow
  # ========================================================================= #
  def yellow(i = '')
    NAMESPACE.yellow(i)
  end; alias brown      yellow # === brown
       alias yel        yellow # === yel
       alias bold_brown yellow # === bold_brown

  # ========================================================================= #
  # === light_red
  # ========================================================================= #
  def light_red(i = '')
    NAMESPACE.light_red(i)
  end

  # ========================================================================= #
  # === Colours.green
  # ========================================================================= #
  def self.green(i = '')
    "#{COLOUR_GREEN}#{i}#{REVERT}"
  end

  # ========================================================================= #
  # === Colours.brown
  #
  # Note that Colours.bold_yellow is an alias to this method.
  # ========================================================================= #
  def self.brown(i = '')
    "#{COLOUR_BROWN}#{i}#{REVERT}"
  end; self.instance_eval { alias bold_yellow brown } # === Colours.bold_yellow
       self.instance_eval { alias yellow      brown } # === Colours.yellow

  # ========================================================================= #
  # === Colours.light_cyan
  # ========================================================================= #
  def self.light_cyan(i = '')
    "#{COLOUR_LIGHT_CYAN}#{i}#{REVERT}"
  end; self.instance_eval { alias lightcyan light_cyan } # === Colours.lightcyan

  # ========================================================================= #
  # === Colours.black
  # ========================================================================= #
  def self.black(i = '')
    "#{COLOUR_BLACK}#{i}#{REVERT}"
  end

  # ========================================================================= #
  # === Colours::Essentials.light_gray
  # ========================================================================= #
  def self.light_gray(i = '')
    "#{COLOUR_LIGHT_GRAY}#{i}#{REVERT}"
  end; self.instance_eval { alias lightgray  light_gray } # === Colours.lightgray
       self.instance_eval { alias light_grey light_gray } # === Colours.light_grey
       self.instance_eval { alias lightgrey  light_gray } # === Colours.lightgrey

  # ========================================================================= #
  # === Colours::Essentials.dark_gray
  # ========================================================================= #
  def self.dark_gray(i = '')
    "#{COLOUR_DARK_GRAY}#{i}#{REVERT}"
  end; self.instance_eval { alias darkgray  dark_gray } # === Colours.darkgray
       self.instance_eval { alias dark_grey dark_gray } # === Colours.dark_grey
       self.instance_eval { alias darkgrey  dark_gray } # === Colours.darkgrey

  # ========================================================================= #
  # === Colours.cyan
  # ========================================================================= #
  def self.cyan(i = '')
    "#{COLOUR_CYAN}#{i}#{REVERT}"
  end; self.instance_eval { alias teal cyan } # === Colours.teal

  # ========================================================================= #
  # === cyan
  # ========================================================================= #
  def cyan(i = '')
    NAMESPACE.cyan(i)
  end

  # ========================================================================= #
  # === Colours.grey
  # ========================================================================= #
  def self.grey(i = '')
    "#{COLOUR_GRAY}#{i}#{REVERT}"
  end; self.instance_eval { alias gray grey } # === Colours.gray

  # ========================================================================= #
  # === grey
  # ========================================================================= #
  def grey(i = '')
    NAMESPACE.grey(i)
  end; alias gray grey # === gray

  # ========================================================================= #
  # === Colours::Essentials.white
  # ========================================================================= #
  def self.white(i = '')
    "#{COLOUR_WHITE}#{i}#{REVERT}"
  end; self.instance_eval { alias bold_white white } # === Colours::Essentials.bold_white

  # ========================================================================= #
  # === bold_white
  # ========================================================================= #
  def bold_white(i = '')
    NAMESPACE.bold_white(i)
  end; alias whiteb bold_white # === whiteb

  # ========================================================================= #
  # === Colours.light_red
  # ========================================================================= #
  def self.light_red(i = '')
    "#{COLOUR_LIGHT_RED}#{i}#{REVERT}"
  end; self.instance_eval { alias lightred light_red } # === Colours.lightred
       self.instance_eval { alias bold_red light_red } # === Colours.bold_red

  # ========================================================================= #
  # === bold_red
  # ========================================================================= #
  def bold_red(i = '')
    NAMESPACE.bold_red(i)
  end; alias lightred bold_red # === lightred
       alias redb     bold_red # === redb

  # ========================================================================= #
  # === bold_yellow
  # ========================================================================= #
  def bold_yellow(i = '')
    NAMESPACE.bold_yellow(i)
  end; alias yelb bold_yellow # === yelb

  # ========================================================================= #
  # === Colours.define_colour_methods_that_can_be_included
  #
  # Dynamic definitions of some methods, such as teal() or red()
  # or white() or bold_white() or lightblue(). These will be
  # defined at include-time, meaning that they will only be
  # available if you do "include Colours".
  #
  # Should come up very early in the definition, as other methods
  # may depend on it.
  #
  # To test this, try:
  #
  #   Colours.bold_yellow('hey joe')
  #
  # ========================================================================= #
  def self.define_colour_methods_that_can_be_included
    all_colours = ::Colours.really_all_colours
    # ======================================================================= #
    # The above refers to an Array that looks like this:
    #
    #   [ :black, :red, :green, :yellow, :blue, :magenta, :teal,
    #     :white, :bright_black, :bright_red, :bright_green,
    #     :bright_yellow, :bright_blue, :bright_magenta,
    #     :bright_cyan, :bright_white]
    #
    # ======================================================================= #
    all_colours.each {|entry|
      unless defined? entry.to_sym # Must prevent re-definitions here.
        define_method(entry.to_sym) {|i = ''| # Allow input.
          i = i.to_s
          _ = ''.dup
          _ << "#{map_colour_to_constant(__method__)}"
          _ << "#{i}#{rev}" unless i.empty?
          return _
        }
      end
    }
  end; define_colour_methods_that_can_be_included # Invoke the above-defined method at once.

end; end

if __FILE__ == $PROGRAM_NAME
  alias e puts
  x = Colours::Essentials
  # ========================================================================= #
  # Bold variants:
  # ========================================================================= #
  test_this_string = '  Hello world!'
  e
  e x.light_magenta(test_this_string)
  e x.bold_blue(test_this_string)
  e x.bold_green(test_this_string)
  e x.bold_red(test_this_string)
  e x.bold_yellow(test_this_string)
  e x.bold_white(test_this_string)
  # ========================================================================= #
  # Non-bold variants:
  # ========================================================================= #
  e
  e 'Next, the non-bold variants:'
  e
  e x.yellow(test_this_string)
  e x.green(test_this_string)
  e x.teal(test_this_string)
  e
  e 'Next, we will create a class with Colours included:'
  e
  e '   class TestClass; include Colours::Essentials; def test; e bold_yellow("hi there"); end; end'
  e
  class TestClass
    include Colours::Essentials
    def test
      e bold_yellow("hi there")
    end
  end
  TestClass.new.test
end # rb basic_colours.rb