#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/html_colours/random_html_colour.rb'
# =========================================================================== #
module Colours

module HtmlColours # === Colours::HtmlColours

  require 'colours/html_colours/hash_html_colours.rb'

  # ========================================================================= #
  # === Colours::HtmlColours.random_colour?
  #
  # Obtain a random sample, aka a random colour, from all the registered
  # html colours.
  # ========================================================================= #
  def self.random_colour?
    available_html_colours?.sample
  end; self.instance_eval { alias random_colour             random_colour? } # === Colours::HtmlColours.random_colour
       self.instance_eval { alias random                    random_colour? } # === Colours::HtmlColours.random
       self.instance_eval { alias sample                    random_colour? } # === Colours::HtmlColours.sample
       self.instance_eval { alias random_html_colour        random_colour? } # === Colours::HtmlColours.random_html_colour
       self.instance_eval { alias return_random_html_colour random_colour? } # === Colours::HtmlColours.return_random_html_colour
       self.instance_eval { alias return_random_colour      random_colour? } # === Colours::HtmlColours.return_random_colour

end

# =========================================================================== #
# === Colours.random_html_colour
#
# This method will simply return a (one) random HTML colour, in long
# format, e. g. "teal" or "slateblue".
#
# If you wish to have it colourized properly, you need to use another
# method.
#
# Usage examples:
#
#   Colours.random_colour? # => "teal"
#   Colours.random_colour? # => "blueviolet"
#
# =========================================================================== # 
def self.random_html_colour
  ::Colours::HtmlColours.random_colour?
end; self.instance_eval { alias random_html_colour?       random_html_colour } # === Colours.random_html_colour?
     self.instance_eval { alias random_colour?            random_html_colour } # === Colours.random_colour?
     self.instance_eval { alias return_random_html_colour random_html_colour } # === Colours.return_random_html_colour
     self.instance_eval { alias return_html_colour?       random_html_colour } # === Colours.return_html_colour?
     self.instance_eval { alias random_colour             random_html_colour } # === Colours.random_colour
     self.instance_eval { alias random                    random_html_colour } # === Colours.random
     self.instance_eval { alias sample                    random_html_colour } # === Colours.sample
     self.instance_eval { alias return_random_html_colour random_html_colour } # === Colours.return_random_html_colour
     self.instance_eval { alias return_random_colour      random_html_colour } # === Colours.return_random_colour
     self.instance_eval { alias random_colour?            random_html_colour } # === Colours.return_random_colour

end

if __FILE__ == $PROGRAM_NAME
  alias e puts
  e 'Random HTML colour: '+Colours.random_html_colour.to_s
  e
  e Colours.random_colour? # => "teal"
  e Colours.random_colour? # => "steelblue"
  e
end