#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/rainbow_colours/constants.rb'
# =========================================================================== #
module Colours

module RainbowColours # === Colours::RainbowColours

  require 'colours/constants/constants.rb'

  # ========================================================================= #
  # === Colours::RainbowColours::DEFAULT_RAINBOW_SPREAD
  # ========================================================================= #
  DEFAULT_RAINBOW_SPREAD = 3.0

  # ========================================================================= #
  # === Colours::RainbowColours::STRIP_ANSI
  #
  # Checking for escape sequences (and a number).
  #
  # Official documentation can be seen here:
  #
  #   https://ruby-doc.org/core/Regexp.html#method-c-new
  #
  # ========================================================================= #
  STRIP_ANSI = Regexp.new('\e\[[\d;]*[m|K]', nil)

end; end