#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/rainbow_colours/print_rainbow_line.rb'
# =========================================================================== #
module Colours

module RainbowColours

  require 'colours/toplevel_methods/e.rb'
  require 'colours/rainbow_colours/constants.rb'
  require 'colours/rainbow_colours/println_plain.rb'

  # ========================================================================= #
  # === Colours::RainbowColours.e
  # ========================================================================= #
  def self.e(i = '')
    ::Colours.e(i)
  end

  # ========================================================================= #
  # === Colours::RainbowColours.print_rainbow_line
  #
  # This line will do the colourizing part, on a per-line basis.
  #
  # The second and third arguments are Hashes.
  #
  # Simple invocation example:
  #
  #   Colours::RainbowColours.print_rainbow_line("Hello world! \n" * 80)
  #
  # ========================================================================= #
  def self.print_rainbow_line(
      string       = 'Hello world!',
      defaults     = {},
      options_hash = {}
    )
    if string.is_a? Array
      string = string.join(' ').strip
    end
    options_hash.merge!(defaults)
    string = string.dup if string.frozen?
    string.chomp! if string.include? N
    # ======================================================================= #
    # Next, get rid of ANSI colours, unless the string is nil.
    # ======================================================================= #
    if !string.nil? and ($stdout.tty? or options_hash[:force])
      string.gsub!(STRIP_ANSI, '')
    end
    # ======================================================================= #
    # Replace all tabs with 2 spaces.
    # ======================================================================= #
    string.gsub!("\t", ' ' * 2) if string.include? "\t"
    if options_hash[:animate]
      # ===================================================================== #
      # Handle animated frames, as specified by the options-hash.
      # ===================================================================== #
      println_ani(string, options_hash)
    else
      RainbowColours.println_plain(string, options_hash)
    end
    e
  end; self.instance_eval { alias print_line          print_rainbow_line } # === Colours::RainbowColours.print_line
       self.instance_eval { alias rainbow_line        print_rainbow_line } # === Colours::RainbowColours.rainbow_line
       self.instance_eval { alias say_in_rainbow_line print_rainbow_line } # === Colours::RainbowColours.say_in_rainbow_line

end; end