#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
module Colours

module RainbowColours

  require 'colours/rainbow_colours/println_plain.rb'

  # ========================================================================= #
  # === Colours::RainbowColours.println_ani
  #
  # This method here will be called if the "animate option" was enabled,
  # that is, set to true.
  # ========================================================================= #
  def self.println_ani(
      str, hash_options = {}
    )
    return if str.empty? # Return early in this case.
    (1 .. hash_options[:duration]).each { |irrelevant_variable|
      print "\e[#{str.length}D"
      hash_options[:os] += hash_options[:spread]
      # ===================================================================== #
      # Next, delegate to println_plain():
      # ===================================================================== #
      println_plain(str, hash_options)
      sleep(1.0/hash_options[:speed])
    }
  end

end; end