#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/rainbow_colours/returnln_plain.rb'
# =========================================================================== #
module Colours

module RainbowColours

  require 'colours/rainbow_colours/rainbow.rb'
  require 'colours/rainbow_colours/set_mode.rb'

  # ========================================================================= #
  # === Colours::RainbowColours.returnln_plain
  #
  # This will return a rainbow-coloured text.
  #
  # The first argument is the text that you wish to display.
  #
  # Invocation example:
  #
  #   puts Colours::RainbowColours.returnln_plain('abc def ' * 1000)
  #
  # ========================================================================= #
  def self.returnln_plain(
      str          = "Hello world! Good morning sunshine.\n",
      defaults     = {},
      options_hash = {
        spread:    DEFAULT_RAINBOW_SPREAD,
        os:        rand(256),
        truecolor: true
      }
    )
    options_hash.merge!(defaults)
    RainbowColours.set_mode(options_hash[:truecolor])
    the_chars = str.chomp.chars # We obtain the individual characters here.
    # ======================================================================= #
    # Iterate over the chars. i, aka the second argument, is the index.
    # ======================================================================= #
    result = ''.dup
    the_chars.each_with_index { |character, index|
      # ===================================================================== #
      # Delegate towards the toplevel-method rainbow().
      # ===================================================================== #
      division_result = (
        options_hash[:os]+index / options_hash[:spread]
      )
      # ===================================================================== #
      # Next, we will obtain some ASCII value such as '#A5D604':
      # ===================================================================== #
      code = RainbowColours.rainbow(options_hash[:freq], division_result)
      # ===================================================================== #
      # Delegate towards Paint[] next. The painted character will be
      # displayed one-per-char.
      # This will yield a String such as "\e[38;2;16;236;130mo\e[0m".
      # ===================================================================== #
      result << Paint[character, *[ (:black if options_hash[:invert]), code ].compact ]
    }
    return result
  end

end; end